/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.communicate;

import cn.com.voltronic.solar.communicate.ICommunicateDevice;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.snmp4j.SNMPConfig;
import cn.com.voltronic.solar.snmp4j.SnmpUtil;
import cn.com.voltronic.solar.snmp4j.SnmpUtilV2;
import cn.com.voltronic.solar.snmp4j.SnmpUtilV3;
import cn.com.voltronic.solar.util.VolUtil;
import java.io.IOException;
import java.util.List;

public class SNMPHandler
implements ICommunicateDevice {
    private SnmpUtil _snmp;
    private String _snmpIP;
    protected AbstractProcessor notifyProcesser;

    public SNMPHandler(String ip, int port, SNMPConfig snmpConfig) {
        try {
            this._snmp = snmpConfig.isV3() ? new SnmpUtilV3(snmpConfig) : new SnmpUtilV2();
            this._snmp.initComm(ip, port);
            this._snmpIP = ip;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public List<Object> getTable(String oid) {
        return this._snmp.getTable(oid);
    }

    public String get(String oid) {
        Object result;
        block3: {
            try {
                result = this._snmp.get(oid);
                if (result != null) break block3;
                return "";
            }
            catch (Exception e) {
                e.printStackTrace();
                return "";
            }
        }
        return result.toString();
    }

    public int getInt(String oid) {
        String str = this.get(oid);
        if (str.isEmpty()) {
            return -1;
        }
        return VolUtil.parseInt(str);
    }

    public double getDouble(String oid) {
        String str = this.get(oid);
        if (str.isEmpty()) {
            return -1.0;
        }
        return VolUtil.parseDouble(str);
    }

    public boolean set(String oid, String value, int dataType) {
        return this._snmp.set(oid, value, dataType);
    }

    @Override
    public String getDeviceName() {
        return this._snmpIP;
    }

    @Override
    public void close() {
        try {
            this._snmp.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setNotifyProcess(AbstractProcessor process) {
        this.notifyProcesser = process;
    }

    public String getSerialNo() {
        String serialno = this.get(".1.3.6.1.4.1.21111.1.2.1.4");
        return serialno;
    }
}

