/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.communicate;

import cn.com.voltronic.solar.communicate.IComUSBHandler;
import cn.com.voltronic.solar.communicate.ICommunicateDevice;
import cn.com.voltronic.solar.debug.Debug;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.util.CRCUtil;
import org.apache.commons.lang.StringUtils;
import usb.IUSBComm;

public class USBHandler
implements IComUSBHandler,
ICommunicateDevice {
    private String usbId;
    private IUSBComm usbComm;
    protected AbstractProcessor notifyProcesser;
    private int _errorcount = 0;

    public USBHandler(IUSBComm usbComm, String usbId) {
        this.usbComm = usbComm;
        this.usbId = usbId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String excuteSimpleCommand(String command) {
        IUSBComm iUSBComm = this.usbComm;
        synchronized (iUSBComm) {
            String returnValue;
            block10: {
                boolean result = true;
                returnValue = "";
                try {
                    try {
                        int time = 0;
                        while ((StringUtils.isEmpty((String)returnValue) || returnValue.startsWith("(NAK")) && time < 3) {
                            returnValue = this.usbComm.sendCommand(this.usbId, String.valueOf(command) + "\r");
                            ++time;
                        }
                        if (StringUtils.isEmpty((String)returnValue)) {
                            result = false;
                        }
                        returnValue = CRCUtil.checkCRC(returnValue) ? returnValue.substring(0, returnValue.length() - 2) : "";
                        Debug.debug(command, returnValue);
                    }
                    catch (Exception ex) {
                        result = false;
                        this.countErrorandNotifyProcesser(result);
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    this.countErrorandNotifyProcesser(result);
                    throw throwable;
                }
                this.countErrorandNotifyProcesser(result);
            }
            return returnValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String excuteCommand(String command, boolean isResponse) {
        IUSBComm iUSBComm = this.usbComm;
        synchronized (iUSBComm) {
            String returnValue;
            block15: {
                boolean result;
                block14: {
                    result = true;
                    returnValue = "";
                    try {
                        try {
                            returnValue = this.usbComm.sendCommand(this.usbId, String.valueOf(command) + "\r");
                            if (isResponse) {
                                int time = 0;
                                while ((StringUtils.isEmpty((String)returnValue) || returnValue.startsWith("(NAK")) && time < 2) {
                                    returnValue = this.usbComm.sendCommand(this.usbId, String.valueOf(command) + "\r");
                                    ++time;
                                }
                                if (StringUtils.isEmpty((String)returnValue)) {
                                    result = false;
                                }
                            }
                            if (CRCUtil.checkCRC(returnValue)) {
                                returnValue = returnValue.substring(0, returnValue.length() - 2);
                                Debug.debug(command, returnValue);
                                break block14;
                            }
                            try {
                                Debug.debug(command, String.valueOf(returnValue) + " -- CRC failure");
                                returnValue = String.valueOf(returnValue) + "00";
                                if (CRCUtil.checkCRC(returnValue)) {
                                    returnValue = returnValue.substring(0, returnValue.length() - 2);
                                    break block14;
                                }
                                returnValue = "";
                            }
                            catch (Exception e) {
                                returnValue = "";
                            }
                        }
                        catch (Exception ex) {
                            result = false;
                            this.countErrorandNotifyProcesser(result);
                            break block15;
                        }
                    }
                    catch (Throwable throwable) {
                        this.countErrorandNotifyProcesser(result);
                        throw throwable;
                    }
                }
                this.countErrorandNotifyProcesser(result);
            }
            return returnValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        IUSBComm iUSBComm = this.usbComm;
        synchronized (iUSBComm) {
            if (this.usbComm != null) {
                try {
                    this.usbComm.closeUSBPort(this.usbId);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public String getDeviceName() {
        return "USB" + this.usbId;
    }

    @Override
    public void setNotifyProcess(AbstractProcessor process) {
        this.notifyProcesser = process;
    }

    private void countErrorandNotifyProcesser(boolean success) {
        this._errorcount = success ? 0 : ++this._errorcount;
        if (this._errorcount >= 3 && this.notifyProcesser != null) {
            System.out.println("---------communication exception---------" + this._errorcount);
            this.notifyProcesser.close();
        }
    }

    @Override
    public int getMpptTrackNumber() {
        int mpptTrackNumber = 2;
        try {
            String result = this.excuteCommand("QPIRI", true);
            if (result != null && !"".equals(result) && !result.equals("QPIRI")) {
                String[] arr = result.split(" ");
                mpptTrackNumber = Integer.parseInt(arr[7]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return mpptTrackNumber;
    }

    @Override
    public String getSerialNo() {
        String serialno = "";
        String serialnoStr = "";
        try {
            int i = 0;
            while (i < 3) {
                serialnoStr = this.excuteCommand("QSID", true);
                if (!(serialnoStr == null || "".equals(serialnoStr) || serialnoStr.equalsIgnoreCase("(NAK") || serialnoStr.equalsIgnoreCase("(ACK") || serialnoStr.equals("QSID"))) {
                    try {
                        String validLen = serialnoStr.substring(1, 3);
                        if (validLen.contains("(")) {
                            --i;
                            continue;
                        }
                        serialno = serialnoStr.substring(3, 3 + Integer.valueOf(validLen));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                ++i;
            }
            if ("" != serialno) {
                return serialno;
            }
            i = 0;
            serialnoStr = "";
            while (i < 3) {
                serialnoStr = this.excuteCommand("QID", true);
                if (!(serialnoStr == null || "".equals(serialnoStr) || serialnoStr.equalsIgnoreCase("(NAK") || serialnoStr.equalsIgnoreCase("(ACK") || serialnoStr.equals("QID"))) {
                    serialno = serialnoStr.substring(1);
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return serialno;
    }

    @Override
    public String getModeType() {
        String machineTypeStr = "";
        try {
            String qpiriStr = this.excuteCommand("QPIRI", true);
            if (!("".equals(qpiriStr) || qpiriStr.equals("(NAK") || qpiriStr.equals("QPIRI"))) {
                String[] ratingInfo = qpiriStr.split(" ");
                machineTypeStr = ratingInfo[8];
                return machineTypeStr;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return machineTypeStr;
    }

    @Override
    public String getDeviceModel() {
        String _deviceModel = "";
        try {
            String qdmStr = this.excuteCommand("QDM", true);
            if (!("".equals(qdmStr) || qdmStr.equals("(NAK") || qdmStr.equals("QDM"))) {
                _deviceModel = qdmStr = qdmStr.substring(1);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return _deviceModel;
    }

    @Override
    public boolean isSupportQCTH() {
        String qchtStr = this.excuteCommand("QCHT", true);
        return qchtStr != null && !"".equals(qchtStr) && !qchtStr.equals("(NAK");
    }

    @Override
    public boolean isSupportQPPS() {
        String ppsStr = this.excuteCommand("QPPS", true);
        return ppsStr != null && !"".equals(ppsStr) && !ppsStr.equals("(NAK");
    }
}

