/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.comusbprocessor;

import cn.com.voltronic.solar.communicate.IComUSBHandler;
import cn.com.voltronic.solar.communicate.ICommunicateDevice;
import cn.com.voltronic.solar.comusbprocessor.P30ComUSBProcessor;
import cn.com.voltronic.solar.data.bean.MachineInfo;
import cn.com.voltronic.solar.data.bean.WorkInfo;
import cn.com.voltronic.solar.protocol.IProtocol;
import cn.com.voltronic.solar.protocol.P30;
import cn.com.voltronic.solar.util.VolUtil;
import cn.com.voltronic.solar.view.ParameterJDialog;
import java.util.Date;

public class P301TO3KWComUSBProcessor
extends P30ComUSBProcessor {
    public P301TO3KWComUSBProcessor(ICommunicateDevice handler, IProtocol protocol) {
        super(handler, protocol);
    }

    @Override
    public boolean pollQuery() {
        boolean result = true;
        IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
        if (handler == null) {
            this.close();
            return false;
        }
        if (this.refreshConfig) {
            this.getProtocol().setDelayChanging(true);
            this.queryMachineInfo();
            this.queryConfigData();
            this.queryCapability();
            this.refreshConfig = false;
        }
        if (this.bfirsttime) {
            this._preparalleltype = this._paralleltype;
            this.bfirsttime = false;
        } else if (this._preparalleltype != this._paralleltype) {
            this.close();
            return false;
        }
        if (!ParameterJDialog.startQueryThread) {
            this.getProtocol().setDelayChanging(false);
        }
        if (!this.getSerialNo().equals(handler.getSerialNo())) {
            this.close();
            return false;
        }
        WorkInfo workInfo = (WorkInfo)this.getBeanBag().getBean("workinfo");
        try {
            String qpigsStr;
            workInfo.setProdid(this._protocol.getProtocolID());
            workInfo.setSerialno(handler.getSerialNo());
            String qmodStrs = handler.excuteCommand("QMOD", true);
            if (!"".equals(qmodStrs) && !qmodStrs.equals("(NAK")) {
                String qmodStr = qmodStrs.substring(1);
                String workMode = "Standby Mode";
                if (qmodStr.equals("P")) {
                    workMode = "Power On Mode";
                } else if (qmodStr.equals("S")) {
                    workMode = "Standby Mode";
                } else if (qmodStr.equals("L")) {
                    workMode = "Line Mode";
                } else if (qmodStr.equals("B")) {
                    workMode = "Battery Mode";
                } else if (qmodStr.equals("F")) {
                    workMode = "Fault Mode";
                } else if (qmodStr.equals("D")) {
                    workMode = "Shutdown Mode";
                }
                workInfo.setWorkMode(workMode);
            }
            if (!"".equals(qpigsStr = handler.excuteCommand("QPIGS", true)) && !qpigsStr.equals("(NAK")) {
                char ch3;
                char ch2;
                String[] qpigsArr = qpigsStr.split(" ");
                double gridVoltageR = VolUtil.parseDouble(qpigsArr[0].substring(1));
                workInfo.setGridVoltageR(gridVoltageR);
                double gridFrequency = VolUtil.parseDouble(qpigsArr[1]);
                workInfo.setGridFrequency(gridFrequency);
                double acOutputVoltageR = VolUtil.parseDouble(qpigsArr[2]);
                workInfo.setAcOutputVoltageR(acOutputVoltageR);
                double acOutputFrequency = VolUtil.parseDouble(qpigsArr[3]);
                workInfo.setAcOutputFrequency(acOutputFrequency);
                double acOutputApparentPower = VolUtil.parseDouble(qpigsArr[4]);
                workInfo.setAcOutputApparentPower(acOutputApparentPower);
                double acOutputActivePower = VolUtil.parseDouble(qpigsArr[5]);
                workInfo.setAcOutputActivePower(acOutputActivePower);
                int outputLoadPercent = VolUtil.parseInt(qpigsArr[6]);
                workInfo.setOutputLoadPercent(outputLoadPercent);
                double pBusVoltage = VolUtil.parseDouble(qpigsArr[7]);
                workInfo.setPBUSVoltage(pBusVoltage);
                double pBatteryVoltage = VolUtil.parseDouble(qpigsArr[8]);
                workInfo.setPBatteryVoltage(pBatteryVoltage);
                double chargingCurrent = VolUtil.parseDouble(qpigsArr[9]);
                workInfo.setChargingCurrent(chargingCurrent);
                int batteryCapacity = VolUtil.parseInt(qpigsArr[10]);
                workInfo.setBatteryCapacity(batteryCapacity);
                double pvInputVoltage1 = VolUtil.parseDouble(qpigsArr[13]);
                workInfo.setPvInputVoltage1(pvInputVoltage1);
                int pvChargingPower = VolUtil.parseInt(qpigsArr[19]);
                workInfo.setPvInputPower1(pvChargingPower);
                double pvInputCurrent = (double)pvChargingPower / (pvInputVoltage1 + 0.01);
                String pvIC = String.format("%.2f", pvInputCurrent);
                workInfo.setPvInputCurrent(VolUtil.parseDouble(pvIC));
                double pvInputCurrentForBatttery = VolUtil.parseDouble(qpigsArr[12]);
                workInfo.setPvInputCurrentForBatttery(pvInputCurrentForBatttery);
                int batDischargeCurrent = VolUtil.parseInt(qpigsArr[15]);
                workInfo.setBatDisCurrent(batDischargeCurrent);
                workInfo.setCurrentTime(new Date());
                String deviceStatus = qpigsArr[16];
                char ch0 = deviceStatus.charAt(0);
                if (ch0 == '1') {
                    workInfo.setCustomerV("1");
                } else {
                    workInfo.setCustomerV("0");
                }
                char ch1 = deviceStatus.charAt(1);
                if (ch1 == '1') {
                    this.getProtocol().setDelayChanging(true);
                    this.queryMachineInfo();
                    this.queryCapability();
                    this.queryConfigData();
                }
                if ((ch2 = deviceStatus.charAt(2)) == '1') {
                    this.queryMachineInfo();
                }
                if ((ch3 = deviceStatus.charAt(3)) == '1') {
                    workInfo.setHasLoad(true);
                } else {
                    workInfo.setHasLoad(false);
                }
                char ch5 = deviceStatus.charAt(5);
                if (ch5 == '1') {
                    workInfo.setChargeOn(true);
                } else {
                    workInfo.setChargeOn(false);
                }
                char ch6 = deviceStatus.charAt(6);
                if (ch6 == '1') {
                    workInfo.setSCCchargeOn(true);
                } else {
                    workInfo.setSCCchargeOn(false);
                }
                char ch7 = deviceStatus.charAt(7);
                if (ch7 == '1') {
                    workInfo.setACchargeOn(true);
                } else {
                    workInfo.setACchargeOn(false);
                }
                if (ch5 == '1' && ch6 == '1' && ch7 == '0') {
                    workInfo.setIsPVCharging(1);
                    workInfo.setIsShowChargingCurrent(1);
                } else if (ch5 == '1' && ch6 == '1' && ch7 == '1') {
                    workInfo.setIsPVCharging(1);
                    workInfo.setIsShowChargingCurrent(1);
                    MachineInfo machineInfo = (MachineInfo)this.getBeanBag().getBean("machineinfo");
                    if (P30.isALFAM(machineInfo)) {
                        workInfo.setIsShowChargingCurrent(0);
                    }
                } else {
                    workInfo.setIsPVCharging(0);
                    workInfo.setIsShowChargingCurrent(0);
                }
                if (workInfo.isChargeOn()) {
                    if (workInfo.isSCCchargeOn() && workInfo.isACchargeOn()) {
                        workInfo.setChargeSource("Solar and Utility");
                    } else if (workInfo.isSCCchargeOn()) {
                        workInfo.setChargeSource("Solar");
                    } else if (workInfo.isACchargeOn()) {
                        workInfo.setChargeSource("Utility");
                    }
                } else {
                    workInfo.setChargeSource("---");
                }
                if (workInfo.isHasLoad()) {
                    if (workInfo.getWorkMode().equals("Line Mode")) {
                        workInfo.setLoadSource("Utility");
                    } else if (workInfo.getWorkMode().equals("Battery Mode")) {
                        workInfo.setLoadSource("Battery");
                    }
                } else {
                    workInfo.setLoadSource("---");
                }
            }
        }
        catch (Exception ex) {
            result = false;
            ex.printStackTrace();
        }
        return result;
    }
}

