/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.comusbprocessor;

import cn.com.voltronic.solar.beanbag.P30BeanBag;
import cn.com.voltronic.solar.communicate.IComUSBHandler;
import cn.com.voltronic.solar.communicate.ICommunicateDevice;
import cn.com.voltronic.solar.comusbprocessor.AbstractComUSBProcessor;
import cn.com.voltronic.solar.comusbprocessor.ParallSubProcessor;
import cn.com.voltronic.solar.constants.Constants;
import cn.com.voltronic.solar.control.P30ComUSBControlModule;
import cn.com.voltronic.solar.data.bean.Capability;
import cn.com.voltronic.solar.data.bean.ConfigData;
import cn.com.voltronic.solar.data.bean.DefaultData;
import cn.com.voltronic.solar.data.bean.MachineInfo;
import cn.com.voltronic.solar.data.bean.ProtocolInfo;
import cn.com.voltronic.solar.data.bean.WorkInfo;
import cn.com.voltronic.solar.exception.EventsHandler;
import cn.com.voltronic.solar.exception.FaultHandler;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.protocol.IProtocol;
import cn.com.voltronic.solar.protocol.P30;
import cn.com.voltronic.solar.system.GlobalProcessors;
import cn.com.voltronic.solar.system.GlobalVariables;
import cn.com.voltronic.solar.util.VolUtil;
import cn.com.voltronic.solar.view.ParameterJDialog;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class P30ComUSBProcessor
extends AbstractComUSBProcessor {
    public static Lock lock = new ReentrantLock();
    public boolean refreshConfig = false;
    public int _preparalleltype = 0;
    public boolean bfirsttime = true;
    Map<String, String> faultMap = new HashMap<String, String>();

    public P30ComUSBProcessor(ICommunicateDevice handler, IProtocol protocol) {
        super(handler, protocol);
    }

    @Override
    protected void initBeanBag() {
        this._beanbag = new P30BeanBag();
    }

    @Override
    protected void initControlModule() {
        this._control = new P30ComUSBControlModule(this.getHandler());
    }

    @Override
    public void initProtocol() {
        ProtocolInfo info = (ProtocolInfo)this.getBeanBag().getBean("protocolinfo");
        info.setProdid(this._protocol.getProtocolID());
        info.setBaseInfo(this._protocol.getBaseInfo());
        info.setProductInfo(this._protocol.getProductInfo());
        info.setRatingInfo(this._protocol.getRatingInfo());
        try {
            info.setSerialno(this._protocol.getSerialNo());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        info.setMoreInfo(this._protocol.getMoreInfo());
    }

    @Override
    public P30BeanBag getBeanBag() {
        return (P30BeanBag)this._beanbag;
    }

    private boolean explainQPGSN(AbstractProcessor processor, IComUSBHandler handler, String[] retArr) {
        try {
            int pvInputPower1;
            WorkInfo workInfo = (WorkInfo)processor.getBeanBag().getBean("workinfo");
            workInfo.setProdid(this._protocol.getProtocolID());
            workInfo.setSerialno(processor.getSerialNo());
            ConfigData configdata = (ConfigData)processor.getBeanBag().getBean("configdata");
            workInfo.setCurrentTime(new Date());
            String workMode = retArr[2].trim();
            workInfo.setWorkMode("Standby Mode");
            if (workMode.equals("P")) {
                workInfo.setWorkMode("Power On Mode");
            } else if (workMode.equals("S")) {
                workInfo.setWorkMode("Standby Mode");
            } else if (workMode.equals("L")) {
                workInfo.setWorkMode("Line Mode");
            } else if (workMode.equals("B")) {
                workInfo.setWorkMode("Battery Mode");
            } else if (workMode.equals("F")) {
                workInfo.setWorkMode("Fault Mode");
            } else if (workMode.equals("D")) {
                workInfo.setWorkMode("Shutdown Mode");
            }
            double gridVoltageR = VolUtil.parseDouble(retArr[4]);
            workInfo.setGridVoltageR(gridVoltageR);
            double gridFrequency = VolUtil.parseDouble(retArr[5]);
            workInfo.setGridFrequency(gridFrequency);
            double acOutputVoltageR = VolUtil.parseDouble(retArr[6]);
            workInfo.setAcOutputVoltageR(acOutputVoltageR);
            double acOutputFrequency = VolUtil.parseDouble(retArr[7]);
            workInfo.setAcOutputFrequency(acOutputFrequency);
            double acOutputApparentPower = VolUtil.parseDouble(retArr[8]);
            workInfo.setAcOutputApparentPower(acOutputApparentPower);
            double acOutputActivePower = VolUtil.parseDouble(retArr[9]);
            workInfo.setAcOutputActivePower(acOutputActivePower);
            int outputLoadPercent = VolUtil.parseInt(retArr[10]);
            workInfo.setOutputLoadPercent(outputLoadPercent);
            double pBatteryVoltage = VolUtil.parseDouble(retArr[11]);
            workInfo.setPBatteryVoltage(pBatteryVoltage);
            double chargingCurrent = VolUtil.parseDouble(retArr[12]);
            workInfo.setChargingCurrent(chargingCurrent);
            int batteryCapacity = VolUtil.parseInt(retArr[13]);
            workInfo.setBatteryCapacity(batteryCapacity);
            double pvInputVoltage1 = VolUtil.parseDouble(retArr[14]);
            workInfo.setPvInputVoltage1(pvInputVoltage1);
            double ttlchargingCurrent = VolUtil.parseDouble(retArr[15]);
            workInfo.setTtlChargingCurrent(ttlchargingCurrent);
            double ttlAcoutputVA = VolUtil.parseDouble(retArr[16]);
            workInfo.setAcTtlOutputApparentPower(ttlAcoutputVA);
            double ttlAcoutputW = VolUtil.parseDouble(retArr[17]);
            workInfo.setAcTtlOutputActivePower(ttlAcoutputW);
            double ttlAcoutputPercent = VolUtil.parseDouble(retArr[18]);
            workInfo.setAcTtlOutputPercent(ttlAcoutputPercent);
            String status = retArr[19];
            if (status.length() >= 8) {
                if (status.charAt(7) == '1') {
                    this.refreshConfig = true;
                }
                if (status.charAt(6) == '1') {
                    workInfo.setHasLoad(true);
                } else {
                    workInfo.setHasLoad(false);
                }
                if (status.charAt(5) == '1') {
                    workInfo.setLineLoss(true);
                    if (!workInfo.getWarnings().contains("2004")) {
                        EventsHandler.handleEvent(workInfo.getProdid(), workInfo.getSerialno(), workInfo.getCurrentTime(), "2004");
                        workInfo.addWarning("2004");
                    }
                } else {
                    workInfo.setLineLoss(false);
                    if (workInfo.getWarnings().contains("2004")) {
                        EventsHandler.handleEvent(workInfo.getProdid(), workInfo.getSerialno(), workInfo.getCurrentTime(), "2016");
                        workInfo.getWarnings().remove("2004");
                    }
                }
                if (status.charAt(1) == '1' || status.charAt(2) == '1') {
                    workInfo.setChargeOn(true);
                } else {
                    workInfo.setChargeOn(false);
                }
                if (status.charAt(1) == '1') {
                    workInfo.setACchargeOn(true);
                } else {
                    workInfo.setACchargeOn(false);
                }
                if (status.charAt(2) == '1') {
                    workInfo.setSCCchargeOn(true);
                } else {
                    workInfo.setSCCchargeOn(false);
                }
                if (workInfo.isChargeOn()) {
                    if (workInfo.isSCCchargeOn() && workInfo.isACchargeOn()) {
                        workInfo.setChargeSource("Solar and Utility");
                    } else if (workInfo.isSCCchargeOn()) {
                        workInfo.setChargeSource("Solar");
                    } else if (workInfo.isACchargeOn()) {
                        workInfo.setChargeSource("Utility");
                    }
                } else {
                    workInfo.setChargeSource("---");
                }
                if (workInfo.isHasLoad()) {
                    if (workInfo.getWorkMode().equals("Line Mode")) {
                        workInfo.setLoadSource("Utility");
                    } else if (workInfo.getWorkMode().equals("Battery Mode")) {
                        workInfo.setLoadSource("Battery");
                    } else if (workInfo.getWorkMode().equals("Bypass Mode")) {
                        workInfo.setLoadSource("Utility");
                    }
                } else {
                    workInfo.setLoadSource("---");
                }
            }
            if (retArr.length > 20) {
                int outputtype = 0;
                try {
                    outputtype = VolUtil.parseInt(retArr[20]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                processor.setOutputMode(outputtype);
                if (processor instanceof ParallSubProcessor) {
                    configdata.setSubOutputMode(processor.getSerialNo(), outputtype);
                } else {
                    configdata.setOutputMode(outputtype);
                }
            }
            if (retArr.length > 23) {
                String chargingSource = retArr[21];
                String chargeSource = "Utility";
                if (chargingSource.equals("0")) {
                    chargeSource = "Utility";
                } else if (chargingSource.equals("1")) {
                    chargeSource = "Solar first";
                } else if (chargingSource.equals("2")) {
                    chargeSource = "Utility and Solar";
                } else if (chargingSource.equals("3")) {
                    chargeSource = "Solar only";
                }
                if (processor instanceof ParallSubProcessor) {
                    configdata.setChargerSource(processor.getSerialNo(), chargeSource);
                } else {
                    configdata.setChargerSource(chargeSource);
                }
                String maxchangestr = retArr[22];
                int maxchargecurrent = VolUtil.parseInt(maxchangestr);
                if (processor instanceof ParallSubProcessor) {
                    configdata.setMaxChargeCurrent(processor.getSerialNo(), maxchargecurrent);
                } else {
                    configdata.setMaxChargeCurrent(maxchargecurrent);
                }
                String maxmaxchargestr = retArr[23];
                int maxmaxcharge = VolUtil.parseInt(maxmaxchargestr);
                if (processor instanceof ParallSubProcessor) {
                    configdata.setMinMaxChargeCurrent(processor.getSerialNo(), 10.0);
                    configdata.setMaxMaxChargeCurrent(processor.getSerialNo(), maxmaxcharge);
                } else {
                    configdata.setMaxMaxChargeCurrent(maxmaxcharge);
                    configdata.setMinMaxChargeCurrent(10.0);
                }
            }
            if (retArr.length > 24) {
                int maxacchargecurrent = VolUtil.parseInt(retArr[24]);
                if (processor instanceof ParallSubProcessor) {
                    configdata.setMaxacchargingcurrent(processor.getSerialNo(), maxacchargecurrent);
                } else {
                    configdata.setMaxacchargingcurrent(maxacchargecurrent);
                }
            }
            if (retArr.length > 25) {
                int pvInputCurrent = VolUtil.parseInt(retArr[25]);
                workInfo.setPvInputCurrent(pvInputCurrent);
            }
            if (retArr.length > 26) {
                int batDischargeCurrent = VolUtil.parseInt(retArr[26]);
                workInfo.setBatDisCurrent(batDischargeCurrent);
            }
            String faultcode = retArr[3];
            FaultHandler.doFaultEvent(workInfo, faultcode);
            String prodid = processor.getProtocol().getProtocolID();
            if (prodid.equals("P30PLUSDUO") || prodid.equals("P30PLUSTRI")) {
                int parall_i = processor.getParallKey();
                String qp2gsn = handler.excuteCommand("QP2GS" + parall_i, true);
                if (this.notEmpty(qp2gsn)) {
                    String[] qp2gsnArr = qp2gsn.split(" ");
                    pvInputPower1 = VolUtil.parseInt(qp2gsnArr[1]);
                    workInfo.setPvInputPower1(pvInputPower1);
                    double pvInputVoltage2 = VolUtil.parseDouble(qp2gsnArr[2]);
                    workInfo.setPvInputVoltage2(pvInputVoltage2);
                    int pvInputCurrent2 = VolUtil.parseInt(qp2gsnArr[3]);
                    workInfo.setPvInputCurrent2(pvInputCurrent2);
                    int pvInputPower2 = VolUtil.parseInt(qp2gsnArr[4]);
                    workInfo.setPvInputPower2(pvInputPower2);
                    double pvInputVoltage3 = VolUtil.parseDouble(qp2gsnArr[5]);
                    workInfo.setPvInputVoltage3(pvInputVoltage3);
                    int pvInputCurrent3 = VolUtil.parseInt(qp2gsnArr[6]);
                    workInfo.setPvInputCurrent3(pvInputCurrent3);
                    int pvInputPower3 = VolUtil.parseInt(qp2gsnArr[7]);
                    workInfo.setPvInputPower3(pvInputPower3);
                    String sccStatus = qp2gsnArr[8];
                    workInfo.setSCCchargeOn2(sccStatus.charAt(1) == '1');
                }
            } else {
                double pvPower = workInfo.getPBatteryVoltage() * workInfo.getPvInputCurrent();
                Double dVal = new Double(pvPower);
                pvInputPower1 = dVal.intValue();
                workInfo.setPvInputPower1(pvInputPower1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public synchronized boolean pollQueryParallel() {
        boolean result = true;
        boolean bParentLoss = true;
        int parall_i = 0;
        ArrayList<String> curList = new ArrayList<String>();
        ArrayList<String> delList = new ArrayList<String>();
        IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
        if (handler == null) {
            return false;
        }
        try {
            parall_i = 0;
            while (parall_i < this._parallelnum) {
                String ret = handler.excuteCommand("QPGS" + parall_i, true);
                String[] spiltArray = ret.split(" ");
                int outputtype = 0;
                if (spiltArray.length > 20) {
                    outputtype = VolUtil.parseInt(spiltArray[20]);
                }
                if (spiltArray[0].length() >= 2 && spiltArray[0].charAt(1) == '1' && outputtype != 0) {
                    String oldKey;
                    String serial = spiltArray[1].trim();
                    curList.add(serial);
                    ParallSubProcessor processor = null;
                    if (this.subMap.containsKey(serial)) {
                        processor = (ParallSubProcessor)this.subMap.get(serial);
                        processor.setParallKey(parall_i);
                        this.explainQPGSN(processor, handler, spiltArray);
                        oldKey = processor.processorKey();
                        if (!processor.reGenProcesorKey().equalsIgnoreCase(oldKey)) {
                            GlobalProcessors.removeProcessor(oldKey);
                            GlobalProcessors.addProcessor(processor.processorKey(), processor);
                        }
                    } else if (serial.equalsIgnoreCase(this.getSerialNo())) {
                        this.setParallKey(parall_i);
                        this.explainQPGSN(this, handler, spiltArray);
                        oldKey = this.processorKey();
                        if (!this.reGenProcesorKey().equalsIgnoreCase(oldKey)) {
                            GlobalProcessors.removeProcessor(oldKey);
                            GlobalProcessors.addProcessor(this.processorKey(), this);
                        }
                        bParentLoss = false;
                    } else {
                        processor = new ParallSubProcessor(this, new P30BeanBag());
                        processor.setDeviceName(this.getDeviceName());
                        processor.setSerialNo(serial);
                        processor.setParallKey(parall_i);
                        this.explainQPGSN(processor, handler, spiltArray);
                        this.subMap.put(serial, processor);
                        processor.saveDevice();
                        GlobalProcessors.addProcessor(processor.processorKey(), processor);
                    }
                }
                ++parall_i;
            }
            for (Map.Entry entry : this.subMap.entrySet()) {
                if (curList.indexOf(entry.getKey()) >= 0) continue;
                ((ParallSubProcessor)entry.getValue()).close();
                delList.add((String)entry.getKey());
            }
            for (String key : delList) {
                this.subMap.remove(key);
            }
            if (bParentLoss) {
                this.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            result = false;
        }
        return result;
    }

    @Override
    public boolean pollQueryStatus() {
        boolean result = true;
        IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
        if (handler == null) {
            return false;
        }
        if (this._paralleltype != 2) {
            WorkInfo workinfo = (WorkInfo)this.getBeanBag().getBean("workinfo");
            try {
                workinfo.setProdid(this._protocol.getProtocolID());
                workinfo.setSerialno(this.getProtocol().getSerialNo());
                workinfo.setCurrentTime(new Date());
                String qpiws = handler.excuteCommand("QPIWS", true);
                if (!"".equals(qpiws) && !qpiws.equals("(NAK") && this.isQPIWS(qpiws)) {
                    String qpiwsStr = qpiws.substring(1);
                    if (this._protocol.isVMII()) {
                        if (qpiwsStr.charAt(0) == '1') {
                            workinfo.setPvLoss(true);
                        } else {
                            workinfo.setPvLoss(false);
                        }
                    }
                    this.hasFault = qpiwsStr.charAt(1) == '1';
                    if (qpiwsStr.charAt(2) == '1') {
                        if (!workinfo.getWarnings().contains("2001")) {
                            EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2001");
                            workinfo.addWarning("2001");
                        }
                    } else if (workinfo.getWarnings().contains("2001")) {
                        workinfo.getWarnings().remove("2001");
                    }
                    if (qpiwsStr.charAt(3) == '1') {
                        if (!workinfo.getWarnings().contains("2002")) {
                            EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2002");
                            workinfo.addWarning("2002");
                        }
                    } else if (workinfo.getWarnings().contains("2002")) {
                        workinfo.getWarnings().remove("2002");
                    }
                    if (qpiwsStr.charAt(4) == '1') {
                        if (!workinfo.getWarnings().contains("2003")) {
                            EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2003");
                            workinfo.addWarning("2003");
                        }
                    } else if (workinfo.getWarnings().contains("2003")) {
                        workinfo.getWarnings().remove("2003");
                    }
                    if (qpiwsStr.charAt(5) == '1') {
                        workinfo.setLineLoss(true);
                        if (!workinfo.getWarnings().contains("2004")) {
                            EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2004");
                            workinfo.addWarning("2004");
                        }
                    } else {
                        workinfo.setLineLoss(false);
                        if (workinfo.getWarnings().contains("2004")) {
                            EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2016");
                            workinfo.getWarnings().remove("2004");
                        }
                    }
                    if (qpiwsStr.charAt(6) == '1') {
                        if (!workinfo.getWarnings().contains("2005")) {
                            EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2005");
                            workinfo.addWarning("2005");
                        }
                    } else if (workinfo.getWarnings().contains("2005")) {
                        workinfo.getWarnings().remove("2005");
                    }
                    if (qpiwsStr.charAt(7) == '1') {
                        if (!workinfo.getWarnings().contains("2006")) {
                            EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2006");
                            workinfo.addWarning("2006");
                        }
                    } else if (workinfo.getWarnings().contains("2006")) {
                        workinfo.getWarnings().remove("2006");
                    }
                    if (qpiwsStr.charAt(8) == '1') {
                        if (!workinfo.getWarnings().contains("2007")) {
                            EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2007");
                            workinfo.addWarning("2007");
                        }
                    } else if (workinfo.getWarnings().contains("2007")) {
                        workinfo.getWarnings().remove("2007");
                    }
                    if (qpiwsStr.charAt(9) == '1') {
                        if (this.hasFault) {
                            if (!workinfo.getWarnings().contains("1011")) {
                                EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "1011");
                                FaultHandler.recordEvent(workinfo, "1011");
                                workinfo.addWarning("1011");
                            }
                        } else if (!workinfo.getWarnings().contains("2008")) {
                            EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2008");
                            workinfo.addWarning("2008");
                        }
                    } else {
                        if (workinfo.getWarnings().contains("2008")) {
                            workinfo.getWarnings().remove("2008");
                        }
                        if (workinfo.getWarnings().contains("1011")) {
                            workinfo.getWarnings().remove("1011");
                        }
                    }
                    if (qpiwsStr.charAt(10) == '1') {
                        if (this.hasFault) {
                            if (!workinfo.getWarnings().contains("1001")) {
                                EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "1001");
                                FaultHandler.recordEvent(workinfo, "1001");
                                workinfo.addWarning("1001");
                            }
                        } else if (!workinfo.getWarnings().contains("2009")) {
                            EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2009");
                            workinfo.addWarning("2009");
                        }
                    } else {
                        if (workinfo.getWarnings().contains("2009")) {
                            workinfo.getWarnings().remove("2009");
                        }
                        if (workinfo.getWarnings().contains("1001")) {
                            workinfo.getWarnings().remove("1001");
                        }
                    }
                    if (qpiwsStr.charAt(11) == '1') {
                        if (this.hasFault) {
                            if (!workinfo.getWarnings().contains("1002")) {
                                EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "1002");
                                FaultHandler.recordEvent(workinfo, "1002");
                                workinfo.addWarning("1002");
                            }
                        } else if (!workinfo.getWarnings().contains("2010")) {
                            EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2010");
                            workinfo.addWarning("2010");
                        }
                    } else {
                        if (workinfo.getWarnings().contains("2010")) {
                            workinfo.getWarnings().remove("2010");
                        }
                        if (workinfo.getWarnings().contains("1002")) {
                            workinfo.getWarnings().remove("1002");
                        }
                    }
                    if (qpiwsStr.charAt(12) == '1') {
                        if (!workinfo.getWarnings().contains("2011")) {
                            EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2011");
                            workinfo.addWarning("2011");
                        }
                    } else if (workinfo.getWarnings().contains("2011")) {
                        workinfo.getWarnings().remove("2011");
                    }
                    if (qpiwsStr.charAt(13) == '1') {
                        if (!workinfo.getWarnings().contains("2012")) {
                            EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2012");
                            workinfo.addWarning("2012");
                        }
                    } else if (workinfo.getWarnings().contains("2012")) {
                        workinfo.getWarnings().remove("2012");
                    }
                    if (qpiwsStr.charAt(14) == '1') {
                        if (!workinfo.getWarnings().contains("2013")) {
                            EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2013");
                            workinfo.addWarning("2013");
                        }
                    } else if (workinfo.getWarnings().contains("2013")) {
                        workinfo.removeWarning("2013");
                    }
                    if (qpiwsStr.charAt(15) == '1') {
                        if (!workinfo.getWarnings().contains("2014")) {
                            EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2014");
                            workinfo.addWarning("2014");
                        }
                    } else if (workinfo.getWarnings().contains("2014")) {
                        workinfo.removeWarning("2014");
                    }
                    if (qpiwsStr.charAt(16) == '1') {
                        if (this.hasFault) {
                            if (!workinfo.getWarnings().contains("1003")) {
                                EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "1003");
                                FaultHandler.recordEvent(workinfo, "1003");
                                workinfo.addWarning("1003");
                            }
                        } else if (!workinfo.getWarnings().contains("2015")) {
                            EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2015");
                            workinfo.addWarning("2015");
                        }
                    } else {
                        if (workinfo.getWarnings().contains("2015")) {
                            workinfo.removeWarning("2015");
                        }
                        if (workinfo.getWarnings().contains("1003")) {
                            workinfo.removeWarning("1003");
                        }
                    }
                    if (qpiwsStr.charAt(18) == '1') {
                        if (!workinfo.getWarnings().contains("1004")) {
                            EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "1004");
                            workinfo.addWarning("1004");
                        }
                    } else if (workinfo.getWarnings().contains("1004")) {
                        workinfo.removeWarning("1004");
                    }
                    if (qpiwsStr.charAt(19) == '1') {
                        if (!workinfo.getWarnings().contains("1005")) {
                            EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "1005");
                            workinfo.addWarning("1005");
                        }
                    } else if (workinfo.getWarnings().contains("1005")) {
                        workinfo.removeWarning("1005");
                    }
                    if (qpiwsStr.charAt(20) == '1') {
                        if (!workinfo.getWarnings().contains("1006")) {
                            EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "1006");
                            workinfo.addWarning("1006");
                        }
                    } else if (workinfo.getWarnings().contains("1006")) {
                        workinfo.removeWarning("1006");
                    }
                    if (qpiwsStr.charAt(21) == '1') {
                        if (!workinfo.getWarnings().contains("1007")) {
                            EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "1007");
                            workinfo.addWarning("1007");
                        }
                    } else if (workinfo.getWarnings().contains("1007")) {
                        workinfo.removeWarning("1007");
                    }
                    if (qpiwsStr.charAt(22) == '1') {
                        if (this._protocol.isVMII()) {
                            workinfo.setNoBattery(true);
                            if (!workinfo.getWarnings().contains("2017")) {
                                EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2017");
                                workinfo.addWarning("2017");
                            }
                        } else if (!workinfo.getWarnings().contains("1008")) {
                            EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "1008");
                            workinfo.addWarning("1008");
                        }
                    } else if (this._protocol.isVMII()) {
                        workinfo.setNoBattery(false);
                        if (workinfo.getWarnings().contains("2017")) {
                            workinfo.removeWarning("2017");
                        }
                    } else if (workinfo.getWarnings().contains("1008")) {
                        workinfo.removeWarning("1008");
                    }
                    if (qpiwsStr.charAt(23) == '1') {
                        if (!workinfo.getWarnings().contains("1009")) {
                            EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "1009");
                            workinfo.addWarning("1009");
                        }
                    } else if (workinfo.getWarnings().contains("1009")) {
                        workinfo.removeWarning("1009");
                    }
                    if (qpiwsStr.charAt(24) == '1') {
                        if (!workinfo.getWarnings().contains("1010")) {
                            EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "1010");
                            workinfo.addWarning("1010");
                        }
                    } else if (workinfo.getWarnings().contains("1010")) {
                        workinfo.removeWarning("1010");
                    }
                    if (qpiwsStr.charAt(25) == '1') {
                        if (this._protocol.getAxpert().equals("022")) {
                            if (!workinfo.getWarnings().contains("2024")) {
                                EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2024");
                                workinfo.addWarning("2024");
                            }
                        } else if (!workinfo.getWarnings().contains("2019")) {
                            EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2019");
                            workinfo.addWarning("2019");
                        }
                    } else if (this._protocol.getAxpert().equals("022")) {
                        if (workinfo.getWarnings().contains("2024")) {
                            workinfo.removeWarning("2024");
                        }
                    } else if (workinfo.getWarnings().contains("2019")) {
                        workinfo.removeWarning("2019");
                    }
                    if (qpiwsStr.charAt(26) == '1') {
                        if (this._protocol.getAxpert().equals("022")) {
                            if (!workinfo.getWarnings().contains("2019")) {
                                EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2019");
                                workinfo.addWarning("2019");
                            }
                        } else if (!workinfo.getWarnings().contains("2020")) {
                            EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2020");
                            workinfo.addWarning("2020");
                        }
                    } else if (this._protocol.getAxpert().equals("022")) {
                        if (workinfo.getWarnings().contains("2019")) {
                            workinfo.removeWarning("2019");
                        }
                    } else if (workinfo.getWarnings().contains("2020")) {
                        workinfo.removeWarning("2020");
                    }
                    if (qpiwsStr.charAt(27) == '1') {
                        if (this._protocol.getAxpert().equals("022") && !workinfo.getWarnings().contains("2021")) {
                            EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2021");
                            workinfo.addWarning("2021");
                        }
                    } else if (this._protocol.getAxpert().equals("022") && workinfo.getWarnings().contains("2021")) {
                        workinfo.removeWarning("2021");
                    }
                    if (qpiwsStr.charAt(28) == '1') {
                        if (this._protocol.getAxpert().equals("022") && !workinfo.getWarnings().contains("2022")) {
                            EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2022");
                            workinfo.addWarning("2022");
                        }
                    } else if (this._protocol.getAxpert().equals("022") && workinfo.getWarnings().contains("2022")) {
                        workinfo.removeWarning("2022");
                    }
                    if (qpiwsStr.charAt(29) == '1') {
                        if (this._protocol.getAxpert().equals("022") && !workinfo.getWarnings().contains("2023")) {
                            EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2023");
                            workinfo.addWarning("2023");
                        }
                    } else if (this._protocol.getAxpert().equals("022") && workinfo.getWarnings().contains("2023")) {
                        workinfo.removeWarning("2023");
                    }
                    if (qpiwsStr.charAt(30) == '1') {
                        if (this._protocol.getAxpert().equals("022")) {
                            if (!workinfo.getWarnings().contains("2020")) {
                                EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2020");
                                workinfo.addWarning("2020");
                            }
                        } else if ((this._protocol.getAxpert().equals("023") || this._protocol.getAxpert().equals("024")) && !workinfo.getWarnings().contains("1087")) {
                            EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "1087");
                            workinfo.addWarning("1087");
                        }
                    } else if (this._protocol.getAxpert().equals("022")) {
                        if (workinfo.getWarnings().contains("2020")) {
                            workinfo.removeWarning("2020");
                        }
                    } else if ((this._protocol.getAxpert().equals("023") || this._protocol.getAxpert().equals("024")) && workinfo.getWarnings().contains("1087")) {
                        workinfo.removeWarning("1087");
                    }
                    try {
                        if (qpiwsStr.length() >= 33) {
                            qpiwsStr.charAt(32);
                            qpiwsStr.charAt(33);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (qpiwsStr.charAt(15) == '1') {
                        workinfo.setOverLoad(true);
                    } else {
                        workinfo.setOverLoad(false);
                    }
                }
                this.reconnectTimes = 0;
            }
            catch (Exception e) {
                result = false;
                e.printStackTrace();
                workinfo.clear();
                ++this.reconnectTimes;
            }
        }
        return result;
    }

    @Override
    public boolean pollQuery() {
        boolean result = true;
        IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
        if (handler == null) {
            this.close();
            return false;
        }
        if (this.refreshConfig) {
            this.getProtocol().setDelayChanging(true);
            this.queryMachineInfo();
            this.queryConfigData();
            this.queryCapability();
            this.refreshConfig = false;
        }
        if (this.bfirsttime) {
            this._preparalleltype = this._paralleltype;
            this.bfirsttime = false;
        } else if (this._preparalleltype != this._paralleltype) {
            this.close();
            return false;
        }
        if (!ParameterJDialog.startQueryThread) {
            this.getProtocol().setDelayChanging(false);
        }
        if (!this.getSerialNo().equals(handler.getSerialNo())) {
            this.close();
            return false;
        }
        if (this._paralleltype != 0) {
            return this.pollQueryParallel();
        }
        WorkInfo workInfo = (WorkInfo)this.getBeanBag().getBean("workinfo");
        try {
            String ret;
            String qpigsStr;
            workInfo.setProdid(this._protocol.getProtocolID());
            workInfo.setSerialno(handler.getSerialNo());
            String qmodStrs = handler.excuteCommand("QMOD", true);
            if (!"".equals(qmodStrs) && !qmodStrs.equals("(NAK")) {
                String qmodStr = qmodStrs.substring(1);
                String workMode = "Standby Mode";
                if (qmodStr.equals("P")) {
                    workMode = "Power On Mode";
                } else if (qmodStr.equals("S")) {
                    workMode = "Standby Mode";
                } else if (qmodStr.equals("L")) {
                    workMode = "Line Mode";
                } else if (qmodStr.equals("B")) {
                    workMode = "Battery Mode";
                } else if (qmodStr.equals("Y")) {
                    workMode = "Bypass Mode";
                } else if (qmodStr.equals("E")) {
                    workMode = "ECO Mode";
                } else if (qmodStr.equals("F")) {
                    workMode = "Fault Mode";
                } else if (qmodStr.equals("D")) {
                    workMode = "Shutdown Mode";
                }
                workInfo.setWorkMode(workMode);
            }
            if (!"".equals(qpigsStr = handler.excuteCommand("QPIGS", true)) && !qpigsStr.equals("(NAK")) {
                char ch3;
                char ch2;
                String[] qpigsArr = qpigsStr.split(" ");
                double gridVoltageR = VolUtil.parseDouble(qpigsArr[0].substring(1));
                workInfo.setGridVoltageR(gridVoltageR);
                double gridFrequency = VolUtil.parseDouble(qpigsArr[1]);
                workInfo.setGridFrequency(gridFrequency);
                double acOutputVoltageR = VolUtil.parseDouble(qpigsArr[2]);
                workInfo.setAcOutputVoltageR(acOutputVoltageR);
                double acOutputFrequency = VolUtil.parseDouble(qpigsArr[3]);
                workInfo.setAcOutputFrequency(acOutputFrequency);
                double acOutputApparentPower = VolUtil.parseDouble(qpigsArr[4]);
                workInfo.setAcOutputApparentPower(acOutputApparentPower);
                double acOutputActivePower = VolUtil.parseDouble(qpigsArr[5]);
                workInfo.setAcOutputActivePower(acOutputActivePower);
                int outputLoadPercent = VolUtil.parseInt(qpigsArr[6]);
                workInfo.setOutputLoadPercent(outputLoadPercent);
                double pBusVoltage = VolUtil.parseDouble(qpigsArr[7]);
                workInfo.setPBUSVoltage(pBusVoltage);
                double pBatteryVoltage = VolUtil.parseDouble(qpigsArr[8]);
                workInfo.setPBatteryVoltage(pBatteryVoltage);
                double chargingCurrent = VolUtil.parseDouble(qpigsArr[9]);
                workInfo.setChargingCurrent(chargingCurrent);
                int batteryCapacity = VolUtil.parseInt(qpigsArr[10]);
                workInfo.setBatteryCapacity(batteryCapacity);
                double pvInputVoltage1 = VolUtil.parseDouble(qpigsArr[13]);
                workInfo.setPvInputVoltage1(pvInputVoltage1);
                int pvChargingPower = VolUtil.parseInt(qpigsArr[19]);
                double pvInputCurrent = (double)pvChargingPower / (pvInputVoltage1 + 0.01);
                workInfo.setPvInputCurrent(pvInputCurrent);
                if (this.getProtocol().getAxpert().equals("024") || this.getProtocol().getAxpert().equals("023")) {
                    workInfo.setPvInputPower1((int)Math.round(pvInputVoltage1 * pvInputCurrent));
                }
                int batDischargeCurrent = VolUtil.parseInt(qpigsArr[15]);
                workInfo.setBatDisCurrent(batDischargeCurrent);
                workInfo.setCurrentTime(new Date());
                String deviceStatus = qpigsArr[16];
                char ch0 = deviceStatus.charAt(0);
                if (ch0 == '1') {
                    workInfo.setCustomerV("1");
                } else {
                    workInfo.setCustomerV("0");
                }
                char ch1 = deviceStatus.charAt(1);
                if (ch1 == '1') {
                    this.getProtocol().setDelayChanging(true);
                    this.queryMachineInfo();
                    this.queryCapability();
                    this.queryConfigData();
                }
                if ((ch2 = deviceStatus.charAt(2)) == '1') {
                    this.queryMachineInfo();
                }
                if ((ch3 = deviceStatus.charAt(3)) == '1') {
                    workInfo.setHasLoad(true);
                } else {
                    workInfo.setHasLoad(false);
                }
                char ch5 = deviceStatus.charAt(5);
                if (this._protocol.getAxpert().equals("022")) {
                    workInfo.setSCCchargeOn3(deviceStatus.charAt(5) == '1');
                }
                if (ch5 == '1') {
                    workInfo.setChargeOn(true);
                } else {
                    workInfo.setChargeOn(false);
                }
                char ch6 = deviceStatus.charAt(6);
                if (ch6 == '1') {
                    workInfo.setSCCchargeOn(true);
                } else {
                    workInfo.setSCCchargeOn(false);
                }
                char ch7 = deviceStatus.charAt(7);
                if (ch7 == '1') {
                    workInfo.setACchargeOn(true);
                } else {
                    workInfo.setACchargeOn(false);
                }
                MachineInfo machineInfo = (MachineInfo)this.getBeanBag().getBean("machineinfo");
                if (machineInfo != null) {
                    if (P30.is4to5k(machineInfo.getAcOutputRatingApparentPower())) {
                        workInfo.setIsPVCharging(1);
                    } else if (P30.is1to3k(machineInfo.getAcOutputRatingApparentPower())) {
                        if (ch5 == '1' && ch6 == '1' && ch7 == '0') {
                            workInfo.setIsPVCharging(1);
                        } else if (ch5 == '1' && ch6 == '1' && ch7 == '1') {
                            workInfo.setIsPVCharging(1);
                        } else {
                            workInfo.setIsPVCharging(0);
                        }
                    }
                }
                if (workInfo.isChargeOn()) {
                    if (workInfo.isSCCchargeOn() && workInfo.isACchargeOn()) {
                        workInfo.setChargeSource("Solar and Utility");
                    } else if (workInfo.isSCCchargeOn()) {
                        workInfo.setChargeSource("Solar");
                    } else if (workInfo.isACchargeOn()) {
                        workInfo.setChargeSource("Utility");
                    }
                } else {
                    workInfo.setChargeSource("---");
                }
                if (workInfo.isHasLoad()) {
                    if (workInfo.getWorkMode().equals("Line Mode")) {
                        workInfo.setLoadSource("Utility");
                    } else if (workInfo.getWorkMode().equals("Battery Mode")) {
                        workInfo.setLoadSource("Battery");
                    } else if (workInfo.getWorkMode().equals("Bypass Mode")) {
                        workInfo.setLoadSource("Utility");
                    }
                } else {
                    workInfo.setLoadSource("---");
                }
            }
            if (!"".equals(ret = handler.excuteCommand("QPGS0", true)) && !ret.equals("(NAK")) {
                boolean isExsit;
                String[] item = ret.split(" ");
                boolean bl = isExsit = item[0].charAt(1) == '1';
                if (isExsit) {
                    this.explainQPGSN0(this, item);
                }
            }
        }
        catch (Exception ex) {
            result = false;
            ex.printStackTrace();
        }
        return result;
    }

    public void explainQPGSN0(AbstractProcessor processor, String[] retArr) {
        try {
            WorkInfo workInfo = (WorkInfo)processor.getBeanBag().getBean("workfault");
            workInfo.setProdid(this._protocol.getProtocolID());
            workInfo.setSerialno(processor.getSerialNo());
            String workMode = retArr[2].trim();
            workInfo.setWorkMode("Standby Mode");
            if (workMode.equals("P")) {
                workInfo.setWorkMode("Power On Mode");
            } else if (workMode.equals("S")) {
                workInfo.setWorkMode("Standby Mode");
            } else if (workMode.equals("L")) {
                workInfo.setWorkMode("Line Mode");
            } else if (workMode.equals("B")) {
                workInfo.setWorkMode("Battery Mode");
            } else if (workMode.equals("F")) {
                workInfo.setWorkMode("Fault Mode");
            } else if (workMode.equals("D")) {
                workInfo.setWorkMode("Shutdown Mode");
            }
            double gridVoltageR = VolUtil.parseDouble(retArr[4]);
            workInfo.setGridVoltageR(gridVoltageR);
            double gridFrequency = VolUtil.parseDouble(retArr[5]);
            workInfo.setGridFrequency(gridFrequency);
            double acOutputVoltageR = VolUtil.parseDouble(retArr[6]);
            workInfo.setAcOutputVoltageR(acOutputVoltageR);
            double acOutputFrequency = VolUtil.parseDouble(retArr[7]);
            workInfo.setAcOutputFrequency(acOutputFrequency);
            double acOutputApparentPower = VolUtil.parseDouble(retArr[8]);
            workInfo.setAcOutputApparentPower(acOutputApparentPower);
            double acOutputActivePower = VolUtil.parseDouble(retArr[9]);
            workInfo.setAcOutputActivePower(acOutputActivePower);
            int outputLoadPercent = VolUtil.parseInt(retArr[10]);
            workInfo.setOutputLoadPercent(outputLoadPercent);
            double pBatteryVoltage = VolUtil.parseDouble(retArr[11]);
            workInfo.setPBatteryVoltage(pBatteryVoltage);
            double chargingCurrent = VolUtil.parseDouble(retArr[12]);
            workInfo.setChargingCurrent(chargingCurrent);
            int batteryCapacity = VolUtil.parseInt(retArr[13]);
            workInfo.setBatteryCapacity(batteryCapacity);
            double pvInputVoltage1 = VolUtil.parseDouble(retArr[14]);
            workInfo.setPvInputVoltage1(pvInputVoltage1);
            double ttlchargingCurrent = VolUtil.parseDouble(retArr[15]);
            workInfo.setTtlChargingCurrent(ttlchargingCurrent);
            double ttlAcoutputVA = VolUtil.parseDouble(retArr[16]);
            workInfo.setAcTtlOutputApparentPower(ttlAcoutputVA);
            double ttlAcoutputW = VolUtil.parseDouble(retArr[17]);
            workInfo.setAcTtlOutputActivePower(ttlAcoutputW);
            double ttlAcoutputPercent = VolUtil.parseDouble(retArr[18]);
            workInfo.setAcTtlOutputPercent(ttlAcoutputPercent);
            workInfo.setCurrentTime(new Date());
            if (retArr.length > 25) {
                int pvInputCurrent = VolUtil.parseInt(retArr[25]);
                workInfo.setPvInputCurrent(pvInputCurrent);
            }
            if (retArr.length > 26) {
                int batDischargeCurrent = VolUtil.parseInt(retArr[26]);
                workInfo.setBatDisCurrent(batDischargeCurrent);
            }
            String faultcode = retArr[3];
            FaultHandler.doFaultEvent(workInfo, faultcode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean queryMachineInfo() {
        IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
        if (handler == null) {
            return false;
        }
        boolean result = true;
        MachineInfo machineInfo = (MachineInfo)this.getBeanBag().getBean("machineinfo");
        try {
            String eqInfo;
            String qpiriStr;
            String slaveFirmwareVersion;
            machineInfo.setSerialno(handler.getSerialNo());
            String mainFirmwareVersion = handler.excuteCommand("QVFW", true);
            if (!"".equals(mainFirmwareVersion) && !mainFirmwareVersion.equals("(NAK")) {
                machineInfo.setMainFirmwareVersion(mainFirmwareVersion.substring(7).trim());
            }
            if (!"".equals(slaveFirmwareVersion = handler.excuteCommand("QVFW2", true)) && !slaveFirmwareVersion.equals("(NAK")) {
                String slaveFMVersion = slaveFirmwareVersion.substring(8).trim();
                if (slaveFMVersion == null) {
                    slaveFMVersion = "---";
                } else if (slaveFMVersion.indexOf(".") == -1) {
                    slaveFMVersion = "---";
                }
                machineInfo.setSlaveFirmwareVersion(slaveFMVersion);
            }
            if (!"".equals(qpiriStr = handler.excuteCommand("QPIRI", true)) && !qpiriStr.equals("(NAK")) {
                String[] ratingInfo = qpiriStr.split(" ");
                double gridRatingVoltage = VolUtil.parseDouble(ratingInfo[0].substring(1));
                double gridRatingCurrent = VolUtil.parseDouble(ratingInfo[1]);
                double acOutputRatingVoltage = VolUtil.parseDouble(ratingInfo[2]);
                double acOutputRatingFrequency = VolUtil.parseDouble(ratingInfo[3]);
                double acOutputRatingCurrent = VolUtil.parseDouble(ratingInfo[4]);
                double acOutputRatingApparentPower = VolUtil.parseDouble(ratingInfo[5]);
                double acOutputRatingActivePower = VolUtil.parseDouble(ratingInfo[6]);
                double batteryRatingVoltage = VolUtil.parseDouble(ratingInfo[7]);
                String batteryTypeStr = ratingInfo[12];
                double perMPPTRatingCurrent = VolUtil.parseDouble(ratingInfo[13]);
                String inputVoltageRangeStr = ratingInfo[15];
                String outputSourceStr = ratingInfo[16];
                String chargeSourceStr = ratingInfo[17];
                String machineTypeStr = ratingInfo[19];
                String topologyStr = ratingInfo[20];
                machineInfo.setGridRatingVoltage(gridRatingVoltage);
                machineInfo.setGridRatingCurrent(gridRatingCurrent);
                machineInfo.setAcOutputRatingVoltage(acOutputRatingVoltage);
                machineInfo.setAcOutputRatingFrequency(acOutputRatingFrequency);
                machineInfo.setAcOutputRatingCurrent(acOutputRatingCurrent);
                machineInfo.setAcOutputRatingApparentPower(acOutputRatingApparentPower);
                machineInfo.setAcOutputRatingActivePower(acOutputRatingActivePower);
                machineInfo.setBatteryRatingVoltage(batteryRatingVoltage);
                machineInfo.setPerMPPTRatingCurrent(perMPPTRatingCurrent);
                String batteryType = "---";
                if (batteryTypeStr.equals("0")) {
                    batteryType = "AGM";
                } else if (batteryTypeStr.equals("1")) {
                    batteryType = "Flooded";
                }
                machineInfo.setBatteryType(batteryType);
                String inputVoltageRange = "---";
                if (inputVoltageRangeStr.equals("0")) {
                    inputVoltageRange = "Appliance";
                } else if (inputVoltageRangeStr.equals("1")) {
                    inputVoltageRange = "UPS";
                }
                if (ratingInfo.length > 21) {
                    try {
                        int outputmode = Integer.parseInt(ratingInfo[21]);
                        this._protocol.setOutputMode(outputmode);
                        this._outputmode = outputmode;
                        if (outputmode != 0) {
                            this._paralleltype = 1;
                            this._parallelnum = VolUtil.parseInt(ratingInfo[18]);
                        } else {
                            this._paralleltype = 0;
                        }
                    }
                    catch (Exception outputmode) {
                        // empty catch block
                    }
                }
                machineInfo.setInputVoltageRange(inputVoltageRange);
                String outputSource = "---";
                if (outputSourceStr.equals("0")) {
                    if (!this._protocol.getAxpert().equals("023") && !this._protocol.getAxpert().equals("024")) {
                        outputSource = "Utility";
                    }
                } else if (outputSourceStr.equals("1")) {
                    outputSource = "Solar";
                }
                machineInfo.setOutputSource(outputSource);
                String chargeSource = "---";
                if (chargeSourceStr.equals("0")) {
                    chargeSource = this._protocol.getAxpert().equals("023") || this._protocol.getAxpert().equals("024") ? "SBL&UCB" : "Utility";
                } else if (chargeSourceStr.equals("1")) {
                    chargeSource = this._protocol.getAxpert().equals("023") || this._protocol.getAxpert().equals("024") ? "SBL&UDC" : "Solar";
                } else if (chargeSourceStr.equals("2")) {
                    chargeSource = this._protocol.getAxpert().equals("023") || this._protocol.getAxpert().equals("024") ? "SLB&UCB" : "Solar and Utility";
                } else if (chargeSourceStr.equals("3") && (this._protocol.getAxpert().equals("023") || this._protocol.getAxpert().equals("024"))) {
                    chargeSource = "SLB&UDC";
                }
                machineInfo.setChargeSource(chargeSource);
                String machineType = "---";
                if (machineTypeStr.equals("00")) {
                    machineType = "Grid tie";
                } else if (machineTypeStr.equals("01")) {
                    machineType = "Stand alone";
                } else if (machineTypeStr.equals("10")) {
                    machineType = "Hybrid";
                } else if (machineTypeStr.equals("30") || machineTypeStr.equals("31")) {
                    machineType = "Stand alone";
                }
                machineInfo.setMachineType(machineType);
                String topology = "---";
                if (topologyStr.equals("0")) {
                    topology = "Transformerless";
                } else if (topologyStr.equals("1")) {
                    topology = "Transformer";
                }
                machineInfo.setTopology(topology);
            }
            if (!("".equals(eqInfo = handler.excuteCommand("QBEQI", true)) || eqInfo.equals("(NAK") || eqInfo.equals("QBEQI"))) {
                machineInfo.setSupportEQ(true);
            } else {
                machineInfo.setSupportEQ(false);
            }
            String piriInfo = handler.excuteCommand("QPIRI", true);
            if (!"".equals(piriInfo) && !eqInfo.equals("(NAK")) {
                String[] CVtime = piriInfo.split(" ");
                if (CVtime.length >= 26) {
                    machineInfo.setSupportMaxCVTime(true);
                } else {
                    machineInfo.setSupportMaxCVTime(false);
                }
            } else {
                machineInfo.setSupportMaxCVTime(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    @Override
    public boolean queryCapability() {
        boolean result = true;
        IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
        if (handler == null) {
            return false;
        }
        Capability capability = (Capability)this.getBeanBag().getBean("capability");
        try {
            String qflagStr = handler.excuteCommand("QFLAG", true);
            if (!"".equals(qflagStr) && !qflagStr.equals("(NAK")) {
                String qebgpstr;
                ConfigData configdata;
                String before = qflagStr.substring(qflagStr.indexOf("E"), qflagStr.indexOf("D"));
                if (before.indexOf(97) != -1) {
                    capability.setCapableA(true);
                } else {
                    capability.setCapableA(false);
                }
                if (before.indexOf(106) != -1) {
                    capability.setCapableJ(true);
                } else {
                    capability.setCapableJ(false);
                }
                if (before.indexOf(107) != -1) {
                    capability.setCapableK(true);
                } else {
                    capability.setCapableK(false);
                }
                if (before.indexOf(117) != -1) {
                    capability.setCapableU(true);
                } else {
                    capability.setCapableU(false);
                }
                if (before.indexOf(118) != -1) {
                    capability.setCapableV(true);
                } else {
                    capability.setCapableV(false);
                }
                if (before.indexOf(119) != -1) {
                    capability.setCapableW(true);
                } else {
                    capability.setCapableW(false);
                }
                if (before.indexOf(120) != -1) {
                    capability.setCapableX(true);
                } else {
                    capability.setCapableX(false);
                }
                if (before.indexOf(121) != -1) {
                    capability.setCapableY(true);
                } else {
                    capability.setCapableY(false);
                }
                if (before.indexOf(122) != -1) {
                    capability.setCapableZ(true);
                } else {
                    capability.setCapableZ(false);
                }
                if (before.indexOf(98) != -1) {
                    capability.setCapableB(true);
                } else {
                    capability.setCapableB(false);
                }
                if (before.indexOf(99) != -1) {
                    if (this._protocol.getAxpert().equals("024") || this._protocol.getAxpert().equals("023")) {
                        configdata = (ConfigData)this.getBeanBag().getBean("configdata");
                        if (before.indexOf(98) != -1) {
                            configdata.setBypassFunction("Enable");
                        } else {
                            configdata.setBypassFunction("Disable");
                        }
                    }
                } else {
                    configdata = (ConfigData)this.getBeanBag().getBean("configdata");
                    configdata.setBypassFunction("Forbidden");
                }
                if (before.indexOf(100) != -1) {
                    configdata = (ConfigData)this.getBeanBag().getBean("configdata");
                    configdata.setECOMode(1);
                } else {
                    configdata = (ConfigData)this.getBeanBag().getBean("configdata");
                    configdata.setECOMode(0);
                }
                if (before.indexOf(112) != -1) {
                    capability.setCapableP(true);
                } else {
                    capability.setCapableP(false);
                }
                if (before.indexOf(103) != -1) {
                    capability.setCapableG(true);
                } else {
                    capability.setCapableG(false);
                }
                if (before.indexOf(108) != -1) {
                    capability.setCapableL(true);
                } else {
                    capability.setCapableL(false);
                }
                if ((this._protocol.getAxpertType().equals("VMII-3000") || this._protocol.getAxpertType().equals("VMII-5000") || this._protocol.getAxpertType().equals("VMII-1500") || this._protocol.getAxpertType().equals("VMIII-1500") || this._protocol.getAxpertType().equals("VMIII-3000") || this._protocol.getAxpertType().equals("VMIII-3200") || this._protocol.getAxpertType().equals("VMIII-5000") || this._protocol.getAxpertType().equals("VMIII-5200")) && this.notEmpty(qebgpstr = handler.excuteCommand("QEBGP", true)) && !qebgpstr.equals("QEBGP")) {
                    String[] qebgps = qebgpstr.split(" ");
                    int activeLifeBattery = VolUtil.parseInt(qebgps[1]);
                    capability.setCapableLBF(activeLifeBattery == 1);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
            System.err.println(e.getMessage());
        }
        return result;
    }

    @Override
    public boolean queryConfigData() {
        boolean result;
        block129: {
            result = true;
            try {
                String qbeqiStr;
                String qpacchargstr;
                ConfigData configdata = (ConfigData)this.getBeanBag().getBean("configdata");
                MachineInfo machine = (MachineInfo)this.getBeanBag().getBean("machineinfo");
                IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
                if (handler == null) {
                    throw new Exception("handler is null");
                }
                String qpiriStr = handler.excuteCommand("QPIRI", true);
                if ("".equals(qpiriStr) || qpiriStr.equals("(NAK")) break block129;
                String[] ratingInfo = qpiriStr.split(" ");
                String outputVoltage = ratingInfo[2];
                configdata.setOutputVoltage(outputVoltage.substring(0, 3));
                String outputFrequency = ratingInfo[3];
                configdata.setOutputFrequency(outputFrequency.substring(0, 2));
                configdata.setBatteryVoltage(VolUtil.parseDouble(ratingInfo[7]));
                configdata.setRechargeVoltage(VolUtil.parseDouble(ratingInfo[8]));
                String batteryTypeStr = ratingInfo[12];
                String batteryType = "AGM";
                if (batteryTypeStr.equals("0")) {
                    batteryType = "AGM";
                } else if (batteryTypeStr.equals("1")) {
                    batteryType = "Flooded";
                } else if (batteryTypeStr.equals("2")) {
                    batteryType = "User";
                }
                configdata.setBatteryType(batteryType);
                double maxChargeCurrent = VolUtil.parseDouble(ratingInfo[13]);
                double currentChargeCurrent = VolUtil.parseDouble(ratingInfo[14]);
                configdata.setMaxChargeCurrent(currentChargeCurrent);
                configdata.setMinMaxChargeCurrent(10.0);
                if (machine.isChargeCurrentComBox() || this.getProtocol().getAxpert().equals("023") || this.getProtocol().getAxpert().equals("024") || this.getProtocol().getAxpertType().equals("VMII-5000") || this.getProtocol().getAxpertType().equals("VMIII-5200") || this.getProtocol().getAxpertType().equals("VMIII-5000") || this.getProtocol().getAxpertType().equals("VMIII-3200") || this.getProtocol().getAxpertType().equals("VMIII-3000") || this.getProtocol().getAxpertType().equals("VMIII-1500") || this.getProtocol().getAxpertType().equals("VMII-1500")) {
                    configdata.setMaxacchargingcurrent(maxChargeCurrent);
                } else {
                    configdata.setMaxMaxChargeCurrent(maxChargeCurrent);
                }
                double maxChargeVoltage = VolUtil.parseDouble(ratingInfo[10]);
                configdata.setMaxChargeVoltage(maxChargeVoltage);
                double floatChargVoltage = VolUtil.parseDouble(ratingInfo[11]);
                configdata.setFloatingChargeVoltage(floatChargVoltage);
                double batteryUnder = VolUtil.parseDouble(ratingInfo[9]);
                configdata.setBatteryUnder(batteryUnder);
                if (this._protocol.getAxpertType().startsWith("EX") || this._protocol.getAxpertType().startsWith("MEX")) {
                    if (!(configdata.getBatteryVoltage() > 40.0)) {
                        if (configdata.getBatteryVoltage() > 20.0) {
                            configdata.setMinMaxChargeVoltage(24.0);
                            configdata.setMaxMaxChargeVoltage(30.6);
                            configdata.setMinFloatingChargeVoltage(24.0);
                            configdata.setMaxFloatingChargeVoltage(30.6);
                            configdata.setMinBatteryUnder(20.4);
                            configdata.setMaxBatteryUnder(24.0);
                        } else {
                            configdata.setMinMaxChargeVoltage(12.0);
                            configdata.setMaxMaxChargeVoltage(15.3);
                            configdata.setMinFloatingChargeVoltage(12.0);
                            configdata.setMaxFloatingChargeVoltage(15.3);
                            configdata.setMinBatteryUnder(10.2);
                            configdata.setMaxBatteryUnder(12.0);
                        }
                    }
                } else if (this._protocol.getAxpertType().equals("VP-3000") || this._protocol.getAxpertType().equals("VM-3000") || this._protocol.getAxpertType().equals("VMII-1500") || this._protocol.getAxpertType().equals("VMIII-1500") || this._protocol.getAxpertType().equals("VMIII-3000") || this._protocol.getAxpertType().equals("VMIII-3200") || this._protocol.getAxpertType().equals("VMII-3000")) {
                    configdata.setMinMaxChargeVoltage(25.0);
                    configdata.setMaxMaxChargeVoltage(31.5);
                    configdata.setMinFloatingChargeVoltage(25.0);
                    configdata.setMaxFloatingChargeVoltage(31.5);
                    configdata.setMinBatteryUnder(21.0);
                    configdata.setMaxBatteryUnder(24.0);
                } else if (this._protocol.getAxpertType().equals("VP-5000") || this._protocol.getAxpertType().equals("VM-5000") || this._protocol.getAxpertType().equals("VMIII-5000") || this._protocol.getAxpertType().equals("VMIII-5200") || this._protocol.getAxpertType().equals("VMII-5000")) {
                    configdata.setMinFloatingChargeVoltage(48.0);
                    configdata.setMaxFloatingChargeVoltage(61.0);
                    configdata.setMinMaxChargeVoltage(48.0);
                    configdata.setMaxMaxChargeVoltage(61.0);
                    configdata.setMinBatteryUnder(42.0);
                    configdata.setMaxBatteryUnder(48.0);
                } else if (this._protocol.getAxpert().equals("012") || this._protocol.getAxpert().equals("013") || this._protocol.getAxpert().equals("024") || this._protocol.getAxpert().equals("023")) {
                    if (configdata.getBatteryVoltage() > 40.0) {
                        if (this._protocol.getAxpert().equals("024")) {
                            configdata.setMinMaxChargeVoltage(24.0);
                            configdata.setMaxMaxChargeVoltage(32.0);
                            configdata.setMinFloatingChargeVoltage(24.0);
                            configdata.setMaxFloatingChargeVoltage(32.0);
                        } else {
                            configdata.setMinMaxChargeVoltage(48.0);
                            configdata.setMaxMaxChargeVoltage(64.0);
                            configdata.setMinFloatingChargeVoltage(48.0);
                            configdata.setMaxFloatingChargeVoltage(64.0);
                        }
                        if (this._protocol.getAxpert().equals("023")) {
                            configdata.setMinBatteryUnder(40.0);
                            configdata.setMaxBatteryUnder(54.0);
                        } else if (this._protocol.getAxpert().equals("024")) {
                            configdata.setMinBatteryUnder(20.0);
                            configdata.setMaxBatteryUnder(27.0);
                        } else {
                            configdata.setMinBatteryUnder(40.0);
                            configdata.setMaxBatteryUnder(48.0);
                        }
                    } else if (configdata.getBatteryVoltage() > 20.0) {
                        if (this._protocol.getAxpert().equals("024")) {
                            configdata.setMinMaxChargeVoltage(24.0);
                            configdata.setMaxMaxChargeVoltage(32.0);
                            configdata.setMinFloatingChargeVoltage(24.0);
                            configdata.setMaxFloatingChargeVoltage(32.0);
                            configdata.setMinBatteryUnder(20.0);
                            configdata.setMaxBatteryUnder(27.0);
                        } else {
                            configdata.setMinMaxChargeVoltage(24.0);
                            configdata.setMaxMaxChargeVoltage(29.21);
                            configdata.setMinFloatingChargeVoltage(24.0);
                            configdata.setMaxFloatingChargeVoltage(29.21);
                            configdata.setMinBatteryUnder(20.0);
                            configdata.setMaxBatteryUnder(24.0);
                        }
                    } else {
                        configdata.setMinMaxChargeVoltage(12.0);
                        configdata.setMaxMaxChargeVoltage(14.6);
                        configdata.setMinFloatingChargeVoltage(12.0);
                        configdata.setMaxFloatingChargeVoltage(14.6);
                        configdata.setMinBatteryUnder(10.0);
                        configdata.setMaxBatteryUnder(12.0);
                    }
                } else if (this._protocol.getAxpert().equals("022")) {
                    configdata.setMinMaxChargeVoltage(48.0);
                    configdata.setMaxMaxChargeVoltage(64.0);
                    configdata.setMinFloatingChargeVoltage(48.0);
                    configdata.setMaxFloatingChargeVoltage(64.0);
                    configdata.setMinBatteryUnder(40.0);
                    configdata.setMaxBatteryUnder(54.0);
                } else if (this._protocol.getAxpertType().equals("VP-2000")) {
                    configdata.setMinMaxChargeVoltage(24.0);
                    configdata.setMaxMaxChargeVoltage(29.21);
                    configdata.setMinFloatingChargeVoltage(24.0);
                    configdata.setMaxFloatingChargeVoltage(29.21);
                    configdata.setMinBatteryUnder(21.0);
                    configdata.setMaxBatteryUnder(24.0);
                } else if (configdata.getBatteryVoltage() > 40.0) {
                    configdata.setMinMaxChargeVoltage(48.0);
                    configdata.setMaxMaxChargeVoltage(58.4);
                    configdata.setMinFloatingChargeVoltage(48.0);
                    configdata.setMaxFloatingChargeVoltage(58.4);
                    configdata.setMinBatteryUnder(40.0);
                    configdata.setMaxBatteryUnder(48.0);
                } else if (configdata.getBatteryVoltage() > 20.0) {
                    configdata.setMinMaxChargeVoltage(24.0);
                    configdata.setMaxMaxChargeVoltage(29.21);
                    configdata.setMinFloatingChargeVoltage(24.0);
                    configdata.setMaxFloatingChargeVoltage(29.21);
                    configdata.setMinBatteryUnder(20.0);
                    configdata.setMaxBatteryUnder(24.0);
                } else {
                    configdata.setMinMaxChargeVoltage(12.0);
                    configdata.setMaxMaxChargeVoltage(14.6);
                    configdata.setMinFloatingChargeVoltage(12.0);
                    configdata.setMaxFloatingChargeVoltage(14.6);
                    configdata.setMinBatteryUnder(10.0);
                    configdata.setMaxBatteryUnder(12.0);
                }
                String inputVoltageRangeStr = ratingInfo[15];
                String outputSourceStr = ratingInfo[16];
                String chargeSourceStr = ratingInfo[17];
                String inputVoltageRange = "Appliance";
                if (inputVoltageRangeStr.equals("0")) {
                    inputVoltageRange = this._protocol.getAxpert().equals("022") ? "APL range" : "Appliance";
                } else if (inputVoltageRangeStr.equals("1")) {
                    inputVoltageRange = "UPS";
                }
                if (ratingInfo.length > 21) {
                    try {
                        int outputmode = Integer.parseInt(ratingInfo[21]);
                        this._protocol.setOutputMode(outputmode);
                        if (outputmode != 0) {
                            this._paralleltype = 1;
                            this._parallelnum = VolUtil.parseInt(ratingInfo[18]);
                        } else {
                            this._paralleltype = 0;
                        }
                    }
                    catch (Exception outputmode) {
                        // empty catch block
                    }
                }
                if (ratingInfo.length > 22) {
                    if (VolUtil.round(VolUtil.parseDouble(ratingInfo[22]), 0) == 0.0) {
                        configdata.setReDischargeVoltage("FULL");
                    } else {
                        configdata.setReDischargeVoltage(ratingInfo[22]);
                    }
                    configdata.setBatReDischargeCapacity(VolUtil.parseInt(ratingInfo[22]));
                }
                if (ratingInfo.length > 24) {
                    if (VolUtil.parseInt(ratingInfo[23]) == 1) {
                        configdata.setAllpvok(true);
                    } else {
                        configdata.setAllpvok(false);
                    }
                    if (VolUtil.parseInt(ratingInfo[24]) == 1) {
                        configdata.setSolarbalance(true);
                    } else {
                        configdata.setSolarbalance(false);
                    }
                }
                configdata.setAcInputRange(inputVoltageRange);
                String outputSource = "Utility";
                if (outputSourceStr.equals("0")) {
                    outputSource = this._protocol.getAxpert().equals("023") || this._protocol.getAxpert().equals("024") ? "Utility->Solar->Battery" : "Utility";
                    try {
                        if (GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().startsWith("VMIII")) {
                            Constants.outputSource = "Utility";
                        }
                    }
                    catch (Exception exception) {}
                } else if (outputSourceStr.equals("1")) {
                    if (this._protocol.getAxpert().equals("023") || this._protocol.getAxpert().equals("024")) {
                        outputSource = "Solar->Utility->Battery";
                    } else {
                        outputSource = "Solar";
                        if (GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().startsWith("VMIII")) {
                            Constants.outputSource = "Solar";
                        }
                    }
                } else if (outputSourceStr.equals("2")) {
                    outputSource = this._protocol.getAxpert().equals("023") || this._protocol.getAxpert().equals("024") ? "Solar->Battery->Utility" : "SBU";
                    try {
                        if (GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().startsWith("VMIII")) {
                            Constants.outputSource = "SBU";
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                configdata.setOutputSource(outputSource);
                String chargeSource = "Utility";
                if (chargeSourceStr.equals("0")) {
                    chargeSource = this._protocol.getAxpert().equals("023") || this._protocol.getAxpert().equals("024") ? "SBL&UCB" : "Utility";
                } else if (chargeSourceStr.equals("1")) {
                    chargeSource = this._protocol.getAxpert().equals("023") || this._protocol.getAxpert().equals("024") ? "SBL&UDC" : "Solar first";
                } else if (chargeSourceStr.equals("2")) {
                    chargeSource = this._protocol.getAxpert().equals("023") || this._protocol.getAxpert().equals("024") ? "SLB&UCB" : "Utility and Solar";
                } else if (chargeSourceStr.equals("3")) {
                    chargeSource = this._protocol.getAxpert().equals("023") || this._protocol.getAxpert().equals("024") ? "SLB&UDC" : "Solar only";
                }
                configdata.setChargerSource(chargeSource);
                try {
                    configdata.setChargingTimeInCVStage(VolUtil.parseInt(ratingInfo[25]));
                    configdata.setMinChargingTimeInCVStage(0);
                    configdata.setMaxChargingTimeInCVStage(900);
                    if (ratingInfo.length >= 26) {
                        switch (VolUtil.parseInt(ratingInfo[26])) {
                            case 0: {
                                configdata.setOperationLogic("Automatically(AUT)");
                                break;
                            }
                            case 1: {
                                configdata.setOperationLogic("Online mode(ONL)");
                                break;
                            }
                            case 2: {
                                configdata.setOperationLogic("ECO Mode(ECO)");
                            }
                            default: {
                                break;
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.notEmpty(qpiriStr = handler.excuteCommand("QMCHGCR", true))) {
                    ratingInfo = qpiriStr.substring(1).split(" ");
                    if (machine.isChargeCurrentComBox() || this.getProtocol().getAxpert().equals("023") || this.getProtocol().getAxpert().equals("024") || this.getProtocol().getAxpertType().equals("VMIII-5000") || this.getProtocol().getAxpertType().equals("VMIII-5200")) {
                        int index = 0;
                        while (index < ratingInfo.length) {
                            try {
                                ratingInfo[index] = String.format("%d", Integer.parseInt(ratingInfo[index]));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            ++index;
                        }
                        configdata.setChargingCurrentComBox(ratingInfo);
                    } else {
                        configdata.setMinMaxChargeCurrent(VolUtil.parseDouble(ratingInfo[0].substring(1)));
                        configdata.setMaxMaxChargeCurrent(VolUtil.parseDouble(ratingInfo[1]));
                    }
                }
                if (this.notEmpty(qpacchargstr = handler.excuteCommand("QMUCHGCR", true))) {
                    ratingInfo = qpacchargstr.substring(1).split(" ");
                    int index = 0;
                    while (index < ratingInfo.length) {
                        try {
                            ratingInfo[index] = String.format("%d", Integer.parseInt(ratingInfo[index]));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++index;
                    }
                    configdata.setAcChargingCurrentComBox(ratingInfo);
                    GlobalVariables.setSPforVM3000Plus(false);
                    try {
                        GlobalVariables.setSPforVM3000Plus(Integer.parseInt(ratingInfo[ratingInfo.length - 1]) < 40);
                    }
                    catch (Exception e) {
                        GlobalVariables.setSPforVM3000Plus(false);
                    }
                }
                if (this.notEmpty(qbeqiStr = handler.excuteCommand("QBEQI", true))) {
                    String[] qbeqi = qbeqiStr.substring(1).split(" ");
                    configdata.setEnableEq(qbeqi[0].equals("1"));
                    configdata.setEqTime(VolUtil.parseInt(qbeqi[1]));
                    configdata.setMinEqTime(5);
                    configdata.setMaxEqTime(900);
                    configdata.setEqPeriod(VolUtil.parseInt(qbeqi[2]));
                    configdata.setMinEqPeriod(0);
                    configdata.setMaxEqPeriod(90);
                    configdata.setEqVoltage(VolUtil.parseDouble(qbeqi[5]));
                    String axpert = this._protocol.getAxpert();
                    if (axpert.equals("012") || axpert.equals("013") || axpert.equals("023")) {
                        configdata.setMinEqVoltage(48.0);
                        configdata.setMaxEqVoltage(64.0);
                    } else if (axpert.equals("014") || axpert.equals("015") || axpert.equals("016") || axpert.equals("016") || axpert.equals("020") || axpert.equals("016") || axpert.equals("017")) {
                        configdata.setMinEqVoltage(48.0);
                        configdata.setMaxEqVoltage(58.4);
                    } else if (axpert.equals("008") || axpert.equals("009") || axpert.equals("010") || axpert.equals("011") || axpert.equals("006") || axpert.equals("007")) {
                        configdata.setMinEqVoltage(24.0);
                        configdata.setMaxEqVoltage(29.21);
                    } else if (axpert.equals("022")) {
                        configdata.setMinEqVoltage(48.0);
                        configdata.setMaxEqVoltage(64.0);
                    } else if (axpert.equals("024")) {
                        configdata.setMinEqVoltage(24.0);
                        configdata.setMaxEqVoltage(32.0);
                    } else if (this.getProtocol().getAxpertType().equals("VP-5000") || this.getProtocol().getAxpertType().equals("VM-5000") || this.getProtocol().getAxpertType().equals("VMIII-5000") || this.getProtocol().getAxpertType().equals("VMIII-5200") || this.getProtocol().getAxpertType().equals("VMII-5000")) {
                        configdata.setMinEqVoltage(48.0);
                        configdata.setMaxEqVoltage(61.0);
                    } else if (this.getProtocol().getAxpertType().equals("VP-3000") || this.getProtocol().getAxpertType().equals("VM-3000") || this.getProtocol().getAxpertType().equals("VMIII-3200") || this.getProtocol().getAxpertType().equals("VMII-1500") || this.getProtocol().getAxpertType().equals("VMIII-1500") || this.getProtocol().getAxpertType().equals("VMIII-3000") || this.getProtocol().getAxpertType().equals("VMIII-3200") || this.getProtocol().getAxpertType().equals("VMII-3000")) {
                        configdata.setMinEqVoltage(25.0);
                        configdata.setMaxEqVoltage(31.5);
                    } else if (this.getProtocol().getAxpertType().equals("VP-2000") || this.getProtocol().getAxpertType().equals("VM-2000")) {
                        configdata.setMinEqVoltage(25.0);
                        configdata.setMaxEqVoltage(30.0);
                    } else if (this.getProtocol().getAxpertType().equals("VP-1000") || this.getProtocol().getAxpertType().equals("VM-1000") || this.getProtocol().getAxpertType().equals("VM-1200")) {
                        configdata.setMinEqVoltage(12.5);
                        configdata.setMaxEqVoltage(15.0);
                    } else if (this.isMKSPF1_3K(machine)) {
                        if (configdata.getBatteryVoltage() > 40.0) {
                            configdata.setMinEqVoltage(48.0);
                            configdata.setMaxEqVoltage(58.4);
                        } else if (configdata.getBatteryVoltage() > 20.0) {
                            configdata.setMinEqVoltage(24.0);
                            configdata.setMaxEqVoltage(29.21);
                        } else if (configdata.getBatteryVoltage() > 10.0) {
                            configdata.setMinEqVoltage(12.0);
                            configdata.setMaxEqVoltage(14.6);
                        }
                    } else if (this.isKSPF1_3K(machine)) {
                        if (machine.getAcOutputRatingApparentPower() == 3000.0 || machine.getAcOutputRatingApparentPower() == 2000.0) {
                            configdata.setMinEqVoltage(24.0);
                            configdata.setMaxEqVoltage(29.21);
                            System.out.println("ice2lin------------");
                        } else if (machine.getAcOutputRatingApparentPower() == 1000.0) {
                            configdata.setMinEqVoltage(12.0);
                            configdata.setMaxEqVoltage(14.6);
                        }
                    } else {
                        configdata.setMinEqVoltage(24.0);
                        configdata.setMaxEqVoltage(29.21);
                    }
                    configdata.setEqOverTime(VolUtil.parseInt(qbeqi[7]));
                    configdata.setMinEqOverTime(5);
                    configdata.setMaxEqOverTime(900);
                    configdata.setActivateEq(qbeqi[8].equals("1"));
                }
            }
            catch (Exception e) {
                result = false;
                e.printStackTrace();
            }
        }
        return result;
    }

    protected boolean isMKSPF1_3K(MachineInfo machineInfo) {
        if (machineInfo == null) {
            return false;
        }
        return machineInfo.getAcOutputRatingApparentPower() >= 1000.0 && machineInfo.getAcOutputRatingApparentPower() <= 3000.0 && machineInfo.getMainFirmwareVersion().compareToIgnoreCase("00001.00") >= 0 && machineInfo.getMainFirmwareVersion().compareToIgnoreCase("00010.00") < 0;
    }

    protected boolean isKSPF1_3K(MachineInfo machineInfo) {
        if (machineInfo == null) {
            return false;
        }
        return machineInfo.getAcOutputRatingApparentPower() >= 1000.0 && machineInfo.getAcOutputRatingApparentPower() <= 3000.0 && machineInfo.getMainFirmwareVersion().compareToIgnoreCase("00015.00") >= 0 && machineInfo.getMainFirmwareVersion().compareToIgnoreCase("00018.00") < 0;
    }

    @Override
    public void querySelfTestResult() {
    }

    @Override
    public boolean queryDefaultData() {
        boolean result;
        block83: {
            IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
            if (handler == null) {
                return false;
            }
            DefaultData defaultData = (DefaultData)this.getBeanBag().getBean("defaultdata");
            result = true;
            try {
                String qdiStr = handler.excuteCommand("QDI", true);
                if ("".equals(qdiStr) || qdiStr.equals("(NAK")) break block83;
                String[] qdiArr = qdiStr.split(" ");
                double acOutputVoltage = VolUtil.parseDouble(qdiArr[0].substring(1));
                double acOutputFrequency = VolUtil.parseDouble(qdiArr[1]);
                defaultData.setMaxACChargingCurrent(VolUtil.parseInt(qdiArr[2]));
                defaultData.setBatteryCutoffVoltage(VolUtil.parseDouble(qdiArr[3]));
                defaultData.setFloatChargingVoltage(VolUtil.parseDouble(qdiArr[4]));
                double maxChargingVoltage = VolUtil.parseDouble(qdiArr[5]);
                if (this.getProtocol().getAxpert().equals("023")) {
                    defaultData.setReChangingVoltage(VolUtil.parseDouble(qdiArr[6]));
                } else if (this.getProtocol().getAxpert().equals("024")) {
                    defaultData.setReChangingVoltage(VolUtil.parseDouble("23"));
                } else {
                    defaultData.setReChangingVoltage(VolUtil.parseDouble(qdiArr[6]));
                }
                int maxChargingCurrent = VolUtil.parseInt(qdiArr[7]);
                int acInputVoltage = VolUtil.parseInt(qdiArr[8]);
                int outputSourcePriority = VolUtil.parseInt(qdiArr[9]);
                int chargerSourcePriority = VolUtil.parseInt(qdiArr[10]);
                int batteryType = VolUtil.parseInt(qdiArr[11]);
                int capableA = VolUtil.parseInt(qdiArr[12]);
                int capableJ = VolUtil.parseInt(qdiArr[13]);
                int capableU = VolUtil.parseInt(qdiArr[14]);
                int capableV = VolUtil.parseInt(qdiArr[15]);
                int capableX = VolUtil.parseInt(qdiArr[16]);
                int capableY = VolUtil.parseInt(qdiArr[17]);
                int capableZ = VolUtil.parseInt(qdiArr[18]);
                defaultData.setAcOutputVoltage(acOutputVoltage);
                defaultData.setAcOutputFrequency(acOutputFrequency);
                defaultData.setMaxChargingVoltage(maxChargingVoltage);
                defaultData.setMaxChargingCurrent(maxChargingCurrent);
                if (acInputVoltage == 0) {
                    if ("022".equals(this._protocol.getAxpert())) {
                        defaultData.setAcInputVoltage("APL range");
                    } else {
                        defaultData.setAcInputVoltage("Appliance");
                    }
                } else if (this._protocol.getAxpert().equals("023") || this._protocol.getAxpert().equals("024")) {
                    defaultData.setAcInputVoltage("UPS");
                } else {
                    defaultData.setAcInputVoltage("UPS");
                }
                if (outputSourcePriority == 0) {
                    if (this._protocol.getAxpert().equals("023") || this._protocol.getAxpert().equals("024")) {
                        defaultData.setOutputSourcePriority("Utility->Solar->Battery");
                    } else {
                        defaultData.setOutputSourcePriority("Utility");
                    }
                } else if (outputSourcePriority == 1) {
                    if (this._protocol.getAxpert().equals("023") || this._protocol.getAxpert().equals("024")) {
                        defaultData.setOutputSourcePriority("Solar->Utility->Battery");
                    } else {
                        defaultData.setOutputSourcePriority("Solar");
                    }
                } else if (outputSourcePriority == 2) {
                    if (this._protocol.getAxpert().equals("023") || this._protocol.getAxpert().equals("024")) {
                        defaultData.setOutputSourcePriority("Solar->Battery->Utility");
                    } else {
                        defaultData.setOutputSourcePriority("SBU");
                    }
                }
                if (chargerSourcePriority == 0) {
                    if (this._protocol.getAxpert().equals("023") || this._protocol.getAxpert().equals("024")) {
                        defaultData.setChargerSourcePriority("SBL&UCB");
                    } else {
                        defaultData.setChargerSourcePriority("Utility");
                    }
                } else if (chargerSourcePriority == 1) {
                    if (this._protocol.getAxpert().equals("023") || this._protocol.getAxpert().equals("024")) {
                        defaultData.setChargerSourcePriority("SBL&UDC");
                    } else {
                        defaultData.setChargerSourcePriority("Solar");
                    }
                } else if (chargerSourcePriority == 2) {
                    if (this._protocol.getAxpert().equals("023") || this._protocol.getAxpert().equals("024")) {
                        defaultData.setChargerSourcePriority("SBL&UCB");
                    } else {
                        defaultData.setChargerSourcePriority("Utility and Solar");
                    }
                } else if (chargerSourcePriority == 3) {
                    if (this._protocol.getAxpert().equals("023") || this._protocol.getAxpert().equals("024")) {
                        defaultData.setChargerSourcePriority("SLB&UDC");
                    } else {
                        defaultData.setChargerSourcePriority("Solar only");
                    }
                }
                if (batteryType == 0) {
                    defaultData.setBatteryType("AGM");
                } else if (batteryType == 1) {
                    defaultData.setBatteryType("Flooded");
                } else if (batteryType == 2) {
                    defaultData.setBatteryType("User");
                }
                if (capableA == 0) {
                    if (this.getProtocol().getAxpert().equals("024") || this.getProtocol().getAxpert().equals("023")) {
                        defaultData.setCapableA("Enable");
                    } else {
                        defaultData.setCapableA("Disable");
                    }
                } else {
                    defaultData.setCapableA("Enable");
                }
                if (capableJ == 0) {
                    defaultData.setCapableJ("Disable");
                } else {
                    defaultData.setCapableJ("Enable");
                }
                if (capableU == 0) {
                    defaultData.setCapableU("Disable");
                } else {
                    defaultData.setCapableU("Enable");
                }
                if (capableV == 0) {
                    defaultData.setCapableV("Disable");
                } else {
                    defaultData.setCapableV("Enable");
                }
                if (capableX == 0) {
                    defaultData.setCapableX("Disable");
                } else {
                    defaultData.setCapableX("Enable");
                }
                if (capableY == 0) {
                    defaultData.setCapableY("Disable");
                } else {
                    defaultData.setCapableY("Enable");
                }
                if (capableZ == 0) {
                    defaultData.setCapableZ("Disable");
                } else {
                    defaultData.setCapableZ("Enable");
                }
                try {
                    int chargingTimeInCVStage;
                    int capableB = VolUtil.parseInt(qdiArr[19]);
                    if (capableB == 0) {
                        defaultData.setCapableB("Disable");
                    } else {
                        defaultData.setCapableB("Enable");
                    }
                    int capableK = VolUtil.parseInt(qdiArr[20]);
                    if (capableK == 0) {
                        if (this.getProtocol().getAxpert().equals("024") || this.getProtocol().getAxpert().equals("023")) {
                            defaultData.setCapableK("Enable");
                        } else {
                            defaultData.setCapableK("Disable");
                        }
                    } else {
                        defaultData.setCapableK("Enable");
                    }
                    String[] modes = new String[]{"Single", "Parallel", "Phase R of 3 phase output", "Phase S of 3 phase output", "Phase T of 3 phase output"};
                    int outputmode = VolUtil.parseInt(qdiArr[21]);
                    if (outputmode >= 0 && outputmode <= 4) {
                        defaultData.setOutputMode(modes[outputmode]);
                    }
                    defaultData.setReDischargeVoltage(VolUtil.parseDouble(qdiArr[22]));
                    defaultData.setBatReDischargeCapacity(VolUtil.parseInt(qdiArr[22]));
                    int allpvok = VolUtil.parseInt(qdiArr[23]);
                    int solarbalance = VolUtil.parseInt(qdiArr[24]);
                    if (allpvok == 0) {
                        defaultData.setAllpvok("Disable");
                    } else {
                        defaultData.setAllpvok("Enable");
                    }
                    if (solarbalance == 0) {
                        defaultData.setSolarbalance("Disable");
                    } else {
                        defaultData.setSolarbalance("Enable");
                    }
                    if (qdiArr.length >= 26) {
                        System.out.println(String.valueOf(qdiArr.length));
                        System.out.println(String.valueOf(qdiArr[25]));
                        chargingTimeInCVStage = VolUtil.parseInt(qdiArr[25]);
                        if (chargingTimeInCVStage == 0) {
                            defaultData.setChargingTimeInCVStage("Auto");
                        } else {
                            defaultData.setChargingTimeInCVStage(String.valueOf(chargingTimeInCVStage));
                        }
                    }
                    if (qdiArr.length >= 26 && (this._protocol.getAxpert().equals("023") || this._protocol.getAxpert().equals("024"))) {
                        chargingTimeInCVStage = VolUtil.parseInt(qdiArr[25]);
                    }
                    if (qdiArr.length >= 27) {
                        int operationLogic = VolUtil.parseInt(qdiArr[26]);
                        if (operationLogic == 0) {
                            defaultData.setOperationLogic("Automatically(AUT)");
                        } else if (operationLogic == 1) {
                            defaultData.setOperationLogic("Online mode(ONL)");
                        } else if (operationLogic == 2) {
                            defaultData.setOperationLogic("ECO Mode(ECO)");
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                result = false;
                e.printStackTrace();
            }
        }
        return result;
    }

    @Override
    public boolean supportSelfTest() {
        return false;
    }
}

