/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.comusbprocessor;

import cn.com.voltronic.solar.communicate.IComUSBHandler;
import cn.com.voltronic.solar.communicate.ICommunicateDevice;
import cn.com.voltronic.solar.comusbprocessor.P30ComUSBProcessor;
import cn.com.voltronic.solar.control.P30PlusDuoComUSBControlModule;
import cn.com.voltronic.solar.data.bean.ConfigData;
import cn.com.voltronic.solar.data.bean.DefaultData;
import cn.com.voltronic.solar.data.bean.MachineInfo;
import cn.com.voltronic.solar.data.bean.WorkInfo;
import cn.com.voltronic.solar.protocol.IProtocol;
import cn.com.voltronic.solar.protocol.P30;
import cn.com.voltronic.solar.system.GlobalVariables;
import cn.com.voltronic.solar.util.VolUtil;
import cn.com.voltronic.solar.view.ParameterJDialog;
import java.util.Date;

public class P30PlusDuoComUSBProcessor
extends P30ComUSBProcessor {
    public P30PlusDuoComUSBProcessor(ICommunicateDevice handler, IProtocol protocol) {
        super(handler, protocol);
    }

    @Override
    protected void initControlModule() {
        this._control = new P30PlusDuoComUSBControlModule(this.getHandler());
    }

    @Override
    public boolean pollQuery() {
        boolean result = true;
        IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
        if (handler == null) {
            this.close();
            return false;
        }
        if (this.refreshConfig) {
            this.getProtocol().setDelayChanging(true);
            this.queryMachineInfo();
            this.queryConfigData();
            this.queryCapability();
            this.refreshConfig = false;
        }
        if (this.bfirsttime) {
            this._preparalleltype = this._paralleltype;
            this.bfirsttime = false;
        } else if (this._preparalleltype != this._paralleltype) {
            this.close();
            return false;
        }
        if (!ParameterJDialog.startQueryThread) {
            this.getProtocol().setDelayChanging(false);
        }
        if (!this.getSerialNo().equals(handler.getSerialNo())) {
            this.close();
            return false;
        }
        if (this._paralleltype != 0) {
            return this.pollQueryParallel();
        }
        WorkInfo workInfo = (WorkInfo)this.getBeanBag().getBean("workinfo");
        try {
            String ret;
            MachineInfo machineInfo;
            String qpigs2;
            String qpigsStr;
            workInfo.setProdid(this._protocol.getProtocolID());
            workInfo.setSerialno(handler.getSerialNo());
            workInfo.setCurrentTime(new Date());
            workInfo.setMachineType(this.getProtocol().getMachineType());
            String qmodStrs = handler.excuteCommand("QMOD", true);
            if (!"".equals(qmodStrs) && !qmodStrs.equals("(NAK")) {
                String qmodStr = qmodStrs.substring(1);
                String workMode = "Standby Mode";
                if (qmodStr.equals("P")) {
                    workMode = "Power On Mode";
                } else if (qmodStr.equals("S")) {
                    workMode = "Standby Mode";
                } else if (qmodStr.equals("L")) {
                    workMode = "Line Mode";
                } else if (qmodStr.equals("B")) {
                    workMode = "Battery Mode";
                } else if (qmodStr.equals("F")) {
                    workMode = "Fault Mode";
                } else if (qmodStr.equals("D")) {
                    workMode = "Shutdown Mode";
                }
                workInfo.setWorkMode(workMode);
            }
            if (!"".equals(qpigsStr = handler.excuteCommand("QPIGS", true)) && !qpigsStr.equals("(NAK")) {
                char ch3;
                char ch2;
                String[] qpigsArr = qpigsStr.split(" ");
                double gridVoltageR = VolUtil.parseDouble(qpigsArr[0].substring(1));
                if (gridVoltageR <= 30.0) {
                    gridVoltageR = 0.0;
                }
                workInfo.setGridVoltageR(gridVoltageR);
                double gridFrequency = VolUtil.parseDouble(qpigsArr[1]);
                workInfo.setGridFrequency(gridFrequency);
                double acOutputVoltageR = VolUtil.parseDouble(qpigsArr[2]);
                workInfo.setAcOutputVoltageR(acOutputVoltageR);
                double acOutputFrequency = VolUtil.parseDouble(qpigsArr[3]);
                workInfo.setAcOutputFrequency(acOutputFrequency);
                double acOutputApparentPower = VolUtil.parseDouble(qpigsArr[4]);
                workInfo.setAcOutputApparentPower(acOutputApparentPower);
                double acOutputActivePower = VolUtil.parseDouble(qpigsArr[5]);
                workInfo.setAcOutputActivePower(acOutputActivePower);
                int outputLoadPercent = VolUtil.parseInt(qpigsArr[6]);
                workInfo.setOutputLoadPercent(outputLoadPercent);
                double pBusVoltage = VolUtil.parseDouble(qpigsArr[7]);
                workInfo.setPBUSVoltage(pBusVoltage);
                double pBatteryVoltage = VolUtil.parseDouble(qpigsArr[8]);
                workInfo.setPBatteryVoltage(pBatteryVoltage);
                double chargingCurrent = VolUtil.parseDouble(qpigsArr[9]);
                workInfo.setChargingCurrent(chargingCurrent);
                int batteryCapacity = VolUtil.parseInt(qpigsArr[10]);
                workInfo.setBatteryCapacity(batteryCapacity);
                double pvInputVoltage1 = VolUtil.parseDouble(qpigsArr[13]);
                workInfo.setPvInputVoltage1(pvInputVoltage1);
                int pvInputCurrent = VolUtil.parseInt(qpigsArr[12]);
                workInfo.setPvInputCurrent1(pvInputCurrent);
                try {
                    int pvInputPower1 = VolUtil.parseInt(qpigsArr[19]);
                    workInfo.setPvInputPower1(pvInputPower1);
                }
                catch (Exception pvInputPower1) {
                    // empty catch block
                }
                double batVolSCC1 = VolUtil.parseDouble(qpigsArr[14]);
                workInfo.setBatVolSCC1(batVolSCC1);
                int batDischargeCurrent = VolUtil.parseInt(qpigsArr[15]);
                workInfo.setBatDisCurrent(batDischargeCurrent);
                String deviceStatus = qpigsArr[16];
                char ch0 = deviceStatus.charAt(0);
                if (ch0 == '1') {
                    workInfo.setCustomerV("1");
                } else {
                    workInfo.setCustomerV("0");
                }
                char ch1 = deviceStatus.charAt(1);
                if (ch1 == '1') {
                    this.getProtocol().setDelayChanging(true);
                    this.queryMachineInfo();
                    this.queryCapability();
                    this.queryConfigData();
                }
                if ((ch2 = deviceStatus.charAt(2)) == '1') {
                    this.queryMachineInfo();
                }
                if ((ch3 = deviceStatus.charAt(3)) == '1') {
                    workInfo.setHasLoad(true);
                } else {
                    workInfo.setHasLoad(false);
                }
                char ch5 = deviceStatus.charAt(5);
                if (ch5 == '1') {
                    workInfo.setChargeOn(true);
                } else {
                    workInfo.setChargeOn(false);
                }
                char ch6 = deviceStatus.charAt(6);
                if (ch6 == '1') {
                    workInfo.setSCCchargeOn(true);
                } else {
                    workInfo.setSCCchargeOn(false);
                }
                char ch7 = deviceStatus.charAt(7);
                if (ch7 == '1') {
                    workInfo.setACchargeOn(true);
                } else {
                    workInfo.setACchargeOn(false);
                }
                if (workInfo.isChargeOn()) {
                    if (workInfo.isSCCchargeOn() && workInfo.isACchargeOn()) {
                        workInfo.setChargeSource("Solar and Utility");
                    } else if (workInfo.isSCCchargeOn()) {
                        workInfo.setChargeSource("Solar");
                    } else if (workInfo.isACchargeOn()) {
                        workInfo.setChargeSource("Utility");
                    }
                } else {
                    workInfo.setChargeSource("---");
                }
                if (workInfo.isHasLoad()) {
                    if (workInfo.getWorkMode().equals("Line Mode")) {
                        workInfo.setLoadSource("Utility");
                    } else if (workInfo.getWorkMode().equals("Battery Mode")) {
                        workInfo.setLoadSource("Battery");
                    }
                } else {
                    workInfo.setLoadSource("---");
                }
            }
            if (this.notEmpty(qpigs2 = handler.excuteCommand("QPIGS2", true))) {
                String[] qpigs2Arr = qpigs2.split(" ");
                int pvInputCurrent2 = VolUtil.parseInt(qpigs2Arr[0].substring(1));
                workInfo.setPvInputCurrent2(pvInputCurrent2);
                double pvInputVoltage2 = VolUtil.parseDouble(qpigs2Arr[1]);
                workInfo.setPvInputVoltage2(pvInputVoltage2);
                double batVolSCC2 = VolUtil.parseDouble(qpigs2Arr[2]);
                workInfo.setBatVolSCC2(batVolSCC2);
                int pvInputPower2 = VolUtil.parseInt(qpigs2Arr[3]);
                workInfo.setPvInputPower2(pvInputPower2);
                String deviceStatus = qpigs2Arr[4];
                workInfo.setSCCchargeOn2(deviceStatus.charAt(0) == '1');
                double gridCurrentR = VolUtil.parseDouble(qpigs2Arr[5]);
                workInfo.setGridCurrentR(gridCurrentR);
                double gridPowerR = VolUtil.parseDouble(qpigs2Arr[6]);
                workInfo.setGridPowerR(gridPowerR);
            }
            if (!workInfo.isSCCchargeOn()) {
                workInfo.setPvInputVoltage1(0.0);
                workInfo.setPvInputCurrent1(0.0);
                workInfo.setPvInputPower1(0);
            }
            if (!workInfo.isSCCchargeOn2()) {
                workInfo.setPvInputVoltage2(0.0);
                workInfo.setPvInputCurrent2(0.0);
                workInfo.setPvInputPower2(0);
            }
            if (P30.is4to5k((machineInfo = (MachineInfo)this.getBeanBag().getBean("machineinfo")).getAcOutputRatingApparentPower()) && !"".equals(ret = handler.excuteCommand("QPGS0", true)) && !ret.equals("(NAK")) {
                boolean isExsit;
                String[] item = ret.split(" ");
                boolean bl = isExsit = item[0].charAt(1) == '1';
                if (isExsit) {
                    String qp2gsn0 = handler.excuteCommand("QP2GS0", true);
                    if (this.notEmpty(qp2gsn0)) {
                        String[] attr = qp2gsn0.split(" ");
                        WorkInfo faultInfo = (WorkInfo)this.getBeanBag().getBean("workfault");
                        faultInfo.setPvInputVoltage2(VolUtil.parseDouble(attr[2]));
                    }
                    this.explainQPGSN0(this, item);
                }
            }
        }
        catch (Exception ex) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean pollQueryStatus() {
        boolean result = true;
        IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
        if (handler == null) {
            return false;
        }
        if (this._paralleltype != 2) {
            WorkInfo workinfo = (WorkInfo)this.getBeanBag().getBean("workinfo");
            try {
                workinfo.setProdid(this._protocol.getProtocolID());
                workinfo.setSerialno(this.getProtocol().getSerialNo());
                workinfo.setCurrentTime(new Date());
                String qpiws = handler.excuteCommand("QPIWS", true);
                if (!"".equals(qpiws) && !qpiws.equals("(NAK") && this.isQPIWS(qpiws)) {
                    String qpiwsStr = qpiws.substring(1);
                    this.hasFault = qpiwsStr.charAt(1) == '1';
                    if (qpiwsStr.charAt(15) == '1') {
                        workinfo.setOverLoad(true);
                    } else {
                        workinfo.setOverLoad(false);
                    }
                    this.warnsHandler(qpiwsStr, 2, "2001", workinfo);
                    this.warnsHandler(qpiwsStr, 3, "2002", workinfo);
                    this.warnsHandler(qpiwsStr, 4, "2003", workinfo);
                    this.warnsHandler(qpiwsStr, 5, "2004", workinfo);
                    this.warnsHandler(qpiwsStr, 6, "2005", workinfo);
                    this.warnsHandler(qpiwsStr, 7, "2006", workinfo);
                    this.warnsHandler(qpiwsStr, 8, "2007", workinfo);
                    this.warnsHandler(qpiwsStr, 9, "2008", workinfo, this.hasFault, "1011");
                    this.warnsHandler(qpiwsStr, 10, "2009", workinfo, this.hasFault, "1001");
                    this.warnsHandler(qpiwsStr, 11, "2010", workinfo, this.hasFault, "1002");
                    this.warnsHandler(qpiwsStr, 12, "2011", workinfo);
                    this.warnsHandler(qpiwsStr, 13, "2012", workinfo);
                    this.warnsHandler(qpiwsStr, 14, "2013", workinfo);
                    this.warnsHandler(qpiwsStr, 15, "2014", workinfo);
                    this.warnsHandler(qpiwsStr, 16, "2015", workinfo, this.hasFault, "1003");
                    this.warnsHandler(qpiwsStr, 18, "1004", workinfo);
                    this.warnsHandler(qpiwsStr, 19, "1005", workinfo);
                    this.warnsHandler(qpiwsStr, 20, "1006", workinfo);
                    this.warnsHandler(qpiwsStr, 21, "1007", workinfo);
                    this.warnsHandler(qpiwsStr, 22, "1008", workinfo);
                    this.warnsHandler(qpiwsStr, 23, "1009", workinfo);
                    this.warnsHandler(qpiwsStr, 24, "1010", workinfo);
                    this.warnsHandler(qpiwsStr, 25, "2017", workinfo);
                    this.warnsHandler(qpiwsStr, 26, "2018", workinfo);
                    this.warnsHandler(qpiwsStr, 27, "2020", workinfo);
                    this.warnsHandler(qpiwsStr, 28, "2022", workinfo);
                    this.warnsHandler(qpiwsStr, 29, "2024", workinfo);
                    this.warnsHandler(qpiwsStr, 30, "2019", workinfo);
                    this.warnsHandler(qpiwsStr, 31, "2021", workinfo);
                    this.warnsHandler(qpiwsStr, 32, "2023", workinfo);
                    this.warnsHandler(qpiwsStr, 33, "2025", workinfo);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                result = false;
            }
        }
        return result;
    }

    @Override
    public boolean queryMachineInfo() {
        IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
        if (handler == null) {
            return false;
        }
        boolean result = true;
        MachineInfo machineInfo = (MachineInfo)this.getBeanBag().getBean("machineinfo");
        try {
            String eqInfo;
            String qpiriStr;
            String scc3cpuversion;
            String scc2cpuversion;
            String scc1cpuversion;
            machineInfo.setSerialno(handler.getSerialNo());
            String mainFirmwareVersion = handler.excuteCommand("QVFW", true);
            if (this.notEmpty(mainFirmwareVersion)) {
                machineInfo.setMainFirmwareVersion(mainFirmwareVersion.substring(7).trim());
            }
            if (this.notEmpty(scc1cpuversion = handler.excuteCommand("QVFW2", true))) {
                int index = scc1cpuversion.indexOf(":") + 1;
                machineInfo.setScc1CpuFirmwareVersion(scc1cpuversion.substring(index).trim());
            }
            if (this.notEmpty(scc2cpuversion = handler.excuteCommand("QVFW3", true))) {
                int index = scc2cpuversion.indexOf(":") + 1;
                machineInfo.setScc2CpuFirmwareVersion(scc2cpuversion.substring(index).trim());
            }
            if (this.notEmpty(scc3cpuversion = handler.excuteCommand("QVFW4", true))) {
                int index = scc3cpuversion.indexOf(":") + 1;
                machineInfo.setScc3CpuFirmwareVersion(scc3cpuversion.substring(index).trim());
            }
            if (!"".equals(qpiriStr = handler.excuteCommand("QPIRI", true)) && !qpiriStr.equals("(NAK")) {
                String[] ratingInfo = qpiriStr.split(" ");
                double gridRatingVoltage = VolUtil.parseDouble(ratingInfo[0].substring(1));
                double gridRatingCurrent = VolUtil.parseDouble(ratingInfo[1]);
                double acOutputRatingVoltage = VolUtil.parseDouble(ratingInfo[2]);
                double acOutputRatingFrequency = VolUtil.parseDouble(ratingInfo[3]);
                double acOutputRatingCurrent = VolUtil.parseDouble(ratingInfo[4]);
                double acOutputRatingApparentPower = VolUtil.parseDouble(ratingInfo[5]);
                double acOutputRatingActivePower = VolUtil.parseDouble(ratingInfo[6]);
                double batteryRatingVoltage = VolUtil.parseDouble(ratingInfo[7]);
                String batteryTypeStr = ratingInfo[12];
                double perMPPTRatingCurrent = VolUtil.parseDouble(ratingInfo[13]);
                String inputVoltageRangeStr = ratingInfo[15];
                String outputSourceStr = ratingInfo[16];
                String chargeSourceStr = ratingInfo[17];
                String machineTypeStr = ratingInfo[19];
                String topologyStr = ratingInfo[20];
                machineInfo.setGridRatingVoltage(gridRatingVoltage);
                machineInfo.setGridRatingCurrent(gridRatingCurrent);
                machineInfo.setAcOutputRatingVoltage(acOutputRatingVoltage);
                machineInfo.setAcOutputRatingFrequency(acOutputRatingFrequency);
                machineInfo.setAcOutputRatingCurrent(acOutputRatingCurrent);
                machineInfo.setAcOutputRatingApparentPower(acOutputRatingApparentPower);
                machineInfo.setAcOutputRatingActivePower(acOutputRatingActivePower);
                machineInfo.setBatteryRatingVoltage(batteryRatingVoltage);
                machineInfo.setPerMPPTRatingCurrent(perMPPTRatingCurrent);
                String batteryType = "---";
                if (batteryTypeStr.equals("0")) {
                    batteryType = "AGM";
                } else if (batteryTypeStr.equals("1")) {
                    batteryType = "Flooded";
                }
                machineInfo.setBatteryType(batteryType);
                String inputVoltageRange = "---";
                if (inputVoltageRangeStr.equals("0")) {
                    inputVoltageRange = "Appliance";
                } else if (inputVoltageRangeStr.equals("1")) {
                    inputVoltageRange = "UPS";
                }
                int outputmode = Integer.parseInt(ratingInfo[21]);
                this._protocol.setOutputMode(outputmode);
                this._outputmode = outputmode;
                this._paralleltype = 0;
                if (outputmode != 0) {
                    this._paralleltype = 1;
                    this._parallelnum = VolUtil.parseInt(ratingInfo[18]);
                } else {
                    this._paralleltype = 0;
                }
                machineInfo.setInputVoltageRange(inputVoltageRange);
                String outputSource = "---";
                if (outputSourceStr.equals("0")) {
                    outputSource = "Utility";
                } else if (outputSourceStr.equals("1")) {
                    outputSource = "Solar";
                }
                machineInfo.setOutputSource(outputSource);
                String chargeSource = "---";
                if (chargeSourceStr.equals("0")) {
                    chargeSource = "Utility";
                } else if (chargeSourceStr.equals("1")) {
                    chargeSource = "Solar";
                } else if (chargeSourceStr.equals("2")) {
                    chargeSource = "Solar and Utility";
                }
                machineInfo.setChargeSource(chargeSource);
                String machineType = "---";
                if (machineTypeStr.equals("00")) {
                    machineType = "Grid tie";
                } else if (machineTypeStr.equals("01")) {
                    machineType = "Stand alone";
                } else if (machineTypeStr.equals("10")) {
                    machineType = "Hybrid";
                } else if (machineTypeStr.equals("11")) {
                    machineType = "Stand alone";
                    machineInfo.setMpptTrackNumber(2);
                } else if (machineTypeStr.equals("20")) {
                    machineType = "Stand alone";
                    machineInfo.setMpptTrackNumber(3);
                }
                machineInfo.setMachineType(machineType);
                String topology = "---";
                if (topologyStr.equals("0")) {
                    topology = "Transformerless";
                } else if (topologyStr.equals("1")) {
                    topology = "Transformer";
                }
                machineInfo.setTopology(topology);
            }
            if (!P30.is1to3k(machineInfo.getAcOutputRatingApparentPower()) && P30.is4to5k(machineInfo.getAcOutputRatingApparentPower())) {
                double maxSolarChargingCurrent = this._protocol.getMpptTrackNumber() * 60;
                machineInfo.setMaxSolarChargingCurrent(maxSolarChargingCurrent);
            }
            if (!"".equals(eqInfo = handler.excuteCommand("QBEQI", true)) && !eqInfo.equals("(NAK")) {
                machineInfo.setSupportEQ(true);
            } else {
                machineInfo.setSupportEQ(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    @Override
    public boolean queryConfigData() {
        boolean result = true;
        try {
            String qbeqiStr;
            String qcvt;
            String qcst;
            String qmschgcr;
            ConfigData configdata = (ConfigData)this.getBeanBag().getBean("configdata");
            MachineInfo machine = (MachineInfo)this.getBeanBag().getBean("machineinfo");
            IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
            if (handler == null) {
                throw new Exception("handler is null");
            }
            String qpiriStr = handler.excuteCommand("QPIRI", true);
            if (!"".equals(qpiriStr) && !qpiriStr.equals("(NAK")) {
                String qpacchargstr;
                String[] ratingInfo = qpiriStr.split(" ");
                String outputVoltage = ratingInfo[2];
                configdata.setOutputVoltage(outputVoltage.substring(0, 3));
                String outputFrequency = ratingInfo[3];
                configdata.setOutputFrequency(outputFrequency.substring(0, 2));
                configdata.setBatteryVoltage(VolUtil.parseDouble(ratingInfo[7]));
                configdata.setRechargeVoltage(VolUtil.parseDouble(ratingInfo[8]));
                double batteryUnder = VolUtil.parseDouble(ratingInfo[9]);
                configdata.setBatteryUnder(batteryUnder);
                if (configdata.getBatteryVoltage() > 40.0) {
                    configdata.setMinBatteryUnder(40.0);
                    configdata.setMaxBatteryUnder(48.0);
                } else if (configdata.getBatteryVoltage() > 20.0) {
                    configdata.setMinBatteryUnder(20.0);
                    configdata.setMaxBatteryUnder(24.0);
                } else {
                    configdata.setMinBatteryUnder(10.0);
                    configdata.setMaxBatteryUnder(12.0);
                }
                String batteryTypeStr = ratingInfo[12];
                String batteryType = "AGM";
                if (batteryTypeStr.equals("0")) {
                    batteryType = "AGM";
                } else if (batteryTypeStr.equals("1")) {
                    batteryType = "Flooded";
                } else if (batteryTypeStr.equals("2")) {
                    batteryType = "User";
                }
                configdata.setBatteryType(batteryType);
                double maxChargeCurrent = VolUtil.parseDouble(ratingInfo[13]);
                double currentChargeCurrent = VolUtil.parseDouble(ratingInfo[14]);
                configdata.setMaxChargeCurrent(currentChargeCurrent);
                configdata.setMinMaxChargeCurrent(10.0);
                if (machine.isChargeCurrentComBox()) {
                    configdata.setMaxacchargingcurrent(maxChargeCurrent);
                } else {
                    configdata.setMaxMaxChargeCurrent(maxChargeCurrent);
                }
                double maxChargeVoltage = VolUtil.parseDouble(ratingInfo[10]);
                configdata.setMaxChargeVoltage(maxChargeVoltage);
                if (configdata.getBatteryVoltage() > 40.0) {
                    configdata.setMinMaxChargeVoltage(48.0);
                    configdata.setMaxMaxChargeVoltage(58.4);
                } else if (configdata.getBatteryVoltage() > 20.0) {
                    configdata.setMinMaxChargeVoltage(24.0);
                    configdata.setMaxMaxChargeVoltage(29.21);
                } else {
                    configdata.setMinMaxChargeVoltage(12.0);
                    configdata.setMaxMaxChargeVoltage(14.6);
                }
                double floatChargVoltage = VolUtil.parseDouble(ratingInfo[11]);
                configdata.setFloatingChargeVoltage(floatChargVoltage);
                if (configdata.getBatteryVoltage() > 40.0) {
                    configdata.setMinFloatingChargeVoltage(48.0);
                    configdata.setMaxFloatingChargeVoltage(58.4);
                } else if (configdata.getBatteryVoltage() > 20.0) {
                    configdata.setMinFloatingChargeVoltage(24.0);
                    configdata.setMaxFloatingChargeVoltage(29.21);
                } else {
                    configdata.setMinFloatingChargeVoltage(12.0);
                    configdata.setMaxFloatingChargeVoltage(14.6);
                }
                String inputVoltageRangeStr = ratingInfo[15];
                String outputSourceStr = ratingInfo[16];
                String chargeSourceStr = ratingInfo[17];
                String inputVoltageRange = "Appliance";
                if (inputVoltageRangeStr.equals("0")) {
                    inputVoltageRange = "Appliance";
                } else if (inputVoltageRangeStr.equals("1")) {
                    inputVoltageRange = "UPS";
                }
                int outputmode = Integer.parseInt(ratingInfo[21]);
                this._protocol.setOutputMode(outputmode);
                this._paralleltype = 0;
                if (VolUtil.round(VolUtil.parseDouble(ratingInfo[22]), 0) == 0.0) {
                    configdata.setReDischargeVoltage("FULL");
                } else {
                    configdata.setReDischargeVoltage(ratingInfo[22]);
                }
                if (VolUtil.parseInt(ratingInfo[23]) == 1) {
                    configdata.setAllpvok(true);
                } else {
                    configdata.setAllpvok(false);
                }
                if (VolUtil.parseInt(ratingInfo[24]) == 1) {
                    configdata.setSolarbalance(true);
                } else {
                    configdata.setSolarbalance(false);
                }
                configdata.setAcInputRange(inputVoltageRange);
                String outputSource = "Utility";
                if (outputSourceStr.equals("0")) {
                    outputSource = "Utility";
                } else if (outputSourceStr.equals("1")) {
                    outputSource = "Solar";
                } else if (outputSourceStr.equals("2")) {
                    outputSource = "SBU";
                }
                configdata.setOutputSource(outputSource);
                String chargeSource = "Utility";
                if (chargeSourceStr.equals("0")) {
                    chargeSource = "Utility";
                } else if (chargeSourceStr.equals("1")) {
                    chargeSource = "Solar first";
                } else if (chargeSourceStr.equals("2")) {
                    chargeSource = "Utility and Solar";
                } else if (chargeSourceStr.equals("3")) {
                    chargeSource = "Solar only";
                }
                configdata.setChargerSource(chargeSource);
                qpiriStr = handler.excuteCommand("QMCHGCR", true);
                String qpiri = handler.excuteCommand("QPIRI", true);
                if (this.notEmpty(qpiri)) {
                    String[] item = qpiri.split(" ");
                    double acOutputRatingApparentPower = VolUtil.parseDouble(item[5]);
                    String machineType = item[19];
                    if (this.is4to5k(acOutputRatingApparentPower) && machineType.equals("11")) {
                        qpiriStr = "(010 020 030 040 050 060 070 080 090 100 110 120 130 140 150 160 170 180";
                    } else if (this.is4to5k(acOutputRatingApparentPower) && machineType.equals("20")) {
                        qpiriStr = "(010 020 030 040 050 060 070 080 090 100 110 120 130 140 150 160 170 180 190 200 210 220 230 240";
                    }
                }
                if (this.notEmpty(qpiriStr)) {
                    ratingInfo = qpiriStr.substring(1).split(" ");
                    if (machine.isChargeCurrentComBox()) {
                        int index = 0;
                        while (index < ratingInfo.length) {
                            try {
                                ratingInfo[index] = String.format("%d", Integer.parseInt(ratingInfo[index]));
                            }
                            catch (Exception acOutputRatingApparentPower) {
                                // empty catch block
                            }
                            ++index;
                        }
                        configdata.setChargingCurrentComBox(ratingInfo);
                    } else {
                        configdata.setMinMaxChargeCurrent(VolUtil.parseDouble(ratingInfo[0].substring(1)));
                        configdata.setMaxMaxChargeCurrent(VolUtil.parseDouble(ratingInfo[1]));
                    }
                }
                if (this.notEmpty(qpacchargstr = handler.excuteCommand("QMUCHGCR", true))) {
                    ratingInfo = qpacchargstr.substring(1).split(" ");
                    int index = 0;
                    while (index < ratingInfo.length) {
                        try {
                            ratingInfo[index] = String.format("%d", Integer.parseInt(ratingInfo[index]));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++index;
                    }
                    configdata.setAcChargingCurrentComBox(ratingInfo);
                    GlobalVariables.setSPforVM3000Plus(false);
                    try {
                        GlobalVariables.setSPforVM3000Plus(Integer.parseInt(ratingInfo[ratingInfo.length - 1]) < 40);
                    }
                    catch (Exception e) {
                        GlobalVariables.setSPforVM3000Plus(false);
                    }
                }
            }
            if (this.notEmpty(qmschgcr = handler.excuteCommand("QMSCHGCR", true))) {
                String[] attr = qmschgcr.substring(1).split(" ");
                int index = 0;
                while (index < attr.length) {
                    try {
                        attr[index] = String.format("%d", Integer.parseInt(attr[index]));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ++index;
                }
                configdata.setMaxSolarChargingCurrentCombox(attr);
            }
            if (this.notEmpty(qcst = handler.excuteCommand("QCST", true))) {
                if ((qcst = qcst.substring(1)).equals("00")) {
                    qcst = "Auto";
                } else if (qcst.equals("01")) {
                    qcst = "2-stage";
                } else if (qcst.equals("02")) {
                    qcst = "3-stage";
                }
                configdata.setChargingStage(qcst);
            }
            if (this.notEmpty(qcvt = handler.excuteCommand("QCVT", true))) {
                if ((qcvt = qcvt.substring(1)).equals("255")) {
                    qcvt = "Auto";
                }
                configdata.setChargingTimeInCvMode(qcvt);
            }
            if (this.notEmpty(qbeqiStr = handler.excuteCommand("QBEQI", true))) {
                String[] qbeqi = qbeqiStr.substring(1).split(" ");
                configdata.setEnableEq(qbeqi[0].equals("1"));
                configdata.setEqTime(VolUtil.parseInt(qbeqi[1]));
                configdata.setMinEqTime(5);
                configdata.setMaxEqTime(900);
                configdata.setEqPeriod(VolUtil.parseInt(qbeqi[2]));
                configdata.setMinEqPeriod(0);
                configdata.setMaxEqPeriod(90);
                configdata.setEqVoltage(VolUtil.parseDouble(qbeqi[5]));
                String axpert = this._protocol.getAxpert();
                if (axpert.equals("018")) {
                    configdata.setMinEqVoltage(48.0);
                    configdata.setMaxEqVoltage(58.4);
                }
                configdata.setEqOverTime(VolUtil.parseInt(qbeqi[7]));
                configdata.setMinEqOverTime(5);
                configdata.setMaxEqOverTime(900);
                configdata.setActivateEq(qbeqi[8].equals("1"));
            }
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public boolean queryDefaultData() {
        IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
        if (handler == null) {
            return false;
        }
        DefaultData defaultData = (DefaultData)this.getBeanBag().getBean("defaultdata");
        boolean result = true;
        try {
            String qdiStr = handler.excuteCommand("QDI", true);
            if (!"".equals(qdiStr) && !qdiStr.equals("(NAK")) {
                String[] qdiArr = qdiStr.split(" ");
                double acOutputVoltage = VolUtil.parseDouble(qdiArr[0].substring(1));
                double acOutputFrequency = VolUtil.parseDouble(qdiArr[1]);
                defaultData.setBatteryCutoffVoltage(VolUtil.parseDouble(qdiArr[3]));
                defaultData.setFloatChargingVoltage(VolUtil.parseDouble(qdiArr[4]));
                double maxChargingVoltage = VolUtil.parseDouble(qdiArr[5]);
                defaultData.setMaxChargingVoltage(maxChargingVoltage);
                defaultData.setReChangingVoltage(VolUtil.parseDouble(qdiArr[6]));
                int maxChargingCurrent = VolUtil.parseInt(qdiArr[7]);
                defaultData.setMaxChargingCurrent(maxChargingCurrent);
                defaultData.setMaxACChargingCurrent(VolUtil.parseInt(qdiArr[2]));
                MachineInfo machineInfo = (MachineInfo)this.getBeanBag().getBean("machineinfo");
                double acOutputRatingApparentPower = machineInfo.getAcOutputRatingApparentPower();
                if (this.is4to5k(acOutputRatingApparentPower)) {
                    defaultData.setMaxChargingCurrent(VolUtil.parseInt(qdiArr[2]));
                    defaultData.setMaxACChargingCurrent(maxChargingCurrent);
                }
                int acInputVoltage = VolUtil.parseInt(qdiArr[8]);
                int outputSourcePriority = VolUtil.parseInt(qdiArr[9]);
                int chargerSourcePriority = VolUtil.parseInt(qdiArr[10]);
                int batteryType = VolUtil.parseInt(qdiArr[11]);
                int capableA = VolUtil.parseInt(qdiArr[12]);
                int capableJ = VolUtil.parseInt(qdiArr[13]);
                int capableU = VolUtil.parseInt(qdiArr[14]);
                int capableV = VolUtil.parseInt(qdiArr[15]);
                int capableX = VolUtil.parseInt(qdiArr[16]);
                int capableY = VolUtil.parseInt(qdiArr[17]);
                int capableZ = VolUtil.parseInt(qdiArr[18]);
                defaultData.setAcOutputVoltage(acOutputVoltage);
                defaultData.setAcOutputFrequency(acOutputFrequency);
                if (acInputVoltage == 0) {
                    defaultData.setAcInputVoltage("Appliance");
                } else {
                    defaultData.setAcInputVoltage("UPS");
                }
                if (outputSourcePriority == 0) {
                    defaultData.setOutputSourcePriority("Utility");
                } else if (outputSourcePriority == 1) {
                    defaultData.setOutputSourcePriority("Solar");
                } else if (outputSourcePriority == 2) {
                    defaultData.setOutputSourcePriority("SBU");
                }
                if (chargerSourcePriority == 0) {
                    defaultData.setChargerSourcePriority("Utility");
                } else if (chargerSourcePriority == 1) {
                    defaultData.setChargerSourcePriority("Solar");
                } else if (chargerSourcePriority == 2) {
                    defaultData.setChargerSourcePriority("Utility and Solar");
                } else if (chargerSourcePriority == 3) {
                    defaultData.setChargerSourcePriority("Solar only");
                }
                if (batteryType == 0) {
                    defaultData.setBatteryType("AGM");
                } else if (batteryType == 1) {
                    defaultData.setBatteryType("Flooded");
                } else if (batteryType == 2) {
                    defaultData.setBatteryType("User");
                }
                if (capableA == 0) {
                    defaultData.setCapableA("Enable");
                } else {
                    defaultData.setCapableA("Disable");
                }
                if (capableJ == 0) {
                    defaultData.setCapableJ("Disable");
                } else {
                    defaultData.setCapableJ("Enable");
                }
                if (capableU == 0) {
                    defaultData.setCapableU("Disable");
                } else {
                    defaultData.setCapableU("Enable");
                }
                if (capableV == 0) {
                    defaultData.setCapableV("Disable");
                } else {
                    defaultData.setCapableV("Enable");
                }
                if (capableX == 0) {
                    defaultData.setCapableX("Disable");
                } else {
                    defaultData.setCapableX("Enable");
                }
                if (capableY == 0) {
                    defaultData.setCapableY("Disable");
                } else {
                    defaultData.setCapableY("Enable");
                }
                if (capableZ == 0) {
                    defaultData.setCapableZ("Disable");
                } else {
                    defaultData.setCapableZ("Enable");
                }
                if (qdiArr.length >= 20) {
                    int capableB = VolUtil.parseInt(qdiArr[19]);
                    if (capableB == 0) {
                        defaultData.setCapableB("Disable");
                    } else {
                        defaultData.setCapableB("Enable");
                    }
                }
                if (qdiArr.length >= 21) {
                    int capableK = VolUtil.parseInt(qdiArr[20]);
                    if (capableK == 0) {
                        defaultData.setCapableK("Disable");
                    } else {
                        defaultData.setCapableK("Enable");
                    }
                }
                if (qdiArr.length >= 22) {
                    String[] modes = new String[]{"Single", "Parallel", "Phase R of 3 phase output", "Phase S of 3 phase output", "Phase T of 3 phase output"};
                    int outputmode = VolUtil.parseInt(qdiArr[21]);
                    if (outputmode >= 0 && outputmode <= 4) {
                        defaultData.setOutputMode(modes[outputmode]);
                    }
                }
                if (qdiArr.length >= 23) {
                    defaultData.setReDischargeVoltage(VolUtil.parseDouble(qdiArr[22]));
                }
                if (qdiArr.length >= 26) {
                    String stage = qdiArr[25];
                    if (stage.equals("0")) {
                        stage = "Auto";
                    } else if (stage.equals("1")) {
                        stage = "2-stage";
                    } else if (stage.equals("2")) {
                        stage = "3-stage";
                    }
                    defaultData.setChargingStage(stage);
                    defaultData.setMaxSolarChargingCurrent(VolUtil.parseInt(qdiArr[27]));
                    String mode = qdiArr[28];
                    if (mode.equals("255")) {
                        mode = "Auto";
                    }
                    defaultData.setChargingTimeInCvMode(mode);
                }
            }
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
        }
        return result;
    }
}

