/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.comusbprocessor;

import cn.com.voltronic.solar.communicate.IComUSBHandler;
import cn.com.voltronic.solar.communicate.ICommunicateDevice;
import cn.com.voltronic.solar.comusbprocessor.P30PlusDuoComUSBProcessor;
import cn.com.voltronic.solar.data.bean.WorkInfo;
import cn.com.voltronic.solar.protocol.IProtocol;
import cn.com.voltronic.solar.util.VolUtil;
import cn.com.voltronic.solar.view.ParameterJDialog;
import java.util.Date;

public class P30PlusTriComUSBProcessor
extends P30PlusDuoComUSBProcessor {
    public P30PlusTriComUSBProcessor(ICommunicateDevice handler, IProtocol protocol) {
        super(handler, protocol);
    }

    @Override
    public boolean pollQuery() {
        boolean result = true;
        IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
        if (handler == null) {
            this.close();
            return false;
        }
        if (!ParameterJDialog.startQueryThread) {
            this.getProtocol().setDelayChanging(false);
        }
        if (!this.getSerialNo().equals(handler.getSerialNo())) {
            this.close();
            return false;
        }
        if (this._paralleltype != 0) {
            return this.pollQueryParallel();
        }
        WorkInfo workInfo = (WorkInfo)this.getBeanBag().getBean("workinfo");
        try {
            String ret;
            String qpigs2;
            String qpigsStr;
            workInfo.setProdid(this._protocol.getProtocolID());
            workInfo.setSerialno(handler.getSerialNo());
            workInfo.setMachineType(this.getProtocol().getMachineType());
            String qmodStrs = handler.excuteCommand("QMOD", true);
            if (!"".equals(qmodStrs) && !qmodStrs.equals("(NAK")) {
                String qmodStr = qmodStrs.substring(1);
                String workMode = "Standby Mode";
                if (qmodStr.equals("P")) {
                    workMode = "Power On Mode";
                } else if (qmodStr.equals("S")) {
                    workMode = "Standby Mode";
                } else if (qmodStr.equals("L")) {
                    workMode = "Line Mode";
                } else if (qmodStr.equals("B")) {
                    workMode = "Battery Mode";
                } else if (qmodStr.equals("F")) {
                    workMode = "Fault Mode";
                } else if (qmodStr.equals("D")) {
                    workMode = "Shutdown Mode";
                }
                workInfo.setWorkMode(workMode);
            }
            if (!"".equals(qpigsStr = handler.excuteCommand("QPIGS", true)) && !qpigsStr.equals("(NAK")) {
                char ch3;
                char ch2;
                String[] qpigsArr = qpigsStr.split(" ");
                double gridVoltageR = VolUtil.parseDouble(qpigsArr[0].substring(1));
                if (gridVoltageR <= 30.0) {
                    gridVoltageR = 0.0;
                }
                workInfo.setGridVoltageR(gridVoltageR);
                double gridFrequency = VolUtil.parseDouble(qpigsArr[1]);
                workInfo.setGridFrequency(gridFrequency);
                double acOutputVoltageR = VolUtil.parseDouble(qpigsArr[2]);
                workInfo.setAcOutputVoltageR(acOutputVoltageR);
                double acOutputFrequency = VolUtil.parseDouble(qpigsArr[3]);
                workInfo.setAcOutputFrequency(acOutputFrequency);
                double acOutputApparentPower = VolUtil.parseDouble(qpigsArr[4]);
                workInfo.setAcOutputApparentPower(acOutputApparentPower);
                double acOutputActivePower = VolUtil.parseDouble(qpigsArr[5]);
                workInfo.setAcOutputActivePower(acOutputActivePower);
                int outputLoadPercent = VolUtil.parseInt(qpigsArr[6]);
                workInfo.setOutputLoadPercent(outputLoadPercent);
                double pBusVoltage = VolUtil.parseDouble(qpigsArr[7]);
                workInfo.setPBUSVoltage(pBusVoltage);
                double pBatteryVoltage = VolUtil.parseDouble(qpigsArr[8]);
                workInfo.setPBatteryVoltage(pBatteryVoltage);
                double chargingCurrent = VolUtil.parseDouble(qpigsArr[9]);
                workInfo.setChargingCurrent(chargingCurrent);
                int batteryCapacity = VolUtil.parseInt(qpigsArr[10]);
                workInfo.setBatteryCapacity(batteryCapacity);
                int pvInputCurrent = VolUtil.parseInt(qpigsArr[12]);
                workInfo.setPvInputCurrent1(pvInputCurrent);
                double pvInputVoltage1 = VolUtil.parseDouble(qpigsArr[13]);
                workInfo.setPvInputVoltage1(pvInputVoltage1);
                double batVolSCC1 = VolUtil.parseDouble(qpigsArr[14]);
                workInfo.setBatVolSCC1(batVolSCC1);
                try {
                    int pvInputPower1 = VolUtil.parseInt(qpigsArr[19]);
                    workInfo.setPvInputPower1(pvInputPower1);
                }
                catch (Exception pvInputPower1) {
                    // empty catch block
                }
                int batDischargeCurrent = VolUtil.parseInt(qpigsArr[15]);
                workInfo.setBatDisCurrent(batDischargeCurrent);
                workInfo.setCurrentTime(new Date());
                String deviceStatus = qpigsArr[16];
                char ch0 = deviceStatus.charAt(0);
                if (ch0 == '1') {
                    workInfo.setCustomerV("1");
                } else {
                    workInfo.setCustomerV("0");
                }
                char ch1 = deviceStatus.charAt(1);
                if (ch1 == '1') {
                    this.getProtocol().setDelayChanging(true);
                    this.queryMachineInfo();
                    this.queryCapability();
                    this.queryConfigData();
                }
                if ((ch2 = deviceStatus.charAt(2)) == '1') {
                    this.queryMachineInfo();
                }
                if ((ch3 = deviceStatus.charAt(3)) == '1') {
                    workInfo.setHasLoad(true);
                } else {
                    workInfo.setHasLoad(false);
                }
                char ch5 = deviceStatus.charAt(5);
                if (ch5 == '1') {
                    workInfo.setChargeOn(true);
                } else {
                    workInfo.setChargeOn(false);
                }
                char ch6 = deviceStatus.charAt(6);
                if (ch6 == '1') {
                    workInfo.setSCCchargeOn(true);
                } else {
                    workInfo.setSCCchargeOn(false);
                }
                char ch7 = deviceStatus.charAt(7);
                if (ch7 == '1') {
                    workInfo.setACchargeOn(true);
                } else {
                    workInfo.setACchargeOn(false);
                }
                if (workInfo.isChargeOn()) {
                    if (workInfo.isSCCchargeOn() && workInfo.isACchargeOn()) {
                        workInfo.setChargeSource("Solar and Utility");
                    } else if (workInfo.isSCCchargeOn()) {
                        workInfo.setChargeSource("Solar");
                    } else if (workInfo.isACchargeOn()) {
                        workInfo.setChargeSource("Utility");
                    }
                } else {
                    workInfo.setChargeSource("---");
                }
                if (workInfo.isHasLoad()) {
                    if (workInfo.getWorkMode().equals("Line Mode")) {
                        workInfo.setLoadSource("Utility");
                    } else if (workInfo.getWorkMode().equals("Battery Mode")) {
                        workInfo.setLoadSource("Battery");
                    }
                } else {
                    workInfo.setLoadSource("---");
                }
            }
            if (this.notEmpty(qpigs2 = handler.excuteCommand("QPIGS2", true))) {
                String[] qpigs2Arr = qpigs2.split(" ");
                int pvInputCurrent2 = VolUtil.parseInt(qpigs2Arr[0].substring(1));
                workInfo.setPvInputCurrent2(pvInputCurrent2);
                double pvInputVoltage2 = VolUtil.parseDouble(qpigs2Arr[1]);
                workInfo.setPvInputVoltage2(pvInputVoltage2);
                double batVolSCC2 = VolUtil.parseDouble(qpigs2Arr[2]);
                workInfo.setBatVolSCC2(batVolSCC2);
                int pvInputPower2 = VolUtil.parseInt(qpigs2Arr[3]);
                workInfo.setPvInputPower2(pvInputPower2);
                String deviceStatus = qpigs2Arr[4];
                workInfo.setSCCchargeOn2(deviceStatus.charAt(0) == '1');
                workInfo.setSCCchargeOn3(deviceStatus.charAt(1) == '1');
                double gridCurrentR = VolUtil.parseDouble(qpigs2Arr[5]);
                workInfo.setGridCurrentR(gridCurrentR);
                double gridPowerR = VolUtil.parseDouble(qpigs2Arr[6]);
                workInfo.setGridPowerR(gridPowerR);
                int pvInputCurrent3 = VolUtil.parseInt(qpigs2Arr[7]);
                workInfo.setPvInputCurrent3(pvInputCurrent3);
                double pvInputVoltage3 = VolUtil.parseDouble(qpigs2Arr[8]);
                workInfo.setPvInputVoltage3(pvInputVoltage3);
                double batVolSCC3 = VolUtil.parseDouble(qpigs2Arr[9]);
                workInfo.setBatVolSCC3(batVolSCC3);
                int pvInputPower3 = VolUtil.parseInt(qpigs2Arr[10]);
                workInfo.setPvInputPower3(pvInputPower3);
            }
            if (!workInfo.isSCCchargeOn()) {
                workInfo.setPvInputVoltage1(0.0);
                workInfo.setPvInputCurrent1(0.0);
                workInfo.setPvInputPower1(0);
            }
            if (!workInfo.isSCCchargeOn2()) {
                workInfo.setPvInputVoltage2(0.0);
                workInfo.setPvInputCurrent2(0.0);
                workInfo.setPvInputPower2(0);
            }
            if (!workInfo.isSCCchargeOn3()) {
                workInfo.setPvInputVoltage3(0.0);
                workInfo.setPvInputCurrent3(0.0);
                workInfo.setPvInputPower3(0);
            }
            if (!"".equals(ret = handler.excuteCommand("QPGS0", true)) && !ret.equals("(NAK")) {
                boolean isExsit;
                String[] item = ret.split(" ");
                boolean bl = isExsit = item[0].charAt(1) == '1';
                if (isExsit) {
                    String qp2gsn0 = handler.excuteCommand("QP2GS0", true);
                    if (this.notEmpty(qp2gsn0)) {
                        String[] attr = qp2gsn0.split(" ");
                        WorkInfo faultInfo = (WorkInfo)this.getBeanBag().getBean("workfault");
                        faultInfo.setPvInputVoltage2(VolUtil.parseDouble(attr[2]));
                        faultInfo.setPvInputVoltage3(VolUtil.parseDouble(attr[5]));
                    }
                    this.explainQPGSN0(this, item);
                }
            }
        }
        catch (Exception ex) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean pollQueryStatus() {
        boolean result = true;
        IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
        if (handler == null) {
            return false;
        }
        if (this._paralleltype != 2) {
            WorkInfo workinfo = (WorkInfo)this.getBeanBag().getBean("workinfo");
            try {
                workinfo.setProdid(this._protocol.getProtocolID());
                workinfo.setSerialno(this.getProtocol().getSerialNo());
                workinfo.setCurrentTime(new Date());
                String qpiws = handler.excuteCommand("QPIWS", true);
                if (!"".equals(qpiws) && !qpiws.equals("(NAK") && this.isQPIWS(qpiws)) {
                    String qpiwsStr = qpiws.substring(1);
                    this.hasFault = qpiwsStr.charAt(1) == '1';
                    if (qpiwsStr.charAt(15) == '1') {
                        workinfo.setOverLoad(true);
                    } else {
                        workinfo.setOverLoad(false);
                    }
                    this.warnsHandler(qpiwsStr, 2, "2001", workinfo);
                    this.warnsHandler(qpiwsStr, 3, "2002", workinfo);
                    this.warnsHandler(qpiwsStr, 4, "2003", workinfo);
                    this.warnsHandler(qpiwsStr, 5, "2004", workinfo);
                    this.warnsHandler(qpiwsStr, 6, "2005", workinfo);
                    this.warnsHandler(qpiwsStr, 7, "2006", workinfo);
                    this.warnsHandler(qpiwsStr, 8, "2007", workinfo);
                    this.warnsHandler(qpiwsStr, 9, "2008", workinfo, this.hasFault, "1011");
                    this.warnsHandler(qpiwsStr, 10, "2009", workinfo, this.hasFault, "1001");
                    this.warnsHandler(qpiwsStr, 11, "2010", workinfo, this.hasFault, "1002");
                    this.warnsHandler(qpiwsStr, 12, "2011", workinfo);
                    this.warnsHandler(qpiwsStr, 13, "2012", workinfo);
                    this.warnsHandler(qpiwsStr, 14, "2013", workinfo);
                    this.warnsHandler(qpiwsStr, 15, "2014", workinfo);
                    this.warnsHandler(qpiwsStr, 16, "2015", workinfo, this.hasFault, "1003");
                    this.warnsHandler(qpiwsStr, 18, "1004", workinfo);
                    this.warnsHandler(qpiwsStr, 19, "1005", workinfo);
                    this.warnsHandler(qpiwsStr, 20, "1006", workinfo);
                    this.warnsHandler(qpiwsStr, 21, "1007", workinfo);
                    this.warnsHandler(qpiwsStr, 22, "1008", workinfo);
                    this.warnsHandler(qpiwsStr, 23, "1009", workinfo);
                    this.warnsHandler(qpiwsStr, 24, "1010", workinfo);
                    this.warnsHandler(qpiwsStr, 25, "2017", workinfo);
                    this.warnsHandler(qpiwsStr, 26, "2018", workinfo);
                    this.warnsHandler(qpiwsStr, 27, "2021", workinfo);
                    this.warnsHandler(qpiwsStr, 28, "2024", workinfo);
                    this.warnsHandler(qpiwsStr, 29, "2027", workinfo);
                    this.warnsHandler(qpiwsStr, 30, "2019", workinfo);
                    this.warnsHandler(qpiwsStr, 31, "2022", workinfo);
                    this.warnsHandler(qpiwsStr, 32, "2025", workinfo);
                    this.warnsHandler(qpiwsStr, 33, "2028", workinfo);
                    this.warnsHandler(qpiwsStr, 34, "2020", workinfo);
                    this.warnsHandler(qpiwsStr, 35, "2023", workinfo);
                    this.warnsHandler(qpiwsStr, 36, "2026", workinfo);
                    this.warnsHandler(qpiwsStr, 37, "2029", workinfo);
                }
            }
            catch (Exception e) {
                result = false;
                workinfo.clear();
            }
        }
        return result;
    }
}

