/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.comusbprocessor;

import cn.com.voltronic.solar.communicate.IComUSBHandler;
import cn.com.voltronic.solar.communicate.ICommunicateDevice;
import cn.com.voltronic.solar.comusbprocessor.P301TO3KWComUSBProcessor;
import cn.com.voltronic.solar.data.bean.ConfigData;
import cn.com.voltronic.solar.data.bean.MachineInfo;
import cn.com.voltronic.solar.data.bean.WorkInfo;
import cn.com.voltronic.solar.protocol.IProtocol;
import cn.com.voltronic.solar.system.GlobalVariables;
import cn.com.voltronic.solar.util.VolUtil;
import cn.com.voltronic.solar.view.ParameterJDialog;
import java.util.Date;

public class P30VPComUSBProcessor
extends P301TO3KWComUSBProcessor {
    public P30VPComUSBProcessor(ICommunicateDevice handler, IProtocol protocol) {
        super(handler, protocol);
    }

    @Override
    public boolean pollQuery() {
        boolean result = true;
        IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
        if (handler == null) {
            this.close();
            return false;
        }
        if (this.refreshConfig) {
            this.getProtocol().setDelayChanging(true);
            this.queryMachineInfo();
            this.queryConfigData();
            this.queryCapability();
            this.refreshConfig = false;
        }
        if (this.bfirsttime) {
            this._preparalleltype = this._paralleltype;
            this.bfirsttime = false;
        } else if (this._preparalleltype != this._paralleltype) {
            this.close();
            return false;
        }
        if (!ParameterJDialog.startQueryThread) {
            this.getProtocol().setDelayChanging(false);
        }
        if (!this.getSerialNo().equals(handler.getSerialNo())) {
            this.close();
            return false;
        }
        WorkInfo workInfo = (WorkInfo)this.getBeanBag().getBean("workinfo");
        try {
            String qpigsStr;
            workInfo.setProdid(this._protocol.getProtocolID());
            workInfo.setSerialno(handler.getSerialNo());
            String qmodStrs = handler.excuteCommand("QMOD", true);
            if (!"".equals(qmodStrs) && !qmodStrs.equals("(NAK")) {
                String qmodStr = qmodStrs.substring(1);
                String workMode = "Standby Mode";
                if (qmodStr.equals("P")) {
                    workMode = "Power On Mode";
                } else if (qmodStr.equals("S")) {
                    workMode = "Standby Mode";
                } else if (qmodStr.equals("L")) {
                    workMode = "Line Mode";
                } else if (qmodStr.equals("B")) {
                    workMode = "Battery Mode";
                } else if (qmodStr.equals("F")) {
                    workMode = "Fault Mode";
                } else if (qmodStr.equals("D")) {
                    workMode = "Shutdown Mode";
                }
                workInfo.setWorkMode(workMode);
            }
            if (!"".equals(qpigsStr = handler.excuteCommand("QPIGS", true)) && !qpigsStr.equals("(NAK")) {
                char ch3;
                char ch2;
                char ch1;
                String[] qpigsArr = qpigsStr.split(" ");
                double gridVoltageR = VolUtil.parseDouble(qpigsArr[0].substring(1));
                workInfo.setGridVoltageR(gridVoltageR);
                double gridFrequency = VolUtil.parseDouble(qpigsArr[1]);
                workInfo.setGridFrequency(gridFrequency);
                double acOutputVoltageR = VolUtil.parseDouble(qpigsArr[2]);
                workInfo.setAcOutputVoltageR(acOutputVoltageR);
                double acOutputFrequency = VolUtil.parseDouble(qpigsArr[3]);
                workInfo.setAcOutputFrequency(acOutputFrequency);
                double acOutputApparentPower = VolUtil.parseDouble(qpigsArr[4]);
                workInfo.setAcOutputApparentPower(acOutputApparentPower);
                double acOutputActivePower = VolUtil.parseDouble(qpigsArr[5]);
                workInfo.setAcOutputActivePower(acOutputActivePower);
                int outputLoadPercent = VolUtil.parseInt(qpigsArr[6]);
                workInfo.setOutputLoadPercent(outputLoadPercent);
                double pBusVoltage = VolUtil.parseDouble(qpigsArr[7]);
                workInfo.setPBUSVoltage(pBusVoltage);
                double pBatteryVoltage = VolUtil.parseDouble(qpigsArr[8]);
                workInfo.setPBatteryVoltage(pBatteryVoltage);
                double chargingCurrent = VolUtil.parseDouble(qpigsArr[9]);
                workInfo.setChargingCurrent(chargingCurrent);
                int batteryCapacity = VolUtil.parseInt(qpigsArr[10]);
                workInfo.setBatteryCapacity(batteryCapacity);
                double pvInputVoltage1 = VolUtil.parseDouble(qpigsArr[13]);
                workInfo.setPvInputVoltage1(pvInputVoltage1);
                int pvChargingPower = VolUtil.parseInt(qpigsArr[19]);
                workInfo.setPvInputPower1(pvChargingPower);
                double pvInputCurrent = (double)pvChargingPower / (pvInputVoltage1 + 0.01);
                String pvIC = String.format("%.2f", pvInputCurrent);
                workInfo.setPvInputCurrent(VolUtil.parseDouble(pvIC));
                double pvInputCurrentForBatttery = VolUtil.parseDouble(qpigsArr[12]);
                workInfo.setPvInputCurrentForBatttery(pvInputCurrentForBatttery);
                workInfo.setPvInputCurrent(pvInputCurrentForBatttery);
                int batDischargeCurrent = VolUtil.parseInt(qpigsArr[15]);
                workInfo.setBatDisCurrent(batDischargeCurrent);
                workInfo.setCurrentTime(new Date());
                String deviceStatus = qpigsArr[16];
                char ch0 = deviceStatus.charAt(0);
                if (ch0 == '1') {
                    workInfo.setCustomerV("1");
                } else {
                    workInfo.setCustomerV("0");
                }
                if (this._protocol.isVMII()) {
                    if (ch0 == '1') {
                        workInfo.setLoadFrom(1);
                    } else {
                        workInfo.setLoadFrom(0);
                    }
                }
                if ((ch1 = deviceStatus.charAt(1)) == '1') {
                    this.getProtocol().setDelayChanging(true);
                    this.queryMachineInfo();
                    this.queryCapability();
                    this.queryConfigData();
                }
                if ((ch2 = deviceStatus.charAt(2)) == '1') {
                    this.queryMachineInfo();
                }
                if ((ch3 = deviceStatus.charAt(3)) == '1') {
                    workInfo.setHasLoad(true);
                } else {
                    workInfo.setHasLoad(false);
                }
                char ch5 = deviceStatus.charAt(5);
                if (ch5 == '1') {
                    workInfo.setChargeOn(true);
                } else {
                    workInfo.setChargeOn(false);
                }
                char ch6 = deviceStatus.charAt(6);
                if (ch6 == '1') {
                    workInfo.setSCCchargeOn(true);
                } else {
                    workInfo.setSCCchargeOn(false);
                }
                char ch7 = deviceStatus.charAt(7);
                if (ch7 == '1') {
                    workInfo.setACchargeOn(true);
                } else {
                    workInfo.setACchargeOn(false);
                }
                String axpertType = this._protocol.getAxpertType();
                if (axpertType.equals("VMII-3000") || axpertType.equals("VMII-5000") || axpertType.equals("VMII-1500") || axpertType.equals("VMIII-1500") || axpertType.equals("VMIII-3000") || axpertType.equals("VMIII-3200") || axpertType.equals("VMIII-5000") || axpertType.equals("VMIII-5200")) {
                    workInfo.setIsPVCharging(1);
                    workInfo.setIsShowChargingCurrent(1);
                } else {
                    if (ch5 == '1' && ch6 == '1' && ch7 == '0') {
                        workInfo.setIsPVCharging(1);
                    } else if (ch5 == '1' && ch6 == '1' && ch7 == '1') {
                        if (axpertType.equals("VP-5000") || axpertType.equals("VM-5000") || axpertType.equals("VP-2000") || axpertType.equals("VM-2000") || axpertType.equals("VP-1000")) {
                            workInfo.setIsPVCharging(1);
                        }
                    } else {
                        workInfo.setIsPVCharging(0);
                    }
                    workInfo.setIsShowChargingCurrent(0);
                }
                if (workInfo.isChargeOn()) {
                    if (workInfo.isSCCchargeOn() && workInfo.isACchargeOn()) {
                        workInfo.setChargeSource("Solar and Utility");
                    } else if (workInfo.isSCCchargeOn()) {
                        workInfo.setChargeSource("Solar");
                    } else if (workInfo.isACchargeOn()) {
                        workInfo.setChargeSource("Utility");
                    }
                } else {
                    workInfo.setChargeSource("---");
                }
                if (workInfo.isHasLoad()) {
                    if (workInfo.getWorkMode().equals("Line Mode")) {
                        if (this._protocol.isVMII()) {
                            if (workInfo.getLoadFrom() == 1) {
                                workInfo.setLoadSource("Solar and Utility");
                            } else {
                                workInfo.setLoadSource("Utility");
                            }
                        } else {
                            workInfo.setLoadSource("Utility");
                        }
                    } else if (workInfo.getWorkMode().equals("Battery Mode")) {
                        if (this._protocol.isVMII()) {
                            if (workInfo.isNoBattery()) {
                                workInfo.setLoadSource("Solar");
                            } else if (!workInfo.isPvLoss() && workInfo.getChargingCurrent() > 0.0) {
                                workInfo.setLoadSource("Solar and Battery");
                            } else {
                                workInfo.setLoadSource("Battery");
                            }
                        } else {
                            workInfo.setLoadSource("Battery");
                        }
                    }
                } else {
                    workInfo.setLoadSource("---");
                }
            }
        }
        catch (Exception ex) {
            result = false;
            ex.printStackTrace();
        }
        return result;
    }

    @Override
    public boolean queryConfigData() {
        boolean result;
        block68: {
            result = true;
            try {
                String qbeqiStr;
                String qpacchargstr;
                ConfigData configdata = (ConfigData)this.getBeanBag().getBean("configdata");
                MachineInfo machine = (MachineInfo)this.getBeanBag().getBean("machineinfo");
                IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
                if (handler == null) {
                    throw new Exception("handler is null");
                }
                String qpiriStr = handler.excuteCommand("QPIRI", true);
                if ("".equals(qpiriStr) || qpiriStr.equals("(NAK")) break block68;
                String[] ratingInfo = qpiriStr.split(" ");
                String outputVoltage = ratingInfo[2];
                configdata.setOutputVoltage(outputVoltage.substring(0, 3));
                String outputFrequency = ratingInfo[3];
                configdata.setOutputFrequency(outputFrequency.substring(0, 2));
                configdata.setBatteryVoltage(VolUtil.parseDouble(ratingInfo[7]));
                configdata.setRechargeVoltage(VolUtil.parseDouble(ratingInfo[8]));
                String batteryTypeStr = ratingInfo[12];
                String batteryType = "AGM";
                if (batteryTypeStr.equals("0")) {
                    batteryType = "AGM";
                } else if (batteryTypeStr.equals("1")) {
                    batteryType = "Flooded";
                } else if (batteryTypeStr.equals("2")) {
                    batteryType = "User";
                }
                configdata.setBatteryType(batteryType);
                double maxChargeCurrent = VolUtil.parseDouble(ratingInfo[13]);
                double currentChargeCurrent = VolUtil.parseDouble(ratingInfo[14]);
                configdata.setMaxChargeCurrent(currentChargeCurrent);
                configdata.setMinMaxChargeCurrent(10.0);
                if (machine.isChargeCurrentComBox()) {
                    configdata.setMaxacchargingcurrent(maxChargeCurrent);
                } else {
                    configdata.setMaxMaxChargeCurrent(maxChargeCurrent);
                }
                double maxChargeVoltage = VolUtil.parseDouble(ratingInfo[10]);
                configdata.setMaxChargeVoltage(maxChargeVoltage);
                double floatChargVoltage = VolUtil.parseDouble(ratingInfo[11]);
                configdata.setFloatingChargeVoltage(floatChargVoltage);
                double batteryUnder = VolUtil.parseDouble(ratingInfo[9]);
                configdata.setBatteryUnder(batteryUnder);
                if (this._protocol.getAxpertType().equals("VP-3000") || this._protocol.getAxpertType().equals("VM-3000") || this._protocol.getAxpertType().equals("VMII-3000") || this._protocol.getAxpertType().equals("VMII-1500") || this._protocol.getAxpertType().equals("VMIII-1500") || this._protocol.getAxpertType().equals("VMIII-3000") || this._protocol.getAxpertType().equals("VMIII-3200") || this._protocol.getAxpertType().equals("VM-3200")) {
                    configdata.setMinMaxChargeVoltage(25.0);
                    configdata.setMaxMaxChargeVoltage(31.5);
                    configdata.setMinFloatingChargeVoltage(25.0);
                    configdata.setMaxFloatingChargeVoltage(31.5);
                    configdata.setMinBatteryUnder(21.0);
                    configdata.setMaxBatteryUnder(24.0);
                } else if (this._protocol.getAxpertType().equals("VM-1000") || this._protocol.getAxpertType().equals("VM-1200")) {
                    configdata.setMinMaxChargeVoltage(12.5);
                    configdata.setMaxMaxChargeVoltage(15.0);
                    configdata.setMinFloatingChargeVoltage(12.5);
                    configdata.setMaxFloatingChargeVoltage(15.0);
                    configdata.setMinBatteryUnder(10.5);
                    configdata.setMaxBatteryUnder(12.0);
                } else if (this._protocol.getAxpertType().equals("VP-5000") || this._protocol.getAxpertType().equals("VM-5000") || this._protocol.getAxpertType().equals("VMII-5000") || this._protocol.getAxpertType().equals("VMIII-5000") || this._protocol.getAxpertType().equals("VMIII-5200")) {
                    configdata.setMinMaxChargeVoltage(48.0);
                    configdata.setMaxMaxChargeVoltage(61.0);
                    configdata.setMinFloatingChargeVoltage(48.0);
                    configdata.setMaxFloatingChargeVoltage(61.0);
                    configdata.setMinBatteryUnder(42.0);
                    configdata.setMaxBatteryUnder(48.0);
                } else if (this._protocol.getAxpertType().equals("VP-2000") || this._protocol.getAxpertType().equals("VM-2000") || this._protocol.getAxpertType().equals("VM-2200")) {
                    configdata.setMinMaxChargeVoltage(25.0);
                    configdata.setMaxMaxChargeVoltage(30.0);
                    configdata.setMinFloatingChargeVoltage(25.0);
                    configdata.setMaxFloatingChargeVoltage(30.0);
                    configdata.setMinBatteryUnder(21.0);
                    configdata.setMaxBatteryUnder(24.0);
                } else if (this._protocol.getAxpertType().equals("VP-1000")) {
                    configdata.setMinMaxChargeVoltage(12.5);
                    configdata.setMaxMaxChargeVoltage(15.0);
                    configdata.setMinFloatingChargeVoltage(12.5);
                    configdata.setMaxFloatingChargeVoltage(15.0);
                    configdata.setMinBatteryUnder(10.5);
                    configdata.setMaxBatteryUnder(12.0);
                }
                String inputVoltageRangeStr = ratingInfo[15];
                String outputSourceStr = ratingInfo[16];
                String chargeSourceStr = ratingInfo[17];
                String inputVoltageRange = "Appliance";
                if (inputVoltageRangeStr.equals("0")) {
                    inputVoltageRange = "Appliance";
                } else if (inputVoltageRangeStr.equals("1")) {
                    inputVoltageRange = "UPS";
                }
                if (ratingInfo.length > 21) {
                    try {
                        int outputmode = Integer.parseInt(ratingInfo[21]);
                        this._protocol.setOutputMode(outputmode);
                        if (outputmode != 0) {
                            this._paralleltype = 1;
                            this._parallelnum = VolUtil.parseInt(ratingInfo[18]);
                        } else {
                            this._paralleltype = 0;
                        }
                    }
                    catch (Exception outputmode) {
                        // empty catch block
                    }
                }
                if (ratingInfo.length > 22) {
                    if (VolUtil.round(VolUtil.parseDouble(ratingInfo[22]), 0) == 0.0) {
                        configdata.setReDischargeVoltage("FULL");
                    } else {
                        configdata.setReDischargeVoltage(ratingInfo[22]);
                    }
                }
                if (ratingInfo.length > 24) {
                    if (VolUtil.parseInt(ratingInfo[23]) == 1) {
                        configdata.setAllpvok(true);
                    } else {
                        configdata.setAllpvok(false);
                    }
                    if (VolUtil.parseInt(ratingInfo[24]) == 1) {
                        configdata.setSolarbalance(true);
                    } else {
                        configdata.setSolarbalance(false);
                    }
                }
                configdata.setAcInputRange(inputVoltageRange);
                String outputSource = "Utility";
                if (outputSourceStr.equals("0")) {
                    outputSource = "Utility";
                } else if (outputSourceStr.equals("1")) {
                    outputSource = "Solar";
                } else if (outputSourceStr.equals("2")) {
                    outputSource = "SBU";
                }
                configdata.setOutputSource(outputSource);
                String chargeSource = "Utility";
                if (chargeSourceStr.equals("0")) {
                    chargeSource = "Utility";
                } else if (chargeSourceStr.equals("1")) {
                    chargeSource = "Solar first";
                } else if (chargeSourceStr.equals("2")) {
                    chargeSource = "Utility and Solar";
                } else if (chargeSourceStr.equals("3")) {
                    chargeSource = "Solar only";
                }
                configdata.setChargerSource(chargeSource);
                qpiriStr = handler.excuteCommand("QMCHGCR", true);
                if (this.notEmpty(qpiriStr)) {
                    ratingInfo = qpiriStr.substring(1).split(" ");
                    if (machine.isChargeCurrentComBox()) {
                        int index = 0;
                        while (index < ratingInfo.length) {
                            try {
                                ratingInfo[index] = String.format("%d", Integer.parseInt(ratingInfo[index]));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            ++index;
                        }
                        configdata.setChargingCurrentComBox(ratingInfo);
                    } else {
                        configdata.setMinMaxChargeCurrent(VolUtil.parseDouble(ratingInfo[0].substring(1)));
                        configdata.setMaxMaxChargeCurrent(VolUtil.parseDouble(ratingInfo[1]));
                    }
                }
                if (this.notEmpty(qpacchargstr = handler.excuteCommand("QMUCHGCR", true))) {
                    ratingInfo = qpacchargstr.substring(1).split(" ");
                    int index = 0;
                    while (index < ratingInfo.length) {
                        try {
                            ratingInfo[index] = String.format("%d", Integer.parseInt(ratingInfo[index]));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++index;
                    }
                    configdata.setAcChargingCurrentComBox(ratingInfo);
                    GlobalVariables.setSPforVM3000Plus(false);
                    try {
                        GlobalVariables.setSPforVM3000Plus(Integer.parseInt(ratingInfo[ratingInfo.length - 1]) < 40);
                    }
                    catch (Exception e) {
                        GlobalVariables.setSPforVM3000Plus(false);
                    }
                }
                if (this.notEmpty(qbeqiStr = handler.excuteCommand("QBEQI", true))) {
                    String[] qbeqi = qbeqiStr.substring(1).split(" ");
                    configdata.setEnableEq(qbeqi[0].equals("1"));
                    configdata.setEqTime(VolUtil.parseInt(qbeqi[1]));
                    configdata.setMinEqTime(5);
                    configdata.setMaxEqTime(900);
                    configdata.setEqPeriod(VolUtil.parseInt(qbeqi[2]));
                    configdata.setMinEqPeriod(0);
                    configdata.setMaxEqPeriod(90);
                    configdata.setEqVoltage(VolUtil.parseDouble(qbeqi[5]));
                    String axpertType = this._protocol.getAxpertType();
                    if (axpertType.startsWith("VP") || axpertType.startsWith("VM")) {
                        if (axpertType.contains("5000")) {
                            configdata.setMinEqVoltage(48.0);
                            configdata.setMaxEqVoltage(61.0);
                        } else if (axpertType.contains("3000") || axpertType.contains("3200")) {
                            configdata.setMinEqVoltage(25.0);
                            configdata.setMaxEqVoltage(31.5);
                        } else if (axpertType.contains("2000") || axpertType.contains("2200")) {
                            configdata.setMinEqVoltage(25.0);
                            configdata.setMaxEqVoltage(30.0);
                        } else if (axpertType.contains("1000") || axpertType.contains("1200")) {
                            configdata.setMinEqVoltage(12.5);
                            configdata.setMaxEqVoltage(15.0);
                        }
                    }
                    configdata.setEqOverTime(VolUtil.parseInt(qbeqi[7]));
                    configdata.setMinEqOverTime(5);
                    configdata.setMaxEqOverTime(900);
                    configdata.setActivateEq(qbeqi[8].equals("1"));
                }
            }
            catch (Exception e) {
                result = false;
                e.printStackTrace();
            }
        }
        return result;
    }
}

