/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.console.mac;

import cn.com.voltronic.solar.console.SolarPowerTray;
import cn.com.voltronic.solar.constants.Constants;
import cn.com.voltronic.solar.debug.Debug;
import cn.com.voltronic.solar.socket.UdpClient;
import cn.com.voltronic.solar.system.GlobalVariables;
import cn.com.voltronic.solar.upgrade.StartUpgrade;
import cn.com.voltronic.solar.view.ConfigFrame;
import cn.com.voltronic.solar.view.MainJFrame;
import cn.com.voltronicpower.main.SNMPMainJFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MacMonitorTray
extends SolarPowerTray
implements MouseMotionListener,
MouseListener,
ActionListener {
    private static final long serialVersionUID = 970574584469690071L;
    private JButton configItem;
    public JButton updateOnline;
    public JButton updateByUser;
    private JButton openItem_Bt;
    private JButton exitItem_Bt;
    private JButton snmpMrg;
    private JButton debugItem;
    private JLabel name;
    private JPanel centerPanel;
    private JPanel southPanel;
    private int x = 0;
    private int y = 0;
    private Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    private boolean drag = false;
    private boolean isDrag = true;
    private boolean automaticLocate = true;
    private Color bgColor = new Color(18, 134, 255);
    private Color bgColor1 = Color.white;
    private Font font12 = new Font(null, 0, 12);

    public MacMonitorTray() {
        this.initComponents();
        this.setBounds((int)this.screenSize.getWidth() - 250, (int)this.screenSize.getHeight() - 280, 158, 172);
        this.setAlwaysOnTop(true);
        this.setBackground(this.bgColor);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.setVisible(true);
    }

    private void initComponents() {
        this.centerPanel = new JPanel();
        this.configItem = new JButton();
        this.updateOnline = new JButton();
        this.updateByUser = new JButton();
        this.snmpMrg = new JButton();
        this.debugItem = new JButton();
        this.openItem_Bt = new JButton();
        this.exitItem_Bt = new JButton();
        this.southPanel = new JPanel();
        this.name = new JLabel();
        this.icon = new JLabel();
        this.configItem.setCursor(new Cursor(12));
        this.updateOnline.setCursor(new Cursor(12));
        this.updateByUser.setCursor(new Cursor(12));
        this.snmpMrg.setCursor(new Cursor(12));
        this.debugItem.setCursor(new Cursor(12));
        this.openItem_Bt.setCursor(new Cursor(12));
        this.exitItem_Bt.setCursor(new Cursor(12));
        this.configItem.setText("Configuration");
        this.configItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigFrame.getInstance();
            }
        });
        this.configItem.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                MacMonitorTray.this.configItem.setBackground(Color.ORANGE);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                MacMonitorTray.this.configItem.setBackground(MacMonitorTray.this.bgColor1);
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        this.updateOnline.setText("Online Upgrade");
        this.updateOnline.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StartUpgrade start = new StartUpgrade();
                start.updateOnline();
            }
        });
        this.updateOnline.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                MacMonitorTray.this.updateOnline.setBackground(Color.ORANGE);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                MacMonitorTray.this.updateOnline.setBackground(MacMonitorTray.this.bgColor1);
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        this.updateByUser.setText("Manually Upgrade");
        this.updateByUser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StartUpgrade start = new StartUpgrade();
                start.updateByUser();
            }
        });
        this.debugItem.setText("Debug");
        this.debugItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Debug.isDebug) {
                    MacMonitorTray.this.debugItem.setText("Debug");
                    Debug.setDebug(false);
                } else {
                    MacMonitorTray.this.debugItem.setText("\u221a Debug");
                    Debug.setDebug(true);
                    try {
                        Desktop.getDesktop().open(new File(Debug.URL));
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        this.updateByUser.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                MacMonitorTray.this.updateByUser.setBackground(Color.ORANGE);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                MacMonitorTray.this.updateByUser.setBackground(MacMonitorTray.this.bgColor1);
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        this.snmpMrg.setText("SNMP Manager");
        this.snmpMrg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SNMPMainJFrame snmp = SNMPMainJFrame.getInstanse();
                snmp.runSNMPService();
            }
        });
        this.snmpMrg.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                MacMonitorTray.this.snmpMrg.setBackground(Color.ORANGE);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                MacMonitorTray.this.snmpMrg.setBackground(MacMonitorTray.this.bgColor1);
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        this.openItem_Bt.setText("Open Monitor");
        this.openItem_Bt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MainJFrame.getNewInstance().setVisible(true);
                MainJFrame.getNewInstance().setState(0);
            }
        });
        this.openItem_Bt.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                MacMonitorTray.this.openItem_Bt.setBackground(Color.ORANGE);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                MacMonitorTray.this.openItem_Bt.setBackground(MacMonitorTray.this.bgColor1);
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        this.exitItem_Bt.setText("Exit");
        this.exitItem_Bt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                UdpClient client = null;
                String port = "38694";
                try {
                    port = GlobalVariables.globalConfig.getUdpPort();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                try {
                    try {
                        client = new UdpClient("localhost", port);
                        client.send("(exit:myself");
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        if (client != null) {
                            client.disconnect();
                        }
                    }
                }
                finally {
                    if (client != null) {
                        client.disconnect();
                    }
                }
            }
        });
        this.exitItem_Bt.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                MacMonitorTray.this.exitItem_Bt.setBackground(Color.ORANGE);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                MacMonitorTray.this.exitItem_Bt.setBackground(MacMonitorTray.this.bgColor1);
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        this.configItem.setBounds(0, 0, 158, 23);
        this.updateOnline.setBounds(0, 20, 158, 23);
        this.updateByUser.setBounds(0, 40, 158, 23);
        this.debugItem.setBounds(0, 60, 158, 23);
        this.snmpMrg.setBounds(0, 80, 158, 23);
        this.openItem_Bt.setBounds(0, 100, 158, 23);
        this.exitItem_Bt.setBounds(0, 120, 158, 23);
        this.configItem.setBackground(this.bgColor1);
        this.updateOnline.setBackground(this.bgColor1);
        this.updateByUser.setBackground(this.bgColor1);
        this.openItem_Bt.setBackground(this.bgColor1);
        this.debugItem.setBackground(this.bgColor1);
        this.snmpMrg.setBackground(this.bgColor1);
        this.exitItem_Bt.setBackground(this.bgColor1);
        this.configItem.setFont(this.font12);
        this.updateOnline.setFont(this.font12);
        this.updateByUser.setFont(this.font12);
        this.debugItem.setFont(this.font12);
        this.snmpMrg.setFont(this.font12);
        this.openItem_Bt.setFont(this.font12);
        this.exitItem_Bt.setFont(this.font12);
        this.centerPanel.setLayout(null);
        this.centerPanel.setBackground(this.bgColor);
        this.centerPanel.setBorder(BorderFactory.createEtchedBorder());
        this.southPanel.setBackground(this.bgColor);
        this.southPanel.setBorder(BorderFactory.createEtchedBorder());
        this.centerPanel.add(this.configItem);
        this.centerPanel.add(this.updateOnline);
        this.centerPanel.add(this.updateByUser);
        this.centerPanel.add(this.debugItem);
        this.centerPanel.add(this.snmpMrg);
        this.centerPanel.add(this.openItem_Bt);
        this.centerPanel.add(this.exitItem_Bt);
        this.add((Component)this.centerPanel, "Center");
        this.name.setText(GlobalVariables.customerConfig.getCustomerName());
        this.name.setFont(this.font12);
        this.name.setForeground(Color.white);
        this.icon.setIcon(new ImageIcon(Constants.CONNECTEDIMG));
        this.southPanel.add(this.name);
        this.southPanel.add(this.icon);
        this.add((Component)this.southPanel, "South");
        this.pack();
    }

    public boolean getDragable() {
        return this.isDrag;
    }

    public void setDragable(boolean yesOrNo) {
        this.isDrag = yesOrNo;
    }

    public boolean getAntoLocate() {
        return this.automaticLocate;
    }

    public void setAntoLocate(boolean bLocate) {
        this.automaticLocate = bLocate;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.drag = false;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.isDrag) {
            return;
        }
        this.drag = true;
        this.x = e.getX();
        this.y = e.getY();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.isDrag) {
            return;
        }
        if (this.drag) {
            int w_x = this.getLocation().x;
            int w_y = this.getLocation().y;
            int m_x = e.getX();
            int m_y = e.getY();
            if (m_x != this.x || m_y != this.y) {
                this.setLocation(w_x + m_x - this.x, w_y + m_y - this.y);
            }
        }
    }

    @Override
    public void setLocation(int x, int y) {
        if (this.screenSize != null && this.automaticLocate) {
            int w = this.getWidth();
            int h = this.getHeight();
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
            if (x + w > this.screenSize.width) {
                x = this.screenSize.width - w;
            }
            if (y + h > this.screenSize.height) {
                y = this.screenSize.height - h;
            }
        }
        super.setLocation(x, y);
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void refreshUpgrade(boolean online, boolean manually) {
        this.updateOnline.setEnabled(online);
        this.updateByUser.setEnabled(manually);
    }

    @Override
    public void addToSystemTray() {
    }
}

