/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.console.mac;

import cn.com.voltronic.solar.beanbag.P30BeanBag;
import cn.com.voltronic.solar.communicate.ModbusHandler;
import cn.com.voltronic.solar.communicate.SNMPHandler;
import cn.com.voltronic.solar.communicate.SerialHandler;
import cn.com.voltronic.solar.communicate.USBHandler;
import cn.com.voltronic.solar.comusbprocessor.P301TO3KWComUSBProcessor;
import cn.com.voltronic.solar.comusbprocessor.P304TO5KWComUSBProcessor;
import cn.com.voltronic.solar.comusbprocessor.P30EPSComUSBProcessor;
import cn.com.voltronic.solar.comusbprocessor.P30PlusDuoComUSBProcessor;
import cn.com.voltronic.solar.comusbprocessor.P30PlusTriComUSBProcessor;
import cn.com.voltronic.solar.comusbprocessor.P30VPComUSBProcessor;
import cn.com.voltronic.solar.configure.SystemEnv;
import cn.com.voltronic.solar.console.SolarPowerTray;
import cn.com.voltronic.solar.console.mac.MacMonitorTray;
import cn.com.voltronic.solar.constants.Constants;
import cn.com.voltronic.solar.dao.WorkDataDao;
import cn.com.voltronic.solar.modbusprocessor.P301TO3KWModbusProcessor;
import cn.com.voltronic.solar.modbusprocessor.P304TO5KWModbusProcessor;
import cn.com.voltronic.solar.modbusprocessor.P30EPSModbusProcessor;
import cn.com.voltronic.solar.protocol.P301TO3KW;
import cn.com.voltronic.solar.protocol.P304TO5KW;
import cn.com.voltronic.solar.protocol.P30EPS;
import cn.com.voltronic.solar.protocol.P30EPSM5K;
import cn.com.voltronic.solar.protocol.P30LY;
import cn.com.voltronic.solar.protocol.P30Paral;
import cn.com.voltronic.solar.protocol.P30PlusDuo;
import cn.com.voltronic.solar.protocol.P30PlusTri;
import cn.com.voltronic.solar.protocol.P30V;
import cn.com.voltronic.solar.snmpprocessor.P301TO3KWSNMPProcessor;
import cn.com.voltronic.solar.snmpprocessor.P304TO5KWSNMPProcessor;
import cn.com.voltronic.solar.snmpprocessor.P30PlusDuoSNMPProcessor;
import cn.com.voltronic.solar.snmpprocessor.P30PlusTriSNMPProcessor;
import cn.com.voltronic.solar.socket.DatagramServer;
import cn.com.voltronic.solar.socket.SystemTrayUDPClient;
import cn.com.voltronic.solar.socket.SystemTrayUDPServer;
import cn.com.voltronic.solar.socket.UdpClient;
import cn.com.voltronic.solar.system.DaoManager;
import cn.com.voltronic.solar.system.GlobalVariables;
import cn.com.voltronic.solar.system.ProcessorCategories;
import cn.com.voltronic.solar.thread.AutoDetect;
import cn.com.voltronic.solar.thread.EventThread;
import cn.com.voltronic.solar.thread.PageThread;
import cn.com.voltronic.solar.upgrade.StartUpgrade;
import cn.com.voltronic.solar.view.EventInfoDialog;
import cn.com.voltronic.solar.view.MainJFrame;
import cn.com.voltronic.solar.work.PollProcessorStatus;
import cn.com.voltronic.solar.work.RecordWorkinfo;
import cn.com.voltronic.solar.work.SearchDevice;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class WatchPower {
    private DatagramServer udpServerSocket = null;
    public EventInfoDialog dialog = null;
    public volatile List<String> infoList;
    public volatile boolean isopen = false;
    public volatile int pvCounter = 0;
    public JLabel icon;
    private static SolarPowerTray consoleTray = null;
    private static final String LOG_PATH = String.valueOf(System.getProperty("user.dir")) + File.separator + "config" + File.separator + "log4j.properties";
    private static Logger logger = Logger.getLogger(WatchPower.class);

    public static SolarPowerTray getConsoleTray() {
        return consoleTray;
    }

    public void startRun() {
        block11: {
            try {
                this.udpServerSocket = SystemTrayUDPServer.getServer();
                try {
                    this.inint();
                }
                catch (Exception e) {
                    logger.error((Object)"System initialization failed.");
                    if (this.udpServerSocket != null) {
                        this.udpServerSocket.close();
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)"The tray has been running.");
                String port = "38694";
                UdpClient client = null;
                try {
                    try {
                        port = GlobalVariables.globalConfig.getUdpPort();
                        client = new UdpClient("localhost", port);
                        client.send("OPENPAGE");
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        if (client != null) {
                            client.disconnect();
                        }
                    }
                }
                finally {
                    if (client == null) break block11;
                    client.disconnect();
                }
            }
        }
    }

    public void inint() {
        PropertyConfigurator.configure((String)LOG_PATH);
        GlobalVariables.initConfig(Constants.CONFIG_PATH);
        this.initMonitorProcess();
        consoleTray = new MacMonitorTray();
        EventThread event = new EventThread();
        event.start();
        PageThread thread = new PageThread();
        thread.start();
        this.initDaoManager();
        SearchDevice searchdevice = new SearchDevice();
        searchdevice.start();
        RecordWorkinfo record = new RecordWorkinfo();
        record.start();
        PollProcessorStatus pollstatus = new PollProcessorStatus();
        pollstatus.setPriority(10);
        pollstatus.start();
        this.icon = WatchPower.consoleTray.icon;
        boolean useautoDetect = GlobalVariables.upgradeConfig.isAutoUpgrade();
        if (useautoDetect) {
            AutoDetect autoDetect = new AutoDetect();
            autoDetect.setDaemon(true);
            autoDetect.start();
        }
        this.infoList = new ArrayList<String>();
        EventListener eventListener = new EventListener();
        eventListener.start();
    }

    public static void main(String[] args) {
        WatchPower console = new WatchPower();
        console.startRun();
    }

    private void initDaoManager() {
        DaoManager.registerDAO(P30BeanBag.class, WorkDataDao.class);
    }

    private void initMonitorProcess() {
        ProcessorCategories.registerProcessor(P301TO3KW.class, SerialHandler.class, P301TO3KWComUSBProcessor.class);
        ProcessorCategories.registerProcessor(P301TO3KW.class, USBHandler.class, P301TO3KWComUSBProcessor.class);
        ProcessorCategories.registerProcessor(P301TO3KW.class, ModbusHandler.class, P301TO3KWModbusProcessor.class);
        ProcessorCategories.registerProcessor(P301TO3KW.class, SNMPHandler.class, P301TO3KWSNMPProcessor.class);
        ProcessorCategories.registerProcessor(P304TO5KW.class, SerialHandler.class, P304TO5KWComUSBProcessor.class);
        ProcessorCategories.registerProcessor(P304TO5KW.class, USBHandler.class, P304TO5KWComUSBProcessor.class);
        ProcessorCategories.registerProcessor(P304TO5KW.class, ModbusHandler.class, P304TO5KWModbusProcessor.class);
        ProcessorCategories.registerProcessor(P304TO5KW.class, SNMPHandler.class, P304TO5KWSNMPProcessor.class);
        ProcessorCategories.registerProcessor(P30PlusDuo.class, SerialHandler.class, P30PlusDuoComUSBProcessor.class);
        ProcessorCategories.registerProcessor(P30PlusDuo.class, USBHandler.class, P30PlusDuoComUSBProcessor.class);
        ProcessorCategories.registerProcessor(P30PlusDuo.class, SNMPHandler.class, P30PlusDuoSNMPProcessor.class);
        ProcessorCategories.registerProcessor(P30PlusTri.class, SerialHandler.class, P30PlusTriComUSBProcessor.class);
        ProcessorCategories.registerProcessor(P30PlusTri.class, USBHandler.class, P30PlusTriComUSBProcessor.class);
        ProcessorCategories.registerProcessor(P30PlusTri.class, SNMPHandler.class, P30PlusTriSNMPProcessor.class);
        ProcessorCategories.registerProcessor(P30V.class, SerialHandler.class, P30VPComUSBProcessor.class);
        ProcessorCategories.registerProcessor(P30V.class, USBHandler.class, P30VPComUSBProcessor.class);
        ProcessorCategories.registerProcessor(P30EPS.class, SerialHandler.class, P30EPSComUSBProcessor.class);
        ProcessorCategories.registerProcessor(P30EPS.class, USBHandler.class, P30EPSComUSBProcessor.class);
        ProcessorCategories.registerProcessor(P30EPS.class, ModbusHandler.class, P30EPSModbusProcessor.class);
        ProcessorCategories.registerProcessor(P30EPSM5K.class, SerialHandler.class, P304TO5KWComUSBProcessor.class);
        ProcessorCategories.registerProcessor(P30EPSM5K.class, USBHandler.class, P304TO5KWComUSBProcessor.class);
        ProcessorCategories.registerProcessor(P30LY.class, SerialHandler.class, P301TO3KWComUSBProcessor.class);
        ProcessorCategories.registerProcessor(P30LY.class, USBHandler.class, P301TO3KWSNMPProcessor.class);
        ProcessorCategories.registerProcessor(P30Paral.class, SerialHandler.class, P304TO5KWComUSBProcessor.class);
        ProcessorCategories.registerProcessor(P30Paral.class, USBHandler.class, P304TO5KWComUSBProcessor.class);
        ProcessorCategories.registerProcessor(P30Paral.class, SNMPHandler.class, P304TO5KWSNMPProcessor.class);
    }

    class EventListener
    extends Thread {
        EventListener() {
        }

        @Override
        public void run() {
            boolean isUpgrade = false;
            block8: while (true) {
                try {
                    while (true) {
                        String rec;
                        if ((rec = WatchPower.this.udpServerSocket.receive().trim()).startsWith("(Event:")) {
                            int i;
                            StringBuffer sb;
                            String event = rec.substring(7, rec.lastIndexOf("13"));
                            String eventaddn = String.valueOf(event) + "\n";
                            String startEvent = eventaddn.substring(0, eventaddn.lastIndexOf("]") + 1);
                            String endEvent = eventaddn.substring(eventaddn.lastIndexOf("]") + 2);
                            WatchPower.this.infoList.add(String.valueOf(startEvent) + "\n" + "     " + endEvent);
                            if (!WatchPower.this.isopen) {
                                WatchPower.this.dialog = EventInfoDialog.getInstance();
                                WatchPower.this.dialog.setVisible(true);
                                WatchPower.this.isopen = true;
                                WatchPower.this.dialog.addWindowListener(new WindowAdapter(){

                                    @Override
                                    public void windowClosing(WindowEvent e) {
                                        ((EventListener)EventListener.this).WatchPower.this.isopen = false;
                                        ((EventListener)EventListener.this).WatchPower.this.infoList.clear();
                                        ((EventListener)EventListener.this).WatchPower.this.dialog.dispose();
                                    }
                                });
                                WatchPower.this.dialog.jButton1.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent evt) {
                                        ((EventListener)EventListener.this).WatchPower.this.isopen = false;
                                        ((EventListener)EventListener.this).WatchPower.this.infoList.clear();
                                        ((EventListener)EventListener.this).WatchPower.this.dialog.dispose();
                                    }
                                });
                                sb = new StringBuffer();
                                i = 0;
                                while (i < WatchPower.this.infoList.size()) {
                                    sb.append(WatchPower.this.infoList.get(i));
                                    ++i;
                                }
                                WatchPower.this.dialog.getEventTextPanel().setText(sb.toString());
                                WatchPower.this.dialog.getEventTextPanel().setCaretPosition(WatchPower.this.dialog.getEventTextPanel().getText().length());
                                continue;
                            }
                            sb = new StringBuffer();
                            i = 0;
                            while (i < WatchPower.this.infoList.size()) {
                                sb.append(WatchPower.this.infoList.get(i));
                                ++i;
                            }
                            WatchPower.this.dialog.getEventTextPanel().setText(sb.toString());
                            WatchPower.this.dialog.getEventTextPanel().setCaretPosition(WatchPower.this.dialog.getEventTextPanel().getText().length());
                            continue;
                        }
                        if (rec.startsWith("(PVCount:")) {
                            try {
                                String count = rec.substring(9);
                                WatchPower.this.pvCounter = Integer.parseInt(count);
                                if (WatchPower.this.pvCounter > 0) {
                                    WatchPower.this.icon.setIcon(new ImageIcon(Constants.CONNECTEDIMG_DEVICE));
                                    continue;
                                }
                                WatchPower.this.icon.setIcon(new ImageIcon(Constants.CONNECTEDIMG));
                            }
                            catch (Exception count) {}
                            continue;
                        }
                        if (rec.startsWith("(exit:myself")) {
                            SystemEnv.stoped = 0;
                            SystemEnv.stopping = true;
                            break block8;
                        }
                        if (rec.startsWith("(exit:upgrade")) {
                            isUpgrade = true;
                            SystemEnv.stoped = 0;
                            SystemEnv.stopping = true;
                            break block8;
                        }
                        if (!rec.equals("OPENPAGE")) continue;
                        MainJFrame.getNewInstance().setVisible(true);
                        MainJFrame.getNewInstance().setState(0);
                    }
                }
                catch (Exception rec) {
                    continue;
                }
                break;
            }
            if (WatchPower.this.udpServerSocket != null) {
                WatchPower.this.udpServerSocket.close();
            }
            int iexit = 0;
            while (SystemEnv.stoped < 3) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (++iexit > 20) break;
            }
            System.out.println("stopped ok");
            try {
                SystemTrayUDPClient client = new SystemTrayUDPClient("localhost", 33656);
                int i = 0;
                while (i < 3) {
                    client.send("EXIT".getBytes());
                    Thread.sleep(500L);
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (isUpgrade) {
                StartUpgrade.runUpgrade();
            }
            System.exit(0);
        }
    }
}

