/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.control;

import cn.com.voltronic.solar.communicate.IComUSBHandler;
import cn.com.voltronic.solar.control.AbstractControlModule;
import cn.com.voltronic.solar.control.IP30ControlModule;
import cn.com.voltronic.solar.util.VolUtil;

public class P30ComUSBControlModule
extends AbstractControlModule
implements IP30ControlModule {
    public P30ComUSBControlModule(Object handler) {
        super(handler);
    }

    @Override
    public IComUSBHandler getHandler() {
        return (IComUSBHandler)super.getHandler();
    }

    @Override
    public boolean setBatteryLow(double value) {
        boolean result = true;
        try {
            result = this.excuteCommand("BATLOW", this.getFomatStr(String.valueOf(value), 4));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setBatteryType(String value) {
        boolean result = true;
        try {
            result = this.excuteCommand("PBT", this.getFomatStr(String.valueOf(value), 2));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setBatteryUnder(double value) {
        boolean result = true;
        try {
            result = this.excuteCommand("PSDV", String.format("%04.01f", value));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setChargerSource(String value) {
        boolean result = true;
        try {
            result = this.excuteCommand("PCP", this.getFomatStr(String.valueOf(value), 2));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setGridWorkRange(String value) {
        boolean result = true;
        try {
            result = this.excuteCommand("PGR", this.getFomatStr(String.valueOf(value), 2));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setMaxChargingCurrent(int value) {
        boolean result = true;
        try {
            result = this.excuteCommand("MCHGC", this.getFomatStr(String.valueOf(value), 3));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setMaxChargingVoltage(double value) {
        boolean result = true;
        try {
            result = this.excuteCommand("PCVV", String.format("%04.01f", value));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setOutputFrequency(int value) {
        boolean result = true;
        try {
            result = this.excuteCommand("F", this.getFomatStr(String.valueOf(value), 2));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public boolean setOperationLogic(int commandNO) {
        boolean result = true;
        try {
            result = this.excuteCommand("POPLG", this.getFomatStr(String.valueOf(commandNO), 2));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public boolean setBypassFunction(int commandNO) {
        boolean result = true;
        try {
            switch (commandNO) {
                case 0: {
                    result = this.excuteCommand("PD", "c");
                    break;
                }
                case 1: {
                    result = this.excuteCommand("PE", "c");
                    long end1 = System.currentTimeMillis() + 1000L;
                    while (System.currentTimeMillis() < end1) {
                    }
                    if (result) {
                        result = this.excuteCommand("PD", "b");
                    }
                    break;
                }
                case 2: {
                    result = this.excuteCommand("PE", "c");
                    long end2 = System.currentTimeMillis() + 1000L;
                    while (System.currentTimeMillis() < end2) {
                    }
                    if (!result) break;
                    result = this.excuteCommand("PE", "b");
                }
                default: {
                    break;
                }
            }
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setOutputVoltage(int value) {
        boolean result = true;
        try {
            result = this.excuteCommand("V", this.getFomatStr(String.valueOf(value), 3));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setCapability(String x, boolean isEnable) {
        boolean result = true;
        try {
            result = this.excuteCommand(isEnable ? "PE" : "PD", x);
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
        }
        return result;
    }

    public boolean setECO(String x) {
        boolean result = true;
        try {
            if (x.equals("1")) {
                result = this.excuteCommand("PE", "d");
            } else if (x.equals("0")) {
                result = this.excuteCommand("PD", "d");
            }
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public boolean setPF() {
        boolean result = true;
        try {
            result = this.excuteCommand("PF", null);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean excuteCommand(String command, String parmeter) throws Exception {
        IComUSBHandler _handler = this.getHandler();
        boolean result = false;
        String re = "(NAK";
        int times = 0;
        while (re.equals("(NAK") && times < 3) {
            if (_handler != null) {
                re = parmeter == null || "".equals(parmeter) ? _handler.excuteCommand(command, true) : _handler.excuteCommand(String.valueOf(command) + parmeter, true);
            }
            ++times;
        }
        times = 0;
        result = re.equals("(ACK");
        return result;
    }

    @Override
    public boolean setRechargingVol(double value) {
        boolean result = true;
        try {
            result = this.excuteCommand("PBCV", String.format("%04.01f", value));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setReDisChargeVoltage(double value) {
        boolean result = true;
        try {
            result = this.excuteCommand("PBDV", String.format("%04.01f", value));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public boolean setPPVOKC(int intvalue) {
        boolean result = true;
        try {
            result = this.excuteCommand("PPVOKC", "" + intvalue);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public boolean setPSPB(int intvalue) {
        boolean result = true;
        try {
            result = this.excuteCommand("PSPB", "" + intvalue);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setFloatingVoltage(double value) {
        boolean result = true;
        try {
            result = this.excuteCommand("PBFT", String.format("%04.01f", value));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setOutputMode(int key, int mode) {
        boolean result = true;
        try {
            result = this.excuteCommand("POPM", String.valueOf(key) + mode);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setPChargerSource(int key, String value) {
        boolean result = true;
        try {
            result = this.excuteCommand("PPCP", key + value);
        }
        catch (Exception e) {
            result = false;
        }
        if (!result) {
            try {
                result = this.excuteCommand("PCP", value);
            }
            catch (Exception e2) {
                result = false;
            }
        }
        return result;
    }

    @Override
    public boolean setPMaxChargingCurrent(int key, int maxChargeCurrent) {
        boolean result = true;
        try {
            result = this.excuteCommand("MCHGC", String.format("%03d", maxChargeCurrent));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setNPMaxChargingCurrent(int key, int maxChargeCurrent) {
        boolean result = true;
        try {
            result = this.excuteCommand("MNCHGC", key + String.format("%03d", maxChargeCurrent));
        }
        catch (Exception e) {
            result = false;
        }
        if (!result) {
            try {
                result = this.excuteCommand("MNCHGC", String.format("%03d", maxChargeCurrent));
            }
            catch (Exception e2) {
                result = false;
            }
        }
        if (!result) {
            try {
                result = this.excuteCommand("MCHGC", String.format("%03d", maxChargeCurrent));
            }
            catch (Exception e2) {
                result = false;
            }
        }
        return result;
    }

    public boolean setVNPMaxChargingCurrent(int maxChargeCurrent) {
        boolean result = true;
        try {
            result = this.excuteCommand("MNCHGC", String.format("%03d", maxChargeCurrent));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public boolean setPMaxACChargeCurrent(int key, int maxChargeCurrent) {
        boolean result = true;
        try {
            result = this.excuteCommand("MUCHGC", key + String.format("%02d", maxChargeCurrent));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public boolean setVPMaxACChargeCurrent(int maxACChargeCurrent) {
        boolean result = true;
        try {
            result = this.excuteCommand("MUCHGC", String.format("%03d", maxACChargeCurrent));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setMSCHGC(String value) {
        return false;
    }

    @Override
    public boolean setPCST(String value) {
        return false;
    }

    @Override
    public boolean setPCVT(String value) {
        return false;
    }

    @Override
    public boolean setPOPV(int value) {
        boolean result = true;
        try {
            result = this.excuteCommand("POPV", String.valueOf(value) + "0");
        }
        catch (Exception e) {
            result = false;
        }
        if (!result) {
            try {
                result = this.excuteCommand("V", String.valueOf(value));
            }
            catch (Exception e) {
                result = false;
            }
        }
        return result;
    }

    @Override
    public boolean setPBEQA(int value) {
        boolean result = true;
        try {
            result = this.excuteCommand("PBEQA", "" + value);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setPBEQE(int value) {
        boolean result = true;
        try {
            result = this.excuteCommand("PBEQE", "" + value);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setPBEQOT(double value) {
        boolean result = true;
        try {
            int val = (int)value;
            String varStr = String.format("%03d", val);
            result = this.excuteCommand("PBEQOT", varStr);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setPBEQP(double value) {
        boolean result = true;
        try {
            int val = (int)value;
            result = this.excuteCommand("PBEQP", String.format("%03d", val));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setPBEQT(double value) {
        boolean result = true;
        try {
            int val = (int)value;
            result = this.excuteCommand("PBEQT", String.format("%03d", val));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setPBEQV(double value) {
        boolean result = true;
        try {
            String val = String.valueOf(value) + "0";
            result = this.excuteCommand("PBEQV", val);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setBatReDischargeCapacity(double value) {
        value = VolUtil.round(value / 100.0, 1);
        return this.setReDisChargeVoltage(value);
    }

    @Override
    public boolean setPCVT(double value) {
        boolean result = true;
        try {
            int val = (int)value;
            result = this.excuteCommand("PCVT", String.format("%03d", val));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setLBF(int value) {
        boolean result = true;
        try {
            result = this.excuteCommand("LBF", String.valueOf(value));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setOutputSource(String value) {
        boolean result = true;
        try {
            result = this.excuteCommand("POP", this.getFomatStr(String.valueOf(value), 2));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }
}

