/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.control;

import cn.com.voltronic.solar.communicate.ModbusHandler;
import cn.com.voltronic.solar.control.AbstractControlModule;
import cn.com.voltronic.solar.control.IP30ControlModule;
import net.wimpi.modbus.procimg.Register;
import net.wimpi.modbus.procimg.SimpleRegister;
import net.wimpi.modbus.util.BitVector;
import net.wimpi.modbus.util.ModbusUtil;

public class P30ModbusControlModule
extends AbstractControlModule
implements IP30ControlModule {
    public P30ModbusControlModule(Object handler) {
        super(handler);
    }

    @Override
    public boolean setBatteryLow(double value) {
        return false;
    }

    @Override
    public boolean setBatteryType(String value) {
        boolean result = true;
        try {
            String valueStr = "";
            this.excuteCommand(1478, Integer.valueOf(value));
            Thread.sleep(3500L);
            Register[] query = ((ModbusHandler)this.getHandler()).readMultipleRegisters(1478, 1);
            if (query[0].getValue() == 0) {
                valueStr = "00";
            } else if (query[0].getValue() == 1) {
                valueStr = "01";
            } else if (query[0].getValue() == 2) {
                valueStr = "02";
            }
            result = value.equals(valueStr);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    @Override
    public boolean setBatteryUnder(double value) {
        boolean result = true;
        try {
            this.excuteCommand(1477, (int)(value * 10.0));
            Thread.sleep(3500L);
            Register[] query = ((ModbusHandler)this.getHandler()).readMultipleRegisters(1477, 1);
            result = value == (double)query[0].getValue() / 10.0;
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    @Override
    public boolean setCapability(String x, boolean isEnable) {
        boolean result;
        block28: {
            result = true;
            try {
                if (x.equals("a")) {
                    this.excuteCommand(14, isEnable ? 32768 : Short.MAX_VALUE);
                    Thread.sleep(1000L);
                    int i = 0;
                    while (i < 9) {
                        Register[] reg = ((ModbusHandler)this.getHandler()).readMultipleRegisters(14, 1);
                        BitVector bits = new BitVector(16);
                        bits.setBytes(reg[0].toBytes(), 16);
                        bits.toggleAccess(true);
                        boolean bl = result = isEnable == bits.getBit(0);
                        if (!result) {
                            Thread.sleep(1000L);
                            ++i;
                            continue;
                        }
                        break block28;
                    }
                    break block28;
                }
                if (x.equals("b")) {
                    this.excuteCommand(14, isEnable ? 16384 : 49151);
                    Thread.sleep(1000L);
                    int i = 0;
                    while (i < 9) {
                        Register[] reg = ((ModbusHandler)this.getHandler()).readMultipleRegisters(14, 1);
                        BitVector bits = new BitVector(16);
                        bits.setBytes(reg[0].toBytes(), 16);
                        bits.toggleAccess(true);
                        boolean bl = result = isEnable == bits.getBit(1);
                        if (!result) {
                            Thread.sleep(1000L);
                            ++i;
                            continue;
                        }
                        break block28;
                    }
                    break block28;
                }
                if (x.equals("j")) {
                    this.excuteCommand(15, isEnable ? 32768 : Short.MAX_VALUE);
                    Thread.sleep(1000L);
                    int i = 0;
                    while (i < 9) {
                        Register[] reg = ((ModbusHandler)this.getHandler()).readMultipleRegisters(15, 1);
                        BitVector bits = new BitVector(16);
                        bits.setBytes(reg[0].toBytes(), 16);
                        bits.toggleAccess(true);
                        boolean bl = result = isEnable == bits.getBit(0);
                        if (!result) {
                            Thread.sleep(1000L);
                            ++i;
                            continue;
                        }
                        break block28;
                    }
                    break block28;
                }
                if (x.equals("k")) {
                    this.excuteCommand(15, isEnable ? 16384 : 49151);
                    Thread.sleep(1000L);
                    int i = 0;
                    while (i < 9) {
                        Register[] reg = ((ModbusHandler)this.getHandler()).readMultipleRegisters(15, 1);
                        BitVector bits = new BitVector(16);
                        bits.setBytes(reg[0].toBytes(), 16);
                        bits.toggleAccess(true);
                        boolean bl = result = isEnable == bits.getBit(1);
                        if (!result) {
                            Thread.sleep(1000L);
                            ++i;
                            continue;
                        }
                        break block28;
                    }
                    break block28;
                }
                if (x.equals("u")) {
                    this.excuteCommand(15, isEnable ? 1024 : 64511);
                    Thread.sleep(1000L);
                    int i = 0;
                    while (i < 9) {
                        Register[] reg = ((ModbusHandler)this.getHandler()).readMultipleRegisters(15, 1);
                        BitVector bits = new BitVector(16);
                        bits.setBytes(reg[0].toBytes(), 16);
                        bits.toggleAccess(true);
                        boolean bl = result = isEnable == bits.getBit(5);
                        if (!result) {
                            Thread.sleep(1000L);
                            ++i;
                            continue;
                        }
                        break block28;
                    }
                    break block28;
                }
                if (x.equals("v")) {
                    this.excuteCommand(15, isEnable ? 4096 : 61439);
                    Thread.sleep(1000L);
                    int i = 0;
                    while (i < 9) {
                        Register[] reg = ((ModbusHandler)this.getHandler()).readMultipleRegisters(15, 1);
                        BitVector bits = new BitVector(16);
                        bits.setBytes(reg[0].toBytes(), 16);
                        bits.toggleAccess(true);
                        boolean bl = result = isEnable == bits.getBit(3);
                        if (!result) {
                            Thread.sleep(1000L);
                            ++i;
                            continue;
                        }
                        break block28;
                    }
                    break block28;
                }
                if (x.equals("x")) {
                    this.excuteCommand(15, isEnable ? 512 : 65023);
                    Thread.sleep(1000L);
                    int i = 0;
                    while (i < 9) {
                        Register[] reg = ((ModbusHandler)this.getHandler()).readMultipleRegisters(15, 1);
                        BitVector bits = new BitVector(16);
                        bits.setBytes(reg[0].toBytes(), 16);
                        bits.toggleAccess(true);
                        boolean bl = result = isEnable == bits.getBit(6);
                        if (!result) {
                            Thread.sleep(1000L);
                            ++i;
                            continue;
                        }
                        break block28;
                    }
                    break block28;
                }
                if (x.equals("y")) {
                    this.excuteCommand(15, isEnable ? 256 : 65279);
                    Thread.sleep(1000L);
                    int i = 0;
                    while (i < 9) {
                        Register[] reg = ((ModbusHandler)this.getHandler()).readMultipleRegisters(15, 1);
                        BitVector bits = new BitVector(16);
                        bits.setBytes(reg[0].toBytes(), 16);
                        bits.toggleAccess(true);
                        boolean bl = result = isEnable == bits.getBit(7);
                        if (!result) {
                            Thread.sleep(1000L);
                            ++i;
                            continue;
                        }
                        break block28;
                    }
                    break block28;
                }
                if (!x.equals("z")) break block28;
                this.excuteCommand(15, isEnable ? 128 : 65407);
                Thread.sleep(1000L);
                int i = 0;
                while (i < 9) {
                    Register[] reg = ((ModbusHandler)this.getHandler()).readMultipleRegisters(15, 1);
                    BitVector bits = new BitVector(16);
                    bits.setBytes(reg[0].toBytes(), 16);
                    bits.toggleAccess(true);
                    boolean bl = result = isEnable == bits.getBit(8);
                    if (!result) {
                        Thread.sleep(1000L);
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                result = false;
            }
        }
        return result;
    }

    @Override
    public boolean setChargerSource(String value) {
        boolean result = true;
        try {
            this.excuteCommand(1480, Integer.valueOf(value));
            Thread.sleep(3500L);
            Register[] query = ((ModbusHandler)this.getHandler()).readMultipleRegisters(1480, 1);
            String queryStr = "";
            if (query[0].getValue() == 0) {
                queryStr = "00";
            } else if (query[0].getValue() == 1) {
                queryStr = "01";
            } else if (query[0].getValue() == 2) {
                queryStr = "02";
            } else if (query[0].getValue() == 3) {
                queryStr = "03";
            }
            result = value.equals(queryStr);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    @Override
    public boolean setFloatingVoltage(double value) {
        boolean result = true;
        try {
            this.excuteCommand(1456, (int)(value * 10.0));
            Thread.sleep(3500L);
            Register[] query = ((ModbusHandler)this.getHandler()).readMultipleRegisters(1456, 1);
            result = value == (double)query[0].getValue() / 10.0;
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    @Override
    public boolean setGridWorkRange(String value) {
        boolean result = true;
        try {
            this.excuteCommand(1483, Integer.valueOf(value));
            Thread.sleep(3500L);
            Register[] query = ((ModbusHandler)this.getHandler()).readMultipleRegisters(1483, 1);
            String queryStr = "";
            if (query[0].getValue() == 0) {
                queryStr = "00";
            } else if (query[0].getValue() == 1) {
                queryStr = "01";
            }
            result = value.equals(queryStr);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    @Override
    public boolean setMaxChargingCurrent(int value) {
        boolean result = true;
        try {
            this.excuteCommand(1457, value);
            Thread.sleep(3500L);
            Register[] query = ((ModbusHandler)this.getHandler()).readMultipleRegisters(1457, 1);
            result = value == query[0].getValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    @Override
    public boolean setMaxChargingVoltage(double value) {
        boolean result = true;
        try {
            this.excuteCommand(1493, (int)(value * 10.0));
            Thread.sleep(3500L);
            Register[] query = ((ModbusHandler)this.getHandler()).readMultipleRegisters(1493, 1);
            result = value == (double)query[0].getValue() / 10.0;
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    @Override
    public boolean setOutputFrequency(int value) {
        boolean result = true;
        try {
            if (value == 50) {
                this.excuteCommand(1314, 32768);
                Thread.sleep(3500L);
                Register[] query = ((ModbusHandler)this.getHandler()).readMultipleRegisters(1314, 1);
                BitVector bits = new BitVector(16);
                bits.setBytes(query[0].toBytes(), 16);
                bits.toggleAccess(true);
                result = bits.getBit(0);
            } else if (value == 60) {
                this.excuteCommand(1314, 16384);
                Thread.sleep(3500L);
                Register[] query = ((ModbusHandler)this.getHandler()).readMultipleRegisters(1314, 1);
                BitVector bits = new BitVector(16);
                bits.setBytes(query[0].toBytes(), 16);
                bits.toggleAccess(true);
                result = bits.getBit(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    @Override
    public boolean setOutputMode(int key, int mode) {
        boolean result = true;
        try {
            this.excuteCommand(1460, mode);
            Thread.sleep(1000L);
            int i = 0;
            while (i < 6) {
                Register[] query = ((ModbusHandler)this.getHandler()).readMultipleRegisters(1481, 1);
                boolean bl = result = mode == query[0].getValue();
                if (!result) {
                    Thread.sleep(1000L);
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    @Override
    public boolean setOutputSource(String value) {
        boolean result = true;
        try {
            this.excuteCommand(1479, Integer.valueOf(value));
            Thread.sleep(3500L);
            Register[] query = ((ModbusHandler)this.getHandler()).readMultipleRegisters(1479, 1);
            String queryStr = "";
            if (query[0].getValue() == 0) {
                queryStr = "00";
            } else if (query[0].getValue() == 1) {
                queryStr = "01";
            } else if (query[0].getValue() == 2) {
                queryStr = "02";
            }
            result = value.equals(queryStr);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    @Override
    public boolean setOutputVoltage(int value) {
        return false;
    }

    @Override
    public boolean setPChargerSource(int key, String value) {
        boolean result = true;
        try {
            this.excuteCommand(1480, key * 100 + Integer.valueOf(value));
            Thread.sleep(3500L);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    @Override
    public boolean setPF() {
        boolean result = true;
        try {
            this.excuteCommand(48, 32768);
            Thread.sleep(3500L);
            Register[] reg = ((ModbusHandler)this.getHandler()).readMultipleRegisters(59, 1);
            BitVector bits = new BitVector(16);
            bits.setBytes(reg[0].toBytes(), 16);
            bits.toggleAccess(true);
            result = bits.getBit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    @Override
    public boolean setPMaxChargingCurrent(int key, int maxChargeCurrent) {
        boolean result = true;
        try {
            this.excuteCommand(1457, key * 100 + maxChargeCurrent);
            Thread.sleep(3500L);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    @Override
    public boolean setNPMaxChargingCurrent(int key, int maxChargeCurrent) {
        boolean result = true;
        try {
            this.excuteCommand(1457, key * 1000 + maxChargeCurrent);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    @Override
    public boolean setReDisChargeVoltage(double value) {
        boolean result = true;
        try {
            this.excuteCommand(1486, (int)(value * 10.0));
            Thread.sleep(3500L);
            Register[] query = ((ModbusHandler)this.getHandler()).readMultipleRegisters(1486, 1);
            result = value == (double)query[0].getValue() / 10.0;
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    @Override
    public boolean setRechargingVol(double value) {
        boolean result = true;
        try {
            this.excuteCommand(1482, (int)(value * 10.0));
            Thread.sleep(3500L);
            Register[] query = ((ModbusHandler)this.getHandler()).readMultipleRegisters(1482, 1);
            result = value == (double)query[0].getValue() / 10.0;
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    public boolean setParallelIndex(int value) {
        boolean result = true;
        try {
            this.excuteCommand(350, value);
            Thread.sleep(3500L);
            Register[] query = ((ModbusHandler)this.getHandler()).readMultipleRegisters(350, 1);
            result = value == query[0].getValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    public boolean setPPVOKC(int value) {
        boolean result = true;
        try {
            this.excuteCommand(1484, value);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    public boolean setPSPB(int value) {
        boolean result = true;
        try {
            this.excuteCommand(1485, value);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    public boolean setPMaxACChargeCurrent(int key, int maxChargeCurrent) {
        boolean result = true;
        try {
            this.excuteCommand(1476, key * 100 + maxChargeCurrent);
            Thread.sleep(3500L);
            Register[] query = ((ModbusHandler)this.getHandler()).readMultipleRegisters(1476, 1);
            result = maxChargeCurrent == query[0].getValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    @Override
    public void excuteCommand(int address, int value) throws Exception {
        byte[] bytes = ModbusUtil.shortToRegister((short)((short)value));
        SimpleRegister reg = new SimpleRegister(bytes[0], bytes[1]);
        ((ModbusHandler)this.getHandler()).writeMultipleRegisters(address, new Register[]{reg});
    }

    @Override
    public boolean setMSCHGC(String value) {
        return false;
    }

    @Override
    public boolean setPCST(String value) {
        return false;
    }

    @Override
    public boolean setPCVT(String value) {
        return false;
    }

    @Override
    public boolean setPOPV(int value) {
        return false;
    }

    @Override
    public boolean setPBEQA(int value) {
        return false;
    }

    @Override
    public boolean setPBEQE(int value) {
        return false;
    }

    @Override
    public boolean setPBEQOT(double value) {
        return false;
    }

    @Override
    public boolean setPBEQP(double value) {
        return false;
    }

    @Override
    public boolean setPBEQT(double value) {
        return false;
    }

    @Override
    public boolean setPBEQV(double value) {
        return false;
    }

    @Override
    public boolean setBatReDischargeCapacity(double value) {
        return false;
    }

    @Override
    public boolean setPCVT(double value) {
        boolean result = true;
        try {
            int modVal = (int)value;
            this.excuteCommand(1487, modVal);
            Thread.sleep(3500L);
            Register[] query = ((ModbusHandler)this.getHandler()).readMultipleRegisters(1487, 1);
            result = modVal == query[0].getValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    @Override
    public boolean setLBF(int value) {
        return false;
    }
}

