/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.control;

import cn.com.voltronic.solar.control.P30ComUSBControlModule;

public class P30PlusDuoComUSBControlModule
extends P30ComUSBControlModule {
    public P30PlusDuoComUSBControlModule(Object handler) {
        super(handler);
    }

    @Override
    public boolean setMSCHGC(String value) {
        boolean result = true;
        try {
            result = this.excuteCommand("MSCHGC", this.getFomatStr(value, 3));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setPMaxChargingCurrent(int key, int maxChargeCurrent) {
        boolean result = true;
        try {
            result = this.excuteCommand("MCHGC", String.format("%03d", maxChargeCurrent));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setPCST(String value) {
        boolean result = true;
        try {
            if (value.equals("Auto")) {
                value = "00";
            } else if (value.equals("2-stage")) {
                value = "01";
            } else if (value.equals("3-stage")) {
                value = "02";
            }
            result = this.excuteCommand("PCST", this.getFomatStr(value, 2));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setPCVT(String value) {
        boolean result = true;
        try {
            if (value.equals("Auto")) {
                value = "255";
            }
            result = this.excuteCommand("PCVT", this.getFomatStr(value, 3));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setPOPV(int value) {
        boolean result = true;
        try {
            result = this.excuteCommand("POPV", String.valueOf(value) + "0");
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }
}

