/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.control;

import cn.com.voltronic.solar.communicate.SNMPHandler;
import cn.com.voltronic.solar.control.AbstractControlModule;
import cn.com.voltronic.solar.control.IP30ControlModule;
import cn.com.voltronic.solar.util.VolUtil;

public class P30SNMPControlModule
extends AbstractControlModule
implements IP30ControlModule {
    public P30SNMPControlModule(Object handler) {
        super(handler);
    }

    @Override
    public boolean setBatteryLow(double value) {
        return false;
    }

    @Override
    public boolean setBatteryType(String value) {
        try {
            int mibValue = VolUtil.parseInt(value);
            return this.getHandler().set(".1.3.6.1.4.1.21111.1.2.11.5", String.valueOf(mibValue), 4);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean setBatteryUnder(double value) {
        try {
            int mibValue = (int)(value * 10.0);
            return this.getHandler().set(".1.3.6.1.4.1.21111.1.2.14.68", String.valueOf(mibValue), 4);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean setCapability(String x, boolean isEnable) {
        try {
            int mibValue;
            String oid = "";
            int n = mibValue = isEnable ? 1 : 0;
            if (x.equals("a")) {
                oid = ".1.3.6.1.4.1.21111.1.2.14.19";
            } else if (x.equals("b")) {
                oid = ".1.3.6.1.4.1.21111.1.2.14.61";
            } else if (x.equals("j")) {
                oid = ".1.3.6.1.4.1.21111.1.2.14.62";
            } else if (x.equals("k")) {
                oid = ".1.3.6.1.4.1.21111.1.2.14.10";
            } else if (x.equals("u")) {
                oid = ".1.3.6.1.4.1.21111.1.2.14.63";
            } else if (x.equals("v")) {
                oid = ".1.3.6.1.4.1.21111.1.2.14.64";
            } else if (x.equals("x")) {
                oid = ".1.3.6.1.4.1.21111.1.2.14.65";
            } else if (x.equals("y")) {
                oid = ".1.3.6.1.4.1.21111.1.2.14.66";
            } else if (x.equals("z")) {
                oid = ".1.3.6.1.4.1.21111.1.2.14.67";
            } else if (x.equals("l")) {
                oid = ".1.3.6.1.4.1.21111.1.2.14.81";
            }
            return this.getHandler().set(oid, String.valueOf(mibValue), 4);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean setChargerSource(String value) {
        try {
            return this.getHandler().set(".1.3.6.1.4.1.21111.1.2.11.8", this.getFomatStr(String.valueOf(value), 2), 4);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean setFloatingVoltage(double value) {
        try {
            int mibValue = (int)(value * 10.0);
            return this.getHandler().set(".1.3.6.1.4.1.21111.1.2.14.57", String.valueOf(mibValue), 4);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean setGridWorkRange(String value) {
        try {
            int mibValue = VolUtil.parseInt(value);
            return this.getHandler().set(".1.3.6.1.4.1.21111.1.2.11.6", String.valueOf(mibValue), 4);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean setMaxChargingCurrent(int value) {
        try {
            return this.getHandler().set(".1.3.6.1.4.1.21111.1.2.14.34", String.valueOf(value), 4);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean setMaxChargingVoltage(double value) {
        try {
            int mibValue = (int)(value * 10.0);
            return this.getHandler().set(".1.3.6.1.4.1.21111.1.2.14.54", String.valueOf(mibValue), 4);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean setNPMaxChargingCurrent(int key, int maxChargeCurrent) {
        try {
            return this.getHandler().set(".1.3.6.1.4.1.21111.1.2.15.3", key + String.format("%03d", maxChargeCurrent), 4);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean setOutputFrequency(int mibValue) {
        try {
            return this.getHandler().set(".1.3.6.1.4.1.21111.1.2.2.4", String.valueOf(mibValue), 4);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean setOutputMode(int key, int mode) {
        try {
            return this.getHandler().set(".1.3.6.1.4.1.21111.1.2.11.9", String.valueOf(key) + mode, 4);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean setOutputSource(String value) {
        try {
            int mibValue = VolUtil.parseInt(value);
            return this.getHandler().set(".1.3.6.1.4.1.21111.1.2.11.7", String.valueOf(mibValue), 4);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean setOutputVoltage(int value) {
        try {
            int mibValue = value * 10;
            return this.getHandler().set(".1.3.6.1.4.1.21111.1.2.2.8", String.valueOf(mibValue), 4);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean setPChargerSource(int key, String value) {
        try {
            return this.getHandler().set(".1.3.6.1.4.1.21111.1.2.15.4", key + value, 4);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean setPF() {
        try {
            return this.getHandler().set(".1.3.6.1.4.1.21111.1.2.14.17", "1", 4);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean setPMaxChargingCurrent(int key, int maxChargeCurrent) {
        try {
            return this.getHandler().set(".1.3.6.1.4.1.21111.1.2.14.34", key + String.format("%02d", maxChargeCurrent), 4);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean setReDisChargeVoltage(double value) {
        try {
            int mibValue = (int)(value * 10.0);
            return this.getHandler().set(".1.3.6.1.4.1.21111.1.2.14.58", String.valueOf(mibValue), 4);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean setRechargingVol(double value) {
        try {
            int mibValue = (int)(value * 10.0);
            return this.getHandler().set(".1.3.6.1.4.1.21111.1.2.14.49", String.valueOf(mibValue), 4);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setParallelIndex(int value) {
        try {
            return this.getHandler().set(".1.3.6.1.4.1.21111.1.2.15.2", String.valueOf(value), 4);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setPPVOKC(int value) {
        try {
            return this.getHandler().set(".1.3.6.1.4.1.21111.1.2.14.59", String.valueOf(value), 4);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setPSPB(int value) {
        try {
            return this.getHandler().set(".1.3.6.1.4.1.21111.1.2.14.60", String.valueOf(value), 4);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setPMaxACChargeCurrent(int key, int maxChargeCurrent) {
        try {
            return this.getHandler().set(".1.3.6.1.4.1.21111.1.2.14.69", key + String.format("%02d", maxChargeCurrent), 4);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public SNMPHandler getHandler() {
        SNMPHandler handler = null;
        try {
            handler = (SNMPHandler)super.getHandler();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return handler;
    }

    @Override
    public boolean setMSCHGC(String value) {
        return false;
    }

    @Override
    public boolean setPCST(String value) {
        return false;
    }

    @Override
    public boolean setPCVT(String value) {
        return false;
    }

    @Override
    public boolean setPOPV(int value) {
        return this.setOutputVoltage(value);
    }

    @Override
    public boolean setPBEQA(int value) {
        return false;
    }

    @Override
    public boolean setPBEQE(int value) {
        return false;
    }

    @Override
    public boolean setPBEQOT(double value) {
        return false;
    }

    @Override
    public boolean setPBEQP(double value) {
        return false;
    }

    @Override
    public boolean setPBEQT(double value) {
        return false;
    }

    @Override
    public boolean setPBEQV(double value) {
        return false;
    }

    @Override
    public boolean setBatReDischargeCapacity(double value) {
        return false;
    }

    @Override
    public boolean setPCVT(double value) {
        try {
            int mibValue = (int)value;
            return this.getHandler().set(".1.3.6.1.4.1.21111.1.2.14.83", String.valueOf(mibValue), 4);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean setLBF(int value) {
        return false;
    }
}

