/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.dao;

import cn.com.voltronic.solar.dao.BaseDao;
import cn.com.voltronic.solar.data.bean.DeviceBean;
import cn.com.voltronic.solar.dbtools.DBManager;
import cn.com.voltronic.solar.system.GlobalProcessors;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

public class DeviceDao
extends BaseDao {
    private static final String INSERT_SERIALNO = "INSERT INTO SERIALNO(prodid,serialno,mpptnumber,modetype,parallel) VALUES(?,?,?,?,?)";
    private static final String SELECT_SERIALNO = "select * from serialno where serialno=? order by serialno";
    private static final String QUERYDATA_PRODID = " SELECT distinct prodid FROM serialno order by prodid";
    private static final String QUERYDATA_SERIALNO = " SELECT distinct serialno FROM SERIALNO order by serialno";
    private static final String UPDATE_SERIALNO = " update serialno set mpptnumber=?,modetype=?,parallel=? where prodid=? and serialno=? ";
    private static final String DELETE = "delete from serialno";

    public boolean InsertOrUpdateDevice(DeviceBean bean) {
        boolean result;
        block9: {
            result = false;
            boolean update = false;
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                try {
                    ps = conn.prepareStatement("select serialno from serialno where prodid=? and serialno=? ");
                    ps.setString(1, bean.getProdid());
                    ps.setString(2, bean.getSerialno());
                    rs = ps.executeQuery();
                    if (rs.next()) {
                        update = true;
                    }
                    this.close(rs, ps);
                    rs = null;
                    if (update) {
                        ps = conn.prepareStatement(UPDATE_SERIALNO);
                        ps.setInt(1, bean.getMpptnumber());
                        ps.setString(2, bean.getModetype());
                        ps.setInt(3, bean.getParallel());
                        ps.setString(4, bean.getProdid());
                        ps.setString(5, bean.getSerialno());
                    } else {
                        ps = conn.prepareStatement(INSERT_SERIALNO);
                        ps.setString(1, bean.getProdid());
                        ps.setString(2, bean.getSerialno());
                        ps.setInt(3, bean.getMpptnumber());
                        ps.setString(4, bean.getModetype());
                        ps.setInt(5, bean.getParallel());
                    }
                    if (ps.executeUpdate() > 0) {
                        result = true;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return result;
    }

    public List<String> queryProdidAll() {
        ArrayList<String> result;
        block7: {
            result = new ArrayList<String>();
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            if (conn != null) {
                try {
                    try {
                        ps = conn.prepareStatement(QUERYDATA_PRODID);
                        rs = ps.executeQuery();
                        while (rs.next()) {
                            result.add(rs.getString("prodid"));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.close(rs, ps);
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    this.close(rs, ps);
                    throw throwable;
                }
                this.close(rs, ps);
            }
        }
        return result;
    }

    public List<String> querySerialnoAll() {
        ArrayList<String> result;
        block7: {
            result = new ArrayList<String>();
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            if (conn != null) {
                try {
                    try {
                        ps = conn.prepareStatement(QUERYDATA_SERIALNO);
                        rs = ps.executeQuery();
                        while (rs.next()) {
                            result.add(rs.getString("serialno"));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.close(rs, ps);
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    this.close(rs, ps);
                    throw throwable;
                }
                this.close(rs, ps);
            }
        }
        return result;
    }

    public DeviceBean queryDevicebySerialno(String serialno) {
        DeviceBean bean;
        block8: {
            bean = null;
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            if (conn != null) {
                try {
                    try {
                        ps = conn.prepareStatement(SELECT_SERIALNO);
                        ps.setString(1, serialno);
                        rs = ps.executeQuery();
                        while (rs.next()) {
                            bean = new DeviceBean();
                            bean.setProdid(rs.getString("prodid"));
                            bean.setSerialno(rs.getString("serialno"));
                            bean.setMpptnumber(rs.getInt("mpptnumber"));
                            bean.setModetype(rs.getString("modetype"));
                            bean.setParallel(rs.getInt("parallel"));
                            if (!GlobalProcessors.getCurrentProcessor().getProtocol().getProtocolID().equals(rs.getString("prodid"))) {
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.close(rs, ps);
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    this.close(rs, ps);
                    throw throwable;
                }
                this.close(rs, ps);
            }
        }
        return bean;
    }

    public boolean updateDevice(DeviceBean bean) {
        boolean result = false;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement(UPDATE_SERIALNO);
                ps.setInt(1, bean.getMpptnumber());
                ps.setString(2, bean.getModetype());
                ps.setInt(3, bean.getParallel());
                ps.setString(4, bean.getProdid());
                ps.setString(5, bean.getSerialno());
                if (ps.executeUpdate() > 0) {
                    result = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
        return result;
    }

    public boolean deleteAll() {
        boolean result = false;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement(DELETE);
                if (ps.executeUpdate() > 0) {
                    result = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
        return result;
    }

    public boolean aliasDevice(String original, String newValue) {
        boolean result;
        block8: {
            result = false;
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                try {
                    ps = conn.prepareStatement("SELECT * FROM DEVICE_ALIAS WHERE DEVICE_ALIAS = ?");
                    ps.setString(1, original);
                    rs = ps.executeQuery();
                    if (rs.next()) {
                        String device = rs.getString("DEVICE");
                        ps = conn.prepareStatement("UPDATE DEVICE_ALIAS SET DEVICE_ALIAS = ? WHERE DEVICE = ?");
                        ps.setString(1, newValue);
                        ps.setString(2, device);
                    } else {
                        ps = conn.prepareStatement("INSERT INTO DEVICE_ALIAS(DEVICE,DEVICE_ALIAS) VALUES(?,?)");
                        ps.setString(1, original);
                        ps.setString(2, newValue);
                    }
                    if (ps.executeUpdate() > 0) {
                        result = true;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return result;
    }

    public String queryAlias(String device) {
        String alias;
        block6: {
            alias = "";
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                try {
                    ps = conn.prepareStatement("SELECT DEVICE_ALIAS FROM DEVICE_ALIAS WHERE DEVICE = ?");
                    ps.setString(1, device);
                    rs = ps.executeQuery();
                    if (rs.next()) {
                        alias = rs.getString("DEVICE_ALIAS");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return alias;
    }

    public String queryDevice(String alias) {
        String device;
        block6: {
            device = "";
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                try {
                    ps = conn.prepareStatement("SELECT DEVICE FROM DEVICE_ALIAS WHERE DEVICE_ALIAS = ?");
                    ps.setString(1, alias);
                    rs = ps.executeQuery();
                    if (rs.next()) {
                        device = rs.getString("DEVICE");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return device;
    }

    public boolean deleteDeviceAlias() {
        boolean result = false;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement("DELETE FROM DEVICE_ALIAS");
                if (ps.executeUpdate() > 0) {
                    result = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
        return result;
    }

    public boolean deleteDeviceAlias(String alias) {
        boolean result = false;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement("DELETE FROM DEVICE_ALIAS WHERE DEVICE_ALIAS = ?");
                ps.setString(1, alias);
                if (ps.executeUpdate() > 0) {
                    result = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
        return result;
    }
}

