/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.dao;

import cn.com.voltronic.solar.dao.BaseDao;
import cn.com.voltronic.solar.data.bean.EventData;
import cn.com.voltronic.solar.data.bean.EventDataRecord;
import cn.com.voltronic.solar.data.bean.EventStatis;
import cn.com.voltronic.solar.data.bean.EventStatisItem;
import cn.com.voltronic.solar.dbtools.DBManager;
import cn.com.voltronic.solar.exception.EventsHandler;
import cn.com.voltronic.solar.util.DateUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class EventRecordDao
extends BaseDao {
    private static final String INSERT_EVENTRECORD = "insert into event_record (prodid,serialno,eventid,trandate) values(?,?,?,?)";
    private static final String QUERY_EVENTRECORD = "select * from event_record where serialno = ? and trandate BETWEEN ? and ? order by trandate desc";
    private static final String QUERY_ALLDEVICE = "select DISTINCT serialno from event_record order by serialno";
    private static final String DELETE_EVENTRECORD = "delete from event_record where serialno = ? and eventid = ? and trandate = ?";
    private static final String DELETE_EVENTRECORD_ALL = "delete from event_record where serialno = ? and trandate BETWEEN ? and ?";
    public static final String QUERY_EVENTDATA_ST = " select prodid, eventid,count(eventid) as ecount FROM event_record WHERE serialno=? and trandate BETWEEN ? AND ? group by eventid, prodid";

    public boolean insertEvent(EventDataRecord data) {
        Date reDate = DateUtils.getDateParseDate(data.getTrandate());
        if (reDate == null) {
            return false;
        }
        boolean result = false;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement(INSERT_EVENTRECORD);
                ps.setString(1, data.getProdId());
                ps.setString(2, data.getSerialNo());
                ps.setString(3, data.getEventId());
                ps.setTimestamp(4, new Timestamp(reDate.getTime()));
                if (ps.executeUpdate() > 0) {
                    result = true;
                }
                conn.commit();
            }
            catch (Exception e) {
                result = false;
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
        return result;
    }

    public List<EventStatisItem> queryEventStatistics(String serialno, Date begin, Date end, boolean includeInfo) {
        ArrayList<EventStatis> lists;
        block11: {
            lists = new ArrayList<EventStatis>();
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            if (conn != null) {
                try {
                    try {
                        ps = conn.prepareStatement(QUERY_EVENTDATA_ST);
                        ps.setString(1, serialno);
                        ps.setDate(2, new java.sql.Date(begin.getTime()));
                        ps.setDate(3, new java.sql.Date(end.getTime() + 86400000L));
                        rs = ps.executeQuery();
                        while (rs.next()) {
                            EventStatis data = new EventStatis();
                            data.setProdid(rs.getString("prodid"));
                            data.setEventId(rs.getString("eventid"));
                            data.setCount(rs.getInt("ecount"));
                            lists.add(data);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.close(rs, ps);
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    this.close(rs, ps);
                    throw throwable;
                }
                this.close(rs, ps);
            }
        }
        ArrayList<EventStatisItem> eventStatisItem = new ArrayList<EventStatisItem>();
        int i = 0;
        while (i < lists.size()) {
            String eventid = ((EventStatis)lists.get(i)).getEventId();
            int level = EventsHandler.getEventLevel(EventsHandler.getDocumentByProdid(((EventStatis)lists.get(i)).getProdid()), eventid);
            String name = EventsHandler.getEventname(EventsHandler.getDocumentByProdid(((EventStatis)lists.get(i)).getProdid()), eventid);
            EventStatisItem items = new EventStatisItem();
            items.setEventId(eventid);
            items.setCount(((EventStatis)lists.get(i)).getCount());
            items.setLevel(level);
            items.setName(name);
            if (includeInfo) {
                eventStatisItem.add(items);
            } else if (items.getLevel() != 3) {
                eventStatisItem.add(items);
            }
            ++i;
        }
        return eventStatisItem;
    }

    public boolean alreadyInsert(EventDataRecord data) {
        boolean result;
        block6: {
            result = false;
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                try {
                    ps = conn.prepareStatement("select * from event_record where serialno=? and trandate=? and eventid=?");
                    ps.setString(1, data.getSerialNo());
                    ps.setTimestamp(2, new Timestamp(data.getTrandate().getTime()));
                    ps.setString(3, data.getEventId());
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        result = true;
                    }
                    conn.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return result;
    }

    public List<EventDataRecord> queryEvent(String serialno, Date fromDate, Date toDate, boolean includeInfo) {
        ArrayList<EventDataRecord> list;
        block7: {
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            EventDataRecord event = null;
            ResultSet rs = null;
            list = new ArrayList<EventDataRecord>();
            try {
                try {
                    ps = conn.prepareStatement(QUERY_EVENTRECORD);
                    ps.setString(1, serialno);
                    ps.setDate(2, new java.sql.Date(fromDate.getTime()));
                    ps.setDate(3, new java.sql.Date(toDate.getTime() + 86400000L));
                    rs = ps.executeQuery();
                    conn.commit();
                    while (rs.next()) {
                        event = new EventDataRecord();
                        String prodid = rs.getString("prodid");
                        event.setProdId(prodid);
                        event.setSerialNo(rs.getString("serialno"));
                        String eventId = rs.getString("eventid");
                        event.setEventId(eventId);
                        event.setTrandate(rs.getTimestamp("trandate"));
                        EventData eventData = EventsHandler.getEventById(prodid, eventId);
                        int level = eventData.getEventLevel();
                        if (includeInfo) {
                            list.add(event);
                            continue;
                        }
                        if (level == 3) continue;
                        list.add(event);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    this.close(rs, ps);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return list;
    }

    public List<String> queryDevices() {
        ArrayList<String> list;
        block6: {
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            list = new ArrayList<String>();
            ResultSet rs = null;
            try {
                try {
                    ps = conn.prepareStatement(QUERY_ALLDEVICE);
                    rs = ps.executeQuery();
                    conn.commit();
                    while (rs.next()) {
                        list.add(rs.getString("serialno"));
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    this.close(rs, ps);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return list;
    }

    public boolean deleteEventRecord(String serialno, String eventid, Date deldate) {
        boolean result = false;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement(DELETE_EVENTRECORD);
                ps.setString(1, serialno);
                ps.setString(2, eventid);
                ps.setTimestamp(3, new Timestamp(deldate.getTime()));
                if (ps.executeUpdate() > 0) {
                    result = true;
                }
                conn.commit();
            }
            catch (Exception ex) {
                result = false;
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
        return result;
    }

    public boolean deleteEventRecordAll(String serialno, Date fromDate, Date toDate) {
        boolean result = false;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement(DELETE_EVENTRECORD_ALL);
                ps.setString(1, serialno);
                ps.setDate(2, new java.sql.Date(fromDate.getTime()));
                ps.setDate(3, new java.sql.Date(toDate.getTime() + 86400000L));
                if (ps.executeUpdate() > 0) {
                    result = true;
                }
                conn.commit();
            }
            catch (Exception ex) {
                result = false;
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
        return result;
    }

    public boolean deleteAll() {
        boolean result = false;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement("delete from event_record;");
                if (ps.executeUpdate() > 0) {
                    result = true;
                }
                conn.commit();
            }
            catch (Exception ex) {
                result = false;
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
        return result;
    }

    public static void main(String[] args) {
        EventRecordDao dao = new EventRecordDao();
        EventDataRecord data = new EventDataRecord();
        data.setEventId("1004");
        data.setSerialNo("90000000000000");
        data.setTrandate(new Date());
        dao.insertEvent(data);
    }
}

