/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.dao;

import cn.com.voltronic.solar.dao.BaseDao;
import cn.com.voltronic.solar.data.bean.DataBeforeFault;
import cn.com.voltronic.solar.dbtools.DBManager;
import cn.com.voltronic.solar.exception.EventsHandler;
import cn.com.voltronic.solar.util.DateUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class FaultDataDao
extends BaseDao {
    private final String DELETE_FAULTDATA = "delete from faultdata where serialno = ? and trandate between ? and ?";
    private final String DELETE_FAULTDATA_ALL = "delete from faultdata where serialno = ? and trandate BETWEEN ? and ?";

    public List<String> getAllProdid() {
        ArrayList<String> result;
        block6: {
            result = new ArrayList<String>();
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                try {
                    ps = conn.prepareStatement("SELECT distinct prodid FROM faultdata");
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        result.add(rs.getString("prodid"));
                    }
                    conn.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return result;
    }

    public String getProdidBySerialno(String serialno) {
        String result;
        block6: {
            result = "";
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                try {
                    ps = conn.prepareStatement("SELECT distinct prodid FROM faultdata where serialno=?");
                    ps.setString(1, serialno);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        result = rs.getString("prodid");
                    }
                    conn.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return result;
    }

    public List<String> getSerialNo() {
        ArrayList<String> result;
        block6: {
            result = new ArrayList<String>();
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                try {
                    ps = conn.prepareStatement("SELECT distinct serialno FROM faultdata order by serialno");
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        result.add(rs.getString("serialno"));
                    }
                    conn.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return result;
    }

    public boolean alreadyInsert(DataBeforeFault data) {
        boolean result;
        block6: {
            result = false;
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                try {
                    ps = conn.prepareStatement("select * from faultdata where serialno=? and trandate=? and faultString=? order by trandate desc");
                    ps.setString(1, data.getSerialno());
                    ps.setTimestamp(2, new Timestamp(data.getTrandate().getTime()));
                    ps.setString(3, data.getFaultString());
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        result = true;
                    }
                    conn.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return result;
    }

    public boolean insertData(DataBeforeFault faultdata) {
        boolean result = true;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement(" INSERT INTO faultdata ( prodid,serialno,faultString,trandate,workmode,gridvoltager,gridfrequency,pvinputvoltage1,outputapparentpower,outputactivepower,pbatteryvoltage,batterycapacity,chargingcurrent,acoutputvoltager,acoutputfrequency,ttlchargingcurrent,ttloutputapparentpower,ttloutputactivepower,ttloutputpercent,pvInputCurrent,batDisCurrent,pvinputvoltage2,pvinputvoltage3,rgridvoltage,sgridvoltage,tgridvoltage,rphaseacoutputvoltage,sphaseacoutputvoltage,tphaseacoutputvoltage,outputapparentpowerr,outputapparentpowers,outputapparentpowert,outputactivepowerr,outputactivepowers,outputactivepowert) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                ps.setString(1, faultdata.getProdid());
                ps.setString(2, faultdata.getSerialno());
                ps.setString(3, faultdata.getFaultString());
                ps.setTimestamp(4, new Timestamp(faultdata.getTrandate().getTime()));
                ps.setString(5, faultdata.getWorkMode());
                ps.setDouble(6, faultdata.getGridVoltageR());
                ps.setDouble(7, faultdata.getGridFrequency());
                ps.setDouble(8, faultdata.getPvInputVoltage1());
                ps.setDouble(9, faultdata.getAcOutputApparentPower());
                ps.setDouble(10, faultdata.getAcOutputActivePower());
                ps.setDouble(11, faultdata.getPBatteryVoltage());
                ps.setInt(12, faultdata.getBatteryCapacity());
                ps.setDouble(13, faultdata.getChargingCurrent());
                ps.setDouble(14, faultdata.getAcOutputVoltageR());
                ps.setDouble(15, faultdata.getAcOutputFrequency());
                ps.setDouble(16, faultdata.getTtlChargingCurrent());
                ps.setDouble(17, faultdata.getAcTtlOutputApparentPower());
                ps.setDouble(18, faultdata.getAcTtlOutputActivePower());
                ps.setDouble(19, faultdata.getAcTtlOutputPercent());
                ps.setDouble(20, faultdata.getPvInputCurrent());
                ps.setDouble(21, faultdata.getBatDisCurrent());
                ps.setDouble(22, faultdata.getPvInputVoltage2());
                ps.setDouble(23, faultdata.getPvInputVoltage3());
                ps.setDouble(24, faultdata.getRGridVoltage());
                ps.setDouble(25, faultdata.getSGridVoltage());
                ps.setDouble(26, faultdata.getTGridVoltage());
                ps.setDouble(27, faultdata.getRPhaseACOutputVoltage());
                ps.setDouble(28, faultdata.getSPhaseACOutputVoltage());
                ps.setDouble(29, faultdata.getTPhaseACOutputVoltage());
                ps.setInt(30, faultdata.getOutputApparentPowerR());
                ps.setInt(31, faultdata.getOutputApparentPowerS());
                ps.setInt(32, faultdata.getOutputApparentPowerT());
                ps.setInt(33, faultdata.getOutputActivePowerR());
                ps.setInt(34, faultdata.getOutputActivePowerS());
                ps.setInt(35, faultdata.getOutputActivePowerT());
                ps.executeUpdate();
                conn.commit();
            }
            catch (Exception e) {
                e.printStackTrace();
                result = false;
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
        return result;
    }

    public List<DataBeforeFault> queryData(String serialno, Date beginDate, Date endDate) {
        ArrayList<DataBeforeFault> resultList;
        block6: {
            String prodid = "P30";
            prodid = this.getProdidBySerialno(serialno);
            Calendar end = Calendar.getInstance();
            end.setTime(endDate);
            Calendar start = Calendar.getInstance();
            start.setTime(beginDate);
            resultList = new ArrayList<DataBeforeFault>();
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                try {
                    ps = conn.prepareStatement("select * from faultdata where serialno=? and trandate between ? and ? order by trandate desc");
                    ps.setString(1, serialno);
                    ps.setTimestamp(2, new Timestamp(DateUtils.getStartofDayFullTime(start).getTime().getTime()));
                    ps.setTimestamp(3, new Timestamp(DateUtils.getEndofDayFullTime(end).getTime().getTime()));
                    rs = ps.executeQuery();
                    conn.commit();
                    while (rs.next()) {
                        DataBeforeFault data = new DataBeforeFault();
                        data.setSerialno(serialno);
                        data.setTrandate(rs.getTimestamp("trandate"));
                        String faultString = "";
                        faultString = prodid.equals("P30PLUSDUO") ? EventsHandler.getEventname(EventsHandler.getDocumentPlusDuo(), rs.getString("faultString")) : (prodid.equals("P30PLUSTRI") ? EventsHandler.getEventname(EventsHandler.getDocumentPlusTri(), rs.getString("faultString")) : EventsHandler.getEventname(EventsHandler.getDocument30(), rs.getString("faultString")));
                        data.setFaultString(faultString);
                        data.setWorkMode(rs.getString("workmode"));
                        data.setGridVoltageR(rs.getDouble("gridvoltager"));
                        data.setGridFrequency(rs.getDouble("gridfrequency"));
                        data.setPvInputVoltage1(rs.getDouble("pvinputvoltage1"));
                        data.setPvInputVoltage2(rs.getDouble("pvinputvoltage2"));
                        data.setPvInputVoltage3(rs.getDouble("pvinputvoltage3"));
                        data.setAcOutputApparentPower(rs.getDouble("outputapparentpower"));
                        data.setAcOutputActivePower(rs.getDouble("outputactivepower"));
                        data.setPBatteryVoltage(rs.getDouble("pbatteryvoltage"));
                        data.setBatteryCapacity(rs.getInt("batterycapacity"));
                        data.setChargingCurrent(rs.getDouble("chargingcurrent"));
                        data.setAcOutputVoltageR(rs.getDouble("acoutputvoltager"));
                        data.setAcOutputFrequency(rs.getDouble("acoutputfrequency"));
                        data.setTtlChargingCurrent(rs.getDouble("ttlchargingcurrent"));
                        data.setAcTtlOutputApparentPower(rs.getDouble("ttloutputapparentpower"));
                        data.setAcTtlOutputActivePower(rs.getDouble("ttloutputactivepower"));
                        data.setAcTtlOutputPercent(rs.getDouble("ttloutputpercent"));
                        data.setPvInputCurrent(rs.getDouble("pvInputCurrent"));
                        data.setBatDisCurrent(rs.getDouble("batDisCurrent"));
                        data.setRGridVoltage(rs.getDouble("rgridvoltage"));
                        data.setSGridVoltage(rs.getDouble("sgridvoltage"));
                        data.setTGridVoltage(rs.getDouble("tgridvoltage"));
                        data.setRPhaseACOutputVoltage(rs.getDouble("rphaseacoutputvoltage"));
                        data.setSPhaseACOutputVoltage(rs.getDouble("sphaseacoutputvoltage"));
                        data.setTPhaseACOutputVoltage(rs.getDouble("tphaseacoutputvoltage"));
                        data.setOutputApparentPowerR(rs.getInt("outputapparentpowerr"));
                        data.setOutputApparentPowerS(rs.getInt("outputapparentpowers"));
                        data.setOutputApparentPowerT(rs.getInt("outputapparentpowert"));
                        data.setOutputActivePowerR(rs.getInt("outputactivepowerr"));
                        data.setOutputActivePowerS(rs.getInt("outputactivepowers"));
                        data.setOutputActivePowerT(rs.getInt("outputactivepowert"));
                        resultList.add(data);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return resultList;
    }

    public boolean removeData(String serialno, Date date) {
        boolean result = false;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement("delete from faultdata where serialno = ? and trandate between ? and ?");
                ps.setString(1, serialno);
                ps.setTimestamp(2, new Timestamp(date.getTime()));
                Calendar ca = Calendar.getInstance();
                ca.setTime(date);
                ca.add(13, 1);
                ps.setTimestamp(3, new Timestamp(ca.getTime().getTime()));
                if (ps.executeUpdate() > 0) {
                    result = true;
                }
            }
            catch (Exception e) {
                result = false;
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
        return result;
    }

    public boolean removeDataAll(String serialno, Date fromDate, Date toDate) {
        boolean result = false;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement("delete from faultdata where serialno = ? and trandate BETWEEN ? and ?");
                ps.setString(1, serialno);
                ps.setDate(2, new java.sql.Date(fromDate.getTime()));
                ps.setDate(3, new java.sql.Date(toDate.getTime() + 86400000L));
                if (ps.executeUpdate() > 0) {
                    result = true;
                }
            }
            catch (Exception e) {
                result = false;
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
        return result;
    }

    public boolean removeAll() {
        boolean result = true;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement("delete from faultdata");
                ps.executeUpdate();
                conn.commit();
            }
            catch (Exception e) {
                result = false;
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
        return result;
    }

    public static void main(String[] args) {
        FaultDataDao dao = new FaultDataDao();
        DataBeforeFault faultdata = new DataBeforeFault();
        faultdata.setProdid("P16");
        faultdata.setSerialno("90000000000002");
        faultdata.setFaultString("1002");
        boolean re = dao.insertData(faultdata);
        System.out.println(re);
    }
}

