/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.dao;

import cn.com.voltronic.solar.dao.BaseDao;
import cn.com.voltronic.solar.data.bean.WorkInfo;
import cn.com.voltronic.solar.dbtools.DBManager;
import cn.com.voltronic.solar.util.DateUtils;
import cn.com.voltronic.solar.util.VolUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class WorkDataDao
extends BaseDao {
    @Override
    public boolean writeRecords() {
        WorkInfo workinfo = (WorkInfo)this.getBeanBag().getBean("workinfo");
        if (workinfo.getProdid() == null || "".equals(workinfo.getProdid()) || workinfo.getSerialno() == null || "".equals(workinfo.getSerialno()) || workinfo.getCurrentTime() == null || "---".equals(workinfo.getWorkMode()) || "".equals(workinfo.getWorkMode())) {
            return false;
        }
        return this.insertWorkInfo(workinfo);
    }

    public boolean removeWork(String prodid, String serialno, Date date) {
        boolean result;
        block6: {
            result = false;
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            try {
                try {
                    String sqlStr = "delete from WORK_DATA where prodid=? and serialno=? and currentTime=?";
                    ps = conn.prepareStatement(sqlStr);
                    ps.setString(1, prodid);
                    ps.setString(2, serialno);
                    ps.setTimestamp(3, new Timestamp(date.getTime()));
                    if (ps.executeUpdate() > 0) {
                        result = true;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.close(ps);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(ps);
                throw throwable;
            }
            this.close(ps);
        }
        return result;
    }

    public boolean removeAllWork(String prodid, String serialno, Date beginDate, Date endDate) {
        Calendar end = Calendar.getInstance();
        end.setTime(endDate);
        Calendar start = Calendar.getInstance();
        start.setTime(beginDate);
        boolean result = false;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement("delete from WORK_DATA where prodid=? and serialno=? and currentTime between ? and ?");
                ps.setString(1, prodid);
                ps.setString(2, serialno);
                ps.setTimestamp(3, new Timestamp(DateUtils.getStartofDayFullTime(start).getTime().getTime()));
                ps.setTimestamp(4, new Timestamp(DateUtils.getEndofDayFullTime(end).getTime().getTime()));
                if (ps.executeUpdate() > 0) {
                    result = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
        return result;
    }

    @Override
    public boolean qrySameRecord(WorkInfo workinfo) {
        boolean result;
        block6: {
            result = false;
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                try {
                    String sqlStr = "select count(*) as count from WORK_DATA where prodid=? and serialno=? and workMode = ? and currentTime= ?";
                    ps = conn.prepareStatement(sqlStr);
                    ps.setString(1, workinfo.getProdid());
                    ps.setString(2, workinfo.getSerialno());
                    ps.setString(3, workinfo.getWorkMode());
                    ps.setTimestamp(4, new Timestamp(workinfo.getCurrentTime().getTime()));
                    rs = ps.executeQuery();
                    if (rs.next()) {
                        int count = rs.getInt("count");
                        result = count > 3;
                    }
                }
                catch (Exception exception) {
                    this.close(rs, ps);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return result;
    }

    public boolean insertWorkInfo(WorkInfo workinfo) {
        boolean result = false;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement(" INSERT INTO WORK_DATA (    prodid,serialno,workMode,gridVoltageR,gridPowerR,gridCurrentR,gridFrequency,acOutputVoltageR,acOutputPowerR,   acOutputFrequency,acOutputCurrentR,outputLoadPercent,pBatteryVoltage,nBatteryVoltage,   batteryCapacity,chargingCurrent,pvInputPower1,pvInputPower2,pvInputPower3,pvInputVoltage1,   pvInputVoltage2,pvInputVoltage3,maxTemperature,rGridVoltage,sGridVoltage,tGridVoltage,rsGridVoltage,rtGridVoltage,stGridVoltage,rGridCurrent,sGridCurrent,   tGridCurrent,rPhasePower,sPhasePower,tPhasePower,wholePower,rPhaseACOutputVoltage,sPhaseACOutputVoltage,tPhaseACOutputVoltage,rsPhaseACOutputVoltage,rtPhaseACOutputVoltage,stPhaseACOutputVoltage,   rACOutputCurrent,sACOutputCurrent,tACOutputCurrent,rPhaseACOutputLoad,sPhaseACOutputLoad,tPhaseACOutputLoad,wholeACOutputLoad,   batteryPieceNumber,batteryTotalCapacity,batteryRemainTime,OUTPUTAPPARENTPOWER,OUTPUTACTIVEPOWER,   TTLCHARGINGCURRENT,TTLOUTPUTAPPARENTPOWER,TTLOUTPUTACTIVEPOWER, TTLOUTPUTPERCENT,pvInputCurrent,batDisCurrent,   PVINPUTCURRENTFORBATTTERY,PVINPUTCURRENT1,PVINPUTCURRENT2,PVINPUTCURRENT3,\tOUTPUTAPPARENTPOWERR,OUTPUTAPPARENTPOWERS,OUTPUTAPPARENTPOWERT,OUTPUTACTIVEPOWERR,OUTPUTACTIVEPOWERS,OUTPUTACTIVEPOWERT,\tcurrentTime) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                ps.setString(1, workinfo.getProdid());
                ps.setString(2, workinfo.getSerialno());
                ps.setString(3, workinfo.getWorkMode());
                ps.setDouble(4, workinfo.getGridVoltageR());
                ps.setDouble(5, workinfo.getGridPowerR());
                ps.setDouble(6, workinfo.getGridCurrentR());
                ps.setDouble(7, workinfo.getGridFrequency());
                ps.setDouble(8, workinfo.getAcOutputVoltageR());
                ps.setDouble(9, workinfo.getAcOutputPowerR());
                ps.setDouble(10, workinfo.getAcOutputFrequency());
                ps.setDouble(11, workinfo.getAcOutputCurrentR());
                ps.setInt(12, workinfo.getOutputLoadPercent());
                ps.setDouble(13, workinfo.getPBatteryVoltage());
                ps.setDouble(14, workinfo.getNBatteryVoltage());
                ps.setInt(15, workinfo.getBatteryCapacity());
                ps.setDouble(16, workinfo.getChargingCurrent());
                ps.setInt(17, workinfo.getPvInputPower1());
                ps.setInt(18, workinfo.getPvInputPower2());
                ps.setInt(19, workinfo.getPvInputPower3());
                ps.setDouble(20, workinfo.getPvInputVoltage1());
                ps.setDouble(21, workinfo.getPvInputVoltage2());
                ps.setDouble(22, workinfo.getPvInputVoltage3());
                ps.setDouble(23, workinfo.getMaxTemperature());
                ps.setDouble(24, workinfo.getRGridVoltage());
                ps.setDouble(25, workinfo.getSGridVoltage());
                ps.setDouble(26, workinfo.getTGridVoltage());
                ps.setDouble(27, workinfo.getRsGridVoltage());
                ps.setDouble(28, workinfo.getRtGridVoltage());
                ps.setDouble(29, workinfo.getStGridVoltage());
                ps.setDouble(30, workinfo.getRGridCurrent());
                ps.setDouble(31, workinfo.getSGridCurrent());
                ps.setDouble(32, workinfo.getTGridCurrent());
                ps.setInt(33, workinfo.getRPhasePower());
                ps.setInt(34, workinfo.getSPhasePower());
                ps.setInt(35, workinfo.getTPhasePower());
                ps.setInt(36, workinfo.getWholePower());
                ps.setDouble(37, workinfo.getRPhaseACOutputVoltage());
                ps.setDouble(38, workinfo.getSPhaseACOutputVoltage());
                ps.setDouble(39, workinfo.getTPhaseACOutputVoltage());
                ps.setDouble(40, workinfo.getRsPhaseACOutputVoltage());
                ps.setDouble(41, workinfo.getRtPhaseACOutputVoltage());
                ps.setDouble(42, workinfo.getStPhaseACOutputVoltage());
                ps.setDouble(43, workinfo.getRACOutputCurrent());
                ps.setDouble(44, workinfo.getSACOutputCurrent());
                ps.setDouble(45, workinfo.getTACOutputCurrent());
                ps.setInt(46, workinfo.getRPhaseACOutputLoad());
                ps.setInt(47, workinfo.getSPhaseACOutputLoad());
                ps.setInt(48, workinfo.getTPhaseACOutputLoad());
                ps.setInt(49, workinfo.getWholeACOutputLoad());
                ps.setInt(50, workinfo.getBatteryPieceNumber());
                ps.setInt(51, workinfo.getBatteryTotalCapacity());
                ps.setInt(52, workinfo.getBatteryRemainTime());
                ps.setDouble(53, workinfo.getAcOutputApparentPower());
                ps.setDouble(54, workinfo.getAcOutputActivePower());
                ps.setDouble(55, workinfo.getTtlChargingCurrent());
                ps.setDouble(56, workinfo.getAcTtlOutputApparentPower());
                ps.setDouble(57, workinfo.getAcTtlOutputActivePower());
                ps.setDouble(58, workinfo.getAcTtlOutputPercent());
                ps.setDouble(59, workinfo.getPvInputCurrent());
                ps.setDouble(60, workinfo.getBatDisCurrent());
                ps.setDouble(61, workinfo.getPvInputCurrentForBatttery());
                ps.setDouble(62, workinfo.getPvInputCurrent1());
                ps.setDouble(63, workinfo.getPvInputCurrent2());
                ps.setDouble(64, workinfo.getPvInputCurrent3());
                ps.setInt(65, workinfo.getOutputApparentPowerR());
                ps.setInt(66, workinfo.getOutputApparentPowerS());
                ps.setInt(67, workinfo.getOutputApparentPowerT());
                ps.setInt(68, workinfo.getOutputActivePowerR());
                ps.setInt(69, workinfo.getOutputActivePowerS());
                ps.setInt(70, workinfo.getOutputActivePowerT());
                if (workinfo.getCurrentTime() != null) {
                    ps.setTimestamp(71, new Timestamp(workinfo.getCurrentTime().getTime()));
                    if (ps.executeUpdate() > 0) {
                        result = true;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
        return result;
    }

    public List<WorkInfo> queryWorkInfo(String prodid, String serialno, Date beginDate, Date endDate) {
        ArrayList<WorkInfo> result;
        block6: {
            Calendar end = Calendar.getInstance();
            end.setTime(endDate);
            Calendar start = Calendar.getInstance();
            start.setTime(beginDate);
            result = new ArrayList<WorkInfo>();
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                try {
                    ps = conn.prepareStatement("select * from WORK_DATA where serialno=? and currenttime between ? and ? order by currenttime desc");
                    ps.setString(1, serialno);
                    ps.setTimestamp(2, new Timestamp(DateUtils.getStartofDayFullTime(start).getTime().getTime()));
                    ps.setTimestamp(3, new Timestamp(DateUtils.getEndofDayFullTime(end).getTime().getTime()));
                    rs = ps.executeQuery();
                    conn.commit();
                    while (rs.next()) {
                        WorkInfo data = new WorkInfo();
                        data = this.getWorkInDB(data, rs);
                        result.add(data);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return result;
    }

    private Calendar[] getMinMaxDate(String prodid, String serialno, int year, Date begin, Date end) {
        Calendar[] result;
        block7: {
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            result = new Calendar[2];
            if (conn != null) {
                try {
                    try {
                        ps = conn.prepareStatement(" select min(currenttime) mindate, max(currenttime) maxdate from WORK_DATA where prodid=? and serialno=? and currenttime>= ? and currenttime< ? ");
                        ps.setString(1, prodid);
                        ps.setString(2, serialno);
                        ps.setDate(3, new java.sql.Date(begin.getTime()));
                        ps.setDate(4, new java.sql.Date(end.getTime()));
                        rs = ps.executeQuery();
                        if (rs != null && rs.next() && rs.getTimestamp("mindate") != null && rs.getTimestamp("maxdate") != null) {
                            result[0] = Calendar.getInstance();
                            result[0].setTime(rs.getTimestamp("mindate"));
                            result[1] = Calendar.getInstance();
                            result[1].setTime(rs.getTimestamp("maxdate"));
                        }
                    }
                    catch (Exception exception) {
                        this.close(rs, ps);
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    this.close(rs, ps);
                    throw throwable;
                }
                this.close(rs, ps);
            }
        }
        return result;
    }

    private String workInfofieldList() {
        String field = " max(prodid) as prodid, max(serialno) as serialno, max(currenttime) as currenttime, max(workMode) as workmode, max(gridVoltageR) as gridVoltageR ,max(gridPowerR) as gridPowerR,max(gridCurrentR) as gridCurrentR, max(gridFrequency) as gridFrequency,max(acOutputVoltageR) as acOutputVoltageR,max(acOutputPowerR) as acOutputPowerR, max(acOutputFrequency) as acOutputFrequency,max(acOutputCurrentR) as acOutputCurrentR,max(outputLoadPercent) as outputLoadPercent, max(pBatteryVoltage) as pBatteryVoltage,max(nBatteryVoltage) as nBatteryVoltage,max(batteryCapacity) as batteryCapacity,  max(chargingCurrent) as chargingCurrent,max(pvInputPower1) as pvInputPower1,max(pvInputPower2) as pvInputPower2,  max(pvInputPower3) as pvInputPower3,max(pvInputVoltage1) as pvInputVoltage1,max(pvInputVoltage2) as pvInputVoltage2, max(pvInputVoltage3) as pvInputVoltage3,max(maxTemperature) as maxTemperature,max(rGridVoltage) as rGridVoltage,max(sGridVoltage) as sGridVoltage, max(tGridVoltage) as tGridVoltage,max(rsGridVoltage) as rsGridVoltage,max(rtGridVoltage) as rtGridVoltage,max(stGridVoltage) as stGridVoltage, max(rGridCurrent) as rGridCurrent,max(sGridCurrent) as sGridCurrent,max(tGridCurrent) as tGridCurrent,  max(rPhasePower) as rPhasePower,max(sPhasePower) as sPhasePower,max(tPhasePower) as tPhasePower,max(wholePower) as wholePower, max(rPhaseACOutputVoltage) as rPhaseACOutputVoltage,max(sPhaseACOutputVoltage) as sPhaseACOutputVoltage,max(tPhaseACOutputVoltage) as tPhaseACOutputVoltage , max(rsPhaseACOutputVoltage) as rsPhaseACOutputVoltage,max(rtPhaseACOutputVoltage) as rtPhaseACOutputVoltage, max(stPhaseACOutputVoltage) as stPhaseACOutputVoltage,max(rACOutputCurrent) as rACOutputCurrent,max(sACOutputCurrent) as sACOutputCurrent,max(tACOutputCurrent) as tACOutputCurrent, max(rPhaseACOutputLoad) as rPhaseACOutputLoad,max(sPhaseACOutputLoad) as sPhaseACOutputLoad,max(tPhaseACOutputLoad) as tPhaseACOutputLoad, max(batteryPieceNumber) as batteryPieceNumber,max(batteryTotalCapacity) as batteryTotalCapacity,max(batteryRemainTime) as batteryRemainTime, max(wholeACOutputLoad) as wholeACOutputLoad,max(OUTPUTAPPARENTPOWER) as OUTPUTAPPARENTPOWER,max(OUTPUTACTIVEPOWER) as OUTPUTACTIVEPOWER, max(TTLCHARGINGCURRENT) as TTLCHARGINGCURRENT,max(TTLOUTPUTAPPARENTPOWER) as TTLOUTPUTAPPARENTPOWER,max(TTLOUTPUTACTIVEPOWER) as TTLOUTPUTACTIVEPOWER,max(TTLOUTPUTPERCENT) as TTLOUTPUTPERCENT, max(PVINPUTCURRENT) as PVINPUTCURRENT,max(BATDISCURRENT) as BATDISCURRENT,max(PVINPUTCURRENTFORBATTTERY) as PVINPUTCURRENTFORBATTTERY, max(PVINPUTCURRENT1) as PVINPUTCURRENT1,max(PVINPUTCURRENT2) as PVINPUTCURRENT2,max(PVINPUTCURRENT3) as PVINPUTCURRENT3, max(OUTPUTAPPARENTPOWERR) as OUTPUTAPPARENTPOWERR, max(OUTPUTAPPARENTPOWERS) as OUTPUTAPPARENTPOWERS, max(OUTPUTAPPARENTPOWERT) as OUTPUTAPPARENTPOWERT, max(OUTPUTACTIVEPOWERR) as OUTPUTACTIVEPOWERR, max(OUTPUTACTIVEPOWERS) as OUTPUTACTIVEPOWERS, max(OUTPUTACTIVEPOWERT) as OUTPUTACTIVEPOWERT";
        return field;
    }

    private WorkInfo getWorkData(String prodid, String serialno, int year, Calendar mindbDate, Calendar maxdbDate, Calendar begin, Calendar enddate) {
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        ResultSet rs = null;
        WorkInfo work = new WorkInfo();
        try {
            try {
                if (mindbDate != null && maxdbDate != null && begin.compareTo(maxdbDate) <= 0 && enddate.compareTo(mindbDate) >= 0) {
                    ps = conn.prepareStatement(" select " + this.workInfofieldList() + " from WORK_DATA where prodid= ? and  SERIALNO = ? and currenttime>= ? and currenttime<? order by currenttime ");
                    Timestamp timeb = new Timestamp(begin.getTime().getTime());
                    Timestamp timee = new Timestamp(enddate.getTime().getTime());
                    ps.setString(1, prodid);
                    ps.setString(2, serialno);
                    ps.setTimestamp(3, timeb);
                    ps.setTimestamp(4, timee);
                    rs = ps.executeQuery();
                    if (rs != null && rs.next()) {
                        work = this.getWorkInDB(work, rs);
                    }
                }
                work.setCurrentTime(begin.getTime());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.close(rs, ps);
            }
        }
        finally {
            this.close(rs, ps);
        }
        return work;
    }

    public List<WorkInfo> getWorkDatasByYear(int year, String prodid, String serialno) {
        Calendar ca = Calendar.getInstance();
        ca.set(year, 0, 1, 0, 0, 0);
        Calendar endtime = Calendar.getInstance();
        endtime.set(year + 1, 0, 1, 0, 0, 0);
        Calendar tempDate = (Calendar)ca.clone();
        ArrayList<WorkInfo> works = new ArrayList<WorkInfo>();
        try {
            Calendar[] minmaxdate = this.getMinMaxDate(prodid, serialno, year, ca.getTime(), endtime.getTime());
            while (ca.before(endtime)) {
                tempDate.add(5, 3);
                if (tempDate.after(endtime)) {
                    tempDate = endtime;
                }
                works.add(this.getWorkData(prodid, serialno, year, minmaxdate[0], minmaxdate[1], ca, tempDate));
                ca.add(5, 3);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return works;
    }

    public List<WorkInfo> getWorkDatasByMonth(int year, int month, String prodid, String serialno) {
        Calendar ca = Calendar.getInstance();
        ca.set(year, month - 1, 1, 0, 0, 0);
        Calendar endtime = Calendar.getInstance();
        endtime.set(year, month, 1, 0, 0, 0);
        Calendar tempDate = (Calendar)ca.clone();
        ArrayList<WorkInfo> works = new ArrayList<WorkInfo>();
        try {
            Calendar[] minmaxdate = this.getMinMaxDate(prodid, serialno, year, ca.getTime(), endtime.getTime());
            while (ca.before(endtime)) {
                tempDate.add(11, 6);
                if (tempDate.after(endtime)) {
                    tempDate = endtime;
                }
                works.add(this.getWorkData(prodid, serialno, year, minmaxdate[0], minmaxdate[1], ca, tempDate));
                ca.add(11, 6);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return works;
    }

    public List<WorkInfo> getWorkDatasByDay(Date queryDate, String prodid, String serialno) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(queryDate);
        ca = DateUtils.getShortdate(ca);
        Calendar endtime = (Calendar)ca.clone();
        endtime.add(5, 1);
        Calendar tempDate = (Calendar)ca.clone();
        ArrayList<WorkInfo> works = new ArrayList<WorkInfo>();
        int year = ca.get(1);
        try {
            Calendar[] minmaxdate = this.getMinMaxDate(prodid, serialno, year, ca.getTime(), endtime.getTime());
            while (ca.before(endtime)) {
                tempDate.add(12, 15);
                if (tempDate.after(endtime)) {
                    tempDate = endtime;
                }
                works.add(this.getWorkData(prodid, serialno, year, minmaxdate[0], minmaxdate[1], ca, tempDate));
                ca.add(12, 15);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return works;
    }

    public List<WorkInfo> getWorkDatasByHour(Date queryDate, int hour, String prodid, String serialno) {
        ArrayList<WorkInfo> works;
        block10: {
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            Calendar ca = Calendar.getInstance();
            ca.setTime(queryDate);
            ca = DateUtils.getShortdate(ca);
            ca.set(11, hour);
            Calendar endtime = (Calendar)ca.clone();
            endtime.add(11, 1);
            works = new ArrayList<WorkInfo>();
            try {
                try {
                    ps = conn.prepareStatement(" select * from WORK_DATA where prodid=? and serialno=? and currenttime>=? and currenttime<? order by currenttime ", 1004, 1007);
                    ps.setString(1, prodid);
                    ps.setString(2, serialno);
                    ps.setTimestamp(3, new Timestamp(ca.getTime().getTime()));
                    ps.setTimestamp(4, new Timestamp(endtime.getTime().getTime()));
                    rs = ps.executeQuery();
                    Long temp = null;
                    int target = 60;
                    while (rs.next()) {
                        int temptarget;
                        Long time = rs.getTimestamp("currentTime").getTime();
                        if (temp != null && (temptarget = (int)(time - temp) / 1000) < target && temptarget % 30 == 0 && temptarget > 0) {
                            target = temptarget;
                        }
                        temp = time;
                    }
                    rs.beforeFirst();
                    while (rs.next()) {
                        Timestamp recordTime = rs.getTimestamp("currentTime");
                        long recordMillis = ((Date)recordTime).getTime();
                        if (recordMillis < ca.getTimeInMillis()) continue;
                        WorkInfo workinfo = new WorkInfo();
                        while (recordMillis > ca.getTimeInMillis() + 60000L) {
                            workinfo.setCurrentTime(ca.getTime());
                            works.add(workinfo);
                            ca.add(13, target);
                        }
                        WorkInfo work = new WorkInfo();
                        work = this.getWorkInDB(work, rs);
                        works.add(work);
                        ca.add(13, target);
                    }
                    while (ca.get(11) == hour) {
                        WorkInfo work = new WorkInfo();
                        work.setCurrentTime(ca.getTime());
                        works.add(work);
                        ca.add(13, target);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block10;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return works;
    }

    private WorkInfo getWorkInDB(WorkInfo work, ResultSet rs) throws Exception {
        WorkInfo data = work;
        data.setProdid(rs.getString("prodid"));
        data.setSerialno(rs.getString("serialno"));
        data.setWorkMode(rs.getString("workMode"));
        data.setGridVoltageR(rs.getDouble("gridVoltageR"));
        data.setGridPowerR(rs.getDouble("gridPowerR"));
        data.setGridCurrentR(rs.getDouble("gridCurrentR"));
        data.setGridFrequency(rs.getDouble("gridFrequency"));
        data.setAcOutputVoltageR(rs.getDouble("acOutputVoltageR"));
        data.setAcOutputPowerR(rs.getDouble("acOutputPowerR"));
        data.setAcOutputFrequency(rs.getDouble("acOutputFrequency"));
        data.setAcOutputCurrentR(rs.getDouble("acOutputCurrentR"));
        data.setOutputLoadPercent(rs.getInt("outputLoadPercent"));
        data.setPBatteryVoltage(rs.getDouble("pBatteryVoltage"));
        data.setNBatteryVoltage(rs.getDouble("nBatteryVoltage"));
        data.setBatteryCapacity(rs.getInt("batteryCapacity"));
        data.setChargingCurrent(rs.getDouble("chargingCurrent"));
        data.setPvInputPower1(rs.getInt("pvInputPower1"));
        data.setPvInputPower2(rs.getInt("pvInputPower2"));
        data.setPvInputPower3(rs.getInt("pvInputPower3"));
        data.setPvInputVoltage1(rs.getDouble("pvInputVoltage1"));
        data.setPvInputVoltage2(rs.getDouble("pvInputVoltage2"));
        data.setPvInputVoltage3(rs.getDouble("pvInputVoltage3"));
        data.setMaxTemperature(rs.getDouble("maxTemperature"));
        data.setRGridVoltage(rs.getDouble("rGridVoltage"));
        data.setSGridVoltage(rs.getDouble("sGridVoltage"));
        data.setTGridVoltage(rs.getDouble("tGridVoltage"));
        data.setRsGridVoltage(rs.getDouble("rsGridVoltage"));
        data.setRtGridVoltage(rs.getDouble("rtGridVoltage"));
        data.setStGridVoltage(rs.getDouble("stGridVoltage"));
        data.setRGridCurrent(rs.getDouble("rGridCurrent"));
        data.setSGridCurrent(rs.getDouble("sGridCurrent"));
        data.setTGridCurrent(rs.getDouble("tGridCurrent"));
        data.setRPhasePower(rs.getInt("rPhasePower"));
        data.setSPhasePower(rs.getInt("sPhasePower"));
        data.setTPhasePower(rs.getInt("tPhasePower"));
        data.setWholePower(rs.getInt("wholePower"));
        data.setRPhaseACOutputVoltage(rs.getDouble("rPhaseACOutputVoltage"));
        data.setSPhaseACOutputVoltage(rs.getDouble("sPhaseACOutputVoltage"));
        data.setTPhaseACOutputVoltage(rs.getDouble("tPhaseACOutputVoltage"));
        data.setRsPhaseACOutputVoltage(rs.getDouble("rsPhaseACOutputVoltage"));
        data.setRtPhaseACOutputVoltage(rs.getDouble("rtPhaseACOutputVoltage"));
        data.setStPhaseACOutputVoltage(rs.getDouble("stPhaseACOutputVoltage"));
        data.setRACOutputCurrent(rs.getDouble("rACOutputCurrent"));
        data.setSACOutputCurrent(rs.getDouble("sACOutputCurrent"));
        data.setTACOutputCurrent(rs.getDouble("tACOutputCurrent"));
        data.setRPhaseACOutputLoad(rs.getInt("rPhaseACOutputLoad"));
        data.setSPhaseACOutputLoad(rs.getInt("sPhaseACOutputLoad"));
        data.setTPhaseACOutputLoad(rs.getInt("tPhaseACOutputLoad"));
        data.setWholeACOutputLoad(rs.getInt("wholeACOutputLoad"));
        data.setBatteryPieceNumber(rs.getInt("batteryPieceNumber"));
        data.setBatteryTotalCapacity(rs.getInt("batteryTotalCapacity"));
        data.setBatteryRemainTime(rs.getInt("batteryRemainTime"));
        data.setAcOutputApparentPower(rs.getDouble("OUTPUTAPPARENTPOWER"));
        data.setAcOutputActivePower(rs.getDouble("OUTPUTACTIVEPOWER"));
        data.setTtlChargingCurrent(rs.getDouble("TTLCHARGINGCURRENT"));
        data.setAcTtlOutputApparentPower(rs.getDouble("TTLOUTPUTAPPARENTPOWER"));
        data.setAcTtlOutputActivePower(rs.getDouble("TTLOUTPUTACTIVEPOWER"));
        data.setAcTtlOutputPercent(rs.getDouble("TTLOUTPUTPERCENT"));
        data.setPvInputCurrent(rs.getDouble("pvInputCurrent"));
        data.setBatDisCurrent(rs.getDouble("batDisCurrent"));
        data.setPvInputCurrentForBatttery(rs.getDouble("PVINPUTCURRENTFORBATTTERY"));
        data.setPvInputCurrent1(rs.getDouble("PVINPUTCURRENT1"));
        data.setPvInputCurrent2(rs.getDouble("PVINPUTCURRENT2"));
        data.setPvInputCurrent3(rs.getDouble("PVINPUTCURRENT3"));
        data.setOutputApparentPowerR(rs.getInt("OUTPUTAPPARENTPOWERR"));
        data.setOutputApparentPowerS(rs.getInt("OUTPUTAPPARENTPOWERS"));
        data.setOutputApparentPowerT(rs.getInt("OUTPUTAPPARENTPOWERT"));
        data.setOutputActivePowerR(rs.getInt("OUTPUTACTIVEPOWERR"));
        data.setOutputActivePowerS(rs.getInt("OUTPUTACTIVEPOWERS"));
        data.setOutputActivePowerT(rs.getInt("OUTPUTACTIVEPOWERT"));
        data.setCurrentTime(rs.getTimestamp("currentTime"));
        VolUtil.setTemperature(data);
        return work;
    }

    public static void main(String[] args) {
        WorkDataDao dao = new WorkDataDao();
        WorkInfo workinfo = new WorkInfo();
        workinfo.setProdid("P15");
        workinfo.setSerialno("90000000000001");
        workinfo.setWorkMode("online");
        workinfo.setAcOutputCurrentR(214.0);
        workinfo.setAcOutputFrequency(52.0);
        workinfo.setAcOutputPowerR(500.0);
        workinfo.setAcOutputVoltageR(530.0);
        workinfo.setBatteryCapacity(30);
        workinfo.setChargingCurrent(22.0);
        workinfo.setFaultInfo("1002");
        workinfo.setGridCurrentR(42.0);
        workinfo.setGridFrequency(51.0);
        workinfo.setGridPowerR(310.0);
        workinfo.setGridVoltageR(280.0);
        workinfo.setMaxTemperature(53.0);
        workinfo.setPvInputPower1(172);
        workinfo.setPvInputPower2(393);
        workinfo.setPvInputPower3(121);
        workinfo.setPvInputVoltage1(320.0);
        workinfo.setPvInputVoltage2(370.0);
        workinfo.setPvInputVoltage3(143.0);
        workinfo.setWholePower(2000);
        workinfo.setCurrentTime(new Date());
        boolean re = dao.insertWorkInfo(workinfo);
        System.out.println(re);
    }
}

