/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.exception;

import cn.com.voltronic.solar.configure.ConfigureTools;
import cn.com.voltronic.solar.dao.EventCfgDao;
import cn.com.voltronic.solar.dao.EventRecordDao;
import cn.com.voltronic.solar.data.bean.EventData;
import cn.com.voltronic.solar.data.bean.EventDataRecord;
import cn.com.voltronic.solar.data.bean.Eventcfg;
import cn.com.voltronic.solar.socket.UdpClient;
import cn.com.voltronic.solar.system.GlobalVariables;
import cn.com.voltronic.solar.thread.SendEmailThread;
import cn.com.voltronic.solar.thread.SendSMSThread;
import cn.com.voltronic.solar.util.DateUtils;
import cn.com.voltronic.solar.util.VolUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class EventsHandler {
    private static Document document30 = null;
    private static Document documentPlusDuo = null;
    private static Document documentPlusRri = null;
    private static final String XML_PATH = String.valueOf(System.getProperty("user.dir")) + File.separator + "config" + File.separator;

    static {
        try {
            document30 = EventsHandler.doDocument("Events_P30.xml");
            documentPlusDuo = EventsHandler.doDocument("Events_PlusDuo.xml");
            documentPlusRri = EventsHandler.doDocument("Events_PlusTri.xml");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Document getDocument30() {
        return document30;
    }

    public static Document getDocumentPlusDuo() {
        return documentPlusDuo;
    }

    public static Document getDocumentPlusTri() {
        return documentPlusRri;
    }

    public static Document getDocumentByProdid(String prodid) {
        if (prodid.equalsIgnoreCase("P30PLUSDUO")) {
            return documentPlusDuo;
        }
        if (prodid.equalsIgnoreCase("P30PLUSTRI")) {
            return documentPlusRri;
        }
        return document30;
    }

    public static List<Element> getP30AllEvent() {
        List list = document30.getRootElement().elements("event");
        return list;
    }

    public static List<Element> getPlusDuoAllEvent() {
        List list = documentPlusDuo.getRootElement().elements("event");
        return list;
    }

    public static List<Element> getPlusTriAllEvent() {
        List list = documentPlusRri.getRootElement().elements("event");
        return list;
    }

    private static Document doDocument(String fileName) {
        Document document;
        block15: {
            document = null;
            SAXReader reader = new SAXReader();
            File fileExt = null;
            try {
                fileExt = new File(String.valueOf(XML_PATH) + fileName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (fileExt != null && fileExt.exists() && fileExt.isFile()) {
                FileInputStream fisExt = null;
                try {
                    try {
                        fisExt = new FileInputStream(fileExt);
                        document = reader.read((InputStream)fisExt);
                    }
                    catch (Exception exception) {
                        if (fisExt == null) break block15;
                        try {
                            fisExt.close();
                        }
                        catch (Exception exception2) {}
                    }
                }
                finally {
                    if (fisExt != null) {
                        try {
                            fisExt.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
        return document;
    }

    public static EventData getEventById(String prodid, String eventId) {
        String eventName = "";
        int eventLevel = 0;
        if (prodid.equalsIgnoreCase("P30PLUSDUO")) {
            eventName = EventsHandler.getEventname(documentPlusDuo, eventId);
            eventLevel = EventsHandler.getEventLevel(documentPlusDuo, eventId);
        } else if (prodid.equalsIgnoreCase("P30PLUSTRI")) {
            eventName = EventsHandler.getEventname(documentPlusRri, eventId);
            eventLevel = EventsHandler.getEventLevel(documentPlusRri, eventId);
        } else {
            eventName = EventsHandler.getEventname(document30, eventId);
            eventLevel = EventsHandler.getEventLevel(document30, eventId);
        }
        EventData eventData = new EventData();
        eventData.setEventId(eventId);
        eventData.setEventLevel(eventLevel);
        eventData.setEventName(eventName);
        return eventData;
    }

    public static int getEventLevel(Document document, String eventId) {
        Element eventEle = (Element)document.selectSingleNode("//event[@id='" + eventId + "']");
        String level = eventEle.attributeValue("level");
        return Integer.parseInt(level);
    }

    public static String getEventname(Document document, String eventId) {
        Element eventEle = (Element)document.selectSingleNode("//event[@id='" + eventId + "']");
        String language = "en_US";
        try {
            ConfigureTools.wrapProperties(GlobalVariables.globalConfig);
            language = GlobalVariables.globalConfig.getLanguage();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        String name = null;
        name = language.equals("en_US") ? eventEle.attributeValue("enName") : (language.equals("zh_CN") ? eventEle.attributeValue("name") : (language.equals("fr_FR") ? eventEle.attributeValue("frName") : (language.equals("de_DE") ? eventEle.attributeValue("deName") : (language.equals("it_IT") ? eventEle.attributeValue("itName") : (language.equals("pl_PL") ? eventEle.attributeValue("plName") : (language.equals("pt_PT") ? eventEle.attributeValue("ptName") : (language.equals("ru_RU") ? eventEle.attributeValue("rusName") : (language.equals("es_ES") ? eventEle.attributeValue("spName") : (language.equals("uk_UA") ? eventEle.attributeValue("ukrName") : (language.equals("tr_TR") ? eventEle.attributeValue("turName") : (language.equals("zh_TW") ? eventEle.attributeValue("twName") : eventEle.attributeValue("enName"))))))))))));
        return name;
    }

    public static void handleEvent(String prodid, String serialno, Date trandate, String eventId) {
        if (!(prodid == null || "".equals(prodid) || serialno == null || "".equals(serialno) || eventId == null || "".equals(eventId) || trandate == null)) {
            EventsHandler.reocrdEvent(prodid, serialno, eventId, trandate);
        }
    }

    private static void reocrdEvent(String prodid, String serialno, String eventId, Date trandate) {
        EventCfgDao cfgDao = new EventCfgDao();
        List<Eventcfg> cfgList = cfgDao.queryEventcfg(eventId);
        int i = 0;
        while (i < cfgList.size()) {
            String message;
            EventData eventData;
            Eventcfg cfg;
            block17: {
                EventDataRecord eventdata2;
                EventRecordDao eventDao;
                cfg = cfgList.get(i);
                if (cfg.getAction() == 1 && !(eventDao = new EventRecordDao()).alreadyInsert(eventdata2 = new EventDataRecord(prodid, serialno, eventId, trandate))) {
                    eventDao.insertEvent(eventdata2);
                }
                if (cfg.getAction() == 2) {
                    String port = "38694";
                    try {
                        port = GlobalVariables.globalConfig.getUdpPort();
                    }
                    catch (Exception eventdata2) {
                        // empty catch block
                    }
                    EventData eventData2 = EventsHandler.getEventById(prodid, eventId);
                    String message2 = eventData2.getEventName();
                    UdpClient udpClient = null;
                    try {
                        try {
                            udpClient = new UdpClient("localhost", port);
                            String eventDescription = "(Event:[" + serialno + "] [" + VolUtil.getFormatTimestamp(trandate) + "] " + message2 + "13";
                            udpClient.send(eventDescription);
                        }
                        catch (Exception exception) {
                            if (udpClient != null) {
                                udpClient.disconnect();
                            }
                            break block17;
                        }
                    }
                    catch (Throwable throwable) {
                        if (udpClient != null) {
                            udpClient.disconnect();
                        }
                        throw throwable;
                    }
                    if (udpClient != null) {
                        udpClient.disconnect();
                    }
                }
            }
            if (cfg.getAction() == 3) {
                eventData = EventsHandler.getEventById(prodid, eventId);
                message = eventData.getEventName();
                SendEmailThread sendEmailUtil = new SendEmailThread(serialno, DateUtils.getFormatTimestamp(trandate), message, cfg.getReceive());
                sendEmailUtil.start();
            }
            if (cfg.getAction() == 4) {
                eventData = EventsHandler.getEventById(prodid, eventId);
                message = eventData.getEventName();
                try {
                    SendSMSThread sendSMSUtil = new SendSMSThread(serialno, DateUtils.getFormatTimestamp(trandate), message, cfg.getReceive());
                    sendSMSUtil.start();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++i;
        }
    }
}

