/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.modbusprocessor;

import cn.com.voltronic.solar.communicate.ModbusHandler;
import cn.com.voltronic.solar.data.bean.WorkInfo;
import cn.com.voltronic.solar.modbusprocessor.P30ModbusProcessor;
import cn.com.voltronic.solar.protocol.IProtocol;
import cn.com.voltronic.solar.view.ParameterJDialog;
import java.util.Date;
import net.wimpi.modbus.procimg.Register;
import net.wimpi.modbus.util.BitVector;

public class P304TO5KWModbusProcessor
extends P30ModbusProcessor {
    public P304TO5KWModbusProcessor(ModbusHandler handler, IProtocol protocol) {
        super(handler, protocol);
    }

    @Override
    public boolean pollQuery() {
        Register[] reg;
        String isParallelNumExist;
        ModbusHandler handler;
        block49: {
            block48: {
                block47: {
                    try {
                        handler = this.getHandler();
                        if (handler != null) break block47;
                        this.close();
                        return false;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
                if (this.refreshConfig) {
                    this.getProtocol().setDelayChanging(true);
                    this.queryMachineInfo();
                    this.queryConfigData();
                    this.queryCapability();
                    this.refreshConfig = false;
                }
                if (!ParameterJDialog.startQueryThread) {
                    this.getProtocol().setDelayChanging(false);
                }
                if (this.bfirsttime) {
                    this._preparalleltype = this._paralleltype;
                    this.bfirsttime = false;
                    break block48;
                }
                if (this._preparalleltype == this._paralleltype) break block48;
                this.close();
                return false;
            }
            if (this.getSerialNo().equals(handler.getSerialNo())) break block49;
            this.close();
            return false;
        }
        if (this._paralleltype != 0) {
            return this.pollQueryParallel();
        }
        WorkInfo workInfo = (WorkInfo)this.getBeanBag().getBean("workinfo");
        workInfo.setProdid(this._protocol.getProtocolID());
        workInfo.setSerialno(handler.getSerialNo());
        Register[] regs = handler.readMultipleRegisters(208, 1);
        String workMode = new String(regs[0].toBytes()).trim();
        workInfo.setWorkMode("Standby Mode");
        if (workMode.equals("P")) {
            workInfo.setWorkMode("Power On Mode");
        } else if (workMode.equals("S")) {
            workInfo.setWorkMode("Standby Mode");
        } else if (workMode.equals("L")) {
            workInfo.setWorkMode("Line Mode");
        } else if (workMode.equals("B")) {
            workInfo.setWorkMode("Battery Mode");
        } else if (workMode.equals("F")) {
            workInfo.setWorkMode("Fault Mode");
        } else if (workMode.equals("D")) {
            workInfo.setWorkMode("Shutdown Mode");
        } else if (workMode.equals("H")) {
            workInfo.setWorkMode("Power Saving Mode");
        }
        regs = handler.readMultipleRegisters(209, 1);
        workInfo.setGridVoltageR((double)regs[0].getValue() / 10.0);
        regs = handler.readMultipleRegisters(213, 1);
        workInfo.setGridFrequency((double)regs[0].getValue() / 10.0);
        regs = handler.readMultipleRegisters(216, 7);
        workInfo.setAcOutputVoltageR((double)regs[0].getValue() / 10.0);
        workInfo.setAcOutputFrequency((double)regs[3].getValue() / 10.0);
        workInfo.setAcOutputActivePower((int)P304TO5KWModbusProcessor.convert2Regiters(regs[1], regs[2]));
        workInfo.setOutputLoadPercent(regs[5].getValue());
        workInfo.setPBUSVoltage(regs[6].getValue());
        regs = handler.readMultipleRegisters(389, 2);
        workInfo.setAcOutputApparentPower((int)P304TO5KWModbusProcessor.convert2Regiters(regs[0], regs[1]));
        regs = handler.readMultipleRegisters(224, 1);
        workInfo.setPBatteryVoltage((double)regs[0].getValue() / 100.0);
        regs = handler.readMultipleRegisters(226, 1);
        workInfo.setBatteryCapacity(regs[0].getValue());
        regs = handler.readMultipleRegisters(227, 1);
        workInfo.setChargingCurrent((double)regs[0].getValue() / 10.0);
        regs = handler.readMultipleRegisters(234, 1);
        workInfo.setPvInputVoltage1((double)regs[0].getValue() / 10.0);
        regs = handler.readMultipleRegisters(785, 1);
        workInfo.setPvInputPower1(regs[0].getValue());
        workInfo.setCurrentTime(new Date());
        Register[] register = handler.readMultipleRegisters(295, 5);
        workInfo.setPvInputCurrent(register[0].getValue());
        workInfo.setBatDisCurrent((int)P304TO5KWModbusProcessor.convert2Regiters(register[2], register[3]));
        BitVector bits = new BitVector(16);
        bits.setBytes(register[4].toBytes(), 16);
        bits.toggleAccess(true);
        if (bits.getBit(0)) {
            workInfo.setCustomerV("1");
        } else {
            workInfo.setCustomerV("0");
        }
        if (bits.getBit(1)) {
            this.getProtocol().setDelayChanging(true);
            this.queryMachineInfo();
            this.queryCapability();
            this.queryConfigData();
        }
        if (bits.getBit(2)) {
            this.queryMachineInfo();
        }
        if (bits.getBit(3)) {
            workInfo.setHasLoad(true);
        } else {
            workInfo.setHasLoad(false);
        }
        if (bits.getBit(5)) {
            workInfo.setChargeOn(true);
        } else {
            workInfo.setChargeOn(false);
        }
        if (bits.getBit(6)) {
            workInfo.setSCCchargeOn(true);
        } else {
            workInfo.setSCCchargeOn(false);
        }
        if (bits.getBit(7)) {
            workInfo.setACchargeOn(true);
        } else {
            workInfo.setACchargeOn(false);
        }
        if (workInfo.isChargeOn()) {
            if (workInfo.isSCCchargeOn() && workInfo.isACchargeOn()) {
                workInfo.setChargeSource("Solar and Utility");
            } else if (workInfo.isSCCchargeOn()) {
                workInfo.setChargeSource("Solar");
            } else if (workInfo.isACchargeOn()) {
                workInfo.setChargeSource("Utility");
            }
        } else {
            workInfo.setChargeSource("---");
        }
        if (workInfo.isHasLoad()) {
            if (workInfo.getWorkMode().equals("Line Mode")) {
                workInfo.setLoadSource("Utility");
            } else if (workInfo.getWorkMode().equals("Battery Mode")) {
                workInfo.setLoadSource("Battery");
            }
        } else {
            workInfo.setLoadSource("---");
        }
        if (this.executeControl("setParallelIndex", new Object[]{0}) && (isParallelNumExist = new String((reg = handler.readMultipleRegisters(351, 1))[0].toBytes()).trim()).equals("1")) {
            this.explainQPGSN0(this);
        }
        return true;
    }
}

