/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.modbusprocessor;

import cn.com.voltronic.solar.beanbag.P30BeanBag;
import cn.com.voltronic.solar.communicate.ModbusHandler;
import cn.com.voltronic.solar.comusbprocessor.ParallSubProcessor;
import cn.com.voltronic.solar.control.P30ModbusControlModule;
import cn.com.voltronic.solar.data.bean.Capability;
import cn.com.voltronic.solar.data.bean.ConfigData;
import cn.com.voltronic.solar.data.bean.DefaultData;
import cn.com.voltronic.solar.data.bean.MachineInfo;
import cn.com.voltronic.solar.data.bean.ProtocolInfo;
import cn.com.voltronic.solar.data.bean.WorkInfo;
import cn.com.voltronic.solar.exception.EventsHandler;
import cn.com.voltronic.solar.exception.FaultHandler;
import cn.com.voltronic.solar.modbusprocessor.AbstractModbusProcessor;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.protocol.IProtocol;
import cn.com.voltronic.solar.protocol.P30;
import cn.com.voltronic.solar.system.GlobalProcessors;
import cn.com.voltronic.solar.util.VolUtil;
import cn.com.voltronic.solar.view.ParameterJDialog;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import net.wimpi.modbus.procimg.Register;
import net.wimpi.modbus.util.BitVector;

public class P30ModbusProcessor
extends AbstractModbusProcessor {
    public static final double DOUBLE_TEN = 10.0;
    public static final double DOUBLE_HUNDRED = 100.0;
    public static final int INT_TEN = 10;
    public boolean refreshConfig = false;
    public int _preparalleltype = 0;
    public boolean bfirsttime = true;

    public P30ModbusProcessor(ModbusHandler handler, IProtocol protocol) {
        super(handler, protocol);
    }

    @Override
    protected void initBeanBag() {
        this._beanbag = new P30BeanBag();
    }

    @Override
    protected void initControlModule() {
        this._control = new P30ModbusControlModule(this.getHandler());
    }

    @Override
    public void initProtocol() {
        ProtocolInfo info = (ProtocolInfo)this.getBeanBag().getBean("protocolinfo");
        info.setProdid(this._protocol.getProtocolID());
        info.setBaseInfo(this._protocol.getBaseInfo());
        info.setProductInfo(this._protocol.getProductInfo());
        info.setRatingInfo(this._protocol.getRatingInfo());
        try {
            info.setSerialno(this._protocol.getSerialNo());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        info.setMoreInfo(this._protocol.getMoreInfo());
    }

    @Override
    public boolean pollQuery() {
        Register[] reg;
        String isParallelNumExist;
        ModbusHandler handler;
        block57: {
            block56: {
                block55: {
                    try {
                        handler = this.getHandler();
                        if (handler != null) break block55;
                        this.close();
                        return false;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
                if (this.refreshConfig) {
                    this.getProtocol().setDelayChanging(true);
                    this.queryMachineInfo();
                    this.queryConfigData();
                    this.queryCapability();
                    this.refreshConfig = false;
                }
                if (!ParameterJDialog.startQueryThread) {
                    this.getProtocol().setDelayChanging(false);
                }
                if (this.bfirsttime) {
                    this._preparalleltype = this._paralleltype;
                    this.bfirsttime = false;
                    break block56;
                }
                if (this._preparalleltype == this._paralleltype) break block56;
                this.close();
                return false;
            }
            if (this.getSerialNo().equals(handler.getSerialNo())) break block57;
            this.close();
            return false;
        }
        if (this._paralleltype != 0) {
            return this.pollQueryParallel();
        }
        WorkInfo workInfo = (WorkInfo)this.getBeanBag().getBean("workinfo");
        workInfo.setProdid(this._protocol.getProtocolID());
        workInfo.setSerialno(handler.getSerialNo());
        Register[] regs = handler.readMultipleRegisters(208, 1);
        String workMode = new String(regs[0].toBytes()).trim();
        workInfo.setWorkMode("Standby Mode");
        if (workMode.equals("P")) {
            workInfo.setWorkMode("Power On Mode");
        } else if (workMode.equals("S")) {
            workInfo.setWorkMode("Standby Mode");
        } else if (workMode.equals("L")) {
            workInfo.setWorkMode("Line Mode");
        } else if (workMode.equals("B")) {
            workInfo.setWorkMode("Battery Mode");
        } else if (workMode.equals("F")) {
            workInfo.setWorkMode("Fault Mode");
        } else if (workMode.equals("D")) {
            workInfo.setWorkMode("Shutdown Mode");
        } else if (workMode.equals("H")) {
            workInfo.setWorkMode("Power Saving Mode");
        }
        regs = handler.readMultipleRegisters(209, 1);
        workInfo.setGridVoltageR((double)regs[0].getValue() / 10.0);
        regs = handler.readMultipleRegisters(213, 1);
        workInfo.setGridFrequency((double)regs[0].getValue() / 10.0);
        regs = handler.readMultipleRegisters(216, 7);
        workInfo.setAcOutputVoltageR((double)regs[0].getValue() / 10.0);
        workInfo.setAcOutputFrequency((double)regs[3].getValue() / 10.0);
        workInfo.setAcOutputActivePower((int)P30ModbusProcessor.convert2Regiters(regs[1], regs[2]));
        workInfo.setOutputLoadPercent(regs[5].getValue());
        workInfo.setPBUSVoltage(regs[6].getValue());
        regs = handler.readMultipleRegisters(389, 2);
        workInfo.setAcOutputApparentPower((int)P30ModbusProcessor.convert2Regiters(regs[0], regs[1]));
        regs = handler.readMultipleRegisters(224, 1);
        workInfo.setPBatteryVoltage((double)regs[0].getValue() / 100.0);
        regs = handler.readMultipleRegisters(226, 1);
        workInfo.setBatteryCapacity(regs[0].getValue());
        regs = handler.readMultipleRegisters(227, 1);
        workInfo.setChargingCurrent((double)regs[0].getValue() / 10.0);
        regs = handler.readMultipleRegisters(234, 1);
        workInfo.setPvInputVoltage1((double)regs[0].getValue() / 10.0);
        workInfo.setCurrentTime(new Date());
        Register[] register = handler.readMultipleRegisters(295, 5);
        workInfo.setPvInputCurrent(register[0].getValue());
        workInfo.setBatDisCurrent((int)P30ModbusProcessor.convert2Regiters(register[2], register[3]));
        BitVector bits = new BitVector(16);
        bits.setBytes(register[4].toBytes(), 16);
        bits.toggleAccess(true);
        if (bits.getBit(0)) {
            workInfo.setCustomerV("1");
        } else {
            workInfo.setCustomerV("0");
        }
        if (bits.getBit(1)) {
            this.getProtocol().setDelayChanging(true);
            this.queryMachineInfo();
            this.queryCapability();
            this.queryConfigData();
        }
        if (bits.getBit(2)) {
            this.queryMachineInfo();
        }
        if (bits.getBit(3)) {
            workInfo.setHasLoad(true);
        } else {
            workInfo.setHasLoad(false);
        }
        if (bits.getBit(5)) {
            workInfo.setChargeOn(true);
        } else {
            workInfo.setChargeOn(false);
        }
        if (bits.getBit(6)) {
            workInfo.setSCCchargeOn(true);
        } else {
            workInfo.setSCCchargeOn(false);
        }
        if (bits.getBit(7)) {
            workInfo.setACchargeOn(true);
        } else {
            workInfo.setACchargeOn(false);
        }
        MachineInfo machineInfo = (MachineInfo)this.getBeanBag().getBean("machineinfo");
        if (machineInfo != null) {
            if (P30.is4to5k(machineInfo.getAcOutputRatingApparentPower())) {
                workInfo.setIsPVCharging(1);
            } else if (P30.is1to3k(machineInfo.getAcOutputRatingApparentPower())) {
                if (bits.getBit(5) && bits.getBit(6) && !bits.getBit(7)) {
                    workInfo.setIsPVCharging(1);
                } else if (bits.getBit(5) && bits.getBit(6) && bits.getBit(7)) {
                    workInfo.setIsPVCharging(1);
                } else {
                    workInfo.setIsPVCharging(0);
                }
            }
        }
        if (workInfo.isChargeOn()) {
            if (workInfo.isSCCchargeOn() && workInfo.isACchargeOn()) {
                workInfo.setChargeSource("Solar and Utility");
            } else if (workInfo.isSCCchargeOn()) {
                workInfo.setChargeSource("Solar");
            } else if (workInfo.isACchargeOn()) {
                workInfo.setChargeSource("Utility");
            }
        } else {
            workInfo.setChargeSource("---");
        }
        if (workInfo.isHasLoad()) {
            if (workInfo.getWorkMode().equals("Line Mode")) {
                workInfo.setLoadSource("Utility");
            } else if (workInfo.getWorkMode().equals("Battery Mode")) {
                workInfo.setLoadSource("Battery");
            }
        } else {
            workInfo.setLoadSource("---");
        }
        if (this.executeControl("setParallelIndex", new Object[]{0}) && (isParallelNumExist = new String((reg = handler.readMultipleRegisters(351, 1))[0].toBytes()).trim()).equals("1")) {
            this.explainQPGSN0(this);
        }
        return true;
    }

    public void explainQPGSN0(AbstractProcessor processor) {
        try {
            WorkInfo workInfo = (WorkInfo)processor.getBeanBag().getBean("workfault");
            workInfo.setProdid(this._protocol.getProtocolID());
            workInfo.setSerialno(processor.getSerialNo());
            ModbusHandler handler = this.getHandler();
            Register[] regs = handler.readMultipleRegisters(359, 30);
            String workMode = new String(regs[0].toBytes()).trim();
            workInfo.setWorkMode("Standby Mode");
            if (workMode.equals("P")) {
                workInfo.setWorkMode("Power On Mode");
            } else if (workMode.equals("S")) {
                workInfo.setWorkMode("Standby Mode");
            } else if (workMode.equals("L")) {
                workInfo.setWorkMode("Line Mode");
            } else if (workMode.equals("B")) {
                workInfo.setWorkMode("Battery Mode");
            } else if (workMode.equals("F")) {
                workInfo.setWorkMode("Fault Mode");
            } else if (workMode.equals("D")) {
                workInfo.setWorkMode("Shutdown Mode");
            } else if (workMode.equals("H")) {
                workInfo.setWorkMode("Power Saving Mode");
            }
            workInfo.setGridVoltageR((double)regs[2].getValue() / 10.0);
            workInfo.setGridFrequency((double)regs[3].getValue() / 100.0);
            workInfo.setAcOutputVoltageR((double)regs[4].getValue() / 10.0);
            workInfo.setAcOutputFrequency((double)regs[5].getValue() / 100.0);
            workInfo.setAcOutputApparentPower((int)P30ModbusProcessor.convert2Regiters(regs[6], regs[7]));
            workInfo.setAcOutputActivePower((int)P30ModbusProcessor.convert2Regiters(regs[8], regs[9]));
            workInfo.setOutputLoadPercent(regs[10].getValue());
            workInfo.setPBatteryVoltage((double)regs[11].getValue() / 10.0);
            workInfo.setChargingCurrent(regs[12].getValue());
            workInfo.setBatteryCapacity(regs[13].getValue());
            workInfo.setPvInputVoltage1((double)regs[14].getValue() / 10.0);
            workInfo.setTtlChargingCurrent(regs[15].getValue());
            workInfo.setAcTtlOutputApparentPower((int)P30ModbusProcessor.convert2Regiters(regs[16], regs[17]));
            workInfo.setAcTtlOutputActivePower((int)P30ModbusProcessor.convert2Regiters(regs[18], regs[19]));
            workInfo.setAcTtlOutputPercent(regs[20].getValue());
            workInfo.setCurrentTime(new Date());
            workInfo.setPvInputCurrent(regs[27].getValue());
            workInfo.setBatDisCurrent((int)P30ModbusProcessor.convert2Regiters(regs[28], regs[29]));
            String faultcode = new String(regs[1].toBytes()).trim();
            int fCode = regs[1].getValue();
            if (fCode < 10) {
                faultcode = "0" + fCode;
            }
            FaultHandler.doFaultEvent(workInfo, faultcode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean pollQueryParallel() {
        boolean result = true;
        int parall_i = 0;
        ArrayList<String> curList = new ArrayList<String>();
        ArrayList<String> delList = new ArrayList<String>();
        ModbusHandler handler = this.getHandler();
        if (handler == null) {
            return false;
        }
        try {
            boolean bParentLoss = true;
            parall_i = 0;
            while (parall_i < this._parallelnum) {
                if (!this.executeControl("setParallelIndex", new Object[]{parall_i})) {
                    return false;
                }
                Thread.sleep(500L);
                int outputtype = 0;
                Register[] reg = handler.readMultipleRegisters(351, 1);
                String isParallelNumExist = new String(reg[0].toBytes()).trim();
                if (!isParallelNumExist.equals("0") && (outputtype = (reg = handler.readMultipleRegisters(381, 1))[0].getValue()) != 0) {
                    String oldKey;
                    reg = handler.readMultipleRegisters(352, 7);
                    String builder = "";
                    int item = 0;
                    while (item < reg.length) {
                        builder = String.valueOf(builder) + new String(reg[item].toBytes()).trim();
                        ++item;
                    }
                    String serial = builder;
                    curList.add(serial);
                    ParallSubProcessor processor = null;
                    if (this.subMap.containsKey(serial)) {
                        processor = (ParallSubProcessor)this.subMap.get(serial);
                        processor.setParallKey(parall_i);
                        this.explainQPGSN(processor);
                        oldKey = processor.processorKey();
                        if (!processor.reGenProcesorKey().equalsIgnoreCase(oldKey)) {
                            GlobalProcessors.removeProcessor(oldKey);
                            GlobalProcessors.addProcessor(processor.processorKey(), processor);
                        }
                    } else if (serial.equalsIgnoreCase(this.getSerialNo())) {
                        bParentLoss = false;
                        this.setParallKey(parall_i);
                        this.explainQPGSN(this);
                        oldKey = this.processorKey();
                        if (!this.reGenProcesorKey().equalsIgnoreCase(oldKey)) {
                            GlobalProcessors.removeProcessor(oldKey);
                            GlobalProcessors.addProcessor(this.processorKey(), this);
                        }
                    } else {
                        processor = new ParallSubProcessor(this, new P30BeanBag());
                        processor.setDeviceName(this.getDeviceName());
                        processor.setSerialNo(serial);
                        processor.setParallKey(parall_i);
                        this.explainQPGSN(processor);
                        this.subMap.put(serial, processor);
                        processor.saveDevice();
                        GlobalProcessors.addProcessor(processor.processorKey(), processor);
                    }
                }
                ++parall_i;
            }
            for (Map.Entry entry : this.subMap.entrySet()) {
                if (curList.indexOf(entry.getKey()) >= 0) continue;
                ((ParallSubProcessor)entry.getValue()).close();
                delList.add((String)entry.getKey());
            }
            for (String key : delList) {
                this.subMap.remove(key);
            }
            if (!bParentLoss) return result;
            this.close();
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean explainQPGSN(AbstractProcessor processor) {
        try {
            WorkInfo workInfo = (WorkInfo)processor.getBeanBag().getBean("workinfo");
            workInfo.setProdid(this._protocol.getProtocolID());
            workInfo.setSerialno(processor.getSerialNo());
            ConfigData configdata = (ConfigData)processor.getBeanBag().getBean("configdata");
            ModbusHandler handler = this.getHandler();
            Register[] regs = handler.readMultipleRegisters(359, 30);
            String workMode = new String(regs[0].toBytes()).trim();
            workInfo.setWorkMode("Standby Mode");
            if (workMode.equals("P")) {
                workInfo.setWorkMode("Power On Mode");
            } else if (workMode.equals("S")) {
                workInfo.setWorkMode("Standby Mode");
            } else if (workMode.equals("L")) {
                workInfo.setWorkMode("Line Mode");
            } else if (workMode.equals("B")) {
                workInfo.setWorkMode("Battery Mode");
            } else if (workMode.equals("F")) {
                workInfo.setWorkMode("Fault Mode");
            } else if (workMode.equals("D")) {
                workInfo.setWorkMode("Shutdown Mode");
            } else if (workMode.equals("H")) {
                workInfo.setWorkMode("Power Saving Mode");
            }
            workInfo.setGridVoltageR((double)regs[2].getValue() / 10.0);
            workInfo.setGridFrequency((double)regs[3].getValue() / 100.0);
            workInfo.setAcOutputVoltageR((double)regs[4].getValue() / 10.0);
            workInfo.setAcOutputFrequency((double)regs[5].getValue() / 100.0);
            workInfo.setAcOutputApparentPower((int)P30ModbusProcessor.convert2Regiters(regs[6], regs[7]));
            workInfo.setAcOutputActivePower((int)P30ModbusProcessor.convert2Regiters(regs[8], regs[9]));
            workInfo.setOutputLoadPercent(regs[10].getValue());
            workInfo.setPBatteryVoltage((double)regs[11].getValue() / 10.0);
            workInfo.setChargingCurrent(regs[12].getValue());
            workInfo.setBatteryCapacity(regs[13].getValue());
            workInfo.setPvInputVoltage1((double)regs[14].getValue() / 10.0);
            workInfo.setTtlChargingCurrent(regs[15].getValue());
            workInfo.setAcTtlOutputApparentPower((int)P30ModbusProcessor.convert2Regiters(regs[16], regs[17]));
            workInfo.setAcTtlOutputActivePower((int)P30ModbusProcessor.convert2Regiters(regs[18], regs[19]));
            workInfo.setAcTtlOutputPercent(regs[20].getValue());
            double pvPower = workInfo.getPBatteryVoltage() * workInfo.getPvInputCurrent();
            Double dVal = new Double(pvPower);
            int pvInputPower1 = dVal.intValue();
            workInfo.setPvInputPower1(pvInputPower1);
            workInfo.setCurrentTime(new Date());
            String status = "";
            BitVector warnStatus = new BitVector(16);
            warnStatus.setBytes(regs[21].toBytes(), 16);
            warnStatus.toggleAccess(true);
            int item = 0;
            while (item < 16) {
                status = warnStatus.getBit(item) ? String.valueOf(status) + "1" : String.valueOf(status) + "0";
                ++item;
            }
            if (status.length() >= 8) {
                if (status.charAt(7) == '1') {
                    this.refreshConfig = true;
                }
                if (status.charAt(6) == '1') {
                    workInfo.setHasLoad(true);
                } else {
                    workInfo.setHasLoad(false);
                }
                if (status.charAt(5) == '1') {
                    workInfo.setLineLoss(true);
                    if (!workInfo.getWarnings().contains("2004")) {
                        EventsHandler.handleEvent(workInfo.getProdid(), workInfo.getSerialno(), workInfo.getCurrentTime(), "2004");
                        workInfo.addWarning("2004");
                    }
                } else {
                    workInfo.setLineLoss(false);
                    if (workInfo.getWarnings().contains("2004")) {
                        EventsHandler.handleEvent(workInfo.getProdid(), workInfo.getSerialno(), workInfo.getCurrentTime(), "2016");
                        workInfo.getWarnings().remove("2004");
                    }
                }
                if (status.charAt(1) == '1' || status.charAt(2) == '1') {
                    workInfo.setChargeOn(true);
                } else {
                    workInfo.setChargeOn(false);
                }
                if (status.charAt(1) == '1') {
                    workInfo.setACchargeOn(true);
                } else {
                    workInfo.setACchargeOn(false);
                }
                if (status.charAt(2) == '1') {
                    workInfo.setSCCchargeOn(true);
                } else {
                    workInfo.setSCCchargeOn(false);
                }
                if (workInfo.isChargeOn()) {
                    if (workInfo.isSCCchargeOn() && workInfo.isACchargeOn()) {
                        workInfo.setChargeSource("Solar and Utility");
                    } else if (workInfo.isSCCchargeOn()) {
                        workInfo.setChargeSource("Solar");
                    } else if (workInfo.isACchargeOn()) {
                        workInfo.setChargeSource("Utility");
                    }
                } else {
                    workInfo.setChargeSource("---");
                }
                if (workInfo.isHasLoad()) {
                    if (workInfo.getWorkMode().equals("Line Mode")) {
                        workInfo.setLoadSource("Utility");
                    } else if (workInfo.getWorkMode().equals("Battery Mode")) {
                        workInfo.setLoadSource("Battery");
                    }
                } else {
                    workInfo.setLoadSource("---");
                }
            }
            int outputtype = 0;
            outputtype = regs[22].getValue();
            processor.setOutputMode(outputtype);
            if (processor instanceof ParallSubProcessor) {
                configdata.setSubOutputMode(processor.getSerialNo(), outputtype);
            } else {
                configdata.setOutputMode(outputtype);
            }
            String chargeSource = "Utility";
            if (regs[23].getValue() == 0) {
                chargeSource = "Utility";
            } else if (regs[23].getValue() == 1) {
                chargeSource = "Solar first";
            } else if (regs[23].getValue() == 2) {
                chargeSource = "Utility and Solar";
            } else if (regs[23].getValue() == 3) {
                chargeSource = "Solar only";
            }
            if (processor instanceof ParallSubProcessor) {
                configdata.setChargerSource(processor.getSerialNo(), chargeSource);
            } else {
                configdata.setChargerSource(chargeSource);
            }
            if (processor instanceof ParallSubProcessor) {
                configdata.setMaxChargeCurrent(processor.getSerialNo(), regs[24].getValue());
            } else {
                configdata.setMaxChargeCurrent(regs[24].getValue());
            }
            if (processor instanceof ParallSubProcessor) {
                configdata.setMinMaxChargeCurrent(processor.getSerialNo(), 10.0);
                configdata.setMaxMaxChargeCurrent(processor.getSerialNo(), regs[25].getValue());
            } else {
                configdata.setMaxMaxChargeCurrent(regs[25].getValue());
                configdata.setMinMaxChargeCurrent(10.0);
            }
            if (processor instanceof ParallSubProcessor) {
                configdata.setMaxacchargingcurrent(processor.getSerialNo(), regs[26].getValue());
            } else {
                configdata.setMaxacchargingcurrent(regs[26].getValue());
            }
            workInfo.setPvInputCurrent(regs[27].getValue());
            workInfo.setBatDisCurrent((int)P30ModbusProcessor.convert2Regiters(regs[28], regs[29]));
            String faultcode = new String(regs[1].toBytes()).trim();
            int fCode = regs[1].getValue();
            if (fCode < 10) {
                faultcode = "0" + fCode;
            }
            FaultHandler.doFaultEvent(workInfo, faultcode);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public boolean pollQueryStatus() {
        ModbusHandler handler = this.getHandler();
        if (handler == null) {
            return false;
        }
        if (this._paralleltype == 2) {
            return true;
        }
        boolean result = true;
        WorkInfo workinfo = (WorkInfo)this.getBeanBag().getBean("workinfo");
        try {
            workinfo.setProdid(this._protocol.getProtocolID());
            workinfo.setSerialno(this.getProtocol().getSerialNo());
            workinfo.setCurrentTime(new Date());
            Register[] regs = handler.readMultipleRegisters(3, 3);
            BitVector bits3 = new BitVector(16);
            bits3.setBytes(regs[0].toBytes(), 16);
            bits3.toggleAccess(true);
            this.hasFault = bits3.getBit(9);
            if (bits3.getBit(10)) {
                if (!workinfo.getWarnings().contains("2001")) {
                    EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2001");
                    workinfo.addWarning("2001");
                }
            } else if (workinfo.getWarnings().contains("2001")) {
                workinfo.getWarnings().remove("2001");
            }
            if (bits3.getBit(11)) {
                if (!workinfo.getWarnings().contains("2002")) {
                    EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2002");
                    workinfo.addWarning("2002");
                }
            } else if (workinfo.getWarnings().contains("2002")) {
                workinfo.getWarnings().remove("2002");
            }
            if (bits3.getBit(12)) {
                if (!workinfo.getWarnings().contains("2003")) {
                    EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2003");
                    workinfo.addWarning("2003");
                }
            } else if (workinfo.getWarnings().contains("2003")) {
                workinfo.getWarnings().remove("2003");
            }
            if (bits3.getBit(13)) {
                workinfo.setLineLoss(true);
                if (!workinfo.getWarnings().contains("2004")) {
                    EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2004");
                    workinfo.addWarning("2004");
                }
            } else {
                workinfo.setLineLoss(false);
                if (workinfo.getWarnings().contains("2004")) {
                    EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2016");
                    workinfo.getWarnings().remove("2004");
                }
            }
            if (bits3.getBit(14)) {
                if (!workinfo.getWarnings().contains("2005")) {
                    EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2005");
                    workinfo.addWarning("2005");
                }
            } else if (workinfo.getWarnings().contains("2005")) {
                workinfo.getWarnings().remove("2005");
            }
            if (bits3.getBit(15)) {
                if (!workinfo.getWarnings().contains("2006")) {
                    EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2006");
                    workinfo.addWarning("2006");
                }
            } else if (workinfo.getWarnings().contains("2006")) {
                workinfo.getWarnings().remove("2006");
            }
            BitVector bits4 = new BitVector(16);
            bits4.setBytes(regs[1].toBytes(), 16);
            bits4.toggleAccess(true);
            if (bits4.getBit(0)) {
                if (!workinfo.getWarnings().contains("2007")) {
                    EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2007");
                    workinfo.addWarning("2007");
                }
            } else if (workinfo.getWarnings().contains("2007")) {
                workinfo.getWarnings().remove("2007");
            }
            if (bits4.getBit(1)) {
                if (this.hasFault) {
                    if (!workinfo.getWarnings().contains("1011")) {
                        EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "1011");
                        FaultHandler.recordEvent(workinfo, "1011");
                        workinfo.addWarning("1011");
                    }
                } else if (!workinfo.getWarnings().contains("2008")) {
                    EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2008");
                    workinfo.addWarning("2008");
                }
            } else {
                if (workinfo.getWarnings().contains("2008")) {
                    workinfo.getWarnings().remove("2008");
                }
                if (workinfo.getWarnings().contains("1011")) {
                    workinfo.getWarnings().remove("1011");
                }
            }
            if (bits4.getBit(2)) {
                if (this.hasFault) {
                    if (!workinfo.getWarnings().contains("1001")) {
                        EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "1001");
                        FaultHandler.recordEvent(workinfo, "1001");
                        workinfo.addWarning("1001");
                    }
                } else if (!workinfo.getWarnings().contains("2009")) {
                    EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2009");
                    workinfo.addWarning("2009");
                }
            } else {
                if (workinfo.getWarnings().contains("2009")) {
                    workinfo.getWarnings().remove("2009");
                }
                if (workinfo.getWarnings().contains("1001")) {
                    workinfo.getWarnings().remove("1001");
                }
            }
            if (bits4.getBit(3)) {
                if (this.hasFault) {
                    if (!workinfo.getWarnings().contains("1002")) {
                        EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "1002");
                        FaultHandler.recordEvent(workinfo, "1002");
                        workinfo.addWarning("1002");
                    }
                } else if (!workinfo.getWarnings().contains("2010")) {
                    EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2010");
                    workinfo.addWarning("2010");
                }
            } else {
                if (workinfo.getWarnings().contains("2010")) {
                    workinfo.getWarnings().remove("2010");
                }
                if (workinfo.getWarnings().contains("1002")) {
                    workinfo.getWarnings().remove("1002");
                }
            }
            if (bits4.getBit(4)) {
                if (!workinfo.getWarnings().contains("2011")) {
                    EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2011");
                    workinfo.addWarning("2011");
                }
            } else if (workinfo.getWarnings().contains("2011")) {
                workinfo.getWarnings().remove("2011");
            }
            if (bits4.getBit(5)) {
                if (!workinfo.getWarnings().contains("2012")) {
                    EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2012");
                    workinfo.addWarning("2012");
                }
            } else if (workinfo.getWarnings().contains("2012")) {
                workinfo.getWarnings().remove("2012");
            }
            if (bits4.getBit(6)) {
                if (!workinfo.getWarnings().contains("2013")) {
                    EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2013");
                    workinfo.addWarning("2013");
                }
            } else if (workinfo.getWarnings().contains("2013")) {
                workinfo.removeWarning("2013");
            }
            if (bits4.getBit(7)) {
                if (!workinfo.getWarnings().contains("2014")) {
                    EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2014");
                    workinfo.addWarning("2014");
                }
            } else if (workinfo.getWarnings().contains("2014")) {
                workinfo.removeWarning("2014");
            }
            if (bits4.getBit(8)) {
                if (this.hasFault) {
                    if (!workinfo.getWarnings().contains("1003")) {
                        EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "1003");
                        FaultHandler.recordEvent(workinfo, "1003");
                        workinfo.addWarning("1003");
                    }
                } else if (!workinfo.getWarnings().contains("2015")) {
                    EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2015");
                    workinfo.addWarning("2015");
                }
            } else {
                if (workinfo.getWarnings().contains("2015")) {
                    workinfo.removeWarning("2015");
                }
                if (workinfo.getWarnings().contains("1003")) {
                    workinfo.removeWarning("1003");
                }
            }
            if (bits4.getBit(10)) {
                if (!workinfo.getWarnings().contains("1004")) {
                    EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "1004");
                    workinfo.addWarning("1004");
                }
            } else if (workinfo.getWarnings().contains("1004")) {
                workinfo.removeWarning("1004");
            }
            if (bits4.getBit(11)) {
                if (!workinfo.getWarnings().contains("1005")) {
                    EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "1005");
                    workinfo.addWarning("1005");
                }
            } else if (workinfo.getWarnings().contains("1005")) {
                workinfo.removeWarning("1005");
            }
            if (bits4.getBit(12)) {
                if (!workinfo.getWarnings().contains("1006")) {
                    EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "1006");
                    workinfo.addWarning("1006");
                }
            } else if (workinfo.getWarnings().contains("1006")) {
                workinfo.removeWarning("1006");
            }
            if (bits4.getBit(13)) {
                if (!workinfo.getWarnings().contains("1007")) {
                    EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "1007");
                    workinfo.addWarning("1007");
                }
            } else if (workinfo.getWarnings().contains("1007")) {
                workinfo.removeWarning("1007");
            }
            if (bits4.getBit(14)) {
                if (!workinfo.getWarnings().contains("1008")) {
                    EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "1008");
                    workinfo.addWarning("1008");
                }
            } else if (workinfo.getWarnings().contains("1008")) {
                workinfo.removeWarning("1008");
            }
            if (bits4.getBit(15)) {
                if (!workinfo.getWarnings().contains("1009")) {
                    EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "1009");
                    workinfo.addWarning("1009");
                }
            } else if (workinfo.getWarnings().contains("1009")) {
                workinfo.removeWarning("1009");
            }
            if (bits4.getBit(7)) {
                workinfo.setOverLoad(true);
            } else {
                workinfo.setOverLoad(false);
            }
            BitVector bits5 = new BitVector(16);
            bits5.setBytes(regs[2].toBytes(), 16);
            bits5.toggleAccess(true);
            if (bits5.getBit(0)) {
                if (!workinfo.getWarnings().contains("1010")) {
                    EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "1010");
                    workinfo.addWarning("1010");
                }
            } else if (workinfo.getWarnings().contains("1010")) {
                workinfo.removeWarning("1010");
            }
            this.reconnectTimes = 0;
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
            workinfo.clear();
            ++this.reconnectTimes;
        }
        return result;
    }

    @Override
    public boolean queryCapability() {
        ModbusHandler handler;
        block3: {
            try {
                handler = this.getHandler();
                if (handler != null) break block3;
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        Capability capability = (Capability)this.getBeanBag().getBean("capability");
        Register[] reg = handler.readMultipleRegisters(14, 1);
        BitVector bits = new BitVector(16);
        bits.setBytes(reg[0].toBytes(), 16);
        bits.toggleAccess(true);
        capability.setCapableA(bits.getBit(0));
        capability.setCapableB(bits.getBit(1));
        Register[] regs = handler.readMultipleRegisters(15, 1);
        BitVector bitV = new BitVector(16);
        bitV.setBytes(regs[0].toBytes(), 16);
        bitV.toggleAccess(true);
        capability.setCapableJ(bitV.getBit(0));
        capability.setCapableK(bitV.getBit(1));
        capability.setCapableU(bitV.getBit(5));
        capability.setCapableV(bitV.getBit(3));
        capability.setCapableX(bitV.getBit(6));
        capability.setCapableY(bitV.getBit(7));
        capability.setCapableZ(bitV.getBit(8));
        return true;
    }

    @Override
    public boolean queryConfigData() {
        block57: {
            ModbusHandler handler;
            block56: {
                handler = this.getHandler();
                if (handler != null) break block56;
                return false;
            }
            try {
                MachineInfo machine = (MachineInfo)this.getBeanBag().getBean("machineinfo");
                ConfigData configdata = (ConfigData)this.getBeanBag().getBean("configdata");
                Register[] outputVoltage = handler.readMultipleRegisters(1171, 1);
                configdata.setOutputVoltage(String.valueOf((double)outputVoltage[0].getValue() / 10.0));
                Register[] outputFrequency = handler.readMultipleRegisters(1170, 1);
                configdata.setOutputFrequency(String.valueOf(outputFrequency[0].getValue() / 10));
                Register[] batteryRatingVoltage = handler.readMultipleRegisters(1176, 1);
                configdata.setBatteryVoltage((double)batteryRatingVoltage[0].getValue() / 10.0);
                if (configdata.getBatteryVoltage() > 40.0) {
                    configdata.setMinBatteryUnder(40.0);
                    configdata.setMaxBatteryUnder(48.0);
                } else if (configdata.getBatteryVoltage() > 20.0) {
                    configdata.setMinBatteryUnder(20.0);
                    configdata.setMaxBatteryUnder(24.0);
                } else {
                    configdata.setMinBatteryUnder(10.0);
                    configdata.setMaxBatteryUnder(12.0);
                }
                Register[] chargingInfo = handler.readMultipleRegisters(1476, 11);
                double maxChargeCurrent = chargingInfo[0].getValue();
                if (machine.isChargeCurrentComBox()) {
                    configdata.setMaxacchargingcurrent(maxChargeCurrent);
                } else {
                    configdata.setMaxMaxChargeCurrent(maxChargeCurrent);
                }
                configdata.setBatteryUnder((double)chargingInfo[1].getValue() / 10.0);
                String batteryType = "AGM";
                if (chargingInfo[2].getValue() == 0) {
                    batteryType = "AGM";
                } else if (chargingInfo[2].getValue() == 1) {
                    batteryType = "Flooded";
                } else if (chargingInfo[2].getValue() == 2) {
                    batteryType = "User";
                }
                configdata.setBatteryType(batteryType);
                String outputSource = "Utility";
                if (chargingInfo[3].getValue() == 0) {
                    outputSource = "Utility";
                } else if (chargingInfo[3].getValue() == 1) {
                    outputSource = "Solar";
                } else if (chargingInfo[3].getValue() == 2) {
                    outputSource = "SBU";
                }
                configdata.setOutputSource(outputSource);
                String chargeSource = "Utility";
                if (chargingInfo[4].getValue() == 0) {
                    chargeSource = "Utility";
                } else if (chargingInfo[4].getValue() == 1) {
                    chargeSource = "Solar first";
                } else if (chargingInfo[4].getValue() == 2) {
                    chargeSource = "Utility and Solar";
                } else if (chargingInfo[4].getValue() == 3) {
                    chargeSource = "Solar only";
                }
                configdata.setChargerSource(chargeSource);
                configdata.setRechargeVoltage((double)chargingInfo[6].getValue() / 10.0);
                String inputVoltageRange = "Appliance";
                if (chargingInfo[7].getValue() == 0) {
                    inputVoltageRange = "Appliance";
                } else if (chargingInfo[7].getValue() == 1) {
                    inputVoltageRange = "UPS";
                }
                configdata.setAcInputRange(inputVoltageRange);
                if (chargingInfo[8].getValue() == 1) {
                    configdata.setAllpvok(true);
                } else {
                    configdata.setAllpvok(false);
                }
                if (chargingInfo[9].getValue() == 1) {
                    configdata.setSolarbalance(true);
                } else {
                    configdata.setSolarbalance(false);
                }
                if (VolUtil.round((double)chargingInfo[10].getValue() / 10.0, 0) == 0.0) {
                    configdata.setReDischargeVoltage("FULL");
                } else {
                    String reDisChargeVol = String.valueOf((double)chargingInfo[10].getValue() / 10.0);
                    configdata.setReDischargeVoltage(reDisChargeVol);
                }
                Register[] bulkChargingVoltage = handler.readMultipleRegisters(1493, 1);
                configdata.setMaxChargeVoltage((double)bulkChargingVoltage[0].getValue() / 10.0);
                if (configdata.getBatteryVoltage() > 40.0) {
                    configdata.setMinMaxChargeVoltage(48.0);
                    configdata.setMaxMaxChargeVoltage(58.4);
                } else if (configdata.getBatteryVoltage() > 20.0) {
                    configdata.setMinMaxChargeVoltage(24.0);
                    configdata.setMaxMaxChargeVoltage(29.21);
                } else {
                    configdata.setMinMaxChargeVoltage(12.0);
                    configdata.setMaxMaxChargeVoltage(14.6);
                }
                Register[] chargeCurAndChargeVol = handler.readMultipleRegisters(1456, 2);
                configdata.setFloatingChargeVoltage((double)chargeCurAndChargeVol[0].getValue() / 10.0);
                if (configdata.getBatteryVoltage() > 40.0) {
                    configdata.setMinFloatingChargeVoltage(48.0);
                    configdata.setMaxFloatingChargeVoltage(58.4);
                } else if (configdata.getBatteryVoltage() > 20.0) {
                    configdata.setMinFloatingChargeVoltage(24.0);
                    configdata.setMaxFloatingChargeVoltage(29.21);
                } else {
                    configdata.setMinFloatingChargeVoltage(12.0);
                    configdata.setMaxFloatingChargeVoltage(14.6);
                }
                configdata.setMaxChargeCurrent(chargeCurAndChargeVol[1].getValue());
                configdata.setMinMaxChargeCurrent(10.0);
                try {
                    Register[] chargingTime = handler.readMultipleRegisters(1487, 1);
                    configdata.setChargingTimeInCVStage(chargingTime[0].getValue());
                    configdata.setMinChargingTimeInCVStage(0);
                    configdata.setMaxChargingTimeInCVStage(900);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                String chargingCurrentStr = "";
                Register[] chargingCurrentComBox = handler.readMultipleRegisters(300, 25);
                int item = 0;
                while (item < chargingCurrentComBox.length) {
                    chargingCurrentStr = String.valueOf(chargingCurrentStr) + new String(chargingCurrentComBox[item].toBytes());
                    ++item;
                }
                if (!"".equals(chargingCurrentStr = chargingCurrentStr.trim())) {
                    String[] chargingCurrent = chargingCurrentStr.split(" ");
                    if (machine.isChargeCurrentComBox()) {
                        int index = 0;
                        while (index < chargingCurrent.length) {
                            try {
                                chargingCurrent[index] = String.format("%d", Integer.parseInt(chargingCurrent[index]));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            ++index;
                        }
                        configdata.setChargingCurrentComBox(chargingCurrent);
                    } else {
                        configdata.setMinMaxChargeCurrent(VolUtil.parseDouble(chargingCurrent[0]));
                        configdata.setMaxMaxChargeCurrent(VolUtil.parseDouble(chargingCurrent[1]));
                    }
                }
                String acChargingCurrentStr = "";
                Register[] acComBox = handler.readMultipleRegisters(325, 25);
                int item2 = 0;
                while (item2 < chargingCurrentComBox.length) {
                    acChargingCurrentStr = String.valueOf(acChargingCurrentStr) + new String(acComBox[item2].toBytes());
                    ++item2;
                }
                if ("".equals(acChargingCurrentStr = acChargingCurrentStr.trim())) break block57;
                String[] acChargingCurrent = acChargingCurrentStr.split(" ");
                int index = 0;
                while (index < acChargingCurrent.length) {
                    try {
                        acChargingCurrent[index] = String.format("%d", Integer.parseInt(acChargingCurrent[index]));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++index;
                }
                configdata.setAcChargingCurrentComBox(acChargingCurrent);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean queryDefaultData() {
        ModbusHandler handler;
        block26: {
            try {
                handler = this.getHandler();
                if (handler != null) break block26;
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        DefaultData defaultData = (DefaultData)this.getBeanBag().getBean("defaultdata");
        Register[] reg = handler.readMultipleRegisters(1184, 13);
        defaultData.setAcOutputVoltage((double)reg[0].getValue() / 10.0);
        defaultData.setAcOutputFrequency((double)reg[1].getValue() / 10.0);
        defaultData.setMaxACChargingCurrent(reg[2].getValue());
        defaultData.setBatteryCutoffVoltage((double)reg[3].getValue() / 10.0);
        defaultData.setFloatChargingVoltage((double)reg[4].getValue() / 10.0);
        defaultData.setMaxChargingVoltage((double)reg[5].getValue() / 10.0);
        defaultData.setReChangingVoltage((double)reg[6].getValue() / 10.0);
        defaultData.setMaxChargingCurrent(reg[7].getValue());
        if (reg[8].getValue() == 0) {
            defaultData.setAcInputVoltage("Appliance");
        } else if (1 == reg[8].getValue()) {
            defaultData.setAcInputVoltage("UPS");
        }
        if (reg[9].getValue() == 0) {
            defaultData.setOutputSourcePriority("Utility");
        } else if (1 == reg[9].getValue()) {
            defaultData.setOutputSourcePriority("Solar");
        } else if (2 == reg[9].getValue()) {
            defaultData.setOutputSourcePriority("SBU");
        }
        if (reg[10].getValue() == 0) {
            defaultData.setChargerSourcePriority("Utility");
        } else if (1 == reg[10].getValue()) {
            defaultData.setChargerSourcePriority("Solar");
        } else if (2 == reg[10].getValue()) {
            defaultData.setChargerSourcePriority("Utility and Solar");
        } else if (3 == reg[10].getValue()) {
            defaultData.setChargerSourcePriority("Solar only");
        }
        if (reg[11].getValue() == 0) {
            defaultData.setBatteryType("AGM");
        } else if (1 == reg[11].getValue()) {
            defaultData.setBatteryType("Flooded");
        } else if (2 == reg[11].getValue()) {
            defaultData.setBatteryType("User");
        }
        reg = handler.readMultipleRegisters(1200, 2);
        String[] modes = new String[]{"Single", "Parallel", "Phase R of 3 phase output", "Phase S of 3 phase output", "Phase T of 3 phase output"};
        int outputmode = reg[0].getValue();
        if (outputmode >= 0 && outputmode <= 4) {
            defaultData.setOutputMode(modes[outputmode]);
        }
        defaultData.setReDischargeVoltage((double)reg[1].getValue() / 10.0);
        reg = handler.readMultipleRegisters(16, 2);
        BitVector bits = new BitVector(16);
        bits.setBytes(reg[0].toBytes(), 16);
        bits.toggleAccess(true);
        defaultData.setCapableA(bits.getBit(0) ? "Enable" : "Disable");
        defaultData.setCapableB(bits.getBit(1) ? "Enable" : "Disable");
        BitVector bitV = new BitVector(16);
        bitV.setBytes(reg[1].toBytes(), 16);
        bitV.toggleAccess(true);
        defaultData.setCapableJ(bitV.getBit(0) ? "Enable" : "Disable");
        defaultData.setCapableK(bitV.getBit(1) ? "Enable" : "Disable");
        defaultData.setCapableU(bitV.getBit(5) ? "Enable" : "Disable");
        defaultData.setCapableV(bitV.getBit(3) ? "Enable" : "Disable");
        defaultData.setCapableX(bitV.getBit(6) ? "Enable" : "Disable");
        defaultData.setCapableY(bitV.getBit(7) ? "Enable" : "Disable");
        defaultData.setCapableZ(bitV.getBit(8) ? "Enable" : "Disable");
        reg = handler.readMultipleRegisters(1198, 1);
        int chargingTimeInCVStage = reg[0].getValue();
        if (chargingTimeInCVStage == 0) {
            defaultData.setChargingTimeInCVStage("Auto");
        } else {
            defaultData.setChargingTimeInCVStage(String.valueOf(chargingTimeInCVStage));
        }
        return true;
    }

    @Override
    public boolean queryMachineInfo() {
        ModbusHandler handler;
        block15: {
            handler = this.getHandler();
            if (handler != null) break block15;
            return false;
        }
        try {
            MachineInfo machineInfo = (MachineInfo)this.getBeanBag().getBean("machineinfo");
            machineInfo.setSerialno(handler.getSerialNo());
            Register[] qvfw = handler.readMultipleRegisters(993, 10);
            String mainFirmwareVersion = "";
            int item = 0;
            while (item < qvfw.length) {
                mainFirmwareVersion = String.valueOf(mainFirmwareVersion) + new String(qvfw[item].toBytes()).trim();
                ++item;
            }
            machineInfo.setMainFirmwareVersion(mainFirmwareVersion);
            Register[] qvfw2 = handler.readMultipleRegisters(1180, 4);
            String slaveFirmwareVersion = "";
            int item2 = 0;
            while (item2 < qvfw2.length) {
                slaveFirmwareVersion = String.valueOf(slaveFirmwareVersion) + new String(qvfw2[item2].toBytes()).trim();
                ++item2;
            }
            if (slaveFirmwareVersion.equals("")) {
                slaveFirmwareVersion = "---";
            }
            machineInfo.setSlaveFirmwareVersion(slaveFirmwareVersion);
            Register[] outputRatedVA = handler.readMultipleRegisters(1017, 2);
            machineInfo.setAcOutputRatingApparentPower((int)P30ModbusProcessor.convert2Regiters(outputRatedVA[0], outputRatedVA[1]));
            Register[] acOutputRatingActivePower = handler.readMultipleRegisters(1037, 2);
            machineInfo.setAcOutputRatingActivePower((int)P30ModbusProcessor.convert2Regiters(acOutputRatingActivePower[0], acOutputRatingActivePower[1]));
            Register[] gridRatingVoltage = handler.readMultipleRegisters(1167, 1);
            machineInfo.setGridRatingVoltage((double)gridRatingVoltage[0].getValue() / 10.0);
            Register[] gridRatingCurrent = handler.readMultipleRegisters(1169, 1);
            machineInfo.setGridRatingCurrent((double)gridRatingCurrent[0].getValue() / 10.0);
            Register[] acOutputRating = handler.readMultipleRegisters(1170, 3);
            machineInfo.setAcOutputRatingVoltage((double)acOutputRating[1].getValue() / 10.0);
            machineInfo.setAcOutputRatingFrequency((double)acOutputRating[0].getValue() / 10.0);
            machineInfo.setAcOutputRatingCurrent((double)acOutputRating[2].getValue() / 10.0);
            Register[] batteryRatingVoltage = handler.readMultipleRegisters(1176, 1);
            machineInfo.setBatteryRatingVoltage((double)batteryRatingVoltage[0].getValue() / 10.0);
            Register[] machineTypeAndTopology = handler.readMultipleRegisters(1178, 2);
            String machineType = new String(machineTypeAndTopology[0].toBytes()).trim();
            if (machineType.equals("00")) {
                machineType = "Grid tie";
            } else if (machineType.equals("01")) {
                machineType = "Stand alone";
            } else if (machineType.equals("10")) {
                machineType = "Hybrid";
            } else if (machineType.equals("30") || machineType.equals("31")) {
                machineType = "Stand alone";
            }
            machineInfo.setMachineType(machineType);
            String topology = new String(machineTypeAndTopology[1].toBytes()).trim();
            machineInfo.setTopology(topology.equals("0") ? "Transformerless" : "Transformer");
            Register[] register = handler.readMultipleRegisters(1481, 1);
            int outputmode = register[0].getValue();
            this._protocol.setOutputMode(outputmode);
            this._outputmode = outputmode;
            if (outputmode != 0) {
                this._paralleltype = 1;
                Register[] parallelMaxNum = handler.readMultipleRegisters(1166, 1);
                this._parallelnum = parallelMaxNum[0].getValue();
            } else {
                this._paralleltype = 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public void querySelfTestResult() {
    }

    @Override
    public boolean supportSelfTest() {
        return false;
    }
}

