/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.processor;

import cn.com.voltronic.solar.beanbag.BeanBag;
import cn.com.voltronic.solar.communicate.ICommunicateDevice;
import cn.com.voltronic.solar.comusbprocessor.ParallSubProcessor;
import cn.com.voltronic.solar.control.AbstractControlModule;
import cn.com.voltronic.solar.dao.DeviceDao;
import cn.com.voltronic.solar.data.bean.DeviceBean;
import cn.com.voltronic.solar.data.bean.WorkInfo;
import cn.com.voltronic.solar.exception.EventsHandler;
import cn.com.voltronic.solar.processor.WorkMonitor;
import cn.com.voltronic.solar.protocol.IProtocol;
import cn.com.voltronic.solar.system.GlobalProcessors;
import cn.com.voltronic.solar.util.RunTools;
import java.util.HashMap;
import net.wimpi.modbus.util.BitVector;

public abstract class AbstractProcessor {
    public static final int POLL_TIME_PERIOD = 2000;
    public static final int ENERGY_TIME_PERIOD = 30000;
    protected ICommunicateDevice _handler;
    protected BeanBag _beanbag;
    protected AbstractControlModule _control;
    protected IProtocol _protocol;
    protected String _deviceName;
    protected String _faultID = "00";
    protected boolean hasFault = false;
    protected int _paralleltype = 0;
    protected int _parallelnum = 0;
    protected int _outputmode = 0;
    protected String _serialNo;
    protected HashMap<String, ParallSubProcessor> subMap = null;
    protected int parallkey = 0;
    protected String _processKey = "";
    private boolean startQuerySelfTestResult = false;
    public boolean isfirstquery = true;
    public boolean isfirstenery = true;
    private WorkMonitor monitorThread;
    public int reconnectTimes = 0;
    private volatile boolean _closing = false;

    public String getDeviceName() {
        return this._deviceName;
    }

    public int getParalleltype() {
        return this._paralleltype;
    }

    public void setOutputMode(int mode) {
        this._outputmode = mode;
    }

    public int getOutputMode() {
        return this._outputmode;
    }

    public void setDeviceName(String name) {
        this._deviceName = name;
    }

    public boolean isParent(AbstractProcessor subProcess) {
        return this._paralleltype == 1 && this.subMap != null && this.subMap.containsKey(subProcess.getSerialNo());
    }

    public String getSerialNo() {
        return this._serialNo;
    }

    public void setSerialNo(String serialno) {
        this._serialNo = serialno;
    }

    protected String getValidate(String Command2) {
        int temp = 0;
        int i = 0;
        while (i < Command2.length()) {
            char ch = Command2.charAt(i);
            temp += ch;
            ++i;
        }
        String ascii = String.valueOf(temp &= 0xFF);
        int index = ascii.length();
        while (index < 3) {
            ascii = "0" + ascii;
            ++index;
        }
        return ascii;
    }

    public void saveDevice() {
        String prodid = this.getProtocol().getProtocolID();
        String serialno = this.getSerialNo();
        DeviceDao dao = new DeviceDao();
        if (!(serialno == null || "".equals(serialno) || serialno.equals("(NAK") || serialno.equals("(ACK") || prodid == null || "".equals(prodid))) {
            DeviceBean bean = new DeviceBean();
            bean.setProdid(prodid);
            bean.setSerialno(serialno);
            bean.setMpptnumber(1);
            bean.setModetype(this.getProtocol().getMachineType());
            bean.setParallel(this._outputmode);
            this.subMap = new HashMap();
            dao.InsertOrUpdateDevice(bean);
        }
    }

    public void startMonitor() throws Exception {
        if (this._paralleltype != 2) {
            if (this._closing || this._handler == null) {
                GlobalProcessors.removeProcessor(this.processorKey());
                return;
            }
            this.saveDevice();
            this.monitorThread = new WorkMonitor(this);
            this.monitorThread.setPriority(5);
            this.monitorThread.start();
            GlobalProcessors.setCurrentProcesserIfExist(this.processorKey());
        }
    }

    public void close() {
        this._closing = true;
        if (this.subMap != null) {
            for (AbstractProcessor abstractProcessor : this.subMap.values()) {
                if (abstractProcessor.getSerialNo().equalsIgnoreCase(this.getSerialNo())) continue;
                abstractProcessor.close();
            }
            this.subMap.clear();
        }
        if (this._paralleltype != 2 && this.getHandler() != null) {
            boolean bl;
            boolean bl2 = false;
            try {
                this.getHandler().close();
            }
            catch (Exception e) {
                e.printStackTrace();
                boolean bl3 = true;
            }
            int poll = 0;
            while (bl && poll < 6) {
                try {
                    Thread.sleep(100L);
                    this.getHandler().close();
                    bl = false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    bl = true;
                    ++poll;
                }
            }
            this._handler = null;
        }
        GlobalProcessors.removeProcessor(this.processorKey());
    }

    public void setParallKey(int key) {
        this.parallkey = key;
    }

    public int getParallKey() {
        return this.parallkey;
    }

    public boolean isClosing() {
        return this._closing;
    }

    public AbstractProcessor(ICommunicateDevice handler, IProtocol protocol) {
        this._handler = handler;
        this._handler.setNotifyProcess(this);
        this._protocol = protocol;
        this.initControlModule();
        this.initBeanBag();
        this.initProtocol();
        this._serialNo = this._protocol.getSerialNo();
    }

    public abstract boolean queryDefaultData();

    public String reGenProcesorKey() {
        this._processKey = this._outputmode == 0 ? String.valueOf(this.getDeviceName()) + "_" + this.getSerialNo() : (this._outputmode == 1 ? String.valueOf(this.getDeviceName()) + "_" + this.getSerialNo() + "_PARALLEL" : (this._outputmode == 2 ? String.valueOf(this.getDeviceName()) + "_" + this.getSerialNo() + "_R PHASE" : (this._outputmode == 3 ? String.valueOf(this.getDeviceName()) + "_" + this.getSerialNo() + "_S PHASE" : (this._outputmode == 4 ? String.valueOf(this.getDeviceName()) + "_" + this.getSerialNo() + "_T PHASE" : String.valueOf(this.getDeviceName()) + "_" + this.getSerialNo()))));
        return this._processKey;
    }

    public String processorKey() {
        if (this._processKey.isEmpty()) {
            this._processKey = this._outputmode == 0 ? String.valueOf(this.getDeviceName()) + "_" + this.getSerialNo() : (this._outputmode == 1 ? String.valueOf(this.getDeviceName()) + "_" + this.getSerialNo() + "_PARALLEL" : (this._outputmode == 2 ? String.valueOf(this.getDeviceName()) + "_" + this.getSerialNo() + "_R PHASE" : (this._outputmode == 3 ? String.valueOf(this.getDeviceName()) + "_" + this.getSerialNo() + "_S PHASE" : (this._outputmode == 4 ? String.valueOf(this.getDeviceName()) + "_" + this.getSerialNo() + "_T PHASE" : String.valueOf(this.getDeviceName()) + "_" + this.getSerialNo()))));
        }
        return this._processKey;
    }

    public String processorKeyAlias(String alias) {
        String processKey = "";
        processKey = this._outputmode == 0 ? String.valueOf(this.getDeviceName()) + "_" + alias : (this._outputmode == 1 ? String.valueOf(this.getDeviceName()) + "_" + alias + "_PARALLEL" : (this._outputmode == 2 ? String.valueOf(this.getDeviceName()) + "_" + alias + "_R PHASE" : (this._outputmode == 3 ? String.valueOf(this.getDeviceName()) + "_" + alias + "_S PHASE" : (this._outputmode == 4 ? String.valueOf(this.getDeviceName()) + "_" + alias + "_T PHASE" : String.valueOf(this.getDeviceName()) + "_" + alias))));
        return processKey;
    }

    protected abstract void initBeanBag();

    public BeanBag getBeanBag() {
        return this._beanbag;
    }

    public ICommunicateDevice getHandler() {
        return this._handler;
    }

    protected abstract void initControlModule();

    public abstract void querySelfTestResult();

    public abstract boolean supportSelfTest();

    public AbstractControlModule getControlModule() {
        return this._control;
    }

    public abstract void initProtocol();

    public IProtocol getProtocol() {
        return this._protocol;
    }

    public boolean executeControl(String commandMethod, Object[] paras) {
        return this._control.execute(commandMethod, paras);
    }

    public abstract boolean pollQuery();

    public abstract boolean pollQueryStatus();

    public abstract boolean queryMachineInfo();

    public abstract boolean queryCapability();

    public abstract boolean queryConfigData();

    public boolean executeQuery(String queryMethod) {
        return (Boolean)RunTools.runMethod((Object)this, queryMethod, null);
    }

    public double parseDoubleV(String str) throws Exception {
        return Double.parseDouble(str);
    }

    public final void refreshWarningStatus(BitVector warnStatus, BitVector oldwarnings, int index, String eventCode, WorkInfo workinfo) {
        if (warnStatus.getBit(index)) {
            EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), eventCode);
            workinfo.addWarning(eventCode);
        }
    }

    public void setThreadPriority(int priority) {
        if (this.monitorThread != null) {
            this.monitorThread.setPriority(priority);
        }
    }

    public int getThreadPriority() {
        int kmoniter = 5;
        int kenergy = 5;
        if (this.monitorThread != null) {
            kmoniter = this.monitorThread.getPriority();
        }
        if (kmoniter == 10 || kenergy == 10) {
            return 10;
        }
        return 5;
    }

    public boolean isStartQuerySelfTestResult() {
        return this.startQuerySelfTestResult;
    }

    public void setStartQuerySelfTestResult(boolean startQuerySelfTestResult) {
        this.startQuerySelfTestResult = startQuerySelfTestResult;
    }

    public boolean is4to5k(double acOutputRatingApparentPower) {
        return acOutputRatingApparentPower >= 4000.0 && acOutputRatingApparentPower <= 5000.0;
    }
}

