/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.protocol;

import cn.com.voltronic.solar.communicate.IComUSBHandler;
import cn.com.voltronic.solar.communicate.ModbusHandler;
import cn.com.voltronic.solar.communicate.SNMPHandler;
import cn.com.voltronic.solar.configure.CustomerConfig;
import cn.com.voltronic.solar.data.bean.AutoComboBoxItem;
import cn.com.voltronic.solar.data.bean.AutoLabelItem;
import cn.com.voltronic.solar.data.bean.AutoMenuItem;
import cn.com.voltronic.solar.data.bean.AutoMenuList;
import cn.com.voltronic.solar.data.bean.AutoMenuOne;
import cn.com.voltronic.solar.data.bean.AutoMenuTwo;
import cn.com.voltronic.solar.data.bean.AutoRadioItem;
import cn.com.voltronic.solar.data.bean.AutoSpinnerItem;
import cn.com.voltronic.solar.data.bean.BaseInfo;
import cn.com.voltronic.solar.data.bean.ComboBoxParameter;
import cn.com.voltronic.solar.data.bean.ConfigData;
import cn.com.voltronic.solar.data.bean.HistoryChart;
import cn.com.voltronic.solar.data.bean.HistoryData;
import cn.com.voltronic.solar.data.bean.HistoryDataChartColumns;
import cn.com.voltronic.solar.data.bean.HistoryDataColumns;
import cn.com.voltronic.solar.data.bean.HistoryFaultDataColumns;
import cn.com.voltronic.solar.data.bean.MachineInfo;
import cn.com.voltronic.solar.data.bean.MoreInfo;
import cn.com.voltronic.solar.data.bean.ProductInfo;
import cn.com.voltronic.solar.data.bean.PurchaseInfo;
import cn.com.voltronic.solar.data.bean.RadioParameter;
import cn.com.voltronic.solar.data.bean.RatingInfo;
import cn.com.voltronic.solar.data.bean.RestoreInfo;
import cn.com.voltronic.solar.data.bean.SpinnerParameter;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.protocol.IProtocol;
import cn.com.voltronic.solar.system.GlobalProcessors;
import cn.com.voltronic.solar.system.GlobalVariables;
import cn.com.voltronic.solar.util.VolUtil;
import java.util.ArrayList;
import net.wimpi.modbus.procimg.Register;

public class P30
implements IProtocol {
    public String axpertType = "";
    public String axpert = "";
    public String serialNo = "";
    private volatile boolean delaychanging = false;
    public int outputmode = 0;
    public String machineType = "";

    @Override
    public String getProtocolID() {
        return "P30";
    }

    @Override
    public boolean matchProtocol(Object handler) {
        if (handler instanceof IComUSBHandler) {
            return this.matchComUSB((IComUSBHandler)handler);
        }
        if (handler instanceof ModbusHandler) {
            try {
                return this.matchModbus((ModbusHandler)handler);
            }
            catch (Exception e) {
                return false;
            }
        }
        if (handler instanceof SNMPHandler) {
            return this.matchSnmp((SNMPHandler)handler);
        }
        return false;
    }

    public boolean matchComUSB(IComUSBHandler _handler) {
        String dataStr = "(NAK";
        int i = 0;
        while (i < 5) {
            if (!dataStr.equals("(NAK")) break;
            try {
                dataStr = _handler.excuteSimpleCommand("QPI");
            }
            catch (Exception e) {
                return false;
            }
            ++i;
        }
        if (dataStr.startsWith("(PI") && dataStr.endsWith("30") && this instanceof P30) {
            block14: {
                block15: {
                    block16: {
                        try {
                            String qpiri = _handler.excuteSimpleCommand("QPIRI");
                            if (!this.isNotEmpty(qpiri)) break block14;
                            String[] item = qpiri.split(" ");
                            this.machineType = item[19];
                            if (!this.machineType.equals("00") && !this.machineType.equals("01") && !this.machineType.equals("10")) break block15;
                            String serialNoStr = _handler.getSerialNo();
                            if (serialNoStr != null && !"".equals(serialNoStr)) {
                                this.serialNo = serialNoStr;
                                break block16;
                            }
                            return false;
                        }
                        catch (Exception ex) {
                            return false;
                        }
                    }
                    dataStr = _handler.excuteSimpleCommand("QPIRI");
                    if (!"".equals(dataStr) && !dataStr.equals("(NAK")) {
                        String[] ratingInfo = dataStr.split(" ");
                        if (ratingInfo[15].equals("2") || ratingInfo[15].equals("3")) {
                            this.outputmode = 1;
                        } else if (ratingInfo.length > 21) {
                            try {
                                this.outputmode = Integer.parseInt(ratingInfo[21]);
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean matchModbus(ModbusHandler modbus) throws Exception {
        boolean result = false;
        Register[] regs = modbus.readMultipleRegisters(992, 1);
        if (regs != null && regs.length == 1) {
            String pid = new String(regs[0].toBytes());
            if ((pid = "P" + pid).equals(this.getProtocolID())) {
                result = true;
            }
        }
        if (!result) {
            return false;
        }
        this.serialNo = modbus.getSerialNo();
        if ("".equals(this.serialNo)) {
            result = false;
        }
        regs = modbus.readMultipleRegisters(1481, 1);
        this.outputmode = regs[0].getValue();
        return result;
    }

    public boolean matchSnmp(SNMPHandler snmp) {
        String qpi = snmp.get(".1.3.6.1.4.1.21111.1.2.1.2");
        String pid = new String(qpi);
        if (!(pid = "P" + pid).equals(this.getProtocolID())) {
            return false;
        }
        this.serialNo = snmp.getSerialNo();
        if ("".equals(this.serialNo)) {
            return false;
        }
        this.outputmode = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.11.9"));
        return true;
    }

    @Override
    public BaseInfo getBaseInfo() {
        BaseInfo baseInfo = new BaseInfo();
        ArrayList<AutoLabelItem> item = new ArrayList<AutoLabelItem>();
        item.add(new AutoLabelItem("message.acVoltage[:]", "{workInfo.getGridVoltageR}", "V"));
        item.add(new AutoLabelItem("message.acFrequency[:]", "{workInfo.getGridFrequency}", "Hz"));
        item.add(new AutoLabelItem("message.pvInputVoltage[:]", "{workInfo.getPvInputVoltage1}", "V"));
        item.add(new AutoLabelItem("message.pvInputPower[:]", "{workInfo.getPvInputPower1}", "W"));
        item.add(new AutoLabelItem("message.batteryVoltage[:]", "{workInfo.getPBatteryVoltage}", "V"));
        item.add(new AutoLabelItem("message.batteryCapacity[:]", "{workInfo.getBatteryCapacity}", "%"));
        if (this.getAxpertType().equals("VM-1000") || this.getAxpertType().equals("VM-1200") || this.getAxpertType().equals("VM-2000") || this.getAxpertType().equals("VM-2200") || this.getAxpertType().equals("VM-3200") || this.getAxpertType().equals("VM-3000") || this.getAxpertType().equals("VP-1000") || this.getAxpertType().equals("VP-2000") || this.getAxpertType().equals("VP-3000")) {
            item.add(new AutoLabelItem("message.pvInputCurrent[:]", "{workInfo.getChargingCurrent}", "A"));
        } else {
            item.add(new AutoLabelItem("message.chargeCurrent[:]", "{workInfo.getChargingCurrent}", "A"));
        }
        item.add(new AutoLabelItem("message.batdiscurrent[:]", "{workInfo.getBatDisCurrent}", "A"));
        item.add(new AutoLabelItem("message.outputVoltage[:]", "{workInfo.getAcOutputVoltageR}", "V"));
        item.add(new AutoLabelItem("message.outputFrequency[:]", "{workInfo.getAcOutputFrequency}", "Hz"));
        item.add(new AutoLabelItem("message.outputapppower[:]", "{workInfo.getAcOutputApparentPower}", "VA"));
        item.add(new AutoLabelItem("message.outputactpower[:]", "{workInfo.getAcOutputActivePower}", "W"));
        item.add(new AutoLabelItem("message.loadpercent[:]", "{workInfo.getOutputLoadPercent}", "%"));
        if (this.outputmode == 1) {
            item.add(new AutoLabelItem("message.totalchargingcurrent[:]", "{workInfo.getTtlChargingCurrent}", "A"));
            item.add(new AutoLabelItem("message.totaloutputapparentpower[:]", "{workInfo.getAcTtlOutputApparentPower}", "VA"));
            item.add(new AutoLabelItem("message.totaloutputactivepower[:]", "{workInfo.getAcTtlOutputActivePower}", "W"));
            item.add(new AutoLabelItem("message.totaloutputpercent[:]", "{workInfo.getAcTtlOutputPercent}", "%"));
        }
        baseInfo.setBaseInfoList(item);
        return baseInfo;
    }

    @Override
    public MoreInfo getMoreInfo() {
        return null;
    }

    @Override
    public ProductInfo getProductInfo() {
        ProductInfo productInfo = new ProductInfo();
        ArrayList<AutoLabelItem> infos = new ArrayList<AutoLabelItem>();
        infos.add(new AutoLabelItem("message.machinetype[:]", "{machineInfo.getMachineType}", ""));
        infos.add(new AutoLabelItem("message.topology[:]", "{machineInfo.getTopology}", ""));
        infos.add(new AutoLabelItem("message.maincpuversion[:]", "{machineInfo.getMainFirmwareVersion}", ""));
        if (!(this.getAxpertType().equals("VMII-3000") || this.getAxpertType().equals("VMII-5000") || this.getAxpertType().equals("VMII-1500") || this.getAxpertType().startsWith("VMIII") || this.getAxpertType().equals("") || this.getAxpertType().equals(" "))) {
            infos.add(new AutoLabelItem("message.secondarycupversion[:]", "{machineInfo.getSlaveFirmwareVersion}", ""));
        }
        productInfo.setInfos(infos);
        return productInfo;
    }

    @Override
    public PurchaseInfo getPurchaseInfo() {
        return null;
    }

    @Override
    public RatingInfo getRatingInfo() {
        RatingInfo ratingInfo = new RatingInfo();
        ArrayList<AutoLabelItem> infos = new ArrayList<AutoLabelItem>();
        infos.add(new AutoLabelItem("message.nominalacvol[:]", "{machineInfo.getGridRatingVoltage}", "V"));
        infos.add(new AutoLabelItem("message.nominalaccur[:]", "{machineInfo.getGridRatingCurrent}", "A"));
        infos.add(new AutoLabelItem("message.batteryRatingVoltage[:]", "{machineInfo.getBatteryRatingVoltage}", "V"));
        infos.add(new AutoLabelItem("message.nominaloutputvol[:]", "{machineInfo.getAcOutputRatingVoltage}", "V"));
        infos.add(new AutoLabelItem("message.nominaloutputfre[:]", "{machineInfo.getAcOutputRatingFrequency}", "Hz"));
        infos.add(new AutoLabelItem("message.nominaloutputcur[:]", "{machineInfo.getAcOutputRatingCurrent}", "A"));
        infos.add(new AutoLabelItem("message.nominaloutputapparentpower[:]", "{machineInfo.getAcOutputRatingApparentPower}", "VA"));
        infos.add(new AutoLabelItem("message.nominaloutputactivepowwer[:]", "{machineInfo.getAcOutputRatingActivePower}", "W"));
        ratingInfo.setInfos(infos);
        return ratingInfo;
    }

    @Override
    public RestoreInfo getResotreInfo() {
        AbstractProcessor processor = GlobalProcessors.getCurrentProcessor();
        MachineInfo machineInfo = null;
        if (processor != null) {
            machineInfo = (MachineInfo)processor.getBeanBag().getBean("machineinfo");
        }
        RestoreInfo restoreInfo = new RestoreInfo();
        ArrayList<AutoLabelItem> infos = new ArrayList<AutoLabelItem>();
        infos.add(new AutoLabelItem("message.acOutputFre[:]", "{defaultData.getAcOutputFrequency}", "Hz"));
        if (this.getProtocolID().equals("P304TO5KW")) {
            infos.add(new AutoLabelItem("message.maxCVChargingTime[:]", "{defaultData.getChargingTimeInCVStage}", "message.minitue"));
        }
        if (this.is1200or5200(machineInfo) || this.is1K3KV15_50or2_20above(machineInfo)) {
            infos.add(new AutoLabelItem("message.maxChargingVoltage[:]", "{defaultData.getMaxChargingVoltage}", "V"));
            infos.add(new AutoLabelItem("message.maxFloatingVoltage[:]", "{defaultData.getFloatChargingVoltage}", "V"));
        }
        infos.add(new AutoLabelItem("message.maxChargingCurrent[:]", "{defaultData.getMaxChargingCurrent}", "A"));
        if (this.isSupportChargingCurrentComBox(machineInfo)) {
            infos.add(new AutoLabelItem("message.maxAcChargingCurrent[:]", "{defaultData.getMaxACChargingCurrent}", "A"));
        }
        if (this.is1200or5200(machineInfo) || this.is1K3KV15_50or2_20above(machineInfo)) {
            infos.add(new AutoLabelItem("message.batteryCutoffVoltage[:]", "{defaultData.getBatteryCutoffVoltage}", "V"));
        }
        if (this.is1210or5210(machineInfo) || this.is1K3KV15_50or2_20above(machineInfo)) {
            infos.add(new AutoLabelItem("message.backToDischargeVol[:]", "{defaultData.getReDischargeVoltage}", "V"));
        }
        if (!this.is5KwV1_12orBelow(machineInfo)) {
            if (this.is1210or5210(machineInfo)) {
                infos.add(new AutoLabelItem("message.backToGridVol[:]", "{defaultData.getReChangingVoltage}", "V"));
            } else {
                infos.add(new AutoLabelItem("message.backToGridVolForSBUPriority[:]", "{defaultData.getReChangingVoltage}", "V"));
            }
        }
        if (P30.is4k5kwV11_00orabove(machineInfo) && !this.getAxpertType().startsWith("V")) {
            infos.add(new AutoLabelItem("message.outputMode[:]", "{defaultData.getOutputMode}", " "));
        }
        infos.add(new AutoLabelItem("message.acInputVoltageRange[:]", "{defaultData.getAcInputVoltage}", ""));
        infos.add(new AutoLabelItem("message.outputSourcePriority[:]", "{defaultData.getOutputSourcePriority}", ""));
        infos.add(new AutoLabelItem("message.chargerSourcePriority[:]", "{defaultData.getChargerSourcePriority}", ""));
        infos.add(new AutoLabelItem("message.batteryType[:]", "{defaultData.getBatteryType}", ""));
        infos.add(new AutoLabelItem("message.enableDisablebuzzer[:]", "{defaultData.getCapableA}", ""));
        if (processor.getProtocol().getAxpert().equals("024") || processor.getProtocol().getAxpert().equals("023")) {
            infos.add(new AutoLabelItem("message.operationLogic[:]", "{defaultData.getOperationLogic}", ""));
        }
        if (!this.getAxpertType().startsWith("VP") && !this.getAxpertType().startsWith("VM")) {
            infos.add(new AutoLabelItem("message.enableDisablePowerSaving[:]", "{defaultData.getCapableJ}", ""));
        }
        infos.add(new AutoLabelItem("message.enableDisableOverloadRestart[:]", "{defaultData.getCapableU}", ""));
        infos.add(new AutoLabelItem("message.enableDisableOverTempRestart[:]", "{defaultData.getCapableV}", ""));
        infos.add(new AutoLabelItem("message.enableDisableLcdBacklightOn[:]", "{defaultData.getCapableX}", ""));
        infos.add(new AutoLabelItem("message.enableDisableAlarmOn[:]", "{defaultData.getCapableY}", ""));
        if (this.is1200or5200(machineInfo)) {
            infos.add(new AutoLabelItem("message.enableDisableLcdComeBack[:]", "{defaultData.getCapableK}", ""));
        }
        if (!this.is5KwV1_12orBelow(machineInfo)) {
            infos.add(new AutoLabelItem("message.enableDisableOverloadBypass[:]", "{defaultData.getCapableB}", ""));
        }
        if (!this.isAxpertKing(this.getAxpert())) {
            infos.add(new AutoLabelItem("message.operationLogic[:]", "{defaultData.getOperationLogic}", ""));
        }
        restoreInfo.setInfos(infos);
        return restoreInfo;
    }

    @Override
    public RadioParameter getRadioParameter() {
        AbstractProcessor processor = GlobalProcessors.getCurrentProcessor();
        MachineInfo machineInfo = null;
        if (processor != null) {
            machineInfo = (MachineInfo)processor.getBeanBag().getBean("machineinfo");
        }
        RadioParameter radioParameter = new RadioParameter();
        ArrayList<AutoRadioItem> list = new ArrayList<AutoRadioItem>();
        list.add(new AutoRadioItem("message.pepdA[:]", "message.enable", "message.disable", "{cappbility.isCapableA}", "CapableA", false));
        if (processor != null) {
            if (!(this.outputmode != 0 || processor.getProtocol().getAxpert().equals("024") || processor.getProtocol().getAxpert().equals("023") || this.getAxpertType().startsWith("V") || this.getAxpertType().startsWith("VM") || this.getAxpertType().equals("") || this.getAxpertType().equals(" "))) {
                list.add(new AutoRadioItem("message.powerSavingMode[:]", "message.enable", "message.disable", "{cappbility.isCapableJ}", "CapableJ", false));
            }
        } else if (this.outputmode == 0 && !this.getAxpertType().startsWith("V") && !this.getAxpertType().startsWith("VM")) {
            list.add(new AutoRadioItem("message.powerSavingMode[:]", "message.enable", "message.disable", "{cappbility.isCapableJ}", "CapableJ", false));
        }
        list.add(new AutoRadioItem("message.backlight[:]", "message.enable", "message.disable", "{cappbility.isCapableX}", "CapableX", false));
        list.add(new AutoRadioItem("message.overLoadAutoRestart[:]", "message.enable", "message.disable", "{cappbility.isCapableU}", "CapableU", false));
        list.add(new AutoRadioItem("message.overTemperatureAutoRestart[:]", "message.enable", "message.disable", "{cappbility.isCapableV}", "CapableV", false));
        list.add(new AutoRadioItem("message.beepsWhileInterrupt[:]", "message.enable", "message.disable", "{cappbility.isCapableY}", "CapableY", false));
        if (!this.is5KwV1_12orBelow(machineInfo) && !this.isAxpertKing(processor.getProtocol().getAxpert())) {
            list.add(new AutoRadioItem("message.overloadBypass[:]", "message.enable", "message.disable", "{cappbility.isCapableB}", "CapableB", false));
        }
        if (this.is1200or5200(machineInfo) || this.is1K3KV15_33or1_18above(machineInfo)) {
            list.add(new AutoRadioItem("message.lcdComeBackToDefaultAfter1min[:] ", "message.enable", "message.disable", "{cappbility.isCapableK}", "CapableK", false));
        }
        if (this.is1200or5200(machineInfo)) {
            if (this.outputmode == 1) {
                list.add(new AutoRadioItem("message.mustConnectedToPV[:]", "message.enable", "message.disable", "{configData.isAllpvok}", "setPPVOKC", false));
            }
            if (!(this.getAxpertType().startsWith("VP") || this.getAxpertType().startsWith("VM") || 1000.0 <= machineInfo.getAcOutputRatingApparentPower() && machineInfo.getAcOutputRatingApparentPower() <= 3000.0 || this.getAxpertType().equals("") || this.getAxpertType().equals(" "))) {
                list.add(new AutoRadioItem("message.solarPowerBalance[:]", "message.enable", "message.disable", "{configData.isSolarbalance}", "setPSPB", false));
            }
        }
        radioParameter.setRadioParameterList(list);
        return radioParameter;
    }

    @Override
    public SpinnerParameter getSpinnerParameter() {
        SpinnerParameter spinnerParameter = new SpinnerParameter();
        ArrayList<AutoSpinnerItem> list = new ArrayList<AutoSpinnerItem>();
        MachineInfo machineInfo = null;
        AbstractProcessor processor = GlobalProcessors.getCurrentProcessor();
        if (processor != null) {
            machineInfo = (MachineInfo)processor.getBeanBag().getBean("machineinfo");
            ConfigData config = (ConfigData)processor.getBeanBag().getBean("configdata");
            double step = config.getMaxMaxChargeCurrent() - config.getMinMaxChargeCurrent();
            if (step > 10.0) {
                step = 10.0;
            }
            if (!this.isSupportChargingCurrentComBox(machineInfo)) {
                list.add(new AutoSpinnerItem("message.maxChargerCurrent[:]", "{configData.getMinMaxChargeCurrent}", "{configData.getMaxMaxChargeCurrent}", String.valueOf(step), "{configData.getMaxChargeCurrent}", "A", "MaxChargeCurrent", false));
            }
        }
        if (P30.is4k5kwV11_00orabove(machineInfo) || this.is1K3KV15_50or2_20above(machineInfo)) {
            list.add(new AutoSpinnerItem("message.maxChargingVoltage[:]", "{configData.getMinMaxChargeVoltage}", "{configData.getMaxMaxChargeVoltage}", "0.1", "{configData.getMaxChargeVoltage}", "V", "setMaxChargingVoltage", false));
            list.add(new AutoSpinnerItem("message.maxFloatingVoltage[:]", "{configData.getMinFloatingChargeVoltage}", "{configData.getMaxFloatingChargeVoltage}", "0.1", "{configData.getFloatingChargeVoltage}", "V", "setFloatingVoltage", false));
        }
        if (this.getProtocolID().equals("P304TO5KW")) {
            String firmwareVer = machineInfo.getMainFirmwareVersion();
            if ((firmwareVer = firmwareVer.substring(4)).compareToIgnoreCase("2.71") >= 0 && machineInfo.isSupportMaxCVTime()) {
                list.add(new AutoSpinnerItem("message.maxCVChargingTime[:]", "{configData.getMinChargingTimeInCVStage}", "{configData.getMaxChargingTimeInCVStage}", "5", "{configData.getChargingTimeInCVStage}", "message.minitue", "setPCVT", false));
            }
        }
        if (processor != null && (this.is1200or5200(machineInfo) || this.is1K3KV15_50or2_20above(machineInfo))) {
            list.add(new AutoSpinnerItem("message.batteryCutoffVoltage[:]", "{configData.getMinBatteryUnder}", "{configData.getMaxBatteryUnder}", "0.1", "{configData.getBatteryUnder}", "V", "setBatteryCutoffVoltage", false));
        }
        if (this.isLVLY()) {
            list.add(new AutoSpinnerItem("message.batteryCapacity[:]", "{configData.getMinBatDischargeCapacity}", "{configData.getMaxBatDischargeCapacity}", "0.1", "{configData.getBatDischargeCapacity}", "%", "setBatDischargeCapacity", false));
        }
        spinnerParameter.setSpinnerParameterList(list);
        return spinnerParameter;
    }

    @Override
    public ComboBoxParameter getComboBoxParameter() {
        AbstractProcessor processor = GlobalProcessors.getCurrentProcessor();
        MachineInfo machineInfo = null;
        ConfigData config = null;
        if (processor != null) {
            machineInfo = (MachineInfo)processor.getBeanBag().getBean("machineinfo");
            config = (ConfigData)processor.getBeanBag().getBean("configdata");
        }
        ComboBoxParameter comboBoxParameter = new ComboBoxParameter();
        ArrayList<AutoComboBoxItem> list = new ArrayList<AutoComboBoxItem>();
        if (this.is1200or5200(machineInfo)) {
            if (this.getAxpertType().startsWith("VMIII")) {
                list.add(new AutoComboBoxItem("message.chargerSourcePriority[:]", new String[]{"Solar first", "Utility and Solar", "Solar only"}, "{configData.getChargerSource}", "", "ChargerSource", false));
            } else {
                list.add(new AutoComboBoxItem("message.chargerSourcePriority[:]", new String[]{"Utility", "Solar first", "Utility and Solar", "Solar only"}, "{configData.getChargerSource}", "", "PChargerSource", false));
            }
        } else if (this.outputmode == 0) {
            if (this.getAxpertType().startsWith("VMIII")) {
                list.add(new AutoComboBoxItem("message.chargerSourcePriority[:]", new String[]{"Solar first", "Utility and Solar", "Solar only"}, "{configData.getChargerSource}", "", "ChargerSource", false));
            } else if (this.is1K3KV15_33or1_18above(machineInfo)) {
                list.add(new AutoComboBoxItem("message.chargerSourcePriority[:]", new String[]{"Utility", "Solar first", "Utility and Solar", "Solar only"}, "{configData.getChargerSource}", "", "ChargerSource", false));
            } else {
                list.add(new AutoComboBoxItem("message.chargerSourcePriority[:]", new String[]{"Utility", "Solar first", "Utility and Solar"}, "{configData.getChargerSource}", "", "ChargerSource", false));
            }
        }
        if (this.is5KwV1_12orBelow(machineInfo)) {
            list.add(new AutoComboBoxItem("message.outputSourcePriority[:]", new String[]{"Utility", "Solar"}, "{configData.getOutputSource}", "", "OutputSource", false));
        } else if (this.outputmode == 0) {
            list.add(new AutoComboBoxItem("message.outputSourcePriority[:]", new String[]{"Utility", "Solar", "SBU"}, "{configData.getOutputSource}", "", "OutputSource", false));
        } else if (this.is1200or5200(machineInfo)) {
            list.add(new AutoComboBoxItem("message.outputSourcePriority[:]", new String[]{"Utility", "Solar", "SBU"}, "{configData.getOutputSource}", "", "OutputSource", false));
        } else {
            list.add(new AutoComboBoxItem("message.outputSourcePriority[:]", new String[]{"Utility", "Solar"}, "{configData.getOutputSource}", "", "OutputSource", false));
        }
        list.add(new AutoComboBoxItem("message.acInputRange[:]", new String[]{"Appliance", "UPS"}, "{configData.getAcInputRange}", "", "ACInputRange", false));
        if (!P30.is4k5kwV11_00orabove(machineInfo)) {
            if (this.is1K3KV15_50or2_20above(machineInfo)) {
                list.add(new AutoComboBoxItem("message.batteryType[:]", new String[]{"AGM", "Flooded", "User"}, "{configData.getBatteryType}", "", "BatteryType", false));
            } else {
                list.add(new AutoComboBoxItem("message.batteryType[:]", new String[]{"AGM", "Flooded"}, "{configData.getBatteryType}", "", "BatteryType", false));
            }
        } else {
            list.add(new AutoComboBoxItem("message.batteryType[:]", new String[]{"AGM", "Flooded", "User"}, "{configData.getBatteryType}", "", "BatteryType", false));
            if (!this.getAxpertType().startsWith("V")) {
                list.add(new AutoComboBoxItem("message.outputMode[:]", new String[]{"Single", "Parallel", "Phase R of 3 phase output", "Phase S of 3 phase output", "Phase T of 3 phase output"}, "{configData.getOutputMode}", "", "OutputMode", false));
            }
        }
        list.add(new AutoComboBoxItem("message.outputFrequency[:]", new String[]{"50", "60"}, "{configData.getOutputFrequency}", "Hz", "OutputFrequency", false));
        if (GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().startsWith("VMII")) {
            list.add(new AutoComboBoxItem("message.outputVoltage[:]", new String[]{"220", "230", "240"}, "{configData.getOutputVoltage}", "V", "OutputVoltage", false));
        }
        if (processor != null && machineInfo != null && config != null) {
            if (!this.is5KwV1_12orBelow(machineInfo)) {
                if (this.is1210or5210(machineInfo)) {
                    if (config.getBatteryVoltage() > 40.0) {
                        list.add(new AutoComboBoxItem("message.backToGridVol[:]", new String[]{"44.0", "45.0", "46.0", "47.0", "48.0", "49.0", "50.0", "51.0"}, "{configData.getRechargeVoltage}", "V", "ReChargeVoltage", false));
                    } else if (config.getBatteryVoltage() > 20.0) {
                        list.add(new AutoComboBoxItem("message.backToGridVol[:]", new String[]{"22.0", "22.5", "23.0", "23.5", "24.0", "24.5", "25.0", "25.5"}, "{configData.getRechargeVoltage}", "V", "ReChargeVoltage", false));
                    } else {
                        list.add(new AutoComboBoxItem("message.backToGridVol[:]", new String[]{"11.0", "11.3", "11.5", "11.8", "12.0", "12.3", "12.5", "12.8"}, "{configData.getRechargeVoltage}", "V", "ReChargeVoltage", false));
                    }
                } else if (config.getBatteryVoltage() > 40.0) {
                    list.add(new AutoComboBoxItem("message.backToGridVolForSBUPriority[:]", new String[]{"44.0", "45.0", "46.0", "47.0", "48.0", "49.0", "50.0", "51.0"}, "{configData.getRechargeVoltage}", "V", "ReChargeVoltage", false));
                } else if (config.getBatteryVoltage() > 20.0) {
                    list.add(new AutoComboBoxItem("message.backToGridVolForSBUPriority[:]", new String[]{"22.0", "22.5", "23.0", "23.5", "24.0", "24.5", "25.0", "25.5"}, "{configData.getRechargeVoltage}", "V", "ReChargeVoltage", false));
                } else {
                    list.add(new AutoComboBoxItem("message.backToGridVolForSBUPriority[:]", new String[]{"11.0", "11.3", "11.5", "11.8", "12.0", "12.3", "12.5", "12.8"}, "{configData.getRechargeVoltage}", "V", "ReChargeVoltage", false));
                }
            }
            if (this.isSupportChargingCurrentComBox(machineInfo)) {
                if (this.is1227or5227(machineInfo)) {
                    list.add(new AutoComboBoxItem("message.maxChargingCurrent[:]", config.getMaxChargeCurrentCombox(machineInfo, this.outputmode), "{configData.getMaxChargeCurrentInt}", "A", "NPMaxChargeCurrent", false));
                } else {
                    list.add(new AutoComboBoxItem("message.maxChargingCurrent[:]", config.getMaxChargeCurrentCombox(machineInfo, this.outputmode), "{configData.getMaxChargeCurrentInt}", "A", "PMaxChargeCurrent", false));
                }
                list.add(new AutoComboBoxItem("message.maxAcChargingCurrent[:]", config.getAcChargingCurrentComBox(), "{configData.getMaxacchargingcurrentInt}", "A", "PMaxACChargeCurrent", false));
            }
            if (this.is1210or5210(machineInfo)) {
                if (config.getBatteryVoltage() > 40.0) {
                    list.add(new AutoComboBoxItem("message.backToDischargeVol[:]", new String[]{"48.0", "49.0", "50.0", "51.0", "52.0", "53.0", "54.0", "55.0", "56.0", "57.0", "58.0", "FULL"}, "{configData.getReDischargeVoltage}", "V", "ReDisChargeVoltage", false));
                } else if (config.getBatteryVoltage() > 20.0) {
                    list.add(new AutoComboBoxItem("message.backToDischargeVol[:]", new String[]{"24.0", "24.5", "25.0", "25.5", "26.0", "26.5", "27.0", "27.5", "28.0", "28.5", "29.0", "FULL"}, "{configData.getReDischargeVoltage}", "V", "ReDisChargeVoltage", false));
                } else {
                    list.add(new AutoComboBoxItem("message.backToDischargeVol[:]", new String[]{"12.0", "12.3", "12.5", "12.8", "13.0", "13.3", "13.5", "13.8", "14.0", "14.3", "14.5", "FULL"}, "{configData.getReDischargeVoltage}", "V", "ReDisChargeVoltage", false));
                }
            }
        }
        comboBoxParameter.setComboBoxParameterList(list);
        return comboBoxParameter;
    }

    protected boolean is5KwV1_12orBelow(MachineInfo machineInfo) {
        return machineInfo == null || machineInfo.getAcOutputRatingApparentPower() == 5000.0 && machineInfo.getMainFirmwareVersion().compareToIgnoreCase("00001.13") < 0;
    }

    public static synchronized boolean is4k5kwV11_00orabove(MachineInfo machineInfo) {
        if (machineInfo == null) {
            return false;
        }
        return (machineInfo.getAcOutputRatingApparentPower() == 4000.0 || machineInfo.getAcOutputRatingApparentPower() == 5000.0) && (machineInfo.getMainFirmwareVersion().compareToIgnoreCase("00011.00") >= 0 && machineInfo.getMainFirmwareVersion().compareToIgnoreCase("00050.00") < 0 || machineInfo.getMainFirmwareVersion().compareToIgnoreCase("00051.00") >= 0);
    }

    public static synchronized boolean is4to5k(double acOutputRatingApparentPower) {
        return acOutputRatingApparentPower >= 4000.0 && acOutputRatingApparentPower <= 5000.0;
    }

    public static synchronized boolean is1to3k(double acOutputRatingApparentPower) {
        return acOutputRatingApparentPower >= 1000.0 && acOutputRatingApparentPower <= 3000.0;
    }

    public static synchronized boolean isKing3kAnd5k(double acOutputRatingApparentPower) {
        return acOutputRatingApparentPower == 3000.0 || acOutputRatingApparentPower == 5000.0 || acOutputRatingApparentPower == 5200.0;
    }

    protected boolean is1K3KV15_33or1_18above(MachineInfo machineInfo) {
        if (machineInfo == null) {
            return false;
        }
        if (machineInfo.getAcOutputRatingApparentPower() >= 1000.0 && machineInfo.getAcOutputRatingApparentPower() <= 3000.0) {
            if (machineInfo.getMainFirmwareVersion().compareToIgnoreCase("00015.33") >= 0) {
                return true;
            }
            if (machineInfo.getMainFirmwareVersion().compareToIgnoreCase("00001.18") >= 0 && machineInfo.getMainFirmwareVersion().compareToIgnoreCase("00010.00") < 0) {
                return true;
            }
        }
        return false;
    }

    protected boolean is1K3KV15_50or2_20above(MachineInfo machineInfo) {
        if (machineInfo == null) {
            return false;
        }
        if (machineInfo.getAcOutputRatingApparentPower() >= 1000.0 && machineInfo.getAcOutputRatingApparentPower() <= 3000.0) {
            if (machineInfo.getMainFirmwareVersion().compareToIgnoreCase("00015.50") >= 0) {
                return true;
            }
            if (machineInfo.getMainFirmwareVersion().compareToIgnoreCase("00002.20") >= 0 && machineInfo.getMainFirmwareVersion().compareToIgnoreCase("00010.00") < 0) {
                return true;
            }
        }
        return false;
    }

    protected boolean is1200or5200(MachineInfo machineInfo) {
        if (machineInfo == null) {
            return false;
        }
        return (machineInfo.getAcOutputRatingApparentPower() == 4000.0 || machineInfo.getAcOutputRatingApparentPower() == 5000.0) && (machineInfo.getMainFirmwareVersion().compareToIgnoreCase("00052.00") >= 0 || machineInfo.getMainFirmwareVersion().compareToIgnoreCase("00050.00") < 0 && machineInfo.getMainFirmwareVersion().compareToIgnoreCase("00012.00") >= 0);
    }

    protected boolean is1210or5210(MachineInfo machineInfo) {
        if (machineInfo == null) {
            return false;
        }
        if ((machineInfo.getAcOutputRatingApparentPower() == 4000.0 || machineInfo.getAcOutputRatingApparentPower() == 5000.0) && (machineInfo.getMainFirmwareVersion().compareToIgnoreCase("00052.10") >= 0 || machineInfo.getMainFirmwareVersion().compareToIgnoreCase("00050.00") < 0 && machineInfo.getMainFirmwareVersion().compareToIgnoreCase("00012.10") >= 0)) {
            return true;
        }
        if (machineInfo.getAcOutputRatingApparentPower() >= 1000.0 && machineInfo.getAcOutputRatingApparentPower() <= 3000.0) {
            if (machineInfo.getMainFirmwareVersion().compareToIgnoreCase("00015.50") >= 0) {
                return true;
            }
            if (machineInfo.getMainFirmwareVersion().compareToIgnoreCase("00002.20") >= 0 && machineInfo.getMainFirmwareVersion().compareToIgnoreCase("00010.00") < 0) {
                return true;
            }
        }
        return false;
    }

    protected boolean is1227or5227(MachineInfo machineInfo) {
        if (machineInfo == null) {
            return false;
        }
        return (machineInfo.getAcOutputRatingApparentPower() == 4000.0 || machineInfo.getAcOutputRatingApparentPower() == 5000.0) && (machineInfo.getMainFirmwareVersion().compareToIgnoreCase("00052.27") >= 0 || machineInfo.getMainFirmwareVersion().compareToIgnoreCase("00050.00") < 0 && machineInfo.getMainFirmwareVersion().compareToIgnoreCase("00012.27") >= 0);
    }

    protected boolean isSupportChargingCurrentComBox(MachineInfo machineInfo) {
        if (machineInfo == null) {
            return false;
        }
        if (this.getAxpertType().equals("VMII-3000") || this.getAxpertType().equals("VMII-5000") || this.getAxpertType().equals("VMII-1500") || this.getAxpertType().equals("VMIII-1500") || this.getAxpertType().equals("VMIII-3000") || this.getAxpertType().equals("VMIII-3200") || this.getAxpertType().equals("VMIII-5000") || this.getAxpertType().equals("VMIII-5200")) {
            return true;
        }
        return machineInfo.isChargeCurrentComBox();
    }

    @Override
    public HistoryDataColumns getHistoryColumns() {
        HistoryDataColumns columns = new HistoryDataColumns();
        ArrayList<HistoryData> list = new ArrayList<HistoryData>();
        list.add(new HistoryData("message.workMode", "{workInfo.getWorkMode}", true, false));
        list.add(new HistoryData("message.time", "{workInfo.getCurrentTime}", true, false));
        list.add(new HistoryData("message.acVoltage", "{workInfo.getGridVoltageR}", true, false));
        list.add(new HistoryData("message.acFrequency", "{workInfo.getGridFrequency}", true, false));
        list.add(new HistoryData("message.pvInputVoltage", "{workInfo.getPvInputVoltage1}", true, true));
        list.add(new HistoryData("message.pvInputPower", "{workInfo.getPvInputPower1}", true, true));
        list.add(new HistoryData("message.outputapppower", "{workInfo.getAcOutputApparentPower}", true, true));
        list.add(new HistoryData("message.outputactpower", "{workInfo.getAcOutputActivePower}", true, true));
        list.add(new HistoryData("message.batteryVoltage", "{workInfo.getPBatteryVoltage}", true, true));
        list.add(new HistoryData("message.batteryCapacity", "{workInfo.getBatteryCapacity}", true, true));
        if (GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VM-1000") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VM-1200") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VM-2000") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VM-2200") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VM-3200") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VM-3000") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VP-1000") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VP-2000") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VP-3000")) {
            list.add(new HistoryData("message.pvInputCurrent", "{workInfo.getChargingCurrent}", true, true));
        } else {
            list.add(new HistoryData("message.chargeCurrent", "{workInfo.getChargingCurrent}", true, true));
        }
        list.add(new HistoryData("message.batdiscurrent", "{workInfo.getBatDisCurrent}", true, true));
        list.add(new HistoryData("message.outputVoltage", "{workInfo.getAcOutputVoltageR}", true, true));
        list.add(new HistoryData("message.outputFrequency", "{workInfo.getAcOutputFrequency}", true, true));
        if (this.outputmode == 1) {
            list.add(new HistoryData("message.totalchargingcurrent", "{workInfo.getTtlChargingCurrent}", true, true));
            list.add(new HistoryData("message.totaloutputapparentpower", "{workInfo.getAcTtlOutputApparentPower}", true, true));
            list.add(new HistoryData("message.totaloutputactivepower", "{workInfo.getAcTtlOutputActivePower}", true, true));
            list.add(new HistoryData("message.totaloutputpercent", "{workInfo.getAcTtlOutputPercent}", true, true));
        }
        columns.setColumns(list);
        return columns;
    }

    @Override
    public HistoryDataChartColumns getHistoryChartColumns() {
        HistoryDataChartColumns columns = new HistoryDataChartColumns();
        ArrayList<HistoryChart> list = new ArrayList<HistoryChart>();
        list.add(new HistoryChart("message.acVoltage", "{workInfo.getGridVoltageR}", 300.0, "V", true));
        list.add(new HistoryChart("message.acFrequency", "{workInfo.getGridFrequency}", 70.0, "Hz", true));
        list.add(new HistoryChart("message.pvInputVoltage", "{workInfo.getPvInputVoltage1}", 200.0, "V", true));
        list.add(new HistoryChart("message.pvInputPower", "{workInfo.getPvInputPower1}", 3000.0, "V", true));
        list.add(new HistoryChart("message.outputapppower", "{workInfo.getAcOutputApparentPower}", 3000.0, "VA", true));
        list.add(new HistoryChart("message.outputactpower", "{workInfo.getAcOutputActivePower}", 3000.0, "W", true));
        list.add(new HistoryChart("message.batteryVoltage", "{workInfo.getPBatteryVoltage}", 100.0, "V", true));
        list.add(new HistoryChart("message.batteryCapacity", "{workInfo.getBatteryCapacity}", 100.0, "%", true));
        if (GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VM-1000") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VM-1200") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VM-2000") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VM-2200") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VM-3200") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VM-3000") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VP-1000") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VP-2000") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VP-3000")) {
            list.add(new HistoryChart("message.pvInputCurrent", "{workInfo.getChargingCurrent}", 250.0, "A", true));
        } else {
            list.add(new HistoryChart("message.chargeCurrent", "{workInfo.getChargingCurrent}", 250.0, "A", true));
        }
        list.add(new HistoryChart("message.batdiscurrent", "{workInfo.getBatDisCurrent}", 150.0, "A", true));
        list.add(new HistoryChart("message.outputVoltage", "{workInfo.getAcOutputVoltageR}", 300.0, "V", true));
        list.add(new HistoryChart("message.outputFrequency", "{workInfo.getAcOutputFrequency}", 70.0, "Hz", true));
        if (this.outputmode == 1) {
            list.add(new HistoryChart("message.totalchargingcurrent", "{workInfo.getTtlChargingCurrent}", 100.0, "A", true));
            list.add(new HistoryChart("message.totaloutputapparentpower", "{workInfo.getAcTtlOutputApparentPower}", 20000.0, "VA", true));
            list.add(new HistoryChart("message.totaloutputactivepower", "{workInfo.getAcTtlOutputActivePower}", 20000.0, "W", true));
            list.add(new HistoryChart("message.totaloutputpercent", "{workInfo.getAcTtlOutputPercent}", 100.0, "%", true));
        }
        columns.setColumns(list);
        return columns;
    }

    @Override
    public HistoryFaultDataColumns getHistoryFaultColumns() {
        HistoryFaultDataColumns columns = new HistoryFaultDataColumns();
        ArrayList<HistoryData> list = new ArrayList<HistoryData>();
        list.add(new HistoryData("message.trandate", "{faultData.getTrandate}", true, true));
        list.add(new HistoryData("message.faultString", "{faultData.getFaultString}", true, true));
        list.add(new HistoryData("message.workMode", "{faultData.getWorkMode}", true, true));
        list.add(new HistoryData("message.acVoltage", "{faultData.getGridVoltageR}", true, false));
        list.add(new HistoryData("message.acFrequency", "{faultData.getGridFrequency}", true, false));
        list.add(new HistoryData("message.pvInputVoltage", "{faultData.getPvInputVoltage1}", true, true));
        list.add(new HistoryData("message.outputapppower", "{faultData.getAcOutputApparentPower}", true, true));
        list.add(new HistoryData("message.outputactpower", "{faultData.getAcOutputActivePower}", true, true));
        list.add(new HistoryData("message.batteryVoltage", "{faultData.getPBatteryVoltage}", true, true));
        list.add(new HistoryData("message.batteryCapacity", "{faultData.getBatteryCapacity}", true, true));
        if (GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VM-1000") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VM-1200") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VM-2000") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VM-2200") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VM-3200") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VM-3000") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VP-1000") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VP-2000") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VP-3000")) {
            list.add(new HistoryData("message.pvInputCurrent", "{faultData.getChargingCurrent}", true, true));
        } else {
            list.add(new HistoryData("message.chargeCurrent", "{faultData.getChargingCurrent}", true, true));
        }
        list.add(new HistoryData("message.batdiscurrent", "{faultData.getBatDisCurrent}", true, true));
        list.add(new HistoryData("message.outputVoltage", "{faultData.getAcOutputVoltageR}", true, true));
        list.add(new HistoryData("message.outputFrequency", "{faultData.getAcOutputFrequency}", true, true));
        if (this.outputmode == 1) {
            list.add(new HistoryData("message.totalchargingcurrent", "{faultData.getTtlChargingCurrent}", true, true));
            list.add(new HistoryData("message.totaloutputapparentpower", "{faultData.getAcTtlOutputApparentPower}", true, true));
            list.add(new HistoryData("message.totaloutputactivepower", "{faultData.getAcTtlOutputActivePower}", true, true));
            list.add(new HistoryData("message.totaloutputpercent", "{faultData.getAcTtlOutputPercent}", true, true));
        }
        columns.setColumns(list);
        return columns;
    }

    @Override
    public String getSerialNo() {
        return this.serialNo;
    }

    @Override
    public AutoMenuList getMenuList() {
        AbstractProcessor processor = GlobalProcessors.getCurrentProcessor();
        MachineInfo machineInfo = null;
        if (processor != null) {
            machineInfo = (MachineInfo)processor.getBeanBag().getBean("machineinfo");
        }
        AutoMenuList menuList = new AutoMenuList();
        ArrayList<AutoMenuOne> menus = new ArrayList<AutoMenuOne>();
        ArrayList<AutoMenuTwo> items1 = new ArrayList<AutoMenuTwo>();
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.baseSet", 101, ""), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.passwordSet", 102, ""), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.smsinfoSet", 104, ""), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.emailSet", 105, ""), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.electricEventSet", 106, ""), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.setcom", 107, ""), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.modbussetting", 108, ""), null));
        ArrayList<AutoMenuTwo> items2 = new ArrayList<AutoMenuTwo>();
        items2.add(new AutoMenuTwo(new AutoMenuItem("message.parametersSetting", 201, ""), null));
        items2.add(new AutoMenuTwo(new AutoMenuItem("message.factoryReset", 202, ""), null));
        ArrayList<AutoMenuTwo> items3 = new ArrayList<AutoMenuTwo>();
        items3.add(new AutoMenuTwo(new AutoMenuItem("message.queryData", 302, ""), null));
        items3.add(new AutoMenuTwo(new AutoMenuItem("message.queryEvent", 304, ""), null));
        if (this.is1227or5227(machineInfo) || this.getAxpert().startsWith("023") || this.getAxpert().startsWith("024")) {
            items3.add(new AutoMenuTwo(new AutoMenuItem("message.queryFaultData", 303, ""), null));
        }
        ArrayList<AutoMenuTwo> items4 = new ArrayList<AutoMenuTwo>();
        items4.add(new AutoMenuTwo(new AutoMenuItem("English", 401, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("French", 402, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("German", 403, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Polish", 405, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Spanish", 408, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Chinese(Simplified)", 411, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Chinese(Traditional)", 412, "radio"), null));
        ArrayList<AutoMenuTwo> items5 = new ArrayList<AutoMenuTwo>();
        items5.add(new AutoMenuTwo(new AutoMenuItem("message.about", 501, ""), null));
        ArrayList<AutoMenuItem> items = new ArrayList<AutoMenuItem>();
        CustomerConfig custormerConfig = GlobalVariables.customerConfig;
        if (custormerConfig.isEnglish()) {
            items.add(new AutoMenuItem("English", 5021, ""));
        }
        if (custormerConfig.isTurkish()) {
            items.add(new AutoMenuItem("Turkish", 5022, ""));
        }
        if (custormerConfig.isRussian()) {
            items.add(new AutoMenuItem("Russian", 5023, ""));
        }
        if (items.size() < 2) {
            items = null;
        }
        items5.add(new AutoMenuTwo(new AutoMenuItem("message.onlineHelp", 502, ""), items));
        menus.add(new AutoMenuOne("[" + GlobalVariables.customerConfig.getCustomerName() + "]" + "message.pvConfig", 1, items1));
        menus.add(new AutoMenuOne("message.pvControl", 2, items2));
        menus.add(new AutoMenuOne("message.pvView", 3, items3));
        menus.add(new AutoMenuOne("message.language", 4, items4));
        menus.add(new AutoMenuOne("message.help", 5, items5));
        menuList.setMenuList(menus);
        return menuList;
    }

    @Override
    public boolean getDelayChanging() {
        return this.delaychanging;
    }

    @Override
    public void setDelayChanging(boolean delaychange) {
        this.delaychanging = delaychange;
    }

    @Override
    public int getOutputMode() {
        return this.outputmode;
    }

    @Override
    public void setOutputMode(int outputmode) {
        this.outputmode = outputmode;
    }

    @Override
    public int getMpptTrackNumber() {
        return 1;
    }

    @Override
    public String getMachineType() {
        return this.machineType;
    }

    public boolean isNotEmpty(String str) {
        return !this.isEmpty(str);
    }

    public boolean isNotEmpty(String str, String cmd) {
        return !this.isEmpty(str, cmd);
    }

    public boolean isEmpty(String str) {
        return str == null || "".equals(str) || str.equals("(NAK");
    }

    public boolean isEmpty(String str, String cmd) {
        return str == null || "".equals(str) || str.equals("(NAK") || str.indexOf(cmd) >= 0;
    }

    public static boolean isALFAM(MachineInfo machineInfo) {
        if (machineInfo == null) {
            return false;
        }
        if (!P30.is1to3k(machineInfo.getAcOutputRatingApparentPower())) {
            return false;
        }
        return machineInfo.getMainFirmwareVersion().compareToIgnoreCase("00007.00") >= 0 && machineInfo.getMainFirmwareVersion().compareToIgnoreCase("00008.99") <= 0;
    }

    @Override
    public String getAxpertType() {
        return this.axpertType;
    }

    @Override
    public String getAxpert() {
        return this.axpert;
    }

    public boolean isCommonLogic(String qmn) {
        if (this.isEmpty(qmn) || qmn.equals("QMN")) {
            return true;
        }
        this.axpertType = qmn;
        if (qmn.startsWith("(")) {
            this.axpertType = qmn.substring(1);
        }
        if (this.axpertType.startsWith("VP")) {
            return false;
        }
        if (this.axpertType.startsWith("VM")) {
            return false;
        }
        return !this.axpertType.endsWith("LV-LY");
    }

    @Override
    public RadioParameter getEqRadioParameter() {
        return null;
    }

    @Override
    public SpinnerParameter getEqSpinnerParameter() {
        return null;
    }

    @Override
    public boolean isLVLY() {
        if (this.isEmpty(this.axpertType)) {
            return false;
        }
        return this.axpertType.endsWith("LV-LY");
    }

    public boolean isStandardModel(String str) {
        if (this.isNotEmpty(str, "QGMN")) {
            if (str.startsWith("(")) {
                str = str.substring(1);
            }
            this.axpert = str;
            return str.equals("000");
        }
        return true;
    }

    public boolean isEPSM5K(String str) {
        if (this.isNotEmpty(str, "QGMN")) {
            if (str.startsWith("(")) {
                str = str.substring(1);
            }
            this.axpert = str;
            if (str.equals("020")) {
                return true;
            }
        }
        return false;
    }

    public boolean isMKSII5KW(String str) {
        if (this.isNotEmpty(str, "QGMN")) {
            if (str.startsWith("(")) {
                str = str.substring(1);
            }
            this.axpert = str;
            if (str.equals("022")) {
                return true;
            }
        }
        return false;
    }

    public boolean isPlus_PF1(String str) {
        if (this.isNotEmpty(str, "QGMN")) {
            if (str.startsWith("(")) {
                str = str.substring(1);
            }
            this.axpert = str;
            if (str.equals("018")) {
                return true;
            }
        }
        return false;
    }

    public boolean isStandardModelPF1(String str) {
        if (this.isNotEmpty(str, "QGMN")) {
            if (str.startsWith("(")) {
                str = str.substring(1);
            }
            this.axpert = str;
            if (str.equals("014") || str.equals("015") || str.equals("016") || str.equals("017")) {
                return true;
            }
        }
        return false;
    }

    public boolean isAxpertKing(String str) {
        if (this.isNotEmpty(str, "QGMN")) {
            if (str.startsWith("(")) {
                str = str.substring(1);
            }
            this.axpert = str;
            if (str.equals("023") || str.equals("024")) {
                return true;
            }
        }
        return false;
    }

    public boolean isAxpertV(String str) {
        if (this.isNotEmpty(str, "QGMN") || this.isNotEmpty(str, "QMN")) {
            this.axpert = str = str.substring(1);
            if (str.equals("001") || str.equals("002") || str.equals("003") || str.equals("004")) {
                return true;
            }
            return str.equals("VM-1000") || str.equals("VM-1200") || str.equals("VM-2000") || str.equals("VM-2200") || str.equals("VM-3200");
        }
        return true;
    }

    public boolean isAxpertLY(String str) {
        if (this.isNotEmpty(str, "QGMN")) {
            this.axpert = str = str.substring(1);
            return str.equals("005");
        }
        return true;
    }

    public boolean isParal(String str) {
        if (this.isNotEmpty(str, "QGMN")) {
            if (str.startsWith("(")) {
                str = str.substring(1);
            }
            this.axpert = str;
            return str.equals("006") || str.equals("007") || str.equals("008") || str.equals("009") || str.equals("010") || str.equals("011") || str.equals("012") || str.equals("013");
        }
        return true;
    }

    @Override
    public void setMachineType(String machineType) {
        this.machineType = machineType;
    }

    @Override
    public boolean isVMII() {
        if (this.getAxpertType().equals("VMII-3000")) {
            return true;
        }
        return this.getAxpertType().equals("VMII-5000") || this.getAxpertType().equals("VMII-1500") || this.getAxpertType().equals("VMIII-1500") || this.getAxpertType().equals("VMIII-3000") || this.getAxpertType().equals("VMIII-3200") || this.getAxpertType().equals("VMIII-5000") || this.getAxpertType().equals("VMIII-5200");
    }
}

