/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.protocol;

import cn.com.voltronic.solar.communicate.IComUSBHandler;
import cn.com.voltronic.solar.communicate.ModbusHandler;
import cn.com.voltronic.solar.communicate.SNMPHandler;
import cn.com.voltronic.solar.configure.CustomerConfig;
import cn.com.voltronic.solar.data.bean.AutoLabelItem;
import cn.com.voltronic.solar.data.bean.AutoMenuItem;
import cn.com.voltronic.solar.data.bean.AutoMenuList;
import cn.com.voltronic.solar.data.bean.AutoMenuOne;
import cn.com.voltronic.solar.data.bean.AutoMenuTwo;
import cn.com.voltronic.solar.data.bean.AutoRadioItem;
import cn.com.voltronic.solar.data.bean.AutoSpinnerItem;
import cn.com.voltronic.solar.data.bean.BaseInfo;
import cn.com.voltronic.solar.data.bean.HistoryChart;
import cn.com.voltronic.solar.data.bean.HistoryData;
import cn.com.voltronic.solar.data.bean.HistoryDataChartColumns;
import cn.com.voltronic.solar.data.bean.HistoryDataColumns;
import cn.com.voltronic.solar.data.bean.MachineInfo;
import cn.com.voltronic.solar.data.bean.RadioParameter;
import cn.com.voltronic.solar.data.bean.SpinnerParameter;
import cn.com.voltronic.solar.data.bean.WorkInfo;
import cn.com.voltronic.solar.modbusprocessor.AbstractModbusProcessor;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.protocol.P30;
import cn.com.voltronic.solar.system.GlobalProcessors;
import cn.com.voltronic.solar.system.GlobalVariables;
import cn.com.voltronic.solar.util.VolUtil;
import java.util.ArrayList;
import net.wimpi.modbus.procimg.Register;

public class P301TO3KW
extends P30 {
    @Override
    public String getProtocolID() {
        return "P301TO3KW";
    }

    @Override
    public boolean matchProtocol(Object handler) {
        if (handler instanceof IComUSBHandler) {
            return this.matchComUSB((IComUSBHandler)handler);
        }
        if (handler instanceof ModbusHandler) {
            try {
                return this.matchModbus((ModbusHandler)handler);
            }
            catch (Exception e) {
                return false;
            }
        }
        if (handler instanceof SNMPHandler) {
            return this.matchSnmp((SNMPHandler)handler);
        }
        return false;
    }

    @Override
    public boolean matchComUSB(IComUSBHandler _handler) {
        String dataStr = "(NAK";
        int i = 0;
        while (i < 2) {
            if (!this.isEmpty(dataStr)) break;
            try {
                dataStr = _handler.excuteSimpleCommand("QPI");
            }
            catch (Exception e) {
                return false;
            }
            ++i;
        }
        if (dataStr.startsWith("(PI") && dataStr.endsWith("30") && this instanceof P301TO3KW) {
            String serialNoStr;
            String[] ratingInfo;
            block22: {
                block21: {
                    block20: {
                        block19: {
                            String qpiri;
                            block18: {
                                block17: {
                                    try {
                                        String qgmn = _handler.excuteSimpleCommand("QGMN");
                                        if (this.isStandardModel(qgmn)) break block17;
                                        return false;
                                    }
                                    catch (Exception ex) {
                                        return false;
                                    }
                                }
                                qpiri = _handler.excuteSimpleCommand("QPIRI");
                                if (!this.isEmpty(qpiri)) break block18;
                                return false;
                            }
                            ratingInfo = qpiri.split(" ");
                            this.machineType = ratingInfo[19];
                            if (this.machineType.equals("00") || this.machineType.equals("01") || this.machineType.equals("10")) break block19;
                            return false;
                        }
                        double acOutputRatingApparentPower = VolUtil.parseDouble(ratingInfo[5]);
                        if (P301TO3KW.is1to3k(acOutputRatingApparentPower)) break block20;
                        return false;
                    }
                    String qmn = _handler.excuteCommand("QMN", true);
                    if (this.isCommonLogic(qmn)) break block21;
                    return false;
                }
                serialNoStr = _handler.getSerialNo();
                if (!this.isEmpty(serialNoStr)) break block22;
                return false;
            }
            this.serialNo = serialNoStr;
            if (ratingInfo[15].equals("2") || ratingInfo[15].equals("3")) {
                this.outputmode = 1;
            } else if (ratingInfo.length > 21) {
                try {
                    this.outputmode = VolUtil.parseInt(ratingInfo[21]);
                }
                catch (Exception exception) {}
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean matchModbus(ModbusHandler modbus) throws Exception {
        Register[] outputRatedVA;
        int acOutputRatingApparentPower;
        boolean result = false;
        Register[] regs = modbus.readMultipleRegisters(992, 1);
        if (regs != null && regs.length == 1) {
            String pid = new String(regs[0].toBytes());
            if ((pid = "P" + pid).equals("P30")) {
                result = true;
            }
        }
        if (!result) {
            return false;
        }
        this.serialNo = modbus.getSerialNo();
        if ("".equals(this.serialNo)) {
            result = false;
        }
        if (!P301TO3KW.is1to3k(acOutputRatingApparentPower = (int)AbstractModbusProcessor.convert2Regiters((outputRatedVA = modbus.readMultipleRegisters(1017, 2))[0], outputRatedVA[1]))) {
            return false;
        }
        Register[] qryMachineType = modbus.readMultipleRegisters(1178, 1);
        this.machineType = new String(qryMachineType[0].toBytes()).trim();
        if (!(this.machineType.equals("00") || this.machineType.equals("01") || this.machineType.equals("10"))) {
            return false;
        }
        regs = modbus.readMultipleRegisters(1481, 1);
        this.outputmode = regs[0].getValue();
        return result;
    }

    @Override
    public boolean matchSnmp(SNMPHandler snmp) {
        String qpi = snmp.get(".1.3.6.1.4.1.21111.1.2.1.2");
        String pid = new String(qpi);
        if (!(pid = "P" + pid).equals("P30")) {
            return false;
        }
        int qgmnInt = snmp.getInt("1.3.6.1.4.1.21111.1.2.1.13");
        String qgmn = String.format("%03d", qgmnInt);
        if (!this.isStandardModel(qgmn)) {
            return false;
        }
        this.serialNo = snmp.getSerialNo();
        if ("".equals(this.serialNo)) {
            return false;
        }
        double acOutputRatingApparentPower = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.2.2"));
        if (!P301TO3KW.is1to3k(acOutputRatingApparentPower)) {
            return false;
        }
        this.machineType = snmp.get(".1.3.6.1.4.1.21111.1.2.1.7");
        if (!(this.machineType.equals("0") || this.machineType.equals("1") || this.machineType.equals("10"))) {
            return false;
        }
        this.outputmode = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.11.9"));
        return true;
    }

    @Override
    public BaseInfo getBaseInfo() {
        int isPVCharging = 1;
        int isShowChargingCurrent = 1;
        AbstractProcessor processor = GlobalProcessors.getCurrentProcessor();
        WorkInfo workInfo = null;
        if (processor != null) {
            workInfo = (WorkInfo)processor.getBeanBag().getBean("workinfo");
            isPVCharging = workInfo.getIsPVCharging();
            isShowChargingCurrent = workInfo.getIsShowChargingCurrent();
        }
        BaseInfo baseInfo = new BaseInfo();
        ArrayList<AutoLabelItem> item = new ArrayList<AutoLabelItem>();
        item.add(new AutoLabelItem("message.acVoltage[:]", "{workInfo.getGridVoltageR}", "V"));
        item.add(new AutoLabelItem("message.acFrequency[:]", "{workInfo.getGridFrequency}", "Hz"));
        if (isPVCharging == 1) {
            item.add(new AutoLabelItem("message.pvInputVoltage[:]", "{workInfo.getPvInputVoltage1}", "V"));
            item.add(new AutoLabelItem("message.pvInputPower[:]", "{workInfo.getPvInputPower1}", "W"));
        }
        item.add(new AutoLabelItem("message.batteryVoltage[:]", "{workInfo.getPBatteryVoltage}", "V"));
        item.add(new AutoLabelItem("message.batteryCapacity[:]", "{workInfo.getBatteryCapacity}", "%"));
        if (isShowChargingCurrent == 1) {
            if (this.getAxpertType().equals("VM-1000") || this.getAxpertType().equals("VM-1200") || this.getAxpertType().equals("VM-2000") || this.getAxpertType().equals("VM-2200") || this.getAxpertType().equals("VM-3200") || this.getAxpertType().equals("VM-3000") || this.getAxpertType().equals("VP-1000") || this.getAxpertType().equals("VP-2000") || this.getAxpertType().equals("VP-3000")) {
                item.add(new AutoLabelItem("message.pvInputCurrent[:]", "{workInfo.getChargingCurrent}", "A"));
            } else {
                item.add(new AutoLabelItem("message.chargeCurrent[:]", "{workInfo.getChargingCurrent}", "A"));
            }
        }
        item.add(new AutoLabelItem("message.batdiscurrent[:]", "{workInfo.getBatDisCurrent}", "A"));
        item.add(new AutoLabelItem("message.outputVoltage[:]", "{workInfo.getAcOutputVoltageR}", "V"));
        item.add(new AutoLabelItem("message.outputFrequency[:]", "{workInfo.getAcOutputFrequency}", "Hz"));
        item.add(new AutoLabelItem("message.outputapppower[:]", "{workInfo.getAcOutputApparentPower}", "VA"));
        item.add(new AutoLabelItem("message.outputactpower[:]", "{workInfo.getAcOutputActivePower}", "W"));
        item.add(new AutoLabelItem("message.loadpercent[:]", "{workInfo.getOutputLoadPercent}", "%"));
        baseInfo.setBaseInfoList(item);
        return baseInfo;
    }

    @Override
    public HistoryDataColumns getHistoryColumns() {
        HistoryDataColumns columns = new HistoryDataColumns();
        ArrayList<HistoryData> list = new ArrayList<HistoryData>();
        list.add(new HistoryData("message.workMode", "{workInfo.getWorkMode}", true, false));
        list.add(new HistoryData("message.time", "{workInfo.getCurrentTime}", true, false));
        list.add(new HistoryData("message.acVoltage", "{workInfo.getGridVoltageR}", true, false));
        list.add(new HistoryData("message.acFrequency", "{workInfo.getGridFrequency}", true, false));
        list.add(new HistoryData("message.pvInputVoltage", "{workInfo.getPvInputVoltage1}", true, true));
        list.add(new HistoryData("message.pvInputCurrent", "{workInfo.getPvInputCurrentForBatttery}", true, true));
        list.add(new HistoryData("message.pvInputPower", "{workInfo.getPvInputPower1}", true, true));
        list.add(new HistoryData("message.outputapppower", "{workInfo.getAcOutputApparentPower}", true, true));
        list.add(new HistoryData("message.outputactpower", "{workInfo.getAcOutputActivePower}", true, true));
        list.add(new HistoryData("message.batteryVoltage", "{workInfo.getPBatteryVoltage}", true, true));
        list.add(new HistoryData("message.batteryCapacity", "{workInfo.getBatteryCapacity}", true, true));
        if (GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VM-1000") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VM-1200") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VM-2000") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VM-2200") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VM-3200") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VM-3000") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VP-1000") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VP-2000") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VP-3000")) {
            list.add(new HistoryData("message.pvInputCurrent", "{workInfo.getChargingCurrent}", true, true));
        } else {
            list.add(new HistoryData("message.chargeCurrent", "{workInfo.getChargingCurrent}", true, true));
        }
        list.add(new HistoryData("message.batdiscurrent", "{workInfo.getBatDisCurrent}", true, true));
        if (!this.getAxpertType().startsWith("VP") && !this.getAxpertType().startsWith("VM")) {
            list.add(new HistoryData("message.outputVoltage", "{workInfo.getAcOutputVoltageR}", true, true));
        }
        list.add(new HistoryData("message.outputFrequency", "{workInfo.getAcOutputFrequency}", true, true));
        columns.setColumns(list);
        return columns;
    }

    @Override
    public HistoryDataChartColumns getHistoryChartColumns() {
        HistoryDataChartColumns columns = new HistoryDataChartColumns();
        ArrayList<HistoryChart> list = new ArrayList<HistoryChart>();
        list.add(new HistoryChart("message.acVoltage", "{workInfo.getGridVoltageR}", 300.0, "V", true));
        list.add(new HistoryChart("message.acFrequency", "{workInfo.getGridFrequency}", 70.0, "Hz", true));
        list.add(new HistoryChart("message.pvInputVoltage", "{workInfo.getPvInputVoltage1}", 200.0, "V", true));
        list.add(new HistoryChart("message.pvInputCurrent", "{workInfo.getPvInputCurrentForBatttery}", 200.0, "A", true));
        list.add(new HistoryChart("message.pvInputPower", "{workInfo.getPvInputPower1}", 3000.0, "V", true));
        list.add(new HistoryChart("message.outputapppower", "{workInfo.getAcOutputApparentPower}", 3000.0, "VA", true));
        list.add(new HistoryChart("message.outputactpower", "{workInfo.getAcOutputActivePower}", 3000.0, "W", true));
        list.add(new HistoryChart("message.batteryVoltage", "{workInfo.getPBatteryVoltage}", 100.0, "V", true));
        list.add(new HistoryChart("message.batteryCapacity", "{workInfo.getBatteryCapacity}", 100.0, "%", true));
        if (GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VM-1000") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VM-1200") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VM-2000") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VM-2200") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VM-3200") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VM-3000") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VP-1000") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VP-2000") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VP-3000")) {
            list.add(new HistoryChart("message.pvInputCurrent", "{workInfo.getChargingCurrent}", 250.0, "A", true));
        } else {
            list.add(new HistoryChart("message.chargeCurrent", "{workInfo.getChargingCurrent}", 250.0, "A", true));
        }
        list.add(new HistoryChart("message.batdiscurrent", "{workInfo.getBatDisCurrent}", 150.0, "A", true));
        if (!this.getAxpertType().startsWith("VP") && !this.getAxpertType().startsWith("VM")) {
            list.add(new HistoryChart("message.outputVoltage", "{workInfo.getAcOutputVoltageR}", 300.0, "V", true));
        }
        list.add(new HistoryChart("message.outputFrequency", "{workInfo.getAcOutputFrequency}", 70.0, "Hz", true));
        columns.setColumns(list);
        return columns;
    }

    @Override
    public RadioParameter getEqRadioParameter() {
        RadioParameter radioParameter = new RadioParameter();
        ArrayList<AutoRadioItem> list = new ArrayList<AutoRadioItem>();
        AbstractProcessor processor = GlobalProcessors.getCurrentProcessor();
        MachineInfo machineInfo = null;
        if (processor != null) {
            machineInfo = (MachineInfo)processor.getBeanBag().getBean("machineinfo");
        }
        if (machineInfo.isSupportEQ()) {
            list.add(new AutoRadioItem("message.BatteryEqualization[:]", "message.enable", "message.disable", "{configData.isEnableEq}", "setPBEQE", false));
            list.add(new AutoRadioItem("message.RealtimeActivateBatteryEqualization[:]", "message.Activate", "message.cancel", "{configData.getActivateEq}", "setPBEQA", false));
            radioParameter.setRadioParameterList(list);
        }
        return radioParameter;
    }

    @Override
    public SpinnerParameter getEqSpinnerParameter() {
        SpinnerParameter spinnerParameter = new SpinnerParameter();
        ArrayList<AutoSpinnerItem> list = new ArrayList<AutoSpinnerItem>();
        AbstractProcessor processor = GlobalProcessors.getCurrentProcessor();
        MachineInfo machineInfo = null;
        if (processor != null) {
            machineInfo = (MachineInfo)processor.getBeanBag().getBean("machineinfo");
        }
        if (machineInfo.isSupportEQ()) {
            list.add(new AutoSpinnerItem("message.EqualizationTime[:]", "{configData.getMinEqTime}", "{configData.getMaxEqTime}", "5", "{configData.getEqTime}", "message.minitue", "setPBEQT", false));
            list.add(new AutoSpinnerItem("message.EqualizationPeriod[:]", "{configData.getMinEqPeriod}", "{configData.getMaxEqPeriod}", "1", "{configData.getEqPeriod}", "message.days", "setPBEQP", false));
            list.add(new AutoSpinnerItem("message.EqualizationVoltage[:]", "{configData.getMinEqVoltage}", "{configData.getMaxEqVoltage}", "0.1", "{configData.getEqVoltage}", "V", "setPBEQV", false));
            list.add(new AutoSpinnerItem("message.EqualizationOverTime[:]", "{configData.getMinEqOverTime}", "{configData.getMaxEqOverTime}", "5", "{configData.getEqOverTime}", "message.minitue", "setPBEQOT", false));
            spinnerParameter.setSpinnerParameterList(list);
        }
        return spinnerParameter;
    }

    @Override
    public AutoMenuList getMenuList() {
        AutoMenuList menuList = new AutoMenuList();
        ArrayList<AutoMenuOne> menus = new ArrayList<AutoMenuOne>();
        ArrayList<AutoMenuTwo> items1 = new ArrayList<AutoMenuTwo>();
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.baseSet", 101, ""), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.passwordSet", 102, ""), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.smsinfoSet", 104, ""), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.emailSet", 105, ""), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.electricEventSet", 106, ""), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.setcom", 107, ""), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.modbussetting", 108, ""), null));
        ArrayList<AutoMenuTwo> items2 = new ArrayList<AutoMenuTwo>();
        items2.add(new AutoMenuTwo(new AutoMenuItem("message.parametersSetting", 201, ""), null));
        items2.add(new AutoMenuTwo(new AutoMenuItem("message.factoryReset", 202, ""), null));
        ArrayList<AutoMenuTwo> items3 = new ArrayList<AutoMenuTwo>();
        items3.add(new AutoMenuTwo(new AutoMenuItem("message.queryData", 302, ""), null));
        items3.add(new AutoMenuTwo(new AutoMenuItem("message.queryEvent", 304, ""), null));
        ArrayList<AutoMenuTwo> items4 = new ArrayList<AutoMenuTwo>();
        items4.add(new AutoMenuTwo(new AutoMenuItem("English", 401, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("French", 402, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("German", 403, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Polish", 405, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Spanish", 408, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Chinese(Simplified)", 411, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Chinese(Traditional)", 412, "radio"), null));
        ArrayList<AutoMenuTwo> items5 = new ArrayList<AutoMenuTwo>();
        items5.add(new AutoMenuTwo(new AutoMenuItem("message.about", 501, ""), null));
        ArrayList<AutoMenuItem> items = new ArrayList<AutoMenuItem>();
        CustomerConfig custormerConfig = GlobalVariables.customerConfig;
        if (custormerConfig.isEnglish()) {
            items.add(new AutoMenuItem("English", 5021, ""));
        }
        if (custormerConfig.isTurkish()) {
            items.add(new AutoMenuItem("Turkish", 5022, ""));
        }
        if (custormerConfig.isRussian()) {
            items.add(new AutoMenuItem("Russian", 5023, ""));
        }
        if (items.size() < 2) {
            items = null;
        }
        items5.add(new AutoMenuTwo(new AutoMenuItem("message.onlineHelp", 502, ""), items));
        menus.add(new AutoMenuOne("[" + GlobalVariables.customerConfig.getCustomerName() + "]" + "message.pvConfig", 1, items1));
        menus.add(new AutoMenuOne("message.pvControl", 2, items2));
        menus.add(new AutoMenuOne("message.pvView", 3, items3));
        menus.add(new AutoMenuOne("message.language", 4, items4));
        menus.add(new AutoMenuOne("message.help", 5, items5));
        menuList.setMenuList(menus);
        return menuList;
    }
}

