/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.protocol;

import cn.com.voltronic.solar.communicate.IComUSBHandler;
import cn.com.voltronic.solar.communicate.ModbusHandler;
import cn.com.voltronic.solar.communicate.SNMPHandler;
import cn.com.voltronic.solar.data.bean.AutoComboBoxItem;
import cn.com.voltronic.solar.data.bean.AutoLabelItem;
import cn.com.voltronic.solar.data.bean.AutoRadioItem;
import cn.com.voltronic.solar.data.bean.BaseInfo;
import cn.com.voltronic.solar.data.bean.ComboBoxParameter;
import cn.com.voltronic.solar.data.bean.ConfigData;
import cn.com.voltronic.solar.data.bean.HistoryChart;
import cn.com.voltronic.solar.data.bean.HistoryData;
import cn.com.voltronic.solar.data.bean.HistoryDataChartColumns;
import cn.com.voltronic.solar.data.bean.HistoryDataColumns;
import cn.com.voltronic.solar.data.bean.HistoryFaultDataColumns;
import cn.com.voltronic.solar.data.bean.RadioParameter;
import cn.com.voltronic.solar.data.bean.RestoreInfo;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.protocol.P304TO5KW;
import cn.com.voltronic.solar.system.GlobalProcessors;
import cn.com.voltronic.solar.util.VolUtil;
import java.util.ArrayList;
import net.wimpi.modbus.procimg.Register;

public class P30EPS
extends P304TO5KW {
    @Override
    public String getProtocolID() {
        return "P30EPS";
    }

    @Override
    public boolean matchProtocol(Object handler) {
        if (handler instanceof IComUSBHandler) {
            return this.matchComUSB((IComUSBHandler)handler);
        }
        if (handler instanceof ModbusHandler) {
            try {
                return this.matchModbus((ModbusHandler)handler);
            }
            catch (Exception e) {
                return false;
            }
        }
        boolean cfr_ignored_0 = handler instanceof SNMPHandler;
        return false;
    }

    @Override
    public boolean matchComUSB(IComUSBHandler _handler) {
        boolean isPI30;
        String dataStr = "(NAK";
        int i = 0;
        while (i < 2) {
            if (!this.isEmpty(dataStr)) break;
            try {
                dataStr = _handler.excuteSimpleCommand("QPI");
            }
            catch (Exception e) {
                return false;
            }
            ++i;
        }
        boolean bl = isPI30 = dataStr.startsWith("(PI") && dataStr.endsWith("30");
        if (!isPI30) {
            return false;
        }
        String qpiri = _handler.excuteSimpleCommand("QPIRI");
        if (this.isEmpty(qpiri)) {
            return false;
        }
        String[] item = qpiri.split(" ");
        this.machineType = item[19];
        if (!this.machineType.equals("30") && !this.machineType.equals("31")) {
            return false;
        }
        this.serialNo = _handler.getSerialNo();
        if (this.isEmpty(this.serialNo)) {
            return false;
        }
        this.outputmode = VolUtil.parseInt(item[21]);
        return true;
    }

    @Override
    public boolean matchModbus(ModbusHandler modbus) throws Exception {
        boolean result = false;
        Register[] regs = modbus.readMultipleRegisters(992, 1);
        if (regs != null && regs.length == 1) {
            String pid = new String(regs[0].toBytes());
            if ((pid = "P" + pid).equals("P30")) {
                result = true;
            }
        }
        if (!result) {
            return false;
        }
        Register[] qryMachineType = modbus.readMultipleRegisters(1178, 1);
        this.machineType = new String(qryMachineType[0].toBytes()).trim();
        if (!this.machineType.equals("30") && !this.machineType.equals("31")) {
            return false;
        }
        this.serialNo = modbus.getSerialNo();
        if (this.isEmpty(this.serialNo)) {
            result = false;
        }
        regs = modbus.readMultipleRegisters(1481, 1);
        this.outputmode = regs[0].getValue();
        return result;
    }

    @Override
    public BaseInfo getBaseInfo() {
        BaseInfo baseInfo = new BaseInfo();
        ArrayList<AutoLabelItem> item = new ArrayList<AutoLabelItem>();
        if (this.machineType.equals("31")) {
            item.add(new AutoLabelItem("message.gridVoltager[:]", "{workInfo.getRGridVoltage}", "V"));
            item.add(new AutoLabelItem("message.gridVoltages[:]", "{workInfo.getSGridVoltage}", "V"));
            item.add(new AutoLabelItem("message.gridVoltaget[:]", "{workInfo.getTGridVoltage}", "V"));
        } else {
            item.add(new AutoLabelItem("message.acVoltage[:]", "{workInfo.getGridVoltageR}", "V"));
        }
        item.add(new AutoLabelItem("message.acFrequency[:]", "{workInfo.getGridFrequency}", "Hz"));
        if (this.machineType.equals("31")) {
            item.add(new AutoLabelItem("message.outputVoltageR[:]", "{workInfo.getRPhaseACOutputVoltage}", "V"));
            item.add(new AutoLabelItem("message.outputVoltageS[:]", "{workInfo.getSPhaseACOutputVoltage}", "V"));
            item.add(new AutoLabelItem("message.outputVoltageT[:]", "{workInfo.getTPhaseACOutputVoltage}", "V"));
            item.add(new AutoLabelItem("message.acOutputApperentPowerR[:]", "{workInfo.getOutputApparentPowerR}", "VA"));
            item.add(new AutoLabelItem("message.acOutputApperentPowerS[:]", "{workInfo.getOutputApparentPowerS}", "VA"));
            item.add(new AutoLabelItem("message.acOutputApperentPowerT[:]", "{workInfo.getOutputApparentPowerT}", "VA"));
            item.add(new AutoLabelItem("message.acOutputActivePowerR[:]", "{workInfo.getOutputActivePowerR}", "W"));
            item.add(new AutoLabelItem("message.acOutputActivePowerS[:]", "{workInfo.getOutputActivePowerS}", "W"));
            item.add(new AutoLabelItem("message.acOutputActivePowerT[:]", "{workInfo.getOutputActivePowerT}", "W"));
        } else {
            item.add(new AutoLabelItem("message.outputVoltage[:]", "{workInfo.getAcOutputVoltageR}", "V"));
        }
        item.add(new AutoLabelItem("message.outputapppower[:]", "{workInfo.getAcOutputApparentPower}", "VA"));
        item.add(new AutoLabelItem("message.outputactpower[:]", "{workInfo.getAcOutputActivePower}", "W"));
        item.add(new AutoLabelItem("message.loadpercent[:]", "{workInfo.getOutputLoadPercent}", "%"));
        item.add(new AutoLabelItem("message.outputFrequency[:]", "{workInfo.getAcOutputFrequency}", "Hz"));
        item.add(new AutoLabelItem("message.batteryVoltage[:]", "{workInfo.getPBatteryVoltage}", "V"));
        item.add(new AutoLabelItem("message.batteryCapacity[:]", "{workInfo.getBatteryCapacity}", "%"));
        item.add(new AutoLabelItem("message.chargeCurrent[:]", "{workInfo.getChargingCurrent}", "A"));
        item.add(new AutoLabelItem("message.batdiscurrent[:]", "{workInfo.getBatDisCurrent}", "A"));
        if (this.outputmode == 1) {
            item.add(new AutoLabelItem("message.totalchargingcurrent[:]", "{workInfo.getTtlChargingCurrent}", "A"));
            item.add(new AutoLabelItem("message.totaloutputapparentpower[:]", "{workInfo.getAcTtlOutputApparentPower}", "VA"));
            item.add(new AutoLabelItem("message.totaloutputactivepower[:]", "{workInfo.getAcTtlOutputActivePower}", "W"));
            item.add(new AutoLabelItem("message.totaloutputpercent[:]", "{workInfo.getAcTtlOutputPercent}", "%"));
        }
        baseInfo.setBaseInfoList(item);
        return baseInfo;
    }

    @Override
    public HistoryDataColumns getHistoryColumns() {
        HistoryDataColumns columns = new HistoryDataColumns();
        ArrayList<HistoryData> list = new ArrayList<HistoryData>();
        list.add(new HistoryData("message.workMode", "{workInfo.getWorkMode}", true, false));
        list.add(new HistoryData("message.time", "{workInfo.getCurrentTime}", true, false));
        if (this.machineType.equals("31")) {
            list.add(new HistoryData("message.gridVoltager", "{workInfo.getRGridVoltage}", true, true));
            list.add(new HistoryData("message.gridVoltages", "{workInfo.getSGridVoltage}", true, true));
            list.add(new HistoryData("message.gridVoltaget", "{workInfo.getTGridVoltage}", true, true));
        } else {
            list.add(new HistoryData("message.acVoltage", "{workInfo.getGridVoltageR}", true, true));
        }
        list.add(new HistoryData("message.acFrequency", "{workInfo.getGridFrequency}", true, true));
        list.add(new HistoryData("message.batteryVoltage", "{workInfo.getPBatteryVoltage}", true, true));
        list.add(new HistoryData("message.batteryCapacity", "{workInfo.getBatteryCapacity}", true, true));
        list.add(new HistoryData("message.chargeCurrent", "{workInfo.getChargingCurrent}", true, true));
        list.add(new HistoryData("message.batdiscurrent", "{workInfo.getBatDisCurrent}", true, true));
        list.add(new HistoryData("message.outputFrequency", "{workInfo.getAcOutputFrequency}", true, true));
        if (this.machineType.equals("31")) {
            list.add(new HistoryData("message.outputVoltageR", "{workInfo.getRPhaseACOutputVoltage}", true, true));
            list.add(new HistoryData("message.outputVoltageS", "{workInfo.getSPhaseACOutputVoltage}", true, true));
            list.add(new HistoryData("message.outputVoltageT", "{workInfo.getTPhaseACOutputVoltage}", true, true));
            list.add(new HistoryData("message.acOutputApperentPowerR", "{workInfo.getOutputApparentPowerR}", true, true));
            list.add(new HistoryData("message.acOutputApperentPowerS", "{workInfo.getOutputApparentPowerS}", true, true));
            list.add(new HistoryData("message.acOutputApperentPowerT", "{workInfo.getOutputApparentPowerT}", true, true));
            list.add(new HistoryData("message.acOutputActivePowerR", "{workInfo.getOutputActivePowerR}", true, true));
            list.add(new HistoryData("message.acOutputActivePowerS", "{workInfo.getOutputActivePowerS}", true, true));
            list.add(new HistoryData("message.acOutputActivePowerT", "{workInfo.getOutputActivePowerT}", true, true));
        } else {
            list.add(new HistoryData("message.outputVoltage", "{workInfo.getAcOutputVoltageR}", true, true));
        }
        list.add(new HistoryData("message.outputapppower", "{workInfo.getAcOutputApparentPower}", true, true));
        list.add(new HistoryData("message.outputactpower", "{workInfo.getAcOutputActivePower}", true, true));
        if (this.outputmode == 1) {
            list.add(new HistoryData("message.totalchargingcurrent", "{workInfo.getTtlChargingCurrent}", true, true));
            list.add(new HistoryData("message.totaloutputapparentpower", "{workInfo.getAcTtlOutputApparentPower}", true, true));
            list.add(new HistoryData("message.totaloutputactivepower", "{workInfo.getAcTtlOutputActivePower}", true, true));
            list.add(new HistoryData("message.totaloutputpercent", "{workInfo.getAcTtlOutputPercent}", true, true));
        }
        columns.setColumns(list);
        return columns;
    }

    @Override
    public HistoryDataChartColumns getHistoryChartColumns() {
        HistoryDataChartColumns columns = new HistoryDataChartColumns();
        ArrayList<HistoryChart> list = new ArrayList<HistoryChart>();
        if (this.machineType.equals("31")) {
            list.add(new HistoryChart("message.gridVoltager", "{workInfo.getRGridVoltage}", 300.0, "V", true));
            list.add(new HistoryChart("message.gridVoltages", "{workInfo.getSGridVoltage}", 300.0, "V", true));
            list.add(new HistoryChart("message.gridVoltaget", "{workInfo.getTGridVoltage}", 300.0, "V", true));
        } else {
            list.add(new HistoryChart("message.acVoltage", "{workInfo.getGridVoltageR}", 300.0, "V", true));
        }
        list.add(new HistoryChart("message.acFrequency", "{workInfo.getGridFrequency}", 70.0, "Hz", true));
        list.add(new HistoryChart("message.batteryVoltage", "{workInfo.getPBatteryVoltage}", 100.0, "V", true));
        list.add(new HistoryChart("message.batteryCapacity", "{workInfo.getBatteryCapacity}", 100.0, "%", true));
        list.add(new HistoryChart("message.chargeCurrent", "{workInfo.getChargingCurrent}", 250.0, "A", true));
        list.add(new HistoryChart("message.batdiscurrent", "{workInfo.getBatDisCurrent}", 150.0, "A", true));
        list.add(new HistoryChart("message.outputFrequency", "{workInfo.getAcOutputFrequency}", 70.0, "Hz", true));
        if (this.machineType.equals("31")) {
            list.add(new HistoryChart("message.outputVoltageR", "{workInfo.getRPhaseACOutputVoltage}", 300.0, "V", true));
            list.add(new HistoryChart("message.outputVoltageS", "{workInfo.getSPhaseACOutputVoltage}", 300.0, "V", true));
            list.add(new HistoryChart("message.outputVoltageT", "{workInfo.getTPhaseACOutputVoltage}", 300.0, "V", true));
            list.add(new HistoryChart("message.acOutputApperentPowerR", "{workInfo.getOutputApparentPowerR}", 3000.0, "VA", true));
            list.add(new HistoryChart("message.acOutputApperentPowerS", "{workInfo.getOutputApparentPowerS}", 3000.0, "VA", true));
            list.add(new HistoryChart("message.acOutputApperentPowerT", "{workInfo.getOutputApparentPowerT}", 3000.0, "VA", true));
            list.add(new HistoryChart("message.acOutputActivePowerR", "{workInfo.getOutputActivePowerR}", 3000.0, "W", true));
            list.add(new HistoryChart("message.acOutputActivePowerS", "{workInfo.getOutputActivePowerS}", 3000.0, "W", true));
            list.add(new HistoryChart("message.acOutputActivePowerT", "{workInfo.getOutputActivePowerT}", 3000.0, "W", true));
        } else {
            list.add(new HistoryChart("message.outputVoltage", "{workInfo.getAcOutputVoltageR}", 300.0, "V", true));
        }
        list.add(new HistoryChart("message.outputapppower", "{workInfo.getAcOutputApparentPower}", 3000.0, "VA", true));
        list.add(new HistoryChart("message.outputactpower", "{workInfo.getAcOutputActivePower}", 3000.0, "W", true));
        if (this.outputmode == 1) {
            list.add(new HistoryChart("message.totalchargingcurrent", "{workInfo.getTtlChargingCurrent}", 100.0, "A", true));
            list.add(new HistoryChart("message.totaloutputapparentpower", "{workInfo.getAcTtlOutputApparentPower}", 20000.0, "VA", true));
            list.add(new HistoryChart("message.totaloutputactivepower", "{workInfo.getAcTtlOutputActivePower}", 20000.0, "W", true));
            list.add(new HistoryChart("message.totaloutputpercent", "{workInfo.getAcTtlOutputPercent}", 100.0, "%", true));
        }
        columns.setColumns(list);
        return columns;
    }

    @Override
    public HistoryFaultDataColumns getHistoryFaultColumns() {
        HistoryFaultDataColumns columns = new HistoryFaultDataColumns();
        ArrayList<HistoryData> list = new ArrayList<HistoryData>();
        list.add(new HistoryData("message.trandate", "{faultData.getTrandate}", true, true));
        list.add(new HistoryData("message.faultString", "{faultData.getFaultString}", true, true));
        list.add(new HistoryData("message.workMode", "{faultData.getWorkMode}", true, true));
        if (this.machineType.equalsIgnoreCase("31")) {
            list.add(new HistoryData("message.gridVoltager", "{faultData.getRGridVoltage}", true, false));
            list.add(new HistoryData("message.gridVoltages", "{faultData.getSGridVoltage}", true, false));
            list.add(new HistoryData("message.gridVoltaget", "{faultData.getTGridVoltage}", true, false));
        } else {
            list.add(new HistoryData("message.acVoltage", "{faultData.getGridVoltageR}", true, false));
        }
        list.add(new HistoryData("message.acFrequency", "{faultData.getGridFrequency}", true, false));
        list.add(new HistoryData("message.outputapppower", "{faultData.getAcOutputApparentPower}", true, true));
        list.add(new HistoryData("message.outputactpower", "{faultData.getAcOutputActivePower}", true, true));
        list.add(new HistoryData("message.batteryVoltage", "{faultData.getPBatteryVoltage}", true, true));
        list.add(new HistoryData("message.batteryCapacity", "{faultData.getBatteryCapacity}", true, true));
        list.add(new HistoryData("message.chargeCurrent", "{faultData.getChargingCurrent}", true, true));
        list.add(new HistoryData("message.batdiscurrent", "{faultData.getBatDisCurrent}", true, true));
        if (this.machineType.equals("31")) {
            list.add(new HistoryData("message.outputVoltageR", "{faultData.getRPhaseACOutputVoltage}", true, true));
            list.add(new HistoryData("message.outputVoltageS", "{faultData.getSPhaseACOutputVoltage}", true, true));
            list.add(new HistoryData("message.outputVoltageT", "{faultData.getTPhaseACOutputVoltage}", true, true));
            list.add(new HistoryData("message.acOutputApperentPowerR", "{faultData.getOutputApparentPowerR}", true, true));
            list.add(new HistoryData("message.acOutputApperentPowerS", "{faultData.getOutputApparentPowerS}", true, true));
            list.add(new HistoryData("message.acOutputApperentPowerT", "{faultData.getOutputApparentPowerT}", true, true));
            list.add(new HistoryData("message.acOutputActivePowerR", "{faultData.getOutputActivePowerR}", true, true));
            list.add(new HistoryData("message.acOutputActivePowerS", "{faultData.getOutputActivePowerS}", true, true));
            list.add(new HistoryData("message.acOutputActivePowerT", "{faultData.getOutputActivePowerT}", true, true));
        } else {
            list.add(new HistoryData("message.outputVoltage", "{faultData.getAcOutputVoltageR}", true, true));
        }
        list.add(new HistoryData("message.outputFrequency", "{faultData.getAcOutputFrequency}", true, true));
        if (this.outputmode == 1) {
            list.add(new HistoryData("message.totalchargingcurrent", "{faultData.getTtlChargingCurrent}", true, true));
            list.add(new HistoryData("message.totaloutputapparentpower", "{faultData.getAcTtlOutputApparentPower}", true, true));
            list.add(new HistoryData("message.totaloutputactivepower", "{faultData.getAcTtlOutputActivePower}", true, true));
            list.add(new HistoryData("message.totaloutputpercent", "{faultData.getAcTtlOutputPercent}", true, true));
        }
        columns.setColumns(list);
        return columns;
    }

    @Override
    public RestoreInfo getResotreInfo() {
        RestoreInfo restoreInfo = new RestoreInfo();
        ArrayList<AutoLabelItem> infos = new ArrayList<AutoLabelItem>();
        infos.add(new AutoLabelItem("message.outputMode[:]", "{defaultData.getOutputMode}", " "));
        infos.add(new AutoLabelItem("message.maxAcChargingCurrent[:]", "{defaultData.getMaxACChargingCurrent}", "A"));
        infos.add(new AutoLabelItem("message.outputFrequency[:]", "{defaultData.getAcOutputFrequency}", "Hz"));
        infos.add(new AutoLabelItem("message.maxChargingVoltage[:]", "{defaultData.getMaxChargingVoltage}", "V"));
        infos.add(new AutoLabelItem("message.maxFloatingVoltage[:]", "{defaultData.getFloatChargingVoltage}", "V"));
        infos.add(new AutoLabelItem("message.batteryCutoffVoltage[:]", "{defaultData.getBatteryCutoffVoltage}", "V"));
        infos.add(new AutoLabelItem("message.enableDisablebuzzer[:]", "{defaultData.getCapableA}", ""));
        if (this.outputmode == 0) {
            infos.add(new AutoLabelItem("message.enableDisablePowerSaving[:]", "{defaultData.getCapableJ}", ""));
        }
        infos.add(new AutoLabelItem("message.enableDisableOverloadRestart[:]", "{defaultData.getCapableU}", ""));
        infos.add(new AutoLabelItem("message.enableDisableOverTempRestart[:]", "{defaultData.getCapableV}", ""));
        infos.add(new AutoLabelItem("message.enableDisableLcdBacklightOn[:]", "{defaultData.getCapableX}", ""));
        infos.add(new AutoLabelItem("message.enableDisableAlarmOn[:]", "{defaultData.getCapableY}", ""));
        infos.add(new AutoLabelItem("message.enableDisableLcdComeBack[:]", "{defaultData.getCapableK}", ""));
        restoreInfo.setInfos(infos);
        return restoreInfo;
    }

    @Override
    public RadioParameter getRadioParameter() {
        RadioParameter radioParameter = new RadioParameter();
        ArrayList<AutoRadioItem> list = new ArrayList<AutoRadioItem>();
        list.add(new AutoRadioItem("message.pepdA[:]", "message.enable", "message.disable", "{cappbility.isCapableA}", "CapableA", false));
        if (this.outputmode == 0 && !this.getAxpertType().startsWith("V") && !this.getAxpertType().startsWith("VM")) {
            list.add(new AutoRadioItem("message.powerSavingMode[:]", "message.enable", "message.disable", "{cappbility.isCapableJ}", "CapableJ", false));
        }
        list.add(new AutoRadioItem("message.backlight[:]", "message.enable", "message.disable", "{cappbility.isCapableX}", "CapableX", false));
        list.add(new AutoRadioItem("message.overLoadAutoRestart[:]", "message.enable", "message.disable", "{cappbility.isCapableU}", "CapableU", false));
        list.add(new AutoRadioItem("message.overTemperatureAutoRestart[:]", "message.enable", "message.disable", "{cappbility.isCapableV}", "CapableV", false));
        list.add(new AutoRadioItem("message.beepsWhileInterrupt[:]", "message.enable", "message.disable", "{cappbility.isCapableY}", "CapableY", false));
        list.add(new AutoRadioItem("message.lcdComeBackToDefaultAfter1min[:] ", "message.enable", "message.disable", "{cappbility.isCapableK}", "CapableK", false));
        radioParameter.setRadioParameterList(list);
        return radioParameter;
    }

    @Override
    public ComboBoxParameter getComboBoxParameter() {
        AbstractProcessor processor = GlobalProcessors.getCurrentProcessor();
        ConfigData config = null;
        if (processor != null) {
            config = (ConfigData)processor.getBeanBag().getBean("configdata");
        }
        ComboBoxParameter comboBoxParameter = new ComboBoxParameter();
        ArrayList<AutoComboBoxItem> list = new ArrayList<AutoComboBoxItem>();
        list.add(new AutoComboBoxItem("message.outputMode[:]", new String[]{"Single", "Parallel", "Phase R of 3 phase output", "Phase S of 3 phase output", "Phase T of 3 phase output"}, "{configData.getOutputMode}", "", "OutputMode", false));
        list.add(new AutoComboBoxItem("message.outputFrequency[:]", new String[]{"50", "60"}, "{configData.getOutputFrequency}", "Hz", "OutputFrequency", false));
        list.add(new AutoComboBoxItem("message.maxAcChargingCurrent[:]", config.getAcChargingCurrentComBox(), "{configData.getMaxacchargingcurrentInt}", "A", "PMaxACChargeCurrent", false));
        list.add(new AutoComboBoxItem("message.outputVoltage[:]", new String[]{"220", "230", "240"}, "{configData.getOutputVoltage}", "V", "setPOPV", false));
        comboBoxParameter.setComboBoxParameterList(list);
        return comboBoxParameter;
    }
}

