/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.protocol;

import cn.com.voltronic.solar.communicate.IComUSBHandler;
import cn.com.voltronic.solar.communicate.ModbusHandler;
import cn.com.voltronic.solar.data.bean.AutoComboBoxItem;
import cn.com.voltronic.solar.data.bean.AutoLabelItem;
import cn.com.voltronic.solar.data.bean.AutoRadioItem;
import cn.com.voltronic.solar.data.bean.AutoSpinnerItem;
import cn.com.voltronic.solar.data.bean.ComboBoxParameter;
import cn.com.voltronic.solar.data.bean.ConfigData;
import cn.com.voltronic.solar.data.bean.MachineInfo;
import cn.com.voltronic.solar.data.bean.RadioParameter;
import cn.com.voltronic.solar.data.bean.RestoreInfo;
import cn.com.voltronic.solar.data.bean.SpinnerParameter;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.protocol.P304TO5KW;
import cn.com.voltronic.solar.system.GlobalProcessors;
import cn.com.voltronic.solar.util.VolUtil;
import java.util.ArrayList;

public class P30EPSM5K
extends P304TO5KW {
    @Override
    public String getProtocolID() {
        return "P30EPSM5K";
    }

    @Override
    public boolean matchComUSB(IComUSBHandler _handler) {
        String dataStr = "(NAK";
        int i = 0;
        while (i < 2) {
            if (!this.isEmpty(dataStr)) break;
            try {
                dataStr = _handler.excuteSimpleCommand("QPI");
            }
            catch (Exception e) {
                return false;
            }
            ++i;
        }
        if (dataStr.startsWith("(PI") && dataStr.endsWith("30") && this instanceof P30EPSM5K) {
            String serialNoStr;
            String[] ratingInfo;
            block22: {
                block21: {
                    block20: {
                        block19: {
                            String qpiri;
                            block18: {
                                block17: {
                                    try {
                                        String qgmn = _handler.excuteSimpleCommand("QGMN");
                                        if (this.isEPSM5K(qgmn) || this.isMKSII5KW(qgmn)) break block17;
                                        return false;
                                    }
                                    catch (Exception ex) {
                                        return false;
                                    }
                                }
                                qpiri = _handler.excuteSimpleCommand("QPIRI");
                                if (!this.isEmpty(qpiri)) break block18;
                                return false;
                            }
                            ratingInfo = qpiri.split(" ");
                            this.machineType = ratingInfo[19];
                            if (this.machineType.equals("00") || this.machineType.equals("01") || this.machineType.equals("10")) break block19;
                            return false;
                        }
                        double acOutputRatingApparentPower = VolUtil.parseDouble(ratingInfo[5]);
                        if (P30EPSM5K.is4to5k(acOutputRatingApparentPower)) break block20;
                        return false;
                    }
                    String qmn = _handler.excuteCommand("QMN", true);
                    if (this.isCommonLogic(qmn)) break block21;
                    return false;
                }
                serialNoStr = _handler.getSerialNo();
                if (!this.isEmpty(serialNoStr)) break block22;
                return false;
            }
            this.serialNo = serialNoStr;
            if (ratingInfo[15].equals("2") || ratingInfo[15].equals("3")) {
                this.outputmode = 1;
            } else if (ratingInfo.length > 21) {
                try {
                    this.outputmode = VolUtil.parseInt(ratingInfo[21]);
                }
                catch (Exception exception) {}
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean matchModbus(ModbusHandler modbus) throws Exception {
        return false;
    }

    @Override
    public ComboBoxParameter getComboBoxParameter() {
        AbstractProcessor processor = GlobalProcessors.getCurrentProcessor();
        MachineInfo machineInfo = null;
        ConfigData config = null;
        if (processor != null) {
            machineInfo = (MachineInfo)processor.getBeanBag().getBean("machineinfo");
            config = (ConfigData)processor.getBeanBag().getBean("configdata");
        }
        ComboBoxParameter comboBoxParameter = new ComboBoxParameter();
        ArrayList<AutoComboBoxItem> list = new ArrayList<AutoComboBoxItem>();
        if (this.outputmode == 0) {
            list.add(new AutoComboBoxItem("message.chargerSourcePriority[:]", new String[]{"Utility", "Solar first", "Utility and Solar", "Solar only"}, "{configData.getChargerSource}", "", "ChargerSource", false));
        } else {
            list.add(new AutoComboBoxItem("message.chargerSourcePriority[:]", new String[]{"Utility", "Solar first", "Utility and Solar", "Solar only"}, "{configData.getChargerSource}", "", "PChargerSource", false));
        }
        list.add(new AutoComboBoxItem("message.outputSourcePriority[:]", new String[]{"Utility", "Solar", "SBU"}, "{configData.getOutputSource}", "", "OutputSource", false));
        list.add(new AutoComboBoxItem("message.batteryType[:]", new String[]{"AGM", "Flooded", "User"}, "{configData.getBatteryType}", "", "BatteryType", false));
        list.add(new AutoComboBoxItem("message.outputMode[:]", new String[]{"Single", "Parallel", "Phase R of 3 phase output", "Phase S of 3 phase output", "Phase T of 3 phase output"}, "{configData.getOutputMode}", "", "OutputMode", false));
        list.add(new AutoComboBoxItem("message.outputVoltage[:]", new String[]{"220", "230", "240"}, "{configData.getOutputVoltage}", "V", "setPOPV", false));
        list.add(new AutoComboBoxItem("message.outputFrequency[:]", new String[]{"50", "60"}, "{configData.getOutputFrequency}", "Hz", "OutputFrequency", false));
        if (config.getBatteryVoltage() > 40.0) {
            if (processor.getProtocol().getAxpert().equals("022")) {
                list.add(new AutoComboBoxItem("message.backToGridVolForSBUPriority[:]", new String[]{"44.0", "45.0", "46.0", "47.0", "48.0", "49.0", "50.0", "51.0", "52.0", "53.0", "54.0", "55.0", "56.0", "57.0"}, "{configData.getRechargeVoltage}", "V", "ReChargeVoltage", false));
                list.add(new AutoComboBoxItem("message.backToDischargeVol[:]", new String[]{"48.0", "49.0", "50.0", "51.0", "52.0", "53.0", "54.0", "55.0", "56.0", "57.0", "58.0", "59.0", "60.0", "61.0", "62.0", "63.0", "64.0", "FULL"}, "{configData.getReDischargeVoltage}", "V", "ReDisChargeVoltage", false));
            } else {
                list.add(new AutoComboBoxItem("message.backToGridVolForSBUPriority[:]", new String[]{"44.0", "45.0", "46.0", "47.0", "48.0", "49.0", "50.0", "51.0"}, "{configData.getRechargeVoltage}", "V", "ReChargeVoltage", false));
                list.add(new AutoComboBoxItem("message.backToDischargeVol[:]", new String[]{"48.0", "49.0", "50.0", "51.0", "52.0", "53.0", "54.0", "55.0", "56.0", "57.0", "58.0", "FULL"}, "{configData.getReDischargeVoltage}", "V", "ReDisChargeVoltage", false));
            }
        }
        list.add(new AutoComboBoxItem("message.maxChargingCurrent[:]", config.getMaxChargeCurrentCombox(machineInfo, this.outputmode), "{configData.getMaxChargeCurrentInt}", "A", "NPMaxChargeCurrent", false));
        list.add(new AutoComboBoxItem("message.maxAcChargingCurrent[:]", config.getAcChargingCurrentComBox(), "{configData.getMaxacchargingcurrentInt}", "A", "PMaxACChargeCurrent", false));
        if (processor.getProtocol().getAxpert().equals("022")) {
            list.add(new AutoComboBoxItem("message.acInputRange[:]", new String[]{"APL range", "UPS"}, "{configData.getAcInputRange}", "", "ACInputRange", false));
        } else {
            list.add(new AutoComboBoxItem("message.acInputRange[:]", new String[]{"Appliance", "UPS"}, "{configData.getAcInputRange}", "", "ACInputRange", false));
        }
        comboBoxParameter.setComboBoxParameterList(list);
        return comboBoxParameter;
    }

    @Override
    public RestoreInfo getResotreInfo() {
        RestoreInfo restoreInfo = new RestoreInfo();
        ArrayList<AutoLabelItem> infos = new ArrayList<AutoLabelItem>();
        infos.add(new AutoLabelItem("message.acOutputFre[:]", "{defaultData.getAcOutputFrequency}", "Hz"));
        infos.add(new AutoLabelItem("message.maxCVChargingTime[:]", "{defaultData.getChargingTimeInCVStage}", "message.minitue"));
        infos.add(new AutoLabelItem("message.maxChargingVoltage[:]", "{defaultData.getMaxChargingVoltage}", "V"));
        infos.add(new AutoLabelItem("message.maxFloatingVoltage[:]", "{defaultData.getFloatChargingVoltage}", "V"));
        infos.add(new AutoLabelItem("message.maxChargingCurrent[:]", "{defaultData.getMaxChargingCurrent}", "A"));
        infos.add(new AutoLabelItem("message.maxAcChargingCurrent[:]", "{defaultData.getMaxACChargingCurrent}", "A"));
        infos.add(new AutoLabelItem("message.batteryCutoffVoltage[:]", "{defaultData.getBatteryCutoffVoltage}", "V"));
        infos.add(new AutoLabelItem("message.backToDischargeVol[:]", "{defaultData.getReDischargeVoltage}", "V"));
        infos.add(new AutoLabelItem("message.backToGridVol[:]", "{defaultData.getReChangingVoltage}", "V"));
        infos.add(new AutoLabelItem("message.outputMode[:]", "{defaultData.getOutputMode}", " "));
        infos.add(new AutoLabelItem("message.acInputVoltageRange[:]", "{defaultData.getAcInputVoltage}", ""));
        infos.add(new AutoLabelItem("message.outputSourcePriority[:]", "{defaultData.getOutputSourcePriority}", ""));
        infos.add(new AutoLabelItem("message.chargerSourcePriority[:]", "{defaultData.getChargerSourcePriority}", ""));
        infos.add(new AutoLabelItem("message.batteryType[:]", "{defaultData.getBatteryType}", ""));
        infos.add(new AutoLabelItem("message.enableDisablebuzzer[:]", "{defaultData.getCapableA}", ""));
        infos.add(new AutoLabelItem("message.enableDisablePowerSaving[:]", "{defaultData.getCapableJ}", ""));
        infos.add(new AutoLabelItem("message.enableDisableOverloadRestart[:]", "{defaultData.getCapableU}", ""));
        infos.add(new AutoLabelItem("message.enableDisableOverTempRestart[:]", "{defaultData.getCapableV}", ""));
        infos.add(new AutoLabelItem("message.enableDisableLcdBacklightOn[:]", "{defaultData.getCapableX}", ""));
        infos.add(new AutoLabelItem("message.enableDisableAlarmOn[:]", "{defaultData.getCapableY}", ""));
        infos.add(new AutoLabelItem("message.enableDisableLcdComeBack[:]", "{defaultData.getCapableK}", ""));
        infos.add(new AutoLabelItem("message.enableDisableOverloadBypass[:]", "{defaultData.getCapableB}", ""));
        restoreInfo.setInfos(infos);
        return restoreInfo;
    }

    @Override
    public RadioParameter getRadioParameter() {
        RadioParameter radioParameter = new RadioParameter();
        ArrayList<AutoRadioItem> list = new ArrayList<AutoRadioItem>();
        list.add(new AutoRadioItem("message.pepdA[:]", "message.enable", "message.disable", "{cappbility.isCapableA}", "CapableA", false));
        if (this.outputmode == 0) {
            list.add(new AutoRadioItem("message.powerSavingMode[:]", "message.enable", "message.disable", "{cappbility.isCapableJ}", "CapableJ", false));
        }
        list.add(new AutoRadioItem("message.backlight[:]", "message.enable", "message.disable", "{cappbility.isCapableX}", "CapableX", false));
        list.add(new AutoRadioItem("message.overLoadAutoRestart[:]", "message.enable", "message.disable", "{cappbility.isCapableU}", "CapableU", false));
        list.add(new AutoRadioItem("message.overTemperatureAutoRestart[:]", "message.enable", "message.disable", "{cappbility.isCapableV}", "CapableV", false));
        list.add(new AutoRadioItem("message.beepsWhileInterrupt[:]", "message.enable", "message.disable", "{cappbility.isCapableY}", "CapableY", false));
        list.add(new AutoRadioItem("message.overloadBypass[:]", "message.enable", "message.disable", "{cappbility.isCapableB}", "CapableB", false));
        list.add(new AutoRadioItem("message.lcdComeBackToDefaultAfter1min[:] ", "message.enable", "message.disable", "{cappbility.isCapableK}", "CapableK", false));
        if (this.outputmode == 1) {
            list.add(new AutoRadioItem("message.mustConnectedToPV[:]", "message.enable", "message.disable", "{configData.isAllpvok}", "setPPVOKC", false));
        }
        list.add(new AutoRadioItem("message.solarPowerBalance[:]", "message.enable", "message.disable", "{configData.isSolarbalance}", "setPSPB", false));
        radioParameter.setRadioParameterList(list);
        return radioParameter;
    }

    @Override
    public SpinnerParameter getSpinnerParameter() {
        SpinnerParameter spinnerParameter = new SpinnerParameter();
        ArrayList<AutoSpinnerItem> list = new ArrayList<AutoSpinnerItem>();
        list.add(new AutoSpinnerItem("message.maxChargingVoltage[:]", "{configData.getMinMaxChargeVoltage}", "{configData.getMaxMaxChargeVoltage}", "0.1", "{configData.getMaxChargeVoltage}", "V", "setMaxChargingVoltage", false));
        list.add(new AutoSpinnerItem("message.maxFloatingVoltage[:]", "{configData.getMinFloatingChargeVoltage}", "{configData.getMaxFloatingChargeVoltage}", "0.1", "{configData.getFloatingChargeVoltage}", "V", "setFloatingVoltage", false));
        list.add(new AutoSpinnerItem("message.batteryCutoffVoltage[:]", "{configData.getMinBatteryUnder}", "{configData.getMaxBatteryUnder}", "0.1", "{configData.getBatteryUnder}", "V", "setBatteryCutoffVoltage", false));
        spinnerParameter.setSpinnerParameterList(list);
        return spinnerParameter;
    }

    @Override
    public RadioParameter getEqRadioParameter() {
        RadioParameter radioParameter = new RadioParameter();
        ArrayList<AutoRadioItem> list = new ArrayList<AutoRadioItem>();
        list.add(new AutoRadioItem("message.BatteryEqualization[:]", "message.enable", "message.disable", "{configData.isEnableEq}", "setPBEQE", false));
        list.add(new AutoRadioItem("message.RealtimeActivateBatteryEqualization[:]", "message.Activate", "message.cancel", "{configData.getActivateEq}", "setPBEQA", false));
        radioParameter.setRadioParameterList(list);
        return radioParameter;
    }

    @Override
    public SpinnerParameter getEqSpinnerParameter() {
        SpinnerParameter spinnerParameter = new SpinnerParameter();
        ArrayList<AutoSpinnerItem> list = new ArrayList<AutoSpinnerItem>();
        list.add(new AutoSpinnerItem("message.EqualizationTime[:]", "{configData.getMinEqTime}", "{configData.getMaxEqTime}", "5", "{configData.getEqTime}", "message.minitue", "setPBEQT", false));
        list.add(new AutoSpinnerItem("message.EqualizationPeriod[:]", "{configData.getMinEqPeriod}", "{configData.getMaxEqPeriod}", "1", "{configData.getEqPeriod}", "message.days", "setPBEQP", false));
        list.add(new AutoSpinnerItem("message.EqualizationVoltage[:]", "{configData.getMinEqVoltage}", "{configData.getMaxEqVoltage}", "0.1", "{configData.getEqVoltage}", "V", "setPBEQV", false));
        list.add(new AutoSpinnerItem("message.EqualizationOverTime[:]", "{configData.getMinEqOverTime}", "{configData.getMaxEqOverTime}", "5", "{configData.getEqOverTime}", "message.minitue", "setPBEQOT", false));
        spinnerParameter.setSpinnerParameterList(list);
        return spinnerParameter;
    }
}

