/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.protocol;

import cn.com.voltronic.solar.communicate.IComUSBHandler;
import cn.com.voltronic.solar.data.bean.AutoComboBoxItem;
import cn.com.voltronic.solar.data.bean.AutoLabelItem;
import cn.com.voltronic.solar.data.bean.AutoRadioItem;
import cn.com.voltronic.solar.data.bean.AutoSpinnerItem;
import cn.com.voltronic.solar.data.bean.ComboBoxParameter;
import cn.com.voltronic.solar.data.bean.ConfigData;
import cn.com.voltronic.solar.data.bean.MachineInfo;
import cn.com.voltronic.solar.data.bean.RadioParameter;
import cn.com.voltronic.solar.data.bean.RestoreInfo;
import cn.com.voltronic.solar.data.bean.SpinnerParameter;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.protocol.P30;
import cn.com.voltronic.solar.system.GlobalProcessors;
import cn.com.voltronic.solar.util.VolUtil;
import java.util.ArrayList;

public class P30KING
extends P30 {
    @Override
    public String getProtocolID() {
        return "P30KING";
    }

    @Override
    public ComboBoxParameter getComboBoxParameter() {
        AbstractProcessor processor = GlobalProcessors.getCurrentProcessor();
        MachineInfo machineInfo = null;
        ConfigData config = null;
        if (processor != null) {
            machineInfo = (MachineInfo)processor.getBeanBag().getBean("machineinfo");
            config = (ConfigData)processor.getBeanBag().getBean("configdata");
        }
        ComboBoxParameter comboBoxParameter = new ComboBoxParameter();
        ArrayList<AutoComboBoxItem> list = new ArrayList<AutoComboBoxItem>();
        if (this.getAxpertType().startsWith("VMIII")) {
            list.add(new AutoComboBoxItem("message.chargerSourcePriority[:]", new String[]{"Solar first", "Utility and Solar", "Solar only"}, "{configData.getChargerSource}", "", "ChargerSource", false));
        } else {
            list.add(new AutoComboBoxItem("message.chargerSourcePriority[:]", new String[]{"SBL&UCB", "SBL&UDC", "SLB&UCB", "SLB&UDC"}, "{configData.getChargerSource}", "", "ChargerSource", false));
        }
        list.add(new AutoComboBoxItem("message.outputSourcePriority[:]", new String[]{"Utility->Solar->Battery", "Solar->Utility->Battery", "Solar->Battery->Utility"}, "{configData.getOutputSource}", "", "OutputSource", false));
        list.add(new AutoComboBoxItem("message.batteryType[:]", new String[]{"AGM", "Flooded", "User"}, "{configData.getBatteryType}", "", "BatteryType", false));
        list.add(new AutoComboBoxItem("message.bypassFunction[:]", new String[]{"Forbidden", "Disable", "Enable"}, "{configData.getBypassFunction}", "", "BypassFunction", false));
        list.add(new AutoComboBoxItem("message.outputFrequency[:]", new String[]{"50", "60"}, "{configData.getOutputFrequency}", "Hz", "OutputFrequency", false));
        if (GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().startsWith("VMII")) {
            list.add(new AutoComboBoxItem("message.outputVoltage[:]", new String[]{"220", "230", "240"}, "{configData.getOutputVoltage}", "V", "OutputVoltage", false));
        }
        if (processor != null && machineInfo != null && config != null) {
            if (this.getAxpert().equals("023")) {
                list.add(new AutoComboBoxItem("message.backToGridVol[:]", new String[]{"44.0", "45.0", "46.0", "47.0", "48.0", "49.0", "50.0", "51.0", "52.0", "53.0", "54.0", "55.0", "56.0", "57.0"}, "{configData.getRechargeVoltage}", "V", "ReChargeVoltage", false));
            } else if (this.getAxpert().equals("024")) {
                list.add(new AutoComboBoxItem("message.backToGridVol[:]", new String[]{"22.0", "22.5", "23.0", "23.5", "24.0", "24.5", "25.0", "25.5", "26.0", "26.5", "27.0", "27.5", "28.0", "28.5"}, "{configData.getRechargeVoltage}", "V", "ReChargeVoltage", false));
            } else {
                list.add(new AutoComboBoxItem("message.backToGridVol[:]", new String[]{"11.0", "11.3", "11.5", "11.8", "12.0", "12.3", "12.5", "12.8"}, "{configData.getRechargeVoltage}", "V", "ReChargeVoltage", false));
            }
            list.add(new AutoComboBoxItem("message.maxChargingCurrent[:]", config.getMaxChargeCurrentCombox(machineInfo, this.outputmode), "{configData.getMaxChargeCurrentInt}", "A", "NPMaxChargeCurrent", false));
            list.add(new AutoComboBoxItem("message.maxAcChargingCurrent[:]", config.getAcChargingCurrentComBox(), "{configData.getMaxacchargingcurrentInt}", "A", "PMaxACChargeCurrent", false));
            if (this.getAxpert().equals("023")) {
                list.add(new AutoComboBoxItem("message.backToDischargeVol[:]", new String[]{"0.0", "48.0", "49.0", "50.0", "51.0", "52.0", "53.0", "54.0", "55.0", "56.0", "57.0", "58.0", "59.0", "60.0", "61.0", "62.0", "63.0", "64.0"}, "{configData.getReDischargeVoltage}", "V", "ReDisChargeVoltage", false));
            } else if (this.getAxpert().equals("024")) {
                list.add(new AutoComboBoxItem("message.backToDischargeVol[:]", new String[]{"0.0", "24.0", "24.5", "25.0", "25.5", "26.0", "26.5", "27.0", "27.5", "28.0", "28.5", "29.0", "29.5", "30.0", "30.5", "31.0", "31.5", "32.0"}, "{configData.getReDischargeVoltage}", "V", "ReDisChargeVoltage", false));
            } else {
                list.add(new AutoComboBoxItem("message.backToDischargeVol[:]", new String[]{"12.0", "12.3", "12.5", "12.8", "13.0", "13.3", "13.5", "13.8", "14.0", "14.3", "14.5", "FULL"}, "{configData.getReDischargeVoltage}", "V", "ReDisChargeVoltage", false));
            }
            list.add(new AutoComboBoxItem("message.operationLogic[:]", new String[]{"Automatically(AUT)", "Online mode(ONL)", "ECO Mode(ECO)"}, "{configData.getOperationLogic}", "", "OperationLogic", false));
        }
        comboBoxParameter.setComboBoxParameterList(list);
        return comboBoxParameter;
    }

    @Override
    public boolean matchComUSB(IComUSBHandler _handler) {
        String dataStr = "(NAK";
        int i = 0;
        while (i < 2) {
            if (!this.isEmpty(dataStr)) break;
            try {
                dataStr = _handler.excuteSimpleCommand("QPI");
            }
            catch (Exception e) {
                return false;
            }
            ++i;
        }
        if (dataStr.startsWith("(PI") && dataStr.endsWith("30") && this instanceof P30) {
            String serialNoStr;
            String[] ratingInfo;
            block18: {
                block17: {
                    String qpiri;
                    block16: {
                        block15: {
                            try {
                                String qgmn = _handler.excuteSimpleCommand("QGMN");
                                if (this.isAxpertKing(qgmn)) break block15;
                                return false;
                            }
                            catch (Exception ex) {
                                return false;
                            }
                        }
                        qpiri = _handler.excuteSimpleCommand("QPIRI");
                        if (!this.isEmpty(qpiri)) break block16;
                        return false;
                    }
                    ratingInfo = qpiri.split(" ");
                    this.machineType = ratingInfo[19];
                    if (this.machineType.equals("00") || this.machineType.equals("01") || this.machineType.equals("10")) break block17;
                    return false;
                }
                double acOutputRatingApparentPower = VolUtil.parseDouble(ratingInfo[5]);
                String qmn = _handler.excuteCommand("QMN", true);
                serialNoStr = _handler.getSerialNo();
                if (!this.isEmpty(serialNoStr)) break block18;
                return false;
            }
            this.serialNo = serialNoStr;
            if (ratingInfo[15].equals("2") || ratingInfo[15].equals("3")) {
                this.outputmode = 1;
            } else if (ratingInfo.length > 21) {
                try {
                    this.outputmode = VolUtil.parseInt(ratingInfo[21]);
                }
                catch (Exception exception) {}
            }
            return true;
        }
        return false;
    }

    @Override
    public SpinnerParameter getEqSpinnerParameter() {
        SpinnerParameter spinnerParameter = new SpinnerParameter();
        ArrayList<AutoSpinnerItem> list = new ArrayList<AutoSpinnerItem>();
        AbstractProcessor processor = GlobalProcessors.getCurrentProcessor();
        MachineInfo machineInfo = null;
        if (processor != null) {
            machineInfo = (MachineInfo)processor.getBeanBag().getBean("machineinfo");
        }
        if (machineInfo.isSupportEQ()) {
            list.add(new AutoSpinnerItem("message.EqualizationTime[:]", "{configData.getMinEqTime}", "{configData.getMaxEqTime}", "5", "{configData.getEqTime}", "message.minitue", "setPBEQT", false));
            list.add(new AutoSpinnerItem("message.EqualizationPeriod[:]", "{configData.getMinEqPeriod}", "{configData.getMaxEqPeriod}", "1", "{configData.getEqPeriod}", "message.days", "setPBEQP", false));
            list.add(new AutoSpinnerItem("message.EqualizationVoltage[:]", "{configData.getMinEqVoltage}", "{configData.getMaxEqVoltage}", "0.1", "{configData.getEqVoltage}", "V", "setPBEQV", false));
            list.add(new AutoSpinnerItem("message.EqualizationOverTime[:]", "{configData.getMinEqOverTime}", "{configData.getMaxEqOverTime}", "5", "{configData.getEqOverTime}", "message.minitue", "setPBEQOT", false));
            spinnerParameter.setSpinnerParameterList(list);
        }
        return spinnerParameter;
    }

    @Override
    public RadioParameter getEqRadioParameter() {
        RadioParameter radioParameter = new RadioParameter();
        ArrayList<AutoRadioItem> list = new ArrayList<AutoRadioItem>();
        AbstractProcessor processor = GlobalProcessors.getCurrentProcessor();
        MachineInfo machineInfo = null;
        if (processor != null) {
            machineInfo = (MachineInfo)processor.getBeanBag().getBean("machineinfo");
        }
        if (machineInfo.isSupportEQ()) {
            list.add(new AutoRadioItem("message.BatteryEqualization[:]", "message.enable", "message.disable", "{configData.isEnableEq}", "setPBEQE", false));
            list.add(new AutoRadioItem("message.RealtimeActivateBatteryEqualization[:]", "message.Activate", "message.cancel", "{configData.getActivateEq}", "setPBEQA", false));
            radioParameter.setRadioParameterList(list);
        }
        return radioParameter;
    }

    @Override
    public RadioParameter getRadioParameter() {
        AbstractProcessor processor = GlobalProcessors.getCurrentProcessor();
        MachineInfo machineInfo = null;
        if (processor != null) {
            machineInfo = (MachineInfo)processor.getBeanBag().getBean("machineinfo");
        }
        RadioParameter radioParameter = new RadioParameter();
        ArrayList<AutoRadioItem> list = new ArrayList<AutoRadioItem>();
        list.add(new AutoRadioItem("message.pepdA[:]", "message.enable", "message.disable", "{cappbility.isCapableA}", "CapableA", false));
        if (processor != null) {
            if (this.outputmode == 0 && !processor.getProtocol().getAxpert().equals("024") && !processor.getProtocol().getAxpert().equals("023")) {
                list.add(new AutoRadioItem("message.powerSavingMode[:]", "message.enable", "message.disable", "{cappbility.isCapableJ}", "CapableJ", false));
            }
        } else if (this.outputmode == 0) {
            list.add(new AutoRadioItem("message.powerSavingMode[:]", "message.enable", "message.disable", "{cappbility.isCapableJ}", "CapableJ", false));
        }
        list.add(new AutoRadioItem("message.backlight[:]", "message.enable", "message.disable", "{cappbility.isCapableX}", "CapableX", false));
        list.add(new AutoRadioItem("message.overLoadAutoRestart[:]", "message.enable", "message.disable", "{cappbility.isCapableU}", "CapableU", false));
        list.add(new AutoRadioItem("message.overTemperatureAutoRestart[:]", "message.enable", "message.disable", "{cappbility.isCapableV}", "CapableV", false));
        list.add(new AutoRadioItem("message.beepsWhileInterrupt[:]", "message.enable", "message.disable", "{cappbility.isCapableY}", "CapableY", false));
        list.add(new AutoRadioItem("message.lcdComeBackToDefaultAfter1min[:] ", "message.enable", "message.disable", "{cappbility.isCapableK}", "CapableK", false));
        if (this.is1200or5200(machineInfo)) {
            if (this.outputmode == 1) {
                list.add(new AutoRadioItem("message.mustConnectedToPV[:]", "message.enable", "message.disable", "{configData.isAllpvok}", "setPPVOKC", false));
            }
            list.add(new AutoRadioItem("message.solarPowerBalance[:]", "message.enable", "message.disable", "{configData.isSolarbalance}", "setPSPB", false));
        }
        radioParameter.setRadioParameterList(list);
        return radioParameter;
    }

    @Override
    public SpinnerParameter getSpinnerParameter() {
        SpinnerParameter spinnerParameter = new SpinnerParameter();
        ArrayList<AutoSpinnerItem> list = new ArrayList<AutoSpinnerItem>();
        MachineInfo machineInfo = null;
        AbstractProcessor processor = GlobalProcessors.getCurrentProcessor();
        if (processor != null) {
            machineInfo = (MachineInfo)processor.getBeanBag().getBean("machineinfo");
            ConfigData config = (ConfigData)processor.getBeanBag().getBean("configdata");
            double step = config.getMaxMaxChargeCurrent() - config.getMinMaxChargeCurrent();
            if (step > 10.0) {
                step = 10.0;
            }
        }
        list.add(new AutoSpinnerItem("message.maxChargingVoltage[:]", "{configData.getMinMaxChargeVoltage}", "{configData.getMaxMaxChargeVoltage}", "0.1", "{configData.getMaxChargeVoltage}", "V", "setMaxChargingVoltage", false));
        list.add(new AutoSpinnerItem("message.maxFloatingVoltage[:]", "{configData.getMinFloatingChargeVoltage}", "{configData.getMaxFloatingChargeVoltage}", "0.1", "{configData.getFloatingChargeVoltage}", "V", "setFloatingVoltage", false));
        list.add(new AutoSpinnerItem("message.batteryCutoffVoltage[:]", "{configData.getMinBatteryUnder}", "{configData.getMaxBatteryUnder}", "0.1", "{configData.getBatteryUnder}", "V", "setBatteryCutoffVoltage", false));
        spinnerParameter.setSpinnerParameterList(list);
        return spinnerParameter;
    }

    @Override
    public RestoreInfo getResotreInfo() {
        AbstractProcessor processor = GlobalProcessors.getCurrentProcessor();
        MachineInfo machineInfo = null;
        if (processor != null) {
            machineInfo = (MachineInfo)processor.getBeanBag().getBean("machineinfo");
        }
        RestoreInfo restoreInfo = new RestoreInfo();
        ArrayList<AutoLabelItem> infos = new ArrayList<AutoLabelItem>();
        infos.add(new AutoLabelItem("message.acOutputFre[:]", "{defaultData.getAcOutputFrequency}", "Hz"));
        if (this.getProtocolID().equals("P304TO5KW")) {
            infos.add(new AutoLabelItem("message.maxCVChargingTime[:]", "{defaultData.getChargingTimeInCVStage}", "message.minitue"));
        }
        infos.add(new AutoLabelItem("message.maxChargingCurrent[:]", "{defaultData.getMaxChargingCurrent}", "A"));
        infos.add(new AutoLabelItem("message.maxAcChargingCurrent[:]", "{defaultData.getMaxACChargingCurrent}", "A"));
        infos.add(new AutoLabelItem("message.backToGridVol[:]", "{defaultData.getReChangingVoltage}", "V"));
        if (P30KING.is4k5kwV11_00orabove(machineInfo) && !this.getAxpertType().startsWith("V")) {
            infos.add(new AutoLabelItem("message.outputMode[:]", "{defaultData.getOutputMode}", " "));
        }
        infos.add(new AutoLabelItem("message.outputSourcePriority[:]", "{defaultData.getOutputSourcePriority}", ""));
        infos.add(new AutoLabelItem("message.chargerSourcePriority[:]", "{defaultData.getChargerSourcePriority}", ""));
        infos.add(new AutoLabelItem("message.batteryType[:]", "{defaultData.getBatteryType}", ""));
        infos.add(new AutoLabelItem("message.enableDisablebuzzer[:]", "{defaultData.getCapableA}", ""));
        if (processor.getProtocol().getAxpert().equals("024") || processor.getProtocol().getAxpert().equals("023")) {
            infos.add(new AutoLabelItem("message.operationLogic[:]", "{defaultData.getOperationLogic}", ""));
        }
        infos.add(new AutoLabelItem("message.enableDisableOverloadRestart[:]", "{defaultData.getCapableU}", ""));
        infos.add(new AutoLabelItem("message.enableDisableOverTempRestart[:]", "{defaultData.getCapableV}", ""));
        infos.add(new AutoLabelItem("message.enableDisableLcdBacklightOn[:]", "{defaultData.getCapableX}", ""));
        infos.add(new AutoLabelItem("message.enableDisableAlarmOn[:]", "{defaultData.getCapableY}", ""));
        infos.add(new AutoLabelItem("message.enableDisableLcdComeBack[:]", "{defaultData.getCapableK}", ""));
        infos.add(new AutoLabelItem("message.bypassFunction[:]", "{defaultData.getBypassFunction}", ""));
        if (!this.isAxpertKing(this.getAxpert())) {
            infos.add(new AutoLabelItem("message.operationLogic[:]", "{defaultData.getOperationLogic}", ""));
        }
        infos.add(new AutoLabelItem("message.backToDischargeVol[:]", "{defaultData.getReDischargeVoltage}", "V"));
        infos.add(new AutoLabelItem("message.maxChargingVoltage[:]", "{defaultData.getMaxChargingVoltage}", "V"));
        infos.add(new AutoLabelItem("message.maxFloatingVoltage[:]", "{defaultData.getFloatChargingVoltage}", "V"));
        infos.add(new AutoLabelItem("message.batteryCutoffVoltage[:]", "{defaultData.getBatteryCutoffVoltage}", "V"));
        restoreInfo.setInfos(infos);
        return restoreInfo;
    }
}

