/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.protocol;

import cn.com.voltronic.solar.communicate.IComUSBHandler;
import cn.com.voltronic.solar.communicate.ModbusHandler;
import cn.com.voltronic.solar.communicate.SNMPHandler;
import cn.com.voltronic.solar.data.bean.AutoComboBoxItem;
import cn.com.voltronic.solar.data.bean.AutoLabelItem;
import cn.com.voltronic.solar.data.bean.AutoRadioItem;
import cn.com.voltronic.solar.data.bean.AutoSpinnerItem;
import cn.com.voltronic.solar.data.bean.ComboBoxParameter;
import cn.com.voltronic.solar.data.bean.ConfigData;
import cn.com.voltronic.solar.data.bean.MachineInfo;
import cn.com.voltronic.solar.data.bean.RadioParameter;
import cn.com.voltronic.solar.data.bean.RestoreInfo;
import cn.com.voltronic.solar.data.bean.SpinnerParameter;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.protocol.P301TO3KW;
import cn.com.voltronic.solar.system.GlobalProcessors;
import cn.com.voltronic.solar.util.VolUtil;
import java.util.ArrayList;

public class P30LY
extends P301TO3KW {
    @Override
    public String getProtocolID() {
        return "P30LY";
    }

    @Override
    public boolean matchComUSB(IComUSBHandler _handler) {
        String dataStr = "(NAK";
        int i = 0;
        while (i < 2) {
            if (!this.isEmpty(dataStr)) break;
            try {
                dataStr = _handler.excuteSimpleCommand("QPI");
            }
            catch (Exception e) {
                return false;
            }
            ++i;
        }
        if (dataStr.startsWith("(PI") && dataStr.endsWith("30")) {
            String serialNoStr;
            String[] ratingInfo;
            block23: {
                block22: {
                    String qmn;
                    block21: {
                        block20: {
                            String qpiri;
                            block19: {
                                block18: {
                                    try {
                                        String qgmn = _handler.excuteSimpleCommand("QGMN");
                                        if (this.isAxpertLY(qgmn)) break block18;
                                        return false;
                                    }
                                    catch (Exception ex) {
                                        return false;
                                    }
                                }
                                qpiri = _handler.excuteSimpleCommand("QPIRI");
                                if (!this.isEmpty(qpiri)) break block19;
                                return false;
                            }
                            ratingInfo = qpiri.split(" ");
                            this.machineType = ratingInfo[19];
                            if (this.machineType.equals("00") || this.machineType.equals("01") || this.machineType.equals("10")) break block20;
                            return false;
                        }
                        qmn = _handler.excuteCommand("QMN", true);
                        if (!this.isEmpty(qmn)) break block21;
                        return false;
                    }
                    this.axpertType = qmn;
                    if (qmn.startsWith("(")) {
                        this.axpertType = qmn.substring(1);
                    }
                    if (this.axpertType.endsWith("LV-LY")) break block22;
                    return false;
                }
                serialNoStr = _handler.getSerialNo();
                if (!this.isEmpty(serialNoStr)) break block23;
                return false;
            }
            this.serialNo = serialNoStr;
            if (ratingInfo[15].equals("2") || ratingInfo[15].equals("3")) {
                this.outputmode = 1;
            } else if (ratingInfo.length > 21) {
                try {
                    this.outputmode = VolUtil.parseInt(ratingInfo[21]);
                }
                catch (Exception exception) {}
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean matchSnmp(SNMPHandler snmp) {
        return false;
    }

    @Override
    public boolean matchModbus(ModbusHandler modbus) throws Exception {
        return false;
    }

    @Override
    public RadioParameter getRadioParameter() {
        RadioParameter radioParameter = new RadioParameter();
        ArrayList<AutoRadioItem> list = new ArrayList<AutoRadioItem>();
        list.add(new AutoRadioItem("message.pepdA[:]", "message.enable", "message.disable", "{cappbility.isCapableA}", "CapableA", false));
        if (!this.getAxpertType().startsWith("V") && !this.getAxpertType().startsWith("VM")) {
            list.add(new AutoRadioItem("message.powerSavingMode[:]", "message.enable", "message.disable", "{cappbility.isCapableJ}", "CapableJ", false));
        }
        list.add(new AutoRadioItem("message.backlight[:]", "message.enable", "message.disable", "{cappbility.isCapableX}", "CapableX", false));
        list.add(new AutoRadioItem("message.overLoadAutoRestart[:]", "message.enable", "message.disable", "{cappbility.isCapableU}", "CapableU", false));
        list.add(new AutoRadioItem("message.overTemperatureAutoRestart[:]", "message.enable", "message.disable", "{cappbility.isCapableV}", "CapableV", false));
        list.add(new AutoRadioItem("message.beepsWhileInterrupt[:]", "message.enable", "message.disable", "{cappbility.isCapableY}", "CapableY", false));
        list.add(new AutoRadioItem("message.overloadBypass[:]", "message.enable", "message.disable", "{cappbility.isCapableB}", "CapableB", false));
        list.add(new AutoRadioItem("message.lcdComeBackToDefaultAfter1min[:] ", "message.enable", "message.disable", "{cappbility.isCapableK}", "CapableK", false));
        list.add(new AutoRadioItem("message.FaultCodeRecord[:]", "message.enable", "message.disable", "{cappbility.isCapableZ}", "CapableZ", false));
        radioParameter.setRadioParameterList(list);
        return radioParameter;
    }

    @Override
    public ComboBoxParameter getComboBoxParameter() {
        AbstractProcessor processor = GlobalProcessors.getCurrentProcessor();
        MachineInfo machineInfo = null;
        ConfigData config = null;
        if (processor != null) {
            machineInfo = (MachineInfo)processor.getBeanBag().getBean("machineinfo");
            config = (ConfigData)processor.getBeanBag().getBean("configdata");
        }
        ComboBoxParameter comboBoxParameter = new ComboBoxParameter();
        ArrayList<AutoComboBoxItem> list = new ArrayList<AutoComboBoxItem>();
        list.add(new AutoComboBoxItem("message.outputSourcePriority[:]", new String[]{"Utility", "Solar", "SBU"}, "{configData.getOutputSource}", "", "OutputSource", false));
        if (this.getAxpertType().startsWith("VMIII")) {
            list.add(new AutoComboBoxItem("message.chargerSourcePriority[:]", new String[]{"Solar first", "Utility and Solar", "Solar only"}, "{configData.getChargerSource}", "", "ChargerSource", false));
        } else {
            list.add(new AutoComboBoxItem("message.chargerSourcePriority[:]", new String[]{"Utility", "Solar first", "Utility and Solar", "Solar only"}, "{configData.getChargerSource}", "", "ChargerSource", false));
        }
        if (this.getAxpertType().startsWith("VP") || this.getAxpertType().startsWith("VM")) {
            if (GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().startsWith("VMII")) {
                list.add(new AutoComboBoxItem("message.outputVoltage[:]", new String[]{"220", "230", "240"}, "{configData.getOutputVoltage}", "V", "OutputVoltage", false));
            }
        } else {
            list.add(new AutoComboBoxItem("message.outputVoltage[:]", new String[]{"110", "120"}, "{configData.getOutputVoltage}", "V", "OutputVoltage", false));
        }
        list.add(new AutoComboBoxItem("message.outputFrequency[:]", new String[]{"50", "60"}, "{configData.getOutputFrequency}", "Hz", "OutputFrequency", false));
        list.add(new AutoComboBoxItem("message.acInputRange[:]", new String[]{"Appliance", "UPS"}, "{configData.getAcInputRange}", "", "ACInputRange", false));
        if (machineInfo != null) {
            list.add(new AutoComboBoxItem("message.maxChargingCurrent[:]", config.getMaxChargeCurrentCombox(machineInfo, this.outputmode), "{configData.getMaxChargeCurrentInt}", "A", "PMaxChargeCurrent", false));
        }
        list.add(new AutoComboBoxItem("message.maxAcChargingCurrent[:]", config.getAcChargingCurrentComBox(), "{configData.getMaxacchargingcurrentInt}", "A", "PMaxACChargeCurrent", false));
        list.add(new AutoComboBoxItem("message.backToDischargeBatCap[:]", new String[]{"10", "20", "30", "40", "50", "60", "70", "80", "90", "100"}, "{configData.getBatReDischargeCapacity}", "%", "BatReDischargeCapacity", false));
        comboBoxParameter.setComboBoxParameterList(list);
        return comboBoxParameter;
    }

    @Override
    public SpinnerParameter getSpinnerParameter() {
        SpinnerParameter spinnerParameter = new SpinnerParameter();
        ArrayList<AutoSpinnerItem> list = new ArrayList<AutoSpinnerItem>();
        spinnerParameter.setSpinnerParameterList(list);
        return spinnerParameter;
    }

    @Override
    public RestoreInfo getResotreInfo() {
        RestoreInfo restoreInfo = new RestoreInfo();
        ArrayList<AutoLabelItem> infos = new ArrayList<AutoLabelItem>();
        infos.add(new AutoLabelItem("message.outputSourcePriority[:]", "{defaultData.getOutputSourcePriority}", ""));
        infos.add(new AutoLabelItem("message.chargerSourcePriority[:]", "{defaultData.getChargerSourcePriority}", ""));
        if (!this.getAxpertType().startsWith("VP") && !this.getAxpertType().startsWith("VM")) {
            infos.add(new AutoLabelItem("message.outputVoltage[:]", "{defaultData.getAcOutputVoltage}", "V"));
        }
        infos.add(new AutoLabelItem("message.acOutputFre[:]", "{defaultData.getAcOutputFrequency}", "Hz"));
        infos.add(new AutoLabelItem("message.acInputVoltageRange[:]", "{defaultData.getAcInputVoltage}", ""));
        infos.add(new AutoLabelItem("message.maxChargingCurrent[:]", "{defaultData.getMaxChargingCurrent}", "A"));
        infos.add(new AutoLabelItem("message.maxAcChargingCurrent[:]", "{defaultData.getMaxACChargingCurrent}", "A"));
        infos.add(new AutoLabelItem("message.backToDischargeBatCap[:]", "{defaultData.getBatReDischargeCapacity}", "%"));
        infos.add(new AutoLabelItem("message.enableDisablebuzzer[:]", "{defaultData.getCapableA}", ""));
        if (!this.getAxpertType().startsWith("VP") && !this.getAxpertType().startsWith("VM")) {
            infos.add(new AutoLabelItem("message.enableDisablePowerSaving[:]", "{defaultData.getCapableJ}", ""));
        }
        infos.add(new AutoLabelItem("message.enableDisableOverloadRestart[:]", "{defaultData.getCapableU}", ""));
        infos.add(new AutoLabelItem("message.enableDisableOverTempRestart[:]", "{defaultData.getCapableV}", ""));
        infos.add(new AutoLabelItem("message.enableDisableLcdBacklightOn[:]", "{defaultData.getCapableX}", ""));
        infos.add(new AutoLabelItem("message.enableDisableAlarmOn[:]", "{defaultData.getCapableY}", ""));
        infos.add(new AutoLabelItem("message.enableDisableOverloadBypass[:]", "{defaultData.getCapableB}", ""));
        infos.add(new AutoLabelItem("message.FaultCodeRecord[:]", "{defaultData.getCapableZ}", ""));
        restoreInfo.setInfos(infos);
        return restoreInfo;
    }
}

