/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.protocol;

import cn.com.voltronic.solar.communicate.IComUSBHandler;
import cn.com.voltronic.solar.communicate.ModbusHandler;
import cn.com.voltronic.solar.communicate.SNMPHandler;
import cn.com.voltronic.solar.configure.CustomerConfig;
import cn.com.voltronic.solar.data.bean.AutoComboBoxItem;
import cn.com.voltronic.solar.data.bean.AutoLabelItem;
import cn.com.voltronic.solar.data.bean.AutoMenuItem;
import cn.com.voltronic.solar.data.bean.AutoMenuList;
import cn.com.voltronic.solar.data.bean.AutoMenuOne;
import cn.com.voltronic.solar.data.bean.AutoMenuTwo;
import cn.com.voltronic.solar.data.bean.AutoRadioItem;
import cn.com.voltronic.solar.data.bean.AutoSpinnerItem;
import cn.com.voltronic.solar.data.bean.ComboBoxParameter;
import cn.com.voltronic.solar.data.bean.ConfigData;
import cn.com.voltronic.solar.data.bean.MachineInfo;
import cn.com.voltronic.solar.data.bean.RadioParameter;
import cn.com.voltronic.solar.data.bean.RestoreInfo;
import cn.com.voltronic.solar.data.bean.SpinnerParameter;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.protocol.P304TO5KW;
import cn.com.voltronic.solar.system.GlobalProcessors;
import cn.com.voltronic.solar.system.GlobalVariables;
import cn.com.voltronic.solar.util.VolUtil;
import java.util.ArrayList;

public class P30Paral
extends P304TO5KW {
    @Override
    public boolean matchComUSB(IComUSBHandler _handler) {
        String dataStr = "(NAK";
        String qmn = _handler.excuteCommand("QMN", true);
        this.isCommonLogic(qmn);
        int i = 0;
        while (i < 2) {
            if (!this.isEmpty(dataStr)) break;
            try {
                dataStr = _handler.excuteSimpleCommand("QPI");
            }
            catch (Exception e) {
                return false;
            }
            ++i;
        }
        if (dataStr.startsWith("(PI") && dataStr.endsWith("30")) {
            String qpiri;
            block11: {
                String serialNoStr;
                block10: {
                    block9: {
                        try {
                            String qgmn = _handler.excuteSimpleCommand("QGMN");
                            if (this.isParal(qgmn)) break block9;
                            return false;
                        }
                        catch (Exception ex) {
                            return false;
                        }
                    }
                    serialNoStr = _handler.getSerialNo();
                    if (!this.isEmpty(serialNoStr)) break block10;
                    return false;
                }
                this.serialNo = serialNoStr;
                qpiri = _handler.excuteSimpleCommand("QPIRI");
                if (!this.isEmpty(qpiri)) break block11;
                return false;
            }
            String[] ratingInfo = qpiri.split(" ");
            this.machineType = ratingInfo[19];
            this.outputmode = VolUtil.parseInt(ratingInfo[21]);
            return true;
        }
        return false;
    }

    @Override
    public boolean matchModbus(ModbusHandler modbus) throws Exception {
        return false;
    }

    @Override
    public boolean matchSnmp(SNMPHandler snmp) {
        String qpi = snmp.get(".1.3.6.1.4.1.21111.1.2.1.2");
        String pid = new String(qpi);
        if (!(pid = "P" + pid).equals("P30")) {
            return false;
        }
        int qgmnInt = snmp.getInt(".1.3.6.1.4.1.21111.1.2.1.13");
        String qgmn = String.format("%03d", qgmnInt);
        if (!this.isParal(qgmn)) {
            return false;
        }
        this.serialNo = snmp.getSerialNo();
        if (this.serialNo.isEmpty()) {
            return false;
        }
        this.machineType = snmp.get(".1.3.6.1.4.1.21111.1.2.1.7");
        if (this.machineType.length() < 2) {
            this.machineType = "0" + this.machineType;
        }
        this.outputmode = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.11.9"));
        return true;
    }

    @Override
    public String getProtocolID() {
        return "P30PARAL";
    }

    @Override
    public RadioParameter getRadioParameter() {
        RadioParameter radioParameter = new RadioParameter();
        ArrayList<AutoRadioItem> list = new ArrayList<AutoRadioItem>();
        list.add(new AutoRadioItem("message.pepdA[:]", "message.enable", "message.disable", "{cappbility.isCapableA}", "CapableA", false));
        if (this.outputmode == 0 && !this.getAxpertType().startsWith("V") && !this.getAxpertType().startsWith("VM")) {
            list.add(new AutoRadioItem("message.powerSavingMode[:]", "message.enable", "message.disable", "{cappbility.isCapableJ}", "CapableJ", false));
        }
        list.add(new AutoRadioItem("message.backlight[:]", "message.enable", "message.disable", "{cappbility.isCapableX}", "CapableX", false));
        list.add(new AutoRadioItem("message.overLoadAutoRestart[:]", "message.enable", "message.disable", "{cappbility.isCapableU}", "CapableU", false));
        list.add(new AutoRadioItem("message.overTemperatureAutoRestart[:]", "message.enable", "message.disable", "{cappbility.isCapableV}", "CapableV", false));
        list.add(new AutoRadioItem("message.beepsWhileInterrupt[:]", "message.enable", "message.disable", "{cappbility.isCapableY}", "CapableY", false));
        list.add(new AutoRadioItem("message.overloadBypass[:]", "message.enable", "message.disable", "{cappbility.isCapableB}", "CapableB", false));
        list.add(new AutoRadioItem("message.lcdComeBackToDefaultAfter1min[:] ", "message.enable", "message.disable", "{cappbility.isCapableK}", "CapableK", false));
        if (this.outputmode == 1) {
            list.add(new AutoRadioItem("message.mustConnectedToPV[:]", "message.enable", "message.disable", "{configData.isAllpvok}", "setPPVOKC", false));
        }
        MachineInfo machineInfo = (MachineInfo)GlobalProcessors.getCurrentProcessor().getBeanBag().getBean("machineinfo");
        if (!(this.getAxpertType().startsWith("V") || this.getAxpertType().startsWith("VM") || 1000.0 <= machineInfo.getAcOutputRatingApparentPower() && machineInfo.getAcOutputRatingApparentPower() <= 3000.0 || this.getAxpertType().equals("") || this.getAxpertType().equals(" "))) {
            list.add(new AutoRadioItem("message.solarPowerBalance[:]", "message.enable", "message.disable", "{configData.isSolarbalance}", "setPSPB", false));
        }
        list.add(new AutoRadioItem("message.FaultCodeRecord[:]", "message.enable", "message.disable", "{cappbility.isCapableZ}", "CapableZ", false));
        radioParameter.setRadioParameterList(list);
        return radioParameter;
    }

    @Override
    public ComboBoxParameter getComboBoxParameter() {
        ConfigData config = new ConfigData();
        MachineInfo machineInfo = new MachineInfo();
        AbstractProcessor processor = GlobalProcessors.getCurrentProcessor();
        if (processor != null) {
            config = (ConfigData)processor.getBeanBag().getBean("configdata");
            machineInfo = (MachineInfo)processor.getBeanBag().getBean("machineinfo");
        }
        ComboBoxParameter comboBoxParameter = new ComboBoxParameter();
        ArrayList<AutoComboBoxItem> list = new ArrayList<AutoComboBoxItem>();
        if (this.getAxpertType().startsWith("VMIII")) {
            list.add(new AutoComboBoxItem("message.chargerSourcePriority[:]", new String[]{"Solar first", "Utility and Solar", "Solar only"}, "{configData.getChargerSource}", "", "ChargerSource", false));
        } else {
            list.add(new AutoComboBoxItem("message.chargerSourcePriority[:]", new String[]{"Utility", "Solar first", "Utility and Solar", "Solar only"}, "{configData.getChargerSource}", "", "PChargerSource", false));
        }
        list.add(new AutoComboBoxItem("message.outputSourcePriority[:]", new String[]{"Utility", "Solar", "SBU"}, "{configData.getOutputSource}", "", "OutputSource", false));
        list.add(new AutoComboBoxItem("message.acInputRange[:]", new String[]{"Appliance", "UPS"}, "{configData.getAcInputRange}", "", "ACInputRange", false));
        list.add(new AutoComboBoxItem("message.batteryType[:]", new String[]{"AGM", "Flooded", "User"}, "{configData.getBatteryType}", "", "BatteryType", false));
        if (!this.getAxpertType().startsWith("V")) {
            list.add(new AutoComboBoxItem("message.outputMode[:]", new String[]{"Single", "Parallel", "Phase R of 3 phase output", "Phase S of 3 phase output", "Phase T of 3 phase output"}, "{configData.getOutputMode}", "", "OutputMode", false));
        }
        list.add(new AutoComboBoxItem("message.outputFrequency[:]", new String[]{"50", "60"}, "{configData.getOutputFrequency}", "Hz", "OutputFrequency", false));
        if (this.axpert.equalsIgnoreCase("006") || this.axpert.equalsIgnoreCase("007")) {
            list.add(new AutoComboBoxItem("message.outputVoltage[:]", new String[]{"110", "120"}, "{configData.getOutputVoltage}", "V", "setPOPV", false));
        } else if (GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().startsWith("VMII")) {
            list.add(new AutoComboBoxItem("message.outputVoltage[:]", new String[]{"220", "230", "240"}, "{configData.getOutputVoltage}", "V", "setPOPV", false));
        } else if (!this.getAxpertType().startsWith("VP") && !this.getAxpertType().startsWith("VM")) {
            list.add(new AutoComboBoxItem("message.outputVoltage[:]", new String[]{"220", "230", "240"}, "{configData.getOutputVoltage}", "V", "setPOPV", false));
        }
        if (config.getBatteryVoltage() > 40.0) {
            list.add(new AutoComboBoxItem("message.backToGridVol[:]", new String[]{"44.0", "45.0", "46.0", "47.0", "48.0", "49.0", "50.0", "51.0"}, "{configData.getRechargeVoltage}", "V", "ReChargeVoltage", false));
        } else if (config.getBatteryVoltage() > 20.0) {
            list.add(new AutoComboBoxItem("message.backToGridVol[:]", new String[]{"22.0", "22.5", "23.0", "23.5", "24.0", "24.5", "25.0", "25.5"}, "{configData.getRechargeVoltage}", "V", "ReChargeVoltage", false));
        } else {
            list.add(new AutoComboBoxItem("message.backToGridVol[:]", new String[]{"11.0", "11.3", "11.5", "11.8", "12.0", "12.3", "12.5", "12.8"}, "{configData.getRechargeVoltage}", "V", "ReChargeVoltage", false));
        }
        list.add(new AutoComboBoxItem("message.maxChargingCurrent[:]", config.getMaxChargeCurrentCombox(machineInfo, this.outputmode), "{configData.getMaxChargeCurrentInt}", "A", "NPMaxChargeCurrent", false));
        list.add(new AutoComboBoxItem("message.maxAcChargingCurrent[:]", config.getAcChargingCurrentComBox(), "{configData.getMaxacchargingcurrentInt}", "A", "PMaxACChargeCurrent", false));
        if (config.getBatteryVoltage() > 40.0) {
            list.add(new AutoComboBoxItem("message.backToDischargeVol[:]", new String[]{"48.0", "49.0", "50.0", "51.0", "52.0", "53.0", "54.0", "55.0", "56.0", "57.0", "58.0", "FULL"}, "{configData.getReDischargeVoltage}", "V", "ReDisChargeVoltage", false));
        } else if (config.getBatteryVoltage() > 20.0) {
            list.add(new AutoComboBoxItem("message.backToDischargeVol[:]", new String[]{"24.0", "24.5", "25.0", "25.5", "26.0", "26.5", "27.0", "27.5", "28.0", "28.5", "29.0", "FULL"}, "{configData.getReDischargeVoltage}", "V", "ReDisChargeVoltage", false));
        } else {
            list.add(new AutoComboBoxItem("message.backToDischargeVol[:]", new String[]{"12.0", "12.3", "12.5", "12.8", "13.0", "13.3", "13.5", "13.8", "14.0", "14.3", "14.5", "FULL"}, "{configData.getReDischargeVoltage}", "V", "ReDisChargeVoltage", false));
        }
        comboBoxParameter.setComboBoxParameterList(list);
        return comboBoxParameter;
    }

    @Override
    public SpinnerParameter getSpinnerParameter() {
        SpinnerParameter spinnerParameter = new SpinnerParameter();
        ArrayList<AutoSpinnerItem> list = new ArrayList<AutoSpinnerItem>();
        AbstractProcessor processor = GlobalProcessors.getCurrentProcessor();
        MachineInfo machineInfo = null;
        if (processor != null) {
            machineInfo = (MachineInfo)processor.getBeanBag().getBean("machineinfo");
        }
        list.add(new AutoSpinnerItem("message.maxChargingVoltage[:]", "{configData.getMinMaxChargeVoltage}", "{configData.getMaxMaxChargeVoltage}", "0.1", "{configData.getMaxChargeVoltage}", "V", "setMaxChargingVoltage", false));
        list.add(new AutoSpinnerItem("message.maxFloatingVoltage[:]", "{configData.getMinFloatingChargeVoltage}", "{configData.getMaxFloatingChargeVoltage}", "0.1", "{configData.getFloatingChargeVoltage}", "V", "setFloatingVoltage", false));
        list.add(new AutoSpinnerItem("message.batteryCutoffVoltage[:]", "{configData.getMinBatteryUnder}", "{configData.getMaxBatteryUnder}", "0.1", "{configData.getBatteryUnder}", "V", "setBatteryCutoffVoltage", false));
        if (machineInfo.isSupportMaxCVTime()) {
            list.add(new AutoSpinnerItem("message.maxCVChargingTime[:]", "{configData.getMinChargingTimeInCVStage}", "{configData.getMaxChargingTimeInCVStage}", "5", "{configData.getChargingTimeInCVStage}", "message.minitue", "setPCVT", false));
        }
        spinnerParameter.setSpinnerParameterList(list);
        return spinnerParameter;
    }

    @Override
    public RestoreInfo getResotreInfo() {
        RestoreInfo restoreInfo = new RestoreInfo();
        ArrayList<AutoLabelItem> infos = new ArrayList<AutoLabelItem>();
        infos.add(new AutoLabelItem("message.acOutputFre[:]", "{defaultData.getAcOutputFrequency}", "Hz"));
        infos.add(new AutoLabelItem("message.maxChargingVoltage[:]", "{defaultData.getMaxChargingVoltage}", "V"));
        infos.add(new AutoLabelItem("message.maxFloatingVoltage[:]", "{defaultData.getFloatChargingVoltage}", "V"));
        infos.add(new AutoLabelItem("message.maxChargingCurrent[:]", "{defaultData.getMaxChargingCurrent}", "A"));
        infos.add(new AutoLabelItem("message.maxAcChargingCurrent[:]", "{defaultData.getMaxACChargingCurrent}", "A"));
        infos.add(new AutoLabelItem("message.batteryCutoffVoltage[:]", "{defaultData.getBatteryCutoffVoltage}", "V"));
        infos.add(new AutoLabelItem("message.backToDischargeVol[:]", "{defaultData.getReDischargeVoltage}", "V"));
        infos.add(new AutoLabelItem("message.backToGridVol[:]", "{defaultData.getReChangingVoltage}", "V"));
        if (this.axpert.equals("012") || this.axpert.equals("013")) {
            infos.add(new AutoLabelItem("message.maxCVChargingTime[:]", "{defaultData.getChargingTimeInCVStage}", "message.minitue"));
        }
        if (!this.getAxpertType().startsWith("V")) {
            infos.add(new AutoLabelItem("message.outputMode[:]", "{defaultData.getOutputMode}", " "));
        }
        infos.add(new AutoLabelItem("message.acInputVoltageRange[:]", "{defaultData.getAcInputVoltage}", ""));
        infos.add(new AutoLabelItem("message.outputSourcePriority[:]", "{defaultData.getOutputSourcePriority}", ""));
        infos.add(new AutoLabelItem("message.chargerSourcePriority[:]", "{defaultData.getChargerSourcePriority}", ""));
        infos.add(new AutoLabelItem("message.batteryType[:]", "{defaultData.getBatteryType}", ""));
        infos.add(new AutoLabelItem("message.enableDisablebuzzer[:]", "{defaultData.getCapableA}", ""));
        if (this.outputmode == 0 && !this.getAxpertType().startsWith("VP") && !this.getAxpertType().startsWith("VM")) {
            infos.add(new AutoLabelItem("message.enableDisablePowerSaving[:]", "{defaultData.getCapableJ}", ""));
        }
        infos.add(new AutoLabelItem("message.enableDisableOverloadRestart[:]", "{defaultData.getCapableU}", ""));
        infos.add(new AutoLabelItem("message.enableDisableOverTempRestart[:]", "{defaultData.getCapableV}", ""));
        infos.add(new AutoLabelItem("message.enableDisableLcdBacklightOn[:]", "{defaultData.getCapableX}", ""));
        infos.add(new AutoLabelItem("message.enableDisableAlarmOn[:]", "{defaultData.getCapableY}", ""));
        infos.add(new AutoLabelItem("message.enableDisableLcdComeBack[:]", "{defaultData.getCapableK}", ""));
        infos.add(new AutoLabelItem("message.enableDisableOverloadBypass[:]", "{defaultData.getCapableB}", ""));
        infos.add(new AutoLabelItem("message.FaultCodeRecord[:]", "{defaultData.getCapableZ}", ""));
        restoreInfo.setInfos(infos);
        return restoreInfo;
    }

    @Override
    public AutoMenuList getMenuList() {
        AutoMenuList menuList = new AutoMenuList();
        ArrayList<AutoMenuOne> menus = new ArrayList<AutoMenuOne>();
        ArrayList<AutoMenuTwo> items1 = new ArrayList<AutoMenuTwo>();
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.baseSet", 101, ""), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.passwordSet", 102, ""), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.smsinfoSet", 104, ""), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.emailSet", 105, ""), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.electricEventSet", 106, ""), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.setcom", 107, ""), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.modbussetting", 108, ""), null));
        ArrayList<AutoMenuTwo> items2 = new ArrayList<AutoMenuTwo>();
        items2.add(new AutoMenuTwo(new AutoMenuItem("message.parametersSetting", 201, ""), null));
        items2.add(new AutoMenuTwo(new AutoMenuItem("message.factoryReset", 202, ""), null));
        ArrayList<AutoMenuTwo> items3 = new ArrayList<AutoMenuTwo>();
        items3.add(new AutoMenuTwo(new AutoMenuItem("message.queryData", 302, ""), null));
        items3.add(new AutoMenuTwo(new AutoMenuItem("message.queryEvent", 304, ""), null));
        items3.add(new AutoMenuTwo(new AutoMenuItem("message.queryFaultData", 303, ""), null));
        ArrayList<AutoMenuTwo> items4 = new ArrayList<AutoMenuTwo>();
        items4.add(new AutoMenuTwo(new AutoMenuItem("English", 401, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("French", 402, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("German", 403, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Polish", 405, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Spanish", 408, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Chinese(Simplified)", 411, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Chinese(Traditional)", 412, "radio"), null));
        ArrayList<AutoMenuTwo> items5 = new ArrayList<AutoMenuTwo>();
        items5.add(new AutoMenuTwo(new AutoMenuItem("message.about", 501, ""), null));
        ArrayList<AutoMenuItem> items = new ArrayList<AutoMenuItem>();
        CustomerConfig custormerConfig = GlobalVariables.customerConfig;
        if (custormerConfig.isEnglish()) {
            items.add(new AutoMenuItem("English", 5021, ""));
        }
        if (custormerConfig.isTurkish()) {
            items.add(new AutoMenuItem("Turkish", 5022, ""));
        }
        if (custormerConfig.isRussian()) {
            items.add(new AutoMenuItem("Russian", 5023, ""));
        }
        if (items.size() < 2) {
            items = null;
        }
        items5.add(new AutoMenuTwo(new AutoMenuItem("message.onlineHelp", 502, ""), items));
        menus.add(new AutoMenuOne("[" + GlobalVariables.customerConfig.getCustomerName() + "]" + "message.pvConfig", 1, items1));
        menus.add(new AutoMenuOne("message.pvControl", 2, items2));
        menus.add(new AutoMenuOne("message.pvView", 3, items3));
        menus.add(new AutoMenuOne("message.language", 4, items4));
        menus.add(new AutoMenuOne("message.help", 5, items5));
        menuList.setMenuList(menus);
        return menuList;
    }
}

