/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.protocol;

import cn.com.voltronic.solar.communicate.IComUSBHandler;
import cn.com.voltronic.solar.communicate.SNMPHandler;
import cn.com.voltronic.solar.configure.CustomerConfig;
import cn.com.voltronic.solar.data.bean.AutoComboBoxItem;
import cn.com.voltronic.solar.data.bean.AutoLabelItem;
import cn.com.voltronic.solar.data.bean.AutoMenuItem;
import cn.com.voltronic.solar.data.bean.AutoMenuList;
import cn.com.voltronic.solar.data.bean.AutoMenuOne;
import cn.com.voltronic.solar.data.bean.AutoMenuTwo;
import cn.com.voltronic.solar.data.bean.AutoRadioItem;
import cn.com.voltronic.solar.data.bean.AutoSpinnerItem;
import cn.com.voltronic.solar.data.bean.BaseInfo;
import cn.com.voltronic.solar.data.bean.ComboBoxParameter;
import cn.com.voltronic.solar.data.bean.ConfigData;
import cn.com.voltronic.solar.data.bean.HistoryChart;
import cn.com.voltronic.solar.data.bean.HistoryData;
import cn.com.voltronic.solar.data.bean.HistoryDataChartColumns;
import cn.com.voltronic.solar.data.bean.HistoryDataColumns;
import cn.com.voltronic.solar.data.bean.HistoryFaultDataColumns;
import cn.com.voltronic.solar.data.bean.MachineInfo;
import cn.com.voltronic.solar.data.bean.ProductInfo;
import cn.com.voltronic.solar.data.bean.RadioParameter;
import cn.com.voltronic.solar.data.bean.RatingInfo;
import cn.com.voltronic.solar.data.bean.RestoreInfo;
import cn.com.voltronic.solar.data.bean.SpinnerParameter;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.protocol.P30;
import cn.com.voltronic.solar.system.GlobalProcessors;
import cn.com.voltronic.solar.system.GlobalVariables;
import cn.com.voltronic.solar.util.VolUtil;
import java.util.ArrayList;

public class P30PlusDuo
extends P30 {
    @Override
    public boolean matchProtocol(Object handler) {
        if (handler instanceof IComUSBHandler) {
            return this.matchComUSB((IComUSBHandler)handler);
        }
        if (handler instanceof SNMPHandler) {
            return this.matchSnmp((SNMPHandler)handler);
        }
        return false;
    }

    @Override
    public boolean matchComUSB(IComUSBHandler _handler) {
        String dataStr = "(NAK";
        int i = 0;
        while (i < 2) {
            if (!this.isEmpty(dataStr)) break;
            try {
                dataStr = _handler.excuteSimpleCommand("QPI");
            }
            catch (Exception e) {
                return false;
            }
            ++i;
        }
        if (dataStr.startsWith("(PI") && dataStr.endsWith("30") && this instanceof P30PlusDuo) {
            String qgmn = _handler.excuteSimpleCommand("QGMN");
            if (!this.isStandardModel(qgmn) && !this.isPlus_PF1(qgmn)) {
                return false;
            }
            String qpiri = _handler.excuteSimpleCommand("QPIRI");
            if (this.isEmpty(qpiri)) {
                return false;
            }
            String[] item = qpiri.split(" ");
            this.machineType = item[19];
            if (!this.machineType.equals("11")) {
                return false;
            }
            String serialNoStr = _handler.getSerialNo();
            if (this.isEmpty(serialNoStr)) {
                return false;
            }
            this.serialNo = serialNoStr;
            this.outputmode = VolUtil.parseInt(item[21]);
            return true;
        }
        return false;
    }

    @Override
    public boolean matchSnmp(SNMPHandler snmp) {
        String qpi = snmp.get(".1.3.6.1.4.1.21111.1.2.1.2");
        if (!qpi.equals("30")) {
            return false;
        }
        this.machineType = snmp.get(".1.3.6.1.4.1.21111.1.2.1.7");
        if (!this.machineType.equals("11")) {
            return false;
        }
        this.serialNo = snmp.getSerialNo();
        if ("".equals(this.serialNo)) {
            return false;
        }
        this.outputmode = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.11.9"));
        return true;
    }

    @Override
    public String getProtocolID() {
        return "P30PLUSDUO";
    }

    @Override
    public int getMpptTrackNumber() {
        return 2;
    }

    @Override
    public BaseInfo getBaseInfo() {
        BaseInfo baseInfo = new BaseInfo();
        ArrayList<AutoLabelItem> item = new ArrayList<AutoLabelItem>();
        item.add(new AutoLabelItem("message.pvInputVoltage1[:]", "{workInfo.getPvInputVoltage1}", "V"));
        item.add(new AutoLabelItem("message.pvInputPower1[:]", "{workInfo.getPvInputPower1}", "W"));
        item.add(new AutoLabelItem("message.pvInputVoltage2[:]", "{workInfo.getPvInputVoltage2}", "V"));
        item.add(new AutoLabelItem("message.pvInputPower2[:]", "{workInfo.getPvInputPower2}", "W"));
        item.add(new AutoLabelItem("message.acVoltage[:]", "{workInfo.getGridVoltageR}", "V"));
        if (this.outputmode == 0) {
            item.add(new AutoLabelItem("message.ACChargingPower[:]", "{workInfo.getGridPowerR}", "W"));
        }
        item.add(new AutoLabelItem("message.acFrequency[:]", "{workInfo.getGridFrequency}", "Hz"));
        item.add(new AutoLabelItem("message.batteryVoltage[:]", "{workInfo.getPBatteryVoltage}", "V"));
        item.add(new AutoLabelItem("message.batteryCapacity[:]", "{workInfo.getBatteryCapacity}", "%"));
        if (this.getAxpertType().equals("VM-1000") || this.getAxpertType().equals("VM-1200") || this.getAxpertType().equals("VM-2000") || this.getAxpertType().equals("VM-2200") || this.getAxpertType().equals("VM-3200") || this.getAxpertType().equals("VM-3000") || this.getAxpertType().equals("VP-1000") || this.getAxpertType().equals("VP-2000") || this.getAxpertType().equals("VP-3000")) {
            item.add(new AutoLabelItem("message.pvInputCurrent[:]", "{workInfo.getChargingCurrent}", "A"));
        } else {
            item.add(new AutoLabelItem("message.chargeCurrent[:]", "{workInfo.getChargingCurrent}", "A"));
        }
        item.add(new AutoLabelItem("message.batdiscurrent[:]", "{workInfo.getBatDisCurrent}", "A"));
        item.add(new AutoLabelItem("message.outputVoltage[:]", "{workInfo.getAcOutputVoltageR}", "V"));
        item.add(new AutoLabelItem("message.outputFrequency[:]", "{workInfo.getAcOutputFrequency}", "Hz"));
        item.add(new AutoLabelItem("message.outputapppower[:]", "{workInfo.getAcOutputApparentPower}", "VA"));
        item.add(new AutoLabelItem("message.outputactpower[:]", "{workInfo.getAcOutputActivePower}", "W"));
        item.add(new AutoLabelItem("message.loadpercent[:]", "{workInfo.getOutputLoadPercent}", "%"));
        if (this.outputmode == 1) {
            item.add(new AutoLabelItem("message.totalchargingcurrent[:]", "{workInfo.getTtlChargingCurrent}", "A"));
            item.add(new AutoLabelItem("message.totaloutputapparentpower[:]", "{workInfo.getAcTtlOutputApparentPower}", "VA"));
            item.add(new AutoLabelItem("message.totaloutputactivepower[:]", "{workInfo.getAcTtlOutputActivePower}", "W"));
            item.add(new AutoLabelItem("message.totaloutputpercent[:]", "{workInfo.getAcTtlOutputPercent}", "%"));
        }
        baseInfo.setBaseInfoList(item);
        return baseInfo;
    }

    @Override
    public HistoryDataColumns getHistoryColumns() {
        HistoryDataColumns columns = new HistoryDataColumns();
        ArrayList<HistoryData> list = new ArrayList<HistoryData>();
        list.add(new HistoryData("message.workMode", "{workInfo.getWorkMode}", true, false));
        list.add(new HistoryData("message.time", "{workInfo.getCurrentTime}", true, false));
        list.add(new HistoryData("message.pvInputVoltage1", "{workInfo.getPvInputVoltage1}", true, true));
        list.add(new HistoryData("message.pvInputCurrent1", "{workInfo.getPvInputCurrent1}", true, true));
        list.add(new HistoryData("message.pvInputPower1", "{workInfo.getPvInputPower1}", true, true));
        list.add(new HistoryData("message.pvInputVoltage2", "{workInfo.getPvInputVoltage2}", true, true));
        list.add(new HistoryData("message.pvInputCurrent2", "{workInfo.getPvInputCurrent2}", true, true));
        list.add(new HistoryData("message.pvInputPower2", "{workInfo.getPvInputPower2}", true, true));
        list.add(new HistoryData("message.acVoltage", "{workInfo.getGridVoltageR}", true, true));
        list.add(new HistoryData("message.acFrequency", "{workInfo.getGridFrequency}", true, true));
        if (this.outputmode == 0) {
            list.add(new HistoryData("message.ACChargingCurrent", "{workInfo.getGridCurrentR}", true, true));
            list.add(new HistoryData("message.ACChargingPower", "{workInfo.getGridPowerR}", true, true));
        }
        list.add(new HistoryData("message.outputapppower", "{workInfo.getAcOutputApparentPower}", true, true));
        list.add(new HistoryData("message.outputactpower", "{workInfo.getAcOutputActivePower}", true, true));
        list.add(new HistoryData("message.batteryVoltage", "{workInfo.getPBatteryVoltage}", true, true));
        list.add(new HistoryData("message.batteryCapacity", "{workInfo.getBatteryCapacity}", true, true));
        if (GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VM-1000") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VM-1200") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VM-2000") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VM-2200") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VM-3200") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VM-3000") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VP-1000") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VP-2000") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VP-3000")) {
            list.add(new HistoryData("message.pvInputCurrent", "{workInfo.getChargingCurrent}", true, true));
        } else {
            list.add(new HistoryData("message.chargeCurrent", "{workInfo.getChargingCurrent}", true, true));
        }
        list.add(new HistoryData("message.batdiscurrent", "{workInfo.getBatDisCurrent}", true, true));
        if (!this.getAxpertType().startsWith("VP") && !this.getAxpertType().startsWith("VM")) {
            list.add(new HistoryData("message.outputVoltage", "{workInfo.getAcOutputVoltageR}", true, true));
        }
        list.add(new HistoryData("message.outputFrequency", "{workInfo.getAcOutputFrequency}", true, true));
        if (this.outputmode == 1) {
            list.add(new HistoryData("message.totalchargingcurrent", "{workInfo.getTtlChargingCurrent}", true, true));
            list.add(new HistoryData("message.totaloutputapparentpower", "{workInfo.getAcTtlOutputApparentPower}", true, true));
            list.add(new HistoryData("message.totaloutputactivepower", "{workInfo.getAcTtlOutputActivePower}", true, true));
            list.add(new HistoryData("message.totaloutputpercent", "{workInfo.getAcTtlOutputPercent}", true, true));
        }
        columns.setColumns(list);
        return columns;
    }

    @Override
    public HistoryDataChartColumns getHistoryChartColumns() {
        HistoryDataChartColumns columns = new HistoryDataChartColumns();
        ArrayList<HistoryChart> list = new ArrayList<HistoryChart>();
        list.add(new HistoryChart("message.pvInputVoltage1", "{workInfo.getPvInputVoltage1}", 200.0, "V", true));
        list.add(new HistoryChart("message.pvInputCurrent1", "{workInfo.getPvInputCurrent1}", 200.0, "A", true));
        list.add(new HistoryChart("message.pvInputPower1", "{workInfo.getPvInputPower1}", 3000.0, "W", true));
        list.add(new HistoryChart("message.pvInputVoltage2", "{workInfo.getPvInputVoltage2}", 200.0, "V", true));
        list.add(new HistoryChart("message.pvInputCurrent2", "{workInfo.getPvInputCurrent2}", 200.0, "A", true));
        list.add(new HistoryChart("message.pvInputPower2", "{workInfo.getPvInputPower2}", 3000.0, "W", true));
        list.add(new HistoryChart("message.acVoltage", "{workInfo.getGridVoltageR}", 300.0, "V", true));
        list.add(new HistoryChart("message.acFrequency", "{workInfo.getGridFrequency}", 70.0, "Hz", true));
        if (this.outputmode == 0) {
            list.add(new HistoryChart("message.ACChargingCurrent", "{workInfo.getGridCurrentR}", 100.0, "A", true));
            list.add(new HistoryChart("message.ACChargingPower", "{workInfo.getGridPowerR}", 2000.0, "W", true));
        }
        list.add(new HistoryChart("message.outputapppower", "{workInfo.getAcOutputApparentPower}", 3000.0, "VA", true));
        list.add(new HistoryChart("message.outputactpower", "{workInfo.getAcOutputActivePower}", 3000.0, "W", true));
        list.add(new HistoryChart("message.batteryVoltage", "{workInfo.getPBatteryVoltage}", 100.0, "V", true));
        list.add(new HistoryChart("message.batteryCapacity", "{workInfo.getBatteryCapacity}", 100.0, "%", true));
        if (GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VM-1000") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VM-1200") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VM-2000") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VM-2200") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VM-3200") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VM-3000") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VP-1000") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VP-2000") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VP-3000")) {
            list.add(new HistoryChart("message.pvInputCurrent", "{workInfo.getChargingCurrent}", 250.0, "A", true));
        } else {
            list.add(new HistoryChart("message.chargeCurrent", "{workInfo.getChargingCurrent}", 250.0, "A", true));
        }
        list.add(new HistoryChart("message.batdiscurrent", "{workInfo.getBatDisCurrent}", 150.0, "A", true));
        if (!this.getAxpertType().startsWith("VP") && !this.getAxpertType().startsWith("VM")) {
            list.add(new HistoryChart("message.outputVoltage", "{workInfo.getAcOutputVoltageR}", 300.0, "V", true));
        }
        list.add(new HistoryChart("message.outputFrequency", "{workInfo.getAcOutputFrequency}", 70.0, "Hz", true));
        if (this.outputmode == 1) {
            list.add(new HistoryChart("message.totalchargingcurrent", "{workInfo.getTtlChargingCurrent}", 100.0, "A", true));
            list.add(new HistoryChart("message.totaloutputapparentpower", "{workInfo.getAcTtlOutputApparentPower}", 20000.0, "VA", true));
            list.add(new HistoryChart("message.totaloutputactivepower", "{workInfo.getAcTtlOutputActivePower}", 20000.0, "W", true));
            list.add(new HistoryChart("message.totaloutputpercent", "{workInfo.getAcTtlOutputPercent}", 100.0, "%", true));
        }
        columns.setColumns(list);
        return columns;
    }

    @Override
    public RadioParameter getRadioParameter() {
        AbstractProcessor processor = GlobalProcessors.getCurrentProcessor();
        MachineInfo machineInfo = null;
        if (processor != null) {
            machineInfo = (MachineInfo)processor.getBeanBag().getBean("machineinfo");
        }
        RadioParameter radioParameter = new RadioParameter();
        ArrayList<AutoRadioItem> list = new ArrayList<AutoRadioItem>();
        list.add(new AutoRadioItem("message.pepdA[:]", "message.enable", "message.disable", "{cappbility.isCapableA}", "CapableA", false));
        list.add(new AutoRadioItem("message.overTemperatureAutoRestart[:]", "message.enable", "message.disable", "{cappbility.isCapableV}", "CapableV", false));
        list.add(new AutoRadioItem("message.overloadBypass[:]", "message.enable", "message.disable", "{cappbility.isCapableB}", "CapableB", false));
        list.add(new AutoRadioItem("message.overLoadAutoRestart[:]", "message.enable", "message.disable", "{cappbility.isCapableU}", "CapableU", false));
        if (!this.getAxpertType().startsWith("V") && !this.getAxpertType().startsWith("VM")) {
            list.add(new AutoRadioItem("message.powerSavingMode[:]", "message.enable", "message.disable", "{cappbility.isCapableJ}", "CapableJ", false));
        }
        list.add(new AutoRadioItem("message.lcdComeBackToDefaultAfter1min[:]", "message.enable", "message.disable", "{cappbility.isCapableK}", "CapableK", false));
        list.add(new AutoRadioItem("message.beepsWhileInterrupt[:]", "message.enable", "message.disable", "{cappbility.isCapableY}", "CapableY", false));
        list.add(new AutoRadioItem("message.backlight[:]", "message.enable", "message.disable", "{cappbility.isCapableX}", "CapableX", false));
        if (!(!this.is1200or5200(machineInfo) || this.getAxpertType().startsWith("V") || this.getAxpertType().startsWith("VM") || 1000.0 <= machineInfo.getAcOutputRatingApparentPower() && machineInfo.getAcOutputRatingApparentPower() <= 3000.0 || this.getAxpertType().equals("") || this.getAxpertType().equals(" "))) {
            list.add(new AutoRadioItem("message.solarPowerBalance[:]", "message.enable", "message.disable", "{configData.isSolarbalance}", "setPSPB", false));
        }
        list.add(new AutoRadioItem("message.FaultCodeRecord[:]", "message.enable", "message.disable", "{cappbility.isCapableZ}", "CapableZ", false));
        radioParameter.setRadioParameterList(list);
        return radioParameter;
    }

    @Override
    public ComboBoxParameter getComboBoxParameter() {
        AbstractProcessor processor = GlobalProcessors.getCurrentProcessor();
        MachineInfo machineInfo = null;
        ConfigData config = null;
        if (processor != null) {
            machineInfo = (MachineInfo)processor.getBeanBag().getBean("machineinfo");
            config = (ConfigData)processor.getBeanBag().getBean("configdata");
        }
        ComboBoxParameter comboBoxParameter = new ComboBoxParameter();
        ArrayList<AutoComboBoxItem> list = new ArrayList<AutoComboBoxItem>();
        if (this.is1200or5200(machineInfo)) {
            if (this.getAxpertType().startsWith("VMIII")) {
                list.add(new AutoComboBoxItem("message.chargerSourcePriority[:]", new String[]{"Solar first", "Utility and Solar", "Solar only"}, "{configData.getChargerSource}", "", "ChargerSource", false));
            } else {
                list.add(new AutoComboBoxItem("message.chargerSourcePriority[:]", new String[]{"Utility", "Solar first", "Utility and Solar", "Solar only"}, "{configData.getChargerSource}", "", "PChargerSource", false));
            }
        } else if (this.outputmode == 0) {
            if (this.getAxpertType().startsWith("VMIII")) {
                list.add(new AutoComboBoxItem("message.chargerSourcePriority[:]", new String[]{"Solar first", "Utility and Solar", "Solar only"}, "{configData.getChargerSource}", "", "ChargerSource", false));
            } else if (this.is1K3KV15_33or1_18above(machineInfo)) {
                list.add(new AutoComboBoxItem("message.chargerSourcePriority[:]", new String[]{"Utility", "Solar first", "Utility and Solar", "Solar only"}, "{configData.getChargerSource}", "", "ChargerSource", false));
            } else {
                list.add(new AutoComboBoxItem("message.chargerSourcePriority[:]", new String[]{"Utility", "Solar first", "Utility and Solar"}, "{configData.getChargerSource}", "", "ChargerSource", false));
            }
        }
        if (this.is5KwV1_12orBelow(machineInfo)) {
            list.add(new AutoComboBoxItem("message.outputSourcePriority[:]", new String[]{"Utility", "Solar"}, "{configData.getOutputSource}", "", "OutputSource", false));
        } else if (this.outputmode == 0) {
            list.add(new AutoComboBoxItem("message.outputSourcePriority[:]", new String[]{"Utility", "Solar", "SBU"}, "{configData.getOutputSource}", "", "OutputSource", false));
        } else if (this.is1200or5200(machineInfo)) {
            list.add(new AutoComboBoxItem("message.outputSourcePriority[:]", new String[]{"Utility", "SBU"}, "{configData.getOutputSource}", "", "OutputSource", false));
        } else {
            list.add(new AutoComboBoxItem("message.outputSourcePriority[:]", new String[]{"Utility"}, "{configData.getOutputSource}", "", "OutputSource", false));
        }
        list.add(new AutoComboBoxItem("message.acInputRange[:]", new String[]{"Appliance", "UPS"}, "{configData.getAcInputRange}", "", "ACInputRange", false));
        if (!P30PlusDuo.is4k5kwV11_00orabove(machineInfo)) {
            if (this.is1K3KV15_50or2_20above(machineInfo)) {
                list.add(new AutoComboBoxItem("message.batteryType[:]", new String[]{"AGM", "Flooded", "User"}, "{configData.getBatteryType}", "", "BatteryType", false));
            } else {
                list.add(new AutoComboBoxItem("message.batteryType[:]", new String[]{"AGM", "Flooded"}, "{configData.getBatteryType}", "", "BatteryType", false));
            }
        } else {
            list.add(new AutoComboBoxItem("message.batteryType[:]", new String[]{"AGM", "Flooded", "User"}, "{configData.getBatteryType}", "", "BatteryType", false));
            if (!this.getAxpertType().startsWith("V")) {
                list.add(new AutoComboBoxItem("message.outputMode[:]", new String[]{"Single", "Parallel", "Phase R of 3 phase output", "Phase S of 3 phase output", "Phase T of 3 phase output"}, "{configData.getOutputMode}", "", "OutputMode", false));
            }
        }
        list.add(new AutoComboBoxItem("message.outputFrequency[:]", new String[]{"50", "60"}, "{configData.getOutputFrequency}", "Hz", "OutputFrequency", false));
        if (P30PlusDuo.is1to3k(machineInfo.getAcOutputRatingApparentPower())) {
            if (this.getAxpertType().startsWith("VP") || this.getAxpertType().startsWith("VM")) {
                if (GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().startsWith("VMII")) {
                    list.add(new AutoComboBoxItem("message.outputVoltage[:]", new String[]{"220", "230", "240"}, "{configData.getOutputVoltage}", "V", "OutputVoltage", false));
                }
            } else {
                list.add(new AutoComboBoxItem("message.outputVoltage[:]", new String[]{"220", "230", "240"}, "{configData.getOutputVoltage}", "V", "OutputVoltage", false));
            }
        } else if (P30PlusDuo.is4to5k(machineInfo.getAcOutputRatingApparentPower()) && !this.getAxpertType().startsWith("VP") && !this.getAxpertType().startsWith("VM")) {
            list.add(new AutoComboBoxItem("message.outputVoltage[:]", new String[]{"220", "230", "240"}, "{configData.getOutputVoltage}", "V", "setPOPV", false));
        }
        if (processor != null && machineInfo != null && config != null) {
            if (!this.is5KwV1_12orBelow(machineInfo)) {
                if (this.is1210or5210(machineInfo)) {
                    if (config.getBatteryVoltage() > 40.0) {
                        list.add(new AutoComboBoxItem("message.backToGridVol[:]", new String[]{"44.0", "45.0", "46.0", "47.0", "48.0", "49.0", "50.0", "51.0"}, "{configData.getRechargeVoltage}", "V", "ReChargeVoltage", false));
                    } else if (config.getBatteryVoltage() > 20.0) {
                        list.add(new AutoComboBoxItem("message.backToGridVol[:]", new String[]{"22.0", "22.5", "23.0", "23.5", "24.0", "24.5", "25.0", "25.5"}, "{configData.getRechargeVoltage}", "V", "ReChargeVoltage", false));
                    } else {
                        list.add(new AutoComboBoxItem("message.backToGridVol[:]", new String[]{"11.0", "11.3", "11.5", "11.8", "12.0", "12.3", "12.5", "12.8"}, "{configData.getRechargeVoltage}", "V", "ReChargeVoltage", false));
                    }
                } else if (config.getBatteryVoltage() > 40.0) {
                    list.add(new AutoComboBoxItem("message.backToGridVolForSBUPriority[:]", new String[]{"44.0", "45.0", "46.0", "47.0", "48.0", "49.0", "50.0", "51.0"}, "{configData.getRechargeVoltage}", "V", "ReChargeVoltage", false));
                } else if (config.getBatteryVoltage() > 20.0) {
                    list.add(new AutoComboBoxItem("message.backToGridVolForSBUPriority[:]", new String[]{"22.0", "22.5", "23.0", "23.5", "24.0", "24.5", "25.0", "25.5"}, "{configData.getRechargeVoltage}", "V", "ReChargeVoltage", false));
                } else {
                    list.add(new AutoComboBoxItem("message.backToGridVolForSBUPriority[:]", new String[]{"11.0", "11.3", "11.5", "11.8", "12.0", "12.3", "12.5", "12.8"}, "{configData.getRechargeVoltage}", "V", "ReChargeVoltage", false));
                }
            }
            if (this.is1227or5227(machineInfo)) {
                list.add(new AutoComboBoxItem("message.maxChargingCurrent[:]", config.getMaxChargeCurrentCombox(machineInfo, this.outputmode), "{configData.getMaxChargeCurrentInt}", "A", "NPMaxChargeCurrent", false));
            } else {
                list.add(new AutoComboBoxItem("message.maxChargingCurrent[:]", config.getMaxChargeCurrentCombox(machineInfo, this.outputmode), "{configData.getMaxChargeCurrentInt}", "A", "PMaxChargeCurrent", false));
            }
            list.add(new AutoComboBoxItem("message.maxAcChargingCurrent[:]", config.getAcChargingCurrentComBox(), "{configData.getMaxacchargingcurrentInt}", "A", "PMaxACChargeCurrent", false));
            if (this.is1210or5210(machineInfo)) {
                if (config.getBatteryVoltage() > 40.0) {
                    list.add(new AutoComboBoxItem("message.backToDischargeVol[:]", new String[]{"48.0", "49.0", "50.0", "51.0", "52.0", "53.0", "54.0", "55.0", "56.0", "57.0", "58.0", "FULL"}, "{configData.getReDischargeVoltage}", "V", "ReDisChargeVoltage", false));
                } else if (config.getBatteryVoltage() > 20.0) {
                    list.add(new AutoComboBoxItem("message.backToDischargeVol[:]", new String[]{"24.0", "24.5", "25.0", "25.5", "26.0", "26.5", "27.0", "27.5", "28.0", "28.5", "29.0", "FULL"}, "{configData.getReDischargeVoltage}", "V", "ReDisChargeVoltage", false));
                } else {
                    list.add(new AutoComboBoxItem("message.backToDischargeVol[:]", new String[]{"12.0", "12.3", "12.5", "12.8", "13.0", "13.3", "13.5", "13.8", "14.0", "14.3", "14.5", "FULL"}, "{configData.getReDischargeVoltage}", "V", "ReDisChargeVoltage", false));
                }
            }
        }
        if (P30PlusDuo.is1to3k(machineInfo.getAcOutputRatingApparentPower())) {
            list.add(new AutoComboBoxItem("message.MaxSolarChargingCurrent[:]", config.getMaxSolarChargingCurrentCombox(), "0", "A", "MSCHGC", false));
            list.add(new AutoComboBoxItem("message.ChargingStage[:]", new String[]{"Auto", "2-stage", "3-stage"}, "{configData.getChargingStage}", "", "PCST", false));
            list.add(new AutoComboBoxItem("message.ChargingTimeInCVMode[:]", new String[]{"000", "010", "020", "040", "060", "090", "120", "150", "180", "210", "240", "Auto"}, "{configData.getChargingTimeInCvMode}", "message.minitue", "PCVT", false));
        }
        comboBoxParameter.setComboBoxParameterList(list);
        return comboBoxParameter;
    }

    @Override
    public RestoreInfo getResotreInfo() {
        MachineInfo machineInfo;
        RestoreInfo restoreInfo = new RestoreInfo();
        ArrayList<AutoLabelItem> infos = new ArrayList<AutoLabelItem>();
        infos.add(new AutoLabelItem("message.chargerSourcePriority[:]", "{defaultData.getChargerSourcePriority}", ""));
        infos.add(new AutoLabelItem("message.outputSourcePriority[:]", "{defaultData.getOutputSourcePriority}", ""));
        infos.add(new AutoLabelItem("message.acInputVoltageRange[:]", "{defaultData.getAcInputVoltage}", ""));
        infos.add(new AutoLabelItem("message.batteryType[:]", "{defaultData.getBatteryType}", ""));
        infos.add(new AutoLabelItem("message.acOutputFre[:]", "{defaultData.getAcOutputFrequency}", "Hz"));
        if (!this.getAxpertType().startsWith("VP") && !this.getAxpertType().startsWith("VM")) {
            infos.add(new AutoLabelItem("message.outputVoltage[:]", "{defaultData.getAcOutputVoltage}", "V"));
        }
        infos.add(new AutoLabelItem("message.backToGridVol[:]", "{defaultData.getReChangingVoltage}", "V"));
        infos.add(new AutoLabelItem("message.maxChargingCurrent[:]", "{defaultData.getMaxChargingCurrent}", "A"));
        infos.add(new AutoLabelItem("message.maxAcChargingCurrent[:]", "{defaultData.getMaxACChargingCurrent}", "A"));
        infos.add(new AutoLabelItem("message.backToDischargeVol[:]", "{defaultData.getReDischargeVoltage}", "V"));
        AbstractProcessor processor = GlobalProcessors.getCurrentProcessor();
        if (processor != null && (machineInfo = (MachineInfo)processor.getBeanBag().getBean("machineinfo")) != null && P30PlusDuo.is1to3k(machineInfo.getAcOutputRatingApparentPower())) {
            infos.add(new AutoLabelItem("message.MaxSolarChargingCurrent[:]", "{defaultData.getMaxSolarChargingCurrent}", "A"));
            infos.add(new AutoLabelItem("message.ChargingStage[:]", "{defaultData.getChargingStage}", ""));
            infos.add(new AutoLabelItem("message.ChargingTimeInCVMode[:]", "{defaultData.getChargingTimeInCvMode}", "message.minitue"));
            infos.add(new AutoLabelItem("message.maxChargingVoltage[:]", "{defaultData.getMaxChargingVoltage}", "V"));
        }
        infos.add(new AutoLabelItem("message.maxFloatingVoltage[:]", "{defaultData.getFloatChargingVoltage}", "V"));
        infos.add(new AutoLabelItem("message.batteryCutoffVoltage[:]", "{defaultData.getBatteryCutoffVoltage}", "V"));
        infos.add(new AutoLabelItem("message.enableDisablebuzzer[:]", "{defaultData.getCapableA}", ""));
        if (!this.getAxpertType().startsWith("VP") && !this.getAxpertType().startsWith("VM")) {
            infos.add(new AutoLabelItem("message.enableDisablePowerSaving[:]", "{defaultData.getCapableJ}", ""));
        }
        infos.add(new AutoLabelItem("message.enableDisableOverloadRestart[:]", "{defaultData.getCapableU}", ""));
        infos.add(new AutoLabelItem("message.enableDisableOverTempRestart[:]", "{defaultData.getCapableV}", ""));
        infos.add(new AutoLabelItem("message.enableDisableOverloadBypass[:]", "{defaultData.getCapableB}", ""));
        infos.add(new AutoLabelItem("message.enableDisableLcdBacklightOn[:]", "{defaultData.getCapableX}", ""));
        infos.add(new AutoLabelItem("message.enableDisableAlarmOn[:]", "{defaultData.getCapableY}", ""));
        infos.add(new AutoLabelItem("message.enableDisableLcdComeBack[:]", "{defaultData.getCapableK}", ""));
        infos.add(new AutoLabelItem("message.FaultCodeRecord[:]", "{defaultData.getCapableZ}", ""));
        restoreInfo.setInfos(infos);
        return restoreInfo;
    }

    @Override
    public RatingInfo getRatingInfo() {
        RatingInfo ratingInfo = new RatingInfo();
        ArrayList<AutoLabelItem> infos = new ArrayList<AutoLabelItem>();
        AbstractProcessor processor = GlobalProcessors.getCurrentProcessor();
        MachineInfo machineInfo = null;
        if (processor != null && P30PlusDuo.is4to5k((machineInfo = (MachineInfo)processor.getBeanBag().getBean("machineinfo")).getAcOutputRatingApparentPower())) {
            infos.add(new AutoLabelItem("message.MaxSolarChargingCurrent[:]", "{machineInfo.getMaxSolarChargingCurrent}", "A"));
        }
        infos.add(new AutoLabelItem("message.nominalacvol[:]", "{machineInfo.getGridRatingVoltage}", "V"));
        infos.add(new AutoLabelItem("message.nominalaccur[:]", "{machineInfo.getGridRatingCurrent}", "A"));
        infos.add(new AutoLabelItem("message.batteryRatingVoltage[:]", "{machineInfo.getBatteryRatingVoltage}", "V"));
        infos.add(new AutoLabelItem("message.nominaloutputvol[:]", "{machineInfo.getAcOutputRatingVoltage}", "V"));
        infos.add(new AutoLabelItem("message.nominaloutputfre[:]", "{machineInfo.getAcOutputRatingFrequency}", "Hz"));
        infos.add(new AutoLabelItem("message.nominaloutputcur[:]", "{machineInfo.getAcOutputRatingCurrent}", "A"));
        infos.add(new AutoLabelItem("message.nominaloutputapparentpower[:]", "{machineInfo.getAcOutputRatingApparentPower}", "VA"));
        infos.add(new AutoLabelItem("message.nominaloutputactivepowwer[:]", "{machineInfo.getAcOutputRatingActivePower}", "W"));
        infos.add(new AutoLabelItem("message.MPPTTracker[:]", "{machineInfo.getMpptTrackNumber}", ""));
        ratingInfo.setInfos(infos);
        return ratingInfo;
    }

    @Override
    public ProductInfo getProductInfo() {
        ProductInfo productInfo = new ProductInfo();
        ArrayList<AutoLabelItem> infos = new ArrayList<AutoLabelItem>();
        infos.add(new AutoLabelItem("message.machinetype[:]", "{machineInfo.getMachineType}", ""));
        infos.add(new AutoLabelItem("message.topology[:]", "{machineInfo.getTopology}", ""));
        infos.add(new AutoLabelItem("message.maincpuversion[:]", "{machineInfo.getMainFirmwareVersion}", ""));
        infos.add(new AutoLabelItem("message.scc1cpuversion[:]", "{machineInfo.getScc1CpuFirmwareVersion}", ""));
        infos.add(new AutoLabelItem("message.scc2cpuversion[:]", "{machineInfo.getScc2CpuFirmwareVersion}", ""));
        productInfo.setInfos(infos);
        return productInfo;
    }

    @Override
    public HistoryFaultDataColumns getHistoryFaultColumns() {
        HistoryFaultDataColumns columns = new HistoryFaultDataColumns();
        ArrayList<HistoryData> list = new ArrayList<HistoryData>();
        list.add(new HistoryData("message.trandate", "{faultData.getTrandate}", true, true));
        list.add(new HistoryData("message.faultString", "{faultData.getFaultString}", true, true));
        list.add(new HistoryData("message.workMode", "{faultData.getWorkMode}", true, true));
        list.add(new HistoryData("message.acVoltage", "{faultData.getGridVoltageR}", true, false));
        list.add(new HistoryData("message.acFrequency", "{faultData.getGridFrequency}", true, false));
        list.add(new HistoryData("message.pvInputVoltage1", "{faultData.getPvInputVoltage1}", true, true));
        list.add(new HistoryData("message.pvInputVoltage2", "{faultData.getPvInputVoltage2}", true, true));
        if (this.getProtocolID().equals("P30PLUSTRI")) {
            list.add(new HistoryData("message.pvInputVoltage3", "{faultData.getPvInputVoltage3}", true, true));
        }
        list.add(new HistoryData("message.outputapppower", "{faultData.getAcOutputApparentPower}", true, true));
        list.add(new HistoryData("message.outputactpower", "{faultData.getAcOutputActivePower}", true, true));
        list.add(new HistoryData("message.batteryVoltage", "{faultData.getPBatteryVoltage}", true, true));
        list.add(new HistoryData("message.batteryCapacity", "{faultData.getBatteryCapacity}", true, true));
        if (GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VM-1000") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VM-1200") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VM-2000") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VM-2200") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VM-3200") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VM-3000") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VP-1000") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VP-2000") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VP-3000")) {
            list.add(new HistoryData("message.pvInputCurrent", "{faultData.getChargingCurrent}", true, true));
        } else {
            list.add(new HistoryData("message.chargeCurrent", "{faultData.getChargingCurrent}", true, true));
        }
        list.add(new HistoryData("message.batdiscurrent", "{faultData.getBatDisCurrent}", true, true));
        if (!this.getAxpertType().startsWith("VP") && !this.getAxpertType().startsWith("VM")) {
            list.add(new HistoryData("message.outputVoltage", "{faultData.getAcOutputVoltageR}", true, true));
        }
        list.add(new HistoryData("message.outputFrequency", "{faultData.getAcOutputFrequency}", true, true));
        if (this.outputmode == 1) {
            list.add(new HistoryData("message.totalchargingcurrent", "{faultData.getTtlChargingCurrent}", true, true));
            list.add(new HistoryData("message.totaloutputapparentpower", "{faultData.getAcTtlOutputApparentPower}", true, true));
            list.add(new HistoryData("message.totaloutputactivepower", "{faultData.getAcTtlOutputActivePower}", true, true));
            list.add(new HistoryData("message.totaloutputpercent", "{faultData.getAcTtlOutputPercent}", true, true));
        }
        columns.setColumns(list);
        return columns;
    }

    @Override
    public RadioParameter getEqRadioParameter() {
        RadioParameter radioParameter = new RadioParameter();
        ArrayList<AutoRadioItem> list = new ArrayList<AutoRadioItem>();
        AbstractProcessor processor = GlobalProcessors.getCurrentProcessor();
        MachineInfo machineInfo = null;
        if (processor != null) {
            machineInfo = (MachineInfo)processor.getBeanBag().getBean("machineinfo");
        }
        if (machineInfo.isSupportEQ()) {
            list.add(new AutoRadioItem("message.BatteryEqualization[:]", "message.enable", "message.disable", "{configData.isEnableEq}", "setPBEQE", false));
            list.add(new AutoRadioItem("message.RealtimeActivateBatteryEqualization[:]", "message.Activate", "message.cancel", "{configData.getActivateEq}", "setPBEQA", false));
            radioParameter.setRadioParameterList(list);
        }
        return radioParameter;
    }

    @Override
    public SpinnerParameter getEqSpinnerParameter() {
        SpinnerParameter spinnerParameter = new SpinnerParameter();
        ArrayList<AutoSpinnerItem> list = new ArrayList<AutoSpinnerItem>();
        AbstractProcessor processor = GlobalProcessors.getCurrentProcessor();
        MachineInfo machineInfo = null;
        if (processor != null) {
            machineInfo = (MachineInfo)processor.getBeanBag().getBean("machineinfo");
        }
        if (machineInfo.isSupportEQ()) {
            list.add(new AutoSpinnerItem("message.EqualizationTime[:]", "{configData.getMinEqTime}", "{configData.getMaxEqTime}", "5", "{configData.getEqTime}", "message.minitue", "setPBEQT", false));
            list.add(new AutoSpinnerItem("message.EqualizationPeriod[:]", "{configData.getMinEqPeriod}", "{configData.getMaxEqPeriod}", "1", "{configData.getEqPeriod}", "message.days", "setPBEQP", false));
            list.add(new AutoSpinnerItem("message.EqualizationVoltage[:]", "{configData.getMinEqVoltage}", "{configData.getMaxEqVoltage}", "0.1", "{configData.getEqVoltage}", "V", "setPBEQV", false));
            list.add(new AutoSpinnerItem("message.EqualizationOverTime[:]", "{configData.getMinEqOverTime}", "{configData.getMaxEqOverTime}", "5", "{configData.getEqOverTime}", "message.minitue", "setPBEQOT", false));
            spinnerParameter.setSpinnerParameterList(list);
        }
        return spinnerParameter;
    }

    @Override
    public AutoMenuList getMenuList() {
        AbstractProcessor processor = GlobalProcessors.getCurrentProcessor();
        MachineInfo machineInfo = null;
        machineInfo = processor != null ? (MachineInfo)processor.getBeanBag().getBean("machineinfo") : new MachineInfo();
        AutoMenuList menuList = new AutoMenuList();
        ArrayList<AutoMenuOne> menus = new ArrayList<AutoMenuOne>();
        ArrayList<AutoMenuTwo> items1 = new ArrayList<AutoMenuTwo>();
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.baseSet", 101, ""), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.passwordSet", 102, ""), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.smsinfoSet", 104, ""), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.emailSet", 105, ""), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.electricEventSet", 106, ""), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.setcom", 107, ""), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.modbussetting", 108, ""), null));
        ArrayList<AutoMenuTwo> items2 = new ArrayList<AutoMenuTwo>();
        items2.add(new AutoMenuTwo(new AutoMenuItem("message.parametersSetting", 201, ""), null));
        items2.add(new AutoMenuTwo(new AutoMenuItem("message.factoryReset", 202, ""), null));
        ArrayList<AutoMenuTwo> items3 = new ArrayList<AutoMenuTwo>();
        items3.add(new AutoMenuTwo(new AutoMenuItem("message.queryData", 302, ""), null));
        items3.add(new AutoMenuTwo(new AutoMenuItem("message.queryEvent", 304, ""), null));
        if (P30PlusDuo.is4to5k(machineInfo.getAcOutputRatingApparentPower())) {
            items3.add(new AutoMenuTwo(new AutoMenuItem("message.queryFaultData", 303, ""), null));
        }
        ArrayList<AutoMenuTwo> items4 = new ArrayList<AutoMenuTwo>();
        items4.add(new AutoMenuTwo(new AutoMenuItem("English", 401, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("French", 402, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("German", 403, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Polish", 405, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Spanish", 408, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Chinese(Simplified)", 411, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Chinese(Traditional)", 412, "radio"), null));
        ArrayList<AutoMenuTwo> items5 = new ArrayList<AutoMenuTwo>();
        items5.add(new AutoMenuTwo(new AutoMenuItem("message.about", 501, ""), null));
        ArrayList<AutoMenuItem> items = new ArrayList<AutoMenuItem>();
        CustomerConfig custormerConfig = GlobalVariables.customerConfig;
        if (custormerConfig.isEnglish()) {
            items.add(new AutoMenuItem("English", 5021, ""));
        }
        if (custormerConfig.isTurkish()) {
            items.add(new AutoMenuItem("Turkish", 5022, ""));
        }
        if (custormerConfig.isRussian()) {
            items.add(new AutoMenuItem("Russian", 5023, ""));
        }
        if (items.size() < 2) {
            items = null;
        }
        items5.add(new AutoMenuTwo(new AutoMenuItem("message.onlineHelp", 502, ""), items));
        menus.add(new AutoMenuOne("[" + GlobalVariables.customerConfig.getCustomerName() + "]" + "message.pvConfig", 1, items1));
        menus.add(new AutoMenuOne("message.pvControl", 2, items2));
        menus.add(new AutoMenuOne("message.pvView", 3, items3));
        menus.add(new AutoMenuOne("message.language", 4, items4));
        menus.add(new AutoMenuOne("message.help", 5, items5));
        menuList.setMenuList(menus);
        return menuList;
    }
}

