/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.protocol;

import cn.com.voltronic.solar.communicate.IComUSBHandler;
import cn.com.voltronic.solar.communicate.SNMPHandler;
import cn.com.voltronic.solar.data.bean.AutoLabelItem;
import cn.com.voltronic.solar.data.bean.BaseInfo;
import cn.com.voltronic.solar.data.bean.HistoryChart;
import cn.com.voltronic.solar.data.bean.HistoryData;
import cn.com.voltronic.solar.data.bean.HistoryDataChartColumns;
import cn.com.voltronic.solar.data.bean.HistoryDataColumns;
import cn.com.voltronic.solar.data.bean.ProductInfo;
import cn.com.voltronic.solar.protocol.P30PlusDuo;
import cn.com.voltronic.solar.system.GlobalProcessors;
import cn.com.voltronic.solar.util.VolUtil;
import java.util.ArrayList;

public class P30PlusTri
extends P30PlusDuo {
    @Override
    public boolean matchProtocol(Object handler) {
        if (handler instanceof IComUSBHandler) {
            return this.matchComUSB((IComUSBHandler)handler);
        }
        if (handler instanceof SNMPHandler) {
            return this.matchSnmp((SNMPHandler)handler);
        }
        return false;
    }

    @Override
    public boolean matchComUSB(IComUSBHandler _handler) {
        String dataStr = "(NAK";
        int i = 0;
        while (i < 2) {
            if (!this.isEmpty(dataStr)) break;
            try {
                dataStr = _handler.excuteSimpleCommand("QPI");
            }
            catch (Exception e) {
                return false;
            }
            ++i;
        }
        if (dataStr.startsWith("(PI") && dataStr.endsWith("30") && this instanceof P30PlusTri) {
            String qgmn = _handler.excuteSimpleCommand("QGMN");
            if (!this.isStandardModel(qgmn) && !this.isPlus_PF1(qgmn)) {
                return false;
            }
            String qpiri = _handler.excuteSimpleCommand("QPIRI");
            if (this.isEmpty(qpiri)) {
                return false;
            }
            String[] item = qpiri.split(" ");
            this.machineType = item[19];
            if (!this.machineType.equals("20")) {
                return false;
            }
            String serialNoStr = _handler.getSerialNo();
            if (this.isEmpty(serialNoStr)) {
                return false;
            }
            this.serialNo = serialNoStr;
            this.outputmode = VolUtil.parseInt(item[21]);
            return true;
        }
        return false;
    }

    @Override
    public boolean matchSnmp(SNMPHandler snmp) {
        String qpi = snmp.get(".1.3.6.1.4.1.21111.1.2.1.2");
        if (!qpi.equals("30")) {
            return false;
        }
        this.machineType = snmp.get(".1.3.6.1.4.1.21111.1.2.1.7");
        if (!this.machineType.equals("20")) {
            return false;
        }
        this.serialNo = snmp.getSerialNo();
        if ("".equals(this.serialNo)) {
            return false;
        }
        this.outputmode = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.11.9"));
        return true;
    }

    @Override
    public String getProtocolID() {
        return "P30PLUSTRI";
    }

    @Override
    public int getMpptTrackNumber() {
        return 3;
    }

    @Override
    public BaseInfo getBaseInfo() {
        BaseInfo baseInfo = new BaseInfo();
        ArrayList<AutoLabelItem> item = new ArrayList<AutoLabelItem>();
        item.add(new AutoLabelItem("message.pvInputVoltage1[:]", "{workInfo.getPvInputVoltage1}", "V"));
        item.add(new AutoLabelItem("message.pvInputPower1[:]", "{workInfo.getPvInputPower1}", "W"));
        item.add(new AutoLabelItem("message.pvInputVoltage2[:]", "{workInfo.getPvInputVoltage2}", "V"));
        item.add(new AutoLabelItem("message.pvInputPower2[:]", "{workInfo.getPvInputPower2}", "W"));
        item.add(new AutoLabelItem("message.pvInputVoltage3[:]", "{workInfo.getPvInputVoltage3}", "V"));
        item.add(new AutoLabelItem("message.pvInputPower3[:]", "{workInfo.getPvInputPower3}", "W"));
        item.add(new AutoLabelItem("message.acVoltage[:]", "{workInfo.getGridVoltageR}", "V"));
        if (this.outputmode == 0) {
            item.add(new AutoLabelItem("message.ACChargingPower[:]", "{workInfo.getGridPowerR}", "W"));
        }
        item.add(new AutoLabelItem("message.acFrequency[:]", "{workInfo.getGridFrequency}", "Hz"));
        item.add(new AutoLabelItem("message.batteryVoltage[:]", "{workInfo.getPBatteryVoltage}", "V"));
        item.add(new AutoLabelItem("message.batteryCapacity[:]", "{workInfo.getBatteryCapacity}", "%"));
        if (this.getAxpertType().equals("VM-1000") || this.getAxpertType().equals("VM-1200") || this.getAxpertType().equals("VM-2000") || this.getAxpertType().equals("VM-2200") || this.getAxpertType().equals("VM-3200") || this.getAxpertType().equals("VM-3000") || this.getAxpertType().equals("VP-1000") || this.getAxpertType().equals("VP-2000") || this.getAxpertType().equals("VP-3000")) {
            item.add(new AutoLabelItem("message.pvInputCurrent[:]", "{workInfo.getChargingCurrent}", "A"));
        } else {
            item.add(new AutoLabelItem("message.chargeCurrent[:]", "{workInfo.getChargingCurrent}", "A"));
        }
        item.add(new AutoLabelItem("message.batdiscurrent[:]", "{workInfo.getBatDisCurrent}", "A"));
        item.add(new AutoLabelItem("message.outputVoltage[:]", "{workInfo.getAcOutputVoltageR}", "V"));
        item.add(new AutoLabelItem("message.outputFrequency[:]", "{workInfo.getAcOutputFrequency}", "Hz"));
        item.add(new AutoLabelItem("message.outputapppower[:]", "{workInfo.getAcOutputApparentPower}", "VA"));
        item.add(new AutoLabelItem("message.outputactpower[:]", "{workInfo.getAcOutputActivePower}", "W"));
        item.add(new AutoLabelItem("message.loadpercent[:]", "{workInfo.getOutputLoadPercent}", "%"));
        if (this.outputmode == 1) {
            item.add(new AutoLabelItem("message.totalchargingcurrent[:]", "{workInfo.getTtlChargingCurrent}", "A"));
            item.add(new AutoLabelItem("message.totaloutputapparentpower[:]", "{workInfo.getAcTtlOutputApparentPower}", "VA"));
            item.add(new AutoLabelItem("message.totaloutputactivepower[:]", "{workInfo.getAcTtlOutputActivePower}", "W"));
            item.add(new AutoLabelItem("message.totaloutputpercent[:]", "{workInfo.getAcTtlOutputPercent}", "%"));
        }
        baseInfo.setBaseInfoList(item);
        return baseInfo;
    }

    @Override
    public HistoryDataColumns getHistoryColumns() {
        HistoryDataColumns columns = new HistoryDataColumns();
        ArrayList<HistoryData> list = new ArrayList<HistoryData>();
        list.add(new HistoryData("message.workMode", "{workInfo.getWorkMode}", true, false));
        list.add(new HistoryData("message.time", "{workInfo.getCurrentTime}", true, false));
        list.add(new HistoryData("message.pvInputVoltage1", "{workInfo.getPvInputVoltage1}", true, true));
        list.add(new HistoryData("message.pvInputCurrent1", "{workInfo.getPvInputCurrent1}", true, true));
        list.add(new HistoryData("message.pvInputPower1", "{workInfo.getPvInputPower1}", true, true));
        list.add(new HistoryData("message.pvInputVoltage2", "{workInfo.getPvInputVoltage2}", true, true));
        list.add(new HistoryData("message.pvInputCurrent2", "{workInfo.getPvInputCurrent2}", true, true));
        list.add(new HistoryData("message.pvInputPower2", "{workInfo.getPvInputPower2}", true, true));
        list.add(new HistoryData("message.pvInputVoltage3", "{workInfo.getPvInputVoltage3}", true, true));
        list.add(new HistoryData("message.pvInputCurrent3", "{workInfo.getPvInputCurrent3}", true, true));
        list.add(new HistoryData("message.pvInputPower3", "{workInfo.getPvInputPower3}", true, true));
        list.add(new HistoryData("message.acVoltage", "{workInfo.getGridVoltageR}", true, true));
        list.add(new HistoryData("message.acFrequency", "{workInfo.getGridFrequency}", true, true));
        if (this.outputmode == 0) {
            list.add(new HistoryData("message.ACChargingCurrent", "{workInfo.getGridCurrentR}", true, true));
            list.add(new HistoryData("message.ACChargingPower", "{workInfo.getGridPowerR}", true, true));
        }
        list.add(new HistoryData("message.outputapppower", "{workInfo.getAcOutputApparentPower}", true, true));
        list.add(new HistoryData("message.outputactpower", "{workInfo.getAcOutputActivePower}", true, true));
        list.add(new HistoryData("message.batteryVoltage", "{workInfo.getPBatteryVoltage}", true, true));
        list.add(new HistoryData("message.batteryCapacity", "{workInfo.getBatteryCapacity}", true, true));
        list.add(new HistoryData("message.chargeCurrent", "{workInfo.getChargingCurrent}", true, true));
        list.add(new HistoryData("message.batdiscurrent", "{workInfo.getBatDisCurrent}", true, true));
        if (!this.getAxpertType().startsWith("VP") && !this.getAxpertType().startsWith("VM")) {
            list.add(new HistoryData("message.outputVoltage", "{workInfo.getAcOutputVoltageR}", true, true));
        }
        list.add(new HistoryData("message.outputFrequency", "{workInfo.getAcOutputFrequency}", true, true));
        if (this.outputmode == 1) {
            list.add(new HistoryData("message.totalchargingcurrent", "{workInfo.getTtlChargingCurrent}", true, true));
            list.add(new HistoryData("message.totaloutputapparentpower", "{workInfo.getAcTtlOutputApparentPower}", true, true));
            list.add(new HistoryData("message.totaloutputactivepower", "{workInfo.getAcTtlOutputActivePower}", true, true));
            list.add(new HistoryData("message.totaloutputpercent", "{workInfo.getAcTtlOutputPercent}", true, true));
        }
        columns.setColumns(list);
        return columns;
    }

    @Override
    public HistoryDataChartColumns getHistoryChartColumns() {
        HistoryDataChartColumns columns = new HistoryDataChartColumns();
        ArrayList<HistoryChart> list = new ArrayList<HistoryChart>();
        list.add(new HistoryChart("message.pvInputVoltage1", "{workInfo.getPvInputVoltage1}", 200.0, "V", true));
        list.add(new HistoryChart("message.pvInputCurrent1", "{workInfo.getPvInputCurrent1}", 200.0, "A", true));
        list.add(new HistoryChart("message.pvInputPower1", "{workInfo.getPvInputPower1}", 3000.0, "W", true));
        list.add(new HistoryChart("message.pvInputVoltage2", "{workInfo.getPvInputVoltage2}", 200.0, "V", true));
        list.add(new HistoryChart("message.pvInputCurrent2", "{workInfo.getPvInputCurrent2}", 200.0, "A", true));
        list.add(new HistoryChart("message.pvInputPower2", "{workInfo.getPvInputPower2}", 3000.0, "W", true));
        list.add(new HistoryChart("message.pvInputVoltage3", "{workInfo.getPvInputVoltage3}", 200.0, "V", true));
        list.add(new HistoryChart("message.pvInputCurrent3", "{workInfo.getPvInputCurrent3}", 200.0, "A", true));
        list.add(new HistoryChart("message.pvInputPower3", "{workInfo.getPvInputPower3}", 3000.0, "W", true));
        list.add(new HistoryChart("message.acVoltage", "{workInfo.getGridVoltageR}", 300.0, "V", true));
        list.add(new HistoryChart("message.acFrequency", "{workInfo.getGridFrequency}", 70.0, "Hz", true));
        if (this.outputmode == 0) {
            list.add(new HistoryChart("message.ACChargingCurrent", "{workInfo.getGridCurrentR}", 100.0, "A", true));
            list.add(new HistoryChart("message.ACChargingPower", "{workInfo.getGridPowerR}", 2000.0, "W", true));
        }
        list.add(new HistoryChart("message.outputapppower", "{workInfo.getAcOutputApparentPower}", 3000.0, "VA", true));
        list.add(new HistoryChart("message.outputactpower", "{workInfo.getAcOutputActivePower}", 3000.0, "W", true));
        list.add(new HistoryChart("message.batteryVoltage", "{workInfo.getPBatteryVoltage}", 100.0, "V", true));
        list.add(new HistoryChart("message.batteryCapacity", "{workInfo.getBatteryCapacity}", 100.0, "%", true));
        if (GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VM-1000") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VM-1200") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VM-2000") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VM-2200") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VM-3200") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VM-3000") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VP-1000") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VP-2000") || GlobalProcessors.getCurrentProcessor().getProtocol().getAxpertType().equals("VP-3000")) {
            list.add(new HistoryChart("message.pvInputCurrent", "{workInfo.getChargingCurrent}", 250.0, "A", true));
        } else {
            list.add(new HistoryChart("message.chargeCurrent", "{workInfo.getChargingCurrent}", 250.0, "A", true));
        }
        list.add(new HistoryChart("message.batdiscurrent", "{workInfo.getBatDisCurrent}", 150.0, "A", true));
        if (!this.getAxpertType().startsWith("VP") && !this.getAxpertType().startsWith("VM")) {
            list.add(new HistoryChart("message.outputVoltage", "{workInfo.getAcOutputVoltageR}", 300.0, "V", true));
        }
        list.add(new HistoryChart("message.outputFrequency", "{workInfo.getAcOutputFrequency}", 70.0, "Hz", true));
        if (this.outputmode == 1) {
            list.add(new HistoryChart("message.totalchargingcurrent", "{workInfo.getTtlChargingCurrent}", 100.0, "A", true));
            list.add(new HistoryChart("message.totaloutputapparentpower", "{workInfo.getAcTtlOutputApparentPower}", 20000.0, "VA", true));
            list.add(new HistoryChart("message.totaloutputactivepower", "{workInfo.getAcTtlOutputActivePower}", 20000.0, "W", true));
            list.add(new HistoryChart("message.totaloutputpercent", "{workInfo.getAcTtlOutputPercent}", 100.0, "%", true));
        }
        columns.setColumns(list);
        return columns;
    }

    @Override
    public ProductInfo getProductInfo() {
        ProductInfo productInfo = new ProductInfo();
        ArrayList<AutoLabelItem> infos = new ArrayList<AutoLabelItem>();
        infos.add(new AutoLabelItem("message.machinetype[:]", "{machineInfo.getMachineType}", ""));
        infos.add(new AutoLabelItem("message.topology[:]", "{machineInfo.getTopology}", ""));
        infos.add(new AutoLabelItem("message.maincpuversion[:]", "{machineInfo.getMainFirmwareVersion}", ""));
        infos.add(new AutoLabelItem("message.scc1cpuversion[:]", "{machineInfo.getScc1CpuFirmwareVersion}", ""));
        infos.add(new AutoLabelItem("message.scc2cpuversion[:]", "{machineInfo.getScc2CpuFirmwareVersion}", ""));
        infos.add(new AutoLabelItem("message.scc3cpuversion[:]", "{machineInfo.getScc3CpuFirmwareVersion}", ""));
        productInfo.setInfos(infos);
        return productInfo;
    }
}

