/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.protocol;

import cn.com.voltronic.solar.communicate.IComUSBHandler;
import cn.com.voltronic.solar.communicate.ModbusHandler;
import cn.com.voltronic.solar.communicate.SNMPHandler;
import cn.com.voltronic.solar.data.bean.AutoComboBoxItem;
import cn.com.voltronic.solar.data.bean.AutoLabelItem;
import cn.com.voltronic.solar.data.bean.AutoRadioItem;
import cn.com.voltronic.solar.data.bean.AutoSpinnerItem;
import cn.com.voltronic.solar.data.bean.BaseInfo;
import cn.com.voltronic.solar.data.bean.ComboBoxParameter;
import cn.com.voltronic.solar.data.bean.ConfigData;
import cn.com.voltronic.solar.data.bean.MachineInfo;
import cn.com.voltronic.solar.data.bean.RadioParameter;
import cn.com.voltronic.solar.data.bean.RestoreInfo;
import cn.com.voltronic.solar.data.bean.SpinnerParameter;
import cn.com.voltronic.solar.data.bean.WorkInfo;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.protocol.P30;
import cn.com.voltronic.solar.system.GlobalProcessors;
import cn.com.voltronic.solar.util.VolUtil;
import java.util.ArrayList;

public class P30V
extends P30 {
    @Override
    public String getProtocolID() {
        return "P30V";
    }

    @Override
    public boolean matchProtocol(Object handler) {
        if (handler instanceof IComUSBHandler) {
            return this.matchComUSB((IComUSBHandler)handler);
        }
        if (handler instanceof ModbusHandler) {
            return false;
        }
        if (handler instanceof SNMPHandler) {
            return false;
        }
        return false;
    }

    @Override
    public boolean matchComUSB(IComUSBHandler _handler) {
        String dataStr = "(NAK";
        int i = 0;
        while (i < 2) {
            if (!this.isEmpty(dataStr)) break;
            try {
                dataStr = _handler.excuteSimpleCommand("QPI");
            }
            catch (Exception e) {
                return false;
            }
            ++i;
        }
        if (dataStr.startsWith("(PI") && dataStr.endsWith("30")) {
            String serialNoStr;
            String[] ratingInfo;
            block23: {
                block22: {
                    String qmn;
                    block21: {
                        block20: {
                            block19: {
                                String qpiri;
                                block18: {
                                    try {
                                        qpiri = _handler.excuteSimpleCommand("QPIRI");
                                        if (!this.isEmpty(qpiri)) break block18;
                                        return false;
                                    }
                                    catch (Exception ex) {
                                        return false;
                                    }
                                }
                                ratingInfo = qpiri.split(" ");
                                this.machineType = ratingInfo[19];
                                if (this.machineType.equals("00") || this.machineType.equals("01") || this.machineType.equals("10")) break block19;
                                return false;
                            }
                            qmn = _handler.excuteCommand("QMN", true);
                            if (!this.isEmpty(qmn)) break block20;
                            return false;
                        }
                        if (this.isAxpertV(qmn)) break block21;
                        return false;
                    }
                    this.axpertType = qmn;
                    if (qmn.startsWith("(")) {
                        this.axpertType = qmn.substring(1);
                    }
                    if (this.axpertType.startsWith("VP") || this.axpertType.startsWith("VM")) break block22;
                    return false;
                }
                serialNoStr = _handler.getSerialNo();
                if (!this.isEmpty(serialNoStr)) break block23;
                return false;
            }
            this.serialNo = serialNoStr;
            if (ratingInfo[15].equals("2") || ratingInfo[15].equals("3")) {
                this.outputmode = 1;
            } else if (ratingInfo.length > 21) {
                try {
                    this.outputmode = VolUtil.parseInt(ratingInfo[21]);
                }
                catch (Exception exception) {}
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean matchSnmp(SNMPHandler snmp) {
        return false;
    }

    @Override
    public boolean matchModbus(ModbusHandler modbus) throws Exception {
        return false;
    }

    @Override
    public BaseInfo getBaseInfo() {
        if (this.isVMII()) {
            return this.getBaseInfoForVMII();
        }
        int isPVCharging = 1;
        int isShowChargingCurrent = 1;
        AbstractProcessor processor = GlobalProcessors.getCurrentProcessor();
        WorkInfo workInfo = null;
        if (processor != null) {
            workInfo = (WorkInfo)processor.getBeanBag().getBean("workinfo");
            isPVCharging = workInfo.getIsPVCharging();
            isShowChargingCurrent = workInfo.getIsShowChargingCurrent();
        }
        BaseInfo baseInfo = new BaseInfo();
        ArrayList<AutoLabelItem> item = new ArrayList<AutoLabelItem>();
        item.add(new AutoLabelItem("message.acVoltage[:]", "{workInfo.getGridVoltageR}", "V"));
        item.add(new AutoLabelItem("message.acFrequency[:]", "{workInfo.getGridFrequency}", "Hz"));
        item.add(new AutoLabelItem("message.pvInputVoltage[:]", "{workInfo.getPvInputVoltage1}", "V"));
        if (this.getAxpertType().equals("VP-3000") || this.getAxpertType().equals("VM-3000")) {
            if (isPVCharging == 1) {
                item.add(new AutoLabelItem("message.pvInputCurrentForBattery[:]", "{workInfo.getPvInputCurrentForBatttery}", "A"));
            }
            if (this.getAxpertType().equals("VM-3000")) {
                item.add(new AutoLabelItem("message.pvInputPower[:]", "{workInfo.getPvInputPower1}", "W"));
            }
        } else {
            item.add(new AutoLabelItem("message.pvInputCurrentForBattery[:]", "{workInfo.getPvInputCurrentForBatttery}", "A"));
            item.add(new AutoLabelItem("message.pvInputPower[:]", "{workInfo.getPvInputPower1}", "W"));
        }
        item.add(new AutoLabelItem("message.batteryVoltage[:]", "{workInfo.getPBatteryVoltage}", "V"));
        item.add(new AutoLabelItem("message.batteryCapacity[:]", "{workInfo.getBatteryCapacity}", "%"));
        if (isShowChargingCurrent == 1) {
            if (this.getAxpertType().equals("VM-1000") || this.getAxpertType().equals("VM-1200") || this.getAxpertType().equals("VM-2000") || this.getAxpertType().equals("VM-2200") || this.getAxpertType().equals("VM-3200") || this.getAxpertType().equals("VM-3000") || this.getAxpertType().equals("VP-1000") || this.getAxpertType().equals("VP-2000") || this.getAxpertType().equals("VP-3000")) {
                item.add(new AutoLabelItem("message.pvInputCurrent[:]", "{workInfo.getChargingCurrent}", "A"));
            } else {
                item.add(new AutoLabelItem("message.chargeCurrent[:]", "{workInfo.getChargingCurrent}", "A"));
            }
        }
        item.add(new AutoLabelItem("message.batdiscurrent[:]", "{workInfo.getBatDisCurrent}", "A"));
        item.add(new AutoLabelItem("message.outputVoltage[:]", "{workInfo.getAcOutputVoltageR}", "V"));
        item.add(new AutoLabelItem("message.outputFrequency[:]", "{workInfo.getAcOutputFrequency}", "Hz"));
        item.add(new AutoLabelItem("message.outputapppower[:]", "{workInfo.getAcOutputApparentPower}", "VA"));
        item.add(new AutoLabelItem("message.outputactpower[:]", "{workInfo.getAcOutputActivePower}", "W"));
        item.add(new AutoLabelItem("message.loadpercent[:]", "{workInfo.getOutputLoadPercent}", "%"));
        baseInfo.setBaseInfoList(item);
        return baseInfo;
    }

    private BaseInfo getBaseInfoForVMII() {
        BaseInfo baseInfo = new BaseInfo();
        ArrayList<AutoLabelItem> item = new ArrayList<AutoLabelItem>();
        item.add(new AutoLabelItem("message.acVoltage[:]", "{workInfo.getGridVoltageR}", "V"));
        item.add(new AutoLabelItem("message.acFrequency[:]", "{workInfo.getGridFrequency}", "Hz"));
        item.add(new AutoLabelItem("message.pvInputVoltage[:]", "{workInfo.getPvInputVoltage1}", "V"));
        item.add(new AutoLabelItem("message.pvInputCurrent[:]", "{workInfo.getPvInputCurrent}", "A"));
        item.add(new AutoLabelItem("message.pvInputPower[:]", "{workInfo.getPvInputPower1}", "W"));
        item.add(new AutoLabelItem("message.batteryVoltage[:]", "{workInfo.getPBatteryVoltage}", "V"));
        item.add(new AutoLabelItem("message.batteryCapacity[:]", "{workInfo.getBatteryCapacity}", "%"));
        item.add(new AutoLabelItem("message.chargeCurrent[:]", "{workInfo.getChargingCurrent}", "A"));
        item.add(new AutoLabelItem("message.batdiscurrent[:]", "{workInfo.getBatDisCurrent}", "A"));
        item.add(new AutoLabelItem("message.outputVoltage[:]", "{workInfo.getAcOutputVoltageR}", "V"));
        item.add(new AutoLabelItem("message.outputFrequency[:]", "{workInfo.getAcOutputFrequency}", "Hz"));
        item.add(new AutoLabelItem("message.outputapppower[:]", "{workInfo.getAcOutputApparentPower}", "VA"));
        item.add(new AutoLabelItem("message.outputactpower[:]", "{workInfo.getAcOutputActivePower}", "W"));
        item.add(new AutoLabelItem("message.loadpercent[:]", "{workInfo.getOutputLoadPercent}", "%"));
        baseInfo.setBaseInfoList(item);
        return baseInfo;
    }

    @Override
    public RadioParameter getRadioParameter() {
        RadioParameter radioParameter = new RadioParameter();
        ArrayList<AutoRadioItem> list = new ArrayList<AutoRadioItem>();
        list.add(new AutoRadioItem("message.pepdA[:]", "message.enable", "message.disable", "{cappbility.isCapableA}", "CapableA", false));
        list.add(new AutoRadioItem("message.backlight[:]", "message.enable", "message.disable", "{cappbility.isCapableX}", "CapableX", false));
        list.add(new AutoRadioItem("message.overLoadAutoRestart[:]", "message.enable", "message.disable", "{cappbility.isCapableU}", "CapableU", false));
        list.add(new AutoRadioItem("message.overTemperatureAutoRestart[:]", "message.enable", "message.disable", "{cappbility.isCapableV}", "CapableV", false));
        list.add(new AutoRadioItem("message.beepsWhileInterrupt[:]", "message.enable", "message.disable", "{cappbility.isCapableY}", "CapableY", false));
        list.add(new AutoRadioItem("message.overloadBypass[:]", "message.enable", "message.disable", "{cappbility.isCapableB}", "CapableB", false));
        list.add(new AutoRadioItem("message.lcdComeBackToDefaultAfter1min[:] ", "message.enable", "message.disable", "{cappbility.isCapableK}", "CapableK", false));
        list.add(new AutoRadioItem("message.FaultCodeRecord[:]", "message.enable", "message.disable", "{cappbility.isCapableZ}", "CapableZ", false));
        radioParameter.setRadioParameterList(list);
        return radioParameter;
    }

    @Override
    public ComboBoxParameter getComboBoxParameter() {
        AbstractProcessor processor = GlobalProcessors.getCurrentProcessor();
        MachineInfo machineInfo = null;
        ConfigData config = null;
        if (processor != null) {
            machineInfo = (MachineInfo)processor.getBeanBag().getBean("machineinfo");
            config = (ConfigData)processor.getBeanBag().getBean("configdata");
        }
        ComboBoxParameter comboBoxParameter = new ComboBoxParameter();
        ArrayList<AutoComboBoxItem> list = new ArrayList<AutoComboBoxItem>();
        if (this.getAxpertType().startsWith("VMIII")) {
            list.add(new AutoComboBoxItem("message.chargerSourcePriority[:]", new String[]{"Solar first", "Utility and Solar", "Solar only"}, "{configData.getChargerSource}", "", "ChargerSource", false));
        } else {
            list.add(new AutoComboBoxItem("message.chargerSourcePriority[:]", new String[]{"Utility", "Solar first", "Utility and Solar", "Solar only"}, "{configData.getChargerSource}", "", "ChargerSource", false));
        }
        list.add(new AutoComboBoxItem("message.outputSourcePriority[:]", new String[]{"Utility", "Solar", "SBU"}, "{configData.getOutputSource}", "", "OutputSource", false));
        list.add(new AutoComboBoxItem("message.acInputRange[:]", new String[]{"Appliance", "UPS"}, "{configData.getAcInputRange}", "", "ACInputRange", false));
        list.add(new AutoComboBoxItem("message.batteryType[:]", new String[]{"AGM", "Flooded", "User"}, "{configData.getBatteryType}", "", "BatteryType", false));
        list.add(new AutoComboBoxItem("message.outputFrequency[:]", new String[]{"50", "60"}, "{configData.getOutputFrequency}", "Hz", "OutputFrequency", false));
        if (this.isVMII()) {
            if (this.getAxpertType().startsWith("VP") || this.getAxpertType().startsWith("VM")) {
                if (this.getAxpertType().startsWith("VMII")) {
                    list.add(new AutoComboBoxItem("message.outputVoltage[:]", new String[]{"220", "230", "240"}, "{configData.getOutputVoltage}", "V", "OutputVoltage", false));
                }
            } else {
                list.add(new AutoComboBoxItem("message.outputVoltage[:]", new String[]{"220", "230", "240"}, "{configData.getOutputVoltage}", "V", "OutputVoltage", false));
            }
        }
        if (processor != null && machineInfo != null && config != null) {
            if (!this.is5KwV1_12orBelow(machineInfo)) {
                if (this.is1210or5210(machineInfo)) {
                    if (config.getBatteryVoltage() > 40.0) {
                        list.add(new AutoComboBoxItem("message.backToGridVol[:]", new String[]{"44.0", "45.0", "46.0", "47.0", "48.0", "49.0", "50.0", "51.0"}, "{configData.getRechargeVoltage}", "V", "ReChargeVoltage", false));
                    } else if (config.getBatteryVoltage() > 20.0) {
                        list.add(new AutoComboBoxItem("message.backToGridVol[:]", new String[]{"22.0", "22.5", "23.0", "23.5", "24.0", "24.5", "25.0", "25.5"}, "{configData.getRechargeVoltage}", "V", "ReChargeVoltage", false));
                    } else {
                        list.add(new AutoComboBoxItem("message.backToGridVol[:]", new String[]{"11.0", "11.3", "11.5", "11.8", "12.0", "12.3", "12.5", "12.8"}, "{configData.getRechargeVoltage}", "V", "ReChargeVoltage", false));
                    }
                } else if (config.getBatteryVoltage() > 40.0) {
                    list.add(new AutoComboBoxItem("message.backToGridVolForSBUPriority[:]", new String[]{"44.0", "45.0", "46.0", "47.0", "48.0", "49.0", "50.0", "51.0"}, "{configData.getRechargeVoltage}", "V", "ReChargeVoltage", false));
                } else if (config.getBatteryVoltage() > 20.0) {
                    list.add(new AutoComboBoxItem("message.backToGridVolForSBUPriority[:]", new String[]{"22.0", "22.5", "23.0", "23.5", "24.0", "24.5", "25.0", "25.5"}, "{configData.getRechargeVoltage}", "V", "ReChargeVoltage", false));
                } else {
                    list.add(new AutoComboBoxItem("message.backToGridVolForSBUPriority[:]", new String[]{"11.0", "11.3", "11.5", "11.8", "12.0", "12.3", "12.5", "12.8"}, "{configData.getRechargeVoltage}", "V", "ReChargeVoltage", false));
                }
            }
            if (this.isSupportChargingCurrentComBox(machineInfo)) {
                if (this.isVMII()) {
                    list.add(new AutoComboBoxItem("message.maxChargingCurrent[:]", config.getMaxChargeCurrentCombox(machineInfo, this.outputmode), "{configData.getMaxChargeCurrentInt}", "A", "VNPMaxChargeCurrent", false));
                } else if (this.is1227or5227(machineInfo)) {
                    list.add(new AutoComboBoxItem("message.maxChargingCurrent[:]", config.getMaxChargeCurrentCombox(machineInfo, this.outputmode), "{configData.getMaxChargeCurrentInt}", "A", "VNPMaxChargeCurrent", false));
                } else {
                    list.add(new AutoComboBoxItem("message.maxChargingCurrent[:]", config.getMaxChargeCurrentCombox(machineInfo, this.outputmode), "{configData.getMaxChargeCurrentInt}", "A", "PMaxChargeCurrent", false));
                }
                list.add(new AutoComboBoxItem("message.maxAcChargingCurrent[:]", config.getAcChargingCurrentComBox(), "{configData.getMaxacchargingcurrentInt}", "A", "VPMaxACChargeCurrent", false));
            }
            if (this.is1210or5210(machineInfo)) {
                if (config.getBatteryVoltage() > 40.0) {
                    list.add(new AutoComboBoxItem("message.backToDischargeVol[:]", new String[]{"48.0", "49.0", "50.0", "51.0", "52.0", "53.0", "54.0", "55.0", "56.0", "57.0", "58.0", "FULL"}, "{configData.getReDischargeVoltage}", "V", "ReDisChargeVoltage", false));
                } else if (config.getBatteryVoltage() > 20.0) {
                    list.add(new AutoComboBoxItem("message.backToDischargeVol[:]", new String[]{"24.0", "24.5", "25.0", "25.5", "26.0", "26.5", "27.0", "27.5", "28.0", "28.5", "29.0", "FULL"}, "{configData.getReDischargeVoltage}", "V", "ReDisChargeVoltage", false));
                } else {
                    list.add(new AutoComboBoxItem("message.backToDischargeVol[:]", new String[]{"12.0", "12.3", "12.5", "12.8", "13.0", "13.3", "13.5", "13.8", "14.0", "14.3", "14.5", "FULL"}, "{configData.getReDischargeVoltage}", "V", "ReDisChargeVoltage", false));
                }
            }
        }
        comboBoxParameter.setComboBoxParameterList(list);
        return comboBoxParameter;
    }

    @Override
    public RadioParameter getEqRadioParameter() {
        RadioParameter radioParameter = new RadioParameter();
        ArrayList<AutoRadioItem> list = new ArrayList<AutoRadioItem>();
        list.add(new AutoRadioItem("message.BatteryEqualization[:]", "message.enable", "message.disable", "{configData.isEnableEq}", "setPBEQE", false));
        list.add(new AutoRadioItem("message.RealtimeActivateBatteryEqualization[:]", "message.Activate", "message.cancel", "{configData.getActivateEq}", "setPBEQA", false));
        radioParameter.setRadioParameterList(list);
        return radioParameter;
    }

    @Override
    public SpinnerParameter getEqSpinnerParameter() {
        SpinnerParameter spinnerParameter = new SpinnerParameter();
        ArrayList<AutoSpinnerItem> list = new ArrayList<AutoSpinnerItem>();
        list.add(new AutoSpinnerItem("message.EqualizationTime[:]", "{configData.getMinEqTime}", "{configData.getMaxEqTime}", "5", "{configData.getEqTime}", "message.minitue", "setPBEQT", false));
        list.add(new AutoSpinnerItem("message.EqualizationPeriod[:]", "{configData.getMinEqPeriod}", "{configData.getMaxEqPeriod}", "1", "{configData.getEqPeriod}", "message.days", "setPBEQP", false));
        list.add(new AutoSpinnerItem("message.EqualizationVoltage[:]", "{configData.getMinEqVoltage}", "{configData.getMaxEqVoltage}", "0.1", "{configData.getEqVoltage}", "V", "setPBEQV", false));
        list.add(new AutoSpinnerItem("message.EqualizationOverTime[:]", "{configData.getMinEqOverTime}", "{configData.getMaxEqOverTime}", "5", "{configData.getEqOverTime}", "message.minitue", "setPBEQOT", false));
        spinnerParameter.setSpinnerParameterList(list);
        return spinnerParameter;
    }

    @Override
    public RestoreInfo getResotreInfo() {
        RestoreInfo restoreInfo = new RestoreInfo();
        ArrayList<AutoLabelItem> infos = new ArrayList<AutoLabelItem>();
        infos.add(new AutoLabelItem("message.acOutputFre[:]", "{defaultData.getAcOutputFrequency}", "Hz"));
        infos.add(new AutoLabelItem("message.maxChargingVoltage[:]", "{defaultData.getMaxChargingVoltage}", "V"));
        infos.add(new AutoLabelItem("message.maxFloatingVoltage[:]", "{defaultData.getFloatChargingVoltage}", "V"));
        infos.add(new AutoLabelItem("message.maxChargingCurrent[:]", "{defaultData.getMaxChargingCurrent}", "A"));
        infos.add(new AutoLabelItem("message.maxAcChargingCurrent[:]", "{defaultData.getMaxACChargingCurrent}", "A"));
        infos.add(new AutoLabelItem("message.batteryCutoffVoltage[:]", "{defaultData.getBatteryCutoffVoltage}", "V"));
        infos.add(new AutoLabelItem("message.backToDischargeVol[:]", "{defaultData.getReDischargeVoltage}", "V"));
        infos.add(new AutoLabelItem("message.backToGridVol[:]", "{defaultData.getReChangingVoltage}", "V"));
        infos.add(new AutoLabelItem("message.acInputVoltageRange[:]", "{defaultData.getAcInputVoltage}", ""));
        infos.add(new AutoLabelItem("message.outputSourcePriority[:]", "{defaultData.getOutputSourcePriority}", ""));
        infos.add(new AutoLabelItem("message.chargerSourcePriority[:]", "{defaultData.getChargerSourcePriority}", ""));
        infos.add(new AutoLabelItem("message.batteryType[:]", "{defaultData.getBatteryType}", ""));
        infos.add(new AutoLabelItem("message.enableDisablebuzzer[:]", "{defaultData.getCapableA}", ""));
        infos.add(new AutoLabelItem("message.enableDisableOverloadRestart[:]", "{defaultData.getCapableU}", ""));
        infos.add(new AutoLabelItem("message.enableDisableOverTempRestart[:]", "{defaultData.getCapableV}", ""));
        infos.add(new AutoLabelItem("message.enableDisableLcdBacklightOn[:]", "{defaultData.getCapableX}", ""));
        infos.add(new AutoLabelItem("message.enableDisableAlarmOn[:]", "{defaultData.getCapableY}", ""));
        infos.add(new AutoLabelItem("message.enableDisableLcdComeBack[:]", "{defaultData.getCapableK}", ""));
        infos.add(new AutoLabelItem("message.enableDisableOverloadBypass[:]", "{defaultData.getCapableB}", ""));
        infos.add(new AutoLabelItem("message.FaultCodeRecord[:]", "{defaultData.getCapableZ}", ""));
        restoreInfo.setInfos(infos);
        return restoreInfo;
    }
}

