/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.snmp4j;

import cn.com.voltronic.solar.snmp4j.Search;
import cn.com.voltronic.solar.system.GlobalVariables;
import java.net.InetAddress;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.regex.Pattern;

public class SearchSnmpCard
extends Thread {
    private static ConcurrentSkipListSet<String> netIPs = new ConcurrentSkipListSet();
    private static ConcurrentSkipListSet<String> snmpCards = new ConcurrentSkipListSet();

    @Override
    public void run() {
        SearchSnmpCard.search();
    }

    public static Set<String> getSnmpCards() {
        return snmpCards;
    }

    private static boolean ipCheck(String ip) {
        Pattern pattern = Pattern.compile("^((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5]|[*])\\.){3}(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5]|[*])$");
        return pattern.matcher(ip).matches();
    }

    public static void search() {
        SearchSnmpCard.searchNetIps();
        SearchSnmpCard.searchSnmpCards();
    }

    private static void searchNetIps() {
        String[] segments;
        String netSegment = GlobalVariables.globalConfig.getUpsTreeIpAddress();
        if (netSegment == null) {
            netSegment = "";
        }
        netSegment.trim();
        if (netSegment.length() == 0) {
            String ip = "127.0.0.1";
            try {
                ip = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            int lastPointIndex = ip.lastIndexOf(46);
            netSegment = ip.substring(0, lastPointIndex);
            if (netSegment.indexOf("127.0.0") >= 0) {
                netSegment = netSegment.replace("127.0.0", "");
            }
        }
        String[] stringArray = segments = netSegment.split(";");
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            if (SearchSnmpCard.ipCheck(segment)) {
                netIPs.add(segment);
            } else {
                SearchSnmpCard.addIpBySegment(segment);
            }
            ++n2;
        }
    }

    private static void addIpBySegment(String segment) {
        int item = 1;
        while (item <= 255) {
            String ip = String.valueOf(segment) + "." + item;
            if (SearchSnmpCard.ipCheck(ip)) {
                netIPs.add(ip);
            }
            ++item;
        }
    }

    private static void searchSnmpCards() {
        for (String ip : netIPs) {
            Search search = new Search(ip);
            search.start();
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

