/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.snmp4j;

import cn.com.voltronic.solar.snmpprocessor.AbstractSNMPProcessor;
import cn.com.voltronic.solar.system.GlobalProcessors;
import cn.com.voltronic.solar.system.GlobalVariables;
import java.io.IOException;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.snmp4j.CommandResponder;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.MessageDispatcherImpl;
import org.snmp4j.Snmp;
import org.snmp4j.TransportMapping;
import org.snmp4j.mp.MPv1;
import org.snmp4j.mp.MPv2c;
import org.snmp4j.mp.MPv3;
import org.snmp4j.mp.MessageProcessingModel;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.snmp4j.util.MultiThreadedMessageDispatcher;
import org.snmp4j.util.ThreadPool;
import org.snmp4j.util.WorkerPool;

public class SnmpTrap
implements CommandResponder {
    private Logger logger = Logger.getLogger(SnmpTrap.class);
    private MultiThreadedMessageDispatcher dispatcher;
    private ThreadPool threadPool;
    private TransportMapping transport = null;
    private Snmp _snmp = null;

    public void init() throws IOException {
        this.threadPool = ThreadPool.create((String)"Trap", (int)2);
        this.dispatcher = new MultiThreadedMessageDispatcher((WorkerPool)this.threadPool, (MessageDispatcher)new MessageDispatcherImpl());
        this.transport = new DefaultUdpTransportMapping(new UdpAddress("0.0.0.0/" + GlobalVariables.globalConfig.getTrapPort()));
        this._snmp = new Snmp((MessageDispatcher)this.dispatcher, this.transport);
        this._snmp.getMessageDispatcher().addMessageProcessingModel((MessageProcessingModel)new MPv1());
        this._snmp.getMessageDispatcher().addMessageProcessingModel((MessageProcessingModel)new MPv2c());
        this._snmp.getMessageDispatcher().addMessageProcessingModel((MessageProcessingModel)new MPv3());
        USM usm = new USM(SecurityProtocols.getInstance(), new OctetString(MPv3.createLocalEngineID()), 0);
        SecurityModels.getInstance().addSecurityModel((SecurityModel)usm);
        this._snmp.listen();
    }

    public void run() {
        try {
            this.init();
            this._snmp.addCommandResponder((CommandResponder)this);
        }
        catch (Exception ex) {
            this.logger.error((Object)("0.0.0.0:" + GlobalVariables.globalConfig.getTrapPort() + " " + ex.getMessage()));
        }
    }

    public void close() {
        try {
            this._snmp.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void processPdu(CommandResponderEvent respEvnt) {
        if (respEvnt != null && respEvnt.getPDU() != null) {
            String ipAddress = respEvnt.getPeerAddress().toString();
            ipAddress = ipAddress.substring(0, ipAddress.indexOf("/"));
            Vector recVBs = respEvnt.getPDU().getVariableBindings();
            int i = 0;
            while (i < recVBs.size()) {
                AbstractSNMPProcessor process;
                VariableBinding recVB = (VariableBinding)recVBs.elementAt(i);
                if (recVB.getOid().toString().equals("1.3.6.1.4.1.21111.1.2.17.999.0") && (process = (AbstractSNMPProcessor)GlobalProcessors.findProcessorByIPAddress(ipAddress)) != null) {
                    process.processTrap(recVB.getVariable().toString());
                }
                ++i;
            }
        }
    }
}

