/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.snmp4j;

import java.io.IOException;
import java.util.List;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.security.AuthMD5;
import org.snmp4j.security.PrivDES;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.Counter32;
import org.snmp4j.smi.Counter64;
import org.snmp4j.smi.Gauge32;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.UnsignedInteger32;
import org.snmp4j.smi.Variable;

public abstract class SnmpUtil {
    public Snmp _snmp = null;
    public TransportMapping transport = null;
    public Address targetAddress = null;
    public static final OctetString NO_AUTH = new OctetString("admin");
    public static final OctetString NO_AUTH_CONTEXT_NAME = new OctetString("admin");
    public static final OctetString AUTH = new OctetString("admin");
    public static final OctetString AUTH_CONTEXT_NAME = new OctetString("admin");
    public static final OctetString PRIV = new OctetString("admin");
    public static final OctetString PRIV_CONTEXT_NAME = new OctetString("admin");
    public static final OID AUTH_PROTOCOL = AuthMD5.ID;
    public static final OctetString AUTH_PASS = new OctetString("12345678");
    public static final OID PRIV_PROTOCOL = PrivDES.ID;
    public static final OctetString PRIV_PASS = new OctetString("12345678");
    public static String NOTSUPPORT = "999999999";
    public static final int SNMP_DATA_TYPE_COUNTER32 = 0;
    public static final int SNMP_DATA_TYPE_COUNTER64 = 1;
    public static final int SNMP_DATA_TYPE_GAUGE32 = 2;
    public static final int SNMP_DATA_TYPE_GENERICADDRESS = 3;
    public static final int SNMP_DATA_TYPE_INTEGER32 = 4;
    public static final int SNMP_DATA_TYPE_INTEGER64 = 5;
    public static final int SNMP_DATA_TYPE_IPADDRESS = 6;
    public static final int SNMP_DATA_TYPE_OCTETSTRING = 7;
    public static final int SNMP_DATA_TYPE_TIMETICKS = 8;
    public static final int SNMP_DATA_TYPE_UNSIGNEDINTEGER32 = 9;
    public static final String WORKINFO_DEFINE = "----";

    public abstract void initComm(String var1, int var2) throws IOException;

    public abstract Target getTarget();

    public abstract Object get(String var1) throws IOException;

    public abstract boolean set(String var1, String var2, int var3);

    public abstract List<Object> getTable(String var1);

    public Variable getDatatypeVariable(String value, int dataType) {
        switch (dataType) {
            case 0: {
                return new Counter32(Long.parseLong(value));
            }
            case 1: {
                return new Counter64(Long.parseLong(value));
            }
            case 2: {
                return new Gauge32(Long.parseLong(value));
            }
            case 3: {
                return new GenericAddress();
            }
            case 4: {
                return new Integer32(Integer.parseInt(value));
            }
            case 6: {
                return new IpAddress(value);
            }
            case 7: {
                return new OctetString(value);
            }
            case 8: {
                return new TimeTicks(Long.parseLong(value));
            }
            case 9: {
                return new UnsignedInteger32(Long.parseLong(value));
            }
        }
        return null;
    }

    public void close() throws IOException {
        if (this._snmp != null) {
            this._snmp.close();
            this._snmp = null;
        }
        if (this.transport != null) {
            this.transport.close();
            this.transport = null;
        }
    }

    public static boolean isSupport(String value) {
        return !value.equals(NOTSUPPORT);
    }
}

