/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.snmp4j;

import cn.com.voltronic.solar.snmp4j.SnmpUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.Session;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.snmp4j.util.DefaultPDUFactory;
import org.snmp4j.util.PDUFactory;
import org.snmp4j.util.TableEvent;
import org.snmp4j.util.TableUtils;

public class SnmpUtilV2
extends SnmpUtil {
    @Override
    public void initComm(String ip, int port) throws IOException {
        this.targetAddress = GenericAddress.parse((String)("udp:" + ip + "/" + port));
        this.transport = new DefaultUdpTransportMapping();
        this._snmp = new Snmp(this.transport);
        this.transport.listen();
    }

    @Override
    public Target getTarget() {
        CommunityTarget target = new CommunityTarget();
        target.setCommunity(new OctetString("public"));
        target.setAddress(this.targetAddress);
        target.setRetries(2);
        target.setTimeout(1800L);
        target.setVersion(1);
        return target;
    }

    @Override
    public Object get(String oid) throws IOException {
        String result = null;
        Target target = this.getTarget();
        PDU pdu = new PDU();
        pdu.add(new VariableBinding(new OID(String.valueOf(oid) + ".0")));
        pdu.setType(-96);
        ResponseEvent respEvnt = null;
        int num = 0;
        while (result == null && num < 3) {
            ++num;
            respEvnt = this._snmp.send(pdu, target);
            if (respEvnt == null || respEvnt.getResponse() == null) continue;
            Vector recVBs = respEvnt.getResponse().getVariableBindings();
            int i = 0;
            while (i < recVBs.size()) {
                VariableBinding recVB = (VariableBinding)recVBs.elementAt(i);
                result = recVB == null ? "----" : recVB.getVariable().toString();
                ++i;
            }
        }
        return result;
    }

    @Override
    public boolean set(String oid, String value, int dataType) {
        boolean result = true;
        Target target = this.getTarget();
        PDU pdu = new PDU();
        pdu.add(new VariableBinding(new OID(String.valueOf(oid) + ".0"), this.getDatatypeVariable(value, dataType)));
        pdu.setType(-93);
        try {
            ResponseEvent respEvnt = this._snmp.send(pdu, target);
            if (respEvnt != null && respEvnt.getResponse() != null) {
                if (respEvnt.getError() != null) {
                    result = false;
                }
                if (respEvnt.getResponse().getErrorStatus() != 0) {
                    System.out.println("error status:" + respEvnt.getResponse().getErrorStatus());
                    result = false;
                }
            }
        }
        catch (Exception e) {
            System.err.println("set \u7f51\u7edc\u4e2d\u65ad...." + e.getMessage());
        }
        return result;
    }

    @Override
    public List<Object> getTable(String oid) {
        ArrayList<Object> result = null;
        Target target = this.getTarget();
        DefaultPDUFactory pf = new DefaultPDUFactory(-96);
        TableUtils tu = new TableUtils((Session)this._snmp, (PDUFactory)pf);
        OID[] columns = new OID[]{new VariableBinding(new OID(oid)).getOid()};
        int num = 0;
        while ((result == null || result.size() <= 0) && num < 3) {
            result = new ArrayList<Object>();
            ++num;
            List list = tu.getTable(target, columns, null, null);
            int i = 0;
            while (i < list.size()) {
                TableEvent te = (TableEvent)list.get(i);
                VariableBinding[] vb = te.getColumns();
                if (vb != null) {
                    int j = 0;
                    while (j < vb.length) {
                        result.add(vb[j].getVariable());
                        ++j;
                    }
                }
                ++i;
            }
        }
        if (result == null || result.size() == 0) {
            System.err.println("gettable \u7f51\u7edc\u4e2d\u65ad...." + oid);
        }
        return result;
    }

    public static void main(String[] args) throws IOException {
        SnmpUtilV2 snmp = new SnmpUtilV2();
        ((SnmpUtil)snmp).initComm("192.168.107.119", 161);
        String id = ((SnmpUtil)snmp).get(".1.3.6.1.4.1.21111.1.2.1.2").toString();
        System.out.println(id);
    }
}

