/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.snmp4j;

import cn.com.voltronic.solar.snmp4j.SNMPConfig;
import cn.com.voltronic.solar.snmp4j.SnmpUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.snmp4j.PDU;
import org.snmp4j.ScopedPDU;
import org.snmp4j.Session;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.UserTarget;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.mp.MPv3;
import org.snmp4j.security.PrivAES128;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.snmp4j.util.DefaultPDUFactory;
import org.snmp4j.util.PDUFactory;
import org.snmp4j.util.TableEvent;
import org.snmp4j.util.TableUtils;

public class SnmpUtilV3
extends SnmpUtil {
    private SNMPConfig _snmpConfig;
    public OctetString securityName = null;
    public OctetString contextName = null;
    public OID authProtocol = null;
    public OID privProtocol = null;
    public OctetString authPassword = null;
    public OctetString privPassword = null;
    public int securityLevel = 3;

    public SnmpUtilV3() {
    }

    public SnmpUtilV3(SNMPConfig snmpConfig) {
        this._snmpConfig = snmpConfig;
        if (this._snmpConfig.isEncrypt() && this._snmpConfig.isProving()) {
            this.securityName = PRIV;
            this.contextName = PRIV_CONTEXT_NAME;
            this.authProtocol = AUTH_PROTOCOL;
            this.authPassword = new OctetString(this._snmpConfig.getPassword());
            this.privProtocol = PrivAES128.ID;
            this.privPassword = new OctetString(this._snmpConfig.getPassword());
            this.securityLevel = 3;
        } else if (!this._snmpConfig.isEncrypt() && this._snmpConfig.isProving()) {
            this.securityName = AUTH;
            this.contextName = AUTH_CONTEXT_NAME;
            this.authProtocol = AUTH_PROTOCOL;
            this.authPassword = new OctetString(this._snmpConfig.getPassword());
            this.privProtocol = null;
            this.privPassword = null;
            this.securityLevel = 2;
        } else if (!this._snmpConfig.isEncrypt() && !this._snmpConfig.isProving()) {
            this.securityName = NO_AUTH;
            this.contextName = NO_AUTH_CONTEXT_NAME;
            this.authProtocol = null;
            this.authPassword = null;
            this.privProtocol = null;
            this.privPassword = null;
            this.securityLevel = 1;
        }
    }

    @Override
    public void initComm(String ip, int port) throws IOException {
        this.targetAddress = GenericAddress.parse((String)("udp:" + ip + "/" + port));
        this.transport = new DefaultUdpTransportMapping();
        this._snmp = new Snmp(this.transport);
        USM usm = new USM(SecurityProtocols.getInstance(), new OctetString(MPv3.createLocalEngineID()), 0);
        SecurityModels.getInstance().addSecurityModel((SecurityModel)usm);
        UsmUser user = new UsmUser(this.securityName, this.authProtocol, this.authPassword, this.privProtocol, this.privPassword);
        this._snmp.getUSM().addUser(this.securityName, user);
        this.transport.listen();
    }

    @Override
    public Target getTarget() {
        UserTarget target = new UserTarget();
        target.setAddress(this.targetAddress);
        target.setSecurityLevel(this.securityLevel);
        target.setSecurityName(this.securityName);
        target.setVersion(3);
        target.setTimeout(1800L);
        return target;
    }

    @Override
    public Object get(String oid) throws IOException {
        String result = null;
        Target target = this.getTarget();
        ScopedPDU pdu = new ScopedPDU();
        pdu.add(new VariableBinding(new OID(String.valueOf(oid) + ".0")));
        pdu.setType(-96);
        pdu.setContextName(this.contextName);
        ResponseEvent respEvnt = null;
        int num = 0;
        while (result == null && num < 3) {
            ++num;
            respEvnt = this._snmp.send((PDU)pdu, target);
            if (respEvnt == null || respEvnt.getResponse() == null) continue;
            Vector recVBs = respEvnt.getResponse().getVariableBindings();
            int i = 0;
            while (i < recVBs.size()) {
                VariableBinding recVB = (VariableBinding)recVBs.elementAt(i);
                result = recVB == null ? "----" : recVB.getVariable().toString();
                ++i;
            }
        }
        return result;
    }

    @Override
    public List<Object> getTable(String oid) {
        ArrayList<Object> result = null;
        Target target = this.getTarget();
        DefaultPDUFactory pf = new DefaultPDUFactory(-96);
        TableUtils tu = new TableUtils((Session)this._snmp, (PDUFactory)pf);
        OID[] columns = new OID[]{new VariableBinding(new OID(oid)).getOid()};
        int num = 0;
        while ((result == null || result.size() <= 0) && num < 3) {
            result = new ArrayList<Object>();
            ++num;
            List list = tu.getTable(target, columns, null, null);
            int i = 0;
            while (i < list.size()) {
                TableEvent te = (TableEvent)list.get(i);
                VariableBinding[] vb = te.getColumns();
                if (vb != null) {
                    int j = 0;
                    while (j < vb.length) {
                        result.add(vb[j].getVariable());
                        ++j;
                    }
                }
                ++i;
            }
        }
        if (result == null || result.size() == 0) {
            System.err.println("gettable \u7f51\u7edc\u4e2d\u65ad...." + oid);
        }
        return result;
    }

    @Override
    public boolean set(String oid, String value, int dataType) {
        boolean result = true;
        Target target = this.getTarget();
        ScopedPDU pdu = new ScopedPDU();
        pdu.add(new VariableBinding(new OID(String.valueOf(oid) + ".0"), this.getDatatypeVariable(value, dataType)));
        pdu.setType(-93);
        pdu.setContextName(this.contextName);
        try {
            ResponseEvent respEvnt = this._snmp.send((PDU)pdu, target);
            if (respEvnt != null && respEvnt.getResponse() != null) {
                if (respEvnt.getError() != null) {
                    result = false;
                }
                if (respEvnt.getResponse().getErrorStatus() != 0) {
                    System.out.println("error status:" + respEvnt.getResponse().getErrorStatus());
                    result = false;
                }
            }
        }
        catch (Exception e) {
            System.err.println("set \u7f51\u7edc\u4e2d\u65ad...." + e.getMessage());
        }
        return result;
    }

    public static void main(String[] args) {
        try {
            SNMPConfig snmpConfig = new SNMPConfig();
            snmpConfig.setEncrypt(true);
            snmpConfig.setProving(true);
            snmpConfig.setPassword("87654321");
            snmpConfig.setV3(true);
            SnmpUtilV3 util = new SnmpUtilV3(snmpConfig);
            util.initComm("192.168.107.118", 161);
            System.out.println(util.get(".1.3.6.1.4.1.21111.1.1.8.1").toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

