/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.snmp4j;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

public class UdpClient {
    private String ip = "";
    private int port;
    private DatagramSocket ds = null;
    private InetAddress inetAddress;

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public UdpClient(String ip) throws SocketException, UnknownHostException {
        this.ip = ip;
        this.ds = new DatagramSocket();
        this.ds.setSoTimeout(1000);
        this.inetAddress = InetAddress.getByName(this.getIp());
    }

    public UdpClient(String ip, int port) throws SocketException, UnknownHostException {
        this.ip = ip;
        this.port = port;
        this.ds = new DatagramSocket();
        this.ds.setSoTimeout(1000);
        this.inetAddress = InetAddress.getByName(this.getIp());
    }

    public void setTimeout(int timeout) throws SocketException {
        this.ds.setSoTimeout(timeout);
    }

    public byte[] receive() throws IOException {
        byte[] buffer = new byte[64];
        DatagramPacket dp = new DatagramPacket(buffer, buffer.length);
        this.ds.receive(dp);
        return buffer;
    }

    public void disconnect() {
        this.ds.disconnect();
        this.ds.close();
    }

    public void send(String cmd) throws IOException {
        cmd = String.valueOf(cmd) + '\r';
        byte[] cmdb = cmd.getBytes();
        DatagramPacket dp = new DatagramPacket(cmdb, cmdb.length, this.inetAddress, this.getPort());
        this.ds.send(dp);
    }

    public String receiveString() throws IOException {
        byte[] buffer = new byte[512];
        DatagramPacket dp = new DatagramPacket(buffer, buffer.length);
        this.ds.receive(dp);
        String info = new String(dp.getData(), 0, dp.getLength());
        return info;
    }

    public static void main(String[] args) {
    }
}

