/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.snmpprocessor;

import cn.com.voltronic.solar.communicate.SNMPHandler;
import cn.com.voltronic.solar.data.bean.MachineInfo;
import cn.com.voltronic.solar.data.bean.WorkInfo;
import cn.com.voltronic.solar.protocol.IProtocol;
import cn.com.voltronic.solar.protocol.P30;
import cn.com.voltronic.solar.snmpprocessor.P30SNMPProcessor;
import cn.com.voltronic.solar.util.VolUtil;
import cn.com.voltronic.solar.view.ParameterJDialog;
import java.util.Date;

public class P301TO3KWSNMPProcessor
extends P30SNMPProcessor {
    public P301TO3KWSNMPProcessor(SNMPHandler handler, IProtocol protocol) {
        super(handler, protocol);
    }

    @Override
    public boolean pollQuery() {
        SNMPHandler snmp = this.getHandler();
        if (snmp == null) {
            this.close();
            return false;
        }
        if (this.refreshConfig) {
            this.getProtocol().setDelayChanging(true);
            this.queryMachineInfo();
            this.queryConfigData();
            this.queryCapability();
            this.refreshConfig = false;
        }
        if (this.bfirsttime) {
            this._preparalleltype = this._paralleltype;
            this.bfirsttime = false;
        } else if (this._preparalleltype != this._paralleltype) {
            this.close();
            return false;
        }
        if (!ParameterJDialog.startQueryThread) {
            this.getProtocol().setDelayChanging(false);
        }
        if (!this.getSerialNo().equals(snmp.getSerialNo())) {
            this.close();
            return false;
        }
        snmp.get(".1.3.6.1.4.1.21111.1.2.1.2");
        WorkInfo workInfo = (WorkInfo)this.getBeanBag().getBean("workinfo");
        workInfo.setProdid(this._protocol.getProtocolID());
        workInfo.setSerialno(snmp.getSerialNo());
        String qmod = snmp.get(".1.3.6.1.4.1.21111.1.2.1.3");
        String workMode = "Standby Mode";
        if (qmod.equals("Power on mode")) {
            workMode = "Power On Mode";
        } else if (qmod.equals("Standby mode")) {
            workMode = "Standby Mode";
        } else if (qmod.equals("Line mode")) {
            workMode = "Line Mode";
        } else if (qmod.equals("Battery mode")) {
            workMode = "Battery Mode";
        } else if (qmod.equals("Fault mode")) {
            workMode = "Fault Mode";
        } else if (qmod.equals("Power saving mode")) {
            workMode = "Power Saving Mode";
        }
        workInfo.setWorkMode(workMode);
        double gridVoltageR = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.4.8.1.2")) / 10.0;
        workInfo.setGridVoltageR(gridVoltageR);
        double gridFrequency = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.4.4")) / 10.0;
        workInfo.setGridFrequency(gridFrequency);
        double acOutputVoltageR = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.5.5.1.2")) / 10.0;
        workInfo.setAcOutputVoltageR(acOutputVoltageR);
        double acOutputFrequency = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.5.2")) / 10.0;
        workInfo.setAcOutputFrequency(acOutputFrequency);
        double acOutputApparentPower = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.5.5.1.3"));
        workInfo.setAcOutputApparentPower(acOutputApparentPower);
        double acOutputActivePower = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.5.3"));
        workInfo.setAcOutputActivePower(acOutputActivePower);
        int outputLoadPercent = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.5.4"));
        workInfo.setOutputLoadPercent(outputLoadPercent);
        double pBusVoltage = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.2.12"));
        workInfo.setPBUSVoltage(pBusVoltage);
        double pBatteryVoltage = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.3.5")) / 100.0;
        workInfo.setPBatteryVoltage(pBatteryVoltage);
        double chargingCurrent = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.3.16"));
        workInfo.setChargingCurrent(chargingCurrent);
        int batteryCapacity = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.3.17"));
        workInfo.setBatteryCapacity(batteryCapacity);
        int pvInputPower1 = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.6.2"));
        workInfo.setPvInputPower1(pvInputPower1);
        int pvInputCurrent = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.6.3.1.4"));
        workInfo.setPvInputCurrent(pvInputCurrent);
        double pvInputVoltage1 = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.6.3.1.2")) / 10.0;
        workInfo.setPvInputVoltage1(pvInputVoltage1);
        int batDischargeCurrent = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.3.11"));
        workInfo.setBatDisCurrent(batDischargeCurrent);
        workInfo.setCurrentTime(new Date());
        String deviceStatus = snmp.get(".1.3.6.1.4.1.21111.1.2.2.13");
        if (deviceStatus.length() > 9) {
            char ch3;
            char ch2;
            char ch0 = (deviceStatus = deviceStatus.substring(0, 8)).charAt(0);
            if (ch0 == '1') {
                workInfo.setCustomerV("1");
            } else {
                workInfo.setCustomerV("0");
            }
            char ch1 = deviceStatus.charAt(1);
            if (ch1 == '1') {
                this.getProtocol().setDelayChanging(true);
                this.queryMachineInfo();
                this.queryCapability();
                this.queryConfigData();
            }
            if ((ch2 = deviceStatus.charAt(2)) == '1') {
                this.queryMachineInfo();
            }
            if ((ch3 = deviceStatus.charAt(3)) == '1') {
                workInfo.setHasLoad(true);
            } else {
                workInfo.setHasLoad(false);
            }
            char ch5 = deviceStatus.charAt(5);
            if (ch5 == '1') {
                workInfo.setChargeOn(true);
            } else {
                workInfo.setChargeOn(false);
            }
            char ch6 = deviceStatus.charAt(6);
            if (ch6 == '1') {
                workInfo.setSCCchargeOn(true);
            } else {
                workInfo.setSCCchargeOn(false);
            }
            char ch7 = deviceStatus.charAt(7);
            if (ch7 == '1') {
                workInfo.setACchargeOn(true);
            } else {
                workInfo.setACchargeOn(false);
            }
            if (ch5 == '1' && ch6 == '1' && ch7 == '0') {
                workInfo.setIsPVCharging(1);
                workInfo.setIsShowChargingCurrent(1);
            } else if (ch5 == '1' && ch6 == '1' && ch7 == '1') {
                workInfo.setIsPVCharging(1);
                workInfo.setIsShowChargingCurrent(1);
                MachineInfo machineInfo = (MachineInfo)this.getBeanBag().getBean("machineinfo");
                if (P30.isALFAM(machineInfo)) {
                    workInfo.setIsShowChargingCurrent(0);
                }
            } else {
                workInfo.setIsPVCharging(0);
                workInfo.setIsShowChargingCurrent(0);
            }
        }
        if (workInfo.isChargeOn()) {
            if (workInfo.isSCCchargeOn() && workInfo.isACchargeOn()) {
                workInfo.setChargeSource("Solar and Utility");
            } else if (workInfo.isSCCchargeOn()) {
                workInfo.setChargeSource("Solar");
            } else if (workInfo.isACchargeOn()) {
                workInfo.setChargeSource("Utility");
            }
        } else {
            workInfo.setChargeSource("---");
        }
        if (workInfo.isHasLoad()) {
            if (workInfo.getWorkMode().equals("Line Mode")) {
                workInfo.setLoadSource("Utility");
            } else if (workInfo.getWorkMode().equals("Battery Mode")) {
                workInfo.setLoadSource("Battery");
            }
        } else {
            workInfo.setLoadSource("---");
        }
        return true;
    }
}

