/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.snmpprocessor;

import cn.com.voltronic.solar.communicate.SNMPHandler;
import cn.com.voltronic.solar.control.P30PlusDuoSNMPControlModule;
import cn.com.voltronic.solar.data.bean.ConfigData;
import cn.com.voltronic.solar.data.bean.DefaultData;
import cn.com.voltronic.solar.data.bean.MachineInfo;
import cn.com.voltronic.solar.data.bean.WorkInfo;
import cn.com.voltronic.solar.protocol.IProtocol;
import cn.com.voltronic.solar.protocol.P30;
import cn.com.voltronic.solar.snmpprocessor.P30SNMPProcessor;
import cn.com.voltronic.solar.util.VolUtil;
import cn.com.voltronic.solar.view.ParameterJDialog;
import cn.com.voltronic.util.VolStr;
import java.util.Date;
import java.util.List;
import net.wimpi.modbus.util.BitVector;

public class P30PlusDuoSNMPProcessor
extends P30SNMPProcessor {
    public P30PlusDuoSNMPProcessor(SNMPHandler handler, IProtocol protocol) {
        super(handler, protocol);
    }

    @Override
    protected void initControlModule() {
        this._control = new P30PlusDuoSNMPControlModule(this.getHandler());
    }

    @Override
    public boolean pollQuery() {
        String isExist;
        List<Object> existNums;
        SNMPHandler snmp = this.getHandler();
        if (snmp == null) {
            this.close();
            return false;
        }
        if (this.refreshConfig) {
            this.getProtocol().setDelayChanging(true);
            this.queryMachineInfo();
            this.queryConfigData();
            this.queryCapability();
            this.refreshConfig = false;
        }
        if (this.bfirsttime) {
            this._preparalleltype = this._paralleltype;
            this.bfirsttime = false;
        } else if (this._preparalleltype != this._paralleltype) {
            this.close();
            return false;
        }
        if (!ParameterJDialog.startQueryThread) {
            this.getProtocol().setDelayChanging(false);
        }
        if (!this.getSerialNo().equals(snmp.getSerialNo())) {
            this.close();
            return false;
        }
        if (this._paralleltype != 0) {
            return this.pollQueryParallel();
        }
        snmp.get(".1.3.6.1.4.1.21111.1.2.1.2");
        WorkInfo workInfo = (WorkInfo)this.getBeanBag().getBean("workinfo");
        workInfo.setProdid(this._protocol.getProtocolID());
        workInfo.setSerialno(snmp.getSerialNo());
        workInfo.setCurrentTime(new Date());
        String qmod = snmp.get(".1.3.6.1.4.1.21111.1.2.1.3");
        String workMode = "Standby Mode";
        if (qmod.equals("Power on mode")) {
            workMode = "Power On Mode";
        } else if (qmod.equals("Standby mode")) {
            workMode = "Standby Mode";
        } else if (qmod.equals("Line mode")) {
            workMode = "Line Mode";
        } else if (qmod.equals("Battery mode")) {
            workMode = "Battery Mode";
        } else if (qmod.equals("Fault mode")) {
            workMode = "Fault Mode";
        } else if (qmod.equals("Power saving mode")) {
            workMode = "Power Saving Mode";
        }
        workInfo.setWorkMode(workMode);
        double gridVoltageR = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.4.8.1.2")) / 10.0;
        workInfo.setGridVoltageR(gridVoltageR);
        double gridFrequency = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.4.4")) / 10.0;
        workInfo.setGridFrequency(gridFrequency);
        double acOutputVoltageR = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.5.5.1.2")) / 10.0;
        workInfo.setAcOutputVoltageR(acOutputVoltageR);
        double acOutputFrequency = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.5.2")) / 10.0;
        workInfo.setAcOutputFrequency(acOutputFrequency);
        double acOutputApparentPower = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.5.5.1.3"));
        workInfo.setAcOutputApparentPower(acOutputApparentPower);
        double acOutputActivePower = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.5.3"));
        workInfo.setAcOutputActivePower(acOutputActivePower);
        int outputLoadPercent = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.5.4"));
        workInfo.setOutputLoadPercent(outputLoadPercent);
        double pBusVoltage = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.2.12"));
        workInfo.setPBUSVoltage(pBusVoltage);
        double pBatteryVoltage = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.3.5")) / 100.0;
        workInfo.setPBatteryVoltage(pBatteryVoltage);
        double chargingCurrent = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.3.16"));
        workInfo.setChargingCurrent(chargingCurrent);
        int batteryCapacity = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.3.17"));
        workInfo.setBatteryCapacity(batteryCapacity);
        double pvInputVoltage1 = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.6.3.1.2")) / 10.0;
        workInfo.setPvInputVoltage1(pvInputVoltage1);
        int pvInputCurrent = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.6.3.1.4"));
        workInfo.setPvInputCurrent1(pvInputCurrent);
        int pvInputPower1 = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.6.3.1.6"));
        workInfo.setPvInputPower1(pvInputPower1);
        double batVolSCC1 = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.6.3.1.5")) / 100.0;
        workInfo.setBatVolSCC1(batVolSCC1);
        int batDischargeCurrent = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.3.11"));
        workInfo.setBatDisCurrent(batDischargeCurrent);
        String deviceStatus = snmp.get(".1.3.6.1.4.1.21111.1.2.2.13");
        if (deviceStatus.length() > 0) {
            char ch3;
            char ch2;
            char ch0 = deviceStatus.charAt(0);
            if (ch0 == '1') {
                workInfo.setCustomerV("1");
            } else {
                workInfo.setCustomerV("0");
            }
            char ch1 = deviceStatus.charAt(1);
            if (ch1 == '1') {
                this.getProtocol().setDelayChanging(true);
                this.queryMachineInfo();
                this.queryCapability();
                this.queryConfigData();
            }
            if ((ch2 = deviceStatus.charAt(2)) == '1') {
                this.queryMachineInfo();
            }
            if ((ch3 = deviceStatus.charAt(3)) == '1') {
                workInfo.setHasLoad(true);
            } else {
                workInfo.setHasLoad(false);
            }
            char ch5 = deviceStatus.charAt(5);
            if (ch5 == '1') {
                workInfo.setChargeOn(true);
            } else {
                workInfo.setChargeOn(false);
            }
            char ch6 = deviceStatus.charAt(6);
            if (ch6 == '1') {
                workInfo.setSCCchargeOn(true);
            } else {
                workInfo.setSCCchargeOn(false);
            }
            char ch7 = deviceStatus.charAt(7);
            if (ch7 == '1') {
                workInfo.setACchargeOn(true);
            } else {
                workInfo.setACchargeOn(false);
            }
            try {
                char ch11 = deviceStatus.charAt(11);
                if (ch11 == '1') {
                    workInfo.setSCCchargeOn2(true);
                } else {
                    workInfo.setSCCchargeOn2(false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (workInfo.isChargeOn()) {
                if (workInfo.isSCCchargeOn() && workInfo.isACchargeOn()) {
                    workInfo.setChargeSource("Solar and Utility");
                } else if (workInfo.isSCCchargeOn()) {
                    workInfo.setChargeSource("Solar");
                } else if (workInfo.isACchargeOn()) {
                    workInfo.setChargeSource("Utility");
                }
            } else {
                workInfo.setChargeSource("---");
            }
            if (workInfo.isHasLoad()) {
                if (workInfo.getWorkMode().equals("Line Mode")) {
                    workInfo.setLoadSource("Utility");
                } else if (workInfo.getWorkMode().equals("Battery Mode")) {
                    workInfo.setLoadSource("Battery");
                }
            } else {
                workInfo.setLoadSource("---");
            }
        }
        List<Object> pvInputCurrents = snmp.getTable(".1.3.6.1.4.1.21111.1.2.6.3.1.4");
        int pvInputCurrent2 = VolUtil.parseInt(pvInputCurrents.get(1).toString());
        workInfo.setPvInputCurrent2(pvInputCurrent2);
        List<Object> pvInputVoltages = snmp.getTable(".1.3.6.1.4.1.21111.1.2.6.3.1.2");
        double pvInputVoltage2 = VolUtil.parseDouble(pvInputVoltages.get(1).toString()) / 10.0;
        workInfo.setPvInputVoltage2(pvInputVoltage2);
        List<Object> batVolSCCs = snmp.getTable(".1.3.6.1.4.1.21111.1.2.6.3.1.5");
        double batVolSCC2 = VolUtil.parseDouble(batVolSCCs.get(1).toString()) / 100.0;
        workInfo.setBatVolSCC2(batVolSCC2);
        List<Object> pvInputPowers = snmp.getTable(".1.3.6.1.4.1.21111.1.2.6.3.1.6");
        int pvInputPower2 = VolUtil.parseInt(pvInputPowers.get(1).toString());
        workInfo.setPvInputPower2(pvInputPower2);
        double gridCurrentR = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.4.8.1.3"));
        workInfo.setGridCurrentR(gridCurrentR);
        double gridPowerR = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.4.8.1.4"));
        workInfo.setGridPowerR(gridPowerR);
        MachineInfo machineInfo = (MachineInfo)this.getBeanBag().getBean("machineinfo");
        if (P30.is4to5k(machineInfo.getAcOutputRatingApparentPower()) && (existNums = snmp.getTable(".1.3.6.1.4.1.21111.1.2.15.1.1.2")).size() > 0 && (isExist = existNums.get(0).toString()).equals("1")) {
            WorkInfo faultInfo = (WorkInfo)this.getBeanBag().getBean("workfault");
            List<Object> pv2InputVoltages = snmp.getTable(".1.3.6.1.4.1.21111.1.2.15.1.1.30");
            double pvInputVol2 = VolUtil.parseDouble(pv2InputVoltages.get(0).toString()) / 10.0;
            faultInfo.setPvInputVoltage2(pvInputVol2);
            this.explainQPGSN0(this);
        }
        return true;
    }

    @Override
    public boolean queryMachineInfo() {
        SNMPHandler snmp = this.getHandler();
        if (snmp == null) {
            return false;
        }
        MachineInfo machineInfo = (MachineInfo)this.getBeanBag().getBean("machineinfo");
        machineInfo.setSerialno(snmp.getSerialNo());
        String qvfw = snmp.get(".1.3.6.1.4.1.21111.1.2.1.5");
        machineInfo.setMainFirmwareVersion(qvfw);
        String qvfw2 = snmp.get(".1.3.6.1.4.1.21111.1.2.1.6");
        if (qvfw2.equals("")) {
            qvfw2 = "---";
        }
        machineInfo.setScc1CpuFirmwareVersion(qvfw2);
        String qvfw3 = snmp.get(".1.3.6.1.4.1.21111.1.2.1.11");
        if (qvfw3.equals("")) {
            qvfw3 = "---";
        }
        machineInfo.setScc2CpuFirmwareVersion(qvfw3);
        String qvfw4 = snmp.get(".1.3.6.1.4.1.21111.1.2.1.12");
        if (qvfw4.equals("")) {
            qvfw4 = "---";
        }
        machineInfo.setScc3CpuFirmwareVersion(qvfw4);
        double gridRatingVoltage = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.2.3")) / 10.0;
        double gridRatingCurrent = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.2.5")) / 10.0;
        double acOutputRatingVoltage = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.2.8")) / 10.0;
        double acOutputRatingFrequency = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.2.4")) / 10.0;
        double acOutputRatingCurrent = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.2.9")) / 10.0;
        double acOutputRatingApparentPower = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.2.2"));
        double acOutputRatingActivePower = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.2.1"));
        double batteryRatingVoltage = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.2.10")) / 10.0;
        String batteryTypeStr = snmp.get(".1.3.6.1.4.1.21111.1.2.11.5");
        double perMPPTRatingCurrent = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.14.69"));
        String inputVoltageRangeStr = snmp.get(".1.3.6.1.4.1.21111.1.2.11.6");
        String outputSourceStr = snmp.get(".1.3.6.1.4.1.21111.1.2.11.7");
        String chargeSourceStr = snmp.get(".1.3.6.1.4.1.21111.1.2.11.8");
        String machineTypeStr = snmp.get(".1.3.6.1.4.1.21111.1.2.1.7");
        String topologyStr = snmp.get(".1.3.6.1.4.1.21111.1.2.1.8");
        int outputmode = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.11.9"));
        this._protocol.setOutputMode(outputmode);
        machineInfo.setGridRatingVoltage(gridRatingVoltage);
        machineInfo.setGridRatingCurrent(gridRatingCurrent);
        machineInfo.setAcOutputRatingVoltage(acOutputRatingVoltage);
        machineInfo.setAcOutputRatingFrequency(acOutputRatingFrequency);
        machineInfo.setAcOutputRatingCurrent(acOutputRatingCurrent);
        machineInfo.setAcOutputRatingApparentPower(acOutputRatingApparentPower);
        machineInfo.setAcOutputRatingActivePower(acOutputRatingActivePower);
        machineInfo.setBatteryRatingVoltage(batteryRatingVoltage);
        machineInfo.setPerMPPTRatingCurrent(perMPPTRatingCurrent);
        String batteryType = "---";
        if (batteryTypeStr.equals("0")) {
            batteryType = "AGM";
        } else if (batteryTypeStr.equals("1")) {
            batteryType = "Flooded";
        }
        machineInfo.setBatteryType(batteryType);
        String inputVoltageRange = "---";
        if (inputVoltageRangeStr.equals("0")) {
            inputVoltageRange = "Appliance";
        } else if (inputVoltageRangeStr.equals("1")) {
            inputVoltageRange = "UPS";
        }
        machineInfo.setInputVoltageRange(inputVoltageRange);
        String outputSource = "---";
        if (outputSourceStr.equals("0")) {
            outputSource = "Utility";
        } else if (outputSourceStr.equals("1")) {
            outputSource = "Solar";
        } else if (outputSourceStr.equals("2")) {
            outputSource = "SBU";
        }
        machineInfo.setOutputSource(outputSource);
        String chargeSource = "---";
        if (chargeSourceStr.equals("0")) {
            chargeSource = "Utility";
        } else if (chargeSourceStr.equals("1")) {
            chargeSource = "Solar";
        } else if (chargeSourceStr.equals("2")) {
            chargeSource = "Solar and Utility";
        }
        machineInfo.setChargeSource(chargeSource);
        String machineType = "---";
        if (machineTypeStr.equals("0")) {
            machineType = "Grid tie";
        } else if (machineTypeStr.equals("1")) {
            machineType = "Stand alone";
        } else if (machineTypeStr.equals("2")) {
            machineType = "Hybrid";
        } else if (machineTypeStr.equals("11")) {
            machineType = "Stand alone";
            machineInfo.setMpptTrackNumber(2);
        } else if (machineTypeStr.equals("20")) {
            machineType = "Stand alone";
            machineInfo.setMpptTrackNumber(3);
        }
        machineInfo.setMachineType(machineType);
        String topology = "---";
        if (topologyStr.equals("0")) {
            topology = "Transformerless";
        } else if (topologyStr.equals("1")) {
            topology = "Transformer";
        }
        machineInfo.setTopology(topology);
        if (!P30.is1to3k(machineInfo.getAcOutputRatingApparentPower()) && P30.is4to5k(machineInfo.getAcOutputRatingApparentPower())) {
            double maxSolarChargingCurrent = this._protocol.getMpptTrackNumber() * 60;
            machineInfo.setMaxSolarChargingCurrent(maxSolarChargingCurrent);
        }
        return true;
    }

    @Override
    public boolean queryConfigData() {
        String qcst;
        String qmschgcr;
        String qpacchargstr;
        SNMPHandler snmp = this.getHandler();
        if (snmp == null) {
            return false;
        }
        MachineInfo machine = (MachineInfo)this.getBeanBag().getBean("machineinfo");
        ConfigData configdata = (ConfigData)this.getBeanBag().getBean("configdata");
        double outputVoltage = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.2.8")) / 10.0;
        configdata.setOutputVoltage(String.valueOf((int)outputVoltage));
        int outputFrequency = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.2.4")) / 10;
        configdata.setOutputFrequency(String.valueOf(outputFrequency));
        configdata.setBatteryVoltage(VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.2.10")) / 10.0);
        configdata.setRechargeVoltage(VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.14.49")) / 10.0);
        double batteryUnder = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.14.68")) / 10.0;
        configdata.setBatteryUnder(batteryUnder);
        if (configdata.getBatteryVoltage() > 40.0) {
            configdata.setMinBatteryUnder(40.0);
            configdata.setMaxBatteryUnder(48.0);
        } else if (configdata.getBatteryVoltage() > 20.0) {
            configdata.setMinBatteryUnder(20.0);
            configdata.setMaxBatteryUnder(24.0);
        } else {
            configdata.setMinBatteryUnder(10.0);
            configdata.setMaxBatteryUnder(12.0);
        }
        String batteryTypeStr = snmp.get(".1.3.6.1.4.1.21111.1.2.11.5");
        String batteryType = "AGM";
        if (batteryTypeStr.equals("0")) {
            batteryType = "AGM";
        } else if (batteryTypeStr.equals("1")) {
            batteryType = "Flooded";
        } else if (batteryTypeStr.equals("2")) {
            batteryType = "User";
        }
        configdata.setBatteryType(batteryType);
        double maxChargeCurrent = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.14.69"));
        if (machine.isChargeCurrentComBox()) {
            configdata.setMaxacchargingcurrent(maxChargeCurrent);
        } else {
            configdata.setMaxMaxChargeCurrent(maxChargeCurrent);
        }
        double currentChargeCurrent = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.14.34"));
        configdata.setMaxChargeCurrent(currentChargeCurrent);
        configdata.setMinMaxChargeCurrent(10.0);
        double maxChargeVoltage = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.14.54")) / 10.0;
        configdata.setMaxChargeVoltage(maxChargeVoltage);
        if (configdata.getBatteryVoltage() > 40.0) {
            configdata.setMinMaxChargeVoltage(48.0);
            configdata.setMaxMaxChargeVoltage(58.4);
        } else if (configdata.getBatteryVoltage() > 20.0) {
            configdata.setMinMaxChargeVoltage(24.0);
            configdata.setMaxMaxChargeVoltage(29.21);
        } else {
            configdata.setMinMaxChargeVoltage(12.0);
            configdata.setMaxMaxChargeVoltage(14.6);
        }
        double floatChargVoltage = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.14.57")) / 10.0;
        configdata.setFloatingChargeVoltage(floatChargVoltage);
        if (configdata.getBatteryVoltage() > 40.0) {
            configdata.setMinFloatingChargeVoltage(48.0);
            configdata.setMaxFloatingChargeVoltage(58.4);
        } else if (configdata.getBatteryVoltage() > 20.0) {
            configdata.setMinFloatingChargeVoltage(24.0);
            configdata.setMaxFloatingChargeVoltage(29.21);
        } else {
            configdata.setMinFloatingChargeVoltage(12.0);
            configdata.setMaxFloatingChargeVoltage(14.6);
        }
        String inputVoltageRangeStr = snmp.get(".1.3.6.1.4.1.21111.1.2.11.6");
        String inputVoltageRange = "Appliance";
        if (inputVoltageRangeStr.equals("0")) {
            inputVoltageRange = "Appliance";
        } else if (inputVoltageRangeStr.equals("1")) {
            inputVoltageRange = "UPS";
        }
        configdata.setAcInputRange(inputVoltageRange);
        String outputSourceStr = snmp.get(".1.3.6.1.4.1.21111.1.2.11.7");
        String outputSource = "Utility";
        if (outputSourceStr.equals("0")) {
            outputSource = "Utility";
        } else if (outputSourceStr.equals("1")) {
            outputSource = "Solar";
        } else if (outputSourceStr.equals("2")) {
            outputSource = "SBU";
        }
        configdata.setOutputSource(outputSource);
        String chargeSourceStr = snmp.get(".1.3.6.1.4.1.21111.1.2.11.8");
        String chargeSource = "Utility";
        if (chargeSourceStr.equals("0")) {
            chargeSource = "Utility";
        } else if (chargeSourceStr.equals("1")) {
            chargeSource = "Solar first";
        } else if (chargeSourceStr.equals("2")) {
            chargeSource = "Utility and Solar";
        } else if (chargeSourceStr.equals("3")) {
            chargeSource = "Solar only";
        }
        configdata.setChargerSource(chargeSource);
        int outputmode = Integer.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.11.9"));
        this._protocol.setOutputMode(outputmode);
        if (outputmode != 0) {
            this._paralleltype = 1;
            this._parallelnum = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.2.11"));
        } else {
            this._paralleltype = 0;
        }
        double batReDischargeVol = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.14.58")) / 10.0;
        if (VolUtil.round(batReDischargeVol, 0) == 0.0) {
            configdata.setReDischargeVoltage("FULL");
        } else {
            configdata.setReDischargeVoltage(String.valueOf(batReDischargeVol));
        }
        if (VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.14.59")) == 1) {
            configdata.setAllpvok(true);
        } else {
            configdata.setAllpvok(false);
        }
        if (VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.14.60")) == 1) {
            configdata.setSolarbalance(true);
        } else {
            configdata.setSolarbalance(false);
        }
        String qmchgcr = snmp.get(".1.3.6.1.4.1.21111.1.2.3.20");
        double acOutputRatingApparentPower = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.2.2"));
        String machineType = snmp.get(".1.3.6.1.4.1.21111.1.2.1.7");
        if (this.is4to5k(acOutputRatingApparentPower) && machineType.equals("11")) {
            qmchgcr = "010 020 030 040 050 060 070 080 090 100 110 120 130 140 150 160 170 180";
        } else if (this.is4to5k(acOutputRatingApparentPower) && machineType.equals("20")) {
            qmchgcr = "010 020 030 040 050 060 070 080 090 100 110 120 130 140 150 160 170 180 190 200 210 220 230 240";
        }
        if (qmchgcr.length() > 0) {
            String[] item = qmchgcr.split(" ");
            if (machine.isChargeCurrentComBox()) {
                int index = 0;
                while (index < item.length) {
                    try {
                        item[index] = String.format("%d", VolUtil.parseInt(item[index]));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++index;
                }
                configdata.setChargingCurrentComBox(item);
            } else {
                configdata.setMinMaxChargeCurrent(VolUtil.parseDouble(item[0]));
                configdata.setMaxMaxChargeCurrent(VolUtil.parseDouble(item[1]));
            }
        }
        if ((qpacchargstr = snmp.get(".1.3.6.1.4.1.21111.1.2.3.21")).length() > 0) {
            String[] item = qpacchargstr.split(" ");
            int index = 0;
            while (index < item.length) {
                try {
                    item[index] = String.format("%d", VolUtil.parseInt(item[index]));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++index;
            }
            configdata.setAcChargingCurrentComBox(item);
        }
        if ((qmschgcr = snmp.get(".1.3.6.1.4.1.21111.1.2.14.84")).length() > 0) {
            String[] item = qmschgcr.split(" ");
            int index = 0;
            while (index < item.length) {
                try {
                    item[index] = String.format("%d", Integer.parseInt(item[index]));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++index;
            }
            configdata.setMaxSolarChargingCurrentCombox(item);
        }
        if ((qcst = snmp.get(".1.3.6.1.4.1.21111.1.2.14.82")).equals("0")) {
            qcst = "Auto";
        } else if (qcst.equals("1")) {
            qcst = "2-stage";
        } else if (qcst.equals("2")) {
            qcst = "3-stage";
        }
        configdata.setChargingStage(qcst);
        String qcvt = snmp.get(".1.3.6.1.4.1.21111.1.2.14.83");
        if (qcvt.length() == 1) {
            qcvt = "00" + qcvt;
        } else if (qcvt.length() == 2) {
            qcvt = "0" + qcvt;
        }
        if (qcvt.equals("255")) {
            qcvt = "Auto";
        }
        configdata.setChargingTimeInCvMode(qcvt);
        return true;
    }

    @Override
    public boolean queryDefaultData() {
        SNMPHandler snmp = this.getHandler();
        if (snmp == null) {
            return false;
        }
        DefaultData defaultData = (DefaultData)this.getBeanBag().getBean("defaultdata");
        defaultData.setAcOutputVoltage(VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.9.48")) / 10.0);
        defaultData.setAcOutputFrequency(VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.9.49")) / 10.0);
        defaultData.setMaxACChargingCurrent(VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.9.50")));
        defaultData.setBatteryCutoffVoltage(VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.9.51")) / 10.0);
        defaultData.setFloatChargingVoltage(VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.9.52")) / 10.0);
        defaultData.setMaxChargingVoltage(VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.9.53")) / 10.0);
        defaultData.setReChangingVoltage(VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.9.54")) / 10.0);
        defaultData.setMaxChargingCurrent(VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.9.55")));
        int acInputVoltage = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.9.56"));
        int outputSourcePriority = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.9.57"));
        int chargerSourcePriority = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.9.58"));
        int batteryType = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.9.59"));
        if (acInputVoltage == 0) {
            defaultData.setAcInputVoltage("Appliance");
        } else {
            defaultData.setAcInputVoltage("UPS");
        }
        if (outputSourcePriority == 0) {
            defaultData.setOutputSourcePriority("Utility");
        } else if (outputSourcePriority == 1) {
            defaultData.setOutputSourcePriority("Solar");
        } else if (outputSourcePriority == 2) {
            defaultData.setOutputSourcePriority("SBU");
        }
        if (chargerSourcePriority == 0) {
            defaultData.setChargerSourcePriority("Utility");
        } else if (chargerSourcePriority == 1) {
            defaultData.setChargerSourcePriority("Solar");
        } else if (chargerSourcePriority == 2) {
            defaultData.setChargerSourcePriority("Utility and Solar");
        } else if (chargerSourcePriority == 3) {
            defaultData.setChargerSourcePriority("Solar only");
        }
        if (batteryType == 0) {
            defaultData.setBatteryType("AGM");
        } else {
            defaultData.setBatteryType("Flooded");
        }
        int capableA = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.9.60"));
        int capableJ = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.9.61"));
        int capableU = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.9.62"));
        int capableV = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.9.63"));
        int capableX = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.9.64"));
        int capableY = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.9.65"));
        int capableZ = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.9.66"));
        int capableB = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.9.67"));
        int capableK = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.9.68"));
        if (capableA == 0) {
            defaultData.setCapableA("Disable");
        } else {
            defaultData.setCapableA("Enable");
        }
        if (capableJ == 0) {
            defaultData.setCapableJ("Disable");
        } else {
            defaultData.setCapableJ("Enable");
        }
        if (capableU == 0) {
            defaultData.setCapableU("Disable");
        } else {
            defaultData.setCapableU("Enable");
        }
        if (capableV == 0) {
            defaultData.setCapableV("Disable");
        } else {
            defaultData.setCapableV("Enable");
        }
        if (capableX == 0) {
            defaultData.setCapableX("Disable");
        } else {
            defaultData.setCapableX("Enable");
        }
        if (capableY == 0) {
            defaultData.setCapableY("Disable");
        } else {
            defaultData.setCapableY("Enable");
        }
        if (capableZ == 0) {
            defaultData.setCapableZ("Disable");
        } else {
            defaultData.setCapableZ("Enable");
        }
        if (capableB == 0) {
            defaultData.setCapableB("Disable");
        } else {
            defaultData.setCapableB("Enable");
        }
        if (capableK == 0) {
            defaultData.setCapableK("Disable");
        } else {
            defaultData.setCapableK("Enable");
        }
        String[] modes = new String[]{"Single", "Parallel", "Phase R of 3 phase output", "Phase S of 3 phase output", "Phase T of 3 phase output"};
        int outputmode = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.9.69"));
        if (outputmode >= 0 && outputmode <= 4) {
            defaultData.setOutputMode(modes[outputmode]);
        }
        defaultData.setReDischargeVoltage(VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.9.70")) / 10.0);
        String stage = snmp.get(".1.3.6.1.4.1.21111.1.2.9.82");
        if (stage.equals("0")) {
            stage = "Auto";
        } else if (stage.equals("1")) {
            stage = "2-stage";
        } else if (stage.equals("2")) {
            stage = "3-stage";
        }
        defaultData.setChargingStage(stage);
        defaultData.setMaxSolarChargingCurrent(VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.9.20")));
        String mode = snmp.get(".1.3.6.1.4.1.21111.1.2.9.83");
        if (mode.length() == 1) {
            mode = "00" + mode;
        } else if (mode.length() == 2) {
            mode = "0" + mode;
        }
        if (mode.equals("255")) {
            mode = "Auto";
        }
        defaultData.setChargingTimeInCvMode(mode);
        return true;
    }

    @Override
    public void processTrap(String trapid_hex) {
        SNMPHandler snmp = this.getHandler();
        if (snmp == null) {
            return;
        }
        WorkInfo workinfo = (WorkInfo)this.getBeanBag().getBean("workinfo");
        workinfo.setProdid(this._protocol.getProtocolID());
        workinfo.setSerialno(this.getProtocol().getSerialNo());
        workinfo.setCurrentTime(new Date());
        this.parsingWarntrap(workinfo, trapid_hex.substring(1));
    }

    private void parsingWarntrap(WorkInfo workinfo, String trapid_hex) {
        byte[] bytes = VolStr.hexStringToBytes((String)trapid_hex);
        BitVector warnStatus = new BitVector(128);
        warnStatus.toggleAccess(true);
        warnStatus.setBytes(bytes);
        String newWarnStatus = "";
        int item = 0;
        while (item < 64) {
            newWarnStatus = warnStatus.getBit(item) ? String.valueOf(newWarnStatus) + "1" : String.valueOf(newWarnStatus) + "0";
            ++item;
        }
        String qpiwsStr = newWarnStatus;
        this.hasFault = qpiwsStr.charAt(1) == '1';
        if (qpiwsStr.charAt(15) == '1') {
            workinfo.setOverLoad(true);
        } else {
            workinfo.setOverLoad(false);
        }
        this.warnsHandler(qpiwsStr, 2, "2001", workinfo);
        this.warnsHandler(qpiwsStr, 3, "2002", workinfo);
        this.warnsHandler(qpiwsStr, 4, "2003", workinfo);
        this.warnsHandler(qpiwsStr, 5, "2004", workinfo);
        this.warnsHandler(qpiwsStr, 6, "2005", workinfo);
        this.warnsHandler(qpiwsStr, 7, "2006", workinfo);
        this.warnsHandler(qpiwsStr, 8, "2007", workinfo);
        this.warnsHandler(qpiwsStr, 9, "2008", workinfo, this.hasFault, "1011");
        this.warnsHandler(qpiwsStr, 10, "2009", workinfo, this.hasFault, "1001");
        this.warnsHandler(qpiwsStr, 11, "2010", workinfo, this.hasFault, "1002");
        this.warnsHandler(qpiwsStr, 12, "2011", workinfo);
        this.warnsHandler(qpiwsStr, 13, "2012", workinfo);
        this.warnsHandler(qpiwsStr, 14, "2013", workinfo);
        this.warnsHandler(qpiwsStr, 15, "2014", workinfo);
        this.warnsHandler(qpiwsStr, 16, "2015", workinfo, this.hasFault, "1003");
        this.warnsHandler(qpiwsStr, 18, "1004", workinfo);
        this.warnsHandler(qpiwsStr, 19, "1005", workinfo);
        this.warnsHandler(qpiwsStr, 20, "1006", workinfo);
        this.warnsHandler(qpiwsStr, 21, "1007", workinfo);
        this.warnsHandler(qpiwsStr, 22, "1008", workinfo);
        this.warnsHandler(qpiwsStr, 23, "1009", workinfo);
        this.warnsHandler(qpiwsStr, 24, "1010", workinfo);
        this.warnsHandler(qpiwsStr, 25, "2017", workinfo);
        this.warnsHandler(qpiwsStr, 26, "2018", workinfo);
        this.warnsHandler(qpiwsStr, 27, "2020", workinfo);
        this.warnsHandler(qpiwsStr, 28, "2022", workinfo);
        this.warnsHandler(qpiwsStr, 29, "2024", workinfo);
        this.warnsHandler(qpiwsStr, 30, "2019", workinfo);
        this.warnsHandler(qpiwsStr, 31, "2021", workinfo);
        this.warnsHandler(qpiwsStr, 32, "2023", workinfo);
        this.warnsHandler(qpiwsStr, 33, "2025", workinfo);
    }
}

