/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.snmpprocessor;

import cn.com.voltronic.solar.communicate.SNMPHandler;
import cn.com.voltronic.solar.data.bean.WorkInfo;
import cn.com.voltronic.solar.protocol.IProtocol;
import cn.com.voltronic.solar.snmpprocessor.P30PlusDuoSNMPProcessor;
import cn.com.voltronic.solar.util.VolUtil;
import cn.com.voltronic.solar.view.ParameterJDialog;
import cn.com.voltronic.util.VolStr;
import java.util.Date;
import java.util.List;
import net.wimpi.modbus.util.BitVector;

public class P30PlusTriSNMPProcessor
extends P30PlusDuoSNMPProcessor {
    public P30PlusTriSNMPProcessor(SNMPHandler handler, IProtocol protocol) {
        super(handler, protocol);
    }

    @Override
    public boolean pollQuery() {
        String isExist;
        SNMPHandler snmp = this.getHandler();
        if (snmp == null) {
            this.close();
            return false;
        }
        if (this.refreshConfig) {
            this.getProtocol().setDelayChanging(true);
            this.queryMachineInfo();
            this.queryConfigData();
            this.queryCapability();
            this.refreshConfig = false;
        }
        if (this.bfirsttime) {
            this._preparalleltype = this._paralleltype;
            this.bfirsttime = false;
        } else if (this._preparalleltype != this._paralleltype) {
            this.close();
            return false;
        }
        if (!ParameterJDialog.startQueryThread) {
            this.getProtocol().setDelayChanging(false);
        }
        if (!this.getSerialNo().equals(snmp.getSerialNo())) {
            this.close();
            return false;
        }
        if (this._paralleltype != 0) {
            return this.pollQueryParallel();
        }
        snmp.get(".1.3.6.1.4.1.21111.1.2.1.2");
        WorkInfo workInfo = (WorkInfo)this.getBeanBag().getBean("workinfo");
        workInfo.setProdid(this._protocol.getProtocolID());
        workInfo.setSerialno(snmp.getSerialNo());
        workInfo.setCurrentTime(new Date());
        String qmod = snmp.get(".1.3.6.1.4.1.21111.1.2.1.3");
        String workMode = "Standby Mode";
        if (qmod.equals("Power on mode")) {
            workMode = "Power On Mode";
        } else if (qmod.equals("Standby mode")) {
            workMode = "Standby Mode";
        } else if (qmod.equals("Line mode")) {
            workMode = "Line Mode";
        } else if (qmod.equals("Battery mode")) {
            workMode = "Battery Mode";
        } else if (qmod.equals("Fault mode")) {
            workMode = "Fault Mode";
        } else if (qmod.equals("Power saving mode")) {
            workMode = "Power Saving Mode";
        }
        workInfo.setWorkMode(workMode);
        double gridVoltageR = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.4.8.1.2")) / 10.0;
        workInfo.setGridVoltageR(gridVoltageR);
        double gridFrequency = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.4.4")) / 10.0;
        workInfo.setGridFrequency(gridFrequency);
        double acOutputVoltageR = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.5.5.1.2")) / 10.0;
        workInfo.setAcOutputVoltageR(acOutputVoltageR);
        double acOutputFrequency = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.5.2")) / 10.0;
        workInfo.setAcOutputFrequency(acOutputFrequency);
        double acOutputApparentPower = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.5.5.1.3"));
        workInfo.setAcOutputApparentPower(acOutputApparentPower);
        double acOutputActivePower = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.5.3"));
        workInfo.setAcOutputActivePower(acOutputActivePower);
        int outputLoadPercent = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.5.4"));
        workInfo.setOutputLoadPercent(outputLoadPercent);
        double pBusVoltage = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.2.12"));
        workInfo.setPBUSVoltage(pBusVoltage);
        double pBatteryVoltage = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.3.5")) / 100.0;
        workInfo.setPBatteryVoltage(pBatteryVoltage);
        double chargingCurrent = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.3.16"));
        workInfo.setChargingCurrent(chargingCurrent);
        int batteryCapacity = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.3.17"));
        workInfo.setBatteryCapacity(batteryCapacity);
        double pvInputVoltage1 = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.6.3.1.2")) / 10.0;
        workInfo.setPvInputVoltage1(pvInputVoltage1);
        int pvInputCurrent = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.6.3.1.4"));
        workInfo.setPvInputCurrent1(pvInputCurrent);
        int pvInputPower1 = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.6.3.1.6"));
        workInfo.setPvInputPower1(pvInputPower1);
        double batVolSCC1 = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.6.3.1.5")) / 100.0;
        workInfo.setBatVolSCC1(batVolSCC1);
        int batDischargeCurrent = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.3.11"));
        workInfo.setBatDisCurrent(batDischargeCurrent);
        String deviceStatus = snmp.get(".1.3.6.1.4.1.21111.1.2.2.13");
        if (deviceStatus.length() > 9) {
            char ch3;
            char ch2;
            char ch0 = deviceStatus.charAt(0);
            if (ch0 == '1') {
                workInfo.setCustomerV("1");
            } else {
                workInfo.setCustomerV("0");
            }
            char ch1 = deviceStatus.charAt(1);
            if (ch1 == '1') {
                this.getProtocol().setDelayChanging(true);
                this.queryMachineInfo();
                this.queryCapability();
                this.queryConfigData();
            }
            if ((ch2 = deviceStatus.charAt(2)) == '1') {
                this.queryMachineInfo();
            }
            if ((ch3 = deviceStatus.charAt(3)) == '1') {
                workInfo.setHasLoad(true);
            } else {
                workInfo.setHasLoad(false);
            }
            char ch5 = deviceStatus.charAt(5);
            if (ch5 == '1') {
                workInfo.setChargeOn(true);
            } else {
                workInfo.setChargeOn(false);
            }
            char ch6 = deviceStatus.charAt(6);
            if (ch6 == '1') {
                workInfo.setSCCchargeOn(true);
            } else {
                workInfo.setSCCchargeOn(false);
            }
            char ch7 = deviceStatus.charAt(7);
            if (ch7 == '1') {
                workInfo.setACchargeOn(true);
            } else {
                workInfo.setACchargeOn(false);
            }
            char ch11 = deviceStatus.charAt(11);
            if (ch11 == '1') {
                workInfo.setSCCchargeOn2(true);
            } else {
                workInfo.setSCCchargeOn2(false);
            }
            char ch12 = deviceStatus.charAt(12);
            if (ch12 == '1') {
                workInfo.setSCCchargeOn3(true);
            } else {
                workInfo.setSCCchargeOn3(false);
            }
            if (workInfo.isChargeOn()) {
                if (workInfo.isSCCchargeOn() && workInfo.isACchargeOn()) {
                    workInfo.setChargeSource("Solar and Utility");
                } else if (workInfo.isSCCchargeOn()) {
                    workInfo.setChargeSource("Solar");
                } else if (workInfo.isACchargeOn()) {
                    workInfo.setChargeSource("Utility");
                }
            } else {
                workInfo.setChargeSource("---");
            }
            if (workInfo.isHasLoad()) {
                if (workInfo.getWorkMode().equals("Line Mode")) {
                    workInfo.setLoadSource("Utility");
                } else if (workInfo.getWorkMode().equals("Battery Mode")) {
                    workInfo.setLoadSource("Battery");
                }
            } else {
                workInfo.setLoadSource("---");
            }
        }
        List<Object> pvInputCurrents = snmp.getTable(".1.3.6.1.4.1.21111.1.2.6.3.1.4");
        int pvInputCurrent2 = VolUtil.parseInt(pvInputCurrents.get(1).toString());
        int pvInputCurrent3 = VolUtil.parseInt(pvInputCurrents.get(2).toString());
        workInfo.setPvInputCurrent2(pvInputCurrent2);
        workInfo.setPvInputCurrent3(pvInputCurrent3);
        List<Object> pvInputVoltages = snmp.getTable(".1.3.6.1.4.1.21111.1.2.6.3.1.2");
        double pvInputVoltage2 = VolUtil.parseDouble(pvInputVoltages.get(1).toString()) / 10.0;
        double pvInputVoltage3 = VolUtil.parseDouble(pvInputVoltages.get(2).toString()) / 10.0;
        workInfo.setPvInputVoltage2(pvInputVoltage2);
        workInfo.setPvInputVoltage3(pvInputVoltage3);
        List<Object> batVolSCCs = snmp.getTable(".1.3.6.1.4.1.21111.1.2.6.3.1.5");
        double batVolSCC2 = VolUtil.parseDouble(batVolSCCs.get(1).toString()) / 100.0;
        double batVolSCC3 = VolUtil.parseDouble(batVolSCCs.get(2).toString()) / 100.0;
        workInfo.setBatVolSCC2(batVolSCC2);
        workInfo.setBatVolSCC3(batVolSCC3);
        List<Object> pvInputPowers = snmp.getTable(".1.3.6.1.4.1.21111.1.2.6.3.1.6");
        int pvInputPower2 = VolUtil.parseInt(pvInputPowers.get(1).toString());
        int pvInputPower3 = VolUtil.parseInt(pvInputPowers.get(2).toString());
        workInfo.setPvInputPower2(pvInputPower2);
        workInfo.setPvInputPower3(pvInputPower3);
        double gridCurrentR = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.4.8.1.3"));
        workInfo.setGridCurrentR(gridCurrentR);
        double gridPowerR = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.4.8.1.4"));
        workInfo.setGridPowerR(gridPowerR);
        List<Object> existNums = snmp.getTable(".1.3.6.1.4.1.21111.1.2.15.1.1.2");
        if (existNums.size() > 0 && (isExist = existNums.get(0).toString()).equals("1")) {
            WorkInfo faultInfo = (WorkInfo)this.getBeanBag().getBean("workfault");
            List<Object> pv2InputVoltages = snmp.getTable(".1.3.6.1.4.1.21111.1.2.15.1.1.30");
            double pvInputVol2 = VolUtil.parseDouble(pv2InputVoltages.get(0).toString()) / 10.0;
            faultInfo.setPvInputVoltage2(pvInputVol2);
            List<Object> pv3InputVoltages = snmp.getTable(".1.3.6.1.4.1.21111.1.2.15.1.1.33");
            double pvInputVol3 = VolUtil.parseDouble(pv3InputVoltages.get(0).toString()) / 10.0;
            faultInfo.setPvInputVoltage3(pvInputVol3);
            this.explainQPGSN0(this);
        }
        return true;
    }

    @Override
    public void processTrap(String trapid_hex) {
        SNMPHandler snmp = this.getHandler();
        if (snmp == null) {
            return;
        }
        WorkInfo workinfo = (WorkInfo)this.getBeanBag().getBean("workinfo");
        workinfo.setProdid(this._protocol.getProtocolID());
        workinfo.setSerialno(this.getProtocol().getSerialNo());
        workinfo.setCurrentTime(new Date());
        this.parsingWarntrap(workinfo, trapid_hex.substring(1));
    }

    private void parsingWarntrap(WorkInfo workinfo, String trapid_hex) {
        byte[] bytes = VolStr.hexStringToBytes((String)trapid_hex);
        BitVector warnStatus = new BitVector(128);
        warnStatus.toggleAccess(true);
        warnStatus.setBytes(bytes);
        String newWarnStatus = "";
        int item = 0;
        while (item < 64) {
            newWarnStatus = warnStatus.getBit(item) ? String.valueOf(newWarnStatus) + "1" : String.valueOf(newWarnStatus) + "0";
            ++item;
        }
        String qpiwsStr = newWarnStatus;
        this.hasFault = qpiwsStr.charAt(1) == '1';
        if (qpiwsStr.charAt(15) == '1') {
            workinfo.setOverLoad(true);
        } else {
            workinfo.setOverLoad(false);
        }
        this.warnsHandler(qpiwsStr, 2, "2001", workinfo);
        this.warnsHandler(qpiwsStr, 3, "2002", workinfo);
        this.warnsHandler(qpiwsStr, 4, "2003", workinfo);
        this.warnsHandler(qpiwsStr, 5, "2004", workinfo);
        this.warnsHandler(qpiwsStr, 6, "2005", workinfo);
        this.warnsHandler(qpiwsStr, 7, "2006", workinfo);
        this.warnsHandler(qpiwsStr, 8, "2007", workinfo);
        this.warnsHandler(qpiwsStr, 9, "2008", workinfo, this.hasFault, "1011");
        this.warnsHandler(qpiwsStr, 10, "2009", workinfo, this.hasFault, "1001");
        this.warnsHandler(qpiwsStr, 11, "2010", workinfo, this.hasFault, "1002");
        this.warnsHandler(qpiwsStr, 12, "2011", workinfo);
        this.warnsHandler(qpiwsStr, 13, "2012", workinfo);
        this.warnsHandler(qpiwsStr, 14, "2013", workinfo);
        this.warnsHandler(qpiwsStr, 15, "2014", workinfo);
        this.warnsHandler(qpiwsStr, 16, "2015", workinfo, this.hasFault, "1003");
        this.warnsHandler(qpiwsStr, 18, "1004", workinfo);
        this.warnsHandler(qpiwsStr, 19, "1005", workinfo);
        this.warnsHandler(qpiwsStr, 20, "1006", workinfo);
        this.warnsHandler(qpiwsStr, 21, "1007", workinfo);
        this.warnsHandler(qpiwsStr, 22, "1008", workinfo);
        this.warnsHandler(qpiwsStr, 23, "1009", workinfo);
        this.warnsHandler(qpiwsStr, 24, "1010", workinfo);
        this.warnsHandler(qpiwsStr, 25, "2017", workinfo);
        this.warnsHandler(qpiwsStr, 26, "2018", workinfo);
        this.warnsHandler(qpiwsStr, 27, "2021", workinfo);
        this.warnsHandler(qpiwsStr, 28, "2024", workinfo);
        this.warnsHandler(qpiwsStr, 29, "2027", workinfo);
        this.warnsHandler(qpiwsStr, 30, "2019", workinfo);
        this.warnsHandler(qpiwsStr, 31, "2022", workinfo);
        this.warnsHandler(qpiwsStr, 32, "2025", workinfo);
        this.warnsHandler(qpiwsStr, 33, "2028", workinfo);
        this.warnsHandler(qpiwsStr, 34, "2020", workinfo);
        this.warnsHandler(qpiwsStr, 35, "2023", workinfo);
        this.warnsHandler(qpiwsStr, 36, "2026", workinfo);
        this.warnsHandler(qpiwsStr, 37, "2029", workinfo);
    }
}

