/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.snmpprocessor;

import cn.com.voltronic.solar.beanbag.P30BeanBag;
import cn.com.voltronic.solar.communicate.SNMPHandler;
import cn.com.voltronic.solar.comusbprocessor.ParallSubProcessor;
import cn.com.voltronic.solar.control.P30SNMPControlModule;
import cn.com.voltronic.solar.data.bean.Capability;
import cn.com.voltronic.solar.data.bean.ConfigData;
import cn.com.voltronic.solar.data.bean.DefaultData;
import cn.com.voltronic.solar.data.bean.MachineInfo;
import cn.com.voltronic.solar.data.bean.ProtocolInfo;
import cn.com.voltronic.solar.data.bean.WorkInfo;
import cn.com.voltronic.solar.exception.EventsHandler;
import cn.com.voltronic.solar.exception.FaultHandler;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.protocol.IProtocol;
import cn.com.voltronic.solar.protocol.P30;
import cn.com.voltronic.solar.snmpprocessor.AbstractSNMPProcessor;
import cn.com.voltronic.solar.system.GlobalProcessors;
import cn.com.voltronic.solar.util.VolUtil;
import cn.com.voltronic.solar.view.ParameterJDialog;
import cn.com.voltronic.util.VolStr;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.wimpi.modbus.util.BitVector;

public class P30SNMPProcessor
extends AbstractSNMPProcessor {
    public static Lock lock = new ReentrantLock();
    public boolean refreshConfig = false;
    public static final double DOUBLE_TEN = 10.0;
    public static final int INT_TEN = 10;
    public static final double DOUBLE_HUNDRED = 100.0;
    public int _preparalleltype = 0;
    public boolean bfirsttime = true;

    public P30SNMPProcessor(SNMPHandler handler, IProtocol protocol) {
        super(handler, protocol);
    }

    @Override
    protected void initBeanBag() {
        this._beanbag = new P30BeanBag();
    }

    @Override
    protected void initControlModule() {
        this._control = new P30SNMPControlModule(this.getHandler());
    }

    @Override
    public void initProtocol() {
        ProtocolInfo info = (ProtocolInfo)this.getBeanBag().getBean("protocolinfo");
        info.setProdid(this._protocol.getProtocolID());
        info.setBaseInfo(this._protocol.getBaseInfo());
        info.setProductInfo(this._protocol.getProductInfo());
        info.setRatingInfo(this._protocol.getRatingInfo());
        try {
            info.setSerialno(this._protocol.getSerialNo());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        info.setMoreInfo(this._protocol.getMoreInfo());
    }

    @Override
    public boolean pollQuery() {
        String isParallelNumExist;
        SNMPHandler snmp = this.getHandler();
        if (snmp == null) {
            this.close();
            return false;
        }
        if (this.refreshConfig) {
            this.getProtocol().setDelayChanging(true);
            this.queryMachineInfo();
            this.queryConfigData();
            this.queryCapability();
            this.refreshConfig = false;
        }
        if (this.bfirsttime) {
            this._preparalleltype = this._paralleltype;
            this.bfirsttime = false;
        } else if (this._preparalleltype != this._paralleltype) {
            this.close();
            return false;
        }
        if (!ParameterJDialog.startQueryThread) {
            this.getProtocol().setDelayChanging(false);
        }
        if (!this.getSerialNo().equals(snmp.getSerialNo())) {
            this.close();
            return false;
        }
        if (this._paralleltype != 0) {
            return this.pollQueryParallel();
        }
        WorkInfo workInfo = (WorkInfo)this.getBeanBag().getBean("workinfo");
        workInfo.setProdid(this._protocol.getProtocolID());
        workInfo.setSerialno(snmp.getSerialNo());
        String qmod = snmp.get(".1.3.6.1.4.1.21111.1.2.1.3");
        String workMode = "Standby Mode";
        if (qmod.equals("Power on mode")) {
            workMode = "Power On Mode";
        } else if (qmod.equals("Standby mode")) {
            workMode = "Standby Mode";
        } else if (qmod.equals("Line mode")) {
            workMode = "Line Mode";
        } else if (qmod.equals("Battery mode")) {
            workMode = "Battery Mode";
        } else if (qmod.equals("Fault mode")) {
            workMode = "Fault Mode";
        } else if (qmod.equals("Power saving mode")) {
            workMode = "Power Saving Mode";
        }
        workInfo.setWorkMode(workMode);
        double gridVoltageR = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.4.8.1.2")) / 10.0;
        workInfo.setGridVoltageR(gridVoltageR);
        double gridFrequency = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.4.4")) / 10.0;
        workInfo.setGridFrequency(gridFrequency);
        double acOutputVoltageR = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.5.5.1.2")) / 10.0;
        workInfo.setAcOutputVoltageR(acOutputVoltageR);
        double acOutputFrequency = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.5.2")) / 10.0;
        workInfo.setAcOutputFrequency(acOutputFrequency);
        double acOutputApparentPower = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.5.5.1.3"));
        workInfo.setAcOutputApparentPower(acOutputApparentPower);
        double acOutputActivePower = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.5.3"));
        workInfo.setAcOutputActivePower(acOutputActivePower);
        int outputLoadPercent = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.5.4"));
        workInfo.setOutputLoadPercent(outputLoadPercent);
        double pBusVoltage = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.2.12"));
        workInfo.setPBUSVoltage(pBusVoltage);
        double pBatteryVoltage = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.3.5")) / 100.0;
        workInfo.setPBatteryVoltage(pBatteryVoltage);
        double chargingCurrent = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.3.16"));
        workInfo.setChargingCurrent(chargingCurrent);
        int batteryCapacity = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.3.17"));
        workInfo.setBatteryCapacity(batteryCapacity);
        int pvInputCurrent = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.6.3.1.4"));
        workInfo.setPvInputCurrent(pvInputCurrent);
        double pvInputVoltage1 = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.6.3.1.2")) / 10.0;
        workInfo.setPvInputVoltage1(pvInputVoltage1);
        int batDischargeCurrent = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.3.11"));
        workInfo.setBatDisCurrent(batDischargeCurrent);
        workInfo.setCurrentTime(new Date());
        String deviceStatus = snmp.get(".1.3.6.1.4.1.21111.1.2.2.13");
        if (deviceStatus.length() > 9) {
            char ch3;
            char ch2;
            char ch0 = (deviceStatus = deviceStatus.substring(0, 8)).charAt(0);
            if (ch0 == '1') {
                workInfo.setCustomerV("1");
            } else {
                workInfo.setCustomerV("0");
            }
            char ch1 = deviceStatus.charAt(1);
            if (ch1 == '1') {
                this.getProtocol().setDelayChanging(true);
                this.queryMachineInfo();
                this.queryCapability();
                this.queryConfigData();
            }
            if ((ch2 = deviceStatus.charAt(2)) == '1') {
                this.queryMachineInfo();
            }
            if ((ch3 = deviceStatus.charAt(3)) == '1') {
                workInfo.setHasLoad(true);
            } else {
                workInfo.setHasLoad(false);
            }
            char ch5 = deviceStatus.charAt(5);
            if (ch5 == '1') {
                workInfo.setChargeOn(true);
            } else {
                workInfo.setChargeOn(false);
            }
            char ch6 = deviceStatus.charAt(6);
            if (ch6 == '1') {
                workInfo.setSCCchargeOn(true);
            } else {
                workInfo.setSCCchargeOn(false);
            }
            char ch7 = deviceStatus.charAt(7);
            if (ch7 == '1') {
                workInfo.setACchargeOn(true);
            } else {
                workInfo.setACchargeOn(false);
            }
            MachineInfo machineInfo = (MachineInfo)this.getBeanBag().getBean("machineinfo");
            if (machineInfo != null) {
                if (P30.is4to5k(machineInfo.getAcOutputRatingApparentPower())) {
                    workInfo.setIsPVCharging(1);
                } else if (P30.is1to3k(machineInfo.getAcOutputRatingApparentPower())) {
                    if (ch5 == '1' && ch6 == '1' && ch7 == '0') {
                        workInfo.setIsPVCharging(1);
                    } else if (ch5 == '1' && ch6 == '1' && ch7 == '1') {
                        workInfo.setIsPVCharging(1);
                    } else {
                        workInfo.setIsPVCharging(0);
                    }
                }
            }
        }
        if (workInfo.isChargeOn()) {
            if (workInfo.isSCCchargeOn() && workInfo.isACchargeOn()) {
                workInfo.setChargeSource("Solar and Utility");
            } else if (workInfo.isSCCchargeOn()) {
                workInfo.setChargeSource("Solar");
            } else if (workInfo.isACchargeOn()) {
                workInfo.setChargeSource("Utility");
            }
        } else {
            workInfo.setChargeSource("---");
        }
        if (workInfo.isHasLoad()) {
            if (workInfo.getWorkMode().equals("Line Mode")) {
                workInfo.setLoadSource("Utility");
            } else if (workInfo.getWorkMode().equals("Battery Mode")) {
                workInfo.setLoadSource("Battery");
            }
        } else {
            workInfo.setLoadSource("---");
        }
        if (this.executeControl("setParallelIndex", new Object[]{0}) && (isParallelNumExist = snmp.get(".1.3.6.1.4.1.21111.1.2.15.1.1.2")).equals("1")) {
            this.explainQPGSN0(this);
        }
        return true;
    }

    public void explainQPGSN0(AbstractProcessor processor) {
        try {
            SNMPHandler snmp = this.getHandler();
            if (snmp == null) {
                return;
            }
            WorkInfo workInfo = (WorkInfo)processor.getBeanBag().getBean("workfault");
            workInfo.setProdid(this._protocol.getProtocolID());
            workInfo.setSerialno(processor.getSerialNo());
            int qmod = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.15.1.1.4"));
            String workMode = "Standby Mode";
            if (qmod == 1) {
                workMode = "Power On Mode";
            } else if (qmod == 2) {
                workMode = "Standby Mode";
            } else if (qmod == 3) {
                workMode = "Line Mode";
            } else if (qmod == 4) {
                workMode = "Battery Mode";
            } else if (qmod == 5) {
                workMode = "Fault Mode";
            } else if (qmod == 6) {
                workMode = "Power Saving Mode";
            }
            workInfo.setWorkMode(workMode);
            double gridVoltageR = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.15.1.1.6")) / 10.0;
            workInfo.setGridVoltageR(gridVoltageR);
            double gridFrequency = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.15.1.1.7")) / 100.0;
            workInfo.setGridFrequency(gridFrequency);
            double acOutputVoltageR = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.15.1.1.8")) / 10.0;
            workInfo.setAcOutputVoltageR(acOutputVoltageR);
            double acOutputFrequency = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.15.1.1.9")) / 100.0;
            workInfo.setAcOutputFrequency(acOutputFrequency);
            double acOutputApparentPower = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.15.1.1.10"));
            workInfo.setAcOutputApparentPower(acOutputApparentPower);
            double acOutputActivePower = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.15.1.1.11"));
            workInfo.setAcOutputActivePower(acOutputActivePower);
            int outputLoadPercent = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.15.1.1.12"));
            workInfo.setOutputLoadPercent(outputLoadPercent);
            double pBatteryVoltage = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.15.1.1.13")) / 10.0;
            workInfo.setPBatteryVoltage(pBatteryVoltage);
            double chargingCurrent = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.15.1.1.14"));
            workInfo.setChargingCurrent(chargingCurrent);
            int batteryCapacity = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.15.1.1.15"));
            workInfo.setBatteryCapacity(batteryCapacity);
            double pvInputVoltage1 = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.15.1.1.16")) / 10.0;
            workInfo.setPvInputVoltage1(pvInputVoltage1);
            double ttlchargingCurrent = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.15.1.1.17"));
            workInfo.setTtlChargingCurrent(ttlchargingCurrent);
            double ttlAcoutputVA = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.15.1.1.18"));
            workInfo.setAcTtlOutputApparentPower(ttlAcoutputVA);
            double ttlAcoutputW = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.15.1.1.19"));
            workInfo.setAcTtlOutputActivePower(ttlAcoutputW);
            double ttlAcoutputPercent = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.15.1.1.20"));
            workInfo.setAcTtlOutputPercent(ttlAcoutputPercent);
            workInfo.setCurrentTime(new Date());
            int pvInputCurrent = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.15.1.1.27"));
            workInfo.setPvInputCurrent(pvInputCurrent);
            int batDischargeCurrent = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.15.1.1.28"));
            workInfo.setBatDisCurrent(batDischargeCurrent);
            String faultcode = snmp.get(".1.3.6.1.4.1.21111.1.2.15.1.1.5");
            if (faultcode.length() < 2) {
                faultcode = "0" + faultcode;
            }
            FaultHandler.doFaultEvent(workInfo, faultcode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized boolean pollQueryParallel() {
        boolean bParentLoss = true;
        int parall_i = 0;
        ArrayList<String> curList = new ArrayList<String>();
        ArrayList<String> delList = new ArrayList<String>();
        SNMPHandler snmp = this.getHandler();
        if (snmp == null) {
            return false;
        }
        try {
            parall_i = 0;
            while (parall_i < this._parallelnum) {
                int outputtype;
                List<Object> existNums = snmp.getTable(".1.3.6.1.4.1.21111.1.2.15.1.1.2");
                if (parall_i >= existNums.size()) break;
                String isExist = existNums.get(parall_i).toString();
                if (!isExist.equals("0") && (outputtype = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.15.1.1.22"))) != 0) {
                    String oldKey;
                    List<Object> serials = snmp.getTable(".1.3.6.1.4.1.21111.1.2.15.1.1.3");
                    String serial = serials.get(parall_i).toString();
                    curList.add(serial);
                    ParallSubProcessor processor = null;
                    if (this.subMap.containsKey(serial)) {
                        processor = (ParallSubProcessor)this.subMap.get(serial);
                        processor.setParallKey(parall_i);
                        this.explainQPGSN(processor, snmp, parall_i);
                        oldKey = processor.processorKey();
                        if (!processor.reGenProcesorKey().equalsIgnoreCase(oldKey)) {
                            GlobalProcessors.removeProcessor(oldKey);
                            GlobalProcessors.addProcessor(processor.processorKey(), processor);
                        }
                    } else if (serial.equalsIgnoreCase(this.getSerialNo())) {
                        this.setParallKey(parall_i);
                        this.explainQPGSN(this, snmp, parall_i);
                        oldKey = this.processorKey();
                        if (!this.reGenProcesorKey().equalsIgnoreCase(oldKey)) {
                            GlobalProcessors.removeProcessor(oldKey);
                            GlobalProcessors.addProcessor(this.processorKey(), this);
                        }
                        bParentLoss = false;
                    } else {
                        processor = new ParallSubProcessor(this, new P30BeanBag());
                        processor.setDeviceName(this.getDeviceName());
                        processor.setSerialNo(serial);
                        processor.setParallKey(parall_i);
                        this.explainQPGSN(processor, snmp, parall_i);
                        this.subMap.put(serial, processor);
                        processor.saveDevice();
                        GlobalProcessors.addProcessor(processor.processorKey(), processor);
                    }
                }
                ++parall_i;
            }
            for (Map.Entry entry : this.subMap.entrySet()) {
                if (curList.indexOf(entry.getKey()) >= 0) continue;
                ((ParallSubProcessor)entry.getValue()).close();
                delList.add((String)entry.getKey());
            }
            for (String key : delList) {
                this.subMap.remove(key);
            }
            if (bParentLoss) {
                this.close();
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean explainQPGSN(AbstractProcessor processor, SNMPHandler snmp, int parall_i) {
        try {
            WorkInfo workInfo = (WorkInfo)processor.getBeanBag().getBean("workinfo");
            workInfo.setProdid(this._protocol.getProtocolID());
            workInfo.setSerialno(processor.getSerialNo());
            ConfigData configdata = (ConfigData)processor.getBeanBag().getBean("configdata");
            List<Object> qmods = snmp.getTable(".1.3.6.1.4.1.21111.1.2.15.1.1.4");
            int qmod = VolUtil.parseInt(qmods.get(parall_i).toString());
            String workMode = "Standby Mode";
            if (qmod == 1) {
                workMode = "Power On Mode";
            } else if (qmod == 2) {
                workMode = "Standby Mode";
            } else if (qmod == 3) {
                workMode = "Line Mode";
            } else if (qmod == 4) {
                workMode = "Battery Mode";
            } else if (qmod == 5) {
                workMode = "Fault Mode";
            } else if (qmod == 6) {
                workMode = "Power Saving Mode";
            }
            workInfo.setWorkMode(workMode);
            List<Object> gridVoltage = snmp.getTable(".1.3.6.1.4.1.21111.1.2.15.1.1.6");
            double gridVoltageR = VolUtil.parseDouble(gridVoltage.get(parall_i).toString()) / 10.0;
            workInfo.setGridVoltageR(gridVoltageR);
            List<Object> gridFrequencys = snmp.getTable(".1.3.6.1.4.1.21111.1.2.15.1.1.7");
            double gridFrequency = VolUtil.parseDouble(gridFrequencys.get(parall_i).toString()) / 100.0;
            workInfo.setGridFrequency(gridFrequency);
            List<Object> acOutputVoltage = snmp.getTable(".1.3.6.1.4.1.21111.1.2.15.1.1.8");
            double acOutputVoltageR = VolUtil.parseDouble(acOutputVoltage.get(parall_i).toString()) / 10.0;
            workInfo.setAcOutputVoltageR(acOutputVoltageR);
            List<Object> acOutputFrequencys = snmp.getTable(".1.3.6.1.4.1.21111.1.2.15.1.1.9");
            double acOutputFrequency = VolUtil.parseDouble(acOutputFrequencys.get(parall_i).toString()) / 100.0;
            workInfo.setAcOutputFrequency(acOutputFrequency);
            List<Object> acOutputApparentPowers = snmp.getTable(".1.3.6.1.4.1.21111.1.2.15.1.1.10");
            double acOutputApparentPower = VolUtil.parseDouble(acOutputApparentPowers.get(parall_i).toString());
            workInfo.setAcOutputApparentPower(acOutputApparentPower);
            List<Object> acOutputActivePowers = snmp.getTable(".1.3.6.1.4.1.21111.1.2.15.1.1.11");
            double acOutputActivePower = VolUtil.parseDouble(acOutputActivePowers.get(parall_i).toString());
            workInfo.setAcOutputActivePower(acOutputActivePower);
            List<Object> outputLoadPercents = snmp.getTable(".1.3.6.1.4.1.21111.1.2.15.1.1.12");
            int outputLoadPercent = VolUtil.parseInt(outputLoadPercents.get(parall_i).toString());
            workInfo.setOutputLoadPercent(outputLoadPercent);
            List<Object> pBatteryVoltages = snmp.getTable(".1.3.6.1.4.1.21111.1.2.15.1.1.13");
            double pBatteryVoltage = VolUtil.parseDouble(pBatteryVoltages.get(parall_i).toString()) / 10.0;
            workInfo.setPBatteryVoltage(pBatteryVoltage);
            List<Object> chargingCurrents = snmp.getTable(".1.3.6.1.4.1.21111.1.2.15.1.1.14");
            double chargingCurrent = VolUtil.parseDouble(chargingCurrents.get(parall_i).toString());
            workInfo.setChargingCurrent(chargingCurrent);
            List<Object> batteryCapacitys = snmp.getTable(".1.3.6.1.4.1.21111.1.2.15.1.1.15");
            int batteryCapacity = VolUtil.parseInt(batteryCapacitys.get(parall_i).toString());
            workInfo.setBatteryCapacity(batteryCapacity);
            List<Object> pvInputVoltage = snmp.getTable(".1.3.6.1.4.1.21111.1.2.15.1.1.16");
            double pvInputVoltage1 = VolUtil.parseDouble(pvInputVoltage.get(parall_i).toString()) / 10.0;
            workInfo.setPvInputVoltage1(pvInputVoltage1);
            List<Object> ttlchargingCurrents = snmp.getTable(".1.3.6.1.4.1.21111.1.2.15.1.1.17");
            double ttlchargingCurrent = VolUtil.parseDouble(ttlchargingCurrents.get(parall_i).toString());
            workInfo.setTtlChargingCurrent(ttlchargingCurrent);
            List<Object> ttlAcoutputVAs = snmp.getTable(".1.3.6.1.4.1.21111.1.2.15.1.1.18");
            double ttlAcoutputVA = VolUtil.parseDouble(ttlAcoutputVAs.get(parall_i).toString());
            workInfo.setAcTtlOutputApparentPower(ttlAcoutputVA);
            List<Object> ttlAcoutputWs = snmp.getTable(".1.3.6.1.4.1.21111.1.2.15.1.1.19");
            double ttlAcoutputW = VolUtil.parseDouble(ttlAcoutputWs.get(parall_i).toString());
            workInfo.setAcTtlOutputActivePower(ttlAcoutputW);
            List<Object> ttlAcoutputPercents = snmp.getTable(".1.3.6.1.4.1.21111.1.2.15.1.1.20");
            double ttlAcoutputPercent = VolUtil.parseDouble(ttlAcoutputPercents.get(parall_i).toString());
            workInfo.setAcTtlOutputPercent(ttlAcoutputPercent);
            workInfo.setCurrentTime(new Date());
            List<Object> statusList = snmp.getTable(".1.3.6.1.4.1.21111.1.2.15.1.1.21");
            String status = statusList.get(parall_i).toString();
            if (status.length() >= 8) {
                if (status.charAt(7) == '1') {
                    this.refreshConfig = true;
                }
                if (status.charAt(6) == '1') {
                    workInfo.setHasLoad(true);
                } else {
                    workInfo.setHasLoad(false);
                }
                if (status.charAt(5) == '1') {
                    workInfo.setLineLoss(true);
                    if (!workInfo.getWarnings().contains("2004")) {
                        EventsHandler.handleEvent(workInfo.getProdid(), workInfo.getSerialno(), workInfo.getCurrentTime(), "2004");
                        workInfo.addWarning("2004");
                    }
                } else {
                    workInfo.setLineLoss(false);
                    if (workInfo.getWarnings().contains("2004")) {
                        EventsHandler.handleEvent(workInfo.getProdid(), workInfo.getSerialno(), workInfo.getCurrentTime(), "2016");
                        workInfo.getWarnings().remove("2004");
                    }
                }
                if (status.charAt(1) == '1' || status.charAt(2) == '1') {
                    workInfo.setChargeOn(true);
                } else {
                    workInfo.setChargeOn(false);
                }
                if (status.charAt(1) == '1') {
                    workInfo.setACchargeOn(true);
                } else {
                    workInfo.setACchargeOn(false);
                }
                if (status.charAt(2) == '1') {
                    workInfo.setSCCchargeOn(true);
                } else {
                    workInfo.setSCCchargeOn(false);
                }
                if (workInfo.isChargeOn()) {
                    if (workInfo.isSCCchargeOn() && workInfo.isACchargeOn()) {
                        workInfo.setChargeSource("Solar and Utility");
                    } else if (workInfo.isSCCchargeOn()) {
                        workInfo.setChargeSource("Solar");
                    } else if (workInfo.isACchargeOn()) {
                        workInfo.setChargeSource("Utility");
                    }
                } else {
                    workInfo.setChargeSource("---");
                }
                if (workInfo.isHasLoad()) {
                    if (workInfo.getWorkMode().equals("Line Mode")) {
                        workInfo.setLoadSource("Utility");
                    } else if (workInfo.getWorkMode().equals("Battery Mode")) {
                        workInfo.setLoadSource("Battery");
                    }
                } else {
                    workInfo.setLoadSource("---");
                }
            }
            List<Object> outputtypes = snmp.getTable(".1.3.6.1.4.1.21111.1.2.15.1.1.22");
            int outputtype = VolUtil.parseInt(outputtypes.get(parall_i).toString());
            processor.setOutputMode(outputtype);
            if (processor instanceof ParallSubProcessor) {
                configdata.setSubOutputMode(processor.getSerialNo(), outputtype);
            } else {
                configdata.setOutputMode(outputtype);
            }
            List<Object> chargingSources = snmp.getTable(".1.3.6.1.4.1.21111.1.2.15.1.1.23");
            String chargingSource = chargingSources.get(parall_i).toString();
            String chargeSource = "Utility";
            if (chargingSource.equals("0")) {
                chargeSource = "Utility";
            } else if (chargingSource.equals("1")) {
                chargeSource = "Solar first";
            } else if (chargingSource.equals("2")) {
                chargeSource = "Utility and Solar";
            } else if (chargingSource.equals("3")) {
                chargeSource = "Solar only";
            }
            if (processor instanceof ParallSubProcessor) {
                configdata.setChargerSource(processor.getSerialNo(), chargeSource);
            } else {
                configdata.setChargerSource(chargeSource);
            }
            List<Object> maxchangestrs = snmp.getTable(".1.3.6.1.4.1.21111.1.2.15.1.1.24");
            String maxchangestr = maxchangestrs.get(parall_i).toString();
            int maxchargecurrent = VolUtil.parseInt(maxchangestr);
            if (processor instanceof ParallSubProcessor) {
                configdata.setMaxChargeCurrent(processor.getSerialNo(), maxchargecurrent);
            } else {
                configdata.setMaxChargeCurrent(maxchargecurrent);
            }
            List<Object> maxmaxcharges = snmp.getTable(".1.3.6.1.4.1.21111.1.2.15.1.1.25");
            String maxmaxchargestr = maxmaxcharges.get(parall_i).toString();
            int maxmaxcharge = VolUtil.parseInt(maxmaxchargestr);
            if (processor instanceof ParallSubProcessor) {
                configdata.setMinMaxChargeCurrent(processor.getSerialNo(), 10.0);
                configdata.setMaxMaxChargeCurrent(processor.getSerialNo(), maxmaxcharge);
            } else {
                configdata.setMaxMaxChargeCurrent(maxmaxcharge);
                configdata.setMinMaxChargeCurrent(10.0);
            }
            List<Object> maxacchargecurrents = snmp.getTable(".1.3.6.1.4.1.21111.1.2.15.1.1.26");
            int maxacchargecurrent = VolUtil.parseInt(maxacchargecurrents.get(parall_i).toString());
            if (processor instanceof ParallSubProcessor) {
                configdata.setMaxacchargingcurrent(processor.getSerialNo(), maxacchargecurrent);
            } else {
                configdata.setMaxacchargingcurrent(maxacchargecurrent);
            }
            List<Object> pvInputCurrents = snmp.getTable(".1.3.6.1.4.1.21111.1.2.15.1.1.27");
            int pvInputCurrent = VolUtil.parseInt(pvInputCurrents.get(parall_i).toString());
            workInfo.setPvInputCurrent(pvInputCurrent);
            List<Object> batDischargeCurrents = snmp.getTable(".1.3.6.1.4.1.21111.1.2.15.1.1.28");
            int batDischargeCurrent = VolUtil.parseInt(batDischargeCurrents.get(parall_i).toString());
            workInfo.setBatDisCurrent(batDischargeCurrent);
            List<Object> faults = snmp.getTable(".1.3.6.1.4.1.21111.1.2.15.1.1.5");
            String faultcode = faults.get(parall_i).toString();
            if (faultcode.length() < 2) {
                faultcode = "0" + faultcode;
            }
            FaultHandler.doFaultEvent(workInfo, faultcode);
            String prodid = processor.getProtocol().getProtocolID();
            if (prodid.equals("P30PLUSDUO") || prodid.equals("P30PLUSTRI")) {
                List<Object> pv1InputPowers = snmp.getTable(".1.3.6.1.4.1.21111.1.2.15.1.1.29");
                int pvInputPower1 = VolUtil.parseInt(pv1InputPowers.get(parall_i).toString());
                workInfo.setPvInputPower1(pvInputPower1);
                List<Object> pv2InputVoltages = snmp.getTable(".1.3.6.1.4.1.21111.1.2.15.1.1.30");
                double pvInputVoltage2 = VolUtil.parseDouble(pv2InputVoltages.get(parall_i).toString()) / 10.0;
                workInfo.setPvInputVoltage2(pvInputVoltage2);
                List<Object> pv2InputCurrents = snmp.getTable(".1.3.6.1.4.1.21111.1.2.15.1.1.31");
                int pvInputCurrent2 = VolUtil.parseInt(pv2InputCurrents.get(parall_i).toString());
                workInfo.setPvInputCurrent2(pvInputCurrent2);
                List<Object> pv2InputPowers = snmp.getTable(".1.3.6.1.4.1.21111.1.2.15.1.1.32");
                int pvInputPower2 = VolUtil.parseInt(pv2InputPowers.get(parall_i).toString());
                workInfo.setPvInputPower2(pvInputPower2);
                List<Object> pv3InputVoltages = snmp.getTable(".1.3.6.1.4.1.21111.1.2.15.1.1.33");
                double pvInputVoltage3 = VolUtil.parseDouble(pv3InputVoltages.get(parall_i).toString()) / 10.0;
                workInfo.setPvInputVoltage3(pvInputVoltage3);
                List<Object> pv3InputCurrents = snmp.getTable(".1.3.6.1.4.1.21111.1.2.15.1.1.34");
                int pvInputCurrent3 = VolUtil.parseInt(pv3InputCurrents.get(parall_i).toString());
                workInfo.setPvInputCurrent3(pvInputCurrent3);
                List<Object> pv3InputPowers = snmp.getTable(".1.3.6.1.4.1.21111.1.2.15.1.1.35");
                int pvInputPower3 = VolUtil.parseInt(pv3InputPowers.get(parall_i).toString());
                workInfo.setPvInputPower3(pvInputPower3);
                List<Object> sccStatusList = snmp.getTable(".1.3.6.1.4.1.21111.1.2.15.1.1.36");
                String sccStatus = sccStatusList.get(parall_i).toString();
                workInfo.setSCCchargeOn2(sccStatus.charAt(1) == '1');
                workInfo.setSCCchargeOn3(sccStatus.charAt(3) == '1');
            } else {
                double pvPower = workInfo.getPBatteryVoltage() * (double)pvInputCurrent;
                Double dVal = new Double(pvPower);
                workInfo.setPvInputPower1(dVal.intValue());
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean pollQueryStatus() {
        return false;
    }

    @Override
    public boolean queryCapability() {
        SNMPHandler snmp = this.getHandler();
        if (snmp == null) {
            return false;
        }
        Capability capability = (Capability)this.getBeanBag().getBean("capability");
        capability.setCapableA(VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.14.19")) == 1);
        capability.setCapableB(VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.14.61")) == 1);
        capability.setCapableJ(VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.14.62")) == 1);
        capability.setCapableK(VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.14.10")) == 1);
        capability.setCapableU(VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.14.63")) == 1);
        capability.setCapableV(VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.14.64")) == 1);
        capability.setCapableX(VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.14.65")) == 1);
        capability.setCapableY(VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.14.66")) == 1);
        capability.setCapableZ(VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.14.67")) == 1);
        capability.setCapableL(VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.14.81")) == 1);
        return true;
    }

    @Override
    public boolean queryConfigData() {
        String qpacchargstr;
        SNMPHandler snmp = this.getHandler();
        if (snmp == null) {
            return false;
        }
        MachineInfo machine = (MachineInfo)this.getBeanBag().getBean("machineinfo");
        ConfigData configdata = (ConfigData)this.getBeanBag().getBean("configdata");
        double outputVoltage = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.2.8")) / 10.0;
        if (this.getProtocol().getProtocolID().equals("P30PARAL")) {
            configdata.setOutputVoltage(String.valueOf((int)outputVoltage));
        } else {
            configdata.setOutputVoltage(String.valueOf(outputVoltage));
        }
        int outputFrequency = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.2.4")) / 10;
        configdata.setOutputFrequency(String.valueOf(outputFrequency));
        configdata.setBatteryVoltage(VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.2.10")) / 10.0);
        configdata.setRechargeVoltage(VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.14.49")) / 10.0);
        String batteryTypeStr = snmp.get(".1.3.6.1.4.1.21111.1.2.11.5");
        String batteryType = "AGM";
        if (batteryTypeStr.equals("0")) {
            batteryType = "AGM";
        } else if (batteryTypeStr.equals("1")) {
            batteryType = "Flooded";
        } else if (batteryTypeStr.equals("2")) {
            batteryType = "User";
        }
        configdata.setBatteryType(batteryType);
        double maxChargeCurrent = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.14.69"));
        if (machine.isChargeCurrentComBox()) {
            configdata.setMaxacchargingcurrent(maxChargeCurrent);
        } else {
            configdata.setMaxMaxChargeCurrent(maxChargeCurrent);
        }
        double currentChargeCurrent = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.14.34"));
        configdata.setMaxChargeCurrent(currentChargeCurrent);
        configdata.setMinMaxChargeCurrent(10.0);
        double maxChargeVoltage = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.14.54")) / 10.0;
        double floatChargVoltage = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.14.57")) / 10.0;
        double batteryUnder = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.14.68")) / 10.0;
        configdata.setMaxChargeVoltage(maxChargeVoltage);
        configdata.setFloatingChargeVoltage(floatChargVoltage);
        configdata.setBatteryUnder(batteryUnder);
        if (this._protocol.getAxpert().equals("012") || this._protocol.getAxpert().equals("013")) {
            if (configdata.getBatteryVoltage() > 40.0) {
                configdata.setMinMaxChargeVoltage(48.0);
                configdata.setMaxMaxChargeVoltage(64.0);
                configdata.setMinFloatingChargeVoltage(48.0);
                configdata.setMaxFloatingChargeVoltage(64.0);
                configdata.setMinBatteryUnder(40.0);
                configdata.setMaxBatteryUnder(48.0);
            } else if (configdata.getBatteryVoltage() > 20.0) {
                configdata.setMinMaxChargeVoltage(24.0);
                configdata.setMaxMaxChargeVoltage(29.21);
                configdata.setMinFloatingChargeVoltage(24.0);
                configdata.setMaxFloatingChargeVoltage(29.21);
                configdata.setMinBatteryUnder(20.0);
                configdata.setMaxBatteryUnder(24.0);
            } else {
                configdata.setMinMaxChargeVoltage(12.0);
                configdata.setMaxMaxChargeVoltage(14.6);
                configdata.setMinFloatingChargeVoltage(12.0);
                configdata.setMaxFloatingChargeVoltage(14.6);
                configdata.setMinBatteryUnder(10.0);
                configdata.setMaxBatteryUnder(12.0);
            }
        } else if (configdata.getBatteryVoltage() > 40.0) {
            configdata.setMinMaxChargeVoltage(48.0);
            configdata.setMaxMaxChargeVoltage(58.4);
            configdata.setMinFloatingChargeVoltage(48.0);
            configdata.setMaxFloatingChargeVoltage(58.4);
            configdata.setMinBatteryUnder(40.0);
            configdata.setMaxBatteryUnder(48.0);
        } else if (configdata.getBatteryVoltage() > 20.0) {
            configdata.setMinMaxChargeVoltage(24.0);
            configdata.setMaxMaxChargeVoltage(29.21);
            configdata.setMinFloatingChargeVoltage(24.0);
            configdata.setMaxFloatingChargeVoltage(29.21);
            configdata.setMinBatteryUnder(20.0);
            configdata.setMaxBatteryUnder(24.0);
        } else {
            configdata.setMinMaxChargeVoltage(12.0);
            configdata.setMaxMaxChargeVoltage(14.6);
            configdata.setMinFloatingChargeVoltage(12.0);
            configdata.setMaxFloatingChargeVoltage(14.6);
            configdata.setMinBatteryUnder(10.0);
            configdata.setMaxBatteryUnder(12.0);
        }
        String inputVoltageRangeStr = snmp.get(".1.3.6.1.4.1.21111.1.2.11.6");
        String inputVoltageRange = "Appliance";
        if (inputVoltageRangeStr.equals("0")) {
            inputVoltageRange = "Appliance";
        } else if (inputVoltageRangeStr.equals("1")) {
            inputVoltageRange = "UPS";
        }
        configdata.setAcInputRange(inputVoltageRange);
        String outputSourceStr = snmp.get(".1.3.6.1.4.1.21111.1.2.11.7");
        String outputSource = "Utility";
        if (outputSourceStr.equals("0")) {
            outputSource = "Utility";
        } else if (outputSourceStr.equals("1")) {
            outputSource = "Solar";
        } else if (outputSourceStr.equals("2")) {
            outputSource = "SBU";
        }
        configdata.setOutputSource(outputSource);
        String chargeSourceStr = snmp.get(".1.3.6.1.4.1.21111.1.2.11.8");
        String chargeSource = "Utility";
        if (chargeSourceStr.equals("0")) {
            chargeSource = "Utility";
        } else if (chargeSourceStr.equals("1")) {
            chargeSource = "Solar first";
        } else if (chargeSourceStr.equals("2")) {
            chargeSource = "Utility and Solar";
        } else if (chargeSourceStr.equals("3")) {
            chargeSource = "Solar only";
        }
        configdata.setChargerSource(chargeSource);
        int outputmode = Integer.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.11.9"));
        this._protocol.setOutputMode(outputmode);
        if (outputmode != 0) {
            this._paralleltype = 1;
            this._parallelnum = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.2.11"));
        } else {
            this._paralleltype = 0;
        }
        double batReDischargeVol = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.14.58")) / 10.0;
        if (VolUtil.round(batReDischargeVol, 0) == 0.0) {
            configdata.setReDischargeVoltage("FULL");
        } else {
            configdata.setReDischargeVoltage(String.valueOf(batReDischargeVol));
        }
        if (VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.14.59")) == 1) {
            configdata.setAllpvok(true);
        } else {
            configdata.setAllpvok(false);
        }
        if (VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.14.60")) == 1) {
            configdata.setSolarbalance(true);
        } else {
            configdata.setSolarbalance(false);
        }
        String qPcvt = snmp.get(".1.3.6.1.4.1.21111.1.2.14.83");
        configdata.setChargingTimeInCVStage(VolUtil.parseInt(qPcvt));
        configdata.setMinChargingTimeInCVStage(0);
        configdata.setMaxChargingTimeInCVStage(900);
        String qmchgcr = snmp.get(".1.3.6.1.4.1.21111.1.2.3.20");
        if (qmchgcr.length() > 0) {
            String[] item = qmchgcr.split(" ");
            if (machine.isChargeCurrentComBox()) {
                int index = 0;
                while (index < item.length) {
                    try {
                        item[index] = String.format("%d", Integer.parseInt(item[index]));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++index;
                }
                configdata.setChargingCurrentComBox(item);
            } else {
                configdata.setMinMaxChargeCurrent(VolUtil.parseDouble(item[0]));
                configdata.setMaxMaxChargeCurrent(VolUtil.parseDouble(item[1]));
            }
        }
        if ((qpacchargstr = snmp.get(".1.3.6.1.4.1.21111.1.2.3.21")).length() > 0) {
            String[] item = qpacchargstr.split(" ");
            int index = 0;
            while (index < item.length) {
                try {
                    item[index] = String.format("%d", Integer.parseInt(item[index]));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++index;
            }
            configdata.setAcChargingCurrentComBox(item);
        }
        return true;
    }

    @Override
    public boolean queryDefaultData() {
        SNMPHandler snmp = this.getHandler();
        if (snmp == null) {
            return false;
        }
        DefaultData defaultData = (DefaultData)this.getBeanBag().getBean("defaultdata");
        defaultData.setAcOutputVoltage(VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.9.48")) / 10.0);
        defaultData.setAcOutputFrequency(VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.9.49")) / 10.0);
        defaultData.setMaxACChargingCurrent(VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.9.50")));
        defaultData.setBatteryCutoffVoltage(VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.9.51")) / 10.0);
        defaultData.setFloatChargingVoltage(VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.9.52")) / 10.0);
        defaultData.setMaxChargingVoltage(VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.9.53")) / 10.0);
        defaultData.setReChangingVoltage(VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.9.54")) / 10.0);
        defaultData.setMaxChargingCurrent(VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.9.55")));
        int acInputVoltage = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.9.56"));
        int outputSourcePriority = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.9.57"));
        int chargerSourcePriority = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.9.58"));
        int batteryType = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.9.59"));
        if (acInputVoltage == 0) {
            defaultData.setAcInputVoltage("Appliance");
        } else {
            defaultData.setAcInputVoltage("UPS");
        }
        if (outputSourcePriority == 0) {
            defaultData.setOutputSourcePriority("Utility");
        } else if (outputSourcePriority == 1) {
            defaultData.setOutputSourcePriority("Solar");
        } else if (outputSourcePriority == 2) {
            defaultData.setOutputSourcePriority("SBU");
        }
        if (chargerSourcePriority == 0) {
            defaultData.setChargerSourcePriority("Utility");
        } else if (chargerSourcePriority == 1) {
            defaultData.setChargerSourcePriority("Solar");
        } else if (chargerSourcePriority == 2) {
            defaultData.setChargerSourcePriority("Utility and Solar");
        } else if (chargerSourcePriority == 3) {
            defaultData.setChargerSourcePriority("Solar only");
        }
        if (batteryType == 0) {
            defaultData.setBatteryType("AGM");
        } else {
            defaultData.setBatteryType("Flooded");
        }
        int capableA = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.9.60"));
        int capableJ = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.9.61"));
        int capableU = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.9.62"));
        int capableV = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.9.63"));
        int capableX = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.9.64"));
        int capableY = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.9.65"));
        int capableZ = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.9.66"));
        int capableB = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.9.67"));
        int capableK = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.9.68"));
        if (capableA == 0) {
            defaultData.setCapableA("Disable");
        } else {
            defaultData.setCapableA("Enable");
        }
        if (capableJ == 0) {
            defaultData.setCapableJ("Disable");
        } else {
            defaultData.setCapableJ("Enable");
        }
        if (capableU == 0) {
            defaultData.setCapableU("Disable");
        } else {
            defaultData.setCapableU("Enable");
        }
        if (capableV == 0) {
            defaultData.setCapableV("Disable");
        } else {
            defaultData.setCapableV("Enable");
        }
        if (capableX == 0) {
            defaultData.setCapableX("Disable");
        } else {
            defaultData.setCapableX("Enable");
        }
        if (capableY == 0) {
            defaultData.setCapableY("Disable");
        } else {
            defaultData.setCapableY("Enable");
        }
        if (capableZ == 0) {
            defaultData.setCapableZ("Disable");
        } else {
            defaultData.setCapableZ("Enable");
        }
        if (capableB == 0) {
            defaultData.setCapableB("Disable");
        } else {
            defaultData.setCapableB("Enable");
        }
        if (capableK == 0) {
            defaultData.setCapableK("Disable");
        } else {
            defaultData.setCapableK("Enable");
        }
        String[] modes = new String[]{"Single", "Parallel", "Phase R of 3 phase output", "Phase S of 3 phase output", "Phase T of 3 phase output"};
        int outputmode = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.9.69"));
        if (outputmode >= 0 && outputmode <= 4) {
            defaultData.setOutputMode(modes[outputmode]);
        }
        defaultData.setReDischargeVoltage(VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.9.70")) / 10.0);
        int chargingTimeInCVStage = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.9.83"));
        if (chargingTimeInCVStage == 0) {
            defaultData.setChargingTimeInCVStage("Auto");
        } else {
            defaultData.setChargingTimeInCVStage(String.valueOf(chargingTimeInCVStage));
        }
        return true;
    }

    @Override
    public boolean queryMachineInfo() {
        SNMPHandler snmp = this.getHandler();
        if (snmp == null) {
            return false;
        }
        MachineInfo machineInfo = (MachineInfo)this.getBeanBag().getBean("machineinfo");
        machineInfo.setSerialno(snmp.getSerialNo());
        String qvfw = snmp.get(".1.3.6.1.4.1.21111.1.2.1.5");
        machineInfo.setMainFirmwareVersion(qvfw);
        String qvfw2 = snmp.get(".1.3.6.1.4.1.21111.1.2.1.6");
        if (qvfw2 == null || qvfw2.equals("")) {
            qvfw2 = "---";
        }
        machineInfo.setSlaveFirmwareVersion(qvfw2);
        double gridRatingVoltage = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.2.3")) / 10.0;
        double gridRatingCurrent = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.2.5")) / 10.0;
        double acOutputRatingVoltage = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.2.8")) / 10.0;
        double acOutputRatingFrequency = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.2.4")) / 10.0;
        double acOutputRatingCurrent = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.2.9")) / 10.0;
        double acOutputRatingApparentPower = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.2.2"));
        double acOutputRatingActivePower = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.2.1"));
        double batteryRatingVoltage = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.2.10")) / 10.0;
        String batteryTypeStr = snmp.get(".1.3.6.1.4.1.21111.1.2.11.5");
        double perMPPTRatingCurrent = VolUtil.parseDouble(snmp.get(".1.3.6.1.4.1.21111.1.2.14.69"));
        String inputVoltageRangeStr = snmp.get(".1.3.6.1.4.1.21111.1.2.11.6");
        String outputSourceStr = snmp.get(".1.3.6.1.4.1.21111.1.2.11.7");
        String chargeSourceStr = snmp.get(".1.3.6.1.4.1.21111.1.2.11.8");
        int machineTypeInt = snmp.getInt(".1.3.6.1.4.1.21111.1.2.1.7");
        String machineTypeStr = String.format("%02d", machineTypeInt);
        String topologyStr = snmp.get(".1.3.6.1.4.1.21111.1.2.1.8");
        int outputmode = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.11.9"));
        int parallelMaxNum = VolUtil.parseInt(snmp.get(".1.3.6.1.4.1.21111.1.2.2.11"));
        machineInfo.setGridRatingVoltage(gridRatingVoltage);
        machineInfo.setGridRatingCurrent(gridRatingCurrent);
        machineInfo.setAcOutputRatingVoltage(acOutputRatingVoltage);
        machineInfo.setAcOutputRatingFrequency(acOutputRatingFrequency);
        machineInfo.setAcOutputRatingCurrent(acOutputRatingCurrent);
        machineInfo.setAcOutputRatingApparentPower(acOutputRatingApparentPower);
        machineInfo.setAcOutputRatingActivePower(acOutputRatingActivePower);
        machineInfo.setBatteryRatingVoltage(batteryRatingVoltage);
        machineInfo.setPerMPPTRatingCurrent(perMPPTRatingCurrent);
        String batteryType = "---";
        if (batteryTypeStr.equals("0")) {
            batteryType = "AGM";
        } else if (batteryTypeStr.equals("1")) {
            batteryType = "Flooded";
        }
        machineInfo.setBatteryType(batteryType);
        String inputVoltageRange = "---";
        if (inputVoltageRangeStr.equals("0")) {
            inputVoltageRange = "Appliance";
        } else if (inputVoltageRangeStr.equals("1")) {
            inputVoltageRange = "UPS";
        }
        machineInfo.setInputVoltageRange(inputVoltageRange);
        String outputSource = "---";
        if (outputSourceStr.equals("0")) {
            outputSource = "Utility";
        } else if (outputSourceStr.equals("1")) {
            outputSource = "Solar";
        } else if (outputSourceStr.equals("2")) {
            outputSource = "SBU";
        }
        machineInfo.setOutputSource(outputSource);
        String chargeSource = "---";
        if (chargeSourceStr.equals("0")) {
            chargeSource = "Utility";
        } else if (chargeSourceStr.equals("1")) {
            chargeSource = "Solar";
        } else if (chargeSourceStr.equals("2")) {
            chargeSource = "Solar and Utility";
        }
        machineInfo.setChargeSource(chargeSource);
        String machineType = "---";
        if (machineTypeStr.equals("00")) {
            machineType = "Grid tie";
        } else if (machineTypeStr.equals("01")) {
            machineType = "Stand alone";
        } else if (machineTypeStr.equals("10")) {
            machineType = "Hybrid";
        }
        machineInfo.setMachineType(machineType);
        String topology = "---";
        if (topologyStr.equals("0")) {
            topology = "Transformerless";
        } else if (topologyStr.equals("1")) {
            topology = "Transformer";
        }
        machineInfo.setTopology(topology);
        this._protocol.setOutputMode(outputmode);
        this._outputmode = outputmode;
        if (outputmode != 0) {
            this._paralleltype = 1;
            this._parallelnum = parallelMaxNum;
        } else {
            this._paralleltype = 0;
        }
        return true;
    }

    @Override
    public void querySelfTestResult() {
    }

    @Override
    public boolean supportSelfTest() {
        return false;
    }

    @Override
    public void processTrap(String trapid_hex) {
        SNMPHandler snmp = this.getHandler();
        if (snmp == null) {
            return;
        }
        if (this._paralleltype == 2) {
            return;
        }
        WorkInfo workinfo = (WorkInfo)this.getBeanBag().getBean("workinfo");
        workinfo.setProdid(this._protocol.getProtocolID());
        workinfo.setSerialno(this.getProtocol().getSerialNo());
        workinfo.setCurrentTime(new Date());
        this.parsingWarntrap(workinfo, trapid_hex.substring(1));
    }

    private void parsingWarntrap(WorkInfo workinfo, String trapid_hex) {
        byte[] bytes = VolStr.hexStringToBytes((String)trapid_hex);
        BitVector warnStatus = new BitVector(128);
        warnStatus.toggleAccess(true);
        warnStatus.setBytes(bytes);
        String newWarnStatus = "";
        int item = 0;
        while (item < 32) {
            newWarnStatus = warnStatus.getBit(item) ? String.valueOf(newWarnStatus) + "1" : String.valueOf(newWarnStatus) + "0";
            ++item;
        }
        String qpiwsStr = newWarnStatus;
        this.hasFault = qpiwsStr.charAt(1) == '1';
        if (qpiwsStr.charAt(15) == '1') {
            workinfo.setOverLoad(true);
        } else {
            workinfo.setOverLoad(false);
        }
        if (qpiwsStr.charAt(2) == '1') {
            if (!workinfo.getWarnings().contains("2001")) {
                EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2001");
                workinfo.addWarning("2001");
            }
        } else if (workinfo.getWarnings().contains("2001")) {
            workinfo.getWarnings().remove("2001");
        }
        if (qpiwsStr.charAt(3) == '1') {
            if (!workinfo.getWarnings().contains("2002")) {
                EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2002");
                workinfo.addWarning("2002");
            }
        } else if (workinfo.getWarnings().contains("2002")) {
            workinfo.getWarnings().remove("2002");
        }
        if (qpiwsStr.charAt(4) == '1') {
            if (!workinfo.getWarnings().contains("2003")) {
                EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2003");
                workinfo.addWarning("2003");
            }
        } else if (workinfo.getWarnings().contains("2003")) {
            workinfo.getWarnings().remove("2003");
        }
        if (qpiwsStr.charAt(5) == '1') {
            workinfo.setLineLoss(true);
            if (!workinfo.getWarnings().contains("2004")) {
                EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2004");
                workinfo.addWarning("2004");
            }
        } else {
            workinfo.setLineLoss(false);
            if (workinfo.getWarnings().contains("2004")) {
                EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2016");
                workinfo.getWarnings().remove("2004");
            }
        }
        if (qpiwsStr.charAt(6) == '1') {
            if (!workinfo.getWarnings().contains("2005")) {
                EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2005");
                workinfo.addWarning("2005");
            }
        } else if (workinfo.getWarnings().contains("2005")) {
            workinfo.getWarnings().remove("2005");
        }
        if (qpiwsStr.charAt(7) == '1') {
            if (!workinfo.getWarnings().contains("2006")) {
                EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2006");
                workinfo.addWarning("2006");
            }
        } else if (workinfo.getWarnings().contains("2006")) {
            workinfo.getWarnings().remove("2006");
        }
        if (qpiwsStr.charAt(8) == '1') {
            if (!workinfo.getWarnings().contains("2007")) {
                EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2007");
                workinfo.addWarning("2007");
            }
        } else if (workinfo.getWarnings().contains("2007")) {
            workinfo.getWarnings().remove("2007");
        }
        if (qpiwsStr.charAt(9) == '1') {
            if (this.hasFault) {
                if (!workinfo.getWarnings().contains("1011")) {
                    EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "1011");
                    FaultHandler.recordEvent(workinfo, "1011");
                    workinfo.addWarning("1011");
                }
            } else if (!workinfo.getWarnings().contains("2008")) {
                EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2008");
                workinfo.addWarning("2008");
            }
        } else {
            if (workinfo.getWarnings().contains("2008")) {
                workinfo.getWarnings().remove("2008");
            }
            if (workinfo.getWarnings().contains("1011")) {
                workinfo.getWarnings().remove("1011");
            }
        }
        if (qpiwsStr.charAt(10) == '1') {
            if (this.hasFault) {
                if (!workinfo.getWarnings().contains("1001")) {
                    EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "1001");
                    FaultHandler.recordEvent(workinfo, "1001");
                    workinfo.addWarning("1001");
                }
            } else if (!workinfo.getWarnings().contains("2009")) {
                EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2009");
                workinfo.addWarning("2009");
            }
        } else {
            if (workinfo.getWarnings().contains("2009")) {
                workinfo.getWarnings().remove("2009");
            }
            if (workinfo.getWarnings().contains("1001")) {
                workinfo.getWarnings().remove("1001");
            }
        }
        if (qpiwsStr.charAt(11) == '1') {
            if (this.hasFault) {
                if (!workinfo.getWarnings().contains("1002")) {
                    EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "1002");
                    FaultHandler.recordEvent(workinfo, "1002");
                    workinfo.addWarning("1002");
                }
            } else if (!workinfo.getWarnings().contains("2010")) {
                EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2010");
                workinfo.addWarning("2010");
            }
        } else {
            if (workinfo.getWarnings().contains("2010")) {
                workinfo.getWarnings().remove("2010");
            }
            if (workinfo.getWarnings().contains("1002")) {
                workinfo.getWarnings().remove("1002");
            }
        }
        if (qpiwsStr.charAt(12) == '1') {
            if (!workinfo.getWarnings().contains("2011")) {
                EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2011");
                workinfo.addWarning("2011");
            }
        } else if (workinfo.getWarnings().contains("2011")) {
            workinfo.getWarnings().remove("2011");
        }
        if (qpiwsStr.charAt(13) == '1') {
            if (!workinfo.getWarnings().contains("2012")) {
                EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2012");
                workinfo.addWarning("2012");
            }
        } else if (workinfo.getWarnings().contains("2012")) {
            workinfo.getWarnings().remove("2012");
        }
        if (qpiwsStr.charAt(14) == '1') {
            if (!workinfo.getWarnings().contains("2013")) {
                EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2013");
                workinfo.addWarning("2013");
            }
        } else if (workinfo.getWarnings().contains("2013")) {
            workinfo.removeWarning("2013");
        }
        if (qpiwsStr.charAt(15) == '1') {
            if (!workinfo.getWarnings().contains("2014")) {
                EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2014");
                workinfo.addWarning("2014");
            }
        } else if (workinfo.getWarnings().contains("2014")) {
            workinfo.removeWarning("2014");
        }
        if (qpiwsStr.charAt(16) == '1') {
            if (this.hasFault) {
                if (!workinfo.getWarnings().contains("1003")) {
                    EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "1003");
                    FaultHandler.recordEvent(workinfo, "1003");
                    workinfo.addWarning("1003");
                }
            } else if (!workinfo.getWarnings().contains("2015")) {
                EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2015");
                workinfo.addWarning("2015");
            }
        } else {
            if (workinfo.getWarnings().contains("2015")) {
                workinfo.removeWarning("2015");
            }
            if (workinfo.getWarnings().contains("1003")) {
                workinfo.removeWarning("1003");
            }
        }
        if (qpiwsStr.charAt(18) == '1') {
            if (!workinfo.getWarnings().contains("1004")) {
                EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "1004");
                workinfo.addWarning("1004");
            }
        } else if (workinfo.getWarnings().contains("1004")) {
            workinfo.removeWarning("1004");
        }
        if (qpiwsStr.charAt(19) == '1') {
            if (!workinfo.getWarnings().contains("1005")) {
                EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "1005");
                workinfo.addWarning("1005");
            }
        } else if (workinfo.getWarnings().contains("1005")) {
            workinfo.removeWarning("1005");
        }
        if (qpiwsStr.charAt(20) == '1') {
            if (!workinfo.getWarnings().contains("1006")) {
                EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "1006");
                workinfo.addWarning("1006");
            }
        } else if (workinfo.getWarnings().contains("1006")) {
            workinfo.removeWarning("1006");
        }
        if (qpiwsStr.charAt(21) == '1') {
            if (!workinfo.getWarnings().contains("1007")) {
                EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "1007");
                workinfo.addWarning("1007");
            }
        } else if (workinfo.getWarnings().contains("1007")) {
            workinfo.removeWarning("1007");
        }
        if (qpiwsStr.charAt(22) == '1') {
            if (!workinfo.getWarnings().contains("1008")) {
                EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "1008");
                workinfo.addWarning("1008");
            }
        } else if (workinfo.getWarnings().contains("1008")) {
            workinfo.removeWarning("1008");
        }
        if (qpiwsStr.charAt(23) == '1') {
            if (!workinfo.getWarnings().contains("1009")) {
                EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "1009");
                workinfo.addWarning("1009");
            }
        } else if (workinfo.getWarnings().contains("1009")) {
            workinfo.removeWarning("1009");
        }
        if (qpiwsStr.charAt(24) == '1') {
            if (!workinfo.getWarnings().contains("1010")) {
                EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "1010");
                workinfo.addWarning("1010");
            }
        } else if (workinfo.getWarnings().contains("1010")) {
            workinfo.removeWarning("1010");
        }
    }
}

