/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.system;

import cn.com.voltronic.solar.communicate.ModbusHandler;
import cn.com.voltronic.solar.communicate.SNMPHandler;
import cn.com.voltronic.solar.communicate.SerialHandler;
import cn.com.voltronic.solar.communicate.SerialHandlerSolaris;
import cn.com.voltronic.solar.communicate.USBHandler;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.system.ProtocolProcessorItem;
import java.util.ArrayList;
import java.util.List;

public class ProcessorCategories {
    protected static List<ProtocolProcessorItem> _protocolList = new ArrayList<ProtocolProcessorItem>();
    protected static List<ProtocolProcessorItem> serialProcessors = new ArrayList<ProtocolProcessorItem>();
    protected static List<ProtocolProcessorItem> usbProcessors = new ArrayList<ProtocolProcessorItem>();
    protected static List<ProtocolProcessorItem> snmpProcessors = new ArrayList<ProtocolProcessorItem>();
    protected static List<ProtocolProcessorItem> modbusProcessors = new ArrayList<ProtocolProcessorItem>();

    public static void registerProcessor(Class protocol, Class handler, Class abstractProcess) {
        String clsName = handler.getName();
        if (clsName.equals(SerialHandler.class.getName()) || clsName.equals(SerialHandlerSolaris.class.getName())) {
            serialProcessors.add(new ProtocolProcessorItem(protocol, handler, abstractProcess));
        } else if (clsName.equals(USBHandler.class.getName())) {
            usbProcessors.add(new ProtocolProcessorItem(protocol, handler, abstractProcess));
        } else if (clsName.equals(ModbusHandler.class.getName())) {
            modbusProcessors.add(new ProtocolProcessorItem(protocol, handler, abstractProcess));
        } else if (clsName.equals(SNMPHandler.class.getName())) {
            snmpProcessors.add(new ProtocolProcessorItem(protocol, handler, abstractProcess));
        } else {
            _protocolList.add(new ProtocolProcessorItem(protocol, handler, abstractProcess));
        }
    }

    public static synchronized AbstractProcessor getNewMonitor(Object handler) {
        AbstractProcessor process = null;
        for (ProtocolProcessorItem item : _protocolList) {
            process = item.getMatchProcess(handler);
            if (process != null) break;
        }
        return process;
    }

    public static synchronized AbstractProcessor getSerialMonitor(Object handler) {
        AbstractProcessor process = null;
        for (ProtocolProcessorItem item : serialProcessors) {
            process = item.getMatchProcess(handler);
            if (process != null) break;
        }
        return process;
    }

    public static synchronized AbstractProcessor getUsbMonitor(Object handler) {
        AbstractProcessor process = null;
        for (ProtocolProcessorItem item : usbProcessors) {
            process = item.getMatchProcess(handler);
            if (process != null) break;
        }
        return process;
    }

    public static synchronized AbstractProcessor getSnmpMonitor(Object handler) {
        AbstractProcessor process = null;
        for (ProtocolProcessorItem item : snmpProcessors) {
            process = item.getMatchProcess(handler);
            if (process != null) break;
        }
        return process;
    }

    public static synchronized AbstractProcessor getModbusMonitor(Object handler) {
        AbstractProcessor process = null;
        for (ProtocolProcessorItem item : modbusProcessors) {
            process = item.getMatchProcess(handler);
            if (process != null) break;
        }
        return process;
    }
}

