/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.util;

import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;

public class ModemAdapter {
    private String[] destinations;
    private String mobileNum;
    private String message;
    private int baudRate;
    private String portName;
    String mstr2 = null;
    private PrintWriter pw;
    private DataInputStream in;

    public ModemAdapter(String portName, int baudRate, String[] destinations, String message) {
        this.destinations = destinations;
        this.message = message;
        this.baudRate = baudRate;
        this.portName = portName;
    }

    public ModemAdapter(String portName, int baudRate, String mobileNum, String message) {
        this.mobileNum = mobileNum;
        this.message = message;
        this.baudRate = baudRate;
        this.portName = portName;
    }

    public boolean startSendOne() {
        boolean result = false;
        int keeptime = 5000;
        Enumeration portList = CommPortIdentifier.getPortIdentifiers();
        while (portList.hasMoreElements()) {
            CommPortIdentifier portID = (CommPortIdentifier)portList.nextElement();
            if (!portID.getName().equals(this.portName)) continue;
            SerialPort sPort = null;
            StringBuilder sb = new StringBuilder();
            try {
                try {
                    sPort = (SerialPort)portID.open("ats", keeptime);
                    sPort.setSerialPortParams(this.baudRate, 8, 1, 0);
                    sPort.enableReceiveTimeout(1200);
                    this.pw = new PrintWriter(sPort.getOutputStream());
                    this.pw.println("at+cmgf=0;");
                    this.pw.flush();
                    int c = 0;
                    this.in = new DataInputStream(sPort.getInputStream());
                    long end = System.currentTimeMillis() + 1000L;
                    while (System.currentTimeMillis() < end) {
                        c = this.in.read();
                        if (c == -1) continue;
                        sb.append((char)c);
                        String temp = sb.toString();
                        if (temp.endsWith("OK")) {
                            result = true;
                            break;
                        }
                        if (temp.endsWith("ERROR")) break;
                    }
                    if (result) {
                        this.sendSMS(this.mobileNum, this.message);
                    }
                }
                catch (Exception e) {
                    result = false;
                    if (this.in != null) {
                        try {
                            this.in.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (this.pw != null) {
                        this.pw.close();
                    }
                    if (sPort == null) continue;
                    sPort.close();
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (this.in != null) {
                    try {
                        this.in.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (this.pw != null) {
                    this.pw.close();
                }
                if (sPort != null) {
                    sPort.close();
                }
                throw throwable;
            }
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.pw != null) {
                this.pw.close();
            }
            if (sPort == null) continue;
            sPort.close();
        }
        return result;
    }

    public boolean startSend() {
        boolean result = false;
        int keeptime = 5000;
        Enumeration portList = CommPortIdentifier.getPortIdentifiers();
        while (portList.hasMoreElements()) {
            CommPortIdentifier portID = (CommPortIdentifier)portList.nextElement();
            if (!portID.getName().equals(this.portName)) continue;
            SerialPort sPort = null;
            StringBuilder sb = new StringBuilder();
            try {
                try {
                    sPort = (SerialPort)portID.open("ats", keeptime);
                    sPort.setSerialPortParams(this.baudRate, 8, 1, 0);
                    sPort.enableReceiveTimeout(1200);
                    this.pw = new PrintWriter(sPort.getOutputStream());
                    this.pw.println("at+cmgf=0;");
                    this.pw.flush();
                    int c = 0;
                    this.in = new DataInputStream(sPort.getInputStream());
                    long end = System.currentTimeMillis() + 1000L;
                    while (System.currentTimeMillis() < end) {
                        c = this.in.read();
                        if (c == -1) continue;
                        sb.append((char)c);
                        String temp = sb.toString();
                        if (temp.endsWith("OK")) {
                            result = true;
                            break;
                        }
                        if (temp.endsWith("ERROR")) break;
                    }
                    if (result) {
                        String[] stringArray = this.destinations;
                        int n = this.destinations.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String destination = stringArray[n2];
                            Thread.sleep(500L);
                            this.sendSMS(destination, this.message);
                            ++n2;
                        }
                    }
                }
                catch (Exception e) {
                    result = false;
                    if (this.in != null) {
                        try {
                            this.in.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (this.pw != null) {
                        this.pw.close();
                    }
                    if (sPort == null) continue;
                    sPort.close();
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (this.in != null) {
                    try {
                        this.in.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (this.pw != null) {
                    this.pw.close();
                }
                if (sPort != null) {
                    sPort.close();
                }
                throw throwable;
            }
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.pw != null) {
                this.pw.close();
            }
            if (sPort == null) continue;
            sPort.close();
        }
        return result;
    }

    private void sendMsg(String msg) {
        this.pw.println(msg);
        this.pw.flush();
    }

    public static void main(String[] args) {
        String[] destinations = new String[]{"13538199005", "13480630524"};
        ModemAdapter adapter = new ModemAdapter("COM1", 9600, destinations, "\u6d4b\u8bd5\u77ed\u4fe1\u6a21\u5757\u53d1\u9001\u7a0b\u5e8f\u7684\u4ee3\u7801");
        try {
            System.out.println(adapter.startSend());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void sendSMS(String phone, String message) {
        String phonelen;
        if (phone.indexOf("-") != -1) {
            phone = phone.replaceAll("-", "");
        }
        if ((phonelen = Integer.toHexString(phone.length()).toUpperCase()).length() < 2) {
            phonelen = "0" + phonelen;
        }
        String sPhone = this.smsPhoneTranslate(phone);
        String sContent = this.smsMessageTranslateU(message);
        int len = sContent.length();
        len = (16 + sPhone.length() + len) / 2;
        String lenth = String.valueOf(len);
        int mlen = message.length();
        String messagelen = Integer.toHexString(mlen * 2);
        if ((messagelen = messagelen.toUpperCase()).length() < 2) {
            messagelen = "0" + messagelen;
        }
        String cstemp = "AT+CMGS=" + lenth;
        cstemp = String.valueOf(cstemp) + "\r";
        this.sendMsg(cstemp);
        long current = System.currentTimeMillis();
        while (System.currentTimeMillis() - current < 1000L) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        cstemp = "001100" + phonelen;
        cstemp = String.valueOf(cstemp) + "81";
        cstemp = String.valueOf(cstemp) + sPhone;
        cstemp = String.valueOf(cstemp) + "0008A7";
        cstemp = String.valueOf(cstemp) + messagelen;
        cstemp = String.valueOf(cstemp) + sContent;
        char charTemp = '\u001a';
        cstemp = String.valueOf(cstemp) + String.valueOf(charTemp);
        this.sendMsg(cstemp);
        current = System.currentTimeMillis();
        while (System.currentTimeMillis() - current < 1000L) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.mstr2 = "";
        current = System.currentTimeMillis();
        while (System.currentTimeMillis() - current < 10000L && this.mstr2.indexOf("OK", 0) == -1) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String smsPhoneTranslate(String number) {
        String csNum = "";
        if (number.length() % 2 == 1) {
            number = String.valueOf(number) + "F";
        }
        int len = number.length();
        int i = 0;
        while (i < len) {
            String first = number.substring(i, i + 1);
            String second = number.substring(i + 1, i + 2);
            csNum = String.valueOf(csNum) + second + first;
            ++i;
            ++i;
        }
        return csNum;
    }

    private String smsMessageTranslateU(String Content) {
        try {
            StringBuffer sb = new StringBuffer(500);
            sb.setLength(0);
            int i = 0;
            while (i < Content.length()) {
                char c = Content.charAt(i);
                if (c > '\u00ff') {
                    int j = c >>> 8;
                    String tmp = Integer.toHexString(j);
                    if (tmp.length() == 1) {
                        sb.append("0");
                    }
                    sb.append(tmp);
                    j = c & 0xFF;
                    tmp = Integer.toHexString(j);
                    if (tmp.length() == 1) {
                        sb.append("0");
                    }
                    sb.append(tmp);
                } else {
                    sb.append("00" + Integer.toHexString(c));
                }
                ++i;
            }
            return new String(sb).toUpperCase();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }
}

