/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.util;

import cn.com.voltronic.solar.console.SolarPowerTray;
import cn.com.voltronic.solar.data.bean.AutoComboBoxItem;
import cn.com.voltronic.solar.data.bean.AutoLabelItem;
import cn.com.voltronic.solar.data.bean.AutoRadioItem;
import cn.com.voltronic.solar.data.bean.AutoSpinnerItem;
import cn.com.voltronic.solar.data.bean.ConfigData;
import cn.com.voltronic.solar.data.bean.RefreshProductInfo;
import cn.com.voltronic.solar.data.bean.RefreshRatingInfo;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.protocol.IProtocol;
import cn.com.voltronic.solar.system.GlobalProcessors;
import cn.com.voltronic.solar.util.VolUtil;
import cn.com.voltronic.solar.view.LoginJDialog;
import cn.com.voltronic.solar.view.component.AAButton;
import cn.com.voltronic.solar.view.component.AAComboBox;
import cn.com.voltronic.solar.view.component.AALabel;
import cn.com.voltronic.solar.view.component.AARadioButton;
import cn.com.voltronic.solar.view.component.AATextField;
import cn.com.voltronic.solar.view.component.ComponentFactory;
import cn.com.voltronic.solar.view.component.DisplayMessage;
import cn.com.voltronic.solar.view.component.I18NListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PageUtils {
    private static JSpinner jSpinnerBulkVoltage = null;
    private static JSpinner jSpinnerFloatVoltage = null;

    public static String getResultByName(String text, Object object) {
        int index = 0;
        int indexend = 0;
        block2: while ((index = text.indexOf("{", indexend)) >= 0 && text.length() > 3) {
            String replace;
            String classmtd;
            int classindex;
            indexend = text.indexOf("}", index + 1);
            if (indexend <= index || (classindex = (classmtd = (replace = text.substring(index, indexend + 1)).substring(1, replace.length() - 1)).indexOf(".")) <= 0) continue;
            String classname = classmtd.substring(0, classindex);
            String method = classmtd.substring(classindex + 1);
            try {
                Field[] field;
                Field[] fieldArray = field = object.getClass().getDeclaredFields();
                int n = field.length;
                int n2 = 0;
                while (n2 < n) {
                    Field f = fieldArray[n2];
                    if (f.getName().equals(classname)) {
                        Method[] methods;
                        if (!f.isAccessible()) {
                            f.setAccessible(true);
                        }
                        Object obj = f.get(object);
                        Method[] methodArray = methods = obj.getClass().getMethods();
                        int n3 = methods.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Method m = methodArray[n4];
                            if (m.getName().equals(method)) {
                                Object instead = m.invoke(obj, new Object[0]);
                                if (instead == null) {
                                    instead = "";
                                }
                                text = instead.toString();
                                indexend = 0;
                                continue block2;
                            }
                            ++n4;
                        }
                        continue block2;
                    }
                    ++n2;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return text;
    }

    public static void setSpinnerLayout(List<AutoSpinnerItem> list, JPanel panel, Object object) {
        panel.setLayout(new BorderLayout());
        int index = 2;
        index = list.size() % 2 == 0 ? list.size() / 2 : list.size() / 2 + 1;
        JPanel leftPanel = new JPanel();
        JPanel rightPanel = new JPanel();
        GroupLayout layout = new GroupLayout(leftPanel);
        leftPanel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        GroupLayout.SequentialGroup hGroup = layout.createSequentialGroup();
        GroupLayout.SequentialGroup vGroup = layout.createSequentialGroup();
        GroupLayout.ParallelGroup p1 = layout.createParallelGroup(GroupLayout.Alignment.TRAILING);
        GroupLayout.ParallelGroup p2 = layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        GroupLayout.ParallelGroup p3 = layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        GroupLayout.ParallelGroup p4 = layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        int i = 0;
        while (i < index) {
            AALabel caption1 = new AALabel();
            double minValue1 = VolUtil.parseDouble(PageUtils.getResultByName(list.get(i).getMinValue(), object));
            double maxValue1 = VolUtil.parseDouble(PageUtils.getResultByName(list.get(i).getMaxValue(), object));
            double step1 = VolUtil.parseDouble(list.get(i).getStep());
            double nvalue1 = VolUtil.parseDouble(PageUtils.getResultByName(list.get(i).getValue(), object));
            AALabel unit1 = new AALabel();
            final AAButton button1 = new AAButton();
            button1.setEnabled(list.get(i).isEnable());
            final JSpinner value1 = ComponentFactory.createNumberSpinner(minValue1, maxValue1, step1, nvalue1);
            value1.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    boolean enabled = true;
                    AbstractProcessor processor = GlobalProcessors.getCurrentProcessor();
                    if (processor != null) {
                        IProtocol protocol = processor.getProtocol();
                        String prodid = protocol.getProtocolID();
                        ConfigData configData = (ConfigData)processor.getBeanBag().getBean("configdata");
                        String batteryType = configData.getBatteryType();
                        enabled = batteryType.equals("User") ? true : (prodid.equals("P30LY") && batteryType.equals("Flooded") ? true : true);
                    }
                    if (enabled) {
                        button1.setEnabled(true);
                    }
                }
            });
            caption1.setText(list.get(i).getCaption());
            unit1.setText(list.get(i).getUnit());
            button1.setText("message.apply");
            button1.setName(list.get(i).getButtonName());
            if (button1.getName().equals("setMaxChargingVoltage")) {
                jSpinnerBulkVoltage = value1;
            } else if (button1.getName().equals("setFloatingVoltage")) {
                jSpinnerFloatVoltage = value1;
            }
            button1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!SolarPowerTray.isLogin) {
                        new LoginJDialog(new Frame(), true);
                        return;
                    }
                    AbstractProcessor currentProcessor = GlobalProcessors.getCurrentProcessor();
                    if (currentProcessor != null) {
                        button1.setEnabled(false);
                        String name = button1.getName();
                        boolean result = false;
                        String value = value1.getValue().toString();
                        if (name.equals("MaxChargeCurrent")) {
                            result = currentProcessor.executeControl("setMaxChargingCurrent", new Object[]{VolUtil.parseInt(value.substring(0, 2))});
                        } else if (name.equals("PMaxChargeCurrent")) {
                            result = currentProcessor.executeControl("setPMaxChargingCurrent", new Object[]{currentProcessor.getParallKey(), VolUtil.parseInt(value.substring(0, 2))});
                        } else if (name.equals("BatteryLowAlarm")) {
                            result = currentProcessor.executeControl("setBatteryLow", new Object[]{VolUtil.round(VolUtil.parseDouble(value), 1)});
                        } else if (name.equals("setBatteryCutoffVoltage")) {
                            result = currentProcessor.executeControl("setBatteryUnder", new Object[]{VolUtil.round(VolUtil.parseDouble(value), 1)});
                        } else if (name.equals("setMaxChargingVoltage")) {
                            if (jSpinnerFloatVoltage != null && (Double)jSpinnerFloatVoltage.getValue() > (Double)value1.getValue()) {
                                DisplayMessage.showInfoDialog("Bulk charging voltage can not less than floating charging voltage");
                                return;
                            }
                            result = currentProcessor.executeControl(name, new Object[]{VolUtil.round(VolUtil.parseDouble(value), 1)});
                        } else if (name.equals("setFloatingVoltage")) {
                            if (jSpinnerBulkVoltage != null && (Double)jSpinnerBulkVoltage.getValue() < (Double)value1.getValue()) {
                                DisplayMessage.showInfoDialog("Floating voltage can not larger than bulk charging voltage");
                                return;
                            }
                            result = currentProcessor.executeControl(name, new Object[]{VolUtil.round(VolUtil.parseDouble(value), 1)});
                        } else {
                            result = currentProcessor.executeControl(name, new Object[]{VolUtil.round(VolUtil.parseDouble(value), 1)});
                        }
                        if (result) {
                            DisplayMessage.showInfoDialog("message.setTrue");
                        } else {
                            DisplayMessage.showErrorDialog("message.setFalse");
                        }
                        button1.setEnabled(true);
                    }
                }
            });
            p1.addComponent(caption1);
            p2.addComponent(value1, 60, 60, 60);
            p3.addComponent(unit1);
            p4.addComponent(button1);
            vGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(caption1).addComponent(value1).addComponent(unit1).addComponent(button1));
            vGroup.addGap(15, 15, 15);
            ++i;
        }
        hGroup.addGap(40, 40, 40);
        hGroup.addGroup(p1);
        hGroup.addGroup(p2);
        hGroup.addGroup(p3);
        hGroup.addGroup(p4);
        hGroup.addGap(20, 20, 20);
        layout.setHorizontalGroup(hGroup);
        layout.setVerticalGroup(vGroup);
        GroupLayout layout2 = new GroupLayout(rightPanel);
        rightPanel.setLayout(layout2);
        layout2.setAutoCreateGaps(true);
        layout2.setAutoCreateContainerGaps(true);
        GroupLayout.SequentialGroup hGroup2 = layout2.createSequentialGroup();
        GroupLayout.SequentialGroup vGroup2 = layout2.createSequentialGroup();
        GroupLayout.ParallelGroup p5 = layout2.createParallelGroup(GroupLayout.Alignment.TRAILING);
        GroupLayout.ParallelGroup p6 = layout2.createParallelGroup(GroupLayout.Alignment.LEADING);
        GroupLayout.ParallelGroup p7 = layout2.createParallelGroup(GroupLayout.Alignment.LEADING);
        GroupLayout.ParallelGroup p8 = layout2.createParallelGroup(GroupLayout.Alignment.LEADING);
        int j = index;
        while (j < list.size()) {
            AALabel caption2 = new AALabel();
            double minValue2 = VolUtil.parseDouble(PageUtils.getResultByName(list.get(j).getMinValue(), object));
            double maxValue2 = VolUtil.parseDouble(PageUtils.getResultByName(list.get(j).getMaxValue(), object));
            double step2 = VolUtil.parseDouble(list.get(j).getStep());
            double nvalue2 = VolUtil.parseDouble(PageUtils.getResultByName(list.get(j).getValue(), object));
            AALabel unit2 = new AALabel();
            final AAButton button2 = new AAButton();
            button2.setEnabled(list.get(j).isEnable());
            final JSpinner value2 = ComponentFactory.createNumberSpinner(minValue2, maxValue2, step2, nvalue2);
            value2.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    boolean enabled = true;
                    AbstractProcessor processor = GlobalProcessors.getCurrentProcessor();
                    if (processor != null) {
                        IProtocol protocol = processor.getProtocol();
                        String prodid = protocol.getProtocolID();
                        ConfigData configData = (ConfigData)processor.getBeanBag().getBean("configdata");
                        String batteryType = configData.getBatteryType();
                        enabled = batteryType.equals("User") ? true : (prodid.equals("P30LY") && batteryType.equals("Flooded") ? true : true);
                    }
                    if (enabled) {
                        button2.setEnabled(true);
                    }
                }
            });
            caption2.setText(list.get(j).getCaption());
            unit2.setText(list.get(j).getUnit());
            button2.setText("message.apply");
            button2.setName(list.get(j).getButtonName());
            if (button2.getName().equals("setMaxChargingVoltage")) {
                jSpinnerBulkVoltage = value2;
            } else if (button2.getName().equals("setFloatingVoltage")) {
                jSpinnerFloatVoltage = value2;
            }
            button2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!SolarPowerTray.isLogin) {
                        new LoginJDialog(new Frame(), true);
                        return;
                    }
                    AbstractProcessor currentProcessor = GlobalProcessors.getCurrentProcessor();
                    if (currentProcessor != null) {
                        button2.setEnabled(false);
                        String name = button2.getName();
                        boolean result = false;
                        String value = value2.getValue().toString();
                        if (name.equals("MaxChargeCurrent")) {
                            result = currentProcessor.executeControl("setMaxChargingCurrent", new Object[]{VolUtil.parseInt(value.substring(0, 2))});
                        } else if (name.equals("PMaxChargeCurrent")) {
                            result = currentProcessor.executeControl("setPMaxChargingCurrent", new Object[]{currentProcessor.getParallKey(), VolUtil.parseInt(value.substring(0, 2))});
                        } else if (name.equals("BatteryLowAlarm")) {
                            result = currentProcessor.executeControl("setBatteryLow", new Object[]{VolUtil.round(VolUtil.parseDouble(value), 1)});
                        } else if (name.equals("setBatteryCutoffVoltage")) {
                            result = currentProcessor.executeControl("setBatteryUnder", new Object[]{VolUtil.round(VolUtil.parseDouble(value), 1)});
                        } else if (name.equals("setMaxChargingVoltage")) {
                            if (jSpinnerFloatVoltage != null && (Double)jSpinnerFloatVoltage.getValue() > (Double)value2.getValue()) {
                                DisplayMessage.showInfoDialog("Bulk charging voltage can not less than floating charging voltage");
                                return;
                            }
                            result = currentProcessor.executeControl(name, new Object[]{VolUtil.round(VolUtil.parseDouble(value), 1)});
                        } else if (name.equals("setFloatingVoltage")) {
                            if (jSpinnerBulkVoltage != null && (Double)jSpinnerBulkVoltage.getValue() < (Double)value2.getValue()) {
                                DisplayMessage.showInfoDialog("Floating voltage can not larger than bulk charging voltage");
                                return;
                            }
                            result = currentProcessor.executeControl(name, new Object[]{VolUtil.round(VolUtil.parseDouble(value), 1)});
                        } else {
                            result = currentProcessor.executeControl(name, new Object[]{VolUtil.round(VolUtil.parseDouble(value), 1)});
                        }
                        if (result) {
                            DisplayMessage.showInfoDialog("message.setTrue");
                        } else {
                            DisplayMessage.showErrorDialog("message.setFalse");
                        }
                        button2.setEnabled(true);
                    }
                }
            });
            p5.addComponent(caption2);
            p6.addComponent(value2, 60, 60, 60);
            p7.addComponent(unit2);
            p8.addComponent(button2);
            vGroup2.addGroup(layout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(caption2).addComponent(value2).addComponent(unit2).addComponent(button2));
            vGroup2.addGap(15, 15, 15);
            ++j;
        }
        hGroup2.addGap(20, 20, 20);
        hGroup2.addGroup(p5);
        hGroup2.addGroup(p6);
        hGroup2.addGroup(p7);
        hGroup2.addGroup(p8);
        hGroup2.addGap(40, 40, 40);
        layout2.setHorizontalGroup(hGroup2);
        layout2.setVerticalGroup(vGroup2);
        panel.add((Component)leftPanel, "Center");
        panel.add((Component)rightPanel, "East");
    }

    public static void setComboBoxLayout(List<AutoComboBoxItem> list, JPanel panel, Object object) {
        panel.setLayout(new BorderLayout());
        int index = 2;
        index = list.size() % 2 == 0 ? list.size() / 2 : list.size() / 2 + 1;
        JPanel leftPanel = new JPanel();
        JPanel rightPanel = new JPanel();
        GroupLayout layout = new GroupLayout(leftPanel);
        leftPanel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        GroupLayout.SequentialGroup hGroup = layout.createSequentialGroup();
        GroupLayout.SequentialGroup vGroup = layout.createSequentialGroup();
        GroupLayout.ParallelGroup p1 = layout.createParallelGroup(GroupLayout.Alignment.TRAILING);
        GroupLayout.ParallelGroup p2 = layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        GroupLayout.ParallelGroup p3 = layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        GroupLayout.ParallelGroup p4 = layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        int i = 0;
        while (i < index) {
            AALabel caption1 = new AALabel();
            String[] selects1 = list.get(i).getSelects();
            String nvalue1 = PageUtils.getResultByName(list.get(i).getValue(), object);
            AALabel unit1 = new AALabel();
            final AAButton button1 = new AAButton();
            button1.setEnabled(list.get(i).isEnable());
            final AAComboBox value1 = ComponentFactory.createComboBox(selects1, nvalue1);
            if (list.get(i).getButtonName().equalsIgnoreCase("OutputMode")) {
                value1.setSelectedIndex(Integer.parseInt(nvalue1));
            }
            value1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    button1.setEnabled(true);
                }
            });
            caption1.setText(list.get(i).getCaption());
            unit1.setText(list.get(i).getUnit());
            button1.setText("message.apply");
            button1.setName(list.get(i).getButtonName());
            button1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!SolarPowerTray.isLogin) {
                        new LoginJDialog(new Frame(), true);
                        return;
                    }
                    AbstractProcessor currentProcessor = GlobalProcessors.getCurrentProcessor();
                    if (currentProcessor != null) {
                        button1.setEnabled(false);
                        String name = button1.getName();
                        boolean result = false;
                        String value = value1.getSelectedItem().toString();
                        if (name.equals("ChargerSource")) {
                            if (currentProcessor.getProtocol().getAxpert().equals("024") || currentProcessor.getProtocol().getAxpert().equals("023")) {
                                if (value.equals("SBL&UCB")) {
                                    result = currentProcessor.executeControl("setChargerSource", new Object[]{"00"});
                                } else if (value.equals("SBL&UDC")) {
                                    result = currentProcessor.executeControl("setChargerSource", new Object[]{"01"});
                                } else if (value.equals("SLB&UCB")) {
                                    result = currentProcessor.executeControl("setChargerSource", new Object[]{"02"});
                                } else if (value.equals("SLB&UDC")) {
                                    result = currentProcessor.executeControl("setChargerSource", new Object[]{"03"});
                                }
                            } else if (value.equals("Utility")) {
                                result = currentProcessor.executeControl("setChargerSource", new Object[]{"00"});
                            } else if (value.equals("Solar first")) {
                                result = currentProcessor.executeControl("setChargerSource", new Object[]{"01"});
                            } else if (value.equals("Utility and Solar")) {
                                result = currentProcessor.executeControl("setChargerSource", new Object[]{"02"});
                            } else if (value.equals("Solar only")) {
                                result = currentProcessor.executeControl("setChargerSource", new Object[]{"03"});
                            }
                        } else if (name.equals("PChargerSource")) {
                            if (currentProcessor.getProtocol().getAxpert().equals("024") || currentProcessor.getProtocol().getAxpert().equals("023")) {
                                if (value.equals("SBL&UCB")) {
                                    result = currentProcessor.executeControl("setPChargerSource", new Object[]{currentProcessor.getParallKey(), "00"});
                                } else if (value.equals("SBL&UDC")) {
                                    result = currentProcessor.executeControl("setPChargerSource", new Object[]{currentProcessor.getParallKey(), "01"});
                                } else if (value.equals("SLB&UCB")) {
                                    result = currentProcessor.executeControl("setPChargerSource", new Object[]{currentProcessor.getParallKey(), "02"});
                                } else if (value.equals("SLB&UDC")) {
                                    result = currentProcessor.executeControl("setPChargerSource", new Object[]{currentProcessor.getParallKey(), "03"});
                                }
                            } else if (value.equals("Utility")) {
                                result = currentProcessor.executeControl("setPChargerSource", new Object[]{currentProcessor.getParallKey(), "00"});
                            } else if (value.equals("Solar first")) {
                                result = currentProcessor.executeControl("setPChargerSource", new Object[]{currentProcessor.getParallKey(), "01"});
                            } else if (value.equals("Utility and Solar")) {
                                result = currentProcessor.executeControl("setPChargerSource", new Object[]{currentProcessor.getParallKey(), "02"});
                            } else if (value.equals("Solar only")) {
                                result = currentProcessor.executeControl("setPChargerSource", new Object[]{currentProcessor.getParallKey(), "03"});
                            }
                        } else if (name.equals("BatteryType")) {
                            if (value.equals("AGM")) {
                                result = currentProcessor.executeControl("setBatteryType", new Object[]{"00"});
                            } else if (value.equals("Flooded")) {
                                result = currentProcessor.executeControl("setBatteryType", new Object[]{"01"});
                            } else if (value.equals("User")) {
                                result = currentProcessor.executeControl("setBatteryType", new Object[]{"02"});
                            }
                        } else if (name.equals("OutputSource")) {
                            if (value.equals("Utility->Solar->Battery") || value.equals("Utility")) {
                                result = currentProcessor.executeControl("setOutputSource", new Object[]{"00"});
                            } else if (value.equals("Solar->Utility->Battery") || value.equals("Solar")) {
                                result = currentProcessor.executeControl("setOutputSource", new Object[]{"01"});
                            } else if (value.equals("Solar->Battery->Utility") || value.equals("SBU")) {
                                result = currentProcessor.executeControl("setOutputSource", new Object[]{"02"});
                            }
                        } else if (name.equals("ACInputRange")) {
                            if (value.equals("Appliance") || value.equals("APL range")) {
                                result = currentProcessor.executeControl("setGridWorkRange", new Object[]{"00"});
                            } else if (value.equals("UPS")) {
                                result = currentProcessor.executeControl("setGridWorkRange", new Object[]{"01"});
                            } else if (value.equals("Parallel 1")) {
                                result = currentProcessor.executeControl("setGridWorkRange", new Object[]{"02"});
                            } else if (value.equals("Parallel 2")) {
                                result = currentProcessor.executeControl("setGridWorkRange", new Object[]{"03"});
                            }
                        } else if (name.equals("OutputFrequency")) {
                            result = currentProcessor.executeControl("setOutputFrequency", new Object[]{VolUtil.parseInt(value)});
                        } else if (name.equals("BypassFunction")) {
                            if (value.equals("Forbidden")) {
                                result = currentProcessor.executeControl("setBypassFunction", new Object[]{0});
                            } else if (value.equals("Disable")) {
                                result = currentProcessor.executeControl("setBypassFunction", new Object[]{1});
                            } else if (value.equals("Enable")) {
                                result = currentProcessor.executeControl("setBypassFunction", new Object[]{2});
                            }
                        } else if (name.equals("OperationLogic")) {
                            if (value.equals("Forbidden")) {
                                result = currentProcessor.executeControl("setOperationLogic", new Object[]{0});
                            } else if (value.equals("Disable")) {
                                result = currentProcessor.executeControl("setOperationLogic", new Object[]{1});
                            } else if (value.equals("Enable")) {
                                result = currentProcessor.executeControl("setOperationLogic", new Object[]{2});
                            }
                        } else if (name.equals("OutputVoltage")) {
                            result = currentProcessor.executeControl("setOutputVoltage", new Object[]{VolUtil.parseInt(value)});
                        } else if (name.equals("setPOPV")) {
                            result = currentProcessor.executeControl("setPOPV", new Object[]{VolUtil.parseInt(value)});
                        } else if (name.equals("MaxChargeVoltage")) {
                            result = currentProcessor.executeControl("setMaxChargingVoltage", new Object[]{VolUtil.round(VolUtil.parseDouble(value), 1)});
                        } else if (name.equalsIgnoreCase("ReChargeVoltage")) {
                            result = currentProcessor.executeControl("setRechargingVol", new Object[]{VolUtil.round(VolUtil.parseDouble(value), 1)});
                        } else if (name.equalsIgnoreCase("ReDisChargeVoltage")) {
                            result = currentProcessor.executeControl("setReDisChargeVoltage", new Object[]{VolUtil.round(VolUtil.parseDouble(value), 1)});
                        } else if (name.equalsIgnoreCase("OutputMode")) {
                            result = currentProcessor.executeControl("setOutputMode", new Object[]{currentProcessor.getParallKey(), value1.getSelectedIndex()});
                        } else if (name.equals("PMaxChargeCurrent")) {
                            result = currentProcessor.executeControl("setPMaxChargingCurrent", new Object[]{currentProcessor.getParallKey(), VolUtil.parseInt(value)});
                        } else if (name.equals("NPMaxChargeCurrent")) {
                            result = currentProcessor.executeControl("setNPMaxChargingCurrent", new Object[]{currentProcessor.getParallKey(), VolUtil.parseInt(value)});
                        } else if (name.equals("VNPMaxChargeCurrent")) {
                            result = currentProcessor.executeControl("setVNPMaxChargingCurrent", new Object[]{VolUtil.parseInt(value)});
                        } else if (name.equals("PMaxACChargeCurrent")) {
                            result = currentProcessor.executeControl("setPMaxACChargeCurrent", new Object[]{currentProcessor.getParallKey(), VolUtil.parseInt(value)});
                        } else if (name.equals("VPMaxACChargeCurrent")) {
                            result = currentProcessor.executeControl("setVPMaxACChargeCurrent", new Object[]{VolUtil.parseInt(value)});
                        } else if (name.equals("MSCHGC")) {
                            result = currentProcessor.executeControl("setMSCHGC", new Object[]{value});
                        } else if (name.equals("PCST")) {
                            result = currentProcessor.executeControl("setPCST", new Object[]{value});
                        } else if (name.equals("PCVT")) {
                            result = currentProcessor.executeControl("setPCVT", new Object[]{value});
                        } else if (name.equals("BatReDischargeCapacity")) {
                            result = currentProcessor.executeControl("setBatReDischargeCapacity", new Object[]{VolUtil.round(VolUtil.parseDouble(value), 1)});
                        }
                        if (result) {
                            DisplayMessage.showInfoDialog("message.setTrue");
                        } else {
                            DisplayMessage.showErrorDialog("message.setFalse");
                        }
                        button1.setEnabled(true);
                    }
                }
            });
            p1.addComponent(caption1);
            p2.addComponent(value1, 100, 200, 200);
            p3.addComponent(unit1);
            p4.addComponent(button1);
            vGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(caption1).addComponent(value1).addComponent(unit1).addComponent(button1));
            vGroup.addGap(15, 15, 15);
            ++i;
        }
        hGroup.addGap(40, 40, 40);
        hGroup.addGroup(p1);
        hGroup.addGroup(p2);
        hGroup.addGroup(p3);
        hGroup.addGroup(p4);
        hGroup.addGap(20, 20, 20);
        layout.setHorizontalGroup(hGroup);
        layout.setVerticalGroup(vGroup);
        GroupLayout layout2 = new GroupLayout(rightPanel);
        rightPanel.setLayout(layout2);
        layout2.setAutoCreateGaps(true);
        layout2.setAutoCreateContainerGaps(true);
        GroupLayout.SequentialGroup hGroup2 = layout2.createSequentialGroup();
        GroupLayout.SequentialGroup vGroup2 = layout2.createSequentialGroup();
        GroupLayout.ParallelGroup p5 = layout2.createParallelGroup(GroupLayout.Alignment.TRAILING);
        GroupLayout.ParallelGroup p6 = layout2.createParallelGroup(GroupLayout.Alignment.LEADING);
        GroupLayout.ParallelGroup p7 = layout2.createParallelGroup(GroupLayout.Alignment.LEADING);
        GroupLayout.ParallelGroup p8 = layout2.createParallelGroup(GroupLayout.Alignment.LEADING);
        int j = index;
        while (j < list.size()) {
            AALabel caption2 = new AALabel();
            String[] selects2 = list.get(j).getSelects();
            String nvalue2 = PageUtils.getResultByName(list.get(j).getValue(), object);
            AALabel unit2 = new AALabel();
            final AAButton button2 = new AAButton();
            button2.setEnabled(list.get(j).isEnable());
            final AAComboBox value2 = ComponentFactory.createComboBox(selects2, nvalue2);
            if (list.get(j).getButtonName().equalsIgnoreCase("OutputMode")) {
                value2.setSelectedIndex(Integer.parseInt(nvalue2));
            }
            value2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    button2.setEnabled(true);
                }
            });
            caption2.setText(list.get(j).getCaption());
            unit2.setText(list.get(j).getUnit());
            button2.setText("message.apply");
            button2.setName(list.get(j).getButtonName());
            button2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!SolarPowerTray.isLogin) {
                        new LoginJDialog(new Frame(), true);
                        return;
                    }
                    AbstractProcessor currentProcessor = GlobalProcessors.getCurrentProcessor();
                    if (currentProcessor != null) {
                        button2.setEnabled(false);
                        String name = button2.getName();
                        boolean result = false;
                        String value = value2.getSelectedItem().toString();
                        if (name.equals("ChargerSource")) {
                            if (value.equals("Utility")) {
                                result = currentProcessor.executeControl("setChargerSource", new Object[]{"00"});
                            } else if (value.equals("Solar first")) {
                                result = currentProcessor.executeControl("setChargerSource", new Object[]{"01"});
                            } else if (value.equals("Utility and Solar")) {
                                result = currentProcessor.executeControl("setChargerSource", new Object[]{"02"});
                            } else if (value.equals("Solar only")) {
                                result = currentProcessor.executeControl("setChargerSource", new Object[]{"03"});
                            }
                        } else if (name.equals("PChargerSource")) {
                            if (currentProcessor.getProtocol().getAxpert().equals("024") || currentProcessor.getProtocol().getAxpert().equals("023")) {
                                if (value.equals("SBL&UCB")) {
                                    result = currentProcessor.executeControl("setPChargerSource", new Object[]{currentProcessor.getParallKey(), "00"});
                                } else if (value.equals("SBL&UDC")) {
                                    result = currentProcessor.executeControl("setPChargerSource", new Object[]{currentProcessor.getParallKey(), "01"});
                                } else if (value.equals("SLB&UCB")) {
                                    result = currentProcessor.executeControl("setPChargerSource", new Object[]{currentProcessor.getParallKey(), "02"});
                                } else if (value.equals("SLB&UDC")) {
                                    result = currentProcessor.executeControl("setPChargerSource", new Object[]{currentProcessor.getParallKey(), "03"});
                                }
                            } else if (value.equals("Utility")) {
                                result = currentProcessor.executeControl("setPChargerSource", new Object[]{currentProcessor.getParallKey(), "00"});
                            } else if (value.equals("Solar first")) {
                                result = currentProcessor.executeControl("setPChargerSource", new Object[]{currentProcessor.getParallKey(), "01"});
                            } else if (value.equals("Utility and Solar")) {
                                result = currentProcessor.executeControl("setPChargerSource", new Object[]{currentProcessor.getParallKey(), "02"});
                            } else if (value.equals("Solar only")) {
                                result = currentProcessor.executeControl("setPChargerSource", new Object[]{currentProcessor.getParallKey(), "03"});
                            }
                        } else if (name.equals("BatteryType")) {
                            if (value.equals("AGM")) {
                                result = currentProcessor.executeControl("setBatteryType", new Object[]{"00"});
                            } else if (value.equals("Flooded")) {
                                result = currentProcessor.executeControl("setBatteryType", new Object[]{"01"});
                            } else if (value.equals("User")) {
                                result = currentProcessor.executeControl("setBatteryType", new Object[]{"02"});
                            }
                        } else if (name.equals("OutputSource")) {
                            if (value.equals("Utility")) {
                                result = currentProcessor.executeControl("setOutputSource", new Object[]{"00"});
                            } else if (value.equals("Solar")) {
                                result = currentProcessor.executeControl("setOutputSource", new Object[]{"01"});
                            } else if (value.equals("SBU")) {
                                result = currentProcessor.executeControl("setOutputSource", new Object[]{"02"});
                            }
                        } else if (name.equals("ACInputRange")) {
                            if (value.equals("Appliance") || value.equals("APL range")) {
                                result = currentProcessor.executeControl("setGridWorkRange", new Object[]{"00"});
                            } else if (value.equals("UPS")) {
                                result = currentProcessor.executeControl("setGridWorkRange", new Object[]{"01"});
                            } else if (value.equals("Parallel 1")) {
                                result = currentProcessor.executeControl("setGridWorkRange", new Object[]{"02"});
                            } else if (value.equals("Parallel 2")) {
                                result = currentProcessor.executeControl("setGridWorkRange", new Object[]{"03"});
                            }
                        } else if (name.equals("OutputFrequency")) {
                            result = currentProcessor.executeControl("setOutputFrequency", new Object[]{VolUtil.parseInt(value)});
                        } else if (name.equals("BypassFunction")) {
                            if (value.equals("Forbidden")) {
                                result = currentProcessor.executeControl("setBypassFunction", new Object[]{0});
                            } else if (value.equals("Disable")) {
                                result = currentProcessor.executeControl("setBypassFunction", new Object[]{1});
                            } else if (value.equals("Enable")) {
                                result = currentProcessor.executeControl("setBypassFunction", new Object[]{2});
                            }
                        } else if (name.equals("OperationLogic")) {
                            if (value.equals("Automatically(AUT)")) {
                                result = currentProcessor.executeControl("setOperationLogic", new Object[]{0});
                            } else if (value.equals("Online mode(ONL)")) {
                                result = currentProcessor.executeControl("setOperationLogic", new Object[]{1});
                            } else if (value.equals("ECO Mode(ECO)")) {
                                result = currentProcessor.executeControl("setOperationLogic", new Object[]{2});
                            }
                        } else if (name.equals("OutputVoltage")) {
                            result = currentProcessor.executeControl("setOutputVoltage", new Object[]{VolUtil.parseInt(value)});
                        } else if (name.equals("setPOPV")) {
                            result = currentProcessor.executeControl("setPOPV", new Object[]{VolUtil.parseInt(value)});
                        } else if (name.equals("MaxChargeVoltage")) {
                            result = currentProcessor.executeControl("setMaxChargingVoltage", new Object[]{VolUtil.round(VolUtil.parseDouble(value), 1)});
                        } else if (name.equals("ReChargeVoltage")) {
                            result = currentProcessor.executeControl("setRechargingVol", new Object[]{VolUtil.round(VolUtil.parseDouble(value), 1)});
                        } else if (name.equalsIgnoreCase("ReDisChargeVoltage")) {
                            result = currentProcessor.executeControl("setReDisChargeVoltage", new Object[]{VolUtil.round(VolUtil.parseDouble(value), 1)});
                        } else if (name.equals("OutputMode")) {
                            result = currentProcessor.executeControl("setOutputMode", new Object[]{currentProcessor.getParallKey(), value2.getSelectedIndex()});
                        } else if (name.equals("PMaxChargeCurrent")) {
                            result = currentProcessor.executeControl("setPMaxChargingCurrent", new Object[]{currentProcessor.getParallKey(), VolUtil.parseInt(value)});
                        } else if (name.equals("NPMaxChargeCurrent")) {
                            result = currentProcessor.executeControl("setNPMaxChargingCurrent", new Object[]{currentProcessor.getParallKey(), VolUtil.parseInt(value)});
                        } else if (name.equals("VNPMaxChargeCurrent")) {
                            result = currentProcessor.executeControl("setVNPMaxChargingCurrent", new Object[]{VolUtil.parseInt(value)});
                        } else if (name.equals("PMaxACChargeCurrent")) {
                            result = currentProcessor.executeControl("setPMaxACChargeCurrent", new Object[]{currentProcessor.getParallKey(), VolUtil.parseInt(value)});
                        } else if (name.equals("VPMaxACChargeCurrent")) {
                            result = currentProcessor.executeControl("setVPMaxACChargeCurrent", new Object[]{VolUtil.parseInt(value)});
                        } else if (name.equals("MSCHGC")) {
                            result = currentProcessor.executeControl("setMSCHGC", new Object[]{value});
                        } else if (name.equals("PCST")) {
                            result = currentProcessor.executeControl("setPCST", new Object[]{value});
                        } else if (name.equals("PCVT")) {
                            result = currentProcessor.executeControl("setPCVT", new Object[]{value});
                        } else if (name.equals("BatReDischargeCapacity")) {
                            result = currentProcessor.executeControl("setBatReDischargeCapacity", new Object[]{VolUtil.round(VolUtil.parseDouble(value), 1)});
                        }
                        if (result) {
                            DisplayMessage.showInfoDialog("message.setTrue");
                        } else {
                            DisplayMessage.showErrorDialog("message.setFalse");
                        }
                        button2.setEnabled(true);
                    }
                }
            });
            p5.addComponent(caption2);
            p6.addComponent(value2, 100, 200, 200);
            p7.addComponent(unit2);
            p8.addComponent(button2);
            vGroup2.addGroup(layout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(caption2).addComponent(value2).addComponent(unit2).addComponent(button2));
            vGroup2.addGap(15, 15, 15);
            ++j;
        }
        hGroup2.addGap(20, 20, 20);
        hGroup2.addGroup(p5);
        hGroup2.addGroup(p6);
        hGroup2.addGroup(p7);
        hGroup2.addGroup(p8);
        hGroup2.addGap(40, 40, 40);
        layout2.setHorizontalGroup(hGroup2);
        layout2.setVerticalGroup(vGroup2);
        panel.add((Component)leftPanel, "Center");
        panel.add((Component)rightPanel, "East");
    }

    public static void setRadioLayout(List<AutoRadioItem> list, JPanel panel, Object object) {
        panel.setLayout(new BorderLayout());
        int index = 2;
        index = list.size() % 2 == 0 ? list.size() / 2 : list.size() / 2 + 1;
        JPanel leftPanel = new JPanel();
        JPanel rightPanel = new JPanel();
        GroupLayout layout = new GroupLayout(leftPanel);
        leftPanel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        GroupLayout.SequentialGroup hGroup = layout.createSequentialGroup();
        GroupLayout.SequentialGroup vGroup = layout.createSequentialGroup();
        GroupLayout.ParallelGroup p1 = layout.createParallelGroup(GroupLayout.Alignment.TRAILING);
        GroupLayout.ParallelGroup p2 = layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        GroupLayout.ParallelGroup p3 = layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        GroupLayout.ParallelGroup p4 = layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        int i = 0;
        while (i < index) {
            AALabel caption1 = new AALabel();
            final AARadioButton valueLabel1 = new AARadioButton();
            final AARadioButton valueLabel2 = new AARadioButton();
            final AAButton button1 = new AAButton();
            button1.setEnabled(list.get(i).isEnable());
            caption1.setText(list.get(i).getCaption());
            valueLabel1.setText(list.get(i).getRadioLabel1());
            valueLabel2.setText(list.get(i).getRadioLabel2());
            boolean value1 = VolUtil.parseBoolean(PageUtils.getResultByName(list.get(i).getValue(), object));
            if (value1) {
                valueLabel1.setSelected(true);
                valueLabel2.setSelected(false);
            } else {
                valueLabel1.setSelected(false);
                valueLabel2.setSelected(true);
            }
            valueLabel1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    valueLabel1.setSelected(true);
                    valueLabel2.setSelected(false);
                    button1.setEnabled(true);
                }
            });
            valueLabel2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    valueLabel1.setSelected(false);
                    valueLabel2.setSelected(true);
                    button1.setEnabled(true);
                }
            });
            button1.setText("message.apply");
            button1.setName(list.get(i).getButtonName());
            button1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!SolarPowerTray.isLogin) {
                        new LoginJDialog(new Frame(), true);
                        return;
                    }
                    AbstractProcessor currentProcessor = GlobalProcessors.getCurrentProcessor();
                    if (currentProcessor != null) {
                        button1.setEnabled(false);
                        String name = button1.getName();
                        boolean result = false;
                        if (name.equals("CapableA")) {
                            if (valueLabel1.isSelected()) {
                                result = currentProcessor.executeControl("setCapability", new Object[]{"a", true});
                            } else if (valueLabel2.isSelected()) {
                                result = currentProcessor.executeControl("setCapability", new Object[]{"a", false});
                            }
                        } else if (name.equals("CapableB")) {
                            if (valueLabel1.isSelected()) {
                                result = currentProcessor.executeControl("setCapability", new Object[]{"b", true});
                            } else if (valueLabel2.isSelected()) {
                                result = currentProcessor.executeControl("setCapability", new Object[]{"b", false});
                            }
                        } else if (name.equals("CapableECO")) {
                            if (valueLabel1.isSelected()) {
                                result = currentProcessor.executeControl("setECO", new Object[]{"1"});
                            } else if (valueLabel2.isSelected()) {
                                result = currentProcessor.executeControl("setECO", new Object[]{"0"});
                            }
                        } else if (name.equals("CapableK")) {
                            if (valueLabel1.isSelected()) {
                                result = currentProcessor.executeControl("setCapability", new Object[]{"k", true});
                            } else if (valueLabel2.isSelected()) {
                                result = currentProcessor.executeControl("setCapability", new Object[]{"k", false});
                            }
                        } else if (name.equals("CapableP")) {
                            if (valueLabel1.isSelected()) {
                                result = currentProcessor.executeControl("setCapability", new Object[]{"p", true});
                            } else if (valueLabel2.isSelected()) {
                                result = currentProcessor.executeControl("setCapability", new Object[]{"p", false});
                            }
                        } else if (name.equals("CapableG")) {
                            if (valueLabel1.isSelected()) {
                                result = currentProcessor.executeControl("setCapability", new Object[]{"g", true});
                            } else if (valueLabel2.isSelected()) {
                                result = currentProcessor.executeControl("setCapability", new Object[]{"g", false});
                            }
                        } else if (name.equals("CapableJ")) {
                            if (valueLabel1.isSelected()) {
                                result = currentProcessor.executeControl("setCapability", new Object[]{"j", true});
                            } else if (valueLabel2.isSelected()) {
                                result = currentProcessor.executeControl("setCapability", new Object[]{"j", false});
                            }
                        } else if (name.equals("CapableU")) {
                            if (valueLabel1.isSelected()) {
                                result = currentProcessor.executeControl("setCapability", new Object[]{"u", true});
                            } else if (valueLabel2.isSelected()) {
                                result = currentProcessor.executeControl("setCapability", new Object[]{"u", false});
                            }
                        } else if (name.equals("CapableV")) {
                            if (valueLabel1.isSelected()) {
                                result = currentProcessor.executeControl("setCapability", new Object[]{"v", true});
                            } else if (valueLabel2.isSelected()) {
                                result = currentProcessor.executeControl("setCapability", new Object[]{"v", false});
                            }
                        } else if (name.equals("CapableW")) {
                            if (valueLabel1.isSelected()) {
                                result = currentProcessor.executeControl("setCapability", new Object[]{"w", true});
                            } else if (valueLabel2.isSelected()) {
                                result = currentProcessor.executeControl("setCapability", new Object[]{"w", false});
                            }
                        } else if (name.equals("CapableX")) {
                            if (valueLabel1.isSelected()) {
                                result = currentProcessor.executeControl("setCapability", new Object[]{"x", true});
                            } else if (valueLabel2.isSelected()) {
                                result = currentProcessor.executeControl("setCapability", new Object[]{"x", false});
                            }
                        } else if (name.equals("CapableY")) {
                            if (valueLabel1.isSelected()) {
                                result = currentProcessor.executeControl("setCapability", new Object[]{"y", true});
                            } else if (valueLabel2.isSelected()) {
                                result = currentProcessor.executeControl("setCapability", new Object[]{"y", false});
                            }
                        } else if (name.equals("CapableZ")) {
                            if (valueLabel1.isSelected()) {
                                result = currentProcessor.executeControl("setCapability", new Object[]{"z", true});
                            } else if (valueLabel2.isSelected()) {
                                result = currentProcessor.executeControl("setCapability", new Object[]{"z", false});
                            }
                        } else if (name.equals("CapableL")) {
                            if (valueLabel1.isSelected()) {
                                result = currentProcessor.executeControl("setCapability", new Object[]{"l", true});
                            } else if (valueLabel2.isSelected()) {
                                result = currentProcessor.executeControl("setCapability", new Object[]{"l", false});
                            }
                        } else if (name.equals("CapabelePDG")) {
                            if (valueLabel1.isSelected()) {
                                result = currentProcessor.executeControl("setPowerFactorLine", new Object[]{1});
                            } else if (valueLabel2.isSelected()) {
                                result = currentProcessor.executeControl("setPowerFactorLine", new Object[]{0});
                            }
                        } else if (name.equals("setPPVOKC")) {
                            if (valueLabel1.isSelected()) {
                                result = currentProcessor.executeControl("setPPVOKC", new Object[]{1});
                            } else if (valueLabel2.isSelected()) {
                                result = currentProcessor.executeControl("setPPVOKC", new Object[]{0});
                            }
                        } else if (name.equals("setPSPB")) {
                            if (valueLabel1.isSelected()) {
                                result = currentProcessor.executeControl("setPSPB", new Object[]{1});
                            } else if (valueLabel2.isSelected()) {
                                result = currentProcessor.executeControl("setPSPB", new Object[]{0});
                            }
                        } else if (name.equals("setPBEQA")) {
                            if (valueLabel1.isSelected()) {
                                result = currentProcessor.executeControl("setPBEQA", new Object[]{1});
                            } else if (valueLabel2.isSelected()) {
                                result = currentProcessor.executeControl("setPBEQA", new Object[]{0});
                            }
                        } else if (name.equals("setPBEQE")) {
                            if (valueLabel1.isSelected()) {
                                result = currentProcessor.executeControl("setPBEQE", new Object[]{1});
                            } else if (valueLabel2.isSelected()) {
                                result = currentProcessor.executeControl("setPBEQE", new Object[]{0});
                            }
                        } else if (name.equals("setLBF")) {
                            if (valueLabel1.isSelected()) {
                                result = currentProcessor.executeControl("setLBF", new Object[]{1});
                            } else if (valueLabel2.isSelected()) {
                                result = currentProcessor.executeControl("setLBF", new Object[]{0});
                            }
                        }
                        if (result) {
                            DisplayMessage.showInfoDialog("message.setTrue");
                        } else {
                            DisplayMessage.showErrorDialog("message.setFalse");
                        }
                        button1.setEnabled(true);
                    }
                }
            });
            p1.addComponent(caption1);
            p2.addComponent(valueLabel1);
            p3.addComponent(valueLabel2);
            p4.addComponent(button1);
            vGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(caption1).addComponent(valueLabel1).addComponent(valueLabel2).addComponent(button1));
            vGroup.addGap(15, 15, 15);
            ++i;
        }
        hGroup.addGap(40, 40, 40);
        hGroup.addGroup(p1);
        hGroup.addGroup(p2);
        hGroup.addGroup(p3);
        hGroup.addGroup(p4);
        hGroup.addGap(20, 20, 20);
        layout.setHorizontalGroup(hGroup);
        layout.setVerticalGroup(vGroup);
        GroupLayout layout2 = new GroupLayout(rightPanel);
        rightPanel.setLayout(layout2);
        layout2.setAutoCreateGaps(true);
        layout2.setAutoCreateContainerGaps(true);
        GroupLayout.SequentialGroup hGroup2 = layout2.createSequentialGroup();
        GroupLayout.SequentialGroup vGroup2 = layout2.createSequentialGroup();
        GroupLayout.ParallelGroup p5 = layout2.createParallelGroup(GroupLayout.Alignment.TRAILING);
        GroupLayout.ParallelGroup p6 = layout2.createParallelGroup(GroupLayout.Alignment.LEADING);
        GroupLayout.ParallelGroup p7 = layout2.createParallelGroup(GroupLayout.Alignment.LEADING);
        GroupLayout.ParallelGroup p8 = layout2.createParallelGroup(GroupLayout.Alignment.LEADING);
        int j = index;
        while (j < list.size()) {
            AALabel caption2 = new AALabel();
            final AARadioButton valueLabel3 = new AARadioButton();
            final AARadioButton valueLabel4 = new AARadioButton();
            final AAButton button2 = new AAButton();
            button2.setEnabled(list.get(j).isEnable());
            caption2.setText(list.get(j).getCaption());
            valueLabel3.setText(list.get(j).getRadioLabel1());
            valueLabel4.setText(list.get(j).getRadioLabel2());
            boolean value2 = VolUtil.parseBoolean(PageUtils.getResultByName(list.get(j).getValue(), object));
            if (value2) {
                valueLabel3.setSelected(true);
                valueLabel4.setSelected(false);
            } else {
                valueLabel3.setSelected(false);
                valueLabel4.setSelected(true);
            }
            valueLabel3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    valueLabel3.setSelected(true);
                    valueLabel4.setSelected(false);
                    button2.setEnabled(true);
                }
            });
            valueLabel4.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    valueLabel3.setSelected(false);
                    valueLabel4.setSelected(true);
                    button2.setEnabled(true);
                }
            });
            button2.setText("message.apply");
            button2.setName(list.get(j).getButtonName());
            button2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!SolarPowerTray.isLogin) {
                        new LoginJDialog(new Frame(), true);
                        return;
                    }
                    AbstractProcessor currentProcessor = GlobalProcessors.getCurrentProcessor();
                    if (currentProcessor != null) {
                        button2.setEnabled(false);
                        String name = button2.getName();
                        boolean result = false;
                        if (name.equals("CapableA")) {
                            if (valueLabel3.isSelected()) {
                                result = currentProcessor.executeControl("setCapability", new Object[]{"a", true});
                            } else if (valueLabel4.isSelected()) {
                                result = currentProcessor.executeControl("setCapability", new Object[]{"a", false});
                            }
                        } else if (name.equals("CapableB")) {
                            if (valueLabel3.isSelected()) {
                                result = currentProcessor.executeControl("setCapability", new Object[]{"b", true});
                            } else if (valueLabel4.isSelected()) {
                                result = currentProcessor.executeControl("setCapability", new Object[]{"b", false});
                            }
                        } else if (name.equals("CapableECO")) {
                            if (valueLabel3.isSelected()) {
                                result = currentProcessor.executeControl("setECO", new Object[]{"1"});
                            } else if (valueLabel4.isSelected()) {
                                result = currentProcessor.executeControl("setECO", new Object[]{"0"});
                            }
                        } else if (name.equals("CapableK")) {
                            if (valueLabel3.isSelected()) {
                                result = currentProcessor.executeControl("setCapability", new Object[]{"k", true});
                            } else if (valueLabel4.isSelected()) {
                                result = currentProcessor.executeControl("setCapability", new Object[]{"k", false});
                            }
                        } else if (name.equals("CapableP")) {
                            if (valueLabel3.isSelected()) {
                                result = currentProcessor.executeControl("setCapability", new Object[]{"p", true});
                            } else if (valueLabel4.isSelected()) {
                                result = currentProcessor.executeControl("setCapability", new Object[]{"p", false});
                            }
                        } else if (name.equals("CapableG")) {
                            if (valueLabel3.isSelected()) {
                                result = currentProcessor.executeControl("setCapability", new Object[]{"g", true});
                            } else if (valueLabel4.isSelected()) {
                                result = currentProcessor.executeControl("setCapability", new Object[]{"g", false});
                            }
                        } else if (name.equals("CapableJ")) {
                            if (valueLabel3.isSelected()) {
                                result = currentProcessor.executeControl("setCapability", new Object[]{"j", true});
                            } else if (valueLabel4.isSelected()) {
                                result = currentProcessor.executeControl("setCapability", new Object[]{"j", false});
                            }
                        } else if (name.equals("CapableU")) {
                            if (valueLabel3.isSelected()) {
                                result = currentProcessor.executeControl("setCapability", new Object[]{"u", true});
                            } else if (valueLabel4.isSelected()) {
                                result = currentProcessor.executeControl("setCapability", new Object[]{"u", false});
                            }
                        } else if (name.equals("CapableV")) {
                            if (valueLabel3.isSelected()) {
                                result = currentProcessor.executeControl("setCapability", new Object[]{"v", true});
                            } else if (valueLabel4.isSelected()) {
                                result = currentProcessor.executeControl("setCapability", new Object[]{"v", false});
                            }
                        } else if (name.equals("CapableW")) {
                            if (valueLabel3.isSelected()) {
                                result = currentProcessor.executeControl("setCapability", new Object[]{"w", true});
                            } else if (valueLabel4.isSelected()) {
                                result = currentProcessor.executeControl("setCapability", new Object[]{"w", false});
                            }
                        } else if (name.equals("CapableX")) {
                            if (valueLabel3.isSelected()) {
                                result = currentProcessor.executeControl("setCapability", new Object[]{"x", true});
                            } else if (valueLabel4.isSelected()) {
                                result = currentProcessor.executeControl("setCapability", new Object[]{"x", false});
                            }
                        } else if (name.equals("CapableY")) {
                            if (valueLabel3.isSelected()) {
                                result = currentProcessor.executeControl("setCapability", new Object[]{"y", true});
                            } else if (valueLabel4.isSelected()) {
                                result = currentProcessor.executeControl("setCapability", new Object[]{"y", false});
                            }
                        } else if (name.equals("CapableZ")) {
                            if (valueLabel3.isSelected()) {
                                result = currentProcessor.executeControl("setCapability", new Object[]{"z", true});
                            } else if (valueLabel4.isSelected()) {
                                result = currentProcessor.executeControl("setCapability", new Object[]{"z", false});
                            }
                        } else if (name.equals("CapableL")) {
                            if (valueLabel3.isSelected()) {
                                result = currentProcessor.executeControl("setCapability", new Object[]{"l", true});
                            } else if (valueLabel4.isSelected()) {
                                result = currentProcessor.executeControl("setCapability", new Object[]{"l", false});
                            }
                        } else if (name.equals("CapabelePDG")) {
                            if (valueLabel3.isSelected()) {
                                result = currentProcessor.executeControl("setPowerFactorLine", new Object[]{1});
                            } else if (valueLabel4.isSelected()) {
                                result = currentProcessor.executeControl("setPowerFactorLine", new Object[]{0});
                            }
                        } else if (name.equals("setPPVOKC")) {
                            if (valueLabel3.isSelected()) {
                                result = currentProcessor.executeControl("setPPVOKC", new Object[]{1});
                            } else if (valueLabel4.isSelected()) {
                                result = currentProcessor.executeControl("setPPVOKC", new Object[]{0});
                            }
                        } else if (name.equals("setPSPB")) {
                            if (valueLabel3.isSelected()) {
                                result = currentProcessor.executeControl("setPSPB", new Object[]{1});
                            } else if (valueLabel4.isSelected()) {
                                result = currentProcessor.executeControl("setPSPB", new Object[]{0});
                            }
                        } else if (name.equals("setPBEQA")) {
                            if (valueLabel3.isSelected()) {
                                result = currentProcessor.executeControl("setPBEQA", new Object[]{1});
                            } else if (valueLabel4.isSelected()) {
                                result = currentProcessor.executeControl("setPBEQA", new Object[]{0});
                            }
                        } else if (name.equals("setPBEQE")) {
                            if (valueLabel3.isSelected()) {
                                result = currentProcessor.executeControl("setPBEQE", new Object[]{1});
                            } else if (valueLabel4.isSelected()) {
                                result = currentProcessor.executeControl("setPBEQE", new Object[]{0});
                            }
                        } else if (name.equals("setLBF")) {
                            if (valueLabel3.isSelected()) {
                                result = currentProcessor.executeControl("setLBF", new Object[]{1});
                            } else if (valueLabel4.isSelected()) {
                                result = currentProcessor.executeControl("setLBF", new Object[]{0});
                            }
                        }
                        if (result) {
                            DisplayMessage.showInfoDialog("message.setTrue");
                        } else {
                            DisplayMessage.showErrorDialog("message.setFalse");
                        }
                        button2.setEnabled(true);
                    }
                }
            });
            p5.addComponent(caption2);
            p6.addComponent(valueLabel3);
            p7.addComponent(valueLabel4);
            p8.addComponent(button2);
            vGroup2.addGroup(layout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(caption2).addComponent(valueLabel3).addComponent(valueLabel4).addComponent(button2));
            vGroup2.addGap(15, 15, 15);
            ++j;
        }
        hGroup2.addGap(20, 20, 20);
        hGroup2.addGroup(p5);
        hGroup2.addGroup(p6);
        hGroup2.addGroup(p7);
        hGroup2.addGroup(p8);
        hGroup2.addGap(40, 40, 40);
        layout2.setHorizontalGroup(hGroup2);
        layout2.setVerticalGroup(vGroup2);
        panel.add((Component)leftPanel, "Center");
        panel.add((Component)rightPanel, "East");
    }

    public static List<RefreshProductInfo> setInfoLayout(List<AutoLabelItem> list, JPanel panel, Object object) {
        ArrayList<RefreshProductInfo> valueList = new ArrayList<RefreshProductInfo>();
        panel.setLayout(new BorderLayout());
        int index = list.size();
        JPanel leftPanel = new JPanel();
        GroupLayout layout = new GroupLayout(leftPanel);
        leftPanel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        GroupLayout.SequentialGroup hGroup = layout.createSequentialGroup();
        GroupLayout.SequentialGroup vGroup = layout.createSequentialGroup();
        GroupLayout.ParallelGroup p1 = layout.createParallelGroup(GroupLayout.Alignment.TRAILING);
        GroupLayout.ParallelGroup p2 = layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        GroupLayout.ParallelGroup p3 = layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        int i = 0;
        while (i < index) {
            AALabel caption1 = new AALabel();
            JTextField value1 = new JTextField();
            value1.setEditable(false);
            value1.setFont(I18NListener.font12);
            value1.setBackground(I18NListener.bgColor);
            AALabel unit1 = new AALabel();
            caption1.setText(list.get(i).getCaption());
            value1.setText(PageUtils.getResultByName(list.get(i).getValue(), object));
            unit1.setText(list.get(i).getUnit());
            valueList.add(new RefreshProductInfo(value1, list.get(i).getValue()));
            p1.addComponent(caption1);
            p2.addComponent(value1);
            p3.addComponent(unit1);
            vGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(caption1).addComponent(value1).addComponent(unit1));
            vGroup.addGap(15, 15, 15);
            ++i;
        }
        hGroup.addGap(55, 55, 55);
        hGroup.addGroup(p1);
        hGroup.addGroup(p2);
        hGroup.addGroup(p3);
        hGroup.addGap(55, 55, 55);
        layout.setHorizontalGroup(hGroup);
        layout.setVerticalGroup(vGroup);
        panel.add((Component)leftPanel, "Center");
        return valueList;
    }

    public static List<RefreshRatingInfo> setTextLayout(List<AutoLabelItem> list, JPanel panel, Object object) {
        ArrayList<RefreshRatingInfo> productList = new ArrayList<RefreshRatingInfo>();
        panel.setLayout(new BorderLayout());
        int index = 2;
        index = list.size() % 2 == 0 ? list.size() / 2 : list.size() / 2 + 1;
        JPanel leftPanel = new JPanel();
        JPanel rightPanel = new JPanel();
        GroupLayout layout = new GroupLayout(leftPanel);
        leftPanel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        GroupLayout.SequentialGroup hGroup = layout.createSequentialGroup();
        GroupLayout.SequentialGroup vGroup = layout.createSequentialGroup();
        GroupLayout.ParallelGroup p1 = layout.createParallelGroup(GroupLayout.Alignment.TRAILING);
        GroupLayout.ParallelGroup p2 = layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        GroupLayout.ParallelGroup p3 = layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        int i = 0;
        while (i < index) {
            AALabel caption1 = new AALabel();
            AATextField value1 = new AATextField();
            AALabel unit1 = new AALabel();
            caption1.setText(list.get(i).getCaption());
            value1.setText(PageUtils.getResultByName(list.get(i).getValue(), object));
            unit1.setText(list.get(i).getUnit());
            productList.add(new RefreshRatingInfo(value1, list.get(i).getValue()));
            p1.addComponent(caption1);
            p2.addComponent(value1, 50, 50, 50);
            p3.addComponent(unit1);
            vGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(caption1).addComponent(value1).addComponent(unit1));
            vGroup.addGap(15, 15, 15);
            ++i;
        }
        hGroup.addGap(15, 15, 15);
        hGroup.addGroup(p1);
        hGroup.addGroup(p2);
        hGroup.addGroup(p3);
        hGroup.addGap(15, 15, 15);
        layout.setHorizontalGroup(hGroup);
        layout.setVerticalGroup(vGroup);
        GroupLayout layout2 = new GroupLayout(rightPanel);
        rightPanel.setLayout(layout2);
        layout2.setAutoCreateGaps(true);
        layout2.setAutoCreateContainerGaps(true);
        GroupLayout.SequentialGroup hGroup2 = layout2.createSequentialGroup();
        GroupLayout.SequentialGroup vGroup2 = layout2.createSequentialGroup();
        GroupLayout.ParallelGroup p4 = layout2.createParallelGroup(GroupLayout.Alignment.TRAILING);
        GroupLayout.ParallelGroup p5 = layout2.createParallelGroup(GroupLayout.Alignment.LEADING);
        GroupLayout.ParallelGroup p6 = layout2.createParallelGroup(GroupLayout.Alignment.LEADING);
        int j = index;
        while (j < list.size()) {
            AALabel caption2 = new AALabel();
            AATextField value2 = new AATextField();
            AALabel unit2 = new AALabel();
            caption2.setText(list.get(j).getCaption());
            value2.setText(PageUtils.getResultByName(list.get(j).getValue(), object));
            unit2.setText(list.get(j).getUnit());
            productList.add(new RefreshRatingInfo(value2, list.get(j).getValue()));
            p4.addComponent(caption2);
            p5.addComponent(value2, 50, 50, 50);
            p6.addComponent(unit2);
            vGroup2.addGroup(layout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(caption2).addComponent(value2).addComponent(unit2));
            vGroup2.addGap(15, 15, 15);
            ++j;
        }
        hGroup2.addGap(15, 15, 15);
        hGroup2.addGroup(p4);
        hGroup2.addGroup(p5);
        hGroup2.addGroup(p6);
        hGroup2.addGap(15, 15, 15);
        layout2.setHorizontalGroup(hGroup2);
        layout2.setVerticalGroup(vGroup2);
        panel.add((Component)leftPanel, "Center");
        panel.add((Component)rightPanel, "East");
        return productList;
    }

    public static List<RefreshRatingInfo> setRestoreTextLayout(List<AutoLabelItem> list, JPanel panel, Object object) {
        ArrayList<RefreshRatingInfo> productList = new ArrayList<RefreshRatingInfo>();
        panel.setLayout(new BorderLayout());
        int index = 2;
        index = list.size() % 2 == 0 ? list.size() / 2 : list.size() / 2 + 1;
        JPanel leftPanel = new JPanel();
        JPanel rightPanel = new JPanel();
        GroupLayout layout = new GroupLayout(leftPanel);
        leftPanel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        GroupLayout.SequentialGroup hGroup = layout.createSequentialGroup();
        GroupLayout.SequentialGroup vGroup = layout.createSequentialGroup();
        GroupLayout.ParallelGroup p1 = layout.createParallelGroup(GroupLayout.Alignment.TRAILING);
        GroupLayout.ParallelGroup p2 = layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        GroupLayout.ParallelGroup p3 = layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        int i = 0;
        while (i < index) {
            AALabel caption1 = new AALabel();
            AATextField value1 = new AATextField();
            AALabel unit1 = new AALabel();
            caption1.setText(list.get(i).getCaption());
            value1.setText(PageUtils.getResultByName(list.get(i).getValue(), object));
            unit1.setText(list.get(i).getUnit());
            productList.add(new RefreshRatingInfo(value1, list.get(i).getValue()));
            p1.addComponent(caption1);
            p2.addComponent(value1, 100, 100, 100);
            p3.addComponent(unit1);
            vGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(caption1).addComponent(value1).addComponent(unit1));
            vGroup.addGap(15, 15, 15);
            ++i;
        }
        hGroup.addGap(15, 15, 15);
        hGroup.addGroup(p1);
        hGroup.addGroup(p2);
        hGroup.addGroup(p3);
        hGroup.addGap(15, 15, 15);
        layout.setHorizontalGroup(hGroup);
        layout.setVerticalGroup(vGroup);
        GroupLayout layout2 = new GroupLayout(rightPanel);
        rightPanel.setLayout(layout2);
        layout2.setAutoCreateGaps(true);
        layout2.setAutoCreateContainerGaps(true);
        GroupLayout.SequentialGroup hGroup2 = layout2.createSequentialGroup();
        GroupLayout.SequentialGroup vGroup2 = layout2.createSequentialGroup();
        GroupLayout.ParallelGroup p4 = layout2.createParallelGroup(GroupLayout.Alignment.TRAILING);
        GroupLayout.ParallelGroup p5 = layout2.createParallelGroup(GroupLayout.Alignment.LEADING);
        GroupLayout.ParallelGroup p6 = layout2.createParallelGroup(GroupLayout.Alignment.LEADING);
        int j = index;
        while (j < list.size()) {
            AALabel caption2 = new AALabel();
            AATextField value2 = new AATextField();
            AALabel unit2 = new AALabel();
            caption2.setText(list.get(j).getCaption());
            value2.setText(PageUtils.getResultByName(list.get(j).getValue(), object));
            unit2.setText(list.get(j).getUnit());
            productList.add(new RefreshRatingInfo(value2, list.get(j).getValue()));
            p4.addComponent(caption2);
            p5.addComponent(value2, 100, 100, 100);
            p6.addComponent(unit2);
            vGroup2.addGroup(layout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(caption2).addComponent(value2).addComponent(unit2));
            vGroup2.addGap(15, 15, 15);
            ++j;
        }
        hGroup2.addGap(15, 15, 15);
        hGroup2.addGroup(p4);
        hGroup2.addGroup(p5);
        hGroup2.addGroup(p6);
        hGroup2.addGap(15, 15, 15);
        layout2.setHorizontalGroup(hGroup2);
        layout2.setVerticalGroup(vGroup2);
        panel.add((Component)leftPanel, "Center");
        panel.add((Component)rightPanel, "East");
        return productList;
    }
}

