/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.view;

import cn.com.voltronic.solar.constants.Constants;
import cn.com.voltronic.solar.dao.DeviceDao;
import cn.com.voltronic.solar.dao.WorkDataDao;
import cn.com.voltronic.solar.data.bean.DeviceBean;
import cn.com.voltronic.solar.data.bean.HistoryChart;
import cn.com.voltronic.solar.data.bean.HistoryDataChartColumns;
import cn.com.voltronic.solar.data.bean.WorkInfo;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.protocol.IProtocol;
import cn.com.voltronic.solar.protocol.P30;
import cn.com.voltronic.solar.protocol.P301TO3KW;
import cn.com.voltronic.solar.protocol.P304TO5KW;
import cn.com.voltronic.solar.protocol.P30EPS;
import cn.com.voltronic.solar.protocol.P30EPSM5K;
import cn.com.voltronic.solar.protocol.P30LY;
import cn.com.voltronic.solar.protocol.P30Paral;
import cn.com.voltronic.solar.protocol.P30PlusDuo;
import cn.com.voltronic.solar.protocol.P30PlusTri;
import cn.com.voltronic.solar.protocol.P30V;
import cn.com.voltronic.solar.system.GlobalProcessors;
import cn.com.voltronic.solar.system.GlobalVariables;
import cn.com.voltronic.solar.util.DateUtils;
import cn.com.voltronic.solar.util.PageUtils;
import cn.com.voltronic.solar.util.VolUtil;
import cn.com.voltronic.solar.view.component.AAButton;
import cn.com.voltronic.solar.view.component.AAComboBox;
import cn.com.voltronic.solar.view.component.AALabel;
import cn.com.voltronic.solar.view.component.AAPanel;
import cn.com.voltronic.solar.view.component.AATabbedPane;
import cn.com.voltronic.solar.view.component.ComponentFactory;
import cn.com.voltronic.solar.view.component.I18NListener;
import cn.com.voltronic.solar.view.component.MyCalendarPanel;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.apache.commons.lang.StringUtils;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickUnit;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYStepRenderer;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Minute;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class HistoryDataChart
extends AAPanel {
    private static final long serialVersionUID = 5818569474311920793L;
    public AAButton closeChartButton;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private AALabel deviceLabel2;
    private JComboBox jComboBox2;
    private AAComboBox jComboBox3;
    private AAComboBox periodComboBox;
    private AALabel maohaoLabel;
    private AALabel periodLabel;
    private AALabel jLabel6;
    private AALabel jLabel7;
    private JScrollPane jScrollPane2;
    private AATabbedPane jTabbedPane1;
    private JSpinner jSpinner1;
    private JSpinner jSpinner2;
    private JTextField jTextField3;
    private AAButton queryChartButton;
    private WorkDataDao workDao = new WorkDataDao();
    private DeviceDao deviceDao = new DeviceDao();
    private IProtocol protocol = new P30();
    public WorkInfo workInfo = new WorkInfo();

    public HistoryDataChart() {
        String serialno;
        this.initComponents();
        AbstractProcessor processor = GlobalProcessors.getCurrentProcessor();
        if (processor != null && !StringUtils.isEmpty((String)(serialno = processor.getSerialNo().trim()))) {
            this.jComboBox2.setSelectedItem(serialno);
        }
    }

    private void initComponents() {
        this.jLabel6 = new AALabel();
        this.jLabel7 = new AALabel();
        this.jTextField3 = new JTextField();
        this.jPanel1 = new JPanel();
        this.deviceLabel2 = new AALabel();
        this.jComboBox2 = new JComboBox();
        this.jComboBox3 = new AAComboBox();
        this.periodLabel = new AALabel();
        this.queryChartButton = new AAButton();
        this.periodComboBox = new AAComboBox();
        this.jTabbedPane1 = new AATabbedPane();
        this.maohaoLabel = new AALabel();
        this.jSpinner1 = ComponentFactory.createNumberSpinner(2010, DateUtils.getCurrentYear() + 200, 1, DateUtils.getCurrentYear());
        this.jSpinner2 = ComponentFactory.createNumberSpinner(0, 23, 1, DateUtils.getCurrentHour());
        this.jScrollPane2 = new JScrollPane();
        this.jPanel2 = new JPanel();
        this.closeChartButton = new AAButton();
        this.setLayout(new BorderLayout());
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.deviceLabel2.setText("message.device[:]");
        this.jComboBox2.setModel(new DefaultComboBoxModel<String>(this.queryDevices()));
        this.periodLabel.setText("message.cycle[:]");
        this.jLabel6.setIcon(new ImageIcon(Constants.DATE));
        this.jLabel6.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MyCalendarPanel calendarPanel = new MyCalendarPanel(HistoryDataChart.this.jTextField3);
                calendarPanel.setBounds(HistoryDataChart.this.getX() + HistoryDataChart.this.jLabel6.getX() + 30, HistoryDataChart.this.getY() + HistoryDataChart.this.jLabel6.getY() + 10, calendarPanel.getWidth(), calendarPanel.getHeight());
                calendarPanel.setVisible(true);
            }
        });
        this.jTextField3.setEditable(false);
        this.jTextField3.setBackground(I18NListener.bgColor);
        this.jTextField3.setText(DateUtils.getNowDate());
        this.jTextField3.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MyCalendarPanel calendarPanel = new MyCalendarPanel(HistoryDataChart.this.jTextField3);
                calendarPanel.setBounds(HistoryDataChart.this.getX() + HistoryDataChart.this.jLabel6.getX() + 30, HistoryDataChart.this.getY() + HistoryDataChart.this.jLabel6.getY() + 10, calendarPanel.getWidth(), calendarPanel.getHeight());
                calendarPanel.setVisible(true);
            }
        });
        String[] monthArr = new String[]{"message.january", "message.february", "message.march", "message.april", "message.may", "message.june", "message.july", "message.august", "message.september", "message.october", "message.november", "message.december"};
        this.jComboBox3.setModel(monthArr);
        this.jLabel7.setText("message.hour");
        this.queryChartButton.setText("message.view");
        this.queryChartButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HistoryDataChart.this.queryChartAction();
            }
        });
        this.setDataChart("year");
        this.jTabbedPane1.setTabPlacement(2);
        this.jScrollPane2.setViewportView(this.jTabbedPane1);
        this.periodComboBox.setModel(new String[]{"message.year", "message.month", "message.day", "message.hour"});
        this.periodComboBox.setSelectedIndex(0);
        this.periodComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HistoryDataChart.this.setPeriod();
            }
        });
        this.setPeriod();
        this.maohaoLabel.setText(":");
        this.add((Component)this.jPanel1, "Center");
        this.jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.closeChartButton.setText("message.close");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap(950, Short.MAX_VALUE).addComponent(this.closeChartButton).addGap(12, 12, 12)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.closeChartButton).addContainerGap()));
        this.add((Component)this.jPanel2, "Last");
    }

    public String[] queryDevices() {
        List<String> devicelist = this.deviceDao.querySerialnoAll();
        String[] devices = new String[devicelist.size()];
        int i = 0;
        while (i < devicelist.size()) {
            devices[i] = devicelist.get(i);
            ++i;
        }
        return devices;
    }

    private void setDataChart(String mask) {
        DeviceBean bean = null;
        this.jTabbedPane1.removeAll();
        String serialno = "";
        if (this.jComboBox2.getSelectedItem() != null) {
            try {
                serialno = this.jComboBox2.getSelectedItem().toString().trim();
                bean = this.deviceDao.queryDevicebySerialno(serialno);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        int year = VolUtil.parseInt(this.jSpinner1.getValue().toString());
        int month = this.jComboBox3.getSelectedIndex() + 1;
        String dateStr = this.jTextField3.getText();
        SimpleDateFormat df = new SimpleDateFormat(GlobalVariables.globalConfig.getDateFormat());
        Date queryDate = new Date();
        try {
            queryDate = df.parse(dateStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Date day = queryDate;
        int hour = VolUtil.parseInt(this.jSpinner2.getValue().toString());
        if (bean == null) {
            this.protocol = new P30();
        } else {
            this.protocol = bean.getProdid().equals("P30") ? new P30() : (bean.getProdid().equals("P30PLUSDUO") ? new P30PlusDuo() : (bean.getProdid().equals("P30PLUSTRI") ? new P30PlusTri() : (bean.getProdid().equals("P301TO3KW") ? new P301TO3KW() : (bean.getProdid().equals("P304TO5KW") ? new P304TO5KW() : (bean.getProdid().equals("P30V") ? new P30V() : (bean.getProdid().equals("P30EPS") ? new P30EPS() : (bean.getProdid().equals("P30EPSM5K") ? new P30EPSM5K() : (bean.getProdid().equals("P30LY") ? new P30LY() : (bean.getProdid().equals("P30PARAL") ? new P30Paral() : new P30())))))))));
            this.protocol.setOutputMode(bean.getParallel());
            this.protocol.setMachineType(bean.getModetype());
        }
        List<Object> lists = new ArrayList();
        HistoryDataChartColumns data = this.protocol.getHistoryChartColumns();
        lists = data.getColumns();
        ArrayList<WorkInfo> workInfoList = new ArrayList();
        if (mask.equals("year")) {
            workInfoList = this.workDao.getWorkDatasByYear(year, this.protocol.getProtocolID(), serialno);
        } else if (mask.equals("month")) {
            workInfoList = this.workDao.getWorkDatasByMonth(year, month, this.protocol.getProtocolID(), serialno);
        } else if (mask.equals("day")) {
            workInfoList = this.workDao.getWorkDatasByDay(queryDate, this.protocol.getProtocolID(), serialno);
        } else if (mask.equals("hour")) {
            workInfoList = this.workDao.getWorkDatasByHour(queryDate, hour, this.protocol.getProtocolID(), serialno);
        }
        int i = 0;
        while (i < lists.size()) {
            AAPanel panel = new AAPanel();
            XYDataset xydataset = this.createDataset(workInfoList, bd.getString(((HistoryChart)lists.get(i)).getName()), ((HistoryChart)lists.get(i)).getValue(), year, month, day, hour, mask);
            JFreeChart chart = null;
            chart = i % 2 == 0 ? this.createChart(xydataset, ((HistoryChart)lists.get(i)).getMaximum(), ((HistoryChart)lists.get(i)).getUnit(), mask, 1) : this.createChart(xydataset, ((HistoryChart)lists.get(i)).getMaximum(), ((HistoryChart)lists.get(i)).getUnit(), mask, 2);
            ChartPanel chartPane = this.createChartPanel(chart);
            panel.add((Component)chartPane);
            this.jTabbedPane1.addTab(((HistoryChart)lists.get(i)).getName(), panel);
            ++i;
        }
    }

    private ChartPanel createChartPanel(JFreeChart chart) {
        ChartPanel chartPane = new ChartPanel(chart);
        chartPane.setPreferredSize(new Dimension(900, 420));
        return chartPane;
    }

    private XYDataset createDataset(List<WorkInfo> workInfoList, String name, String value, int year, int month, Date day, int hour, String mask) {
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(day);
            if (mask.equals("year")) {
                TimeSeries timeseries = new TimeSeries(name, Day.class);
                Day days = new Day(1, 1, year);
                int i = 0;
                while (i < workInfoList.size() - 2) {
                    this.workInfo = workInfoList.get(i);
                    timeseries.add((RegularTimePeriod)days, VolUtil.parseDouble(PageUtils.getResultByName(value, this)));
                    days = (Day)days.next().next().next();
                    ++i;
                }
                TimeSeriesCollection timeseriescollection = new TimeSeriesCollection(timeseries);
                return timeseriescollection;
            }
            if (mask.equals("month")) {
                TimeSeries timeseries = new TimeSeries(name, Hour.class);
                Hour hours = new Hour(0, 1, month, year);
                int i = 0;
                while (i < workInfoList.size() - 2) {
                    this.workInfo = workInfoList.get(i);
                    timeseries.add((RegularTimePeriod)hours, VolUtil.parseDouble(PageUtils.getResultByName(value, this)));
                    hours = (Hour)hours.next().next().next().next().next().next();
                    ++i;
                }
                TimeSeriesCollection timeseriescollection = new TimeSeriesCollection(timeseries);
                return timeseriescollection;
            }
            if (mask.equals("day")) {
                TimeSeries timeseries = new TimeSeries(name, Minute.class);
                Minute minutes = new Minute(0, 0, calendar.get(5), calendar.get(2) + 1, calendar.get(1));
                int i = 0;
                while (i < workInfoList.size() - 1) {
                    this.workInfo = workInfoList.get(i);
                    timeseries.add((RegularTimePeriod)minutes, VolUtil.parseDouble(PageUtils.getResultByName(value, this)));
                    minutes = (Minute)minutes.next().next().next().next().next().next().next().next().next().next().next().next().next().next().next();
                    ++i;
                }
                TimeSeriesCollection timeseriescollection = new TimeSeriesCollection(timeseries);
                return timeseriescollection;
            }
            if (mask.equals("hour")) {
                TimeSeries timeseries = new TimeSeries(name, Minute.class);
                Minute minutes = new Minute(0, hour, calendar.get(5), calendar.get(2) + 1, calendar.get(1));
                int i = 0;
                while (i < workInfoList.size() - 1) {
                    this.workInfo = workInfoList.get(i);
                    timeseries.add((RegularTimePeriod)minutes, VolUtil.parseDouble(PageUtils.getResultByName(value, this)));
                    minutes = (Minute)minutes.next();
                    ++i;
                }
                TimeSeriesCollection timeseriescollection = new TimeSeriesCollection(timeseries);
                return timeseriescollection;
            }
        }
        catch (Exception ex) {
            System.err.println("create history data dataset error");
        }
        return null;
    }

    private JFreeChart createChart(XYDataset xydataset, double maximum, String unit, String mask, int color) {
        try {
            JFreeChart jfreechart = ChartFactory.createTimeSeriesChart((String)"", (String)"", (String)unit, (XYDataset)xydataset, (boolean)false, (boolean)true, (boolean)false);
            jfreechart.setBackgroundPaint((Paint)new Color(102, 102, 102));
            XYPlot xyPlot = (XYPlot)jfreechart.getPlot();
            xyPlot.setBackgroundPaint((Paint)new Color(102, 102, 102));
            xyPlot.setDomainGridlinePaint((Paint)Constants.BG_COLOR);
            xyPlot.setDomainGridlinesVisible(true);
            xyPlot.setRangeGridlinePaint((Paint)Color.white);
            XYStepRenderer xysteprenderer = new XYStepRenderer();
            xysteprenderer.setStroke((Stroke)new BasicStroke(2.0f));
            SimpleDateFormat sdf = new SimpleDateFormat(String.valueOf(GlobalVariables.globalConfig.getDateFormat()) + " HH:mm:ss");
            StandardXYToolTipGenerator ttg = new StandardXYToolTipGenerator("{0}: ({1}, {2})", (DateFormat)sdf, (NumberFormat)new DecimalFormat("##0.00"));
            xysteprenderer.setToolTipGenerator((XYToolTipGenerator)ttg);
            xysteprenderer.setDefaultEntityRadius(6);
            xysteprenderer.setItemLabelsVisible(true);
            xysteprenderer.setBaseItemLabelsVisible(true);
            if (color == 1) {
                xysteprenderer.setPaint((Paint)Color.red);
            } else {
                xysteprenderer.setPaint((Paint)Color.blue);
            }
            xyPlot.setRenderer((XYItemRenderer)xysteprenderer);
            NumberAxis numberaxis = (NumberAxis)xyPlot.getRangeAxis();
            numberaxis.setLowerMargin(0.0);
            numberaxis.setUpperMargin(1.0);
            numberaxis.setRange(0.0, maximum);
            numberaxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
            DateAxis dateAxis = (DateAxis)xyPlot.getDomainAxis();
            dateAxis.setLowerMargin(0.001);
            if (mask.equals("year")) {
                SimpleDateFormat format = new SimpleDateFormat("MM");
                DateTickUnit dtu = new DateTickUnit(1, 1, (DateFormat)format);
                dateAxis.setTickUnit(dtu);
            } else if (mask.equals("month")) {
                SimpleDateFormat format = new SimpleDateFormat("dd");
                DateTickUnit dtu = new DateTickUnit(2, 1, (DateFormat)format);
                dateAxis.setTickUnit(dtu);
            } else if (mask.equals("day")) {
                SimpleDateFormat format = new SimpleDateFormat("HH");
                DateTickUnit dtu = new DateTickUnit(3, 1, (DateFormat)format);
                dateAxis.setTickUnit(dtu);
            } else if (mask.equals("hour")) {
                SimpleDateFormat format = new SimpleDateFormat("mm");
                DateTickUnit dtu = new DateTickUnit(4, 2, (DateFormat)format);
                dateAxis.setTickUnit(dtu);
            }
            return jfreechart;
        }
        catch (Exception ex) {
            System.err.println("create history data chart error");
            return null;
        }
    }

    private void queryChartAction() {
        if (this.jComboBox2.getSelectedItem() != null) {
            if (this.periodComboBox.getSelectedIndex() == 0) {
                this.setDataChart("year");
            } else if (this.periodComboBox.getSelectedIndex() == 1) {
                this.setDataChart("month");
            } else if (this.periodComboBox.getSelectedIndex() == 2) {
                this.setDataChart("day");
            } else if (this.periodComboBox.getSelectedIndex() == 3) {
                this.setDataChart("hour");
            }
        }
    }

    private void setPeriod() {
        if (this.periodComboBox.getSelectedIndex() == 0) {
            this.jSpinner1.setVisible(true);
            this.jTextField3.setVisible(false);
            this.jLabel6.setVisible(false);
            this.jSpinner2.setVisible(false);
            this.jLabel7.setVisible(false);
            this.jComboBox3.setVisible(false);
            GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
            this.jPanel1.setLayout(jPanel1Layout);
            jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 950, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.deviceLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox2, -2, 140, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.periodLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.periodComboBox, -2, 95, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maohaoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinner1, -2, 73, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.queryChartButton))).addContainerGap()));
            jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.deviceLabel2).addComponent(this.jComboBox2, -2, -1, -2).addComponent(this.periodLabel).addComponent(this.periodComboBox, -2, -1, -2).addComponent(this.maohaoLabel).addComponent(this.jSpinner1, -2, -1, -2).addComponent(this.queryChartButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 447, Short.MAX_VALUE).addContainerGap()));
        } else if (this.periodComboBox.getSelectedIndex() == 1) {
            this.jSpinner1.setVisible(true);
            this.jTextField3.setVisible(false);
            this.jLabel6.setVisible(false);
            this.jSpinner2.setVisible(false);
            this.jLabel7.setVisible(false);
            this.jComboBox3.setVisible(true);
            GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
            this.jPanel1.setLayout(jPanel1Layout);
            jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 950, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.deviceLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox2, -2, 140, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.periodLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.periodComboBox, -2, 95, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maohaoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinner1, -2, 73, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox3, -2, 90, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.queryChartButton))).addContainerGap()));
            jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.deviceLabel2).addComponent(this.jComboBox2, -2, -1, -2).addComponent(this.periodLabel).addComponent(this.periodComboBox, -2, -1, -2).addComponent(this.maohaoLabel).addComponent(this.jSpinner1, -2, -1, -2).addComponent(this.queryChartButton).addComponent(this.jComboBox3, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 447, Short.MAX_VALUE).addContainerGap()));
        } else if (this.periodComboBox.getSelectedIndex() == 2) {
            this.jSpinner1.setVisible(false);
            this.jTextField3.setVisible(true);
            this.jLabel6.setVisible(true);
            this.jSpinner2.setVisible(false);
            this.jLabel7.setVisible(false);
            this.jComboBox3.setVisible(false);
            GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
            this.jPanel1.setLayout(jPanel1Layout);
            jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 950, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.deviceLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox2, -2, 140, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.periodLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.periodComboBox, -2, 95, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maohaoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField3, -2, 96, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.queryChartButton))).addContainerGap()));
            jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.queryChartButton).addComponent(this.jLabel6).addComponent(this.jTextField3, -2, -1, -2).addComponent(this.periodComboBox, -2, -1, -2).addComponent(this.maohaoLabel).addComponent(this.periodLabel).addComponent(this.jComboBox2, -2, -1, -2).addComponent(this.deviceLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 447, Short.MAX_VALUE).addContainerGap()));
        } else if (this.periodComboBox.getSelectedIndex() == 3) {
            this.jSpinner1.setVisible(false);
            this.jTextField3.setVisible(true);
            this.jLabel6.setVisible(true);
            this.jSpinner2.setVisible(true);
            this.jLabel7.setVisible(true);
            this.jComboBox3.setVisible(false);
            GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
            this.jPanel1.setLayout(jPanel1Layout);
            jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 950, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.deviceLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox2, -2, 140, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.periodLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.periodComboBox, -2, 95, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maohaoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField3, -2, 96, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinner2, -2, 56, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.queryChartButton))).addContainerGap()));
            jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.queryChartButton).addComponent(this.jLabel7).addComponent(this.jSpinner2, -2, -1, -2).addComponent(this.jLabel6).addComponent(this.jTextField3, -2, -1, -2).addComponent(this.periodComboBox, -2, -1, -2).addComponent(this.periodLabel).addComponent(this.maohaoLabel).addComponent(this.jComboBox2, -2, -1, -2).addComponent(this.deviceLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 447, Short.MAX_VALUE).addContainerGap()));
        }
    }
}

