/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.view;

import cn.com.voltronic.solar.console.SolarPowerTray;
import cn.com.voltronic.solar.constants.Constants;
import cn.com.voltronic.solar.dao.DeviceDao;
import cn.com.voltronic.solar.dao.WorkDataDao;
import cn.com.voltronic.solar.data.bean.DeviceBean;
import cn.com.voltronic.solar.data.bean.HistoryData;
import cn.com.voltronic.solar.data.bean.HistoryDataColumns;
import cn.com.voltronic.solar.data.bean.WorkInfo;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.protocol.IProtocol;
import cn.com.voltronic.solar.protocol.P30;
import cn.com.voltronic.solar.protocol.P301TO3KW;
import cn.com.voltronic.solar.protocol.P304TO5KW;
import cn.com.voltronic.solar.protocol.P30EPS;
import cn.com.voltronic.solar.protocol.P30EPSM5K;
import cn.com.voltronic.solar.protocol.P30LY;
import cn.com.voltronic.solar.protocol.P30Paral;
import cn.com.voltronic.solar.protocol.P30PlusDuo;
import cn.com.voltronic.solar.protocol.P30PlusTri;
import cn.com.voltronic.solar.protocol.P30V;
import cn.com.voltronic.solar.system.GlobalProcessors;
import cn.com.voltronic.solar.system.GlobalVariables;
import cn.com.voltronic.solar.util.DateUtils;
import cn.com.voltronic.solar.util.PageUtils;
import cn.com.voltronic.solar.view.ExcelFileFilter;
import cn.com.voltronic.solar.view.ExcelxFileFilter;
import cn.com.voltronic.solar.view.HistoryDataChart;
import cn.com.voltronic.solar.view.LoginJDialog;
import cn.com.voltronic.solar.view.PDFFileFilter;
import cn.com.voltronic.solar.view.component.AAButton;
import cn.com.voltronic.solar.view.component.AACheckBox;
import cn.com.voltronic.solar.view.component.AADefaultTableModel;
import cn.com.voltronic.solar.view.component.AADialog;
import cn.com.voltronic.solar.view.component.AALabel;
import cn.com.voltronic.solar.view.component.AATabbedPane;
import cn.com.voltronic.solar.view.component.CheckBoxData;
import cn.com.voltronic.solar.view.component.DisplayMessage;
import cn.com.voltronic.solar.view.component.I18NListener;
import cn.com.voltronic.solar.view.component.JComboCheckBox;
import cn.com.voltronic.solar.view.component.MyCalendarPanel;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jxl.Workbook;
import jxl.format.Alignment;
import jxl.format.CellFormat;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import org.apache.commons.lang.StringUtils;

public class HistoryDataJDialog
extends AADialog {
    private static final long serialVersionUID = 7150098148061598284L;
    private HistoryDataChart chartPanel;
    private JPanel dataPanel;
    private AAButton deleteAllButton;
    private AAButton deleteButton;
    private AAButton closeButton;
    private AAButton viewButton;
    private AAButton saveAsButton;
    private AACheckBox excelCheckBox;
    private JComboBox jComboBox1;
    private AALabel jLabel1;
    private AALabel jLabel2;
    private AALabel jLabel3;
    private AALabel jLabel4;
    private AALabel jLabel5;
    private AALabel jLabel6;
    private AALabel jLabel7;
    private AALabel jLabel8;
    private AALabel jLabel9;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JTable jTable1;
    private JTextField jTextField1;
    private JTextField jTextField2;
    private AATabbedPane mainTabbedPane;
    private JComboCheckBox viewColumns;
    private boolean canDelete = false;
    private WorkDataDao workDao = null;
    private DeviceDao deviceDao = null;
    private IProtocol protocol = null;
    private JFileChooser fDialog;
    private AADefaultTableModel tableModel = null;
    private List<WorkInfo> workInfolist = new ArrayList<WorkInfo>();
    public WorkInfo workInfo = null;
    private final int MAX_SIZE = 21;
    private int MAX_COLUMN = 8;
    private String[] tableTile = new String[]{"Input date", "Fault message", "Grid voltage", "Output current", "Grid frequency", "PV1 input voltage", "PV1 input frequency", "Temperature"};

    public HistoryDataJDialog(Frame parent, boolean modal) {
        super(parent, modal);
        String serialno;
        this.protocol = new P30();
        this.deviceDao = new DeviceDao();
        this.workDao = new WorkDataDao();
        this.workInfo = new WorkInfo();
        this.initComponents();
        AbstractProcessor processor = GlobalProcessors.getCurrentProcessor();
        if (processor != null && !StringUtils.isEmpty((String)(serialno = processor.getSerialNo().trim()))) {
            this.jComboBox1.setSelectedItem(serialno);
        }
        int width = this.getWidth();
        int height = this.getHeight();
        if (height < 690) {
            height = 690;
        }
        this.setSize(width, height);
        this.setTitle("message.queryData");
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private List<HistoryData> getHistoryDataColumns() {
        ArrayList<HistoryData> list = new ArrayList();
        Object selected = this.jComboBox1.getSelectedItem();
        if (selected != null) {
            String serialno = selected.toString().trim();
            DeviceBean bean = this.deviceDao.queryDevicebySerialno(serialno);
            if (bean == null) {
                this.protocol = new P30();
            } else {
                this.protocol = bean.getProdid().equals("P30") ? new P30() : (bean.getProdid().equals("P301TO3KW") ? new P301TO3KW() : (bean.getProdid().equals("P304TO5KW") ? new P304TO5KW() : (bean.getProdid().equals("P30V") ? new P30V() : (bean.getProdid().equals("P30PLUSDUO") ? new P30PlusDuo() : (bean.getProdid().equals("P30PLUSTRI") ? new P30PlusTri() : (bean.getProdid().equals("P30EPS") ? new P30EPS() : (bean.getProdid().equals("P30EPSM5K") ? new P30EPSM5K() : (bean.getProdid().equals("P30LY") ? new P30LY() : (bean.getProdid().equals("P30PARAL") ? new P30Paral() : new P30())))))))));
                this.protocol.setOutputMode(bean.getParallel());
                this.protocol.setMachineType(bean.getModetype());
            }
        }
        HistoryDataColumns data = this.protocol.getHistoryColumns();
        list = data.getColumns();
        return list;
    }

    private List<HistoryData> getHistoryDataColumnsView() {
        List<HistoryData> columns = this.getHistoryDataColumns();
        ArrayList<HistoryData> newdata = new ArrayList<HistoryData>();
        String[] values = this.getTableTitle();
        int i = 0;
        while (i < columns.size()) {
            int j = 0;
            while (j < values.length) {
                if (bd.getString(columns.get(i).getName()).equals(values[j])) {
                    newdata.add(columns.get(i));
                    break;
                }
                ++j;
            }
            ++i;
        }
        return newdata;
    }

    private String[] getTableTitle() {
        List<CheckBoxData> values = this.viewColumns.getCheckBoxDatas();
        ArrayList<CheckBoxData> selects = new ArrayList<CheckBoxData>();
        int i = 0;
        while (i < values.size()) {
            if (values.get(i).isSelected()) {
                selects.add(values.get(i));
            }
            ++i;
        }
        this.MAX_COLUMN = selects.size();
        String[] str = new String[selects.size()];
        int i2 = 0;
        while (i2 < selects.size()) {
            str[i2] = bd.getString(((CheckBoxData)selects.get(i2)).getName());
            ++i2;
        }
        return str;
    }

    private List<CheckBoxData> getCheckColumns() {
        List<HistoryData> list = this.getHistoryDataColumns();
        this.MAX_COLUMN = list.size();
        ArrayList<CheckBoxData> listdata = new ArrayList<CheckBoxData>();
        int i = 0;
        while (i < list.size()) {
            CheckBoxData data = new CheckBoxData(bd.getString(list.get(i).getName()), list.get(i).isView(), list.get(i).isEnable());
            listdata.add(data);
            ++i;
        }
        return listdata;
    }

    private void initComponents() {
        this.mainTabbedPane = new AATabbedPane();
        this.dataPanel = new JPanel();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new AALabel();
        this.jComboBox1 = new JComboBox();
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(this.queryDevices()));
        this.viewColumns = new JComboCheckBox();
        this.viewColumns.addItems(this.getCheckColumns());
        this.jLabel2 = new AALabel();
        this.jTextField1 = new JTextField();
        this.jLabel3 = new AALabel();
        this.jLabel4 = new AALabel();
        this.jLabel5 = new AALabel();
        this.jLabel6 = new AALabel();
        this.jLabel7 = new AALabel();
        this.jLabel8 = new AALabel();
        this.jLabel9 = new AALabel();
        this.viewButton = new AAButton();
        this.excelCheckBox = new AACheckBox();
        this.jTextField2 = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.jPanel4 = new JPanel();
        this.deleteAllButton = new AAButton();
        this.deleteButton = new AAButton();
        this.closeButton = new AAButton();
        this.saveAsButton = new AAButton();
        this.chartPanel = new HistoryDataChart();
        this.tableTile = this.getTableTitle();
        this.jTable1 = new JTable(){
            private static final long serialVersionUID = -2097364819095589911L;

            @Override
            public boolean isCellSelected(int row, int column) {
                if (row >= HistoryDataJDialog.this.workInfolist.size()) {
                    return false;
                }
                return super.isCellSelected(row, column);
            }
        };
        this.jTable1.getTableHeader().setReorderingAllowed(false);
        this.jTable1.getTableHeader().setForeground(Color.white);
        this.jTable1.setSelectionMode(0);
        this.tableModel = new AADefaultTableModel(new Object[21][this.MAX_COLUMN], this.tableTile){
            private static final long serialVersionUID = -4444769250474742659L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.jTable1.setModel(this.tableModel);
        this.setDefaultCloseOperation(2);
        this.dataPanel.setLayout(new BorderLayout());
        this.jPanel3.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel1.setText("message.device[:]");
        this.jLabel6.setText("message.viewselect[:]");
        this.jLabel2.setText("message.selectDate[:]");
        this.jComboBox1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                HistoryDataJDialog.this.canDelete = false;
                HistoryDataJDialog.this.viewColumns.removeAllItems();
                HistoryDataJDialog.this.viewColumns.addItems(HistoryDataJDialog.this.getCheckColumns());
            }
        });
        this.jLabel3.setIcon(new ImageIcon(Constants.DATE));
        this.jLabel3.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                HistoryDataJDialog.this.canDelete = false;
                MyCalendarPanel calendarPanel = new MyCalendarPanel(HistoryDataJDialog.this.jTextField1);
                calendarPanel.setBounds(HistoryDataJDialog.this.getX() + HistoryDataJDialog.this.jLabel3.getX() + 30, HistoryDataJDialog.this.getY() + HistoryDataJDialog.this.jLabel3.getY() + 10, calendarPanel.getWidth(), calendarPanel.getHeight());
                calendarPanel.setVisible(true);
            }
        });
        this.jTextField1.setEditable(false);
        this.jTextField1.setBackground(I18NListener.bgColor);
        this.jTextField1.setText(DateUtils.getNowDate());
        this.jTextField1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                HistoryDataJDialog.this.canDelete = false;
                MyCalendarPanel calendarPanel = new MyCalendarPanel(HistoryDataJDialog.this.jTextField1);
                calendarPanel.setBounds(HistoryDataJDialog.this.getX() + HistoryDataJDialog.this.jLabel3.getX() + 30, HistoryDataJDialog.this.getY() + HistoryDataJDialog.this.jLabel3.getY() + 10, calendarPanel.getWidth(), calendarPanel.getHeight());
                calendarPanel.setVisible(true);
            }
        });
        this.jLabel4.setText("--");
        this.jLabel5.setIcon(new ImageIcon(Constants.DATE));
        this.jLabel5.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                HistoryDataJDialog.this.canDelete = false;
                MyCalendarPanel calendarPanel = new MyCalendarPanel(HistoryDataJDialog.this.jTextField2);
                calendarPanel.setBounds(HistoryDataJDialog.this.getX() + HistoryDataJDialog.this.jLabel5.getX() + 30, HistoryDataJDialog.this.getY() + HistoryDataJDialog.this.jLabel5.getY() + 10, calendarPanel.getWidth(), calendarPanel.getHeight());
                calendarPanel.setVisible(true);
            }
        });
        this.jTextField2.setEditable(false);
        this.jTextField2.setBackground(I18NListener.bgColor);
        this.jTextField2.setText(DateUtils.getNowDate());
        this.jTextField2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                HistoryDataJDialog.this.canDelete = false;
                MyCalendarPanel calendarPanel = new MyCalendarPanel(HistoryDataJDialog.this.jTextField2);
                calendarPanel.setBounds(HistoryDataJDialog.this.getX() + HistoryDataJDialog.this.jLabel5.getX() + 30, HistoryDataJDialog.this.getY() + HistoryDataJDialog.this.jLabel5.getY() + 10, calendarPanel.getWidth(), calendarPanel.getHeight());
                calendarPanel.setVisible(true);
            }
        });
        this.viewButton.setText("message.view");
        this.viewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HistoryDataJDialog.this.canDelete = true;
                HistoryDataJDialog.this.queryHistoryWorkInfo();
            }
        });
        this.excelCheckBox.setText("message.saveasexcel");
        this.jLabel7.setText("message.totalrow[:]");
        this.jLabel8.setText("0");
        this.jLabel9.setText("message.row");
        this.jScrollPane1.setViewportView(this.jTable1);
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 950, Short.MAX_VALUE).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox1, -2, 140, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.viewColumns, -2, 140, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField1, -2, 104, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField2, -2, 104, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.viewButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.excelCheckBox))).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel5).addComponent(this.jTextField2, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.jLabel3).addComponent(this.jTextField1, -2, -1, -2).addComponent(this.jComboBox1, -2, -1, -2).addComponent(this.viewColumns, -2, -1, -2).addComponent(this.jLabel6).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.viewButton).addComponent(this.excelCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 447, Short.MAX_VALUE).addContainerGap()));
        this.dataPanel.add((Component)this.jPanel3, "Center");
        this.jPanel4.setBorder(BorderFactory.createEtchedBorder());
        this.deleteButton.setText("message.del");
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SolarPowerTray.isLogin) {
                    new LoginJDialog(new Frame(), true);
                    return;
                }
                HistoryDataJDialog.this.deleteDatas();
            }
        });
        this.deleteAllButton.setText("message.deleteAll");
        this.deleteAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SolarPowerTray.isLogin) {
                    new LoginJDialog(new Frame(), true);
                    return;
                }
                HistoryDataJDialog.this.clearDatas();
            }
        });
        this.closeButton.setText("message.close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HistoryDataJDialog.this.dispose();
            }
        });
        this.saveAsButton.setText("message.saveas");
        this.saveAsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SolarPowerTray.isLogin) {
                    new LoginJDialog(new Frame(), true);
                    return;
                }
                HistoryDataJDialog.this.saveAs();
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel9).addContainerGap(400, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 400, Short.MAX_VALUE).addComponent(this.saveAsButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deleteButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deleteAllButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton).addGap(12, 12, 12)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.jLabel8).addComponent(this.jLabel9).addComponent(this.closeButton).addComponent(this.deleteButton).addComponent(this.deleteAllButton).addComponent(this.saveAsButton)).addContainerGap()));
        this.dataPanel.add((Component)this.jPanel4, "Last");
        this.mainTabbedPane.addTab("message.dataview", this.dataPanel);
        this.chartPanel.closeChartButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HistoryDataJDialog.this.dispose();
            }
        });
        this.mainTabbedPane.addTab("message.digram", this.chartPanel);
        this.getContentPane().add((Component)this.mainTabbedPane, "Center");
        this.pack();
    }

    public void queryHistoryWorkInfo() {
        if (this.jComboBox1.getSelectedItem() != null) {
            String serialno = this.jComboBox1.getSelectedItem().toString().trim();
            String startDate = this.jTextField1.getText().trim();
            String endDate = this.jTextField2.getText().trim();
            if (!(serialno == null || "".equals(serialno) || startDate == null || "".equals(startDate) || endDate == null || "".equals(endDate))) {
                int j;
                this.jLabel8.setText("0");
                SimpleDateFormat format = new SimpleDateFormat(GlobalVariables.globalConfig.getDateFormat());
                Date fromDate = new Date();
                Date toDate = new Date();
                try {
                    fromDate = format.parse(startDate);
                    toDate = format.parse(endDate);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                DeviceBean bean = this.deviceDao.queryDevicebySerialno(serialno);
                this.workInfolist = this.workDao.queryWorkInfo(bean.getProdid(), serialno, fromDate, toDate);
                int size = this.workInfolist.size();
                if (size < 21) {
                    size = 21;
                }
                Object[] tableTitle = this.getTableTitle();
                List<HistoryData> lists = this.getHistoryDataColumnsView();
                Object[][] obj = new Object[size][this.MAX_COLUMN];
                int i = 0;
                while (i < this.workInfolist.size()) {
                    this.workInfo = this.workInfolist.get(i);
                    j = 0;
                    while (j < lists.size()) {
                        try {
                            if (lists.get(j).getValue().equals("{workInfo.getCurrentTime}")) {
                                String dateStr = PageUtils.getResultByName(lists.get(j).getValue(), this);
                                obj[i][j] = DateUtils.getFormatDateStr(dateStr, String.valueOf(GlobalVariables.globalConfig.getDateFormat()) + " HH:mm:ss");
                            } else {
                                obj[i][j] = PageUtils.getResultByName(lists.get(j).getValue(), this);
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        ++j;
                    }
                    ++i;
                }
                if (this.workInfolist.size() < 21) {
                    i = this.workInfolist.size();
                    while (i < 21) {
                        j = 0;
                        while (j < this.MAX_COLUMN) {
                            obj[i][j] = null;
                            ++j;
                        }
                        ++i;
                    }
                }
                this.tableModel.setDataVector(obj, tableTitle);
                if (this.workInfolist != null) {
                    this.jLabel8.setText(String.valueOf(this.workInfolist.size()));
                } else {
                    this.jLabel8.setText("0");
                }
            }
        }
    }

    public void setTableFormate() {
        TableColumnModel tcm = this.jTable1.getColumnModel();
        TableColumn tc0 = tcm.getColumn(0);
        TableColumn tc1 = tcm.getColumn(1);
        TableColumn tc2 = tcm.getColumn(2);
        TableColumn tc3 = tcm.getColumn(3);
        tc0.setPreferredWidth(30);
        tc1.setPreferredWidth(30);
        tc2.setPreferredWidth(100);
        tc3.setPreferredWidth(250);
    }

    public String[] queryDevices() {
        List<String> devicelist = this.deviceDao.querySerialnoAll();
        String[] devices = new String[devicelist.size()];
        int i = 0;
        while (i < devicelist.size()) {
            devices[i] = devicelist.get(i);
            ++i;
        }
        return devices;
    }

    public void deleteDatas() {
        if (this.jComboBox1.getSelectedItem() != null) {
            String serialno = this.jComboBox1.getSelectedItem().toString().trim();
            int re = DisplayMessage.showConfirmDialog("message.deleteConfirm", "message.info");
            if (re == 0 && serialno != null && !"".equals(serialno)) {
                int row = this.jTable1.getSelectedRow();
                if (row > -1) {
                    Object obj = this.tableModel.getValueAt(row, 1);
                    if (obj != null) {
                        SimpleDateFormat sdf = new SimpleDateFormat(String.valueOf(GlobalVariables.globalConfig.getDateFormat()) + " HH:mm:ss");
                        Date trandate = new Date();
                        try {
                            trandate = sdf.parse(obj.toString());
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        DeviceBean bean = this.deviceDao.queryDevicebySerialno(serialno);
                        boolean result = this.workDao.removeWork(bean.getProdid(), serialno, trandate);
                        if (result) {
                            this.queryHistoryWorkInfo();
                        } else {
                            DisplayMessage.showErrorDialog("message.operationfailure");
                        }
                    } else {
                        DisplayMessage.showErrorDialog("message.pleaseselect");
                    }
                } else {
                    DisplayMessage.showErrorDialog("message.pleaseselect");
                }
            }
        }
    }

    public void clearDatas() {
        if (this.canDelete && this.jComboBox1.getSelectedItem() != null) {
            String serialno = this.jComboBox1.getSelectedItem().toString().trim();
            String startDate = this.jTextField1.getText().trim();
            String endDate = this.jTextField2.getText().trim();
            int re = DisplayMessage.showConfirmDialog("message.deleteConfirm", "message.info");
            if (!(re != 0 || serialno == null || "".equals(serialno) || startDate == null || "".equals(startDate) || endDate == null || "".equals(endDate))) {
                SimpleDateFormat format = new SimpleDateFormat(GlobalVariables.globalConfig.getDateFormat());
                Date fromDate = new Date();
                Date toDate = new Date();
                try {
                    fromDate = format.parse(startDate);
                    toDate = format.parse(endDate);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                DeviceBean bean = this.deviceDao.queryDevicebySerialno(serialno);
                boolean result = this.workDao.removeAllWork(bean.getProdid(), serialno, fromDate, toDate);
                if (result) {
                    this.queryHistoryWorkInfo();
                } else {
                    DisplayMessage.showErrorDialog("message.operationfailure");
                }
            }
        }
    }

    public int getSaveDialog() {
        Date date = new Date();
        String saveFileName = DateUtils.getFormatDate(date, "yyyyMMddHHmmss");
        this.fDialog = new JFileChooser();
        if (this.excelCheckBox.isSelected()) {
            saveFileName = String.valueOf(saveFileName) + ".xls";
            ExcelFileFilter xls = new ExcelFileFilter();
            this.fDialog.addChoosableFileFilter(xls);
            ExcelxFileFilter xlsx = new ExcelxFileFilter();
            this.fDialog.setFileFilter(xlsx);
        } else {
            saveFileName = String.valueOf(saveFileName) + ".pdf";
            PDFFileFilter txtFilter = new PDFFileFilter();
            this.fDialog.addChoosableFileFilter(txtFilter);
            this.fDialog.setFileFilter(txtFilter);
        }
        this.fDialog.setAcceptAllFileFilterUsed(true);
        this.fDialog.setSelectedFile(new File(saveFileName));
        return this.fDialog.showSaveDialog(this);
    }

    public void saveAs() {
        int result = this.getSaveDialog();
        if (result == 0) {
            String filepathStr = this.fDialog.getSelectedFile().getPath();
            File newFile = new File(filepathStr);
            if (newFile.exists()) {
                int re = DisplayMessage.showConfirmDialog("message.confirmoverwrite", "message.info");
                if (re == 0) {
                    if (this.excelCheckBox.isSelected()) {
                        this.createExcel(newFile);
                    } else {
                        this.createPdf(filepathStr);
                    }
                } else {
                    this.saveAs();
                }
            } else {
                try {
                    newFile.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (this.excelCheckBox.isSelected()) {
                    this.createExcel(newFile);
                } else {
                    this.createPdf(filepathStr);
                }
            }
        }
    }

    public void createPdf(String path) {
        Document pdf = new Document(PageSize.A4);
        try {
            try {
                PdfWriter.getInstance((Document)pdf, (OutputStream)new FileOutputStream(path));
                pdf.addTitle("History datas");
                pdf.addAuthor(GlobalVariables.customerConfig.getCustomerName());
                pdf.open();
                BaseFont bf = BaseFont.createFont((String)(String.valueOf(Constants.PDF_STYLE_PATH) + "simsun.ttc,1"), (String)"Identity-H", (boolean)false);
                Font datafont = new Font(bf, 12.0f, 0, BaseColor.BLACK);
                String[] titles = this.getTableTitle();
                PdfPTable table = new PdfPTable(titles.length);
                int i = 0;
                while (i < titles.length) {
                    PdfPCell cell = new PdfPCell((Phrase)new Paragraph(bd.getString(titles[i]), datafont));
                    cell.setHorizontalAlignment(1);
                    table.addCell(cell);
                    ++i;
                }
                i = 0;
                while (i < this.workInfolist.size()) {
                    List<HistoryData> lists = this.getHistoryDataColumnsView();
                    this.workInfo = this.workInfolist.get(i);
                    int j = 0;
                    while (j < lists.size()) {
                        if (lists.get(j).getValue().equals("{workInfo.getCurrentTime}")) {
                            table.addCell((Phrase)new Paragraph(DateUtils.getFormatDateStr(PageUtils.getResultByName(lists.get(j).getValue(), this), String.valueOf(GlobalVariables.globalConfig.getDateFormat()) + " HH:mm:ss"), datafont));
                        } else {
                            table.addCell((Phrase)new Paragraph(PageUtils.getResultByName(lists.get(j).getValue(), this), datafont));
                        }
                        ++j;
                    }
                    ++i;
                }
                table.setWidthPercentage(100.0f);
                pdf.add((Element)table);
                Thread.sleep(1500L);
            }
            catch (Exception ie) {
                DisplayMessage.showErrorDialog("message.saveerror");
                try {
                    if (pdf != null) {
                        pdf.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (pdf != null) {
                    pdf.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void createExcel(File newFile) {
        WritableWorkbook wwb = null;
        try {
            try {
                wwb = Workbook.createWorkbook((File)newFile);
                WritableSheet ws = wwb.createSheet("History Datas", 0);
                WritableCellFormat cellFormat = new WritableCellFormat();
                cellFormat.setAlignment(Alignment.CENTRE);
                String[] titles = this.getTableTitle();
                int i = 0;
                while (i < titles.length) {
                    Label labelC = new Label(i, 0, bd.getString(titles[i]));
                    labelC.setCellFormat((CellFormat)cellFormat);
                    ws.addCell((WritableCell)labelC);
                    int length = bd.getString(titles[i]).length();
                    if (length >= 20) {
                        ws.setColumnView(i, length + 2);
                    } else {
                        ws.setColumnView(i, 22);
                    }
                    ++i;
                }
                i = 0;
                while (i < this.workInfolist.size()) {
                    List<HistoryData> lists = this.getHistoryDataColumnsView();
                    this.workInfo = this.workInfolist.get(i);
                    int j = 0;
                    while (j < lists.size()) {
                        Label labelC;
                        if (lists.get(j).getValue().equals("{workInfo.getCurrentTime}")) {
                            labelC = new Label(j, i + 1, DateUtils.getFormatDateStr(PageUtils.getResultByName(lists.get(j).getValue(), this), String.valueOf(GlobalVariables.globalConfig.getDateFormat()) + " HH:mm:ss"));
                            ws.addCell((WritableCell)labelC);
                        } else {
                            labelC = new Label(j, i + 1, PageUtils.getResultByName(lists.get(j).getValue(), this));
                            ws.addCell((WritableCell)labelC);
                        }
                        ++j;
                    }
                    ++i;
                }
                wwb.write();
                Thread.sleep(1500L);
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (wwb != null) {
                        wwb.close();
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (wwb != null) {
                    wwb.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

