/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.view;

import cn.com.voltronic.solar.communicate.FairLock;
import cn.com.voltronic.solar.configure.ConfigureTools;
import cn.com.voltronic.solar.console.SolarPowerTray;
import cn.com.voltronic.solar.constants.Constants;
import cn.com.voltronic.solar.dao.DeviceDao;
import cn.com.voltronic.solar.data.bean.AutoMenuItem;
import cn.com.voltronic.solar.data.bean.AutoMenuList;
import cn.com.voltronic.solar.data.bean.AutoMenuOne;
import cn.com.voltronic.solar.data.bean.AutoMenuTwo;
import cn.com.voltronic.solar.data.bean.MachineInfo;
import cn.com.voltronic.solar.data.bean.WorkInfo;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.protocol.IProtocol;
import cn.com.voltronic.solar.protocol.P30;
import cn.com.voltronic.solar.system.GlobalProcessors;
import cn.com.voltronic.solar.system.GlobalVariables;
import cn.com.voltronic.solar.view.AboutJDialog;
import cn.com.voltronic.solar.view.BasicJDialog;
import cn.com.voltronic.solar.view.COMSetJDialog;
import cn.com.voltronic.solar.view.EmailSetting;
import cn.com.voltronic.solar.view.EventActionDialog;
import cn.com.voltronic.solar.view.HistoryDataJDialog;
import cn.com.voltronic.solar.view.HistoryEventDialog;
import cn.com.voltronic.solar.view.HistoryFaultDataDialog;
import cn.com.voltronic.solar.view.LoginJDialog;
import cn.com.voltronic.solar.view.ModbusSerialSetting;
import cn.com.voltronic.solar.view.MonitoredInfoJDialog;
import cn.com.voltronic.solar.view.ParameterJDialog;
import cn.com.voltronic.solar.view.PasswordJDialog;
import cn.com.voltronic.solar.view.PriceJDialog;
import cn.com.voltronic.solar.view.RealControlJDialog30;
import cn.com.voltronic.solar.view.RestoreJDialog;
import cn.com.voltronic.solar.view.SMSSetting;
import cn.com.voltronic.solar.view.component.AAButtonTip;
import cn.com.voltronic.solar.view.component.AAJMenu;
import cn.com.voltronic.solar.view.component.AAJMenuItem;
import cn.com.voltronic.solar.view.component.AALabel;
import cn.com.voltronic.solar.view.component.DisplayMessage;
import cn.com.voltronic.solar.view.component.I18NBundle;
import cn.com.voltronic.solar.view.component.VPTree;
import cn.com.voltronic.solar.view.panel.BasePanel;
import cn.com.voltronic.solar.view.panel.StatusPanel;
import com.jtattoo.plaf.smart.SmartLookAndFeel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.List;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class MainJFrame
extends JFrame {
    private static final long serialVersionUID = -3494660164922508506L;
    private DeviceDao deviceDao = new DeviceDao();
    private static MainJFrame mainFrame = null;
    private AbstractProcessor currProcesser = null;
    private JMenuBar menuBar = null;
    private JPanel centerPanel;
    private JPanel changePanel;
    private AAButtonTip statusButton;
    private AAButtonTip parameterButton;
    private AAButtonTip dataButton;
    private AAButtonTip eventButton;
    private AAButtonTip faultButton;
    public static AAButtonTip loginButton;
    public static AALabel loginLabel;
    private AALabel monitoredLabelC;
    private AALabel monitoredLabelV;
    private JSplitPane jSplitPane;
    private static VPTree deviceTree;
    private JScrollPane leftScrollPane;
    private JScrollPane treeScrollPane;
    private JPanel treePanel;
    private JLabel logoLabel;
    private JPanel mainPanel;
    private JPanel northPanel;
    private StatusPanel statusPanel;
    private static Integer lock;
    private static Integer menuLock;
    public IProtocol protocol = null;
    private static int isPVCharging;
    private static int isShowChargingCurrent;
    private FairLock fairlock = new FairLock();
    private IProtocol oldProtocol = new P30();

    static {
        lock = 1;
        menuLock = 2;
        isPVCharging = 1;
        isShowChargingCurrent = 0;
        try {
            Properties props = new Properties();
            props.put("foregroundColor", "255 255 255");
            props.put("frameColor", "130 130 130");
            props.put("gridColor", "210 210 210");
            props.put("logoString", "");
            props.put("tooltipBackgroundColor", "102 102 102");
            props.put("tooltipForegroundColor", "255 255 255");
            props.put("selectionBackgroundColor", "230 230 230");
            props.put("menuSelectionForegroundColor", "0 0 0");
            props.put("menuSelectionBackgroundColor", "230 230 230");
            props.put("menuSelectionBackgroundColorLight", "255 255 255");
            props.put("menuSelectionBackgroundColorDark", "230 230 230");
            props.put("menuBackgroundColor", "90 90 90");
            props.put("menuColorLight", "69 69 69");
            props.put("menuColorDark", "102 102 102");
            props.put("menuForegroundColor", "255 255 255");
            props.put("controlColor", "102 102 102");
            props.put("controlColorLight", "102 102 102");
            props.put("controlColorDark", "69 69 69");
            props.put("buttonForegroundColor", "255 255 255");
            props.put("buttonColor", "102 102 102");
            props.put("buttonBackgroundColor", "102 102 102");
            props.put("buttonColorLight", "230 230 230");
            props.put("buttonColorDark", "102 102 102");
            props.put("rolloverColor", "102 102 102");
            props.put("rolloverColorLight", "102 102 102");
            props.put("rolloverColorDark", "69 69 69");
            props.put("windowTitleForegroundColor", "0 0 0");
            props.put("windowTitleBackgroundColor", "69 69 69");
            props.put("windowTitleColorLight", "197 197 197");
            props.put("windowTitleColorDark", "69 69 69");
            props.put("windowBorderColor", "10 10 10");
            props.put("tabAreaBackgroundColor", "102 102 102");
            props.put("inputForegroundColor", "255 255 255");
            props.put("inputBackgroundColor", "102 102 102");
            props.put("focusColor", "255 255 255");
            props.put("focusCellColor", "255 255 255");
            props.put("backgroundColor", "102 102 102");
            props.put("backgroundColorLight", "255 255 255");
            props.put("backgroundColorDark", "102 102 102");
            SmartLookAndFeel.setCurrentTheme((Properties)props);
            UIManager.setLookAndFeel("com.jtattoo.plaf.smart.SmartLookAndFeel");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public MainJFrame() {
        this.menuBar = new JMenuBar();
        this.initMenu();
        this.setJMenuBar(this.menuBar);
        this.initComponents();
        Dimension ds = Toolkit.getDefaultToolkit().getScreenSize();
        int width = 1280;
        int height = 800;
        if (ds.getWidth() < (double)width) {
            width = (int)ds.getWidth();
        }
        if (ds.getHeight() < (double)height) {
            height = (int)ds.getHeight();
        }
        this.setSize(width - 20, height - 45);
        this.setTitle(GlobalVariables.customerConfig.getCustomerName());
        this.setIconImage(Constants.CONNECTEDIMG);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MainJFrame getNewInstance() {
        Integer n = lock;
        synchronized (n) {
            if (mainFrame == null) {
                mainFrame = new MainJFrame();
                mainFrame.setVisible(true);
            }
            return mainFrame;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMenu() {
        Integer n = menuLock;
        synchronized (n) {
            if (this.menuBar != null && this.currProcesser != null) {
                this.menuBar.removeAll();
                this.protocol = new P30();
                this.currProcesser = GlobalProcessors.getCurrentProcessor();
                if (this.currProcesser != null) {
                    this.protocol = this.currProcesser.getProtocol();
                }
                if (this.protocol == null) {
                    this.protocol = new P30();
                }
                AutoMenuList autoMenuList = this.protocol.getMenuList();
                List<AutoMenuOne> autoMenuOneList = autoMenuList.getMenuList();
                int i = 0;
                while (i < autoMenuOneList.size()) {
                    List<AutoMenuTwo> autoMenuTwoList = autoMenuOneList.get(i).getItems();
                    String label = autoMenuOneList.get(i).getLabel();
                    AAJMenu autoMenuOne = new AAJMenu();
                    autoMenuOne.setText(label);
                    int j = 0;
                    while (j < autoMenuTwoList.size()) {
                        Object autoMenuItem;
                        List<AutoMenuItem> items = autoMenuTwoList.get(j).getItems();
                        if (items == null) {
                            autoMenuItem = autoMenuTwoList.get(j).getItem();
                            AAJMenuItem menuItemTwo = new AAJMenuItem();
                            menuItemTwo.setText(((AutoMenuItem)autoMenuItem).getLabel());
                            final int data = ((AutoMenuItem)autoMenuItem).getData();
                            menuItemTwo.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    MainJFrame.this.menuItemAction(data, MainJFrame.this.protocol);
                                }
                            });
                            autoMenuOne.add(menuItemTwo);
                        } else {
                            autoMenuItem = new AAJMenu();
                            ((AAJMenu)autoMenuItem).setText(autoMenuTwoList.get(j).getItem().getLabel());
                            int k = 0;
                            while (k < items.size()) {
                                AAJMenuItem menuItemThree = new AAJMenuItem();
                                menuItemThree.setText(items.get(k).getLabel());
                                final int data = items.get(k).getData();
                                menuItemThree.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        MainJFrame.this.menuItemAction(data, MainJFrame.this.protocol);
                                    }
                                });
                                ((JMenu)autoMenuItem).add(menuItemThree);
                                ++k;
                            }
                            autoMenuOne.add((JMenuItem)autoMenuItem);
                        }
                        ++j;
                    }
                    this.menuBar.add(autoMenuOne);
                    ++i;
                }
            } else if (this.menuBar != null && this.currProcesser == null && mainFrame == null) {
                this.protocol = new P30();
                this.currProcesser = GlobalProcessors.getCurrentProcessor();
                if (this.currProcesser != null) {
                    this.protocol = this.currProcesser.getProtocol();
                }
                if (this.protocol == null) {
                    this.protocol = new P30();
                }
                AutoMenuList autoMenuList = this.protocol.getMenuList();
                List<AutoMenuOne> autoMenuOneList = autoMenuList.getMenuList();
                int i = 0;
                while (i < autoMenuOneList.size()) {
                    List<AutoMenuTwo> autoMenuTwoList = autoMenuOneList.get(i).getItems();
                    String label = autoMenuOneList.get(i).getLabel();
                    AAJMenu autoMenuOne = new AAJMenu();
                    autoMenuOne.setText(label);
                    int j = 0;
                    while (j < autoMenuTwoList.size()) {
                        Object autoMenuItem;
                        List<AutoMenuItem> items = autoMenuTwoList.get(j).getItems();
                        if (items == null) {
                            autoMenuItem = autoMenuTwoList.get(j).getItem();
                            AAJMenuItem menuItemTwo = new AAJMenuItem();
                            menuItemTwo.setText(((AutoMenuItem)autoMenuItem).getLabel());
                            final int data = ((AutoMenuItem)autoMenuItem).getData();
                            menuItemTwo.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    MainJFrame.this.menuItemAction(data, MainJFrame.this.protocol);
                                }
                            });
                            autoMenuOne.add(menuItemTwo);
                        } else {
                            autoMenuItem = new AAJMenu();
                            ((AAJMenu)autoMenuItem).setText(autoMenuTwoList.get(j).getItem().getLabel());
                            int k = 0;
                            while (k < items.size()) {
                                AAJMenuItem menuItemThree = new AAJMenuItem();
                                menuItemThree.setText(items.get(k).getLabel());
                                final int data = items.get(k).getData();
                                menuItemThree.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        MainJFrame.this.menuItemAction(data, MainJFrame.this.protocol);
                                    }
                                });
                                ((JMenu)autoMenuItem).add(menuItemThree);
                                ++k;
                            }
                            autoMenuOne.add((JMenuItem)autoMenuItem);
                        }
                        ++j;
                    }
                    this.menuBar.add(autoMenuOne);
                    ++i;
                }
            }
        }
    }

    private void menuItemAction(int data, IProtocol protocol) {
        switch (data) {
            case 101: {
                new BasicJDialog((Frame)mainFrame, true);
                break;
            }
            case 102: {
                new PasswordJDialog((Frame)mainFrame, true);
                break;
            }
            case 103: {
                new PriceJDialog((Frame)mainFrame, true);
                break;
            }
            case 104: {
                new SMSSetting((Frame)mainFrame, true);
                break;
            }
            case 105: {
                new EmailSetting((Frame)mainFrame, true);
                break;
            }
            case 106: {
                new EventActionDialog((Frame)mainFrame, true);
                break;
            }
            case 107: {
                new COMSetJDialog((Frame)mainFrame, true);
                break;
            }
            case 108: {
                new ModbusSerialSetting((Frame)mainFrame, true);
                break;
            }
            case 201: {
                new ParameterJDialog((Frame)mainFrame, true);
                break;
            }
            case 202: {
                new RestoreJDialog((Frame)mainFrame, true);
                break;
            }
            case 203: {
                break;
            }
            case 204: {
                new RealControlJDialog30((Frame)mainFrame, true);
                break;
            }
            case 301: {
                break;
            }
            case 302: {
                new HistoryDataJDialog((Frame)mainFrame, true);
                break;
            }
            case 303: {
                new HistoryFaultDataDialog((Frame)mainFrame, true);
                break;
            }
            case 304: {
                new HistoryEventDialog((Frame)mainFrame, true);
                break;
            }
            case 305: {
                new MonitoredInfoJDialog((Frame)mainFrame, true);
                break;
            }
            case 401: {
                I18NBundle.changeUS();
                this.updateLanguage("en_US");
                break;
            }
            case 402: {
                I18NBundle.changeFR();
                this.updateLanguage("fr_FR");
                break;
            }
            case 403: {
                I18NBundle.changeDE();
                this.updateLanguage("de_DE");
                break;
            }
            case 404: {
                I18NBundle.changeIT();
                this.updateLanguage("it_IT");
                break;
            }
            case 405: {
                I18NBundle.changePL();
                this.updateLanguage("pl_PL");
                break;
            }
            case 406: {
                I18NBundle.changePT();
                this.updateLanguage("pt_PT");
                break;
            }
            case 407: {
                I18NBundle.changeRUS();
                this.updateLanguage("ru_RU");
                break;
            }
            case 408: {
                I18NBundle.changeSP();
                this.updateLanguage("es_ES");
                break;
            }
            case 409: {
                I18NBundle.changeUKR();
                this.updateLanguage("uk_UA");
                break;
            }
            case 410: {
                I18NBundle.changeTUR();
                this.updateLanguage("tr_TR");
                break;
            }
            case 411: {
                I18NBundle.changeCN();
                this.updateLanguage("zh_CN");
                break;
            }
            case 412: {
                I18NBundle.changeTW();
                this.updateLanguage("zh_TW");
                break;
            }
            case 501: {
                new AboutJDialog((Frame)mainFrame, true);
                break;
            }
            case 502: {
                this.openURL(String.valueOf(System.getProperty("user.dir")) + File.separator + "help" + File.separator + "P30");
                break;
            }
            case 5021: {
                this.openURL(String.valueOf(System.getProperty("user.dir")) + File.separator + "help" + File.separator + "P30");
                break;
            }
            case 5022: {
                this.openURL(String.valueOf(System.getProperty("user.dir")) + File.separator + "help" + File.separator + "P30");
                break;
            }
            case 5023: {
                this.openURL(String.valueOf(System.getProperty("user.dir")) + File.separator + "help" + File.separator + "P30");
                break;
            }
        }
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.northPanel = new JPanel();
        this.statusButton = new AAButtonTip();
        this.parameterButton = new AAButtonTip();
        this.dataButton = new AAButtonTip();
        this.eventButton = new AAButtonTip();
        this.faultButton = new AAButtonTip();
        loginButton = new AAButtonTip();
        loginLabel = new AALabel();
        this.monitoredLabelC = new AALabel();
        this.monitoredLabelV = new AALabel();
        this.centerPanel = new JPanel();
        this.jSplitPane = new JSplitPane();
        this.leftScrollPane = new JScrollPane();
        this.treeScrollPane = new JScrollPane();
        this.treePanel = new JPanel();
        this.logoLabel = new JLabel();
        this.changePanel = new JPanel();
        this.statusPanel = new StatusPanel();
        deviceTree = new VPTree();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                mainFrame.setVisible(false);
            }
        });
        this.mainPanel.setLayout(new BorderLayout());
        this.statusButton.setIcon(new ImageIcon(Constants.STATUSIMG));
        this.statusButton.setToolTipText("message.baseSet");
        this.statusButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new BasicJDialog((Frame)mainFrame, true);
            }
        });
        this.parameterButton.setIcon(new ImageIcon(Constants.PARAMETERIMG));
        this.parameterButton.setToolTipText("message.parametersSetting");
        this.parameterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new ParameterJDialog((Frame)mainFrame, true);
            }
        });
        this.dataButton.setIcon(new ImageIcon(Constants.DATAIMG));
        this.dataButton.setToolTipText("message.queryData");
        this.dataButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new HistoryDataJDialog((Frame)mainFrame, true);
            }
        });
        this.eventButton.setIcon(new ImageIcon(Constants.EVENTIMG));
        this.eventButton.setToolTipText("message.queryEvent");
        this.eventButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new HistoryEventDialog((Frame)mainFrame, true);
            }
        });
        this.faultButton.setIcon(new ImageIcon(Constants.FAULTIMG));
        this.faultButton.setToolTipText("message.queryFaultData");
        this.faultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new HistoryFaultDataDialog((Frame)mainFrame, true);
            }
        });
        if (SolarPowerTray.isLogin) {
            loginButton.setIcon(new ImageIcon(Constants.LOGOUTIMG));
            loginButton.setToolTipText("message.logout");
            loginLabel.setText("message.localManager");
        } else {
            loginButton.setIcon(new ImageIcon(Constants.LOGINIMG));
            loginButton.setToolTipText("message.login");
            loginLabel.setText("message.observer");
        }
        loginButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SolarPowerTray.isLogin) {
                    new LoginJDialog((Frame)mainFrame, true);
                } else {
                    int result = DisplayMessage.showConfirmDialog("message.asklogout", "message.logout");
                    if (result == 0) {
                        SolarPowerTray.isLogin = false;
                        loginButton.setIcon(new ImageIcon(Constants.LOGINIMG));
                        loginButton.setToolTipText("message.login");
                        loginLabel.setText("message.observer");
                    }
                }
            }
        });
        this.monitoredLabelC.setText("message.currentMonitor[:]");
        this.monitoredLabelV.setText("---");
        this.northPanel.setBorder(BorderFactory.createEtchedBorder());
        GroupLayout northPanelLayout = new GroupLayout(this.northPanel);
        this.northPanel.setLayout(northPanelLayout);
        northPanelLayout.setHorizontalGroup(northPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(northPanelLayout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.statusButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.parameterButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dataButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.eventButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(loginButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(loginLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.monitoredLabelC).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.monitoredLabelV).addContainerGap(56, Short.MAX_VALUE)));
        northPanelLayout.setVerticalGroup(northPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.statusButton).addComponent(this.parameterButton).addComponent(this.dataButton).addComponent(this.eventButton).addComponent(loginButton).addGroup(northPanelLayout.createSequentialGroup().addGap(18, 18, 18).addGroup(northPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(loginLabel).addComponent(this.monitoredLabelC).addComponent(this.monitoredLabelV))));
        this.mainPanel.add((Component)this.northPanel, "North");
        this.centerPanel.setLayout(new BorderLayout());
        deviceTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                block9: {
                    if (e.getClickCount() == 2) {
                        try {
                            DefaultMutableTreeNode selectionNode = (DefaultMutableTreeNode)deviceTree.getLastSelectedPathComponent();
                            if (selectionNode.isRoot() || !selectionNode.isLeaf()) break block9;
                            Object selectionObj = selectionNode.getUserObject();
                            String itemString = selectionObj.toString();
                            try {
                                String[] attrs = itemString.split("_");
                                String device = MainJFrame.this.deviceDao.queryDevice(attrs[1]);
                                if (device != null && !device.equals("")) {
                                    AbstractProcessor processor = GlobalProcessors.getProcessorBySerial(device);
                                    itemString = processor.processorKey();
                                }
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                            GlobalProcessors.setCurrentProcesserIfExist(itemString);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    } else if (e.getButton() == 3) {
                        TreePath path = deviceTree.getPathForLocation(e.getX(), e.getY());
                        if (path == null) {
                            return;
                        }
                        deviceTree.setSelectionPath(path);
                        deviceTree.getPopMenu().show(deviceTree, e.getX() + 1, e.getY());
                    }
                }
            }
        });
        this.treePanel.setLayout(new BorderLayout());
        this.treeScrollPane.setViewportView(deviceTree);
        this.treePanel.add((Component)this.treeScrollPane, "Center");
        ImageIcon icon = null;
        try {
            icon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Constants.CUSTOMERIMAGES_PATH) + GlobalVariables.customerConfig.getCustomerLogo()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (icon != null) {
            this.logoLabel.setIcon(icon);
        }
        this.treePanel.add((Component)this.logoLabel, "South");
        this.leftScrollPane.setViewportView(this.treePanel);
        this.jSplitPane.setLeftComponent(this.leftScrollPane);
        this.changePanel.setLayout(new BorderLayout());
        this.changePanel.add((Component)this.statusPanel, "Center");
        this.jSplitPane.setRightComponent(this.changePanel);
        this.jSplitPane.setDividerLocation(250);
        this.centerPanel.add((Component)this.jSplitPane, "Center");
        this.mainPanel.add((Component)this.centerPanel, "Center");
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.pack();
    }

    private void openURL(String url) {
        block16: {
            try {
                File file1 = new File(String.valueOf(url) + ".swf");
                File file2 = new File(String.valueOf(url) + ".pdf");
                File file3 = new File(String.valueOf(url) + ".doc");
                if (file1.exists()) {
                    if (Constants.IS_OS_WINDOWS) {
                        Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + file1);
                    } else {
                        Runtime.getRuntime().exec(file1.getAbsolutePath());
                    }
                    break block16;
                }
                if (file2.exists()) {
                    if (Constants.IS_OS_WINDOWS) {
                        Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + file2);
                        break block16;
                    }
                    if (Constants.IS_OS_LINUX) {
                        Runtime.getRuntime().exec("chmod 777 " + url + ".pdf");
                        Runtime.getRuntime().exec("evince " + url + ".pdf");
                        break block16;
                    }
                    if (Constants.IS_OS_SOLARIS) {
                        Runtime.getRuntime().exec("chmod 777 " + url + ".pdf");
                        Runtime.getRuntime().exec("gpdf " + url + ".pdf");
                        break block16;
                    }
                    if (Constants.IS_OS_MAC || Constants.IS_OS_MAC_OSX) {
                        try {
                            Runtime.getRuntime().exec("chmod 777 " + url + ".pdf");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        Runtime.getRuntime().exec("open " + url + ".pdf");
                        break block16;
                    }
                    Runtime.getRuntime().exec(file2.getAbsolutePath());
                    break block16;
                }
                if (file3.exists()) {
                    if (Constants.IS_OS_WINDOWS) {
                        Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + file3);
                    } else {
                        Runtime.getRuntime().exec(file3.getAbsolutePath());
                    }
                } else {
                    DisplayMessage.showErrorDialog("File is missing!");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                DisplayMessage.showErrorDialog("Please install the PDF reader.");
            }
        }
    }

    private void updateLanguage(String language) {
        try {
            GlobalVariables.properties.setProperty("GLOBAL_CONFIG", "Language", language);
            GlobalVariables.properties.store();
            ConfigureTools.wrapProperties(GlobalVariables.globalConfig);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void refreshDeviceTree() {
        List<String> devices = GlobalProcessors.getSolarList();
        deviceTree.refreshTree(devices);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                deviceTree.updateUI();
            }
        });
    }

    public void refreshWorkInfo() {
        AbstractProcessor processer = GlobalProcessors.getCurrentProcessor();
        MachineInfo machineInfo = null;
        WorkInfo workInfo = null;
        if (processer != null) {
            machineInfo = (MachineInfo)processer.getBeanBag().getBean("machineinfo");
            workInfo = (WorkInfo)processer.getBeanBag().getBean("workinfo");
        }
        if (machineInfo == null) {
            machineInfo = new MachineInfo();
        }
        if (workInfo == null) {
            workInfo = new WorkInfo();
        }
        this.refreshWorkInfo(workInfo);
        this.refreshReal(workInfo);
        this.refreshMachineInfo(machineInfo);
    }

    public void refreshWorkInfo(WorkInfo workInfo) {
        block15: {
            try {
                try {
                    this.fairlock.lock();
                    this.currProcesser = GlobalProcessors.getCurrentProcessor();
                    if (this.currProcesser != null) {
                        BasePanel basePanel;
                        IProtocol protocol = this.currProcesser.getProtocol();
                        if (!(protocol.getDelayChanging() || this.oldProtocol.getProtocolID().equals(protocol.getProtocolID()) && protocol.getOutputMode() == this.oldProtocol.getOutputMode())) {
                            JPanel ratingPanel;
                            if (this.statusPanel.basePanel != null) {
                                this.statusPanel.baseJSPanel.remove(this.statusPanel.basePanel);
                                this.statusPanel.basePanel = null;
                            }
                            this.statusPanel.basePanel = basePanel = new BasePanel();
                            this.statusPanel.baseJSPanel.setViewportView(this.statusPanel.basePanel);
                            if (!this.oldProtocol.getProtocolID().equals(protocol.getProtocolID())) {
                                this.initMenu();
                            }
                            if (this.statusPanel.productPanel != null) {
                                this.statusPanel.centerPanel.remove(this.statusPanel.productPanel);
                                this.statusPanel.productPanel = null;
                            }
                            JPanel productPanel = new JPanel();
                            productPanel.setPreferredSize(new Dimension(420, 200));
                            this.statusPanel.productPanel = productPanel;
                            this.statusPanel.centerPanel.add((Component)this.statusPanel.productPanel, "West");
                            this.statusPanel.getProductInfo(protocol);
                            if (this.statusPanel.ratingPanel != null) {
                                this.statusPanel.centerPanel.remove(this.statusPanel.ratingPanel);
                                this.statusPanel.ratingPanel = null;
                            }
                            this.statusPanel.ratingPanel = ratingPanel = new JPanel();
                            this.statusPanel.centerPanel.add((Component)this.statusPanel.ratingPanel, "Center");
                            this.statusPanel.getRatingInfo(protocol);
                            this.oldProtocol = protocol;
                        }
                        if (this.statusPanel.basePanel != null) {
                            this.statusPanel.basePanel.refreshWorkInfo(workInfo);
                            if (this.needToRefreshDependsOnPvCharging(workInfo.getIsPVCharging()) || this.needToRefreshDependsOnDevice(workInfo.getIsShowChargingCurrent())) {
                                this.statusPanel.baseJSPanel.remove(this.statusPanel.basePanel);
                                this.statusPanel.basePanel = null;
                                this.statusPanel.basePanel = basePanel = new BasePanel();
                                this.statusPanel.baseJSPanel.setViewportView(this.statusPanel.basePanel);
                            }
                        }
                    }
                    if (this.currProcesser != null) {
                        String deviceName = this.currProcesser.getDeviceName();
                        String serailNo = this.currProcesser.getSerialNo();
                        if (deviceName != null && !"".equals(deviceName) && serailNo != null && !"".equals(serailNo)) {
                            this.monitoredLabelV.setTextWithoutI18N(String.valueOf(deviceName) + "_" + serailNo);
                        }
                        break block15;
                    }
                    this.monitoredLabelV.setText("---");
                }
                catch (Exception e) {
                    e.getMessage();
                    this.fairlock.unlock();
                }
            }
            finally {
                this.fairlock.unlock();
            }
        }
    }

    public void refreshReal(WorkInfo workInfo) {
        this.statusPanel.realPanel.refreshWork(workInfo);
    }

    public void refreshMachineInfo(MachineInfo machineInfo) {
        this.statusPanel.refreshMachineInfo(machineInfo);
    }

    public void setDefaultValues() {
        BasePanel basePanel;
        this.oldProtocol = new P30();
        this.initMenu();
        this.statusPanel.setDefaultValues();
        this.statusPanel.baseJSPanel.remove(this.statusPanel.basePanel);
        this.statusPanel.basePanel = null;
        this.statusPanel.basePanel = basePanel = new BasePanel();
        this.statusPanel.baseJSPanel.setViewportView(this.statusPanel.basePanel);
        this.monitoredLabelV.setText("---");
        this.statusPanel.realPanel.setDefaultValues();
        this.statusPanel.basePanel.setDefaultValues();
    }

    private boolean needToRefreshDependsOnPvCharging(int pvCharging) {
        if (isPVCharging == pvCharging) {
            return false;
        }
        isPVCharging = pvCharging;
        return true;
    }

    private boolean needToRefreshDependsOnDevice(int showChargingCurrent) {
        if (isShowChargingCurrent == showChargingCurrent) {
            return false;
        }
        isShowChargingCurrent = showChargingCurrent;
        return true;
    }
}

