/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.view;

import cn.com.voltronic.solar.dao.ModbusDao;
import cn.com.voltronic.solar.data.bean.ModbusSet;
import cn.com.voltronic.solar.view.component.AAButton;
import cn.com.voltronic.solar.view.component.AAComboBox;
import cn.com.voltronic.solar.view.component.AADialog;
import cn.com.voltronic.solar.view.component.AALabel;
import cn.com.voltronic.solar.view.component.AAPanel;
import cn.com.voltronic.solar.view.component.CheckBoxData;
import cn.com.voltronic.solar.view.component.DisplayMessage;
import cn.com.voltronic.solar.view.component.JComboCheckBox;
import gnu.io.CommPortIdentifier;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.LayoutStyle;

public class ModbusSerialSetting
extends AADialog {
    private static final long serialVersionUID = 1L;
    private static ModbusDao modbusdao = new ModbusDao();
    private AAButton applyBtn;
    private AAButton close;
    private AALabel baudRate;
    private AAComboBox baudrateCB;
    private AALabel databit;
    private AAComboBox databitCB;
    private AALabel deviceid;
    private JComboCheckBox deviceidCB;
    private AAPanel mainPanel;
    private AALabel modbusPort;
    private AAComboBox modubsPortCB;
    private AALabel parity;
    private AAComboBox parityCB;
    private AAButton refreshBtn;
    private AALabel stopbit;
    private AAComboBox stopbitCB;
    private List<String> ports;

    public ModbusSerialSetting(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.initModubsSet();
        this.setTitle(bd.getString("message.modbussetting"));
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void initComponents() {
        this.mainPanel = new AAPanel();
        this.modbusPort = new AALabel();
        this.deviceid = new AALabel();
        this.baudRate = new AALabel();
        this.databit = new AALabel();
        this.stopbit = new AALabel();
        this.parity = new AALabel();
        this.modubsPortCB = new AAComboBox();
        this.deviceidCB = new JComboCheckBox();
        this.baudrateCB = new AAComboBox();
        this.databitCB = new AAComboBox();
        this.stopbitCB = new AAComboBox();
        this.parityCB = new AAComboBox();
        this.refreshBtn = new AAButton();
        this.applyBtn = new AAButton();
        this.close = new AAButton();
        this.setDefaultCloseOperation(2);
        this.modbusPort.setText("message.modbusport");
        this.deviceid.setText("message.deviceid");
        this.baudRate.setText("message.baudrate");
        this.databit.setText("message.databit");
        this.stopbit.setText("message.stopbit");
        this.parity.setText("message.parity");
        this.refreshBtn.setText("message.refresh");
        this.applyBtn.setText("message.apply");
        this.close.setText("message.close");
        this.ports = this.getPorts();
        this.modubsPortCB.setModel(new DefaultComboBoxModel<Object>(this.ports.toArray()));
        this.modubsPortCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ModbusSerialSetting.this.modubsPortCBItemStateChanged(evt);
            }
        });
        ArrayList<CheckBoxData> items = new ArrayList<CheckBoxData>();
        int i = 1;
        while (i < 248) {
            CheckBoxData data = new CheckBoxData(String.valueOf(i), false, true);
            items.add(data);
            ++i;
        }
        this.deviceidCB.addItems(items);
        this.baudrateCB.setModel(new DefaultComboBoxModel<String>(new String[]{"1200", "2400", "4800", "9600", "19200"}));
        this.databitCB.setModel(new DefaultComboBoxModel<String>(new String[]{"7", "8"}));
        this.stopbitCB.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2"}));
        this.parityCB.setModel(new DefaultComboBoxModel<String>(new String[]{"NONE", "ODD", "EVEN"}));
        this.refreshBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModbusSerialSetting.this.refreshBtnActionPerformed(evt);
            }
        });
        this.applyBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModbusSerialSetting.this.applyBtnActionPerformed(evt);
            }
        });
        this.close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModbusSerialSetting.this.closeActionPerformed(evt);
            }
        });
        this.viewLayout();
    }

    private void viewLayout() {
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.modbusPort)).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.deviceid)).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.baudRate)).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.databit)).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.stopbit)).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.parity))).addGap(18, 18, 18).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.parityCB, 0, 133, Short.MAX_VALUE).addComponent(this.deviceidCB, 0, 133, Short.MAX_VALUE).addComponent(this.modubsPortCB, 0, 133, Short.MAX_VALUE).addComponent(this.baudrateCB, 0, 133, Short.MAX_VALUE).addComponent(this.databitCB, 0, 133, Short.MAX_VALUE).addComponent(this.stopbitCB, 0, 133, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.close, -1, -1, Short.MAX_VALUE).addComponent(this.applyBtn, -1, -1, Short.MAX_VALUE).addComponent(this.refreshBtn, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.refreshBtn).addComponent(this.modbusPort).addComponent(this.modubsPortCB, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.deviceid).addComponent(this.deviceidCB, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.close).addComponent(this.baudRate).addComponent(this.baudrateCB, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.databit).addComponent(this.databitCB, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.stopbit).addComponent(this.stopbitCB, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.parity).addComponent(this.parityCB, -2, -1, -2))).addComponent(this.applyBtn)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.mainPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.mainPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    public List<String> getPorts() {
        ArrayList<String> ports = new ArrayList<String>();
        Enumeration portEn = CommPortIdentifier.getPortIdentifiers();
        while (portEn.hasMoreElements()) {
            CommPortIdentifier portId = (CommPortIdentifier)portEn.nextElement();
            if (portId.getPortType() != 1 || ports.contains(portId.getName())) continue;
            ports.add(portId.getName());
        }
        return ports;
    }

    public void modubsPortCBItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() != 1) {
            return;
        }
        this.initModubsSet();
    }

    private void initModubsSet() {
        String portName = (String)this.modubsPortCB.getSelectedItem();
        ModbusSet modbus = modbusdao.queryModbusSetByPort(portName);
        if (modbus == null) {
            List<CheckBoxData> items = this.deviceidCB.getCheckBoxDatas();
            for (CheckBoxData checkbox : items) {
                checkbox.setSelected(false);
            }
            this.deviceidCB.removeAllItems();
            this.deviceidCB.addItems(items);
            this.baudrateCB.setSelectedIndex(4);
            this.databitCB.setSelectedIndex(1);
            this.stopbitCB.setSelectedIndex(0);
            this.parityCB.setSelectedIndex(0);
            return;
        }
        String[] deviceids = modbus.getDeviceIds().split(",");
        Map deviceMap = this.deviceidMap(deviceids);
        List<CheckBoxData> items = this.deviceidCB.getCheckBoxDatas();
        for (CheckBoxData checkbox : items) {
            if (this.isFoundInMap(deviceMap, checkbox.getName())) {
                checkbox.setSelected(true);
                continue;
            }
            checkbox.setSelected(false);
        }
        this.deviceidCB.removeAllItems();
        this.deviceidCB.addItems(items);
        int baudRate = modbus.getBaudrate();
        int databit = modbus.getDataBit();
        int stopbit = modbus.getStopBit();
        int parity = modbus.getParity();
        if (baudRate == 1200) {
            this.baudrateCB.setSelectedIndex(0);
        } else if (baudRate == 2400) {
            this.baudrateCB.setSelectedIndex(1);
        } else if (baudRate == 4800) {
            this.baudrateCB.setSelectedIndex(2);
        } else if (baudRate == 9600) {
            this.baudrateCB.setSelectedIndex(3);
        } else if (baudRate == 19200) {
            this.baudrateCB.setSelectedIndex(4);
        }
        if (databit == 7) {
            this.databitCB.setSelectedIndex(0);
        } else if (databit == 8) {
            this.databitCB.setSelectedIndex(1);
        }
        if (stopbit == 1) {
            this.stopbitCB.setSelectedIndex(0);
        } else if (stopbit == 2) {
            this.stopbitCB.setSelectedIndex(1);
        }
        this.parityCB.setSelectedIndex(parity);
    }

    private Map deviceidMap(String[] deviceids) {
        HashMap<String, String> map = new HashMap<String, String>();
        String[] stringArray = deviceids;
        int n = deviceids.length;
        int n2 = 0;
        while (n2 < n) {
            String deviceid = stringArray[n2];
            map.put(deviceid, deviceid);
            ++n2;
        }
        return map;
    }

    private boolean isFoundInMap(Map map, String item) {
        return map.get(item) != null;
    }

    private void applyBtnActionPerformed(ActionEvent evt) {
        try {
            List<String> selecteds = this.deviceidCB.getCheckedLabels();
            String ids = "";
            for (String id : selecteds) {
                ids = String.valueOf(ids) + id + ",";
            }
            ModbusSet modbus = new ModbusSet();
            modbus.setDeviceIds(ids);
            modbus.setPortName((String)this.modubsPortCB.getSelectedItem());
            modbus.setBaudrate(Integer.valueOf((String)this.baudrateCB.getSelectedItem()));
            modbus.setDataBit(Integer.valueOf((String)this.databitCB.getSelectedItem()));
            modbus.setStopBit(Integer.valueOf((String)this.stopbitCB.getSelectedItem()));
            modbus.setParity(this.parityCB.getSelectedIndex());
            if (modbusdao.queryModbusSetByPort(modbus.getPortName()) == null) {
                modbusdao.addModbusSet(modbus);
            } else {
                modbusdao.updateModbusSet(modbus);
            }
        }
        catch (Exception e) {
            DisplayMessage.showErrorDialog("message.operationfailure");
        }
        DisplayMessage.showInfoDialog("message.OperationSuccess");
    }

    private void refreshBtnActionPerformed(ActionEvent evt) {
        this.ports = this.getPorts();
        this.modubsPortCB.setModel(new DefaultComboBoxModel<Object>(this.ports.toArray()));
        this.initModubsSet();
    }

    private void closeActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

