/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.view.component;

import cn.com.voltronic.solar.dao.DeviceDao;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.system.GlobalProcessors;
import cn.com.voltronic.solar.view.MainJFrame;
import cn.com.voltronic.solar.view.component.AAJMenuItem;
import cn.com.voltronic.solar.view.component.MyCellNodeRenderer;
import cn.com.voltronic.solar.view.component.MyDefaultTreeModel;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class VPTree
extends JTree {
    private static final long serialVersionUID = 9199814511565358313L;
    private JPopupMenu popMenu;
    private AAJMenuItem editItem;
    private AAJMenuItem restoreItem;
    private AAJMenuItem restoreAllItem;
    private DeviceDao deviceDao = new DeviceDao();

    public VPTree() {
        this.initComponents();
        this.setBackground(new Color(102, 102, 102));
        this.setForeground(new Color(102, 102, 102));
        this.setEditable(true);
        this.initPopupMenu();
    }

    private void initComponents() {
        ArrayList<String> devices = new ArrayList<String>();
        this.refreshTree(devices);
    }

    private void initPopupMenu() {
        this.editItem = new AAJMenuItem("message.treeRename");
        this.editItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePath selected = VPTree.this.getSelectionPath();
                if (selected != null) {
                    VPTree.this.startEditingAtPath(selected);
                }
            }
        });
        this.restoreItem = new AAJMenuItem("message.treeRestore");
        this.restoreItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultMutableTreeNode selectionNode = (DefaultMutableTreeNode)VPTree.this.getLastSelectedPathComponent();
                Object selectionObj = selectionNode.getUserObject();
                String alias = selectionObj.toString();
                String[] attrs = alias.split("_");
                VPTree.this.deviceDao.deleteDeviceAlias(attrs[1]);
                MainJFrame.getNewInstance().refreshDeviceTree();
            }
        });
        this.restoreAllItem = new AAJMenuItem("message.treeRestoreAll");
        this.restoreAllItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VPTree.this.deviceDao.deleteDeviceAlias();
                MainJFrame.getNewInstance().refreshDeviceTree();
            }
        });
        this.popMenu = new JPopupMenu();
        this.popMenu.add(this.editItem);
        this.popMenu.add(this.restoreItem);
        this.popMenu.add(this.restoreAllItem);
    }

    public void refreshTree(List<String> devices) {
        String computerName = "Computer";
        try {
            InetAddress ip = InetAddress.getLocalHost();
            computerName = ip.getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        DefaultMutableTreeNode treeNode0 = new DefaultMutableTreeNode(computerName);
        int i = 0;
        while (i < devices.size()) {
            AbstractProcessor processor;
            String serials;
            String device = devices.get(i);
            String[] attrs = device.split("_");
            if (attrs.length >= 2 && !(serials = this.deviceDao.queryAlias(attrs[1])).equals("") && (processor = GlobalProcessors.getProcessorByDeviceName(device)) != null) {
                String processorKey;
                device = processorKey = processor.processorKeyAlias(serials);
            }
            DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(device);
            treeNode0.add(treeNode);
            ++i;
        }
        this.setModel(new MyDefaultTreeModel(treeNode0));
        MyCellNodeRenderer renderer = new MyCellNodeRenderer();
        renderer.setBackgroundNonSelectionColor(new Color(102, 102, 102));
        renderer.setBackgroundSelectionColor(new Color(250, 250, 250));
        renderer.setTextNonSelectionColor(new Color(250, 250, 250));
        renderer.setTextSelectionColor(new Color(0, 0, 0));
        this.setCellRenderer(renderer);
    }

    public JPopupMenu getPopMenu() {
        return this.popMenu;
    }

    public void setPopMenu(JPopupMenu popMenu) {
        this.popMenu = popMenu;
    }

    public JMenuItem getEditItem() {
        return this.editItem;
    }

    public void setEditItem(AAJMenuItem editItem) {
        this.editItem = editItem;
    }
}

