/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.work;

import cn.com.voltronic.solar.communicate.IComUSBHandler;
import cn.com.voltronic.solar.communicate.ModbusHandler;
import cn.com.voltronic.solar.communicate.ModbusHandlerMaster;
import cn.com.voltronic.solar.communicate.SNMPHandler;
import cn.com.voltronic.solar.communicate.SerialHandler;
import cn.com.voltronic.solar.communicate.SerialHandlerSolaris;
import cn.com.voltronic.solar.communicate.USBHandler;
import cn.com.voltronic.solar.configure.SystemEnv;
import cn.com.voltronic.solar.dao.SnmpMgrDao;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.snmp4j.SNMPConfig;
import cn.com.voltronic.solar.snmp4j.SearchSnmpCard;
import cn.com.voltronic.solar.snmp4j.SnmpTrap;
import cn.com.voltronic.solar.socket.UdpClient;
import cn.com.voltronic.solar.system.GlobalProcessors;
import cn.com.voltronic.solar.system.GlobalVariables;
import cn.com.voltronic.solar.system.ProcessorCategories;
import gnu.io.CommPortIdentifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import usb.IUSBComm;
import usb.MacUSBRemote;
import usb.USBCommEx;

public class SearchDevice
extends Thread {
    protected static final Logger logger = Logger.getLogger(SearchDevice.class);
    private IUSBComm usbComm;
    private static volatile SearchSnmpCard searchSnmpIP = null;
    private int currentLinkCount;
    private int oldLinkCount;
    private static final int MAX_WAIT_TIME = 4000;
    private static final int MID_WAIT_TIME = 1000;
    private static final int MIN_WAIT_TIME = 500;
    private Vector<AbstractProcessor> templist = new Vector();
    public static SnmpTrap trap = null;
    private SnmpMgrDao snmpMgrDao = new SnmpMgrDao();

    public SearchDevice() {
        if (SystemUtils.IS_OS_MAC_OSX) {
            MacUSBRemote macusbdriver = new MacUSBRemote();
            this.usbComm = macusbdriver;
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        } else if (SystemUtils.IS_OS_WINDOWS || SystemUtils.IS_OS_LINUX || SystemUtils.IS_OS_SOLARIS) {
            USBCommEx usbdriver = new USBCommEx();
            this.usbComm = usbdriver;
        } else {
            USBCommEx usbdriver = new USBCommEx();
            this.usbComm = usbdriver;
        }
    }

    @Override
    public void run() {
        SearchComDevice com = new SearchComDevice();
        com.start();
        if (GlobalVariables.globalConfig.isUseUSB()) {
            SearchUsbDevice usb = new SearchUsbDevice();
            usb.start();
        }
        if (GlobalVariables.globalConfig.isUseSNMP()) {
            if (searchSnmpIP == null) {
                searchSnmpIP = new SearchSnmpCard();
                searchSnmpIP.start();
                trap = new SnmpTrap();
                trap.run();
            }
            SearchSnmpDevice snmp = new SearchSnmpDevice();
            snmp.start();
        }
    }

    public synchronized void sendToTray() {
        int status = this.getLinkCount();
        UdpClient udpClient = null;
        if (status == 1) {
            try {
                try {
                    String port = "38694";
                    try {
                        port = GlobalVariables.globalConfig.getUdpPort();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (port != null && !"".equals(port)) {
                        udpClient = new UdpClient("localhost", port);
                        udpClient.send("(PVCount:" + this.currentLinkCount);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (udpClient != null) {
                        udpClient.disconnect();
                    }
                }
            }
            finally {
                if (udpClient != null) {
                    udpClient.disconnect();
                }
            }
        }
    }

    public int getLinkCount() {
        this.currentLinkCount = GlobalProcessors.getProcesserSize();
        if (this.oldLinkCount != this.currentLinkCount) {
            this.oldLinkCount = this.currentLinkCount;
            return 1;
        }
        return -1;
    }

    public void searchLocalComs() {
        Enumeration portEn = CommPortIdentifier.getPortIdentifiers();
        while (portEn.hasMoreElements()) {
            CommPortIdentifier portId = (CommPortIdentifier)portEn.nextElement();
            if (portId.getPortType() != 1) continue;
            Object handler = GlobalProcessors.getUsedHandlerbyName(portId.getName());
            if (GlobalVariables.globalConfig.isUseCOM() && !GlobalProcessors.getSMSCom().equalsIgnoreCase(portId.getName().trim()) && !GlobalProcessors.getExcludeComs().contains(portId.getName()) && handler == null) {
                try {
                    this.searchSerialPort(portId);
                    handler = GlobalProcessors.getUsedHandlerbyName(portId.getName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!GlobalVariables.globalConfig.isUseModbus() || GlobalProcessors.getExcludeComs().contains(portId.getName()) || !ModbusHandlerMaster.isUseCom(portId)) continue;
            if (handler == null) {
                this.searchModbus(portId);
                continue;
            }
            if (!(handler instanceof ModbusHandler)) continue;
            this.searchModbus(((ModbusHandler)handler).getMaster());
        }
    }

    private void searchSerialPort(CommPortIdentifier portId) throws Exception {
        IComUSBHandler handler = null;
        handler = SystemUtils.IS_OS_SOLARIS || SystemUtils.IS_OS_SUN_OS ? new SerialHandlerSolaris(portId) : new SerialHandler(portId);
        AbstractProcessor processor = ProcessorCategories.getSerialMonitor(handler);
        if (processor != null) {
            processor.setDeviceName(handler.getDeviceName());
            this.doProcessor(processor);
        } else {
            handler.close();
        }
        this.startMonitor(1000L);
    }

    public void searchLocalUsb() {
        String usbDevices = this.usbComm.findUSBDevices();
        String[] devices = usbDevices.split("#");
        if (devices != null && devices.length > 0) {
            String[] stringArray = devices;
            int n = devices.length;
            int n2 = 0;
            while (n2 < n) {
                String usbId = stringArray[n2];
                Object existhandler = GlobalProcessors.getUsedHandlerbyName("USB" + usbId);
                if (existhandler == null) {
                    USBHandler handler = new USBHandler(this.usbComm, usbId);
                    AbstractProcessor processor = ProcessorCategories.getUsbMonitor(handler);
                    if (processor != null) {
                        processor.setDeviceName(handler.getDeviceName());
                        this.doProcessor(processor);
                    } else {
                        handler.close();
                    }
                    this.startMonitor(1000L);
                }
                ++n2;
            }
        }
    }

    private void searchModbus(CommPortIdentifier portId) {
        try {
            ModbusHandlerMaster handlerMaster = new ModbusHandlerMaster(portId);
            this.searchModbus(handlerMaster);
        }
        catch (Exception e) {
            System.err.println("search modbus error: " + e.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     */
    private void searchModbus(ModbusHandlerMaster handlerMaster) {
        handlerMaster.generateHandlers();
        handlers = handlerMaster.getHandlers();
        closeHandlers = new ArrayList<ModbusHandler>();
        previoushandlersize = oldActivehandlersize = handlerMaster.getActiveHandlesSize();
        scanNumber = allhandlesize = handlers.size();
        sleeptime = 0;
        scanCount = 0;
        this.setPriority(10);
        item = 0;
        while (item < allhandlesize) {
            block13: {
                block17: {
                    block16: {
                        block15: {
                            block14: {
                                if (SystemEnv.stopping) break;
                                handler = handlers.get(item);
                                if (handler == null || handler.isActive()) break block13;
                                if (!handler.isMustClose()) break block14;
                                closeHandlers.add(handler);
                                break block13;
                            }
                            if (oldActivehandlersize != 0) break block15;
                            scanNumber = allhandlesize;
                            sleeptime = 10;
                            ** GOTO lbl51
                        }
                        if (!handlerMaster.maybeLost()) break block16;
                        scanNumber = 1;
                        sleeptime = 4000;
                        ** GOTO lbl51
                    }
                    if (handlerMaster.getActiveHandlesSize() <= previoushandlersize) break block17;
                    previoushandlersize = handlerMaster.getActiveHandlesSize();
                    scanNumber = (allhandlesize - previoushandlersize) / 2;
                    if (scanNumber < 40) {
                        scanNumber = 40;
                    }
                    sleeptime = 500;
                    ** GOTO lbl51
                }
                if (oldActivehandlersize > 0 && handlerMaster.getActiveHandlesSize() == 0) {
                    closeHandlers.add(handler);
                } else {
                    if (allhandlesize > oldActivehandlersize * 4) {
                        if (oldActivehandlersize <= 20) {
                            scanNumber = 20;
                            sleeptime = 1000;
                        } else {
                            scanNumber = oldActivehandlersize;
                            sleeptime = 1000;
                        }
                    } else {
                        scanNumber = 10;
                        sleeptime = 500;
                    }
lbl51:
                    // 6 sources

                    processor = ProcessorCategories.getModbusMonitor(handler);
                    if (processor != null && !processor.isClosing() && handler != null) {
                        processor.setDeviceName(handler.getDeviceName());
                        handler.setActive(true);
                        this.doProcessor(processor);
                    } else if (handler != null) {
                        closeHandlers.add(handler);
                    }
                    if (++scanCount > scanNumber) {
                        this.startMonitor(sleeptime);
                        scanCount = 0;
                        previoushandlersize = oldActivehandlersize = handlerMaster.getActiveHandlesSize();
                    }
                }
            }
            ++item;
        }
        for (ModbusHandler item : closeHandlers) {
            if (item == null) continue;
            item.close();
        }
        this.startMonitor(1000L);
        this.setPriority(5);
    }

    private void searchSNMP() {
        List<String> ips = this.snmpMgrDao.qryips();
        for (String ip : ips) {
            if (GlobalProcessors.findProcessorByIPAddress(ip) != null) continue;
            SNMPConfig config = this.initSNMPConfig(ip);
            SNMPHandler handler = new SNMPHandler(ip, 161, config);
            AbstractProcessor processor = ProcessorCategories.getSnmpMonitor(handler);
            if (processor != null) {
                processor.setDeviceName(handler.getDeviceName());
                this.doProcessor(processor);
                continue;
            }
            handler.close();
        }
        this.startMonitor(1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doProcessor(AbstractProcessor processer) {
        Vector<AbstractProcessor> vector = this.templist;
        synchronized (vector) {
            if (GlobalProcessors.findProcessor(processer.processorKey()) == null) {
                GlobalProcessors.addProcessor(processer.processorKey(), processer);
                this.templist.add(processer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startMonitor(long sleeptime) {
        Vector<AbstractProcessor> vector = this.templist;
        synchronized (vector) {
            try {
                for (AbstractProcessor process : this.templist) {
                    try {
                        process.startMonitor();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.templist.clear();
                SearchDevice.sleep(sleeptime);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public SNMPConfig initSNMPConfig(String ip) {
        SNMPConfig config = new SNMPConfig();
        UdpClient client = null;
        try {
            client = new UdpClient(ip, "51220");
            client.send("get use snmpv3");
            String str = new String(client.receive()).trim();
            if (str == null || "".equals(str)) {
                return config;
            }
            if (str.equalsIgnoreCase("disable") || str.equalsIgnoreCase("Illegal command")) {
                config.setV3(false);
            } else {
                config.setV3(true);
                String[] arrStr = str.split(" ");
                if (arrStr[0].equalsIgnoreCase("0")) {
                    config.setEncrypt(false);
                } else {
                    config.setEncrypt(true);
                }
                if (arrStr[1].equalsIgnoreCase("0")) {
                    config.setProving(false);
                } else {
                    config.setProving(true);
                }
                config.setPassword("12345678");
            }
        }
        catch (Exception e) {
            logger.debug((Object)e.getMessage());
        }
        return config;
    }

    private class SearchComDevice
    extends Thread {
        private SearchComDevice() {
        }

        @Override
        public void run() {
            int time_i = 0;
            while (!SystemEnv.stopping) {
                if (time_i >= GlobalVariables.globalConfig.getDeviceSacanInterval()) {
                    SearchDevice.this.searchLocalComs();
                    time_i = 0;
                    SearchDevice.this.sendToTray();
                    continue;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                ++time_i;
            }
            ++SystemEnv.stoped;
        }
    }

    private class SearchSnmpDevice
    extends Thread {
        private SearchSnmpDevice() {
        }

        @Override
        public void run() {
            int time_i = 0;
            while (!SystemEnv.stopping) {
                if (time_i >= GlobalVariables.globalConfig.getDeviceSacanInterval()) {
                    SearchDevice.this.searchSNMP();
                    time_i = 0;
                    SearchDevice.this.sendToTray();
                    continue;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                ++time_i;
            }
            ++SystemEnv.stoped;
        }
    }

    private class SearchUsbDevice
    extends Thread {
        private SearchUsbDevice() {
        }

        @Override
        public void run() {
            int time_i = 0;
            while (!SystemEnv.stopping) {
                if (time_i >= GlobalVariables.globalConfig.getDeviceSacanInterval()) {
                    SearchDevice.this.searchLocalUsb();
                    time_i = 0;
                    SearchDevice.this.sendToTray();
                    continue;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                ++time_i;
            }
            ++SystemEnv.stoped;
        }
    }
}

